package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbtipdoc;

/**
 * ArbtipdocDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbtipdocDaoImpl implements ArbtipdocDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbtipdoc> rwMap = new RowMapper<Arbtipdoc>() {
		public Arbtipdoc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbtipdoc(resultSet.getString("TDID"),
					resultSet.getString("IDTIPODOC"),
					resultSet.getString("TDNOMBRE"),
					resultSet.getString("TDNOMBREE"),
					resultSet.getString("TDPCODIGO"),
					resultSet.getDate("TDFECALTA"),
					resultSet.getDate("TDFECMODIF"),
					resultSet.getString("TDUSUALTA"),
					resultSet.getString("TDUSUMODIF"),
					resultSet.getString("TDTIPO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Pagination
	 * @return Arbtipdoc
	 */
	public Arbtipdoc add(Arbtipdoc arbtipdoc) {
		String query = "INSERT INTO ARBTIPDOC (TDID, ID_TIPODOC, TDNOMBRE, TDNOMBREE, TDPCODIGO, TDFECALTA, TDFECMODIF, TDUSUALTA, TDUSUMODIF, TDTIPO) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbtipdoc.getTdid(),
				arbtipdoc.getIdTipodoc(), arbtipdoc.getTdnombre(),
				arbtipdoc.getTdnombree(), arbtipdoc.getTdpcodigo(),
				arbtipdoc.getTdfecalta(), arbtipdoc.getTdfecmodif(),
				arbtipdoc.getTdusualta(), arbtipdoc.getTdusumodif(),
				arbtipdoc.getTdtipo());
		return arbtipdoc;
	}

	/**
	 * Updates a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Pagination
	 * @return Arbtipdoc
	 */
	public Arbtipdoc update(Arbtipdoc arbtipdoc) {
		String query = "UPDATE ARBTIPDOC SET ID_TIPODOC=?, TDNOMBRE=?, TDNOMBREE=?, TDPCODIGO=?, TDFECALTA=?, TDFECMODIF=?, TDUSUALTA=?, TDUSUMODIF=?, TDTIPO=? WHERE TDID=?";
		this.jdbcTemplate.update(query, arbtipdoc.getIdTipodoc(),
				arbtipdoc.getTdnombre(), arbtipdoc.getTdnombree(),
				arbtipdoc.getTdpcodigo(), arbtipdoc.getTdfecalta(),
				arbtipdoc.getTdfecmodif(), arbtipdoc.getTdusualta(),
				arbtipdoc.getTdusumodif(), arbtipdoc.getTdtipo(),
				arbtipdoc.getTdid());
		return arbtipdoc;
	}

	/**
	 * Finds a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Pagination
	 * @return Arbtipdoc
	 */
	@Transactional(readOnly = true)
	public Arbtipdoc find(Arbtipdoc arbtipdoc) {
		String query = "SELECT t1.TDID TDID, t1.ID_TIPODOC IDTIPODOC, t1.TDNOMBRE TDNOMBRE, t1.TDNOMBREE TDNOMBREE, t1.TDPCODIGO TDPCODIGO, t1.TDFECALTA TDFECALTA, t1.TDFECMODIF TDFECMODIF, t1.TDUSUALTA TDUSUALTA, t1.TDUSUMODIF TDUSUMODIF, t1.TDTIPO TDTIPO FROM ARBTIPDOC t1  WHERE t1.TDID = ?  ";

		List<Arbtipdoc> arbtipdocList = this.jdbcTemplate.query(query,
				this.rwMap, arbtipdoc.getTdid());
		return (Arbtipdoc) DataAccessUtils.uniqueResult(arbtipdocList);
	}

	/**
	 * Removes a single row in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Pagination
	 * @return
	 */
	public void remove(Arbtipdoc arbtipdoc) {
		String query = "DELETE FROM ARBTIPDOC WHERE TDID=?";
		this.jdbcTemplate.update(query, arbtipdoc.getTdid());
	}

	/**
	 * Finds a List of rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbtipdoc> findAll(Arbtipdoc arbtipdoc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TDID TDID,t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE,t1.TDPCODIGO TDPCODIGO,t1.TDFECALTA TDFECALTA,t1.TDFECMODIF TDFECMODIF,t1.TDUSUALTA TDUSUALTA,t1.TDUSUMODIF TDUSUMODIF,t1.TDTIPO TDTIPO ");
		query.append("FROM ARBTIPDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbtipdoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbtipdoc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbtipdoc table.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbtipdoc arbtipdoc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBTIPDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbtipdoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbtipdoc table using like.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbtipdoc> findAllLike(Arbtipdoc arbtipdoc,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TDID TDID,t1.ID_TIPODOC IDTIPODOC,t1.TDNOMBRE TDNOMBRE,t1.TDNOMBREE TDNOMBREE,t1.TDPCODIGO TDPCODIGO,t1.TDFECALTA TDFECALTA,t1.TDFECMODIF TDFECMODIF,t1.TDUSUALTA TDUSUALTA,t1.TDUSUMODIF TDUSUMODIF,t1.TDTIPO TDTIPO ");
		query.append("FROM ARBTIPDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbtipdoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbtipdoc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbtipdoc table using like.
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbtipdoc arbtipdoc, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBTIPDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbtipdoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbtipdoc entity
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbtipdoc arbtipdoc) {

		StringBuilder where = new StringBuilder(
				ArbtipdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbtipdoc != null && arbtipdoc.getTdid() != null) {
			where.append(" AND t1.TDID = ?");
			params.add(arbtipdoc.getTdid());
		}
		if (arbtipdoc != null && arbtipdoc.getIdTipodoc() != null) {
			where.append(" AND t1.ID_TIPODOC = ?");
			params.add(arbtipdoc.getIdTipodoc());
		}
		if (arbtipdoc != null && arbtipdoc.getTdnombre() != null) {
			where.append(" AND t1.TDNOMBRE = ?");
			params.add(arbtipdoc.getTdnombre());
		}
		if (arbtipdoc != null && arbtipdoc.getTdnombree() != null) {
			where.append(" AND t1.TDNOMBREE = ?");
			params.add(arbtipdoc.getTdnombree());
		}
		if (arbtipdoc != null && arbtipdoc.getTdpcodigo() != null) {
			where.append(" AND t1.TDPCODIGO = ?");
			params.add(arbtipdoc.getTdpcodigo());
		}
		if (arbtipdoc != null && arbtipdoc.getTdfecalta() != null) {
			where.append(" AND t1.TDFECALTA = ?");
			params.add(arbtipdoc.getTdfecalta());
		}
		if (arbtipdoc != null && arbtipdoc.getTdfecmodif() != null) {
			where.append(" AND t1.TDFECMODIF = ?");
			params.add(arbtipdoc.getTdfecmodif());
		}
		if (arbtipdoc != null && arbtipdoc.getTdusualta() != null) {
			where.append(" AND t1.TDUSUALTA = ?");
			params.add(arbtipdoc.getTdusualta());
		}
		if (arbtipdoc != null && arbtipdoc.getTdusumodif() != null) {
			where.append(" AND t1.TDUSUMODIF = ?");
			params.add(arbtipdoc.getTdusumodif());
		}
		if (arbtipdoc != null && arbtipdoc.getTdtipo() != null) {
			where.append(" AND t1.TDTIPO = ?");
			params.add(arbtipdoc.getTdtipo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbtipdoc entity
	 * 
	 * @param arbtipdoc
	 *            Arbtipdoc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbtipdoc arbtipdoc,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbtipdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbtipdoc != null && arbtipdoc.getTdid() != null) {
			where.append(" AND UPPER(t1.TDID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdid().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdid().toUpperCase() + "%");
			}
			where.append(" AND t1.TDID IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getIdTipodoc() != null) {
			where.append(" AND UPPER(t1.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getIdTipodoc().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getIdTipodoc().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_TIPODOC IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getTdnombre() != null) {
			where.append(" AND UPPER(t1.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdnombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.TDNOMBRE IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getTdnombree() != null) {
			where.append(" AND UPPER(t1.TDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdnombree().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdnombree().toUpperCase() + "%");
			}
			where.append(" AND t1.TDNOMBREE IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getTdpcodigo() != null) {
			where.append(" AND UPPER(t1.TDPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdpcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TDPCODIGO IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getTdfecalta() != null) {
			where.append(" AND t1.TDFECALTA = ?");
			params.add(arbtipdoc.getTdfecalta());
		}
		if (arbtipdoc != null && arbtipdoc.getTdfecmodif() != null) {
			where.append(" AND t1.TDFECMODIF = ?");
			params.add(arbtipdoc.getTdfecmodif());
		}
		if (arbtipdoc != null && arbtipdoc.getTdusualta() != null) {
			where.append(" AND UPPER(t1.TDUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.TDUSUALTA IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getTdusumodif() != null) {
			where.append(" AND UPPER(t1.TDUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.TDUSUMODIF IS NOT NULL");
		}
		if (arbtipdoc != null && arbtipdoc.getTdtipo() != null) {
			where.append(" AND UPPER(t1.TDTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdoc.getTdtipo().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdoc.getTdtipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TDTIPO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
