package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbtipdecaud;

/**
 * ArbtipdecaudDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbtipdecaudDaoImpl implements ArbtipdecaudDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbtipdecaud> rwMap = new RowMapper<Arbtipdecaud>() {
		public Arbtipdecaud mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbtipdecaud(resultSet.getInt("DAID"),
					resultSet.getString("DADESCES"),
					resultSet.getString("DADESCEU"),
					resultSet.getDate("DAFECALTA"),
					resultSet.getDate("DAFECMODIF"),
					resultSet.getString("DAUSUALTA"),
					resultSet.getString("DAUSUMODIF"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbtipdecaud table.
	 * 
	 * @param arbtipdecaud
	 *            Pagination
	 * @return Arbtipdecaud
	 */
	public Arbtipdecaud add(Arbtipdecaud arbtipdecaud) {
		String query = "INSERT INTO ARBTIPDECAUD (DAID, DADESCES, DADESCEU, DAFECALTA, DAFECMODIF, DAUSUALTA, DAUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbtipdecaud.getDaid(),
				arbtipdecaud.getDadesces(), arbtipdecaud.getDadesceu(),
				arbtipdecaud.getDafecalta(), arbtipdecaud.getDafecmodif(),
				arbtipdecaud.getDausualta(), arbtipdecaud.getDausumodif());
		return arbtipdecaud;
	}

	/**
	 * Updates a single row in the Arbtipdecaud table.
	 * 
	 * @param arbtipdecaud
	 *            Pagination
	 * @return Arbtipdecaud
	 */
	public Arbtipdecaud update(Arbtipdecaud arbtipdecaud) {
		String query = "UPDATE ARBTIPDECAUD SET DADESCES=?, DADESCEU=?, DAFECALTA=?, DAFECMODIF=?, DAUSUALTA=?, DAUSUMODIF=? WHERE DAID=?";
		this.jdbcTemplate.update(query, arbtipdecaud.getDadesces(),
				arbtipdecaud.getDadesceu(), arbtipdecaud.getDafecalta(),
				arbtipdecaud.getDafecmodif(), arbtipdecaud.getDausualta(),
				arbtipdecaud.getDausumodif(), arbtipdecaud.getDaid());
		return arbtipdecaud;
	}

	/**
	 * Finds a single row in the Arbtipdecaud table.
	 * 
	 * @param arbtipdecaud
	 *            Pagination
	 * @return Arbtipdecaud
	 */
	@Transactional(readOnly = true)
	public Arbtipdecaud find(Arbtipdecaud arbtipdecaud) {
		String query = "SELECT t1.DAID DAID, t1.DADESCES DADESCES, t1.DADESCEU DADESCEU, t1.DAFECALTA DAFECALTA, t1.DAFECMODIF DAFECMODIF, t1.DAUSUALTA DAUSUALTA, t1.DAUSUMODIF DAUSUMODIF FROM ARBTIPDECAUD t1  WHERE t1.DAID = ?  ";

		List<Arbtipdecaud> arbtipdecaudList = this.jdbcTemplate.query(query,
				this.rwMap, arbtipdecaud.getDaid());
		return (Arbtipdecaud) DataAccessUtils.uniqueResult(arbtipdecaudList);
	}

	/**
	 * Removes a single row in the Arbtipdecaud table.
	 * 
	 * @param arbtipdecaud
	 *            Pagination
	 * @return
	 */
	public void remove(Arbtipdecaud arbtipdecaud) {
		String query = "DELETE FROM ARBTIPDECAUD WHERE DAID=?";
		this.jdbcTemplate.update(query, arbtipdecaud.getDaid());
	}

	/**
	 * Finds a List of rows in the Arbtipdecaud table.
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbtipdecaud> findAll(Arbtipdecaud arbtipdecaud,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.DAID DAID,t1.DADESCES DADESCES,t1.DADESCEU DADESCEU,t1.DAFECALTA DAFECALTA,t1.DAFECMODIF DAFECMODIF,t1.DAUSUALTA DAUSUALTA,t1.DAUSUMODIF DAUSUMODIF ");
		query.append("FROM ARBTIPDECAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbtipdecaud);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbtipdecaud>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbtipdecaud table.
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbtipdecaud arbtipdecaud) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBTIPDECAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbtipdecaud);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbtipdecaud table using like.
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbtipdecaud> findAllLike(Arbtipdecaud arbtipdecaud,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.DAID DAID,t1.DADESCES DADESCES,t1.DADESCEU DADESCEU,t1.DAFECALTA DAFECALTA,t1.DAFECMODIF DAFECMODIF,t1.DAUSUALTA DAUSUALTA,t1.DAUSUMODIF DAUSUMODIF ");
		query.append("FROM ARBTIPDECAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbtipdecaud,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbtipdecaud>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbtipdecaud table using like.
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbtipdecaud arbtipdecaud, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBTIPDECAUD t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbtipdecaud,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbtipdecaud entity
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbtipdecaud arbtipdecaud) {

		StringBuilder where = new StringBuilder(
				ArbtipdecaudDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbtipdecaud != null && arbtipdecaud.getDaid() != null) {
			where.append(" AND t1.DAID = ?");
			params.add(arbtipdecaud.getDaid());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDadesces() != null) {
			where.append(" AND t1.DADESCES = ?");
			params.add(arbtipdecaud.getDadesces());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDadesceu() != null) {
			where.append(" AND t1.DADESCEU = ?");
			params.add(arbtipdecaud.getDadesceu());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDafecalta() != null) {
			where.append(" AND t1.DAFECALTA = ?");
			params.add(arbtipdecaud.getDafecalta());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDafecmodif() != null) {
			where.append(" AND t1.DAFECMODIF = ?");
			params.add(arbtipdecaud.getDafecmodif());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDausualta() != null) {
			where.append(" AND t1.DAUSUALTA = ?");
			params.add(arbtipdecaud.getDausualta());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDausumodif() != null) {
			where.append(" AND t1.DAUSUMODIF = ?");
			params.add(arbtipdecaud.getDausumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbtipdecaud entity
	 * 
	 * @param arbtipdecaud
	 *            Arbtipdecaud Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbtipdecaud arbtipdecaud,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbtipdecaudDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbtipdecaud != null && arbtipdecaud.getDaid() != null) {
			where.append(" AND t1.DAID = ?");
			params.add(arbtipdecaud.getDaid());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDadesces() != null) {
			where.append(" AND UPPER(t1.DADESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdecaud.getDadesces().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdecaud.getDadesces().toUpperCase() + "%");
			}
			where.append(" AND t1.DADESCES IS NOT NULL");
		}
		if (arbtipdecaud != null && arbtipdecaud.getDadesceu() != null) {
			where.append(" AND UPPER(t1.DADESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdecaud.getDadesceu().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdecaud.getDadesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.DADESCEU IS NOT NULL");
		}
		if (arbtipdecaud != null && arbtipdecaud.getDafecalta() != null) {
			where.append(" AND t1.DAFECALTA = ?");
			params.add(arbtipdecaud.getDafecalta());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDafecmodif() != null) {
			where.append(" AND t1.DAFECMODIF = ?");
			params.add(arbtipdecaud.getDafecmodif());
		}
		if (arbtipdecaud != null && arbtipdecaud.getDausualta() != null) {
			where.append(" AND UPPER(t1.DAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdecaud.getDausualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdecaud.getDausualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DAUSUALTA IS NOT NULL");
		}
		if (arbtipdecaud != null && arbtipdecaud.getDausumodif() != null) {
			where.append(" AND UPPER(t1.DAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbtipdecaud.getDausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbtipdecaud.getDausumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DAUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
