package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbsoltele;

/**
 * ArbsolteleDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbsolteleDaoImpl implements ArbsolteleDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbsoltele> rwMap = new RowMapper<Arbsoltele>() {
		public Arbsoltele mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbsoltele(resultSet.getBigDecimal("ARBSOLID"),
					resultSet.getString("ARBHDCOD"),
					resultSet.getDate("ARBHDFEC"),
					resultSet.getString("ARBHDTE"),
					resultSet.getString("ARBHDCOTSR"),
					resultSet.getBigDecimal("ARBHDCAPTSO"),
					resultSet.getString("ARBHDTESO"),
					resultSet.getString("ARBSOLTIPNOTIF"),
					resultSet.getString("ARBSOLIDIOMA"),
					resultSet.getString("ARBSOLTELEM"),
					resultSet.getString("ARBSOLEMAIL"),
					resultSet.getString("ARBSOLSMS"),
					resultSet.getDate("ARBFECALTA"),
					resultSet.getString("ARBSOLREGEN"),
					resultSet.getDate("ARBSOLFECREGEN"),
					resultSet.getString("ARBSOLNIF"),
					resultSet.getString("ARBSOLNOMBRE"),
					resultSet.getString("ARBSOLCOOR"),
					resultSet.getBigDecimal("ARBSOLNRAN"),
					resultSet.getBigDecimal("ARBSOLNROR"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Pagination
	 * @return Arbsoltele
	 */
	public Arbsoltele add(Arbsoltele arbsoltele) {
		String query = "INSERT INTO ARBSOLTELE (ARBSOLID, ARBHDCOD, ARBHDFEC, ARBHDTE, ARBHDCOTSR, ARBHDCAPTSO, ARBHDTESO, ARBSOLTIPNOTIF, ARBSOLIDIOMA, ARBSOLTELEM, ARBSOLEMAIL, ARBSOLSMS, ARBFECALTA, ARBSOLREGEN, ARBSOLFECREGEN, ARBSOLNIF, ARBSOLNOMBRE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbsoltele.getArbsolid(),
				arbsoltele.getArbhdcod(), arbsoltele.getArbhdfec(),
				arbsoltele.getArbhdte(), arbsoltele.getArbhdcotsr(),
				arbsoltele.getArbhdcaptso(), arbsoltele.getArbhdteso(),
				arbsoltele.getArbsoltipnotif(), arbsoltele.getArbsolidioma(),
				arbsoltele.getArbsoltelem(), arbsoltele.getArbsolemail(),
				arbsoltele.getArbsolsms(), arbsoltele.getArbfecalta(),
				arbsoltele.getArbsolregen(), arbsoltele.getArbsolfecregen(),
				arbsoltele.getArbsolnif(), arbsoltele.getArbsolnombre());
		return arbsoltele;
	}

	/**
	 * Updates a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Pagination
	 * @return Arbsoltele
	 */
	public Arbsoltele update(Arbsoltele arbsoltele) {
		String query = "UPDATE ARBSOLTELE SET ARBHDCOD=?, ARBHDFEC=?, ARBHDTE=?, ARBHDCOTSR=?, ARBHDCAPTSO=?, ARBHDTESO=?, ARBSOLTIPNOTIF=?, ARBSOLIDIOMA=?, ARBSOLTELEM=?, ARBSOLEMAIL=?, ARBSOLSMS=?, ARBFECALTA=?, ARBSOLREGEN=?, ARBSOLFECREGEN=?, ARBSOLNIF=?, ARBSOLNOMBRE=? WHERE ARBSOLID=?";
		this.jdbcTemplate.update(query, arbsoltele.getArbhdcod(),
				arbsoltele.getArbhdfec(), arbsoltele.getArbhdte(),
				arbsoltele.getArbhdcotsr(), arbsoltele.getArbhdcaptso(),
				arbsoltele.getArbhdteso(), arbsoltele.getArbsoltipnotif(),
				arbsoltele.getArbsolidioma(), arbsoltele.getArbsoltelem(),
				arbsoltele.getArbsolemail(), arbsoltele.getArbsolsms(),
				arbsoltele.getArbfecalta(), arbsoltele.getArbsolregen(),
				arbsoltele.getArbsolfecregen(), arbsoltele.getArbsolnif(),
				arbsoltele.getArbsolnombre(), arbsoltele.getArbsolid());
		return arbsoltele;
	}

	/**
	 * Finds a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Pagination
	 * @return Arbsoltele
	 */
	@Transactional(readOnly = true)
	public Arbsoltele find(Arbsoltele arbsoltele) {
		String query = "SELECT t1.ARBSOLID ARBSOLID, t1.ARBHDCOD ARBHDCOD, t1.ARBHDFEC ARBHDFEC, t1.ARBHDTE ARBHDTE, t1.ARBHDCOTSR ARBHDCOTSR, t1.ARBHDCAPTSO ARBHDCAPTSO, t1.ARBHDTESO ARBHDTESO, t1.ARBSOLTIPNOTIF ARBSOLTIPNOTIF, t1.ARBSOLIDIOMA ARBSOLIDIOMA, t1.ARBSOLTELEM ARBSOLTELEM, t1.ARBSOLEMAIL ARBSOLEMAIL, t1.ARBSOLSMS ARBSOLSMS, t1.ARBFECALTA ARBFECALTA, t1.ARBSOLREGEN ARBSOLREGEN, t1.ARBSOLFECREGEN ARBSOLFECREGEN, t1.ARBSOLNIF ARBSOLNIF, t1.ARBSOLNOMBRE ARBSOLNOMBRE FROM ARBSOLTELE t1  WHERE t1.ARBSOLID = ?  ";

		List<Arbsoltele> arbsolteleList = this.jdbcTemplate.query(query,
				this.rwMap, arbsoltele.getArbsolid());
		return (Arbsoltele) DataAccessUtils.uniqueResult(arbsolteleList);
	}

	/**
	 * Removes a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Pagination
	 * @return
	 */
	public void remove(Arbsoltele arbsoltele) {
		String query = "DELETE FROM ARBSOLTELE WHERE ARBSOLID=?";
		this.jdbcTemplate.update(query, arbsoltele.getArbsolid());
	}

	/**
	 * Finds a List of rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbsoltele> findAll(Arbsoltele arbsoltele, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ARBSOLID ARBSOLID,t1.ARBHDCOD ARBHDCOD,t1.ARBHDFEC ARBHDFEC,t1.ARBHDTE ARBHDTE,t1.ARBHDCOTSR ARBHDCOTSR,t1.ARBHDCAPTSO ARBHDCAPTSO,t1.ARBHDTESO ARBHDTESO,t1.ARBSOLTIPNOTIF ARBSOLTIPNOTIF,t1.ARBSOLIDIOMA ARBSOLIDIOMA,t1.ARBSOLTELEM ARBSOLTELEM,t1.ARBSOLEMAIL ARBSOLEMAIL,t1.ARBSOLSMS ARBSOLSMS,t1.ARBFECALTA ARBFECALTA,t1.ARBSOLREGEN ARBSOLREGEN,t1.ARBSOLFECREGEN ARBSOLFECREGEN,t1.ARBSOLNIF ARBSOLNIF,t1.ARBSOLNOMBRE ARBSOLNOMBRE ");
		query.append("FROM ARBSOLTELE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbsoltele);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbsoltele>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbsoltele arbsoltele) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBSOLTELE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbsoltele);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbsoltele> findAllLike(Arbsoltele arbsoltele,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ARBSOLID ARBSOLID,t1.ARBHDCOD ARBHDCOD,t1.ARBHDFEC ARBHDFEC,t1.ARBHDTE ARBHDTE,t1.ARBHDCOTSR ARBHDCOTSR,t1.ARBHDCAPTSO ARBHDCAPTSO,t1.ARBHDTESO ARBHDTESO,t1.ARBSOLTIPNOTIF ARBSOLTIPNOTIF,t1.ARBSOLIDIOMA ARBSOLIDIOMA,t1.ARBSOLTELEM ARBSOLTELEM,t1.ARBSOLEMAIL ARBSOLEMAIL,t1.ARBSOLSMS ARBSOLSMS,t1.ARBFECALTA ARBFECALTA,t1.ARBSOLREGEN ARBSOLREGEN,t1.ARBSOLFECREGEN ARBSOLFECREGEN,t1.ARBSOLNIF ARBSOLNIF,t1.ARBSOLNOMBRE ARBSOLNOMBRE ");
		query.append("FROM ARBSOLTELE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbsoltele, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbsoltele>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbsoltele arbsoltele, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBSOLTELE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbsoltele, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbsoltele entity
	 * 
	 * @param arbsoltele
	 *            Arbsoltele Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbsoltele arbsoltele) {

		StringBuilder where = new StringBuilder(
				ArbsolteleDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbsoltele != null && arbsoltele.getArbsolid() != null) {
			where.append(" AND t1.ARBSOLID = ?");
			params.add(arbsoltele.getArbsolid());
		}
		if (arbsoltele != null && arbsoltele.getArbhdcod() != null) {
			where.append(" AND t1.ARBHDCOD = ?");
			params.add(arbsoltele.getArbhdcod());
		}
		if (arbsoltele != null && arbsoltele.getArbhdfec() != null) {
			where.append(" AND t1.ARBHDFEC = ?");
			params.add(arbsoltele.getArbhdfec());
		}
		if (arbsoltele != null && arbsoltele.getArbhdcotsr() != null) {
			where.append(" AND t1.ARBHDCOTSR = ?");
			params.add(arbsoltele.getArbhdcotsr());
		}
		if (arbsoltele != null && arbsoltele.getArbhdcaptso() != null) {
			where.append(" AND t1.ARBHDCAPTSO = ?");
			params.add(arbsoltele.getArbhdcaptso());
		}
		if (arbsoltele != null && arbsoltele.getArbhdteso() != null) {
			where.append(" AND t1.ARBHDTESO = ?");
			params.add(arbsoltele.getArbhdteso());
		}
		if (arbsoltele != null && arbsoltele.getArbsoltipnotif() != null) {
			where.append(" AND t1.ARBSOLTIPNOTIF = ?");
			params.add(arbsoltele.getArbsoltipnotif());
		}
		if (arbsoltele != null && arbsoltele.getArbsolidioma() != null) {
			where.append(" AND t1.ARBSOLIDIOMA = ?");
			params.add(arbsoltele.getArbsolidioma());
		}
		if (arbsoltele != null && arbsoltele.getArbsoltelem() != null) {
			where.append(" AND t1.ARBSOLTELEM = ?");
			params.add(arbsoltele.getArbsoltelem());
		}
		if (arbsoltele != null && arbsoltele.getArbsolemail() != null) {
			where.append(" AND t1.ARBSOLEMAIL = ?");
			params.add(arbsoltele.getArbsolemail());
		}
		if (arbsoltele != null && arbsoltele.getArbsolsms() != null) {
			where.append(" AND t1.ARBSOLSMS = ?");
			params.add(arbsoltele.getArbsolsms());
		}
		if (arbsoltele != null && arbsoltele.getArbfecalta() != null) {
			where.append(" AND t1.ARBFECALTA = ?");
			params.add(arbsoltele.getArbfecalta());
		}
		if (arbsoltele != null && arbsoltele.getArbsolregen() != null) {
			where.append(" AND t1.ARBSOLREGEN = ?");
			params.add(arbsoltele.getArbsolregen());
		}
		if (arbsoltele != null && arbsoltele.getArbsolfecregen() != null) {
			where.append(" AND t1.ARBSOLFECREGEN = ?");
			params.add(arbsoltele.getArbsolfecregen());
		}
		if (arbsoltele != null && arbsoltele.getArbsolnif() != null) {
			where.append(" AND t1.ARBSOLNIF = ?");
			params.add(arbsoltele.getArbsolnif());
		}
		if (arbsoltele != null && arbsoltele.getArbsolnombre() != null) {
			where.append(" AND t1.ARBSOLNOMBRE = ?");
			params.add(arbsoltele.getArbsolnombre());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbsoltele entity
	 * 
	 * @param arbsoltele
	 *            Arbsoltele Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbsoltele arbsoltele,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbsolteleDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbsoltele != null && arbsoltele.getArbsolid() != null) {
			where.append(" AND t1.ARBSOLID = ?");
			params.add(arbsoltele.getArbsolid());
		}
		if (arbsoltele != null && arbsoltele.getArbhdcod() != null) {
			where.append(" AND UPPER(t1.ARBHDCOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbhdcod().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbhdcod().toUpperCase() + "%");
			}
			where.append(" AND t1.ARBHDCOD IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbhdfec() != null) {
			where.append(" AND t1.ARBHDFEC = ?");
			params.add(arbsoltele.getArbhdfec());
		}
		if (arbsoltele != null && arbsoltele.getArbhdcotsr() != null) {
			where.append(" AND UPPER(t1.ARBHDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbhdcotsr().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbhdcotsr().toUpperCase() + "%");
			}
			where.append(" AND t1.ARBHDCOTSR IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbhdcaptso() != null) {
			where.append(" AND t1.ARBHDCAPTSO = ?");
			params.add(arbsoltele.getArbhdcaptso());
		}
		if (arbsoltele != null && arbsoltele.getArbhdteso() != null) {
			where.append(" AND UPPER(t1.ARBHDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbhdteso().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbhdteso().toUpperCase() + "%");
			}
			where.append(" AND t1.ARBHDTESO IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsoltipnotif() != null) {
			where.append(" AND UPPER(t1.ARBSOLTIPNOTIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsoltipnotif().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsoltipnotif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARBSOLTIPNOTIF IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsolidioma() != null) {
			where.append(" AND UPPER(t1.ARBSOLIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsolidioma().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsolidioma().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARBSOLIDIOMA IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsoltelem() != null) {
			where.append(" AND UPPER(t1.ARBSOLTELEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsoltelem().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsoltelem().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARBSOLTELEM IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsolemail() != null) {
			where.append(" AND UPPER(t1.ARBSOLEMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsolemail().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsolemail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARBSOLEMAIL IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsolsms() != null) {
			where.append(" AND UPPER(t1.ARBSOLSMS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsolsms().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsolsms().toUpperCase() + "%");
			}
			where.append(" AND t1.ARBSOLSMS IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbfecalta() != null) {
			where.append(" AND t1.ARBFECALTA = ?");
			params.add(arbsoltele.getArbfecalta());
		}
		if (arbsoltele != null && arbsoltele.getArbsolregen() != null) {
			where.append(" AND UPPER(t1.ARBSOLREGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsolregen().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsolregen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARBSOLREGEN IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsolfecregen() != null) {
			where.append(" AND t1.ARBSOLFECREGEN = ?");
			params.add(arbsoltele.getArbsolfecregen());
		}
		if (arbsoltele != null && arbsoltele.getArbsolnif() != null) {
			where.append(" AND UPPER(t1.ARBSOLNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsolnif().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsolnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ARBSOLNIF IS NOT NULL");
		}
		if (arbsoltele != null && arbsoltele.getArbsolnombre() != null) {
			where.append(" AND UPPER(t1.ARBSOLNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoltele.getArbsolnombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoltele.getArbsolnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ARBSOLNOMBRE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Pagination
	 * @return Arbsoltele
	 */
	@Transactional(readOnly = true)
	public Arbsoltele findPorRegistroEntrada(Arbsoltele arbsoltele) {
		String query = "SELECT t1.ARBSOLID ARBSOLID, t1.ARBHDCOD ARBHDCOD, t1.ARBHDFEC ARBHDFEC, t1.ARBHDTE ARBHDTE, t1.ARBHDCOTSR ARBHDCOTSR, t1.ARBHDCAPTSO ARBHDCAPTSO, t1.ARBHDTESO ARBHDTESO, t1.ARBSOLTIPNOTIF ARBSOLTIPNOTIF, t1.ARBSOLIDIOMA ARBSOLIDIOMA, t1.ARBSOLTELEM ARBSOLTELEM, t1.ARBSOLEMAIL ARBSOLEMAIL, t1.ARBSOLSMS ARBSOLSMS, t1.ARBFECALTA ARBFECALTA, t1.ARBSOLREGEN ARBSOLREGEN, t1.ARBSOLFECREGEN ARBSOLFECREGEN, t1.ARBSOLNIF ARBSOLNIF, t1.ARBSOLNOMBRE ARBSOLNOMBRE, t1.ARBSOLCOOR ARBSOLCOOR, t1.ARBSOLNRAN ARBSOLNRAN, t1.ARBSOLNROR ARBSOLNROR FROM ARBSOLTELE t1  WHERE t1.ARBSOLREGEN = ?";

		List<Arbsoltele> arbsolteleList = this.jdbcTemplate.query(query,
				this.rwMap, arbsoltele.getArbsolregen());
		return (Arbsoltele) DataAccessUtils.uniqueResult(arbsolteleList);
	}

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * @return
	 */
	public void removeTelematicosAntiguas() {

		String query = "DELETE FROM ARBSOLTELE WHERE ARBSOLTELE.ARBFECALTA+8<SYSDATE AND ARBSOLTELE.ARBSOLREGEN IS NULL ";

		this.jdbcTemplate.update(query);

	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
