package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbsoltele;

/**
 * ArbsolteleDao  
 * 
 *  
 */

public interface ArbsolteleDao {

	/**
	 * Inserts a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	Arbsoltele add(Arbsoltele arbsoltele);

	/**
	 * Updates a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	Arbsoltele update(Arbsoltele arbsoltele);

	/**
	 * Finds a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Arbsoltele
	 */
	Arbsoltele find(Arbsoltele arbsoltele);

	/**
	 * Deletes a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return
	 */
	void remove(Arbsoltele arbsoltele);

	/**
	 * Finds a List of rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbsoltele> findAll(Arbsoltele arbsoltele, Pagination pagination);

	/**
	 * Counts rows in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return Long
	 */
	Long findAllCount(Arbsoltele arbsoltele);

	/**
	 * Finds rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbsoltele> findAllLike(Arbsoltele arbsoltele, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbsoltele table using like.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbsoltele arbsoltele, Boolean startsWith);

	/**
	 * Finds a single row in the Arbsoltele table.
	 * 
	 * @param arbsoltele
	 *            Pagination
	 * @return Arbsoltele
	 */
	public Arbsoltele findPorRegistroEntrada(Arbsoltele arbsoltele);

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * 
	 */
	void removeTelematicosAntiguas();
}
