package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Arbsoltele;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbsoldoctele;

/**
 * ArbsoldocteleDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbsoldocteleDaoImpl implements ArbsoldocteleDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbsoldoctele> rwMap = new RowMapper<Arbsoldoctele>() {
		public Arbsoldoctele mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbsoldoctele(resultSet.getInt("XPID"),
					resultSet.getString("XPNOFILE"),
					resultSet.getBlob("XPDATAFILE"),
					resultSet.getInt("XPSIZEFILE"),
					resultSet.getString("XPTEDESFILE"),
					resultSet.getString("XPORIGEN"),
					resultSet.getDate("XPFECHA"),
					resultSet.getString("XPCONTENTTYPEFILE"),
					resultSet.getString("XPIDDOCUMENTUM"),
					resultSet.getDate("XPFECHAAPORTACION"),
					resultSet.getDate("XPFECHAENTRADA"),
					resultSet.getString("XPNUMREGISTROENTRADA"),
					resultSet.getString("XPRUTAPIF"), new Arbsoltele(
							resultSet.getBigDecimal("ArbsolteleARBSOLID"),
							resultSet.getString("ArbsolteleARBHDCOD"),
							resultSet.getDate("ArbsolteleARBHDFEC"),
							resultSet.getString("ArbsolteleARBHDTE"),
							resultSet.getString("ArbsolteleARBHDCOTSR"),
							resultSet.getBigDecimal("ArbsolteleARBHDCAPTSO"),
							resultSet.getString("ArbsolteleARBHDTESO"),
							resultSet.getString("ArbsolteleARBSOLTIPNOTIF"),
							resultSet.getString("ArbsolteleARBSOLIDIOMA"),
							resultSet.getString("ArbsolteleARBSOLTELEM"),
							resultSet.getString("ArbsolteleARBSOLEMAIL"),
							resultSet.getString("ArbsolteleARBSOLSMS"),
							resultSet.getDate("ArbsolteleARBFECALTA"),
							resultSet.getString("ArbsolteleARBSOLREGEN"),
							resultSet.getDate("ArbsolteleARBSOLFECREGEN"),
							resultSet.getString("ArbsolteleARBSOLNIF"),
							resultSet.getString("ArbsolteleARBSOLNOMBRE"),
							resultSet.getString("ARBSOLTELEARBSOLCOOR"),
							resultSet.getBigDecimal("ARBSOLTELEARBSOLNRAN"),
							resultSet.getBigDecimal("ARBSOLTELEARBSOLNROR")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbsoldoctele table.
	 * 
	 * @param arbsoldoctele
	 *            Pagination
	 * @return Arbsoldoctele
	 */
	public Arbsoldoctele add(Arbsoldoctele arbsoldoctele) {
		String query = "INSERT INTO ARBSOLDOCTELE (XPID, XPARBSOLID, XPNOFILE, XPDATAFILE, XPSIZEFILE, XPTEDESFILE, XPORIGEN, XPFECHA, XPCONTENTTYPEFILE, XPIDDOCUMENTUM, XPFECHAAPORTACION, XPFECHAENTRADA, XPNUMREGISTROENTRADA, XPRUTAPIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getArbsolteleArbsolidAux = null;
		if (arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolid() != null) {
			getArbsolteleArbsolidAux = arbsoldoctele.getArbsoltele()
					.getArbsolid();
		}
		this.jdbcTemplate.update(query, arbsoldoctele.getXpid(),
				getArbsolteleArbsolidAux, arbsoldoctele.getXpnofile(),
				arbsoldoctele.getXpdatafile(), arbsoldoctele.getXpsizefile(),
				arbsoldoctele.getXptedesfile(), arbsoldoctele.getXporigen(),
				arbsoldoctele.getXpfecha(),
				arbsoldoctele.getXpcontenttypefile(),
				arbsoldoctele.getXpiddocumentum(),
				arbsoldoctele.getXpfechaaportacion(),
				arbsoldoctele.getXpfechaentrada(),
				arbsoldoctele.getXpnumregistroentrada(),
				arbsoldoctele.getXprutapif());
		return arbsoldoctele;
	}

	/**
	 * Updates a single row in the Arbsoldoctele table.
	 * 
	 * @param arbsoldoctele
	 *            Pagination
	 * @return Arbsoldoctele
	 */
	public Arbsoldoctele update(Arbsoldoctele arbsoldoctele) {
		String query = "UPDATE ARBSOLDOCTELE SET XPARBSOLID=?, XPNOFILE=?, XPDATAFILE=?, XPSIZEFILE=?, XPTEDESFILE=?, XPORIGEN=?, XPFECHA=?, XPCONTENTTYPEFILE=?, XPIDDOCUMENTUM=?, XPFECHAAPORTACION=?, XPFECHAENTRADA=?, XPNUMREGISTROENTRADA=?, XPRUTAPIF=? WHERE XPID=?";
		Object getArbsolteleArbsolidAux = null;
		if (arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolid() != null) {
			getArbsolteleArbsolidAux = arbsoldoctele.getArbsoltele()
					.getArbsolid();
		}
		this.jdbcTemplate.update(query, getArbsolteleArbsolidAux,
				arbsoldoctele.getXpnofile(), arbsoldoctele.getXpdatafile(),
				arbsoldoctele.getXpsizefile(), arbsoldoctele.getXptedesfile(),
				arbsoldoctele.getXporigen(), arbsoldoctele.getXpfecha(),
				arbsoldoctele.getXpcontenttypefile(),
				arbsoldoctele.getXpiddocumentum(),
				arbsoldoctele.getXpfechaaportacion(),
				arbsoldoctele.getXpfechaentrada(),
				arbsoldoctele.getXpnumregistroentrada(),
				arbsoldoctele.getXprutapif(), arbsoldoctele.getXpid());
		return arbsoldoctele;
	}

	/**
	 * Finds a single row in the Arbsoldoctele table.
	 * 
	 * @param arbsoldoctele
	 *            Pagination
	 * @return Arbsoldoctele
	 */
	@Transactional(readOnly = true)
	public Arbsoldoctele find(Arbsoldoctele arbsoldoctele) {
		String query = "SELECT t1.XPID XPID, t1.XPNOFILE XPNOFILE, t1.XPDATAFILE XPDATAFILE, t1.XPSIZEFILE XPSIZEFILE, t1.XPTEDESFILE XPTEDESFILE, t1.XPORIGEN XPORIGEN, t1.XPFECHA XPFECHA, t1.XPCONTENTTYPEFILE XPCONTENTTYPEFILE, t1.XPIDDOCUMENTUM XPIDDOCUMENTUM, t1.XPFECHAAPORTACION XPFECHAAPORTACION, t1.XPFECHAENTRADA XPFECHAENTRADA, t1.XPNUMREGISTROENTRADA XPNUMREGISTROENTRADA, t1.XPRUTAPIF XPRUTAPIF, t2.ARBSOLID ARBSOLTELEARBSOLID, t2.ARBHDCOD ARBSOLTELEARBHDCOD, t2.ARBHDFEC ARBSOLTELEARBHDFEC, t2.ARBHDTE ARBSOLTELEARBHDTE, t2.ARBHDCOTSR ARBSOLTELEARBHDCOTSR, t2.ARBHDCAPTSO ARBSOLTELEARBHDCAPTSO, t2.ARBHDTESO ARBSOLTELEARBHDTESO, t2.ARBSOLTIPNOTIF ARBSOLTELEARBSOLTIPNOTIF, t2.ARBSOLIDIOMA ARBSOLTELEARBSOLIDIOMA, t2.ARBSOLTELEM ARBSOLTELEARBSOLTELEM, t2.ARBSOLEMAIL ARBSOLTELEARBSOLEMAIL, t2.ARBSOLSMS ARBSOLTELEARBSOLSMS, t2.ARBFECALTA ARBSOLTELEARBFECALTA, t2.ARBSOLREGEN ARBSOLTELEARBSOLREGEN, t2.ARBSOLFECREGEN ARBSOLTELEARBSOLFECREGEN, t2.ARBSOLNIF ARBSOLTELEARBSOLNIF, t2.ARBSOLNOMBRE ARBSOLTELEARBSOLNOMBRE, t2.ARBSOLCOOR ARBSOLTELEARBSOLCOOR, t2.ARBSOLNRAN ARBSOLTELEARBSOLNRAN, t2.ARBSOLNROR ARBSOLTELEARBSOLNROR FROM ARBSOLDOCTELE t1 , ARBSOLTELE t2  WHERE t1.XPID = ?   AND t1.XPARBSOLID= t2.ARBSOLID(+)";

		List<Arbsoldoctele> arbsoldocteleList = this.jdbcTemplate.query(query,
				this.rwMap, arbsoldoctele.getXpid());
		return (Arbsoldoctele) DataAccessUtils.uniqueResult(arbsoldocteleList);
	}

	/**
	 * Removes a single row in the Arbsoldoctele table.
	 * 
	 * @param arbsoldoctele
	 *            Pagination
	 * @return
	 */
	public void remove(Arbsoldoctele arbsoldoctele) {
		String query = "DELETE FROM ARBSOLDOCTELE WHERE XPID=?";
		this.jdbcTemplate.update(query, arbsoldoctele.getXpid());
	}

	/**
	 * Finds a List of rows in the Arbsoldoctele table.
	 * 
	 * @param arbsoldoctele
	 *            Arbsoldoctele
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbsoldoctele> findAll(Arbsoldoctele arbsoldoctele,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.XPID XPID,t1.XPNOFILE XPNOFILE,t1.XPDATAFILE XPDATAFILE,t1.XPSIZEFILE XPSIZEFILE,t1.XPTEDESFILE XPTEDESFILE,t1.XPORIGEN XPORIGEN,t1.XPFECHA XPFECHA,t1.XPCONTENTTYPEFILE XPCONTENTTYPEFILE,t1.XPIDDOCUMENTUM XPIDDOCUMENTUM,t1.XPFECHAAPORTACION XPFECHAAPORTACION,t1.XPFECHAENTRADA XPFECHAENTRADA,t1.XPNUMREGISTROENTRADA XPNUMREGISTROENTRADA,t1.XPRUTAPIF XPRUTAPIF,t2.ARBSOLID ARBSOLTELEARBSOLID,t2.ARBHDCOD ARBSOLTELEARBHDCOD,t2.ARBHDFEC ARBSOLTELEARBHDFEC,t2.ARBHDTE ARBSOLTELEARBHDTE,t2.ARBHDCOTSR ARBSOLTELEARBHDCOTSR,t2.ARBHDCAPTSO ARBSOLTELEARBHDCAPTSO,t2.ARBHDTESO ARBSOLTELEARBHDTESO,t2.ARBSOLTIPNOTIF ARBSOLTELEARBSOLTIPNOTIF,t2.ARBSOLIDIOMA ARBSOLTELEARBSOLIDIOMA,t2.ARBSOLTELEM ARBSOLTELEARBSOLTELEM,t2.ARBSOLEMAIL ARBSOLTELEARBSOLEMAIL,t2.ARBSOLSMS ARBSOLTELEARBSOLSMS,t2.ARBFECALTA ARBSOLTELEARBFECALTA,t2.ARBSOLREGEN ARBSOLTELEARBSOLREGEN,t2.ARBSOLFECREGEN ARBSOLTELEARBSOLFECREGEN,t2.ARBSOLNIF ARBSOLTELEARBSOLNIF,t2.ARBSOLNOMBRE ARBSOLTELEARBSOLNOMBRE ");
		query.append("FROM ARBSOLDOCTELE t1 ,ARBSOLTELE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbsoldoctele);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.XPARBSOLID= t2.ARBSOLID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbsoldoctele>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbsoldoctele table.
	 * 
	 * @param arbsoldoctele
	 *            Arbsoldoctele
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbsoldoctele arbsoldoctele) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBSOLDOCTELE t1 , ARBSOLTELE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbsoldoctele);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.XPARBSOLID= t2.ARBSOLID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbsoldoctele table using like.
	 * 
	 * @param arbsoldoctele
	 *            Arbsoldoctele
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbsoldoctele> findAllLike(Arbsoldoctele arbsoldoctele,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.XPID XPID,t1.XPNOFILE XPNOFILE,t1.XPDATAFILE XPDATAFILE,t1.XPSIZEFILE XPSIZEFILE,t1.XPTEDESFILE XPTEDESFILE,t1.XPORIGEN XPORIGEN,t1.XPFECHA XPFECHA,t1.XPCONTENTTYPEFILE XPCONTENTTYPEFILE,t1.XPIDDOCUMENTUM XPIDDOCUMENTUM,t1.XPFECHAAPORTACION XPFECHAAPORTACION,t1.XPFECHAENTRADA XPFECHAENTRADA,t1.XPNUMREGISTROENTRADA XPNUMREGISTROENTRADA,t1.XPRUTAPIF XPRUTAPIF,t2.ARBSOLID ARBSOLTELEARBSOLID,t2.ARBHDCOD ARBSOLTELEARBHDCOD,t2.ARBHDFEC ARBSOLTELEARBHDFEC,t2.ARBHDTE ARBSOLTELEARBHDTE,t2.ARBHDCOTSR ARBSOLTELEARBHDCOTSR,t2.ARBHDCAPTSO ARBSOLTELEARBHDCAPTSO,t2.ARBHDTESO ARBSOLTELEARBHDTESO,t2.ARBSOLTIPNOTIF ARBSOLTELEARBSOLTIPNOTIF,t2.ARBSOLIDIOMA ARBSOLTELEARBSOLIDIOMA,t2.ARBSOLTELEM ARBSOLTELEARBSOLTELEM,t2.ARBSOLEMAIL ARBSOLTELEARBSOLEMAIL,t2.ARBSOLSMS ARBSOLTELEARBSOLSMS,t2.ARBFECALTA ARBSOLTELEARBFECALTA,t2.ARBSOLREGEN ARBSOLTELEARBSOLREGEN,t2.ARBSOLFECREGEN ARBSOLTELEARBSOLFECREGEN,t2.ARBSOLNIF ARBSOLTELEARBSOLNIF,t2.ARBSOLNOMBRE ARBSOLTELEARBSOLNOMBRE ");
		query.append("FROM ARBSOLDOCTELE t1 ,ARBSOLTELE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbsoldoctele,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.XPARBSOLID= t2.ARBSOLID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbsoldoctele>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbsoldoctele table using like.
	 * 
	 * @param arbsoldoctele
	 *            Arbsoldoctele
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbsoldoctele arbsoldoctele, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBSOLDOCTELE t1 ,ARBSOLTELE t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbsoldoctele,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.XPARBSOLID= t2.ARBSOLID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Removes a single row in the Arbsoldoctele table.
	 * 
	 * @param documentoTelematico
	 *            Pagination
	 * @return
	 */
	public void removeTelematicos(Arbsoldoctele documentoTelematico) {
		String query = "DELETE FROM ARBSOLDOCTELE WHERE XPARBSOLID=?";

		Object getArbsolteleArbsolidAux = null;
		if (documentoTelematico.getArbsoltele() != null
				&& documentoTelematico.getArbsoltele().getArbsolid() != null) {
			getArbsolteleArbsolidAux = documentoTelematico.getArbsoltele()
					.getArbsolid();
		}

		this.jdbcTemplate.update(query, getArbsolteleArbsolidAux);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbsoldoctele entity
	 * 
	 * @param arbsoldoctele
	 *            Arbsoldoctele Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbsoldoctele arbsoldoctele) {

		StringBuilder where = new StringBuilder(
				ArbsoldocteleDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbsoldoctele != null && arbsoldoctele.getXpid() != null) {
			where.append(" AND t1.XPID = ?");
			params.add(arbsoldoctele.getXpid());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolid() != null) {
			where.append(" AND t2.ARBSOLID = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolid());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdcod() != null) {
			where.append(" AND t2.ARBHDCOD = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdcod());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdfec() != null) {
			where.append(" AND t2.ARBHDFEC = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdfec());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdcotsr() != null) {
			where.append(" AND t2.ARBHDCOTSR = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdcotsr());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdcaptso() != null) {
			where.append(" AND t2.ARBHDCAPTSO = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdcaptso());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdteso() != null) {
			where.append(" AND t2.ARBHDTESO = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdteso());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsoltipnotif() != null) {
			where.append(" AND t2.ARBSOLTIPNOTIF = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsoltipnotif());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolidioma() != null) {
			where.append(" AND t2.ARBSOLIDIOMA = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolidioma());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsoltelem() != null) {
			where.append(" AND t2.ARBSOLTELEM = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsoltelem());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolemail() != null) {
			where.append(" AND t2.ARBSOLEMAIL = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolemail());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolsms() != null) {
			where.append(" AND t2.ARBSOLSMS = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolsms());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbfecalta() != null) {
			where.append(" AND t2.ARBFECALTA = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbfecalta());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolregen() != null) {
			where.append(" AND t2.ARBSOLREGEN = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolregen());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolfecregen() != null) {
			where.append(" AND t2.ARBSOLFECREGEN = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolfecregen());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolnif() != null) {
			where.append(" AND t2.ARBSOLNIF = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolnif());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolnombre() != null) {
			where.append(" AND t2.ARBSOLNOMBRE = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolnombre());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpnofile() != null) {
			where.append(" AND t1.XPNOFILE = ?");
			params.add(arbsoldoctele.getXpnofile());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpsizefile() != null) {
			where.append(" AND t1.XPSIZEFILE = ?");
			params.add(arbsoldoctele.getXpsizefile());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXptedesfile() != null) {
			where.append(" AND t1.XPTEDESFILE = ?");
			params.add(arbsoldoctele.getXptedesfile());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXporigen() != null) {
			where.append(" AND t1.XPORIGEN = ?");
			params.add(arbsoldoctele.getXporigen());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpfecha() != null) {
			where.append(" AND t1.XPFECHA = ?");
			params.add(arbsoldoctele.getXpfecha());
		}
		if (arbsoldoctele != null
				&& arbsoldoctele.getXpcontenttypefile() != null) {
			where.append(" AND t1.XPCONTENTTYPEFILE = ?");
			params.add(arbsoldoctele.getXpcontenttypefile());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpiddocumentum() != null) {
			where.append(" AND t1.XPIDDOCUMENTUM = ?");
			params.add(arbsoldoctele.getXpiddocumentum());
		}
		if (arbsoldoctele != null
				&& arbsoldoctele.getXpfechaaportacion() != null) {
			where.append(" AND t1.XPFECHAAPORTACION = ?");
			params.add(arbsoldoctele.getXpfechaaportacion());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpfechaentrada() != null) {
			where.append(" AND t1.XPFECHAENTRADA = ?");
			params.add(arbsoldoctele.getXpfechaentrada());
		}
		if (arbsoldoctele != null
				&& arbsoldoctele.getXpnumregistroentrada() != null) {
			where.append(" AND t1.XPNUMREGISTROENTRADA = ?");
			params.add(arbsoldoctele.getXpnumregistroentrada());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXprutapif() != null) {
			where.append(" AND t1.XPRUTAPIF = ?");
			params.add(arbsoldoctele.getXprutapif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbsoldoctele entity
	 * 
	 * @param arbsoldoctele
	 *            Arbsoldoctele Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbsoldoctele arbsoldoctele,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbsoldocteleDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbsoldoctele != null && arbsoldoctele.getXpid() != null) {
			where.append(" AND t1.XPID = ?");
			params.add(arbsoldoctele.getXpid());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolid() != null) {
			where.append(" AND t2.ARBSOLID = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolid());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdcod() != null) {
			where.append(" AND UPPER(t2.ARBHDCOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbhdcod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbhdcod()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBHDCOD IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdfec() != null) {
			where.append(" AND t2.ARBHDFEC = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdfec());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdcotsr() != null) {
			where.append(" AND UPPER(t2.ARBHDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbhdcotsr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbhdcotsr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBHDCOTSR IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdcaptso() != null) {
			where.append(" AND t2.ARBHDCAPTSO = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbhdcaptso());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbhdteso() != null) {
			where.append(" AND UPPER(t2.ARBHDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbhdteso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbhdteso()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBHDTESO IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsoltipnotif() != null) {
			where.append(" AND UPPER(t2.ARBSOLTIPNOTIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsoltipnotif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsoltipnotif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLTIPNOTIF IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolidioma() != null) {
			where.append(" AND UPPER(t2.ARBSOLIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsolidioma()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsolidioma()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLIDIOMA IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsoltelem() != null) {
			where.append(" AND UPPER(t2.ARBSOLTELEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsoltelem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsoltelem()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLTELEM IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolemail() != null) {
			where.append(" AND UPPER(t2.ARBSOLEMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsolemail()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsolemail()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLEMAIL IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolsms() != null) {
			where.append(" AND UPPER(t2.ARBSOLSMS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsolsms()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsolsms()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLSMS IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbfecalta() != null) {
			where.append(" AND t2.ARBFECALTA = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbfecalta());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolregen() != null) {
			where.append(" AND UPPER(t2.ARBSOLREGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsolregen()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsolregen()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLREGEN IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolfecregen() != null) {
			where.append(" AND t2.ARBSOLFECREGEN = ?");
			params.add(arbsoldoctele.getArbsoltele().getArbsolfecregen());
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolnif() != null) {
			where.append(" AND UPPER(t2.ARBSOLNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsolnif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsolnif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLNIF IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getArbsoltele() != null
				&& arbsoldoctele.getArbsoltele().getArbsolnombre() != null) {
			where.append(" AND UPPER(t2.ARBSOLNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getArbsoltele().getArbsolnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getArbsoltele().getArbsolnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ARBSOLNOMBRE IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpnofile() != null) {
			where.append(" AND UPPER(t1.XPNOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXpnofile().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoldoctele.getXpnofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XPNOFILE IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpsizefile() != null) {
			where.append(" AND t1.XPSIZEFILE = ?");
			params.add(arbsoldoctele.getXpsizefile());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXptedesfile() != null) {
			where.append(" AND UPPER(t1.XPTEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXptedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoldoctele.getXptedesfile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XPTEDESFILE IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getXporigen() != null) {
			where.append(" AND UPPER(t1.XPORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXporigen().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoldoctele.getXporigen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XPORIGEN IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpfecha() != null) {
			where.append(" AND t1.XPFECHA = ?");
			params.add(arbsoldoctele.getXpfecha());
		}
		if (arbsoldoctele != null
				&& arbsoldoctele.getXpcontenttypefile() != null) {
			where.append(" AND UPPER(t1.XPCONTENTTYPEFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXpcontenttypefile().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getXpcontenttypefile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XPCONTENTTYPEFILE IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpiddocumentum() != null) {
			where.append(" AND UPPER(t1.XPIDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXpiddocumentum().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getXpiddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.XPIDDOCUMENTUM IS NOT NULL");
		}
		if (arbsoldoctele != null
				&& arbsoldoctele.getXpfechaaportacion() != null) {
			where.append(" AND t1.XPFECHAAPORTACION = ?");
			params.add(arbsoldoctele.getXpfechaaportacion());
		}
		if (arbsoldoctele != null && arbsoldoctele.getXpfechaentrada() != null) {
			where.append(" AND t1.XPFECHAENTRADA = ?");
			params.add(arbsoldoctele.getXpfechaentrada());
		}
		if (arbsoldoctele != null
				&& arbsoldoctele.getXpnumregistroentrada() != null) {
			where.append(" AND UPPER(t1.XPNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXpnumregistroentrada()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ arbsoldoctele.getXpnumregistroentrada().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XPNUMREGISTROENTRADA IS NOT NULL");
		}
		if (arbsoldoctele != null && arbsoldoctele.getXprutapif() != null) {
			where.append(" AND UPPER(t1.XPRUTAPIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbsoldoctele.getXprutapif().toUpperCase() + "%");
			} else {
				params.add("%" + arbsoldoctele.getXprutapif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XPRUTAPIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * @return
	 */
	public void removeTelematicosAntiguas() {

		String query = "DELETE FROM ARBSOLDOCTELE WHERE EXISTS (SELECT 1 FROM ARBSOLTELE WHERE ARBSOLTELE.ARBSOLID=ARBSOLDOCTELE.XPARBSOLID AND ARBSOLTELE.ARBFECALTA+8<SYSDATE AND ARBSOLTELE.ARBSOLREGEN IS NULL )";

		this.jdbcTemplate.update(query);

	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
