package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbpropbandejaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbpropbandejaDaoImpl implements ArbpropbandejaDao {
	private JdbcTemplate jdbcTemplate;

	private RowMapper<Arbpropbandeja> rwMapDefecto = new RowMapper<Arbpropbandeja>() {
		public Arbpropbandeja mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Arbpropbandeja arbpropbandeja = new Arbpropbandeja(
					resultSet.getLong("BAPRARBID"),
					resultSet.getString("BAPRARBEXCODIGO"),
					resultSet.getString("BAPRARBPCODIGO"),
					resultSet.getString("BAPRARBEXCODCOMPLETO"),
					resultSet.getDate("BAPRARBFEC"),
					resultSet.getString("BAPRARBPROV"),
					resultSet.getString("BAPRARBRESPEXP"),
					resultSet.getString("BAPRARBMUNIC"),
					resultSet.getDate("BAPRARBFECALTA"),
					resultSet.getDate("BAPRARBFECMODIF"),
					resultSet.getString("BAPRARBUSUALTA"),
					resultSet.getString("BAPRARBUSUMODIF"));

			arbpropbandeja.setObservacionesString(Y41bUtils
					.clobToString(resultSet.getClob("BAPRARBOBSERV")));
			return arbpropbandeja;
		}
	};

	private RowMapper<String> rwMapReclamante = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new String(resultSet.getString("DTNOMBRE"));

		}
	};

	private RowMapper<String> rwMapUltimaFechaDecision = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			String lang = "";
			Locale locale = LocaleContextHolder.getLocale();
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				lang = Y41bConstantes.FORMATO_FECHA_ES;
			} else {
				lang = Y41bConstantes.FORMATO_FECHA_EU;
			}
			SimpleDateFormat sdf = new SimpleDateFormat(lang);
			return sdf.format(resultSet.getDate("HCFEDE"));
		}
	};

	private RowMapper<Arbpropbandeja> rwMapBandeja = new RowMapper<Arbpropbandeja>() {
		public Arbpropbandeja mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Establecimiento establecimiento = new Establecimiento(
					resultSet.getString("BAPRARBESTABLEC"));
			establecimiento.setEsnoco(resultSet.getString("ESNOCO"));

			CensoMonitor monitor = new CensoMonitor();
			monitor.setMocodigo(resultSet.getString("BAPRARBRESPEXP"));
			monitor.setMonombre(resultSet.getString("MONOMBRE"));

			TipoProcedimiento tipoproc = new TipoProcedimiento();
			tipoproc.setPcodigo(resultSet.getString("BAPRARBPCODIGO"));
			tipoproc.setPnombre(resultSet.getString("PNOMBRE"));
			tipoproc.setPnombree(resultSet.getString("PNOMBREE"));

			Arbpropbandeja arbpropbandeja = new Arbpropbandeja(
					resultSet.getLong("BAPRARBID"),
					resultSet.getString("BAPRARBEXCODIGO"),
					resultSet.getString("BAPRARBEXCODCOMPLETO"),
					resultSet.getDate("BAPRARBFEC"),
					resultSet.getString("TIENEOBSERV"),
					resultSet.getString("PROVDS_O"),
					resultSet.getString("MUNIPDS_O"),
					resultSet.getDate("BAPRARBFECALTA"),
					resultSet.getDate("BAPRARBFECMODIF"),
					resultSet.getString("BAPRARBUSUALTA"),
					resultSet.getString("BAPRARBUSUMODIF"), monitor,
					establecimiento, tipoproc, null, null);

			arbpropbandeja.setDtnombre(findReclamante(arbpropbandeja));
			arbpropbandeja
					.setEhfecharesolucion(findUltimaFechaDecision(arbpropbandeja));
			return arbpropbandeja;
		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return Arbpropbandeja
	 */
	public Arbpropbandeja add(Arbpropbandeja arbpropbandeja) {
		String query = "INSERT INTO ARBPROPBANDEJA (BAPRARBEXCODIGO, BAPRARBFEC, BAPRARBESTABLEC, BAPRARBPROV, BAPRARBMUNIC, BAPRARBRESPEXP, BAPRARBPCODIGO, BAPRARBEXCODCOMPLETO) VALUES (?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbpropbandeja.getBaprarbexcodigo(),
				arbpropbandeja.getBaprarbfec(), arbpropbandeja
						.getEstablecimiento().getEscodigo(), arbpropbandeja
						.getBaprarbprov(), arbpropbandeja.getBaprarbmunic(),
				arbpropbandeja.getBaprarbrespexp(), arbpropbandeja
						.getBaprarbpcodigo(), arbpropbandeja
						.getBaprarbexcodigocompleto());
		return arbpropbandeja;
	}

	/**
	 * Updates a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return Arbpropbandeja
	 */
	public Arbpropbandeja update(Arbpropbandeja arbpropbandeja) {
		String query = "UPDATE ARBPROPBANDEJA SET BAPRARBEXCODIGO=?, BAPRARBEXCODCOMPLETO=?, BAPRARBFEC=?, BAPRARBESTABLEC=?, BAPRARBPROV=?, BAPRARBMUNIC=?, BAPRARBRESPEXP=? WHERE BAPRARBID=?";
		this.jdbcTemplate.update(query, arbpropbandeja.getBaprarbexcodigo(),
				arbpropbandeja.getBaprarbexcodigocompleto(), arbpropbandeja
						.getBaprarbfec(), arbpropbandeja.getEstablecimiento()
						.getEscodigo(), arbpropbandeja.getBaprarbprov(),
				arbpropbandeja.getBaprarbmunic(), arbpropbandeja
						.getBaprarbrespexp(), arbpropbandeja.getBaprarbid());
		return arbpropbandeja;
	}

	/**
	 * Updates a single row in the Arbpropbandeja table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		try {
			String query = "UPDATE ARBPROPBANDEJA SET BAPRARBESTABLEC =? WHERE BAPRARBESTABLEC =? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {

		}
	}

	/**
	 * Finds a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return Arbpropbandeja
	 */
	@Transactional(readOnly = true)
	public Arbpropbandeja find(Arbpropbandeja arbpropbandeja) {
		String query = "SELECT t1.BAPRARBID BAPRARBID, t1.BAPRARBEXCODIGO BAPRARBEXCODIGO, t1.BAPRARBEXCODCOMPLETO BAPRARBEXCODCOMPLETO, t1.BAPRARBPCODIGO BAPRARBPCODIGO, t1.BAPRARBFEC BAPRARBFEC, t1.BAPRARBOBSERV BAPRARBOBSERV, t1.BAPRARBPROV BAPRARBPROV, t1.BAPRARBMUNIC BAPRARBMUNIC, t1.BAPRARBRESPEXP BAPRARBRESPEXP, t1.BAPRARBFECALTA BAPRARBFECALTA, t1.BAPRARBFECMODIF BAPRARBFECMODIF, t1.BAPRARBUSUALTA BAPRARBUSUALTA, t1.BAPRARBUSUMODIF BAPRARBUSUMODIF FROM ARBPROPBANDEJA t1  WHERE t1.BAPRARBID = ?  ";

		List<Arbpropbandeja> arbpropbandejaList = this.jdbcTemplate.query(
				query, this.rwMapDefecto, arbpropbandeja.getBaprarbid());
		return (Arbpropbandeja) DataAccessUtils
				.uniqueResult(arbpropbandejaList);
	}

	/**
	 * Finds a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findReclamante(Arbpropbandeja arbpropbandeja) {
		String reclamante = null;
		List<String> lreclamante;
		String query = "SELECT TRIM(TRIM(t2.NOMBRE) || ' ' || TRIM(t2.APELLIDO1) || ' ' || TRIM(t2.APELLIDO2)) AS DTNOMBRE FROM ARBPROPBANDEJA t1, INTERVINIENTES t2, CONSUMIDOR t3 WHERE t1.BAPRARBEXCODIGO=t2.HDCODIGO AND t2.DTCODIGO=T3.DTCODIGO AND t1.BAPRARBID = ?";

		lreclamante = this.jdbcTemplate.query(query, this.rwMapReclamante,
				arbpropbandeja.getBaprarbid());
		reclamante = (String) DataAccessUtils.uniqueResult(lreclamante);

		if (reclamante != null) {
			return reclamante;
		} else {
			query = "SELECT TRIM(TRIM(t4.DTNOMBRE) || ' ' || TRIM(t4.DTAPELLIDO1) || ' ' || TRIM(t4.DTAPELLIDO2)) AS DTNOMBRE FROM ARBPROPBANDEJA t1, HECHO_DENUNCIADO t2, DENUNCIA t3, CONSUMIDOR t4 WHERE t1.BAPRARBEXCODIGO=t2.HDCODIGO AND t2.HDCODE=t3.DECODIGO AND t3.DECODT=t4.DTCODIGO AND t1.BAPRARBID = ?";

			lreclamante = this.jdbcTemplate.query(query, this.rwMapReclamante,
					arbpropbandeja.getBaprarbid());
			reclamante = (String) DataAccessUtils.uniqueResult(lreclamante);
			return reclamante;
		}

	}

	/**
	 * Finds a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findUltimaFechaDecision(Arbpropbandeja arbpropbandeja) {
		String fechaDec = null;
		List<String> lfechaDec;
		String query = "SELECT HCFEDE FROM L21.L2125T00 WHERE HCCOHD=? ORDER BY HCFEDE DESC";

		lfechaDec = this.jdbcTemplate.query(query,
				this.rwMapUltimaFechaDecision,
				arbpropbandeja.getBaprarbexcodigo());

		if (lfechaDec != null && lfechaDec.size() > 0) {
			fechaDec = lfechaDec.get(0);
		}
		return fechaDec;
	}

	/**
	 * Removes a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return
	 */
	public void remove(Arbpropbandeja arbpropbandeja) {
		String query = "DELETE FROM ARBPROPBANDEJA WHERE BAPRARBID=?";
		this.jdbcTemplate.update(query, arbpropbandeja.getBaprarbid());
	}

	/**
	 * Removes a single row in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Pagination
	 * @return
	 */
	public void removeSolicitudes(Arbpropbandeja arbpropbandeja) {
		String query = "DELETE FROM ARBPROPBANDEJA WHERE BAPRARBEXCODIGO=?";
		this.jdbcTemplate.update(query, arbpropbandeja.getBaprarbexcodigo());
	}

	/**
	 * Finds a List of rows in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbpropbandeja> findAll(Arbpropbandeja arbpropbandeja,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.BAPRARBID BAPRARBID,t1.BAPRARBEXCODIGO BAPRARBEXCODIGO, t1.BAPRARBEXCODCOMPLETO BAPRARBEXCODCOMPLETO, "
						+ "(SELECT 'S' FROM ARBPROPBANDEJA T8 WHERE t1.BAPRARBID=t8.BAPRARBID AND dbms_lob.compare(nvl(T8.BAPRARBOBSERV, empty_clob()),empty_clob())<> 0) TIENEOBSERV,"
						+ "t1.BAPRARBPCODIGO BAPRARBPCODIGO, t1.BAPRARBESTABLEC BAPRARBESTABLEC, t1.BAPRARBFEC BAPRARBFEC,t2.ESNOCO ESNOCO,t1.BAPRARBPROV BAPRARBPROV,"
						+ "t1.BAPRARBMUNIC BAPRARBMUNIC, t4.DS_O MUNIPDS_O,t1.BAPRARBRESPEXP BAPRARBRESPEXP, T3.MONOMBRE MONOMBRE,t1.BAPRARBFECALTA BAPRARBFECALTA,"
						+ "t1.BAPRARBFECMODIF BAPRARBFECMODIF,t1.BAPRARBUSUALTA BAPRARBUSUALTA,t1.BAPRARBUSUMODIF BAPRARBUSUMODIF, T5.DS_O PROVDS_O, t6.PCODIGO PCODIGO,"
						+ " t6.PNOMBRE PNOMBRE, t6.PNOMBREE PNOMBREE ");
		query.append(" FROM ARBPROPBANDEJA t1, ESTABLECIMIENTO t2, CENSO_MONITOR t3, T17_MUNICIPIO t4, T17_PROVINCIA t5, TIPO_PROCEDIMIENTO t6, DECISION_HECHO t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbpropbandeja);
		StringBuilder where = new StringBuilder(
				"WHERE 1=1 AND t1.BAPRARBEXCODIGO=t7.HCCOHD(+) AND t1.BAPRARBESTABLEC= t2.ESCODIGO(+) AND t1.BAPRARBRESPEXP = t3.MOCODIGO(+) AND t1.BAPRARBMUNIC = t4.ID(+) AND t1.BAPRARBPROV = t5.ID(+) AND t1.BAPRARBPROV = t4.PROVINCIA_ID(+) AND t1.BAPRARBPCODIGO=t6.PCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbpropbandeja>) this.jdbcTemplate.query(query.toString(),
				this.rwMapBandeja, params.toArray());
	}

	/**
	 * Counts rows in the Arbpropbandeja table.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbpropbandeja arbpropbandeja) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBPROPBANDEJA t1, DECISION_HECHO t7  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbpropbandeja);
		StringBuilder where = new StringBuilder(
				"WHERE 1=1 AND t1.BAPRARBEXCODIGO=t7.HCCOHD(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbpropbandeja table using like.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbpropbandeja> findAllLike(Arbpropbandeja arbpropbandeja,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.BAPRARBID BAPRARBID,t1.BAPRARBEXCODIGO BAPRARBEXCODIGO, t1.BAPRARBEXCODCOMPLETO BAPRARBEXCODCOMPLETO, t1.BAPRARBPCODIGO BAPRARBPCODIGO, t1.BAPRARBFEC BAPRARBFEC,t1.BAPRARBOBSERV BAPRARBOBSERV,t1.BAPRARBPROV BAPRARBPROV, t1.BAPRARBMUNIC BAPRARBMUNIC,t1.BAPRARBRESPEXP BAPRARBRESPEXP,t1.BAPRARBFECALTA BAPRARBFECALTA,t1.BAPRARBFECMODIF BAPRARBFECMODIF,t1.BAPRARBUSUALTA BAPRARBUSUALTA,t1.BAPRARBUSUMODIF BAPRARBUSUMODIF ");
		query.append("FROM ARBPROPBANDEJA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbpropbandeja,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbpropbandeja>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDefecto, params.toArray());
	}

	/**
	 * Counts rows in the Arbpropbandeja table using like.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbpropbandeja arbpropbandeja,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBPROPBANDEJA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbpropbandeja,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbpropbandeja entity
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbpropbandeja arbpropbandeja) {

		StringBuilder where = new StringBuilder(
				ArbpropbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbpropbandeja != null && arbpropbandeja.getBaprarbid() != null) {
			where.append(" AND t1.BAPRARBID = ?");
			params.add(arbpropbandeja.getBaprarbid());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbexcodigo() != null) {
			where.append(" AND t1.BAPRARBEXCODIGO = ?");
			params.add(arbpropbandeja.getBaprarbexcodigo());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbexcodigocompleto() != null) {
			where.append(" AND t1.BAPRARBEXCODCOMPLETO = ?");
			params.add(arbpropbandeja.getBaprarbexcodigocompleto());
		}

		if (arbpropbandeja != null && arbpropbandeja.getBaprarbfec() != null) {
			where.append(" AND t1.BAPRARBFEC = ?");
			params.add(arbpropbandeja.getBaprarbfec());
		}
		if (arbpropbandeja != null && arbpropbandeja.getBaprarbprov() != null) {
			where.append(" AND t1.BAPRARBPROV = ?");
			params.add(arbpropbandeja.getBaprarbprov());
		}
		if (arbpropbandeja != null && arbpropbandeja.getBaprarbmunic() != null) {
			where.append(" AND t1.BAPRARBMUNIC = ?");
			params.add(arbpropbandeja.getBaprarbmunic());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbrespexp() != null) {
			where.append(" AND t1.BAPRARBRESPEXP = ?");
			params.add(arbpropbandeja.getBaprarbrespexp());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbfecalta() != null) {
			where.append(" AND t1.BAPRARBFECALTA = ?");
			params.add(arbpropbandeja.getBaprarbfecalta());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbfecmodif() != null) {
			where.append(" AND t1.BAPRARBFECMODIF = ?");
			params.add(arbpropbandeja.getBaprarbfecmodif());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbusualta() != null) {
			where.append(" AND t1.BAPRARBUSUALTA = ?");
			params.add(arbpropbandeja.getBaprarbusualta());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbusumodif() != null) {
			where.append(" AND t1.BAPRARBUSUMODIF = ?");
			params.add(arbpropbandeja.getBaprarbusumodif());
		}
		/*
		 * if (arbpropbandeja != null && arbpropbandeja.getCensoMonitor() !=
		 * null && arbpropbandeja.getCensoMonitor().getOrganismo() != null &&
		 * arbpropbandeja.getCensoMonitor().getOrganismo().getCodOrg() != null)
		 * { where.append(" AND (t7.HCCOOR is null OR t7.HCCOOR = ?)");
		 * params.add(arbpropbandeja.getCensoMonitor().getOrganismo()
		 * .getCodOrg()); }
		 */
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbpropbandeja entity
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbpropbandeja arbpropbandeja,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbpropbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbpropbandeja != null && arbpropbandeja.getBaprarbid() != null) {
			where.append(" AND t1.BAPRARBID = ?");
			params.add(arbpropbandeja.getBaprarbid());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbexcodigo() != null) {
			where.append(" AND UPPER(t1.BAPRARBEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbexcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbpropbandeja.getBaprarbexcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRARBEXCODIGO IS NOT NULL");
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbexcodigocompleto() != null) {
			where.append(" AND UPPER(t1.BAPRARBEXCODCOMPLETO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbexcodigocompleto()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ arbpropbandeja.getBaprarbexcodigocompleto()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.BAPRARBEXCODCOMPLETO IS NOT NULL");
		}
		if (arbpropbandeja != null && arbpropbandeja.getBaprarbfec() != null) {
			where.append(" AND t1.BAPRARBFEC = ?");
			params.add(arbpropbandeja.getBaprarbfec());
		}

		if (arbpropbandeja != null && arbpropbandeja.getBaprarbmunic() != null) {
			where.append(" AND UPPER(t1.BAPRARBMUNIC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbmunic().toUpperCase() + "%");
			} else {
				params.add("%" + arbpropbandeja.getBaprarbmunic().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRARBMUNIC IS NOT NULL");
		}
		if (arbpropbandeja != null && arbpropbandeja.getBaprarbprov() != null) {
			where.append(" AND UPPER(t1.BAPRARBPROV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbprov().toUpperCase() + "%");
			} else {
				params.add("%" + arbpropbandeja.getBaprarbprov().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRARBPROV IS NOT NULL");
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbrespexp() != null) {
			where.append(" AND UPPER(t1.BAPRARBRESPEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbrespexp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbpropbandeja.getBaprarbrespexp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRARBRESPEXP IS NOT NULL");
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbfecalta() != null) {
			where.append(" AND t1.BAPRARBFECALTA = ?");
			params.add(arbpropbandeja.getBaprarbfecalta());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbfecmodif() != null) {
			where.append(" AND t1.BAPRARBFECMODIF = ?");
			params.add(arbpropbandeja.getBaprarbfecmodif());
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbusualta() != null) {
			where.append(" AND UPPER(t1.BAPRARBUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbusualta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbpropbandeja.getBaprarbusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRARBUSUALTA IS NOT NULL");
		}
		if (arbpropbandeja != null
				&& arbpropbandeja.getBaprarbusumodif() != null) {
			where.append(" AND UPPER(t1.BAPRARBUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbpropbandeja.getBaprarbusumodif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbpropbandeja.getBaprarbusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.BAPRARBUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Removes a single row in the Arbpropbandeja table.
	 * 
	 * @param santramexp
	 *            Santramexp
	 * @return
	 */
	public void setObservaciones(Arbpropbandeja arbpropbandeja) {
		String query = "UPDATE ARBPROPBANDEJA SET BAPRARBOBSERV=? WHERE BAPRARBID=?";
		this.jdbcTemplate.update(query,
				Y41bUtils.clobToString(arbpropbandeja.getBaprarbobserv()),
				arbpropbandeja.getBaprarbid());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
