package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbnumsol;

/**
 * ArbnumsolDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbnumsolDaoImpl implements ArbnumsolDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbnumsol> rwMap = new RowMapper<Arbnumsol>() {
		public Arbnumsol mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbnumsol(resultSet.getString("ARBCOOR"),
					resultSet.getBigDecimal("ARBNRAN"),
					resultSet.getBigDecimal("ARBNROR"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Pagination
	 * @return Arbnumsol
	 */
	public Arbnumsol add(Arbnumsol arbnumsol) {
		String query = "INSERT INTO ARBNUMSOL (ARBCOOR, ARBNRAN, ARBNROR) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, arbnumsol.getArbcoor(),
				arbnumsol.getArbnran(), arbnumsol.getArbnror());
		return arbnumsol;
	}

	/**
	 * Updates a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Pagination
	 * @return Arbnumsol
	 */
	public Arbnumsol update(Arbnumsol arbnumsol) {
		String query = "UPDATE ARBNUMSOL SET  WHERE ARBCOOR=? AND ARBNRAN=? AND ARBNROR=?";
		this.jdbcTemplate.update(query, arbnumsol.getArbcoor(),
				arbnumsol.getArbnran(), arbnumsol.getArbnror());
		return arbnumsol;
	}

	/**
	 * Finds a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Pagination
	 * @return Arbnumsol
	 */
	@Transactional(readOnly = true)
	public Arbnumsol find(Arbnumsol arbnumsol) {
		String query = "SELECT t1.ARBCOOR ARBCOOR, t1.ARBNRAN ARBNRAN, t1.ARBNROR ARBNROR FROM ARBNUMSOL t1  WHERE t1.ARBCOOR = ?   AND t1.ARBNRAN = ?   AND t1.ARBNROR = ?  ";

		List<Arbnumsol> arbnumsolList = this.jdbcTemplate.query(query,
				this.rwMap, arbnumsol.getArbcoor(), arbnumsol.getArbnran(),
				arbnumsol.getArbnror());
		return (Arbnumsol) DataAccessUtils.uniqueResult(arbnumsolList);
	}

	/**
	 * Removes a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Pagination
	 * @return
	 */
	public void remove(Arbnumsol arbnumsol) {
		String query = "DELETE FROM ARBNUMSOL WHERE ARBCOOR=? AND ARBNRAN=? AND ARBNROR=?";
		this.jdbcTemplate.update(query, arbnumsol.getArbcoor(),
				arbnumsol.getArbnran(), arbnumsol.getArbnror());
	}

	/**
	 * Finds a List of rows in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbnumsol> findAll(Arbnumsol arbnumsol, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ARBCOOR ARBCOOR,t1.ARBNRAN ARBNRAN,t1.ARBNROR ARBNROR ");
		query.append("FROM ARBNUMSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbnumsol);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbnumsol>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbnumsol arbnumsol) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBNUMSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbnumsol);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbnumsol table using like.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbnumsol> findAllLike(Arbnumsol arbnumsol,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ARBCOOR ARBCOOR,t1.ARBNRAN ARBNRAN,t1.ARBNROR ARBNROR ");
		query.append("FROM ARBNUMSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbnumsol, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbnumsol>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbnumsol table using like.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbnumsol arbnumsol, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBNUMSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbnumsol, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbnumsol entity
	 * 
	 * @param arbnumsol
	 *            Arbnumsol Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbnumsol arbnumsol) {

		StringBuilder where = new StringBuilder(
				ArbnumsolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbnumsol != null && arbnumsol.getArbcoor() != null) {
			where.append(" AND t1.ARBCOOR = ?");
			params.add(arbnumsol.getArbcoor());
		}
		if (arbnumsol != null && arbnumsol.getArbnran() != null) {
			where.append(" AND t1.ARBNRAN = ?");
			params.add(arbnumsol.getArbnran());
		}
		if (arbnumsol != null && arbnumsol.getArbnror() != null) {
			where.append(" AND t1.ARBNROR = ?");
			params.add(arbnumsol.getArbnror());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbnumsol entity
	 * 
	 * @param arbnumsol
	 *            Arbnumsol Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbnumsol arbnumsol,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbnumsolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbnumsol != null && arbnumsol.getArbcoor() != null) {
			where.append(" AND UPPER(t1.ARBCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbnumsol.getArbcoor().toUpperCase() + "%");
			} else {
				params.add("%" + arbnumsol.getArbcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ARBCOOR IS NOT NULL");
		}
		if (arbnumsol != null && arbnumsol.getArbnran() != null) {
			where.append(" AND t1.ARBNRAN = ?");
			params.add(arbnumsol.getArbnran());
		}
		if (arbnumsol != null && arbnumsol.getArbnror() != null) {
			where.append(" AND t1.ARBNROR = ?");
			params.add(arbnumsol.getArbnror());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a single row in the Num_Solicitud table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return BigDecimal
	 */
	public BigDecimal findAndAddNumSolicitud(Arbnumsol arbnumsol) {
		String query = "SELECT NVL(MAX(ABS(ARBNROR)),0)+1 ARBNROR FROM ARBNUMSOL WHERE ARBCOOR = ? AND ARBNRAN = ? ";

		BigDecimal arbsolnror = new BigDecimal(this.jdbcTemplate.queryForLong(
				query, arbnumsol.getArbcoor(), arbnumsol.getArbnran()));

		query = "INSERT INTO ARBNUMSOL (ARBCOOR, ARBNRAN, ARBNROR) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, arbnumsol.getArbcoor(),
				arbnumsol.getArbnran(), arbsolnror);

		return arbsolnror;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
