package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.util.List;

import com.ejie.y41b.model.Arbnumsol;

/**
 * ArbnumsolDao  
 * 
 *  
 */

public interface ArbnumsolDao {

	/**
	 * Inserts a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @return Arbnumsol
	 */
	Arbnumsol add(Arbnumsol arbnumsol);

	/**
	 * Updates a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @return Arbnumsol
	 */
	Arbnumsol update(Arbnumsol arbnumsol);

	/**
	 * Finds a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @return Arbnumsol
	 */
	Arbnumsol find(Arbnumsol arbnumsol);

	/**
	 * Deletes a single row in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @return
	 */
	void remove(Arbnumsol arbnumsol);

	/**
	 * Finds a List of rows in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbnumsol> findAll(Arbnumsol arbnumsol, Pagination pagination);

	/**
	 * Counts rows in the Arbnumsol table.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @return Long
	 */
	Long findAllCount(Arbnumsol arbnumsol);

	/**
	 * Finds rows in the Arbnumsol table using like.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbnumsol> findAllLike(Arbnumsol arbnumsol, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbnumsol table using like.
	 * 
	 * @param arbnumsol
	 *            Arbnumsol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbnumsol arbnumsol, Boolean startsWith);

	/**
	 * Finds a single row in the Num_Solicitud table.
	 * 
	 * @param arbsoltele
	 *            Arbsoltele
	 * @return BigDecimal
	 */
	public BigDecimal findAndAddNumSolicitud(Arbnumsol arbnumsol);
}
