package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbnumadhreu;

/**
 * ArbnumadhreuDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbnumadhreuDaoImpl implements ArbnumadhreuDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbnumadhreu> rwMap = new RowMapper<Arbnumadhreu>() {
		public Arbnumadhreu mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbnumadhreu(resultSet.getBigDecimal("XXNUM"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Pagination
	 * @return Arbnumadhreu
	 */
	public Arbnumadhreu add(Arbnumadhreu arbnumadhreu) {
		String query = "INSERT INTO ARBNUMADHREU (XXNUM) VALUES (?)";
		this.jdbcTemplate.update(query, arbnumadhreu.getXxnum());
		return arbnumadhreu;
	}

	/**
	 * Updates a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Pagination
	 * @return Arbnumadhreu
	 */
	public Arbnumadhreu update(Arbnumadhreu arbnumadhreu) {
		String query = "UPDATE ARBNUMADHREU SET  WHERE XXNUM=?";
		this.jdbcTemplate.update(query, arbnumadhreu.getXxnum());
		return arbnumadhreu;
	}

	/**
	 * Finds a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Pagination
	 * @return Arbnumadhreu
	 */
	@Transactional(readOnly = true)
	public Arbnumadhreu find(Arbnumadhreu arbnumadhreu) {
		String query = "SELECT t1.XXNUM XXNUM FROM ARBNUMADHREU t1  WHERE t1.XXNUM = ?  ";

		List<Arbnumadhreu> arbnumadhreuList = this.jdbcTemplate.query(query,
				this.rwMap, arbnumadhreu.getXxnum());
		return (Arbnumadhreu) DataAccessUtils.uniqueResult(arbnumadhreuList);
	}

	/**
	 * Removes a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Pagination
	 * @return
	 */
	public void remove(Arbnumadhreu arbnumadhreu) {
		String query = "DELETE FROM ARBNUMADHREU WHERE XXNUM=?";
		this.jdbcTemplate.update(query, arbnumadhreu.getXxnum());
	}

	/**
	 * Obtener un codigo reutilizable.
	 * 
	 * @return int
	 */
	private int obtenerNumeroReutilizable() {
		String query1 = "SELECT XXNUM FROM ARBNUMADHREU WHERE ROWNUM=1 ORDER BY XXNUM ASC FOR UPDATE";
		int numAdh = 0;
		try {
			numAdh = this.jdbcTemplate.queryForInt(query1);
		} catch (Exception e) {
			numAdh = 0;
		}

		if (numAdh > 0) {
			String query2 = "DELETE FROM ARBNUMADHREU WHERE XXNUM=?";
			this.jdbcTemplate.update(query2, new BigDecimal(numAdh));
		}
		return numAdh;
	}

	/**
	 * @return int[]
	 */
	public int[] obtenerNumeroAdhesion() {
		int[] resultado = new int[2];
		int numeroReutilizable = obtenerNumeroReutilizable();
		if (numeroReutilizable == 0) {
			List<Object> params = new ArrayList<Object>();
			StringBuffer query = new StringBuffer(
					"SELECT L21XHQ01.NEXTVAL FROM  DUAL ");
			resultado[0] = this.jdbcTemplate.queryForInt(query.toString(),
					params.toArray());
			resultado[1] = 0;
			return resultado;
		} else {
			resultado[0] = numeroReutilizable;
			resultado[1] = 1;
			return resultado;
		}
	}

	/**
	 * Finds a List of rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbnumadhreu> findAll(Arbnumadhreu arbnumadhreu,
			Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.XXNUM XXNUM ");
		query.append("FROM ARBNUMADHREU t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbnumadhreu);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbnumadhreu>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbnumadhreu arbnumadhreu) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBNUMADHREU t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbnumadhreu);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbnumadhreu table using like.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbnumadhreu> findAllLike(Arbnumadhreu arbnumadhreu,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.XXNUM XXNUM ");
		query.append("FROM ARBNUMADHREU t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbnumadhreu,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbnumadhreu>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbnumadhreu table using like.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbnumadhreu arbnumadhreu, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBNUMADHREU t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbnumadhreu,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbnumadhreu entity
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbnumadhreu arbnumadhreu) {

		StringBuilder where = new StringBuilder(
				ArbnumadhreuDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbnumadhreu != null && arbnumadhreu.getXxnum() != null) {
			where.append(" AND t1.XXNUM = ?");
			params.add(arbnumadhreu.getXxnum());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbnumadhreu entity
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbnumadhreu arbnumadhreu,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbnumadhreuDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbnumadhreu != null && arbnumadhreu.getXxnum() != null) {
			where.append(" AND t1.XXNUM = ?");
			params.add(arbnumadhreu.getXxnum());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
