package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbnumadhreu;

/**
 * ArbnumadhreuDao  
 * 
 *  
 */

public interface ArbnumadhreuDao {

	/**
	 * Inserts a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Arbnumadhreu
	 */
	Arbnumadhreu add(Arbnumadhreu arbnumadhreu);

	/**
	 * Updates a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Arbnumadhreu
	 */
	Arbnumadhreu update(Arbnumadhreu arbnumadhreu);

	/**
	 * Finds a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Arbnumadhreu
	 */
	Arbnumadhreu find(Arbnumadhreu arbnumadhreu);

	/**
	 * Deletes a single row in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return
	 */
	void remove(Arbnumadhreu arbnumadhreu);

	/**
	 * @return int[]
	 */
	int[] obtenerNumeroAdhesion();

	/**
	 * Finds a List of rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbnumadhreu> findAll(Arbnumadhreu arbnumadhreu, Pagination pagination);

	/**
	 * Counts rows in the Arbnumadhreu table.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @return Long
	 */
	Long findAllCount(Arbnumadhreu arbnumadhreu);

	/**
	 * Finds rows in the Arbnumadhreu table using like.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbnumadhreu> findAllLike(Arbnumadhreu arbnumadhreu,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbnumadhreu table using like.
	 * 
	 * @param arbnumadhreu
	 *            Arbnumadhreu
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbnumadhreu arbnumadhreu, Boolean startsWith);
}
