package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbmotras;

/**
 * ArbmotrasDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class ArbmotrasDaoImpl implements ArbmotrasDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbmotras> rwMap = new RowMapper<Arbmotras>() {
		public Arbmotras mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Arbmotras(
               resultSet.getString("MTID"), resultSet.getString("MTDESCES"), resultSet.getString("MTDESCEU"), resultSet.getDate("MTFECALTA"), resultSet.getDate("MTFECMODIF"), resultSet.getString("MTUSUALTA"), resultSet.getString("MTUSUMODIF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Arbmotras table.
     *
     * @param arbmotras Pagination
     * @return Arbmotras
     */
	public Arbmotras add(Arbmotras arbmotras) {
    	String query = "INSERT INTO ARBMOTRAS (MTID, MTDESCES, MTDESCEU, MTFECALTA, MTFECMODIF, MTUSUALTA, MTUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbmotras.getMtid(), arbmotras.getMtdesces(), arbmotras.getMtdesceu(), arbmotras.getMtfecalta(), arbmotras.getMtfecmodif(), arbmotras.getMtusualta(), arbmotras.getMtusumodif());
		return arbmotras;
	}

    /**
     * Updates a single row in the Arbmotras table.
     *
     * @param arbmotras Pagination
     * @return Arbmotras
     */
    public Arbmotras update(Arbmotras arbmotras) {
		String query = "UPDATE ARBMOTRAS SET MTDESCES=?, MTDESCEU=?, MTFECALTA=?, MTFECMODIF=?, MTUSUALTA=?, MTUSUMODIF=? WHERE MTID=?";
		this.jdbcTemplate.update(query, arbmotras.getMtdesces(), arbmotras.getMtdesceu(), arbmotras.getMtfecalta(), arbmotras.getMtfecmodif(), arbmotras.getMtusualta(), arbmotras.getMtusumodif(), arbmotras.getMtid());
		return arbmotras;
	}

    /**
     * Finds a single row in the Arbmotras table.
     *
     * @param arbmotras Pagination
     * @return Arbmotras
     */
    @Transactional (readOnly = true)
    public Arbmotras find(Arbmotras arbmotras) {
		String query = "SELECT t1.MTID MTID, t1.MTDESCES MTDESCES, t1.MTDESCEU MTDESCEU, t1.MTFECALTA MTFECALTA, t1.MTFECMODIF MTFECMODIF, t1.MTUSUALTA MTUSUALTA, t1.MTUSUMODIF MTUSUMODIF FROM ARBMOTRAS t1  WHERE t1.MTID = ?  ";
		
		List<Arbmotras> arbmotrasList = this.jdbcTemplate.query(query, this.rwMap, arbmotras.getMtid());
		return (Arbmotras) DataAccessUtils.uniqueResult(arbmotrasList);
    }

    /**
     * Removes a single row in the Arbmotras table.
     *
     * @param arbmotras Pagination
     * @return
     */
    public void remove(Arbmotras arbmotras) {
		String query = "DELETE FROM ARBMOTRAS WHERE MTID=?";
		this.jdbcTemplate.update(query, arbmotras.getMtid());
    }
    
   /**
    * Finds a List of rows in the Arbmotras table.
    * 
    * @param arbmotras Arbmotras
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Arbmotras> findAll(Arbmotras arbmotras, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.MTID MTID,t1.MTDESCES MTDESCES,t1.MTDESCEU MTDESCEU,t1.MTFECALTA MTFECALTA,t1.MTFECMODIF MTFECMODIF,t1.MTUSUALTA MTUSUALTA,t1.MTUSUMODIF MTUSUMODIF "); 
		query.append("FROM ARBMOTRAS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbmotras); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Arbmotras>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Arbmotras table.
     * 
     * @param arbmotras Arbmotras
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Arbmotras arbmotras) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBMOTRAS t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbmotras); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Arbmotras table using like.
     * 
     * @param arbmotras Arbmotras
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Arbmotras> findAllLike(Arbmotras arbmotras, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.MTID MTID,t1.MTDESCES MTDESCES,t1.MTDESCEU MTDESCEU,t1.MTFECALTA MTFECALTA,t1.MTFECMODIF MTFECMODIF,t1.MTUSUALTA MTUSUALTA,t1.MTUSUMODIF MTUSUMODIF "); 
        query.append("FROM ARBMOTRAS t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbmotras,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Arbmotras>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Arbmotras table using like.
     * 
     * @param arbmotras Arbmotras
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Arbmotras arbmotras, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBMOTRAS t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbmotras,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Arbmotras entity 
	 * 
	 * @param arbmotras Arbmotras
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Arbmotras arbmotras){
		
		StringBuilder where = new StringBuilder(ArbmotrasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbmotras  != null  && arbmotras.getMtid() != null ) {
			where.append(" AND t1.MTID = ?");
			params.add(arbmotras.getMtid());
		}
		if (arbmotras  != null  && arbmotras.getMtdesces() != null ) {
			where.append(" AND t1.MTDESCES = ?");
			params.add(arbmotras.getMtdesces());
		}
		if (arbmotras  != null  && arbmotras.getMtdesceu() != null ) {
			where.append(" AND t1.MTDESCEU = ?");
			params.add(arbmotras.getMtdesceu());
		}
		if (arbmotras  != null  && arbmotras.getMtfecalta() != null ) {
			where.append(" AND t1.MTFECALTA = ?");
			params.add(arbmotras.getMtfecalta());
		}
		if (arbmotras  != null  && arbmotras.getMtfecmodif() != null ) {
			where.append(" AND t1.MTFECMODIF = ?");
			params.add(arbmotras.getMtfecmodif());
		}
		if (arbmotras  != null  && arbmotras.getMtusualta() != null ) {
			where.append(" AND t1.MTUSUALTA = ?");
			params.add(arbmotras.getMtusualta());
		}
		if (arbmotras  != null  && arbmotras.getMtusumodif() != null ) {
			where.append(" AND t1.MTUSUMODIF = ?");
			params.add(arbmotras.getMtusumodif());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Arbmotras entity 
	 * 
	 * @param arbmotras Arbmotras
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Arbmotras arbmotras, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(ArbmotrasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbmotras  != null  && arbmotras.getMtid() != null ) {
			where.append(" AND UPPER(t1.MTID) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmotras.getMtid().toUpperCase() +"%");
			}else{
				params.add("%"+arbmotras.getMtid().toUpperCase() +"%");
			}
			where.append(" AND t1.MTID IS NOT NULL");
	     }			
		if (arbmotras  != null  && arbmotras.getMtdesces() != null ) {
			where.append(" AND UPPER(t1.MTDESCES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmotras.getMtdesces().toUpperCase() +"%");
			}else{
				params.add("%"+arbmotras.getMtdesces().toUpperCase() +"%");
			}
			where.append(" AND t1.MTDESCES IS NOT NULL");
	     }			
		if (arbmotras  != null  && arbmotras.getMtdesceu() != null ) {
			where.append(" AND UPPER(t1.MTDESCEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmotras.getMtdesceu().toUpperCase() +"%");
			}else{
				params.add("%"+arbmotras.getMtdesceu().toUpperCase() +"%");
			}
			where.append(" AND t1.MTDESCEU IS NOT NULL");
	     }			
		if (arbmotras  != null  && arbmotras.getMtfecalta() != null ) {
			where.append(" AND t1.MTFECALTA = ?");
			params.add(arbmotras.getMtfecalta());
	     }			
		if (arbmotras  != null  && arbmotras.getMtfecmodif() != null ) {
			where.append(" AND t1.MTFECMODIF = ?");
			params.add(arbmotras.getMtfecmodif());
	     }			
		if (arbmotras  != null  && arbmotras.getMtusualta() != null ) {
			where.append(" AND UPPER(t1.MTUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmotras.getMtusualta().toUpperCase() +"%");
			}else{
				params.add("%"+arbmotras.getMtusualta().toUpperCase() +"%");
			}
			where.append(" AND t1.MTUSUALTA IS NOT NULL");
	     }			
		if (arbmotras  != null  && arbmotras.getMtusumodif() != null ) {
			where.append(" AND UPPER(t1.MTUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmotras.getMtusumodif().toUpperCase() +"%");
			}else{
				params.add("%"+arbmotras.getMtusumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.MTUSUMODIF IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

