package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbmotras;

/**
 * ArbmotrasDao  
 *  
 */

public interface ArbmotrasDao {
    
    /**
     * Inserts a single row in the Arbmotras table.
     *
     * @param arbmotras Arbmotras
     * @return Arbmotras
     */
    Arbmotras add(Arbmotras arbmotras);

    /**
     * Updates a single row in the Arbmotras table.
     *
     * @param arbmotras Arbmotras
     * @return Arbmotras
     */
    Arbmotras update(Arbmotras arbmotras);

    /**
     * Finds a single row in the Arbmotras table.
     *
     * @param arbmotras Arbmotras
     * @return Arbmotras
     */
    Arbmotras find(Arbmotras arbmotras);

    /**
     * Deletes a single row in the Arbmotras table.
     *
     * @param arbmotras Arbmotras
     * @return 
     */
    void remove(Arbmotras arbmotras);

    /**
     * Finds a List of rows in the Arbmotras table.
     *
     * @param arbmotras Arbmotras
     * @param pagination Pagination
     * @return List
     */
    List<Arbmotras> findAll(Arbmotras arbmotras, Pagination pagination);

    /**
     * Counts rows in the Arbmotras table.
     *
     * @param arbmotras Arbmotras
     * @return Long
     */
    Long findAllCount(Arbmotras arbmotras);
	
	/**
     * Finds rows in the Arbmotras table using like.
     *
     * @param arbmotras Arbmotras
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Arbmotras> findAllLike(Arbmotras arbmotras, Pagination pagination, Boolean startsWith);
	
    /**
     * Counts rows in the Arbmotras table using like.
     *
     * @param arbmotras Arbmotras
     * @param startsWith Boolean
     * @return Long
     */
    Long findAllLikeCount(Arbmotras arbmotras, Boolean startsWith);
}

