package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbmonol;

/**
 * ArbmonolDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class ArbmonolDaoImpl implements ArbmonolDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbmonol> rwMap = new RowMapper<Arbmonol>() {
		public Arbmonol mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Arbmonol(
               resultSet.getString("MNID"), resultSet.getString("MNDESCES"), resultSet.getString("MNDESCEU"), resultSet.getDate("MNFECALTA"), resultSet.getDate("MNFECMODIF"), resultSet.getString("MNUSUALTA"), resultSet.getString("MNUSUMODIF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Arbmonol table.
     *
     * @param arbmonol Pagination
     * @return Arbmonol
     */
	public Arbmonol add(Arbmonol arbmonol) {
    	String query = "INSERT INTO ARBMONOL (MNID, MNDESCES, MNDESCEU, MNFECALTA, MNFECMODIF, MNUSUALTA, MNUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbmonol.getMnid(), arbmonol.getMndesces(), arbmonol.getMndesceu(), arbmonol.getMnfecalta(), arbmonol.getMnfecmodif(), arbmonol.getMnusualta(), arbmonol.getMnusumodif());
		return arbmonol;
	}

    /**
     * Updates a single row in the Arbmonol table.
     *
     * @param arbmonol Pagination
     * @return Arbmonol
     */
    public Arbmonol update(Arbmonol arbmonol) {
		String query = "UPDATE ARBMONOL SET MNDESCES=?, MNDESCEU=?, MNFECALTA=?, MNFECMODIF=?, MNUSUALTA=?, MNUSUMODIF=? WHERE MNID=?";
		this.jdbcTemplate.update(query, arbmonol.getMndesces(), arbmonol.getMndesceu(), arbmonol.getMnfecalta(), arbmonol.getMnfecmodif(), arbmonol.getMnusualta(), arbmonol.getMnusumodif(), arbmonol.getMnid());
		return arbmonol;
	}

    /**
     * Finds a single row in the Arbmonol table.
     *
     * @param arbmonol Pagination
     * @return Arbmonol
     */
    @Transactional (readOnly = true)
    public Arbmonol find(Arbmonol arbmonol) {
		String query = "SELECT t1.MNID MNID, t1.MNDESCES MNDESCES, t1.MNDESCEU MNDESCEU, t1.MNFECALTA MNFECALTA, t1.MNFECMODIF MNFECMODIF, t1.MNUSUALTA MNUSUALTA, t1.MNUSUMODIF MNUSUMODIF FROM ARBMONOL t1  WHERE t1.MNID = ?  ";
		
		List<Arbmonol> arbmonolList = this.jdbcTemplate.query(query, this.rwMap, arbmonol.getMnid());
		return (Arbmonol) DataAccessUtils.uniqueResult(arbmonolList);
    }

    /**
     * Removes a single row in the Arbmonol table.
     *
     * @param arbmonol Pagination
     * @return
     */
    public void remove(Arbmonol arbmonol) {
		String query = "DELETE FROM ARBMONOL WHERE MNID=?";
		this.jdbcTemplate.update(query, arbmonol.getMnid());
    }
    
   /**
    * Finds a List of rows in the Arbmonol table.
    * 
    * @param arbmonol Arbmonol
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Arbmonol> findAll(Arbmonol arbmonol, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.MNID MNID,t1.MNDESCES MNDESCES,t1.MNDESCEU MNDESCEU,t1.MNFECALTA MNFECALTA,t1.MNFECMODIF MNFECMODIF,t1.MNUSUALTA MNUSUALTA,t1.MNUSUMODIF MNUSUMODIF "); 
		query.append("FROM ARBMONOL t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbmonol); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Arbmonol>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Arbmonol table.
     * 
     * @param arbmonol Arbmonol
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Arbmonol arbmonol) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBMONOL t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbmonol); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Arbmonol table using like.
     * 
     * @param arbmonol Arbmonol
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Arbmonol> findAllLike(Arbmonol arbmonol, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.MNID MNID,t1.MNDESCES MNDESCES,t1.MNDESCEU MNDESCEU,t1.MNFECALTA MNFECALTA,t1.MNFECMODIF MNFECMODIF,t1.MNUSUALTA MNUSUALTA,t1.MNUSUMODIF MNUSUMODIF "); 
        query.append("FROM ARBMONOL t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbmonol,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Arbmonol>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Arbmonol table using like.
     * 
     * @param arbmonol Arbmonol
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Arbmonol arbmonol, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBMONOL t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbmonol,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Arbmonol entity 
	 * 
	 * @param arbmonol Arbmonol
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Arbmonol arbmonol){
		
		StringBuilder where = new StringBuilder(ArbmonolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbmonol  != null  && arbmonol.getMnid() != null ) {
			where.append(" AND t1.MNID = ?");
			params.add(arbmonol.getMnid());
		}
		if (arbmonol  != null  && arbmonol.getMndesces() != null ) {
			where.append(" AND t1.MNDESCES = ?");
			params.add(arbmonol.getMndesces());
		}
		if (arbmonol  != null  && arbmonol.getMndesceu() != null ) {
			where.append(" AND t1.MNDESCEU = ?");
			params.add(arbmonol.getMndesceu());
		}
		if (arbmonol  != null  && arbmonol.getMnfecalta() != null ) {
			where.append(" AND t1.MNFECALTA = ?");
			params.add(arbmonol.getMnfecalta());
		}
		if (arbmonol  != null  && arbmonol.getMnfecmodif() != null ) {
			where.append(" AND t1.MNFECMODIF = ?");
			params.add(arbmonol.getMnfecmodif());
		}
		if (arbmonol  != null  && arbmonol.getMnusualta() != null ) {
			where.append(" AND t1.MNUSUALTA = ?");
			params.add(arbmonol.getMnusualta());
		}
		if (arbmonol  != null  && arbmonol.getMnusumodif() != null ) {
			where.append(" AND t1.MNUSUMODIF = ?");
			params.add(arbmonol.getMnusumodif());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Arbmonol entity 
	 * 
	 * @param arbmonol Arbmonol
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Arbmonol arbmonol, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(ArbmonolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbmonol  != null  && arbmonol.getMnid() != null ) {
			where.append(" AND UPPER(t1.MNID) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmonol.getMnid().toUpperCase() +"%");
			}else{
				params.add("%"+arbmonol.getMnid().toUpperCase() +"%");
			}
			where.append(" AND t1.MNID IS NOT NULL");
	     }			
		if (arbmonol  != null  && arbmonol.getMndesces() != null ) {
			where.append(" AND UPPER(t1.MNDESCES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmonol.getMndesces().toUpperCase() +"%");
			}else{
				params.add("%"+arbmonol.getMndesces().toUpperCase() +"%");
			}
			where.append(" AND t1.MNDESCES IS NOT NULL");
	     }			
		if (arbmonol  != null  && arbmonol.getMndesceu() != null ) {
			where.append(" AND UPPER(t1.MNDESCEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmonol.getMndesceu().toUpperCase() +"%");
			}else{
				params.add("%"+arbmonol.getMndesceu().toUpperCase() +"%");
			}
			where.append(" AND t1.MNDESCEU IS NOT NULL");
	     }			
		if (arbmonol  != null  && arbmonol.getMnfecalta() != null ) {
			where.append(" AND t1.MNFECALTA = ?");
			params.add(arbmonol.getMnfecalta());
	     }			
		if (arbmonol  != null  && arbmonol.getMnfecmodif() != null ) {
			where.append(" AND t1.MNFECMODIF = ?");
			params.add(arbmonol.getMnfecmodif());
	     }			
		if (arbmonol  != null  && arbmonol.getMnusualta() != null ) {
			where.append(" AND UPPER(t1.MNUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmonol.getMnusualta().toUpperCase() +"%");
			}else{
				params.add("%"+arbmonol.getMnusualta().toUpperCase() +"%");
			}
			where.append(" AND t1.MNUSUALTA IS NOT NULL");
	     }			
		if (arbmonol  != null  && arbmonol.getMnusumodif() != null ) {
			where.append(" AND UPPER(t1.MNUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbmonol.getMnusumodif().toUpperCase() +"%");
			}else{
				params.add("%"+arbmonol.getMnusumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.MNUSUMODIF IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

