package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbitroDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ArbitroDaoImpl implements ArbitroDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbitro> rwMap = new RowMapper<Arbitro>() {
		public Arbitro mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Arbitro arbitro = new Arbitro(resultSet.getString("ARCODIGO"),
					resultSet.getString("ARINCOES"),
					resultSet.getString("ARNIF"),
					resultSet.getString("ARNOMBRE"),
					resultSet.getString("ARNODIR"),
					resultSet.getString("ARCOLO"),
					resultSet.getString("ARNOLO"),
					resultSet.getString("ARNRCOPO"),
					resultSet.getString("ARCOPV"),
					resultSet.getString("ARNOPV"),
					resultSet.getString("ARNRTEL"),
					resultSet.getString("ARNRTEL2"),
					resultSet.getString("ARNRFAX"),
					resultSet.getString("ARTEEM"),
					resultSet.getString("ARTEURL"),
					resultSet.getString("ARNODIRC"),
					resultSet.getString("ARCOLOC"),
					resultSet.getString("ARNOLOC"),
					resultSet.getString("ARNRCOPOC"),
					resultSet.getString("ARCOPVC"),
					resultSet.getString("ARNOPVC"),
					resultSet.getString("ARNRTELC"),
					resultSet.getString("ARNRTEL2C"),
					resultSet.getString("ARNRFAXC"),
					resultSet.getString("ARTEEMC"),
					resultSet.getString("ARTEURLC"),
					resultSet.getString("ARINDICO"),
					resultSet.getDate("ARFEAC"), resultSet.getDate("ARFEBA"),
					resultSet.getString("ARTEOBS"),
					resultSet.getString("ARCOJA"),
					resultSet.getString("ARCOZS"),
					resultSet.getString("ARFEMOD"),
					resultSet.getString("ARNOMBREC"),
					resultSet.getString("ARINPF"),
					resultSet.getString("ARLICENCIADO"),
					resultSet.getString("ARIDIOMA"),
					resultSet.getString("ARPROVID"),
					resultSet.getString("ARMUNID"),
					resultSet.getString("ARLOCID"),
					resultSet.getString("ARCALLEID"),
					resultSet.getString("ARPORTALID"),
					resultSet.getString("ARPROVCID"),
					resultSet.getString("ARMUNCID"),
					resultSet.getString("ARLOCCID"),
					resultSet.getString("ARCALLECID"),
					resultSet.getString("ARPORTALCID"),
					resultSet.getDate("ARFECALTA"),
					resultSet.getString("ARUSUALTA"),
					resultSet.getString("ARTERCERO"));
			arbitro.setArnoentidadEs(resultSet.getString("ARNOENTIDADES"));
			arbitro.setArnoentidadEu(resultSet.getString("ARNOENTIDADEU"));
			arbitro.setArnombrePiso(resultSet.getString("ARNOMBRE_PISO"));
			arbitro.setArnombrecPiso(resultSet.getString("ARNOMBREC_PISO"));
			arbitro.setArnombreCp(resultSet.getString("ARNOMBRE_CP"));
			arbitro.setArnombrecCp(resultSet.getString("ARNOMBREC_CP"));
			return arbitro;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Pagination
	 * @return Arbitro
	 */
	public Arbitro add(Arbitro arbitro) {
		String query = "INSERT INTO ARBITRO (ARCODIGO, ARINCOES, ARNIF, ARNOMBRE, ARNODIR, ARCOLO, ARNOLO, ARNRCOPO, ARCOPV, ARNOPV, ARNRTEL, ARNRTEL2, ARNRFAX, ARTEEM, ARTEURL, ARNODIRC, ARCOLOC, ARNOLOC, ARNRCOPOC, ARCOPVC, ARNOPVC, ARNRTELC, ARNRTEL2C, ARNRFAXC, ARTEEMC, ARTEURLC, ARINDICO, ARFEAC, ARFEBA, ARTEOBS, ARCOJA, ARCOZS, ARFEMOD, ARNOMBREC, ARINPF, ARLICENCIADO, ARIDIOMA, ARPROV_ID, ARMUN_ID, ARLOC_ID, ARCALLE_ID, ARPORTAL_ID, ARPROVC_ID, ARMUNC_ID, ARLOCC_ID, ARCALLEC_ID, ARPORTALC_ID, ARFECALTA, ARUSUALTA, ARTERCERO, ARNOMBRE_CP, ARNOMBRE_PISO, ARNOMBREC_CP, ARNOMBREC_PISO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbitro.getArcodigo(),
				arbitro.getArincoes(), arbitro.getArnif(),
				arbitro.getArnombre(), arbitro.getArnodir(),
				arbitro.getArcolo(), arbitro.getArnolo(),
				arbitro.getArnrcopo(), arbitro.getArcopv(),
				arbitro.getArnopv(), arbitro.getArnrtel(),
				arbitro.getArnrtel2(), arbitro.getArnrfax(),
				arbitro.getArteem(), arbitro.getArteurl(),
				arbitro.getArnodirc(), arbitro.getArcoloc(),
				arbitro.getArnoloc(), arbitro.getArnrcopoc(),
				arbitro.getArcopvc(), arbitro.getArnopvc(),
				arbitro.getArnrtelc(), arbitro.getArnrtel2c(),
				arbitro.getArnrfaxc(), arbitro.getArteemc(),
				arbitro.getArteurlc(), arbitro.getArindico(),
				arbitro.getArfeac(), arbitro.getArfeba(), arbitro.getArteobs(),
				arbitro.getArcoja(), arbitro.getArcozs(), arbitro.getArfemod(),
				arbitro.getArnombrec(), arbitro.getArinpf(),
				arbitro.getArlicenciado(), arbitro.getAridioma(),
				arbitro.getArprovId(), arbitro.getArmunId(),
				arbitro.getArlocId(), arbitro.getArcalleId(),
				arbitro.getArportalId(), arbitro.getArprovcId(),
				arbitro.getArmuncId(), arbitro.getArloccId(),
				arbitro.getArcallecId(), arbitro.getArportalcId(),
				arbitro.getArfecalta(), arbitro.getArusualta(),
				arbitro.getArtercero(), arbitro.getArnombreCp(),
				arbitro.getArnombrePiso(), arbitro.getArnombrecCp(),
				arbitro.getArnombrecPiso());
		return arbitro;
	}

	/**
	 * Updates a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Pagination
	 * @return Arbitro
	 */
	public Arbitro update(Arbitro arbitro) {
		String query = "UPDATE ARBITRO SET ARINCOES=?, ARNIF=?, ARNOMBRE=?, /*ARNODIR=?, ARCOLO=?, ARNOLO=?, ARNRCOPO=?, ARCOPV=?, ARNOPV=?,*/ ARNRTEL=?, ARNRTEL2=?, ARNRFAX=?, ARTEEM=?, ARTEURL=?,/* ARNODIRC=?, ARCOLOC=?, ARNOLOC=?, ARNRCOPOC=?, ARCOPVC=?, ARNOPVC=?,*/ ARNRTELC=?, ARNRTEL2C=?, ARNRFAXC=?, ARTEEMC=?, ARTEURLC=?, ARINDICO=?, ARFEAC=?, ARFEBA=?, ARTEOBS=?, ARCOJA=?, ARNOMBREC=?, ARINPF=?, ARLICENCIADO=?, ARIDIOMA=?, ARPROV_ID=?, ARMUN_ID=?, ARLOC_ID=?, ARCALLE_ID=?, ARPORTAL_ID=?, ARPROVC_ID=?, ARMUNC_ID=?, ARLOCC_ID=?, ARCALLEC_ID=?, ARPORTALC_ID=?, ARTERCERO=?, ARNOMBRE_CP=?, ARNOMBRE_PISO=?, ARNOMBREC_CP=?, ARNOMBREC_PISO=? WHERE ARCODIGO=?";
		this.jdbcTemplate.update(query, arbitro.getArincoes(),
				arbitro.getArnif(), arbitro.getArnombre(),
				/*
				 * arbitro.getArnodir(), arbitro.getArcolo(),
				 * arbitro.getArnolo(), arbitro.getArnrcopo(),
				 * arbitro.getArcopv(), arbitro.getArnopv(),
				 */arbitro.getArnrtel(), arbitro.getArnrtel2(),
				arbitro.getArnrfax(), arbitro.getArteem(),
				arbitro.getArteurl(),
				/*
				 * arbitro.getArnodirc(), arbitro.getArcoloc(),
				 * arbitro.getArnoloc(), arbitro.getArnrcopoc(),
				 * arbitro.getArcopvc(), arbitro.getArnopvc(),
				 */
				arbitro.getArnrtelc(), arbitro.getArnrtel2c(),
				arbitro.getArnrfaxc(), arbitro.getArteemc(),
				arbitro.getArteurlc(), arbitro.getArindico(),
				arbitro.getArfeac(), arbitro.getArfeba(), arbitro.getArteobs(),
				arbitro.getArcoja(), arbitro.getArnombrec(),
				arbitro.getArinpf(), arbitro.getArlicenciado(),
				arbitro.getAridioma(), arbitro.getArprovId(),
				arbitro.getArmunId(), arbitro.getArlocId(),
				arbitro.getArcalleId(), arbitro.getArportalId(),
				arbitro.getArprovcId(), arbitro.getArmuncId(),
				arbitro.getArloccId(), arbitro.getArcallecId(),
				arbitro.getArportalcId(), arbitro.getArtercero(),
				arbitro.getArnombreCp(), arbitro.getArnombrePiso(),
				arbitro.getArnombrecCp(), arbitro.getArnombrecPiso(),
				arbitro.getArcodigo());
		return arbitro;
	}

	/**
	 * Finds a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Pagination
	 * @return Arbitro
	 */
	@Transactional(readOnly = true)
	public Arbitro find(Arbitro arbitro) {
		String query = "SELECT t1.ARCODIGO ARCODIGO, t1.ARINCOES ARINCOES, t1.ARNIF ARNIF, t1.ARNOMBRE ARNOMBRE, t1.ARNODIR ARNODIR, t1.ARCOLO ARCOLO, t1.ARNOLO ARNOLO, t1.ARNRCOPO ARNRCOPO, t1.ARCOPV ARCOPV, t1.ARNOPV ARNOPV, t1.ARNRTEL ARNRTEL, t1.ARNRTEL2 ARNRTEL2, t1.ARNRFAX ARNRFAX, t1.ARTEEM ARTEEM, t1.ARTEURL ARTEURL, t1.ARNODIRC ARNODIRC, t1.ARCOLOC ARCOLOC, t1.ARNOLOC ARNOLOC, t1.ARNRCOPOC ARNRCOPOC, t1.ARCOPVC ARCOPVC, t1.ARNOPVC ARNOPVC, t1.ARNRTELC ARNRTELC, t1.ARNRTEL2C ARNRTEL2C, t1.ARNRFAXC ARNRFAXC, t1.ARTEEMC ARTEEMC, t1.ARTEURLC ARTEURLC, t1.ARINDICO ARINDICO, t1.ARFEAC ARFEAC, t1.ARFEBA ARFEBA, t1.ARTEOBS ARTEOBS, t1.ARCOJA ARCOJA, t2.USUARIOXLNET ARCOZS, t1.ARFEMOD ARFEMOD, t1.ARNOMBREC ARNOMBREC, t1.ARINPF ARINPF, t1.ARLICENCIADO ARLICENCIADO, t1.ARIDIOMA ARIDIOMA, t1.ARPROV_ID ARPROVID, t1.ARMUN_ID ARMUNID, t1.ARLOC_ID ARLOCID, t1.ARCALLE_ID ARCALLEID, t1.ARPORTAL_ID ARPORTALID, t1.ARPROVC_ID ARPROVCID, t1.ARMUNC_ID ARMUNCID, t1.ARLOCC_ID ARLOCCID, t1.ARCALLEC_ID ARCALLECID, t1.ARPORTALC_ID ARPORTALCID, t1.ARFECALTA ARFECALTA, t1.ARUSUALTA ARUSUALTA,t1.ARTERCERO ARTERCERO, '' ARNOENTIDADES, '' ARNOENTIDADEU, ARNOMBRE_CP, ARNOMBRE_PISO, ARNOMBREC_CP, ARNOMBREC_PISO FROM ARBITRO t1,CENSO_MONITOR t2 WHERE t1.ARCOZS=t2.MOCODIGO(+) AND t1.ARCODIGO = ?  ";

		List<Arbitro> arbitroList = this.jdbcTemplate.query(query, this.rwMap,
				arbitro.getArcodigo());
		return (Arbitro) DataAccessUtils.uniqueResult(arbitroList);
	}

	/**
	 * Removes a single row in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Pagination
	 * @return
	 */
	public void remove(Arbitro arbitro) {
		String query = "DELETE FROM ARBITRO WHERE ARCODIGO=?";
		this.jdbcTemplate.update(query, arbitro.getArcodigo());
	}

	/**
	 * Finds a List of rows in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbitro> findAll(Arbitro arbitro, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  distinct t1.ARCODIGO ARCODIGO,t1.ARINCOES ARINCOES,t1.ARNIF ARNIF,t1.ARNOMBRE ARNOMBRE,t1.ARNODIR ARNODIR,t1.ARCOLO ARCOLO,t1.ARNOLO ARNOLO,t1.ARNRCOPO ARNRCOPO,t1.ARCOPV ARCOPV,t1.ARNOPV ARNOPV,t1.ARNRTEL ARNRTEL,t1.ARNRTEL2 ARNRTEL2,t1.ARNRFAX ARNRFAX,t1.ARTEEM ARTEEM,t1.ARTEURL ARTEURL,t1.ARNODIRC ARNODIRC,t1.ARCOLOC ARCOLOC,t1.ARNOLOC ARNOLOC,t1.ARNRCOPOC ARNRCOPOC,t1.ARCOPVC ARCOPVC,t1.ARNOPVC ARNOPVC,t1.ARNRTELC ARNRTELC,t1.ARNRTEL2C ARNRTEL2C,t1.ARNRFAXC ARNRFAXC,t1.ARTEEMC ARTEEMC,t1.ARTEURLC ARTEURLC,t1.ARINDICO ARINDICO,t1.ARFEAC ARFEAC,t1.ARFEBA ARFEBA,t1.ARTEOBS ARTEOBS,t1.ARCOJA ARCOJA,t1.ARCOZS ARCOZS,t1.ARFEMOD ARFEMOD,t1.ARNOMBREC ARNOMBREC,t1.ARINPF ARINPF,t1.ARLICENCIADO ARLICENCIADO,t1.ARIDIOMA ARIDIOMA,t1.ARPROV_ID ARPROVID,t1.ARMUN_ID ARMUNID,t1.ARLOC_ID ARLOCID,t1.ARCALLE_ID ARCALLEID,t1.ARPORTAL_ID ARPORTALID,t1.ARPROVC_ID ARPROVCID,t1.ARMUNC_ID ARMUNCID,t1.ARLOCC_ID ARLOCCID,t1.ARCALLEC_ID ARCALLECID,t1.ARPORTALC_ID ARPORTALCID,t1.ARFECALTA ARFECALTA,t1.ARUSUALTA ARUSUALTA, t1.ARTERCERO ARTERCERO, ARNOMBRE_CP, ARNOMBRE_PISO, ARNOMBREC_CP, ARNOMBREC_PISO, ");
		query.append("CASE WHEN t3.arnoentidadEs!='-' then replace('<ul style=\"list-style:disc inside none\"><li>'||replace(CASE WHEN instr(t3.arnoentidadEs,'@',-1,1)=length(t3.arnoentidadEs) THEN substr(t3.arnoentidadEs,0,length(t3.arnoentidadEs)-2) ELSE t3.arnoentidadEs END,'@','</li><li>')||'</li></ul>','<ul><li></li></ul>','') else ' ' end ARNOENTIDADES, ");
		query.append("CASE WHEN t3.arnoentidadEu!='-' then replace('<ul style=\"list-style:disc inside none\"><li>'||replace(CASE WHEN instr(t3.arnoentidadEu,'@',-1,1)=length(t3.arnoentidadEu) THEN substr(t3.arnoentidadEu,0,length(t3.arnoentidadEu)-2) ELSE t3.arnoentidadEu END,'@','</li><li>')||'</li></ul>','<ul><li></li></ul>','') else ' ' end ARNOENTIDADEU ");
		query.append("FROM ARBITRO t1, ARTA1 t2,  ");
		query.append("( SELECT ARCODIGO,  ");
		query.append("SUBSTR(REGEXP_REPLACE(SYS_CONNECT_BY_PATH(ARNOENTIDADES, '@'), '(@){1,}', '@'),2) ARNOENTIDADES, ");
		query.append(" SUBSTR(REGEXP_REPLACE(SYS_CONNECT_BY_PATH(ARNOENTIDADEU, '@'), '(@){1,}', '@'),2) ARNOENTIDADEU ");
		query.append("FROM (select arcodigo,arnoentidadEs, arnoentidadEu,cod_org, ");
		query.append("count(*) OVER ( partition by arcodigo ) cnt, ");
		query.append("ROW_NUMBER () OVER ( partition by arcodigo order by ORDEN asc) seq  ");
		query.append("from (SELECT B.arcodigo, D.cod_org, D.cod_org||' - '||D.nombre_es arnoentidadEs, ");
		query.append("D.cod_org||' - '||D.nombre_eu arnoentidadEu,B.ORDEN ");
		query.append("FROM (");
		if ("E".equals(arbitro.getArincoes())) {
			query.append("SELECT M2COOE cod_org, M2COAR arcodigo, M2CENTROAR orden FROM OEAR ");
		} else if ("C".equals(arbitro.getArincoes())) {
			query.append("SELECT M1COCC cod_org, M1COAR arcodigo,M1CENTROAR orden FROM CCAR");
		} else {
			query.append("(SELECT M1COCC cod_org, M1COAR arcodigo,M1CENTROAR orden FROM CCAR");
			query.append(" UNION SELECT M2COOE cod_org, M2COAR arcodigo, M2CENTROAR orden FROM OEAR) ");
		}
		query.append(") B, ORGANISMO D ");
		query.append("where B.cod_org=D.cod_org(+) AND B.arcodigo is not null) H ) ");
		query.append("where seq=cnt start with seq=1 connect by prior seq+1=seq and prior arcodigo=arcodigo) t3, ARSE t4, OEAR t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbitro);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ARCODIGO=t2.M3COAR(+) AND t1.ARCODIGO=t3.ARCODIGO(+) AND t1.ARCODIGO=t4.M4COAR(+) AND t1.ARCODIGO=t5.M2COAR(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbitro>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbitro table.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbitro arbitro) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct ARCODIGO) FROM ARBITRO t1, ARTA1 t2, ARSE t4, OEAR t5  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbitro);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ARCODIGO=t2.M3COAR(+) AND t1.ARCODIGO=t4.M4COAR(+) AND t1.ARCODIGO=t5.M2COAR(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbitro table using like.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbitro> findAllLike(Arbitro arbitro, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ARCODIGO ARCODIGO,t1.ARINCOES ARINCOES,t1.ARNIF ARNIF,t1.ARNOMBRE ARNOMBRE,t1.ARNODIR ARNODIR,t1.ARCOLO ARCOLO,t1.ARNOLO ARNOLO,t1.ARNRCOPO ARNRCOPO,t1.ARCOPV ARCOPV,t1.ARNOPV ARNOPV,t1.ARNRTEL ARNRTEL,t1.ARNRTEL2 ARNRTEL2,t1.ARNRFAX ARNRFAX,t1.ARTEEM ARTEEM,t1.ARTEURL ARTEURL,t1.ARNODIRC ARNODIRC,t1.ARCOLOC ARCOLOC,t1.ARNOLOC ARNOLOC,t1.ARNRCOPOC ARNRCOPOC,t1.ARCOPVC ARCOPVC,t1.ARNOPVC ARNOPVC,t1.ARNRTELC ARNRTELC,t1.ARNRTEL2C ARNRTEL2C,t1.ARNRFAXC ARNRFAXC,t1.ARTEEMC ARTEEMC,t1.ARTEURLC ARTEURLC,t1.ARINDICO ARINDICO,t1.ARFEAC ARFEAC,t1.ARFEBA ARFEBA,t1.ARTEOBS ARTEOBS,t1.ARCOJA ARCOJA,t1.ARCOZS ARCOZS,t1.ARFEMOD ARFEMOD,t1.ARNOMBREC ARNOMBREC,t1.ARINPF ARINPF,t1.ARLICENCIADO ARLICENCIADO,t1.ARIDIOMA ARIDIOMA,t1.ARPROV_ID ARPROVID,t1.ARMUN_ID ARMUNID,t1.ARLOC_ID ARLOCID,t1.ARCALLE_ID ARCALLEID,t1.ARPORTAL_ID ARPORTALID,t1.ARPROVC_ID ARPROVCID,t1.ARMUNC_ID ARMUNCID,t1.ARLOCC_ID ARLOCCID,t1.ARCALLEC_ID ARCALLECID,t1.ARPORTALC_ID ARPORTALCID,t1.ARFECALTA ARFECALTA,t1.ARUSUALTA ARUSUALTA, '' ARNOENTIDADES, '' ARNOENTIDADEU, t1.ARTERCERO ARTERCERO, ARNOMBRE_CP, ARNOMBRE_PISO, ARNOMBREC_CP, ARNOMBREC_PISO ");
		query.append("FROM ARBITRO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbitro, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbitro>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbitro table using like.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbitro arbitro, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBITRO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbitro, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbitro entity
	 * 
	 * @param arbitro
	 *            Arbitro Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbitro arbitro) {

		StringBuilder where = new StringBuilder(
				ArbitroDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getArnif())) {
			where.append(" AND TRANSLATE(UPPER(t1.ARNIF),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ arbitro.getArnif().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ARNIF IS NOT NULL");
		}
		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getArnombre())) {
			where.append(" AND TRANSLATE(UPPER(t1.ARNOMBRE),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ arbitro.getArnombre().toUpperCase().replaceAll("", "A")
							.replaceAll("", "E").replaceAll("", "I")
							.replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ARNOMBRE IS NOT NULL");
		}

		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getArincoes())) {
			where.append(" AND t1.ARINCOES = ?");
			params.add(arbitro.getArincoes());
		}
		// Territorio de actuacion
		if (arbitro != null
				&& (!Y41bUtils.esNullOCadenaVacia(arbitro.getArThActAraba())
						|| !Y41bUtils.esNullOCadenaVacia(arbitro
								.getArThActBizkaia()) || !Y41bUtils
						.esNullOCadenaVacia(arbitro.getArThActGipuzkoa()))) {
			where.append(" AND (");
			if (arbitro != null
					&& !Y41bUtils.esNullOCadenaVacia(arbitro.getArThActAraba())) {
				where.append(" t2.M3COTA1 = ? ");
				params.add(arbitro.getArThActAraba());
			}
			if (arbitro != null
					&& !Y41bUtils.esNullOCadenaVacia(arbitro
							.getArThActBizkaia())) {
				if (arbitro != null
						&& !Y41bUtils.esNullOCadenaVacia(arbitro
								.getArThActAraba())) {
					where.append(" OR ");
				}
				where.append(" t2.M3COTA1 = ? ");
				params.add(arbitro.getArThActBizkaia());
			}
			if (arbitro != null
					&& !Y41bUtils.esNullOCadenaVacia(arbitro
							.getArThActGipuzkoa())) {
				if (arbitro != null
						&& (!Y41bUtils.esNullOCadenaVacia(arbitro
								.getArThActAraba()) || !Y41bUtils
								.esNullOCadenaVacia(arbitro.getArThActBizkaia()))) {
					where.append(" OR ");
				}
				where.append(" t2.M3COTA1 = ? ");
				params.add(arbitro.getArThActGipuzkoa());
			}
			where.append(" ) ");
		}
		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getAridiomaC())) {
			if (arbitro != null
					&& !Y41bUtils.esNullOCadenaVacia(arbitro.getAridiomaE())) {
				where.append(" AND t1.ARIDIOMA = 'A'");
			} else {
				where.append(" AND t1.ARIDIOMA = ? ");
				params.add(arbitro.getAridiomaC());
			}
		} else {
			if (arbitro != null
					&& !Y41bUtils.esNullOCadenaVacia(arbitro.getAridiomaE())) {
				where.append(" AND t1.ARIDIOMA = ? ");
				params.add(arbitro.getAridiomaE());
			}
		}
		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getArlicenciado())) {
			where.append(" AND t1.ARLICENCIADO = ?");
			params.add(arbitro.getArlicenciado());
		}
		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getArtercero())) {
			where.append(" AND t1.ARTERCERO = ?");
			params.add(arbitro.getArtercero());
		}
		if (arbitro != null && arbitro.getBaja() != null) {
			if (Y41bConstantes.VALOR_NO.equals(arbitro.getBaja())) {
				where.append(" AND (t1.ARFEBA IS NULL OR ( t1.ARFEBA IS NOT NULL AND t1.ARFEBA >sysdate)) ");
			} else if (Y41bConstantes.VALOR_SI.equals(arbitro.getBaja())) {
				where.append(" AND (t1.ARFEBA IS NOT NULL AND t1.ARFEBA <=sysdate) ");
			}
		}
		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getSecodigo())) {
			where.append(" AND t4.M4COSE = ?");
			params.add(arbitro.getSecodigo());
		}
		if (arbitro != null
				&& !Y41bUtils.esNullOCadenaVacia(arbitro.getOecodigo())) {
			where.append(" AND t5.M2COOE = ?");
			params.add(arbitro.getOecodigo());
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbitro entity
	 * 
	 * @param arbitro
	 *            Arbitro Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbitro arbitro, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbitroDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbitro != null && arbitro.getArcodigo() != null) {
			where.append(" AND UPPER(t1.ARCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCODIGO IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArincoes() != null) {
			where.append(" AND UPPER(t1.ARINCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArincoes().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArincoes().toUpperCase() + "%");
			}
			where.append(" AND t1.ARINCOES IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnif() != null) {
			where.append(" AND UPPER(t1.ARNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnif().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNIF IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnombre() != null) {
			where.append(" AND UPPER(t1.ARNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnombre().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNOMBRE IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnodir() != null) {
			where.append(" AND UPPER(t1.ARNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnodir().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnodir().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNODIR IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcolo() != null) {
			where.append(" AND UPPER(t1.ARCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcolo().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcolo().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCOLO IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnolo() != null) {
			where.append(" AND UPPER(t1.ARNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnolo().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnolo().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNOLO IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrcopo() != null) {
			where.append(" AND UPPER(t1.ARNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrcopo().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRCOPO IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcopv() != null) {
			where.append(" AND UPPER(t1.ARCOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcopv().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcopv().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCOPV IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnopv() != null) {
			where.append(" AND UPPER(t1.ARNOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnopv().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnopv().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNOPV IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrtel() != null) {
			where.append(" AND UPPER(t1.ARNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRTEL IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrtel2() != null) {
			where.append(" AND UPPER(t1.ARNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRTEL2 IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrfax() != null) {
			where.append(" AND UPPER(t1.ARNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrfax().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRFAX IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArteem() != null) {
			where.append(" AND UPPER(t1.ARTEEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArteem().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArteem().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTEEM IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArteurl() != null) {
			where.append(" AND UPPER(t1.ARTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArteurl().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArteurl().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTEURL IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnodirc() != null) {
			where.append(" AND UPPER(t1.ARNODIRC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnodirc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnodirc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNODIRC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcoloc() != null) {
			where.append(" AND UPPER(t1.ARCOLOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcoloc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcoloc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCOLOC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnoloc() != null) {
			where.append(" AND UPPER(t1.ARNOLOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnoloc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnoloc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNOLOC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrcopoc() != null) {
			where.append(" AND UPPER(t1.ARNRCOPOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrcopoc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrcopoc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRCOPOC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcopvc() != null) {
			where.append(" AND UPPER(t1.ARCOPVC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcopvc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcopvc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCOPVC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnopvc() != null) {
			where.append(" AND UPPER(t1.ARNOPVC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnopvc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnopvc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNOPVC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrtelc() != null) {
			where.append(" AND UPPER(t1.ARNRTELC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrtelc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrtelc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRTELC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrtel2c() != null) {
			where.append(" AND UPPER(t1.ARNRTEL2C) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrtel2c().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrtel2c().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRTEL2C IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnrfaxc() != null) {
			where.append(" AND UPPER(t1.ARNRFAXC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnrfaxc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnrfaxc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNRFAXC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArteemc() != null) {
			where.append(" AND UPPER(t1.ARTEEMC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArteemc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArteemc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTEEMC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArteurlc() != null) {
			where.append(" AND UPPER(t1.ARTEURLC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArteurlc().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArteurlc().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTEURLC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArindico() != null) {
			where.append(" AND UPPER(t1.ARINDICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArindico().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArindico().toUpperCase() + "%");
			}
			where.append(" AND t1.ARINDICO IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArfeac() != null) {
			where.append(" AND t1.ARFEAC = ?");
			params.add(arbitro.getArfeac());
		}
		if (arbitro != null && arbitro.getArfeba() != null) {
			where.append(" AND t1.ARFEBA = ?");
			params.add(arbitro.getArfeba());
		}
		if (arbitro != null && arbitro.getArteobs() != null) {
			where.append(" AND UPPER(t1.ARTEOBS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArteobs().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArteobs().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTEOBS IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcoja() != null) {
			where.append(" AND UPPER(t1.ARCOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcoja().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcoja().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCOJA IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcozs() != null) {
			where.append(" AND UPPER(t1.ARCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcozs().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcozs().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCOZS IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArfemod() != null) {
			where.append(" AND UPPER(t1.ARFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArfemod().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArfemod().toUpperCase() + "%");
			}
			where.append(" AND t1.ARFEMOD IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArnombrec() != null) {
			where.append(" AND UPPER(t1.ARNOMBREC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArnombrec().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArnombrec().toUpperCase() + "%");
			}
			where.append(" AND t1.ARNOMBREC IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArinpf() != null) {
			where.append(" AND UPPER(t1.ARINPF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArinpf().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArinpf().toUpperCase() + "%");
			}
			where.append(" AND t1.ARINPF IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArlicenciado() != null) {
			where.append(" AND UPPER(t1.ARLICENCIADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArlicenciado().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArlicenciado().toUpperCase() + "%");
			}
			where.append(" AND t1.ARLICENCIADO IS NOT NULL");
		}
		if (arbitro != null && arbitro.getAridioma() != null) {
			where.append(" AND UPPER(t1.ARIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getAridioma().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getAridioma().toUpperCase() + "%");
			}
			where.append(" AND t1.ARIDIOMA IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArprovId() != null) {
			where.append(" AND UPPER(t1.ARPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArprovId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArprovId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARPROV_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArmunId() != null) {
			where.append(" AND UPPER(t1.ARMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArmunId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArmunId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARMUN_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArlocId() != null) {
			where.append(" AND UPPER(t1.ARLOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArlocId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArlocId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARLOC_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcalleId() != null) {
			where.append(" AND UPPER(t1.ARCALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcalleId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCALLE_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArportalId() != null) {
			where.append(" AND UPPER(t1.ARPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArportalId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArportalId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARPORTAL_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArprovcId() != null) {
			where.append(" AND UPPER(t1.ARPROVC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArprovcId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArprovcId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARPROVC_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArmuncId() != null) {
			where.append(" AND UPPER(t1.ARMUNC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArmuncId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArmuncId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARMUNC_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArloccId() != null) {
			where.append(" AND UPPER(t1.ARLOCC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArloccId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArloccId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARLOCC_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArcallecId() != null) {
			where.append(" AND UPPER(t1.ARCALLEC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArcallecId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArcallecId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARCALLEC_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArportalcId() != null) {
			where.append(" AND UPPER(t1.ARPORTALC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArportalcId().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArportalcId().toUpperCase() + "%");
			}
			where.append(" AND t1.ARPORTALC_ID IS NOT NULL");
		}
		if (arbitro != null && arbitro.getArfecalta() != null) {
			where.append(" AND t1.ARFECALTA = ?");
			params.add(arbitro.getArfecalta());
		}
		if (arbitro != null && arbitro.getArusualta() != null) {
			where.append(" AND UPPER(t1.ARUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbitro.getArusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbitro.getArusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.ARUSUALTA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT L21C1Q00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
