package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbintervDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbintervDaoImpl implements ArbintervDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbinterv> rwMap = new RowMapper<Arbinterv>() {
		public Arbinterv mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Arbinterv(resultSet.getBigDecimal("UAIDINTERV"), resultSet.getString("UANOMBRE"),
					resultSet.getString("UANIF"), resultSet.getString("UANRTEL"), resultSet.getString("UANRTEL2"),
					resultSet.getString("UAPROVID"), resultSet.getString("UAMUNID"), resultSet.getString("UALOCID"),
					resultSet.getString("UACALLEID"), resultSet.getString("UACPID"), resultSet.getString("UAPORTALID"),
					resultSet.getString("UANOMBREPISO"), resultSet.getString("UADIRENOCAPV"),
					resultSet.getString("UADIREANT"), resultSet.getString("UATIPOINTERV"),
					resultSet.getString("UAEXCODIGO"), resultSet.getString("UADTCODIGO"),
					resultSet.getString("UAESCODIGO"), resultSet.getDate("UATRFECALTA"),
					resultSet.getDate("UATRFECMODIF"), resultSet.getString("UATRUSUALTA"),
					resultSet.getString("UATRUSUMODIF"), resultSet.getDate("UAFECALTA"),
					resultSet.getDate("UAFECMODIF"), resultSet.getString("UAUSUALTA"),
					resultSet.getString("UAUSUMODIF"), resultSet.getString("UACOEM"), resultSet.getString("UANODIR"),
					resultSet.getString("UAAPELLIDO1"), resultSet.getString("UAAPELLIDO2"),
					resultSet.getString("UAPAISID"), resultSet.getString("UAENTIDADID"), resultSet.getString("UANOCO"),
					resultSet.getString("UANOPECO"), resultSet.getString("UAURL"), resultSet.getString("UASECODIGO"),
					resultSet.getString("UASENOMBRE"), resultSet.getString("UASENOMBREE"),
					resultSet.getString("UAFECULTMOD"), resultSet.getString("UAUSUULTMOD"),
					resultSet.getString("UAFORMANOTIFICACION"), resultSet.getString("UAIDIOMA"),
					resultSet.getString("UASEXO"), resultSet.getString("UAEDAD"),
					resultSet.getString("UATIPOIDENTIFICACION"));
		}
	};

	private RowMapper<Intervinientes> rwMapInterviniente = new RowMapper<Intervinientes>() {
		public Intervinientes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Intervinientes interviniente = new Intervinientes();
			interviniente.setNombre(resultSet.getString("UANOMBRE"));
			interviniente.setApellido1(resultSet.getString("UAAPELLIDO1"));
			interviniente.setApellido2(resultSet.getString("UAAPELLIDO2"));
			interviniente.setIdinterviniente(resultSet.getString("UAIDINTERV"));
			interviniente.setTipoInterviniente(resultSet.getString("UATIPOINTERV"));
			return interviniente;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Pagination
	 * @return Arbinterv
	 */
	public Arbinterv add(Arbinterv arbinterv) {
		try {
			String query = "INSERT INTO ARBINTERV (UAIDINTERV, UANOMBRE, UANIF, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UADIRE_ANT, UATIPOINTERV, UAEXCODIGO, UADTCODIGO, UAESCODIGO, UATRFECALTA, UATRFECMODIF, UATRUSUALTA, UATRUSUMODIF, UAFECALTA, UAFECMODIF, UAUSUALTA, UAUSUMODIF, UACOEM, UANODIR, UAAPELLIDO1, UAAPELLIDO2, UAPAIS_ID, UAENTIDAD_ID, UANOCO, UANOPECO, UAURL, UASECODIGO, UASENOMBRE, UASENOMBREE, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UAIDIOMA, UASEXO, UAEDAD, UATIPOIDENTIFICACION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			Object getSolarbExcodigoAux = null;
			if (arbinterv.getUaexcodigo() != null) {
				getSolarbExcodigoAux = arbinterv.getUaexcodigo();
			} else if (arbinterv.getSolarb() != null && arbinterv.getSolarb().getSacodigo() != null) {
				getSolarbExcodigoAux = arbinterv.getSolarb().getSacodigo();
			}
			String uanombrePiso = null;
			if (arbinterv.getUanombrePiso() != null && arbinterv.getUanombrePiso().length() > 40) {
				uanombrePiso = arbinterv.getUanombrePiso().substring(0, 40);
			} else {
				uanombrePiso = arbinterv.getUanombrePiso();
			}
			this.jdbcTemplate.update(query, arbinterv.getUaidinterv(), arbinterv.getUanombre(), arbinterv.getUanif(),
					arbinterv.getUanrtel(), arbinterv.getUanrtel2(), arbinterv.getUaprovId(), arbinterv.getUamunId(),
					arbinterv.getUalocId(), arbinterv.getUacalleId(), arbinterv.getUacpId(), arbinterv.getUaportalId(),
					uanombrePiso, arbinterv.getUadireNocapv(), arbinterv.getUadireAnt(), arbinterv.getUatipointerv(),
					getSolarbExcodigoAux, arbinterv.getUadtcodigo(), arbinterv.getUaescodigo(),
					arbinterv.getUatrfecalta(), arbinterv.getUatrfecmodif(), arbinterv.getUatrusualta(),
					arbinterv.getUatrusumodif(), arbinterv.getUafecalta(), arbinterv.getUafecmodif(),
					arbinterv.getUausualta(), arbinterv.getUausumodif(), arbinterv.getUacoem(), arbinterv.getUanodir(),
					arbinterv.getUaapellido1(), arbinterv.getUaapellido2(), arbinterv.getUapaisId(),
					arbinterv.getUaentidadId(), arbinterv.getUanoco(), arbinterv.getUanopeco(), arbinterv.getUaurl(),
					arbinterv.getUasecodigo(), arbinterv.getUasenombre(), arbinterv.getUasenombree(),
					arbinterv.getUafecultmod(), arbinterv.getUausuultmod(), arbinterv.getUaformanotificacion(),
					arbinterv.getUaidioma(), arbinterv.getUasexo(), arbinterv.getUaedad(),
					arbinterv.getUatipoidentificacion());
			arbinterv.setUaidinterv(new BigDecimal(this.currentValue()));
			return arbinterv;
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue() {
		String query = "SELECT L21.L21XAQ00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		return this.jdbcTemplate.queryForInt(query.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Pagination
	 * @return Arbinterv
	 */
	public Arbinterv actualizaFormaNotificacion(Arbinterv arbinterv) {
		String query = "UPDATE ARBINTERV SET UAFORMANOTIFICACION=?,UAIDIOMA=? WHERE UAIDINTERV=?";
		this.jdbcTemplate.update(query, arbinterv.getUaformanotificacion(), arbinterv.getUaidioma(),
				arbinterv.getUaidinterv());
		return arbinterv;
	}

	/**
	 * 
	 * @param arbtinerv
	 *            Arbinterv
	 * @param tipo
	 *            String
	 */
	public void updateTipointervinienteAnterior(Arbinterv arbtinerv, String tipo) {
		if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO.equals(tipo)
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_NO_VALIDADO.equals(tipo)) {
			String query = "UPDATE ARBINTERV SET UATIPOINTERV=? WHERE UAIDINTERV=? ";
			this.jdbcTemplate.update(query, Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMADO_ANTERIOR,
					arbtinerv.getUaidinterv());
		} else if (Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE.equals(tipo)
				|| Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_NO_VALIDADO.equals(tipo)) {
			String query = "UPDATE ARBINTERV SET UATIPOINTERV=? WHERE UAIDINTERV=? ";
			this.jdbcTemplate.update(query, Y41bConstantes.TIPO_INTERVINIENTEARB_REPRESENTANTE_RECLAMANTE_ANTERIOR,
					arbtinerv.getUaidinterv());
		}
	}

	/**
	 * 
	 * @param arbtinerv
	 *            Arbinterv
	 * @param tipo
	 *            String
	 */
	public void updateTipointerviniente(Arbinterv arbtinerv, String tipo) {
		String query = "UPDATE ARBINTERV SET UATIPOINTERV=? WHERE UAIDINTERV=? ";
		this.jdbcTemplate.update(query, tipo, arbtinerv.getUaidinterv());
	}

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Pagination
	 * @return Arbinterv
	 */
	public Arbinterv update(Arbinterv arbinterv) {
		String query = "UPDATE ARBINTERV SET UANOMBRE=?, UANIF=?, UANRTEL=?, UANRTEL2=?, UAPROV_ID=?, UAMUN_ID=?, UALOC_ID=?, UACALLE_ID=?, UACP_ID=?, UAPORTAL_ID=?, UANOMBRE_PISO=?, UADIRE_NOCAPV=?, UADIRE_ANT=?, UATIPOINTERV=?, UAEXCODIGO=?, UADTCODIGO=?, UAESCODIGO=?, UATRFECALTA=?, UATRFECMODIF=?, UATRUSUALTA=?, UATRUSUMODIF=?, UAFECALTA=?, UAFECMODIF=?, UAUSUALTA=?, UAUSUMODIF=?, UACOEM=?, UANODIR=?, UAAPELLIDO1=?, UAAPELLIDO2=?, UAPAIS_ID=?, UAENTIDAD_ID=?, UANOCO=?, UANOPECO=?, UAURL=?, UASECODIGO=?, UASENOMBRE=?, UASENOMBREE=?, UAFECULTMOD=?, UAUSUULTMOD=?, UAFORMANOTIFICACION=?, UAIDIOMA=?, UASEXO=?, UAEDAD=?, UATIPOIDENTIFICACION=? WHERE UAIDINTERV=?";
		String uanombrePiso = null;
		if (arbinterv.getUanombrePiso() != null && arbinterv.getUanombrePiso().length() > 40) {
			uanombrePiso = arbinterv.getUanombrePiso().substring(0, 40);
		} else {
			uanombrePiso = arbinterv.getUanombrePiso();
		}
		this.jdbcTemplate.update(query, arbinterv.getUanombre(), arbinterv.getUanif(), arbinterv.getUanrtel(),
				arbinterv.getUanrtel2(), arbinterv.getUaprovId(), arbinterv.getUamunId(), arbinterv.getUalocId(),
				arbinterv.getUacalleId(), arbinterv.getUacpId(), arbinterv.getUaportalId(), uanombrePiso,
				arbinterv.getUadireNocapv(), arbinterv.getUadireAnt(), arbinterv.getUatipointerv(),
				arbinterv.getUaexcodigo(), arbinterv.getUadtcodigo(), arbinterv.getUaescodigo(),
				arbinterv.getUatrfecalta(), arbinterv.getUatrfecmodif(), arbinterv.getUatrusualta(),
				arbinterv.getUatrusumodif(), arbinterv.getUafecalta(), arbinterv.getUafecmodif(),
				arbinterv.getUausualta(), arbinterv.getUausumodif(), arbinterv.getUacoem(), arbinterv.getUanodir(),
				arbinterv.getUaapellido1(), arbinterv.getUaapellido2(), arbinterv.getUapaisId(),
				arbinterv.getUaentidadId(), arbinterv.getUanoco(), arbinterv.getUanopeco(), arbinterv.getUaurl(),
				arbinterv.getUasecodigo(), arbinterv.getUasenombre(), arbinterv.getUasenombree(),
				arbinterv.getUafecultmod(), arbinterv.getUausuultmod(), arbinterv.getUaformanotificacion(),
				arbinterv.getUaidioma(), arbinterv.getUasexo(), arbinterv.getUaedad(),
				arbinterv.getUatipoidentificacion(), arbinterv.getUaidinterv());
		return arbinterv;
	}

	/**
	 * Finds a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Pagination
	 * @return Arbinterv
	 */
	@Transactional(readOnly = true)
	public Arbinterv find(Arbinterv arbinterv) {
		String query = "SELECT t1.UAIDINTERV UAIDINTERV, t1.UANOMBRE UANOMBRE, t1.UANIF UANIF, t1.UANRTEL UANRTEL, t1.UANRTEL2 UANRTEL2, t1.UAPROV_ID UAPROVID, t1.UAMUN_ID UAMUNID, t1.UALOC_ID UALOCID, t1.UACALLE_ID UACALLEID, t1.UACP_ID UACPID, t1.UAPORTAL_ID UAPORTALID, t1.UANOMBRE_PISO UANOMBREPISO, t1.UADIRE_NOCAPV UADIRENOCAPV, t1.UADIRE_ANT UADIREANT, t1.UATIPOINTERV UATIPOINTERV, t1.UAEXCODIGO UAEXCODIGO, t1.UADTCODIGO UADTCODIGO, t1.UAESCODIGO UAESCODIGO, t1.UATRFECALTA UATRFECALTA, t1.UATRFECMODIF UATRFECMODIF, t1.UATRUSUALTA UATRUSUALTA, t1.UATRUSUMODIF UATRUSUMODIF, t1.UAFECALTA UAFECALTA, t1.UAFECMODIF UAFECMODIF, t1.UAUSUALTA UAUSUALTA, t1.UAUSUMODIF UAUSUMODIF, t1.UACOEM UACOEM, t1.UANODIR UANODIR, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2, t1.UAPAIS_ID UAPAISID, t1.UAENTIDAD_ID UAENTIDADID, t1.UANOCO UANOCO, t1.UANOPECO UANOPECO, t1.UAURL UAURL, t1.UASECODIGO UASECODIGO, t1.UASENOMBRE UASENOMBRE, t1.UASENOMBREE UASENOMBREE, t1.UAFECULTMOD UAFECULTMOD, t1.UAUSUULTMOD UAUSUULTMOD, t1.UAFORMANOTIFICACION UAFORMANOTIFICACION, t1.UAIDIOMA UAIDIOMA, t1.UASEXO UASEXO, t1.UAEDAD UAEDAD, t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION FROM ARBINTERV t1  WHERE t1.UAIDINTERV = ?  ";

		List<Arbinterv> arbintervList = this.jdbcTemplate.query(query, this.rwMap, arbinterv.getUaidinterv());
		return (Arbinterv) DataAccessUtils.uniqueResult(arbintervList);
	}

	/**
	 * Finds a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Pagination
	 * @return Arbinterv
	 */
	@Transactional(readOnly = true)
	public Arbinterv findOrganismoOrigen(Arbinterv arbinterv) {
		String query = "SELECT t1.UAIDINTERV UAIDINTERV, t1.UANOMBRE UANOMBRE, t1.UANIF UANIF, t1.UANRTEL UANRTEL, t1.UANRTEL2 UANRTEL2, t1.UAPROV_ID UAPROVID, t1.UAMUN_ID UAMUNID, t1.UALOC_ID UALOCID, t1.UACALLE_ID UACALLEID, t1.UACP_ID UACPID, t1.UAPORTAL_ID UAPORTALID, t1.UANOMBRE_PISO UANOMBREPISO, t1.UADIRE_NOCAPV UADIRENOCAPV, t1.UADIRE_ANT UADIREANT, t1.UATIPOINTERV UATIPOINTERV, t1.UAEXCODIGO UAEXCODIGO, t1.UADTCODIGO UADTCODIGO, t1.UAESCODIGO UAESCODIGO, t1.UATRFECALTA UATRFECALTA, t1.UATRFECMODIF UATRFECMODIF, t1.UATRUSUALTA UATRUSUALTA, t1.UATRUSUMODIF UATRUSUMODIF, t1.UAFECALTA UAFECALTA, t1.UAFECMODIF UAFECMODIF, t1.UAUSUALTA UAUSUALTA, t1.UAUSUMODIF UAUSUMODIF, t1.UACOEM UACOEM, t1.UANODIR UANODIR, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2, t1.UAPAIS_ID UAPAISID, t1.UAENTIDAD_ID UAENTIDADID, t1.UANOCO UANOCO, t1.UANOPECO UANOPECO, t1.UAURL UAURL, t1.UASECODIGO UASECODIGO, t1.UASENOMBRE UASENOMBRE, t1.UASENOMBREE UASENOMBREE, t1.UAFECULTMOD UAFECULTMOD, t1.UAUSUULTMOD UAUSUULTMOD, t1.UAFORMANOTIFICACION UAFORMANOTIFICACION, t1.UAIDIOMA UAIDIOMA, t1.UASEXO UASEXO, t1.UAEDAD UAEDAD, t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION FROM ARBINTERV t1 WHERE t1.UAEXCODIGO = ? AND t1.UATIPOINTERV = ? AND t1.UAENTIDAD_ID = ? ";

		List<Arbinterv> arbintervList = this.jdbcTemplate.query(query, this.rwMap, arbinterv.getUaexcodigo(),
				arbinterv.getUatipointerv(), arbinterv.getUaentidadId());
		return (Arbinterv) DataAccessUtils.uniqueResult(arbintervList);
	}

	/**
	 * Removes a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Pagination
	 * @return
	 */
	public void remove(Arbinterv arbinterv) {
		String query = "DELETE FROM ARBINTERV WHERE UAIDINTERV=?";
		this.jdbcTemplate.update(query, arbinterv.getUaidinterv());
	}

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbinterv> findAll(Arbinterv arbinterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE UANOMBRE,t1.UANIF UANIF,t1.UANRTEL UANRTEL,t1.UANRTEL2 UANRTEL2,t1.UAPROV_ID UAPROVID,t1.UAMUN_ID UAMUNID,t1.UALOC_ID UALOCID,t1.UACALLE_ID UACALLEID,t1.UACP_ID UACPID,t1.UAPORTAL_ID UAPORTALID,t1.UANOMBRE_PISO UANOMBREPISO,t1.UADIRE_NOCAPV UADIRENOCAPV,t1.UADIRE_ANT UADIREANT,t1.UATIPOINTERV UATIPOINTERV,t1.UAEXCODIGO UAEXCODIGO,t1.UADTCODIGO UADTCODIGO,t1.UAESCODIGO UAESCODIGO,t1.UATRFECALTA UATRFECALTA,t1.UATRFECMODIF UATRFECMODIF,t1.UATRUSUALTA UATRUSUALTA,t1.UATRUSUMODIF UATRUSUMODIF,t1.UAFECALTA UAFECALTA,t1.UAFECMODIF UAFECMODIF,t1.UAUSUALTA UAUSUALTA,t1.UAUSUMODIF UAUSUMODIF,t1.UACOEM UACOEM,t1.UANODIR UANODIR,t1.UAAPELLIDO1 UAAPELLIDO1,t1.UAAPELLIDO2 UAAPELLIDO2,t1.UAPAIS_ID UAPAISID,t1.UAENTIDAD_ID UAENTIDADID,t1.UANOCO UANOCO,t1.UANOPECO UANOPECO,t1.UAURL UAURL,t1.UASECODIGO UASECODIGO,t1.UASENOMBRE UASENOMBRE,t1.UASENOMBREE UASENOMBREE,t1.UAFECULTMOD UAFECULTMOD,t1.UAUSUULTMOD UAUSUULTMOD,t1.UAFORMANOTIFICACION UAFORMANOTIFICACION,t1.UAIDIOMA UAIDIOMA,t1.UASEXO UASEXO,t1.UAEDAD UAEDAD,t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION ");
		query.append("FROM ARBINTERV t1, SOLARB t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbinterv);
		StringBuilder where = new StringBuilder(" WHERE t1.UAEXCODIGO = t2.SACODIGO(+) ");

		if (Y41bConstantes.VALOR_SI.equals(arbinterv.getActivos())) {
			where.append(" AND UAENTIDAD_ID IN (");
			where.append(" SELECT ARBITRO FROM (");
			where.append(" SELECT CASE WHEN XJACTIVOPSUP='").append(Y41bConstantes.VALOR_SI)
					.append("' THEN SACOARPS ELSE SACOARPT END ARBITRO, ");
			where.append(
					" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol, TREXCODIGO");
			where.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '");
			where.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			where.append("' AND TRESTADO = '");
			where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND TREXCODIGO =  SACODIGO");
			where.append(" UNION ");
			where.append(" SELECT CASE WHEN XJACTIVOAACCSUP='").append(Y41bConstantes.VALOR_SI)
					.append("' THEN SACOARTS ELSE SACOARTT END ARBITRO, ");
			where.append(
					" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol, TREXCODIGO");
			where.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '");
			where.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			where.append("' AND TRESTADO = '");
			where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND TREXCODIGO =  SACODIGO");
			where.append(" UNION ");
			where.append(" SELECT CASE WHEN XJACTIVOOOEESUP='").append(Y41bConstantes.VALOR_SI)
					.append("' THEN SACOARDS ELSE SACOARDT END ARBITRO, ");
			where.append(
					" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol, TREXCODIGO");
			where.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '");
			where.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			where.append("' AND TRESTADO = '");
			where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND TREXCODIGO =  SACODIGO");
			where.append(") WHERE filaDesigCol=1 AND TREXCODIGO=t2.SACODIGO)");
		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbinterv>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbinterv arbinterv) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBINTERV t1, SOLARB t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbinterv);
		StringBuilder where = new StringBuilder(" WHERE t1.UAEXCODIGO = t2.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbinterv> findAllLike(Arbinterv arbinterv, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE UANOMBRE,t1.UANIF UANIF,t1.UANRTEL UANRTEL,t1.UANRTEL2 UANRTEL2,t1.UAPROV_ID UAPROVID,t1.UAMUN_ID UAMUNID,t1.UALOC_ID UALOCID,t1.UACALLE_ID UACALLEID,t1.UACP_ID UACPID,t1.UAPORTAL_ID UAPORTALID,t1.UANOMBRE_PISO UANOMBREPISO,t1.UADIRE_NOCAPV UADIRENOCAPV,t1.UADIRE_ANT UADIREANT,t1.UATIPOINTERV UATIPOINTERV,t1.UAEXCODIGO UAEXCODIGO,t1.UADTCODIGO UADTCODIGO,t1.UAESCODIGO UAESCODIGO,t1.UATRFECALTA UATRFECALTA,t1.UATRFECMODIF UATRFECMODIF,t1.UATRUSUALTA UATRUSUALTA,t1.UATRUSUMODIF UATRUSUMODIF,t1.UAFECALTA UAFECALTA,t1.UAFECMODIF UAFECMODIF,t1.UAUSUALTA UAUSUALTA,t1.UAUSUMODIF UAUSUMODIF,t1.UACOEM UACOEM,t1.UANODIR UANODIR,t1.UAAPELLIDO1 UAAPELLIDO1,t1.UAAPELLIDO2 UAAPELLIDO2,t1.UAPAIS_ID UAPAISID,t1.UAENTIDAD_ID UAENTIDADID,t1.UANOCO UANOCO,t1.UANOPECO UANOPECO,t1.UAURL UAURL,t1.UASECODIGO UASECODIGO,t1.UASENOMBRE UASENOMBRE,t1.UASENOMBREE UASENOMBREE,t1.UAFECULTMOD UAFECULTMOD,t1.UAUSUULTMOD UAUSUULTMOD,t1.UAFORMANOTIFICACION UAFORMANOTIFICACION,t1.UAIDIOMA UAIDIOMA,t1.UASEXO UASEXO,t1.UAEDAD UAEDAD,t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION ");
		query.append("FROM ARBINTERV t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbinterv, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbinterv>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbinterv arbinterv, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBINTERV t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbinterv, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbinterv entity
	 * 
	 * @param arbinterv
	 *            Arbinterv Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbinterv arbinterv) {

		StringBuilder where = new StringBuilder(ArbintervDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbinterv != null && arbinterv.getUaidinterv() != null) {
			where.append(" AND t1.UAIDINTERV = ?");
			params.add(arbinterv.getUaidinterv());
		}
		if (arbinterv != null && arbinterv.getUanombre() != null) {
			where.append(" AND t1.UANOMBRE = ?");
			params.add(arbinterv.getUanombre());
		}
		if (arbinterv != null && arbinterv.getUanif() != null) {
			where.append(" AND t1.UANIF = ?");
			params.add(arbinterv.getUanif());
		}
		if (arbinterv != null && arbinterv.getUanrtel() != null) {
			where.append(" AND t1.UANRTEL = ?");
			params.add(arbinterv.getUanrtel());
		}
		if (arbinterv != null && arbinterv.getUanrtel2() != null) {
			where.append(" AND t1.UANRTEL2 = ?");
			params.add(arbinterv.getUanrtel2());
		}
		if (arbinterv != null && arbinterv.getUaprovId() != null) {
			where.append(" AND t1.UAPROV_ID = ?");
			params.add(arbinterv.getUaprovId());
		}
		if (arbinterv != null && arbinterv.getUamunId() != null) {
			where.append(" AND t1.UAMUN_ID = ?");
			params.add(arbinterv.getUamunId());
		}
		if (arbinterv != null && arbinterv.getUalocId() != null) {
			where.append(" AND t1.UALOC_ID = ?");
			params.add(arbinterv.getUalocId());
		}
		if (arbinterv != null && arbinterv.getUacalleId() != null) {
			where.append(" AND t1.UACALLE_ID = ?");
			params.add(arbinterv.getUacalleId());
		}
		if (arbinterv != null && arbinterv.getUacpId() != null) {
			where.append(" AND t1.UACP_ID = ?");
			params.add(arbinterv.getUacpId());
		}
		if (arbinterv != null && arbinterv.getUaportalId() != null) {
			where.append(" AND t1.UAPORTAL_ID = ?");
			params.add(arbinterv.getUaportalId());
		}
		if (arbinterv != null && arbinterv.getUanombrePiso() != null) {
			where.append(" AND t1.UANOMBRE_PISO = ?");
			params.add(arbinterv.getUanombrePiso());
		}
		if (arbinterv != null && arbinterv.getUadireNocapv() != null) {
			where.append(" AND t1.UADIRE_NOCAPV = ?");
			params.add(arbinterv.getUadireNocapv());
		}
		if (arbinterv != null && arbinterv.getUadireAnt() != null) {
			where.append(" AND t1.UADIRE_ANT = ?");
			params.add(arbinterv.getUadireAnt());
		}
		if (arbinterv != null && arbinterv.getUatipointerv() != null) {
			where.append(" AND t1.UATIPOINTERV = ?");
			params.add(arbinterv.getUatipointerv());
		}
		if (arbinterv != null && arbinterv.getUaexcodigo() != null) {
			where.append(" AND t1.UAEXCODIGO = ?");
			params.add(arbinterv.getUaexcodigo());
		}
		if (arbinterv != null && arbinterv.getUadtcodigo() != null) {
			where.append(" AND t1.UADTCODIGO = ?");
			params.add(arbinterv.getUadtcodigo());
		}
		if (arbinterv != null && arbinterv.getUaescodigo() != null) {
			where.append(" AND t1.UAESCODIGO = ?");
			params.add(arbinterv.getUaescodigo());
		}
		if (arbinterv != null && arbinterv.getUatrfecalta() != null) {
			where.append(" AND t1.UATRFECALTA = ?");
			params.add(arbinterv.getUatrfecalta());
		}
		if (arbinterv != null && arbinterv.getUatrfecmodif() != null) {
			where.append(" AND t1.UATRFECMODIF = ?");
			params.add(arbinterv.getUatrfecmodif());
		}
		if (arbinterv != null && arbinterv.getUatrusualta() != null) {
			where.append(" AND t1.UATRUSUALTA = ?");
			params.add(arbinterv.getUatrusualta());
		}
		if (arbinterv != null && arbinterv.getUatrusumodif() != null) {
			where.append(" AND t1.UATRUSUMODIF = ?");
			params.add(arbinterv.getUatrusumodif());
		}
		if (arbinterv != null && arbinterv.getUafecalta() != null) {
			where.append(" AND t1.UAFECALTA = ?");
			params.add(arbinterv.getUafecalta());
		}
		if (arbinterv != null && arbinterv.getUafecmodif() != null) {
			where.append(" AND t1.UAFECMODIF = ?");
			params.add(arbinterv.getUafecmodif());
		}
		if (arbinterv != null && arbinterv.getUausualta() != null) {
			where.append(" AND t1.UAUSUALTA = ?");
			params.add(arbinterv.getUausualta());
		}
		if (arbinterv != null && arbinterv.getUausumodif() != null) {
			where.append(" AND t1.UAUSUMODIF = ?");
			params.add(arbinterv.getUausumodif());
		}
		if (arbinterv != null && arbinterv.getUacoem() != null) {
			where.append(" AND t1.UACOEM = ?");
			params.add(arbinterv.getUacoem());
		}
		if (arbinterv != null && arbinterv.getUanodir() != null) {
			where.append(" AND t1.UANODIR = ?");
			params.add(arbinterv.getUanodir());
		}
		if (arbinterv != null && arbinterv.getUaapellido1() != null) {
			where.append(" AND t1.UAAPELLIDO1 = ?");
			params.add(arbinterv.getUaapellido1());
		}
		if (arbinterv != null && arbinterv.getUaapellido2() != null) {
			where.append(" AND t1.UAAPELLIDO2 = ?");
			params.add(arbinterv.getUaapellido2());
		}
		if (arbinterv != null && arbinterv.getUapaisId() != null) {
			where.append(" AND t1.UAPAIS_ID = ?");
			params.add(arbinterv.getUapaisId());
		}
		if (arbinterv != null && arbinterv.getUaentidadId() != null) {
			where.append(" AND t1.UAENTIDAD_ID = ?");
			params.add(arbinterv.getUaentidadId());
		}
		if (arbinterv != null && arbinterv.getUanoco() != null) {
			where.append(" AND t1.UANOCO = ?");
			params.add(arbinterv.getUanoco());
		}
		if (arbinterv != null && arbinterv.getUanopeco() != null) {
			where.append(" AND t1.UANOPECO = ?");
			params.add(arbinterv.getUanopeco());
		}
		if (arbinterv != null && arbinterv.getUaurl() != null) {
			where.append(" AND t1.UAURL = ?");
			params.add(arbinterv.getUaurl());
		}
		if (arbinterv != null && arbinterv.getUasecodigo() != null) {
			where.append(" AND t1.UASECODIGO = ?");
			params.add(arbinterv.getUasecodigo());
		}
		if (arbinterv != null && arbinterv.getUasenombre() != null) {
			where.append(" AND t1.UASENOMBRE = ?");
			params.add(arbinterv.getUasenombre());
		}
		if (arbinterv != null && arbinterv.getUasenombree() != null) {
			where.append(" AND t1.UASENOMBREE = ?");
			params.add(arbinterv.getUasenombree());
		}
		if (arbinterv != null && arbinterv.getUafecultmod() != null) {
			where.append(" AND t1.UAFECULTMOD = ?");
			params.add(arbinterv.getUafecultmod());
		}
		if (arbinterv != null && arbinterv.getUausuultmod() != null) {
			where.append(" AND t1.UAUSUULTMOD = ?");
			params.add(arbinterv.getUausuultmod());
		}
		if (arbinterv != null && arbinterv.getUaformanotificacion() != null) {
			where.append(" AND t1.UAFORMANOTIFICACION = ?");
			params.add(arbinterv.getUaformanotificacion());
		}
		if (arbinterv != null && arbinterv.getUaidioma() != null) {
			where.append(" AND t1.UAIDIOMA = ?");
			params.add(arbinterv.getUaidioma());
		}
		if (arbinterv != null && arbinterv.getUasexo() != null) {
			where.append(" AND t1.UASEXO = ?");
			params.add(arbinterv.getUasexo());
		}
		if (arbinterv != null && arbinterv.getUaedad() != null) {
			where.append(" AND t1.UAEDAD = ?");
			params.add(arbinterv.getUaedad());
		}
		if (arbinterv != null && arbinterv.getUatipoidentificacion() != null) {
			where.append(" AND t1.UATIPOIDENTIFICACION = ?");
			params.add(arbinterv.getUatipoidentificacion());
		}

		if (arbinterv != null && arbinterv.getSolarb() != null && arbinterv.getSolarb().getSacodigo() != null) {
			where.append(" AND t2.SACODIGO = ?");
			params.add(arbinterv.getSolarb().getSacodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbinterv entity
	 * 
	 * @param arbinterv
	 *            Arbinterv Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbinterv arbinterv, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArbintervDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbinterv != null && arbinterv.getUaidinterv() != null) {
			where.append(" AND t1.UAIDINTERV = ?");
			params.add(arbinterv.getUaidinterv());
		}
		if (arbinterv != null && arbinterv.getUanombre() != null) {
			where.append(" AND UPPER(t1.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanombre().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOMBRE IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanif() != null) {
			where.append(" AND UPPER(t1.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanif().toUpperCase() + "%");
			}
			where.append(" AND t1.UANIF IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanrtel() != null) {
			where.append(" AND UPPER(t1.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanrtel().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.UANRTEL IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanrtel2() != null) {
			where.append(" AND UPPER(t1.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.UANRTEL2 IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaprovId() != null) {
			where.append(" AND UPPER(t1.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaprovId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaprovId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPROV_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUamunId() != null) {
			where.append(" AND UPPER(t1.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUamunId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUamunId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAMUN_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUalocId() != null) {
			where.append(" AND UPPER(t1.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUalocId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUalocId().toUpperCase() + "%");
			}
			where.append(" AND t1.UALOC_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUacalleId() != null) {
			where.append(" AND UPPER(t1.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUacalleId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUacalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.UACALLE_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUacpId() != null) {
			where.append(" AND UPPER(t1.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUacpId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUacpId().toUpperCase() + "%");
			}
			where.append(" AND t1.UACP_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaportalId() != null) {
			where.append(" AND UPPER(t1.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaportalId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaportalId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPORTAL_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanombrePiso() != null) {
			where.append(" AND UPPER(t1.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOMBRE_PISO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUadireNocapv() != null) {
			where.append(" AND UPPER(t1.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUadireNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUadireNocapv().toUpperCase() + "%");
			}
			where.append(" AND t1.UADIRE_NOCAPV IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUadireAnt() != null) {
			where.append(" AND UPPER(t1.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUadireAnt().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUadireAnt().toUpperCase() + "%");
			}
			where.append(" AND t1.UADIRE_ANT IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUatipointerv() != null) {
			where.append(" AND UPPER(t1.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUatipointerv().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUatipointerv().toUpperCase() + "%");
			}
			where.append(" AND t1.UATIPOINTERV IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaexcodigo() != null) {
			where.append(" AND UPPER(t1.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaexcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaexcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UAEXCODIGO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUadtcodigo() != null) {
			where.append(" AND UPPER(t1.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUadtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUadtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UADTCODIGO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaescodigo() != null) {
			where.append(" AND UPPER(t1.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaescodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaescodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UAESCODIGO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUatrfecalta() != null) {
			where.append(" AND t1.UATRFECALTA = ?");
			params.add(arbinterv.getUatrfecalta());
		}
		if (arbinterv != null && arbinterv.getUatrfecmodif() != null) {
			where.append(" AND t1.UATRFECMODIF = ?");
			params.add(arbinterv.getUatrfecmodif());
		}
		if (arbinterv != null && arbinterv.getUatrusualta() != null) {
			where.append(" AND UPPER(t1.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUatrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUatrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.UATRUSUALTA IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUatrusumodif() != null) {
			where.append(" AND UPPER(t1.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUatrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUatrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.UATRUSUMODIF IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUafecalta() != null) {
			where.append(" AND t1.UAFECALTA = ?");
			params.add(arbinterv.getUafecalta());
		}
		if (arbinterv != null && arbinterv.getUafecmodif() != null) {
			where.append(" AND t1.UAFECMODIF = ?");
			params.add(arbinterv.getUafecmodif());
		}
		if (arbinterv != null && arbinterv.getUausualta() != null) {
			where.append(" AND UPPER(t1.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUausualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUALTA IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUausumodif() != null) {
			where.append(" AND UPPER(t1.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUMODIF IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUacoem() != null) {
			where.append(" AND UPPER(t1.UACOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUacoem().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUacoem().toUpperCase() + "%");
			}
			where.append(" AND t1.UACOEM IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanodir() != null) {
			where.append(" AND UPPER(t1.UANODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanodir().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanodir().toUpperCase() + "%");
			}
			where.append(" AND t1.UANODIR IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaapellido1() != null) {
			where.append(" AND UPPER(t1.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaapellido1().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaapellido1().toUpperCase() + "%");
			}
			where.append(" AND t1.UAAPELLIDO1 IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaapellido2() != null) {
			where.append(" AND UPPER(t1.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaapellido2().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaapellido2().toUpperCase() + "%");
			}
			where.append(" AND t1.UAAPELLIDO2 IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUapaisId() != null) {
			where.append(" AND UPPER(t1.UAPAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUapaisId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUapaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPAIS_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaentidadId() != null) {
			where.append(" AND UPPER(t1.UAENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaentidadId().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaentidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAENTIDAD_ID IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanoco() != null) {
			where.append(" AND UPPER(t1.UANOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanoco().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanoco().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOCO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUanopeco() != null) {
			where.append(" AND UPPER(t1.UANOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUanopeco().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUanopeco().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOPECO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaurl() != null) {
			where.append(" AND UPPER(t1.UAURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaurl().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaurl().toUpperCase() + "%");
			}
			where.append(" AND t1.UAURL IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUasecodigo() != null) {
			where.append(" AND UPPER(t1.UASECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUasecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUasecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UASECODIGO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUasenombre() != null) {
			where.append(" AND UPPER(t1.UASENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUasenombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUasenombre().toUpperCase() + "%");
			}
			where.append(" AND t1.UASENOMBRE IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUasenombree() != null) {
			where.append(" AND UPPER(t1.UASENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUasenombree().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUasenombree().toUpperCase() + "%");
			}
			where.append(" AND t1.UASENOMBREE IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUafecultmod() != null) {
			where.append(" AND UPPER(t1.UAFECULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUafecultmod().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUafecultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.UAFECULTMOD IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUausuultmod() != null) {
			where.append(" AND UPPER(t1.UAUSUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUausuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUausuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUULTMOD IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaformanotificacion() != null) {
			where.append(" AND UPPER(t1.UAFORMANOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaformanotificacion().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaformanotificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.UAFORMANOTIFICACION IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaidioma() != null) {
			where.append(" AND UPPER(t1.UAIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaidioma().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaidioma().toUpperCase() + "%");
			}
			where.append(" AND t1.UAIDIOMA IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUasexo() != null) {
			where.append(" AND UPPER(t1.UASEXO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUasexo().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUasexo().toUpperCase() + "%");
			}
			where.append(" AND t1.UASEXO IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUaedad() != null) {
			where.append(" AND UPPER(t1.UAEDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUaedad().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUaedad().toUpperCase() + "%");
			}
			where.append(" AND t1.UAEDAD IS NOT NULL");
		}
		if (arbinterv != null && arbinterv.getUatipoidentificacion() != null) {
			where.append(" AND UPPER(t1.UATIPOIDENTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbinterv.getUatipoidentificacion().toUpperCase() + "%");
			} else {
				params.add("%" + arbinterv.getUatipoidentificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.UATIPOIDENTIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Dame reclamado.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbinterv
	 */
	public Arbinterv dameInterviniente(String sacodigo, String tipo) {
		{
			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setSolarb(new Solarb(sacodigo));
			arbinterv.setUatipointerv(tipo);
			List<Arbinterv> listaArbinterv = this.findAll(arbinterv, null);
			if (listaArbinterv != null) {
				if (listaArbinterv.size() > 0) {
					arbinterv = listaArbinterv.get(0);
					return arbinterv;
				}
			}
			return null;

		}
	}

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Intervinientes> findAllIntervinientesColegio(Intervinientes arbinterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE||' '||nvl(t1.UAAPELLIDO1,'')||' '||nvl(t1.UAAPELLIDO2,'') UANOMBRE,t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2, t1.UATIPOINTERV UATIPOINTERV ");
		query.append(" FROM ARBINTERV t1 ,SOLARB t2 ");

		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.UAEXCODIGO= t2.SACODIGO(+) AND t2.SACODIGO = ? ");
		params.add(arbinterv.getIdExpediente());

		if (arbinterv.getTipoInterviniente() != null) {
			where.append(" AND t1.UATIPOINTERV IN (").append(arbinterv.getTipoInterviniente()).append(")");
		}
		if (Y41bConstantes.VALOR_SI.equals(arbinterv.getActivos())) {
			where.append(" AND ((t1.UATIPOINTERV = '").append(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO);
			where.append("' AND t1.UAENTIDAD_ID IN (");
			where.append(" SELECT ARBITRO FROM (");
			where.append(" SELECT CASE WHEN XJACTIVOPSUP='").append(Y41bConstantes.VALOR_SI)
					.append("' THEN SACOARPS ELSE SACOARPT END ARBITRO, ");
			where.append(
					" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol, TREXCODIGO");
			where.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '");
			where.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			where.append("' AND TRESTADO = '");
			where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND TREXCODIGO =  SACODIGO");
			where.append(" UNION ");
			where.append(" SELECT CASE WHEN XJACTIVOAACCSUP='").append(Y41bConstantes.VALOR_SI)
					.append("' THEN SACOARTS ELSE SACOARTT END ARBITRO, ");
			where.append(
					" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol, TREXCODIGO");
			where.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '");
			where.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			where.append("' AND TRESTADO = '");
			where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND TREXCODIGO =  SACODIGO");
			where.append(" UNION ");
			where.append(" SELECT CASE WHEN XJACTIVOOOEESUP='").append(Y41bConstantes.VALOR_SI)
					.append("' THEN SACOARDS ELSE SACOARDT END ARBITRO, ");
			where.append(
					" ROW_NUMBER() OVER (PARTITION BY TREXCODIGO, TRCODIGO ORDER BY TRFECFIN DESC) filaDesigCol, TREXCODIGO");
			where.append(" FROM ARBTRAMEXP, ARBCOLEGIO, SOLARB WHERE TRID = XJTRID AND TRCODIGO = '");
			where.append(Y41bConstantes.TRAMITE_ARBITRAJE_DESIGNACION_COLEGIO);
			where.append("' AND TRESTADO = '");
			where.append(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO).append("' AND TREXCODIGO =  SACODIGO");
			where.append(") WHERE filaDesigCol=1 AND TREXCODIGO=t2.SACODIGO)");
			where.append(" OR t1.UATIPOINTERV  <> '").append(Y41bConstantes.TIPO_INTERVINIENTEARB_ARBITRO)
					.append("'))");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(), this.rwMapInterviniente,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param uatipointerv
	 *            String
	 * @return List
	 */
	public List<Arbinterv> findAllByTipo(Solarb solarb, String uatipointerv) {
		Arbinterv arbinterv = new Arbinterv();
		arbinterv.setSolarb(new Solarb(solarb.getSacodigo()));
		arbinterv.setUatipointerv(uatipointerv);
		return (List<Arbinterv>) this.findAll(arbinterv, null);
	}

	/**
	 * Updates rows in the Arbinterv table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar) {
		try {
			String query = "UPDATE ARBINTERV SET UAESCODIGO=? WHERE UAESCODIGO=? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {

		}
	}

}
