package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Solarb;

/**
 * ArbintervDao  
 * 
 *  
 */

public interface ArbintervDao {

	/**
	 * Inserts a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv add(Arbinterv arbinterv);

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv update(Arbinterv arbinterv);

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv actualizaFormaNotificacion(Arbinterv arbinterv);

	/**
	 * 
	 * @param arbtinerv
	 *            Arbinterv
	 * @param tipo
	 *            String
	 */
	void updateTipointervinienteAnterior(Arbinterv arbtinerv, String tipo);

	/**
	 * 
	 * @param arbtinerv
	 *            Arbinterv
	 * @param tipo
	 *            String
	 */
	void updateTipointerviniente(Arbinterv arbtinerv, String tipo);

	/**
	 * Finds a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv find(Arbinterv arbinterv);

	/**
	 * Finds a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Arbinterv
	 */
	Arbinterv findOrganismoOrigen(Arbinterv arbinterv);

	/**
	 * Deletes a single row in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return
	 */
	void remove(Arbinterv arbinterv);

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbinterv> findAll(Arbinterv arbinterv, Pagination pagination);

	/**
	 * Counts rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @return Long
	 */
	Long findAllCount(Arbinterv arbinterv);

	/**
	 * Finds rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbinterv> findAllLike(Arbinterv arbinterv, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbinterv arbinterv, Boolean startsWith);

	/**
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbinterv
	 */
	Arbinterv dameInterviniente(String sacodigo, String tipo);

	/**
	 * @param intervinientes
	 * @param pagination
	 * @return
	 */
	List<Intervinientes> findAllIntervinientesColegio(Intervinientes intervinientes, Pagination pagination);

	/**
	 * Finds a List of rows in the Arbinterv table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param uatipointerv
	 *            String
	 * @return List
	 */
	public List<Arbinterv> findAllByTipo(Solarb solarb, String uatipointerv);

	/**
	 * Updates a single row in the Arbinterv table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar);

}
