package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbexpDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ArbexpDaoImpl implements ArbexpDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbexp> rwMap = new RowMapper<Arbexp>() {
		public Arbexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Arbexp retorno = new Arbexp(resultSet.getString("EXCODIGO"), resultSet.getString("EXFOLDERID"),
					resultSet.getString("EXDESCES"), resultSet.getString("EXDESCEU"), resultSet.getDate("EXFECFIN"),
					resultSet.getString("EXIMPORTE"), resultSet.getString("EXTIPRES"), resultSet.getString("EXCAJA1"),
					resultSet.getString("EXCAJA2"), resultSet.getString("EXTRPOSCOD"),
					resultSet.getString("EXMOCODIGO"), resultSet.getString("EXFCODIGO"),
					resultSet.getString("EXMOCODIGOULT"), resultSet.getDate("EXFECALTA"),
					resultSet.getDate("EXFECMODIF"), resultSet.getString("EXUSUALTA"),
					resultSet.getString("EXUSUMODIF"), resultSet.getDate("EXFECPREVFIN"),
					resultSet.getString("EXTRENTIDAD"), resultSet.getDate("HDFECHD"), resultSet.getString("TIPOPROC"),
					resultSet.getString("HDTE"), resultSet.getString("PLATEA"), resultSet.getDate("EXFECINI"),
					resultSet.getString("EXFORMAPRES"));
			retorno.setEximporteSol(resultSet.getBigDecimal("EXIMPORTESOL").toString());
			retorno.setEximporteOtor(resultSet.getBigDecimal("EXIMPORTEOTOR").toString());
			retorno.setExdestnotifreclamante(resultSet.getString("EXDESTNOTIFRECLAMANTE"));
			retorno.setExdestnotifreclamado(resultSet.getString("EXDESTNOTIFRECLAMADO"));
			return retorno;
		}
	};

	private RowMapper<Arbexp> rwMapDetalleExpediente = new RowMapper<Arbexp>() {

		public Arbexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Fase fase = new Fase(resultSet.getString("FASEFCODIGO"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);

			Tramite tramite = new Tramite(resultSet.getString("TRCODIGO"), resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);
			Tramite tramiteEnt = new Tramite(resultSet.getString("TRCODIGOENT"), resultSet.getString("TRNOMBREENT"),
					resultSet.getString("TRNOMBREEENT"), null, null, null, null, null, null);

			Arbtramexp arbtramexp = new Arbtramexp(resultSet.getString("SantramexpTRID"));
			arbtramexp.setTramite(tramite);

			Arbtramexp arbtramexpEntidad = new Arbtramexp(resultSet.getString("SantramexpTRIDENT"));
			arbtramexpEntidad.setTramite(tramiteEnt);

			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(resultSet.getString("SACOHD"));

			Arbexp arbexp = new Arbexp(resultSet.getString("EXCODIGO"), resultSet.getString("EXCOOR"),
					resultSet.getString("EXFOLDERID"), resultSet.getString("EXDESCES"), resultSet.getString("EXDESCEU"),
					resultSet.getDate("EXFECPREVFIN"), resultSet.getDate("EXFECFIN"), resultSet.getString("EXIMPORTE"),
					resultSet.getString("EXTIPRES"), resultSet.getString("EXCAJA1"), resultSet.getString("EXCAJA2"),
					resultSet.getString("EXMOCODIGO"), resultSet.getString("MONOMBRE"), fase,
					resultSet.getString("EXMOCODIGOULT"), resultSet.getDate("EXFECALTA"),
					resultSet.getDate("EXFECMODIF"), resultSet.getString("EXUSUALTA"),
					resultSet.getString("EXUSUMODIF"), arbtramexp, arbtramexpEntidad, hechoDenunciado,
					resultSet.getDate("HDFECHD"), resultSet.getString("HDTE"), new Motivo(null, null, null),
					new Producto(), resultSet.getString("TIPOPROC"), resultSet.getString("PLATEA"),
					resultSet.getString("HDCOTSR"), resultSet.getBigDecimal("HDCAPTSO"),
					resultSet.getString("HDFORMAVENTA"), resultSet.getString("HDTESO"),
					resultSet.getString("EXFORMAPRES"), resultSet.getDate("EXFECINI"), resultSet.getDate("EXFECREG"),
					resultSet.getString("EXREGEN"), resultSet.getString("EXTIPPRES"), resultSet.getString("EXNUMODR"),
					resultSet.getDate("EXFECENVCITPC"), resultSet.getDate("EXFECENVLAUD"),
					resultSet.getDate("EXFECNOTLAUD"), resultSet.getDate("EXFECENVACLA"),
					resultSet.getDate("EXFECNOTACLA"), resultSet.getDate("EXFECENVCONV"),
					resultSet.getDate("EXFECNOTCONV"), resultSet.getDate("EXFECENVSUBS"),
					resultSet.getDate("EXFECNOTSUBS"), resultSet.getDate("EXFECENVCITAC"),
					resultSet.getDate("EXFECNOTCITAC"), resultSet.getDate("EXFECENVCITAE"),
					resultSet.getDate("EXFECNOTCITAE"), resultSet.getDate("EXFECNOTCITPC"),
					resultSet.getDate("EXFECENVCITPE"), resultSet.getDate("EXFECNOTCITPE"),
					resultSet.getDate("EXFECENVCIT2C"), resultSet.getDate("EXFECNOTCIT2C"),
					resultSet.getDate("EXFECENVCIT2E"), resultSet.getDate("EXFECNOTCIT2E"),
					resultSet.getDate("EXFECENVSUSPC"), resultSet.getDate("EXFECNOTSUSPC"),
					resultSet.getDate("EXFECENVSUSPE"), resultSet.getDate("EXFECNOTSUSPE"),
					resultSet.getDate("EXFECRESO"), resultSet.getDate("EXFECENVRESOC"),
					resultSet.getDate("EXFECNOTRESOC"), resultSet.getDate("EXFECENVRESOE"),
					resultSet.getDate("EXFECNOTRESOE"), resultSet.getDate("EXFECENVINFPC"),
					resultSet.getDate("EXFECNOTINFPC"), resultSet.getDate("EXFECENVINFPE"),
					resultSet.getDate("EXFECNOTINFPE"), resultSet.getDate("EXFECENVPAGPC"),
					resultSet.getDate("EXFECNOTPAGPC"), resultSet.getDate("EXFECENVPAGPE"),
					resultSet.getDate("EXFECNOTPAGPE"), resultSet.getDate("EXFECALEGC"),
					resultSet.getDate("EXFECALEGE"), resultSet.getDate("EXFECSUBS"), resultSet.getString("EXIDISOL"),
					resultSet.getString("EXNUMREGISTROORIGEN"), resultSet.getDate("EXFECHAREGISTROORIGEN")

			);

			arbexp.setExcoorg(resultSet.getString("EXCOORG"));
			arbexp.setOrganico(resultSet.getString("SACOJA"));
			arbexp.setEximporteSol(resultSet.getBigDecimal("EXIMPORTESOL") != null
					? resultSet.getBigDecimal("EXIMPORTESOL").toString() : null);
			arbexp.setEximporteOtor(resultSet.getBigDecimal("EXIMPORTEOTOR") != null
					? resultSet.getBigDecimal("EXIMPORTEOTOR").toString() : null);
			arbexp.setExdestnotifreclamante(resultSet.getString("EXDESTNOTIFRECLAMANTE"));
			arbexp.setExdestnotifreclamado(resultSet.getString("EXDESTNOTIFRECLAMADO"));

			arbexp.setExpartrecl(resultSet.getString("EXPARTRECL"));

			arbexp.setExidparticipacionreclamante(resultSet.getString("EXIDPARTICIPACIONRECLAMANTE"));
			arbexp.setExidparticipacionreclamado(resultSet.getString("EXIDPARTICIPACIONRECLAMADO"));

			arbexp.setIsSir(null != resultSet.getString("ISSIR") ? resultSet.getString("ISSIR") : null);

			return arbexp;
		}
	};

	private RowMapper<Arbexp> rwMapPKExpediente = new RowMapper<Arbexp>() {

		public Arbexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Arbexp arbexp = new Arbexp(resultSet.getString("EXCODIGO"));

			return arbexp;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Pagination
	 * @return Arbexp
	 */
	public Arbexp add(Arbexp arbexp) {
		String query = "INSERT INTO ARBEXP (EXCODIGO, EXCOORG, EXFOLDERID, EXDESCES, EXDESCEU, EXFECFIN,  EXIMPORTE,  EXTIPRES, EXCAJA1, EXCAJA2, EXTRPOSCOD, EXMOCODIGO, EXFCODIGO, EXMOCODIGOULT,  EXFECALTA, EXFECMODIF, EXUSUALTA, EXUSUMODIF, EXFECPREVFIN, EXTRENTIDAD,  HDFECHD, TIPOPROC,   HDTE,  PLATEA, HDCOTSR,HDCAPTSO, HDFORMAVENTA, HDTESO, EXFECINI,EXFORMAPRES,  EXFECREG, EXREGEN, EXTIPPRES, EXNUMODR, EXFECENVCITPC, EXFECENVLAUD, EXFECNOTLAUD, EXFECENVACLA, EXFECNOTACLA, EXFECENVCONV, EXFECNOTCONV, EXFECENVSUBS, EXFECNOTSUBS, EXFECENVCITAC, EXFECNOTCITAC, EXFECENVCITAE, EXFECNOTCITAE, EXFECNOTCITPC, EXFECENVCITPE, EXFECNOTCITPE, EXFECENVCIT2C, EXFECNOTCIT2C, EXFECENVCIT2E, EXFECNOTCIT2E, EXFECENVSUSPC, EXFECNOTSUSPC, EXFECENVSUSPE, EXFECNOTSUSPE, EXFECRESO, EXFECENVRESOC, EXFECNOTRESOC, EXFECENVRESOE, EXFECNOTRESOE, EXFECENVINFPC, EXFECNOTINFPC, EXFECENVINFPE, EXFECNOTINFPE, EXFECENVPAGPC, EXFECNOTPAGPC, EXFECENVPAGPE, EXFECNOTPAGPE, EXFECALEGC, EXFECALEGE, EXFECSUBS,EXIDISOL,EXNUMREGISTROORIGEN,EXFECHAREGISTROORIGEN, EXDESTNOTIFRECLAMANTE, EXDESTNOTIFRECLAMADO,EXPARTRECL, ISSIR, ARSOLICITANTE, ARRESUMEN) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getArbtramexpTridAux = null;
		Object getArbtramexpEntidadTridAux = null;
		if (arbexp.getArbtramexp() != null && arbexp.getArbtramexp().getTrid() != null) {
			getArbtramexpTridAux = arbexp.getArbtramexp().getTrid();
		}
		if (arbexp.getArbtramexpEntidad() != null && arbexp.getArbtramexpEntidad().getTrid() != null) {
			getArbtramexpEntidadTridAux = arbexp.getArbtramexpEntidad().getTrid();
		}
		Object getFaseAux = null;
		if (arbexp.getFase() != null && arbexp.getFase().getFcodigo() != null) {
			getFaseAux = arbexp.getFase().getFcodigo();
		}
		this.jdbcTemplate.update(query, arbexp.getExcodigo(), arbexp.getExcoorg(), arbexp.getExfolderid(),
				arbexp.getExdesces(), arbexp.getExdesceu(), arbexp.getExfecfin(), arbexp.getEximporte(),
				arbexp.getExtipres(), arbexp.getExcaja1(), arbexp.getExcaja2(), getArbtramexpTridAux,
				arbexp.getExmocodigo(), getFaseAux, arbexp.getExmocodigoult(), arbexp.getExfecalta(),
				arbexp.getExfecmodif(), arbexp.getExusualta(), arbexp.getExusumodif(), arbexp.getExfecprevfin(),
				getArbtramexpEntidadTridAux, arbexp.getHdfechd(), arbexp.getTipoproc(), arbexp.getHdte(),
				arbexp.getPlatea(), arbexp.getHdcotsr(),
				(arbexp.getHdcaptso() != null ? arbexp.getHdcaptso().setScale(2, BigDecimal.ROUND_CEILING)
						: arbexp.getHdcaptso()),
				arbexp.getHdformaventa(), arbexp.getHdteso(), arbexp.getExfecini(), arbexp.getExformapres(),
				arbexp.getExfecreg(), arbexp.getExregen(), arbexp.getExtippres(), arbexp.getExnumodr(),
				arbexp.getExfecenvcitpc(), arbexp.getExfecenvlaud(), arbexp.getExfecnotlaud(), arbexp.getExfecenvacla(),
				arbexp.getExfecnotacla(), arbexp.getExfecenvconv(), arbexp.getExfecnotconv(), arbexp.getExfecenvsubs(),
				arbexp.getExfecnotsubs(), arbexp.getExfecenvcitac(), arbexp.getExfecnotcitac(),
				arbexp.getExfecenvcitae(), arbexp.getExfecnotcitae(), arbexp.getExfecnotcitpc(),
				arbexp.getExfecenvcitpe(), arbexp.getExfecnotcitpe(), arbexp.getExfecenvcit2c(),
				arbexp.getExfecnotcit2c(), arbexp.getExfecenvcit2e(), arbexp.getExfecnotcit2e(),
				arbexp.getExfecenvsuspc(), arbexp.getExfecnotsuspc(), arbexp.getExfecenvsuspe(),
				arbexp.getExfecnotsuspe(), arbexp.getExfecreso(), arbexp.getExfecenvresoc(), arbexp.getExfecnotresoc(),
				arbexp.getExfecenvresoe(), arbexp.getExfecnotresoe(), arbexp.getExfecenvinfpc(),
				arbexp.getExfecnotinfpc(), arbexp.getExfecenvinfpe(), arbexp.getExfecnotinfpe(),
				arbexp.getExfecenvpagpc(), arbexp.getExfecnotpagpc(), arbexp.getExfecenvpagpe(),
				arbexp.getExfecnotpagpe(), arbexp.getExfecalegc(), arbexp.getExfecalege(), arbexp.getExfecsubs(),
				arbexp.getExidisol(), arbexp.getExnumregistroorigen(), arbexp.getExfecharegistroorigen(),
				arbexp.getExdestnotifreclamante(), arbexp.getExdestnotifreclamado(), arbexp.getExpartrecl(),
				arbexp.getIsSir(), arbexp.getArSolicitante(), arbexp.getArResumen());

		return arbexp;
	}

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Pagination
	 * @return Arbexp
	 */
	public Arbexp update(Arbexp arbexp) {
		String query = "UPDATE ARBEXP SET EXCOORG=?, HDCOTSR=?, HDCAPTSO=?, HDTESO=?, HDFORMAVENTA=?, EXFOLDERID=?, EXDESCES=?, EXDESCEU=?, EXFECFIN=?, EXIMPORTE=?,  EXTIPRES=?, EXCAJA1=?, EXCAJA2=?, EXTRPOSCOD=?, EXMOCODIGO=?, EXFCODIGO=?, EXMOCODIGOULT=?, EXFECPREVFIN=?, EXTRENTIDAD=?, HDFECHD=?,  TIPOPROC=?,    HDTE=?,  PLATEA=?, EXFECINI=?,EXFORMAPRES=?,  EXFECREG=?, EXREGEN=?, EXTIPPRES=?, EXNUMODR=?, EXFECENVCITPC=?, EXFECENVLAUD=?, EXFECNOTLAUD=?, EXFECENVACLA=?, EXFECNOTACLA=?, EXFECENVCONV=?, EXFECNOTCONV=?, EXFECENVSUBS=?, EXFECNOTSUBS=?, EXFECENVCITAC=?, EXFECNOTCITAC=?, EXFECENVCITAE=?, EXFECNOTCITAE=?, EXFECNOTCITPC=?, EXFECENVCITPE=?, EXFECNOTCITPE=?, EXFECENVCIT2C=?, EXFECNOTCIT2C=?, EXFECENVCIT2E=?, EXFECNOTCIT2E=?, EXFECENVSUSPC=?, EXFECNOTSUSPC=?, EXFECENVSUSPE=?, EXFECNOTSUSPE=?, EXFECRESO=?, EXFECENVRESOC=?, EXFECNOTRESOC=?, EXFECENVRESOE=?, EXFECNOTRESOE=?, EXFECENVINFPC=?, EXFECNOTINFPC=?, EXFECENVINFPE=?, EXFECNOTINFPE=?, EXFECENVPAGPC=?, EXFECNOTPAGPC=?, EXFECENVPAGPE=?, EXFECNOTPAGPE=?, EXFECALEGC=?, EXFECALEGE=?, EXFECSUBS=?, EXIDISOL=?, EXNUMREGISTROORIGEN=?, EXFECHAREGISTROORIGEN=?, EXIMPORTESOL=?, EXIMPORTEOTOR=?, EXDESTNOTIFRECLAMANTE=?, EXDESTNOTIFRECLAMADO=? WHERE EXCODIGO=?";

		Object getArbtramexpTridAux = null;
		Object getArbtramexpEntidadTridAux = null;
		if (arbexp.getArbtramexp() != null && arbexp.getArbtramexp().getTrid() != null) {
			getArbtramexpTridAux = arbexp.getArbtramexp().getTrid();
		}
		if (arbexp.getArbtramexpEntidad() != null && arbexp.getArbtramexpEntidad().getTrid() != null) {
			getArbtramexpEntidadTridAux = arbexp.getArbtramexpEntidad().getTrid();
		}
		Object getFaseAux = null;
		if (arbexp.getFase() != null && arbexp.getFase().getFcodigo() != null) {
			getFaseAux = arbexp.getFase().getFcodigo();
		}
		this.jdbcTemplate.update(query, arbexp.getExcoorg(), arbexp.getHdcotsr(), arbexp.getHdcaptso(),
				arbexp.getHdteso(), arbexp.getHdformaventa(), arbexp.getExfolderid(), arbexp.getExdesces(),
				arbexp.getExdesceu(), arbexp.getExfecfin(), arbexp.getEximporte(), arbexp.getExtipres(),
				arbexp.getExcaja1(), arbexp.getExcaja2(), getArbtramexpTridAux, arbexp.getExmocodigo(), getFaseAux,
				arbexp.getExmocodigoult(),
				// arbexp.getExfecalta(),
				// arbexp.getExfecmodif(),
				// arbexp.getExusualta(),
				// arbexp.getExusumodif(),
				arbexp.getExfecprevfin(), getArbtramexpEntidadTridAux, arbexp.getHdfechd(), arbexp.getTipoproc(),
				arbexp.getHdte(), arbexp.getPlatea(), arbexp.getExfecini(), arbexp.getExformapres(),
				arbexp.getExfecreg(), arbexp.getExregen(), arbexp.getExtippres(), arbexp.getExnumodr(),
				arbexp.getExfecenvcitpc(), arbexp.getExfecenvlaud(), arbexp.getExfecnotlaud(), arbexp.getExfecenvacla(),
				arbexp.getExfecnotacla(), arbexp.getExfecenvconv(), arbexp.getExfecnotconv(), arbexp.getExfecenvsubs(),
				arbexp.getExfecnotsubs(), arbexp.getExfecenvcitac(), arbexp.getExfecnotcitac(),
				arbexp.getExfecenvcitae(), arbexp.getExfecnotcitae(), arbexp.getExfecnotcitpc(),
				arbexp.getExfecenvcitpe(), arbexp.getExfecnotcitpe(), arbexp.getExfecenvcit2c(),
				arbexp.getExfecnotcit2c(), arbexp.getExfecenvcit2e(), arbexp.getExfecnotcit2e(),
				arbexp.getExfecenvsuspc(), arbexp.getExfecnotsuspc(), arbexp.getExfecenvsuspe(),
				arbexp.getExfecnotsuspe(), arbexp.getExfecreso(), arbexp.getExfecenvresoc(), arbexp.getExfecnotresoc(),
				arbexp.getExfecenvresoe(), arbexp.getExfecnotresoe(), arbexp.getExfecenvinfpc(),
				arbexp.getExfecnotinfpc(), arbexp.getExfecenvinfpe(), arbexp.getExfecnotinfpe(),
				arbexp.getExfecenvpagpc(), arbexp.getExfecnotpagpc(), arbexp.getExfecenvpagpe(),
				arbexp.getExfecnotpagpe(), arbexp.getExfecalegc(), arbexp.getExfecalege(), arbexp.getExfecsubs(),
				arbexp.getExidisol(), arbexp.getExnumregistroorigen(), arbexp.getExfecharegistroorigen(),
				!Y41bUtils.esNullOCadenaVacia(arbexp.getEximporteSol()) ? new BigDecimal(arbexp.getEximporteSol())
						: null,
				!Y41bUtils.esNullOCadenaVacia(arbexp.getEximporteOtor()) ? new BigDecimal(arbexp.getEximporteOtor())
						: null,
				arbexp.getExdestnotifreclamante(), arbexp.getExdestnotifreclamado(), arbexp.getExcodigo());
		return arbexp;
	}

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Pagination
	 * @return Arbexp
	 */
	@Transactional(readOnly = true)
	public Arbexp find(Arbexp arbexp) {

		StringBuilder query = new StringBuilder("SELECT t0.SACOHD SACOHD, t0.SACOJA SACOJA, t1.EXCOORG EXCOORG, ");
		query.append(
				" t1.EXCODIGO EXCODIGO, t1.EXFOLDERID EXFOLDERID, t1.EXDESCES EXDESCES, t1.EXDESCEU EXDESCEU, t1.EXFECFIN EXFECFIN, t1.EXIMPORTE EXIMPORTE, t1.EXTIPRES EXTIPRES, t1.EXCAJA1 EXCAJA1, t1.EXCAJA2 EXCAJA2, t1.EXTRPOSCOD EXTRPOSCOD, t1.EXMOCODIGO EXMOCODIGO, t1.EXFCODIGO EXFCODIGO, t1.EXMOCODIGOULT EXMOCODIGOULT, t1.EXFECALTA EXFECALTA, t1.EXFECMODIF EXFECMODIF, t1.EXUSUALTA EXUSUALTA, t1.EXUSUMODIF EXUSUMODIF, t1.EXFECPREVFIN EXFECPREVFIN, t1.EXTRENTIDAD EXTRENTIDAD, t1.HDFECHD HDFECHD,  t1.TIPOPROC TIPOPROC, t1.HDTE HDTE, t1.PLATEA PLATEA, t1.HDCOTSR HDCOTSR, t1.HDCAPTSO HDCAPTSO, t1.HDFORMAVENTA HDFORMAVENTA, t1.HDTESO HDTESO, t1.EXFORMAPRES EXFORMAPRES, t1.EXFECINI EXFECINI, t1.EXFECREG EXFECREG, t1.EXREGEN EXREGEN, t1.EXTIPPRES EXTIPPRES, t1.EXNUMODR EXNUMODR, t1.EXFECENVCITPC EXFECENVCITPC, t1.EXFECENVLAUD EXFECENVLAUD, t1.EXFECNOTLAUD EXFECNOTLAUD, t1.EXFECENVACLA EXFECENVACLA, t1.EXFECNOTACLA EXFECNOTACLA, t1.EXFECENVCONV EXFECENVCONV, t1.EXFECNOTCONV EXFECNOTCONV, t1.EXFECENVSUBS EXFECENVSUBS, t1.EXFECNOTSUBS EXFECNOTSUBS, t1.EXFECENVCITAC EXFECENVCITAC, t1.EXFECNOTCITAC EXFECNOTCITAC, t1.EXFECENVCITAE EXFECENVCITAE, t1.EXFECNOTCITAE EXFECNOTCITAE, t1.EXFECNOTCITPC EXFECNOTCITPC, t1.EXFECENVCITPE EXFECENVCITPE, t1.EXFECNOTCITPE EXFECNOTCITPE, t1.EXFECENVCIT2C EXFECENVCIT2C, t1.EXFECNOTCIT2C EXFECNOTCIT2C, t1.EXFECENVCIT2E EXFECENVCIT2E, t1.EXFECNOTCIT2E EXFECNOTCIT2E, t1.EXFECENVSUSPC EXFECENVSUSPC, t1.EXFECNOTSUSPC EXFECNOTSUSPC, t1.EXFECENVSUSPE EXFECENVSUSPE, t1.EXFECNOTSUSPE EXFECNOTSUSPE, t1.EXFECRESO EXFECRESO, t1.EXFECENVRESOC EXFECENVRESOC, t1.EXFECNOTRESOC EXFECNOTRESOC, t1.EXFECENVRESOE EXFECENVRESOE, t1.EXFECNOTRESOE EXFECNOTRESOE, t1.EXFECENVINFPC EXFECENVINFPC, t1.EXFECNOTINFPC EXFECNOTINFPC, t1.EXFECENVINFPE EXFECENVINFPE, t1.EXFECNOTINFPE EXFECNOTINFPE, t1.EXFECENVPAGPC EXFECENVPAGPC, t1.EXFECNOTPAGPC EXFECNOTPAGPC, t1.EXFECENVPAGPE EXFECENVPAGPE, t1.EXFECNOTPAGPE EXFECNOTPAGPE, t1.EXFECALEGC EXFECALEGC, t1.EXFECALEGE EXFECALEGE, t1.EXFECSUBS EXFECSUBS, t1.EXIDISOL EXIDISOL, t1.EXNUMREGISTROORIGEN EXNUMREGISTROORIGEN, t1.EXFECHAREGISTROORIGEN, t1.EXIMPORTESOL, t1.EXIMPORTEOTOR, t1.EXDESTNOTIFRECLAMANTE EXDESTNOTIFRECLAMANTE, t1.EXDESTNOTIFRECLAMADO EXDESTNOTIFRECLAMADO, t1.EXIDPARTICIPACIONRECLAMANTE EXIDPARTICIPACIONRECLAMANTE, t1.EXIDPARTICIPACIONRECLAMADO EXIDPARTICIPACIONRECLAMADO, t1.ISSIR ISSIR, ");
		query.append(" '' EXCOOR,t2.TRUAIDINTERV TRUAIDINTERV, t5.TRUAIDINTERV TRUAIDINTERVENT, ");
		query.append(" (select MONOMBRE FROM CENSO_MONITOR WHERE MOCODIGO=t1.EXMOCODIGO) MONOMBRE, ");
		query.append(" t2.TRID SANTRAMEXPTRID, t2.TRCODIGO SANTRAMEXPTRCODIGO, ");
		query.append(" t5.TRID SANTRAMEXPTRIDENT, t5.TRCODIGO SANTRAMEXPTRCODIGOENT, ");
		query.append(
				" t3.FCODIGO as FASEFCODIGO, t3.FNOMBRE as FASEFNOMBRE, t3.FNOMBREE as FASEFNOMBREE, T4.TRCODIGO, T4.TRNOMBRE, T4.TRNOMBREE, T6.TRCODIGO TRCODIGOENT, T6.TRNOMBRE TRNOMBREENT, T6.TRNOMBREE TRNOMBREEENT, t1.EXPARTRECL ");
		query.append(" FROM SOLARB t0, ARBEXP t1 , ARBTRAMEXP t2, FASE t3, TRAMITE t4, ARBTRAMEXP t5, TRAMITE t6");
		query.append(
				" WHERE  t1.EXCODIGO = ? AND t1.EXCODIGO =t0.SACODIGO  AND t1.EXTRPOSCOD= t2.TRID(+) AND t1.EXFCODIGO = t3.FCODIGO(+) AND t4.TRCODIGO(+) = t2.TRCODIGO AND t1.EXTRENTIDAD= t5.TRID(+) AND t6.TRCODIGO(+) = t5.TRCODIGO");

		List<Arbexp> arbexpList = this.jdbcTemplate.query(query.toString(), this.rwMapDetalleExpediente,
				arbexp.getExcodigo());
		return (Arbexp) DataAccessUtils.uniqueResult(arbexpList);
	}

	/**
	 * Removes a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Pagination
	 * @return
	 */
	public void remove(Arbexp arbexp) {
		String query = "DELETE FROM ARBEXP WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, arbexp.getExcodigo());
	}

	/**
	 * Finds a List of rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbexp> findAll(Arbexp arbexp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EXCODIGO EXCODIGO,t1.EXFOLDERID EXFOLDERID,t1.EXDESCES EXDESCES,t1.EXDESCEU EXDESCEU,t1.EXFECFIN EXFECFIN,t1.EXIMPORTE EXIMPORTE,t1.EXTIPRES EXTIPRES,t1.EXCAJA1 EXCAJA1,t1.EXCAJA2 EXCAJA2,t1.EXTRPOSCOD EXTRPOSCOD,t1.EXMOCODIGO EXMOCODIGO,t1.EXFCODIGO EXFCODIGO,t1.EXMOCODIGOULT EXMOCODIGOULT,t1.EXFECALTA EXFECALTA,t1.EXFECMODIF EXFECMODIF,t1.EXUSUALTA EXUSUALTA,t1.EXUSUMODIF EXUSUMODIF,t1.EXFECPREVFIN EXFECPREVFIN,t1.EXTRENTIDAD EXTRENTIDAD, t1.HDFECHD HDFECHD, t1.TIPOPROC TIPOPROC, t1.HDTE HDTE,t1.PLATEA PLATEA, t1.EXFECINI EXFECINI, t1.EXFORMAPRES EXFORMAPRES,  t1.EXFECREG EXFECREG, t1.EXREGEN EXREGEN, t1.EXTIPPRES EXTIPPRES, t1.EXNUMODR EXNUMODR, t1.EXIMPORTESOL, t1.EXIMPORTEOTOR, t1.EXDESTNOTIFRECLAMANTE EXDESTNOTIFRECLAMANTE, t1.EXDESTNOTIFRECLAMADO EXDESTNOTIFRECLAMADO ");
		query.append("FROM ARBEXP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbexp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbexp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbexp arbexp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBEXP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbexp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbexp> findAllLike(Arbexp arbexp, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EXCODIGO EXCODIGO,t1.EXFOLDERID EXFOLDERID,t1.EXDESCES EXDESCES,t1.EXDESCEU EXDESCEU,t1.EXFECFIN EXFECFIN,t1.EXIMPORTE EXIMPORTE, t1.EXTIPRES EXTIPRES,t1.EXCAJA1 EXCAJA1,t1.EXCAJA2 EXCAJA2,t1.EXTRPOSCOD EXTRPOSCOD,t1.EXMOCODIGO EXMOCODIGO,t1.EXFCODIGO EXFCODIGO,t1.EXMOCODIGOULT EXMOCODIGOULT,t1.EXFECALTA EXFECALTA,t1.EXFECMODIF EXFECMODIF,t1.EXUSUALTA EXUSUALTA,t1.EXUSUMODIF EXUSUMODIF,t1.EXFECPREVFIN EXFECPREVFIN,t1.EXTRENTIDAD EXTRENTIDAD, t1.HDFECHD HDFECHD, t1.TIPOPROC TIPOPROC, t1.HDTE HDTE, t1.PLATEA PLATEA, t1.EXFECINI EXFECINI, t1.EXFORMAPRES EXFORMAPRES,  t1.EXFECREG EXFECREG, t1.EXREGEN EXREGEN, t1.EXTIPPRES EXTIPPRES, t1.EXNUMODR EXNUMODR, t1.EXIMPORTESOL, t1.EXIMPORTEOTOR, t1.EXDESTNOTIFRECLAMANTE EXDESTNOTIFRECLAMANTE, t1.EXDESTNOTIFRECLAMADO EXDESTNOTFIRECLAMADO ");
		query.append("FROM ARBEXP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbexp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbexp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbexp arbexp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBEXP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbexp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbexp entity
	 * 
	 * @param arbexp
	 *            Arbexp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereMap(Arbexp arbexp) {

		StringBuilder where = new StringBuilder(ArbexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbexp != null && arbexp.getExcodigo() != null) {
			where.append(" AND t1.EXCODIGO = ?");
			params.add(arbexp.getExcodigo());
		}
		if (arbexp != null && arbexp.getExfolderid() != null) {
			where.append(" AND t1.EXFOLDERID = ?");
			params.add(arbexp.getExfolderid());
		}
		if (arbexp != null && arbexp.getExdesces() != null) {
			where.append(" AND t1.EXDESCES = ?");
			params.add(arbexp.getExdesces());
		}
		if (arbexp != null && arbexp.getExdesceu() != null) {
			where.append(" AND t1.EXDESCEU = ?");
			params.add(arbexp.getExdesceu());
		}
		if (arbexp != null && arbexp.getExfecfin() != null) {
			where.append(" AND t1.EXFECFIN = ?");
			params.add(arbexp.getExfecfin());
		}

		if (arbexp != null && arbexp.getEximporte() != null) {
			where.append(" AND t1.EXIMPORTE = ?");
			params.add(arbexp.getEximporte());
		}

		if (arbexp != null && arbexp.getExtipres() != null) {
			where.append(" AND t1.EXTIPRES = ?");
			params.add(arbexp.getExtipres());
		}
		if (arbexp != null && arbexp.getExcaja1() != null) {
			where.append(" AND t1.EXCAJA1 = ?");
			params.add(arbexp.getExcaja1());
		}
		if (arbexp != null && arbexp.getExcaja2() != null) {
			where.append(" AND t1.EXCAJA2 = ?");
			params.add(arbexp.getExcaja2());
		}
		if (arbexp != null && arbexp.getExtrposcod() != null) {
			where.append(" AND t1.EXTRPOSCOD = ?");
			params.add(arbexp.getExtrposcod());
		}
		if (arbexp != null && arbexp.getExmocodigo() != null) {
			where.append(" AND t1.EXMOCODIGO = ?");
			params.add(arbexp.getExmocodigo());
		}
		if (arbexp != null && arbexp.getExfcodigo() != null) {
			where.append(" AND t1.EXFCODIGO = ?");
			params.add(arbexp.getExfcodigo());
		}
		if (arbexp != null && arbexp.getExmocodigoult() != null) {
			where.append(" AND t1.EXMOCODIGOULT = ?");
			params.add(arbexp.getExmocodigoult());
		}

		if (arbexp != null && arbexp.getExfecalta() != null) {
			where.append(" AND t1.EXFECALTA = ?");
			params.add(arbexp.getExfecalta());
		}
		if (arbexp != null && arbexp.getExfecmodif() != null) {
			where.append(" AND t1.EXFECMODIF = ?");
			params.add(arbexp.getExfecmodif());
		}
		if (arbexp != null && arbexp.getExusualta() != null) {
			where.append(" AND t1.EXUSUALTA = ?");
			params.add(arbexp.getExusualta());
		}
		if (arbexp != null && arbexp.getExusumodif() != null) {
			where.append(" AND t1.EXUSUMODIF = ?");
			params.add(arbexp.getExusumodif());
		}
		if (arbexp != null && arbexp.getExfecprevfin() != null) {
			where.append(" AND t1.EXFECPREVFIN = ?");
			params.add(arbexp.getExfecprevfin());
		}
		if (arbexp != null && arbexp.getExtrentidad() != null) {
			where.append(" AND t1.EXTRENTIDAD = ?");
			params.add(arbexp.getExtrentidad());
		}

		if (arbexp != null && arbexp.getHdfechd() != null) {
			where.append(" AND t1.HDFECHD = ?");
			params.add(arbexp.getHdfechd());
		}
		if (arbexp != null && arbexp.getTipoproc() != null) {
			where.append(" AND t1.TIPOPROC = ?");
			params.add(arbexp.getTipoproc());
		}

		if (arbexp != null && arbexp.getHdte() != null) {
			where.append(" AND t1.HDTE = ?");
			params.add(arbexp.getHdte());
		}

		if (arbexp != null && arbexp.getPlatea() != null) {
			where.append(" AND t1.PLATEA = ?");
			params.add(arbexp.getPlatea());
		}

		if (arbexp != null && arbexp.getExformapres() != null) {
			where.append(" AND t1.EXFORMAPRES = ?");
			params.add(arbexp.getExformapres());
		}

		if (arbexp != null && arbexp.getExtipres() != null) {
			where.append(" AND t1.EXTIPPRES = ?");
			params.add(arbexp.getExtipres());
		}

		if (arbexp != null && arbexp.getExnumodr() != null) {
			where.append(" AND t1.EXNUMODR = ?");
			params.add(arbexp.getExnumodr());
		}

		if (arbexp != null && arbexp.getExdestnotifreclamante() != null) {
			where.append(" AND t1.EXDESTNOTIFRECLAMANTE = ?");
			params.add(arbexp.getExdestnotifreclamante());
		}

		if (arbexp != null && arbexp.getExdestnotifreclamado() != null) {
			where.append(" AND t1.EXDESTNOTIFRECLAMADO = ?");
			params.add(arbexp.getExdestnotifreclamado());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbexp entity
	 * 
	 * @param arbexp
	 *            Arbexp Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereLikeMap(Arbexp arbexp, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArbexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbexp != null && arbexp.getExcodigo() != null) {
			where.append(" AND UPPER(t1.EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCODIGO IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExfolderid() != null) {
			where.append(" AND UPPER(t1.EXFOLDERID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExfolderid().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExfolderid().toUpperCase() + "%");
			}
			where.append(" AND t1.EXFOLDERID IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExdesces() != null) {
			where.append(" AND UPPER(t1.EXDESCES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExdesces().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExdesces().toUpperCase() + "%");
			}
			where.append(" AND t1.EXDESCES IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExdesceu() != null) {
			where.append(" AND UPPER(t1.EXDESCEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExdesceu().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExdesceu().toUpperCase() + "%");
			}
			where.append(" AND t1.EXDESCEU IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExfecfin() != null) {
			where.append(" AND t1.EXFECFIN = ?");
			params.add(arbexp.getExfecfin());
		}

		if (arbexp != null && arbexp.getEximporte() != null) {
			where.append(" AND UPPER(t1.EXIMPORTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getEximporte().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getEximporte().toUpperCase() + "%");
			}
			where.append(" AND t1.EXIMPORTE IS NOT NULL");
		}

		if (arbexp != null && arbexp.getExtipres() != null) {
			where.append(" AND UPPER(t1.EXTIPRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExtipres().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExtipres().toUpperCase() + "%");
			}
			where.append(" AND t1.EXTIPRES IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExcaja1() != null) {
			where.append(" AND UPPER(t1.EXCAJA1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExcaja1().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExcaja1().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCAJA1 IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExcaja2() != null) {
			where.append(" AND UPPER(t1.EXCAJA2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExcaja2().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExcaja2().toUpperCase() + "%");
			}
			where.append(" AND t1.EXCAJA2 IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExtrposcod() != null) {
			where.append(" AND t1.EXTRPOSCOD = ?");
			params.add(arbexp.getExtrposcod());
		}
		if (arbexp != null && arbexp.getExmocodigo() != null) {
			where.append(" AND UPPER(t1.EXMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExmocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExmocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EXMOCODIGO IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExfcodigo() != null) {
			where.append(" AND UPPER(t1.EXFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExfcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExfcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.EXFCODIGO IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExmocodigoult() != null) {
			where.append(" AND UPPER(t1.EXMOCODIGOULT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExmocodigoult().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExmocodigoult().toUpperCase() + "%");
			}
			where.append(" AND t1.EXMOCODIGOULT IS NOT NULL");
		}

		if (arbexp != null && arbexp.getExfecalta() != null) {
			where.append(" AND t1.EXFECALTA = ?");
			params.add(arbexp.getExfecalta());
		}
		if (arbexp != null && arbexp.getExfecmodif() != null) {
			where.append(" AND t1.EXFECMODIF = ?");
			params.add(arbexp.getExfecmodif());
		}
		if (arbexp != null && arbexp.getExusualta() != null) {
			where.append(" AND UPPER(t1.EXUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.EXUSUALTA IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExusumodif() != null) {
			where.append(" AND UPPER(t1.EXUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.EXUSUMODIF IS NOT NULL");
		}
		if (arbexp != null && arbexp.getExfecprevfin() != null) {
			where.append(" AND t1.EXFECPREVFIN = ?");
			params.add(arbexp.getExfecprevfin());
		}
		if (arbexp != null && arbexp.getExtrentidad() != null) {
			where.append(" AND t1.EXTRENTIDAD = ?");
			params.add(arbexp.getExtrentidad());
		}

		if (arbexp != null && arbexp.getHdfechd() != null) {
			where.append(" AND t1.HDFECHD = ?");
			params.add(arbexp.getHdfechd());
		}
		if (arbexp != null && arbexp.getTipoproc() != null) {
			where.append(" AND UPPER(t1.TIPOPROC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getTipoproc().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getTipoproc().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOPROC IS NOT NULL");
		}

		if (arbexp != null && arbexp.getHdte() != null) {
			where.append(" AND UPPER(t1.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getHdte().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getHdte().toUpperCase() + "%");
			}
			where.append(" AND t1.HDTE IS NOT NULL");
		}

		if (arbexp != null && arbexp.getPlatea() != null) {
			where.append(" AND UPPER(t1.PLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getPlatea().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getPlatea().toUpperCase() + "%");
			}
			where.append(" AND t1.PLATEA IS NOT NULL");
		}

		if (arbexp != null && arbexp.getExformapres() != null) {
			where.append(" AND UPPER(t1.EXFORMAPRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExformapres().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExformapres().toUpperCase() + "%");
			}
			where.append(" AND t1.EXFORMAPRES IS NOT NULL");
		}

		if (arbexp != null && arbexp.getExformapres() != null) {
			where.append(" AND UPPER(t1.EXTIPPRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExtipres().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExtipres().toUpperCase() + "%");
			}
			where.append(" AND t1.EXTIPPRES IS NOT NULL");
		}

		if (arbexp != null && arbexp.getExformapres() != null) {
			where.append(" AND UPPER(t1.EXNUMODR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbexp.getExnumodr().toUpperCase() + "%");
			} else {
				params.add("%" + arbexp.getExnumodr().toUpperCase() + "%");
			}
			where.append(" AND t1.EXNUMODR IS NOT NULL");
		}

		if (arbexp != null && arbexp.getExdestnotifreclamante() != null) {
			where.append(" AND t1.EXDESTNOTIFRECLAMANTE = ?");
			params.add(arbexp.getExdestnotifreclamante());
		}

		if (arbexp != null && arbexp.getExdestnotifreclamado() != null) {
			where.append(" AND t1.EXDESTNOTIFRECLAMADO = ?");
			params.add(arbexp.getExdestnotifreclamado());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	@Transactional(readOnly = true)
	public Arbexp dameDetallesExpediente(Arbexp arbexp) {
		try {
			StringBuilder query = new StringBuilder("SELECT t0.SACOHD SACOHD, t0.SACOJA SACOJA, t1.EXCOORG EXCOORG, ");
			query.append(
					" t1.EXCODIGO EXCODIGO, t1.EXFOLDERID EXFOLDERID, t1.EXDESCES EXDESCES, t1.EXDESCEU EXDESCEU, t1.EXFECFIN EXFECFIN, t1.EXIMPORTE EXIMPORTE, t1.EXTIPRES EXTIPRES, t1.EXCAJA1 EXCAJA1, t1.EXCAJA2 EXCAJA2, t1.EXTRPOSCOD EXTRPOSCOD, t1.EXMOCODIGO EXMOCODIGO, t1.EXFCODIGO EXFCODIGO, t1.EXMOCODIGOULT EXMOCODIGOULT, t1.EXFECALTA EXFECALTA, t1.EXFECMODIF EXFECMODIF, t1.EXUSUALTA EXUSUALTA, t1.EXUSUMODIF EXUSUMODIF, t1.EXFECPREVFIN EXFECPREVFIN, t1.EXTRENTIDAD EXTRENTIDAD, t1.HDFECHD HDFECHD,  t1.TIPOPROC TIPOPROC, t1.HDTE HDTE, t1.PLATEA PLATEA, t1.HDCOTSR HDCOTSR, t1.HDCAPTSO HDCAPTSO, t1.HDFORMAVENTA HDFORMAVENTA, t1.HDTESO HDTESO, t1.EXFORMAPRES EXFORMAPRES, t1.EXFECINI EXFECINI, t1.EXFECREG EXFECREG, t1.EXREGEN EXREGEN, t1.EXTIPPRES EXTIPPRES, t1.EXNUMODR EXNUMODR, t1.EXFECENVCITPC EXFECENVCITPC, t1.EXFECENVLAUD EXFECENVLAUD, t1.EXFECNOTLAUD EXFECNOTLAUD, t1.EXFECENVACLA EXFECENVACLA, t1.EXFECNOTACLA EXFECNOTACLA, t1.EXFECENVCONV EXFECENVCONV, t1.EXFECNOTCONV EXFECNOTCONV, t1.EXFECENVSUBS EXFECENVSUBS, t1.EXFECNOTSUBS EXFECNOTSUBS, t1.EXFECENVCITAC EXFECENVCITAC, t1.EXFECNOTCITAC EXFECNOTCITAC, t1.EXFECENVCITAE EXFECENVCITAE, t1.EXFECNOTCITAE EXFECNOTCITAE, t1.EXFECNOTCITPC EXFECNOTCITPC, t1.EXFECENVCITPE EXFECENVCITPE, t1.EXFECNOTCITPE EXFECNOTCITPE, t1.EXFECENVCIT2C EXFECENVCIT2C, t1.EXFECNOTCIT2C EXFECNOTCIT2C, t1.EXFECENVCIT2E EXFECENVCIT2E, t1.EXFECNOTCIT2E EXFECNOTCIT2E, t1.EXFECENVSUSPC EXFECENVSUSPC, t1.EXFECNOTSUSPC EXFECNOTSUSPC, t1.EXFECENVSUSPE EXFECENVSUSPE, t1.EXFECNOTSUSPE EXFECNOTSUSPE, t1.EXFECRESO EXFECRESO, t1.EXFECENVRESOC EXFECENVRESOC, t1.EXFECNOTRESOC EXFECNOTRESOC, t1.EXFECENVRESOE EXFECENVRESOE, t1.EXFECNOTRESOE EXFECNOTRESOE, t1.EXFECENVINFPC EXFECENVINFPC, t1.EXFECNOTINFPC EXFECNOTINFPC, t1.EXFECENVINFPE EXFECENVINFPE, t1.EXFECNOTINFPE EXFECNOTINFPE, t1.EXFECENVPAGPC EXFECENVPAGPC, t1.EXFECNOTPAGPC EXFECNOTPAGPC, t1.EXFECENVPAGPE EXFECENVPAGPE, t1.EXFECNOTPAGPE EXFECNOTPAGPE, t1.EXFECALEGC EXFECALEGC, t1.EXFECALEGE EXFECALEGE, t1.EXFECSUBS EXFECSUBS,  t1.EXIDISOL EXIDISOL, t1.EXNUMREGISTROORIGEN EXNUMREGISTROORIGEN, t1.EXFECHAREGISTROORIGEN, t1.EXIMPORTESOL, t1.EXIMPORTEOTOR, t1.EXDESTNOTIFRECLAMANTE EXDESTNOTIFRECLAMANTE, t1.EXDESTNOTIFRECLAMADO EXDESTNOTIFRECLAMADO, t1.EXIDPARTICIPACIONRECLAMANTE EXIDPARTICIPACIONRECLAMANTE, t1.EXIDPARTICIPACIONRECLAMADO EXIDPARTICIPACIONRECLAMADO, t1.ISSIR ISSIR,");
			query.append(" t7.SACOORPR EXCOOR, t2.TRUAIDINTERV TRUAIDINTERV, t5.TRUAIDINTERV TRUAIDINTERVENT, ");
			query.append(" (select MONOMBRE FROM CENSO_MONITOR WHERE MOCODIGO=t1.EXMOCODIGO) MONOMBRE, ");
			query.append(" t2.TRID SANTRAMEXPTRID, t2.TRCODIGO SANTRAMEXPTRCODIGO, ");
			query.append(" t5.TRID SANTRAMEXPTRIDENT, t5.TRCODIGO SANTRAMEXPTRCODIGOENT, ");
			query.append(
					" t3.FCODIGO as FASEFCODIGO, t3.FNOMBRE as FASEFNOMBRE, t3.FNOMBREE as FASEFNOMBREE, T4.TRCODIGO, T4.TRNOMBRE, T4.TRNOMBREE, T6.TRCODIGO TRCODIGOENT, T6.TRNOMBRE TRNOMBREENT, T6.TRNOMBREE TRNOMBREEENT, t1.EXPARTRECL ");
			query.append(
					" FROM SOLARB t0,ARBEXP t1 , ARBTRAMEXP t2, FASE t3, TRAMITE t4, ARBTRAMEXP t5, TRAMITE t6, SOLARB t7 ");
			query.append(
					" WHERE t1.EXCODIGO = ? AND t1.EXCODIGO =t0.SACODIGO  AND t1.EXCODIGO = t7.SACODIGO AND t1.EXTRPOSCOD= t2.TRID(+) AND t1.EXFCODIGO = t3.FCODIGO(+) AND t4.TRCODIGO(+) = t2.TRCODIGO AND t1.EXTRENTIDAD= t5.TRID(+) AND t6.TRCODIGO(+) = t5.TRCODIGO");

			List<Arbexp> arbexpList = this.jdbcTemplate.query(query.toString(), this.rwMapDetalleExpediente,
					arbexp.getExcodigo());
			return (Arbexp) DataAccessUtils.uniqueResult(arbexpList);
		} catch (Exception e) {
			throw new Y41bUDAException(e.getMessage(), null, e);
		}
	}

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	@Transactional(readOnly = true)
	public Arbexp findLobTablaTemporal(Arbexp arbexp) {
		String query = "SELECT EXCODIGO, HDTE FROM ARBEXP WHERE EXCODIGO = ? ";
		return (Arbexp) this.jdbcTemplate.queryForObject(query, new RowMapper<Arbexp>() {
			public Arbexp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Arbexp(resultSet.getString("EXCODIGO"), resultSet.getString("HDTE"));
			}
		}, arbexp.getExcodigo());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbexpDao#updateResponsable(com.ejie.y41b.model.Arbexp)
	 */
	@Override()
	public void updateResponsable(Arbexp arbexp) {
		String query = "UPDATE ARBEXP SET EXMOCODIGO=? WHERE EXCODIGO=?";
		this.jdbcTemplate.update(query, arbexp.getExmocodigo(), arbexp.getExcodigo());
	}

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	public Long findExpedientesAbiertos(Arbexp arbexp) {

		Map<String, ?> mapaWhere = this.getWhereMap(arbexp);
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder("SELECT COUNT(*)");

		where.append("FROM ARBEXP t1 , ARBTRAMEXP t2 ");
		where.append(" WHERE 1=1  AND t1.EXCODIGO=t2.TREXCODIGO(+) AND t1.EXFECFIN IS NULL");

		// Busqueda de solicitudes por lugar de audiencia

		if (arbexp != null && arbexp.getArbtramexp() != null && arbexp.getArbtramexp().getTrclugaud() != null) {
			where.append(" AND ( ");
			where.append(" t2.TRCLUGAUD=? ");
			params.add(arbexp.getArbtramexp().getTrclugaud());
			where.append(" ) ");
		}

		where.append(mapaWhere.get("query"));

		return this.jdbcTemplate.queryForLong(where.toString(), params.toArray());
	}

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	public Arbexp updateInstructorOficina(Arbexp arbexp) {
		try {
			String query = "UPDATE ARBEXP SET EXMOCODIGO=? WHERE EXCODIGO=?";

			this.jdbcTemplate.update(query, arbexp.getExmocodigo(), arbexp.getExcodigo());
			return arbexp;
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a List of rows in the Sanexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbexp> findAllExcodigo(Arbexp arbexp, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.EXCODIGO EXCODIGO FROM ARBEXP t1 ");

		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		if (arbexp != null && arbexp.getExmocodigo() != null) {
			where.append(" AND t1.EXMOCODIGO = ?");
			params.add(arbexp.getExmocodigo());
		}

		// para identificar las sanciones abiertas en los trasvases de
		// instructor
		if (arbexp != null && arbexp.getExfecfin() != null && arbexp.getExfecfin() instanceof Date) {
			where.append(" AND t1.EXFECFIN IS NULL ");
		}

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbexp>) this.jdbcTemplate.query(query.toString(), this.rwMapPKExpediente, params.toArray());
	}

	/**
	 * Metodo para actualizar la participacion del reclamado en Platea
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	public Arbexp actualizarParticipacionReclamado(Arbexp arbexp) {
		String query = "UPDATE ARBEXP SET EXPARTRECL=? WHERE EXCODIGO=?";

		this.jdbcTemplate.update(query, arbexp.getExpartrecl(), arbexp.getExcodigo());

		return arbexp;
	}

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param sacodigo
	 *            String
	 */
	public void updateEXIDPARTICIPACIONRECLAMANTE(Arbinterv arbinterv, String sacodigo) {
		String query = "UPDATE ARBEXP SET EXIDPARTICIPACIONRECLAMANTE=? WHERE EXCODIGO=?";

		this.jdbcTemplate.update(query, arbinterv.getUanif(), sacodigo);

	}

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param sacodigo
	 *            String
	 */
	public void updateEXIDPARTICIPACIONRECLAMADO(Arbinterv arbinterv, String sacodigo) {
		String query = "UPDATE ARBEXP SET EXIDPARTICIPACIONRECLAMADO=? WHERE EXCODIGO=?";

		this.jdbcTemplate.update(query, arbinterv.getUanif(), sacodigo);
	}

	/**
	 * Metodo para actualizar el estado de adhesion del establecimiento
	 * 
	 * @param idExpediente
	 *            String
	 * @param idEstablecimiento
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	public void actualizarEstAdhEstablecimiento(String idExpediente, String idEstablecimiento) throws Exception {
		StringBuilder query = new StringBuilder("UPDATE ARBEXP SET EXESTADHINI = (SELECT CASE")
				.append(" WHEN M.ESFEADAR IS NOT NULL AND M.ESFEADAR<=SYSDATE AND (B.AHFEBA IS NULL OR B.AHFEBA>SYSDATE) AND (M.ESFEBA IS NULL OR M.ESFEBA>SYSDATE) THEN '")
				.append(Y41bConstantes.VALOR_SI).append("'").append(" ELSE '").append(Y41bConstantes.VALOR_NO)
				.append("' END").append(" FROM ESTADH B, ESTABLEC M")
				.append(" WHERE B.AHCOES(+) = M.ESCODIGO AND M.ESCODIGO=?) WHERE EXCODIGO=?");

		this.jdbcTemplate.update(query.toString(), idEstablecimiento, idExpediente);
	}
}
