package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;

/**
 * ArbexpDao  
 * 
 *  
 */

public interface ArbexpDao {

	/**
	 * Inserts a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp add(Arbexp arbexp);

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp update(Arbexp arbexp);

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp find(Arbexp arbexp);

	/**
	 * Deletes a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return
	 */
	void remove(Arbexp arbexp);

	/**
	 * Finds a List of rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbexp> findAll(Arbexp arbexp, Pagination pagination);

	/**
	 * Counts rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	Long findAllCount(Arbexp arbexp);

	/**
	 * Finds rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbexp> findAllLike(Arbexp arbexp, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbexp arbexp, Boolean startsWith);

	/**
	 * Finds a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp dameDetallesExpediente(Arbexp arbexp);

	/**
	 * Finds a single row in the Sanexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp findLobTablaTemporal(Arbexp arbexp);

	/**
	 * updateResponsable
	 * 
	 * @param arbexp
	 *            Arbexp
	 */
	void updateResponsable(Arbexp arbexp);

	/**
	 * Counts rows in the Arbexp table using like.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Long
	 */
	Long findExpedientesAbiertos(Arbexp arbexp);

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp updateInstructorOficina(Arbexp arbexp);

	/**
	 * Finds a List of rows in the Arbexp table.
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @param pagination
	 *            Pagination
	 * @return List<Arbexp>
	 */
	List<Arbexp> findAllExcodigo(Arbexp arbexp, Pagination pagination);

	/**
	 * Metodo para actualizar la participacion del reclamado en Platea
	 * 
	 * @param arbexp
	 *            Arbexp
	 * @return Arbexp
	 */
	Arbexp actualizarParticipacionReclamado(Arbexp arbexp);

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param sacodigo
	 *            String
	 */
	public void updateEXIDPARTICIPACIONRECLAMANTE(Arbinterv arbinterv,
			String sacodigo);

	/**
	 * Updates a single row in the Arbexp table.
	 * 
	 * @param arbinterv
	 *            Arbinterv
	 * @param sacodigo
	 *            String
	 */
	public void updateEXIDPARTICIPACIONRECLAMADO(Arbinterv arbinterv,
			String sacodigo);

	/**
	 * Mtodo para actualizar el estado de adhesin del establecimiento
	 * 
	 * @param idEExpediente
	 *            String
	 * @param idEstablecimiento
	 *            String
	 * @throws Exception
	 *             the exception
	 */
	void actualizarEstAdhEstablecimiento(String idExpediente,
			String idEstablecimiento) throws Exception;
}
