package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.Arbenvio;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.utils.Y41bUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * ArbenvioDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbenvioDaoImpl implements ArbenvioDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbenvio> rwMap = new RowMapper<Arbenvio>() {
		public Arbenvio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils
					.cargarDatosBDVO(resultSet);

			Arbinterv arbinterv = new Arbinterv(
					resultSet.getBigDecimal("ArbintervUAIDINTERV"));
			arbinterv.setUanombre(resultSet.getString("ArbintervUANOMBRE"));
			arbinterv.setUamunId(resultSet.getString("ArbintervUAMUNID"));
			arbinterv
					.setNombreCompleto((resultSet
							.getString("ArbintervUANOMBRE") == null ? ""
							: resultSet
									.getString("ArbintervUANOMBRE")
									.concat(" ")
									.concat(resultSet
											.getString("ArbintervUAAPELLIDO1") == null ? ""
											: resultSet
													.getString("ArbintervUAAPELLIDO1"))
									.concat(" ")
									.concat(resultSet
											.getString("ArbintervUAAPELLIDO2") == null ? ""
											: resultSet
													.getString("ArbintervUAAPELLIDO2")))
							.trim());

			Arbenvio arbenvio = new Arbenvio(resultSet.getBigDecimal("ENID"),
					resultSet.getString("ENEXID"),
					resultSet.getDate("ENFECENVIO"),
					resultSet.getDate("ENFECACUSE"),
					resultSet.getString("ENESTADO"),
					resultSet.getDate("ENFECALTA"),
					resultSet.getDate("ENFECMODIF"),
					resultSet.getString("ENUSUALTA"),
					resultSet.getString("ENUSUMODIF"),
					resultSet.getString("ENTIPOENVIO"), new Arbtramexp(
							resultSet.getString("ArbtramexpTRID")), arbinterv,
					new Solarb(resultSet.getString("ENEXID")), new Arbtramexp());

			arbenvio.getArbtramexpByEntrid().setTrcodigo(
					resultSet.getString("ARBTRAMEXPTRCODIGO"));
			arbenvio.getArbtramexpByEntrid().setTrtiponotplatea(
					resultSet.getString("TRTIPONOTPLATEA"));

			arbenvio.setFecharegistro(resultSet.getDate("FECHAREGISTRO"));
			arbenvio.setTrenvrem(resultSet.getString("TRENVREM"));
			arbenvio.setTrcodrem(resultSet.getString("TRCODREM"));
			arbenvio.setRmestado(resultSet.getString("RMESTADO"));

			arbenvio.setTracusereintentado((columnasSeleccionadas
					.contains("TRACUSEREINTENTADO")) ? resultSet
					.getString("TRACUSEREINTENTADO") : null);

			return arbenvio;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Pagination
	 * @return Arbenvio
	 */
	public Arbenvio add(Arbenvio arbenvio) {
		String query = "INSERT INTO ARBENVIO (ENID, ENTRID, ENINID, ENTRIDACUSE, ENEXID, ENFECENVIO, ENFECACUSE, ENESTADO, ENFECALTA, ENFECMODIF, ENUSUALTA, ENUSUMODIF, ENTIPOENVIO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getArbtramexpByEntridTridAux = null;
		if (arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrid() != null) {
			getArbtramexpByEntridTridAux = arbenvio.getArbtramexpByEntrid()
					.getTrid();
		}
		Object getArbintervUaidintervAux = null;
		if (arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaidinterv() != null) {
			getArbintervUaidintervAux = arbenvio.getArbinterv().getUaidinterv();
		}
		Object getSolarbSacodigoAux = null;
		if (arbenvio.getSolarb() != null
				&& arbenvio.getSolarb().getSacodigo() != null) {
			getSolarbSacodigoAux = arbenvio.getSolarb().getSacodigo();
		}
		Object getArbtramexpByEntridacuseTridAux = null;
		if (arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrid() != null) {
			getArbtramexpByEntridacuseTridAux = arbenvio
					.getArbtramexpByEntridacuse().getTrid();
		}
		this.jdbcTemplate.update(query, arbenvio.getEnid(),
				getArbtramexpByEntridTridAux, getArbintervUaidintervAux,
				getArbtramexpByEntridacuseTridAux, getSolarbSacodigoAux,
				arbenvio.getEnfecenvio(), arbenvio.getEnfecacuse(),
				arbenvio.getEnestado(), arbenvio.getEnfecalta(),
				arbenvio.getEnfecmodif(), arbenvio.getEnusualta(),
				arbenvio.getEnusumodif(), arbenvio.getEntipoenvio());
		return arbenvio;
	}

	/**
	 * Updates a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Pagination
	 * @return Arbenvio
	 */
	public Arbenvio update(Arbenvio arbenvio) {
		String query = "UPDATE ARBENVIO SET ENTRID=?, ENINID=?, ENTRIDACUSE=?, ENEXID=?, ENFECENVIO=?, ENFECACUSE=?, ENESTADO=?, ENFECALTA=?, ENFECMODIF=?, ENUSUALTA=?, ENUSUMODIF=?, ENTIPOENVIO=? WHERE ENID=?";
		Object getArbtramexpByEntridTridAux = null;
		if (arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrid() != null) {
			getArbtramexpByEntridTridAux = arbenvio.getArbtramexpByEntrid()
					.getTrid();
		}
		Object getArbintervUaidintervAux = null;
		if (arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaidinterv() != null) {
			getArbintervUaidintervAux = arbenvio.getArbinterv().getUaidinterv();
		}
		Object getArbtramexpByEntridacuseTridAux = null;
		if (arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrid() != null) {
			getArbtramexpByEntridacuseTridAux = arbenvio
					.getArbtramexpByEntridacuse().getTrid();
		}
		this.jdbcTemplate.update(query, getArbtramexpByEntridTridAux,
				getArbintervUaidintervAux, getArbtramexpByEntridacuseTridAux,
				arbenvio.getEnexid(), arbenvio.getEnfecenvio(),
				arbenvio.getEnfecacuse(), arbenvio.getEnestado(),
				arbenvio.getEnfecalta(), arbenvio.getEnfecmodif(),
				arbenvio.getEnusualta(), arbenvio.getEnusumodif(),
				arbenvio.getEntipoenvio(), arbenvio.getEnid());
		return arbenvio;
	}

	/**
	 * Finds a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Pagination
	 * @return Arbenvio
	 */
	@Transactional(readOnly = true)
	public Arbenvio find(Arbenvio arbenvio) {
		String query = "SELECT t1.ENID ENID, t1.ENEXID ENEXID, t1.ENFECENVIO ENFECENVIO, t1.ENFECACUSE ENFECACUSE, t1.ENESTADO ENESTADO, t1.ENFECALTA ENFECALTA, t1.ENFECMODIF ENFECMODIF, t1.ENUSUALTA ENUSUALTA, t1.ENUSUMODIF ENUSUMODIF, t1.ENTIPOENVIO ENTIPOENVIO, t2.TRENVREM TRENVREM,t2.TRCODREM TRCODREM, t2.TRTIPONOTPLATEA TRTIPONOTPLATEA, "
				+ " t2.TRID ARBTRAMEXPTRID, t2.TRCODIGO ARBTRAMEXPTRCODIGO, t2.TRFECREGS FECHAREGISTRO, t3.UAIDINTERV ARBINTERVUAIDINTERV, t3.UANOMBRE ARBINTERVUANOMBRE, t3.UANIF ARBINTERVUANIF, t3.UANRTEL ARBINTERVUANRTEL, t3.UANRTEL2 ARBINTERVUANRTEL2, t3.UAPROV_ID ARBINTERVUAPROVID, t3.UAMUN_ID ARBINTERVUAMUNID, t3.UALOC_ID ARBINTERVUALOCID, t3.UACALLE_ID ARBINTERVUACALLEID, t3.UACP_ID ARBINTERVUACPID, t3.UAPORTAL_ID ARBINTERVUAPORTALID, t3.UANOMBRE_PISO ARBINTERVUANOMBREPISO, t3.UADIRE_NOCAPV ARBINTERVUADIRENOCAPV, t3.UADIRE_ANT ARBINTERVUADIREANT, t3.UATIPOINTERV ARBINTERVUATIPOINTERV, t3.UAEXCODIGO ARBINTERVUAEXCODIGO, t3.UADTCODIGO ARBINTERVUADTCODIGO, t3.UAESCODIGO ARBINTERVUAESCODIGO, t3.UATRFECALTA ARBINTERVUATRFECALTA, t3.UATRFECMODIF ARBINTERVUATRFECMODIF, t3.UATRUSUALTA ARBINTERVUATRUSUALTA, t3.UATRUSUMODIF ARBINTERVUATRUSUMODIF, t3.UAFECALTA ARBINTERVUAFECALTA, t3.UAFECMODIF ARBINTERVUAFECMODIF, t3.UAUSUALTA ARBINTERVUAUSUALTA, t3.UAUSUMODIF ARBINTERVUAUSUMODIF, t3.UACOEM ARBINTERVUACOEM, t3.UANODIR ARBINTERVUANODIR, t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1, t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2, t3.UAPAIS_ID ARBINTERVUAPAISID, t3.UAENTIDAD_ID ARBINTERVUAENTIDADID, t3.UANOCO ARBINTERVUANOCO, t3.UANOPECO ARBINTERVUANOPECO, t3.UAURL ARBINTERVUAURL, t3.UASECODIGO ARBINTERVUASECODIGO, t3.UASENOMBRE ARBINTERVUASENOMBRE, t3.UASENOMBREE ARBINTERVUASENOMBREE, t3.UAFECULTMOD ARBINTERVUAFECULTMOD, t3.UAUSUULTMOD ARBINTERVUAUSUULTMOD, t3.UAFORMANOTIFICACION ARBINTERVUAFORMANOTIFICACION, t3.UAIDIOMA ARBINTERVUAIDIOMA, t3.UASEXO ARBINTERVUASEXO, t3.UAEDAD ARBINTERVUAEDAD, t3.UATIPOIDENTIFICACION ARBINTERVUATIPOIDENTIFICACION, t6.RMESTADO RMESTADO  FROM ARBENVIO t1 , ARBTRAMEXP t2 , ARBINTERV t3 , ARBTRAMEXP t4, SOLARB t5, REMESA t6  WHERE t1.ENID = ?  AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENTRIDACUSE= t4.TRID(+) AND t1.ENEXID= t5.SACODIGO(+) AND t2.TRCODREM=t6.RMCODIGO(+)  ";

		List<Arbenvio> arbenvioList = this.jdbcTemplate.query(query,
				this.rwMap, arbenvio.getEnid());
		return (Arbenvio) DataAccessUtils.uniqueResult(arbenvioList);
	}

	/**
	 * Removes a single row in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Pagination
	 * @return
	 */
	public void remove(Arbenvio arbenvio) {
		String query = "DELETE FROM ARBENVIO WHERE ENID=?";
		this.jdbcTemplate.update(query, arbenvio.getEnid());
	}

	/**
	 * Finds a List of rows in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbenvio> findAll(Arbenvio arbenvio, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ENID ENID,t1.ENEXID ENEXID,t1.ENFECENVIO ENFECENVIO,t1.ENFECACUSE ENFECACUSE,t1.ENESTADO ENESTADO,t1.ENFECALTA ENFECALTA,t1.ENFECMODIF ENFECMODIF,t1.ENUSUALTA ENUSUALTA,t1.ENUSUMODIF ENUSUMODIF,t1.ENTIPOENVIO ENTIPOENVIO,t2.TRID ARBTRAMEXPTRID,t2.TRCODIGO ARBTRAMEXPTRCODIGO,t2.TRFECREGS FECHAREGISTRO,t2.TRENVREM TRENVREM,t2.TRCODREM TRCODREM, t2.TRTIPONOTPLATEA TRTIPONOTPLATEA,"
						+ "t3.UAIDINTERV ARBINTERVUAIDINTERV,t3.UANOMBRE ARBINTERVUANOMBRE,t3.UANIF ARBINTERVUANIF,t3.UANRTEL ARBINTERVUANRTEL,t3.UANRTEL2 ARBINTERVUANRTEL2,t3.UAPROV_ID ARBINTERVUAPROVID,t3.UAMUN_ID ARBINTERVUAMUNID,t3.UALOC_ID ARBINTERVUALOCID,t3.UACALLE_ID ARBINTERVUACALLEID,t3.UACP_ID ARBINTERVUACPID,t3.UAPORTAL_ID ARBINTERVUAPORTALID,t3.UANOMBRE_PISO ARBINTERVUANOMBREPISO,t3.UADIRE_NOCAPV ARBINTERVUADIRENOCAPV,t3.UADIRE_ANT ARBINTERVUADIREANT,t3.UATIPOINTERV ARBINTERVUATIPOINTERV,t3.UAEXCODIGO ARBINTERVUAEXCODIGO,t3.UADTCODIGO ARBINTERVUADTCODIGO,t3.UAESCODIGO ARBINTERVUAESCODIGO,t3.UATRFECALTA ARBINTERVUATRFECALTA,t3.UATRFECMODIF ARBINTERVUATRFECMODIF,t3.UATRUSUALTA ARBINTERVUATRUSUALTA,t3.UATRUSUMODIF ARBINTERVUATRUSUMODIF,t3.UAFECALTA ARBINTERVUAFECALTA,t3.UAFECMODIF ARBINTERVUAFECMODIF,t3.UAUSUALTA ARBINTERVUAUSUALTA,t3.UAUSUMODIF ARBINTERVUAUSUMODIF,t3.UACOEM ARBINTERVUACOEM,t3.UANODIR ARBINTERVUANODIR,t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2,t3.UAPAIS_ID ARBINTERVUAPAISID,t3.UAENTIDAD_ID ARBINTERVUAENTIDADID,t3.UANOCO ARBINTERVUANOCO,t3.UANOPECO ARBINTERVUANOPECO,t3.UAURL ARBINTERVUAURL,t3.UASECODIGO ARBINTERVUASECODIGO,t3.UASENOMBRE ARBINTERVUASENOMBRE,t3.UASENOMBREE ARBINTERVUASENOMBREE,t3.UAFECULTMOD ARBINTERVUAFECULTMOD,t3.UAUSUULTMOD ARBINTERVUAUSUULTMOD,t3.UAFORMANOTIFICACION ARBINTERVUAFORMANOTIFICACION,t3.UAIDIOMA ARBINTERVUAIDIOMA,t3.UASEXO ARBINTERVUASEXO,t3.UAEDAD ARBINTERVUAEDAD,t3.UATIPOIDENTIFICACION ARBINTERVUATIPOIDENTIFICACION,t4.TRID ARBTRAMEXPTRID2,t4.TRCODIGO ARBTRAMEXPTRCODIGO2, t6.RMESTADO RMESTADO,"
						+ "(SELECT TRACUSEREINTENTADO FROM ARBTRAMEXP ACUSREIN WHERE ACUSREIN.TRTRIDREL=t2.TRID AND ACUSREIN.TRCODIGO='"
						+ Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO
						+ "') AS TRACUSEREINTENTADO");
		query.append(" FROM ARBENVIO t1, ARBTRAMEXP t2, ARBINTERV t3, ARBTRAMEXP t4, SOLARB t5, REMESA t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbenvio);
		StringBuilder where = new StringBuilder(
				" WHERE t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENTRIDACUSE= t4.TRID(+) AND t1.ENEXID= t5.SACODIGO(+) AND t2.TRCODREM=t6.RMCODIGO(+)  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbenvio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbenvio table.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbenvio arbenvio) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBENVIO t1 , ARBTRAMEXP t2 , ARBINTERV t3 , ARBTRAMEXP t4, SOLARB t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbenvio);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENTRIDACUSE= t4.TRID(+) AND t1.ENEXID= t5.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbenvio table using like.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbenvio> findAllLike(Arbenvio arbenvio, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ENID ENID,t1.ENEXID ENEXID,t1.ENFECENVIO ENFECENVIO,t1.ENFECACUSE ENFECACUSE,t1.ENESTADO ENESTADO,t1.ENFECALTA ENFECALTA,t1.ENFECMODIF ENFECMODIF,t1.ENUSUALTA ENUSUALTA,t1.ENUSUMODIF ENUSUMODIF,t1.ENTIPOENVIO ENTIPOENVIO,t2.TRID ARBTRAMEXPTRID,t2.TRCODIGO ARBTRAMEXPTRCODIGO, t2.TRTIPONOTPLATEA TRTIPONOTPLATEA, "
						+ "t3.UAIDINTERV ARBINTERVUAIDINTERV,t3.UANOMBRE ARBINTERVUANOMBRE,t3.UANIF ARBINTERVUANIF,t3.UANRTEL ARBINTERVUANRTEL,t3.UANRTEL2 ARBINTERVUANRTEL2,t3.UAPROV_ID ARBINTERVUAPROVID,t3.UAMUN_ID ARBINTERVUAMUNID,t3.UALOC_ID ARBINTERVUALOCID,t3.UACALLE_ID ARBINTERVUACALLEID,t3.UACP_ID ARBINTERVUACPID,t3.UAPORTAL_ID ARBINTERVUAPORTALID,t3.UANOMBRE_PISO ARBINTERVUANOMBREPISO,t3.UADIRE_NOCAPV ARBINTERVUADIRENOCAPV,t3.UADIRE_ANT ARBINTERVUADIREANT,t3.UATIPOINTERV ARBINTERVUATIPOINTERV,t3.UAEXCODIGO ARBINTERVUAEXCODIGO,t3.UADTCODIGO ARBINTERVUADTCODIGO,t3.UAESCODIGO ARBINTERVUAESCODIGO,t3.UATRFECALTA ARBINTERVUATRFECALTA,t3.UATRFECMODIF ARBINTERVUATRFECMODIF,t3.UATRUSUALTA ARBINTERVUATRUSUALTA,t3.UATRUSUMODIF ARBINTERVUATRUSUMODIF,t3.UAFECALTA ARBINTERVUAFECALTA,t3.UAFECMODIF ARBINTERVUAFECMODIF,t3.UAUSUALTA ARBINTERVUAUSUALTA,t3.UAUSUMODIF ARBINTERVUAUSUMODIF,t3.UACOEM ARBINTERVUACOEM,t3.UANODIR ARBINTERVUANODIR,t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2,t3.UAPAIS_ID ARBINTERVUAPAISID,t3.UAENTIDAD_ID ARBINTERVUAENTIDADID,t3.UANOCO ARBINTERVUANOCO,t3.UANOPECO ARBINTERVUANOPECO,t3.UAURL ARBINTERVUAURL,t3.UASECODIGO ARBINTERVUASECODIGO,t3.UASENOMBRE ARBINTERVUASENOMBRE,t3.UASENOMBREE ARBINTERVUASENOMBREE,t3.UAFECULTMOD ARBINTERVUAFECULTMOD,t3.UAUSUULTMOD ARBINTERVUAUSUULTMOD,t3.UAFORMANOTIFICACION ARBINTERVUAFORMANOTIFICACION,t3.UAIDIOMA ARBINTERVUAIDIOMA,t3.UASEXO ARBINTERVUASEXO,t3.UAEDAD ARBINTERVUAEDAD,t3.UATIPOIDENTIFICACION ARBINTERVUATIPOIDENTIFICACION,t4.TRID ARBTRAMEXPTRID,t4.TRCODIGO ARBTRAMEXPTRCODIGO ");
		query.append("FROM ARBENVIO t1, ARBTRAMEXP t2, ARBINTERV t3, ARBTRAMEXP t4, SOLARB t5, REMESA t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbenvio, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENTRIDACUSE= t4.TRID(+) AND t1.ENEXID= t5.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbenvio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbenvio table using like.
	 * 
	 * @param arbenvio
	 *            Arbenvio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbenvio arbenvio, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBENVIO t1 ,ARBTRAMEXP t2 ,ARBINTERV t3 ,ARBTRAMEXP t4, SOLARB t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbenvio, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ENTRID= t2.TRID(+) AND t1.ENINID= t3.UAIDINTERV(+) AND t1.ENTRIDACUSE= t4.TRID(+) AND t1.ENEXID= t5.SACODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbenvio entity
	 * 
	 * @param arbenvio
	 *            Arbenvio Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbenvio arbenvio) {

		StringBuilder where = new StringBuilder(
				ArbenvioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbenvio != null && arbenvio.getEnid() != null) {
			where.append(" AND t1.ENID = ?");
			params.add(arbenvio.getEnid());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrid());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getArbinterv() != null
				&& arbenvio.getArbtramexpByEntrid().getArbinterv()
						.getUaidinterv() != null) {
			where.append(" AND t2.TRUAIDINTERV = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getArbinterv()
					.getUaidinterv());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrtridrel());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTramite() != null
				&& arbenvio.getArbtramexpByEntrid().getTramite().getTrcodigo() != null) {
			where.append(" AND t2.TRCODIGO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTramite()
					.getTrcodigo());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecini());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecfin());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrnomtrames() != null) {
			where.append(" AND t2.TRNOMTRAMES = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrnomtrames());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getCensoMonitor() != null
				&& arbenvio.getArbtramexpByEntrid().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.TRMOCODIGO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getCensoMonitor()
					.getMocodigo());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getCensoMonitorEj() != null
				&& arbenvio.getArbtramexpByEntrid().getCensoMonitorEj()
						.getMocodigo() != null) {
			where.append(" AND t2.TRMOCODIGOEJ = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getCensoMonitorEj()
					.getMocodigo());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresultado());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresofecha());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresotipo() != null) {
			where.append(" AND t2.TRRESOTIPO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresotipo());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresoimporte());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecenvio());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfeccierre());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getFase() != null
				&& arbenvio.getArbtramexpByEntrid().getFase().getFcodigo() != null) {
			where.append(" AND t2.TRFCODIGO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getFase().getFcodigo());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtiponot() != null) {
			where.append(" AND t2.TRTIPONOT = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrtiponot());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrestado() != null) {
			where.append(" AND t2.TRESTADO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrestado());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecalta());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecmodif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrusualta() != null) {
			where.append(" AND t2.TRUSUALTA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrusualta());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrusumodif() != null) {
			where.append(" AND t2.TRUSUMODIF = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrusumodif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecbopv() != null) {
			where.append(" AND t2.TRFECBOPV = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecbopv());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecinitabl() != null) {
			where.append(" AND t2.TRFECINITABL = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecinitabl());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecnotif() != null) {
			where.append(" AND t2.TRFECNOTIF = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecnotif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrcodigorel() != null) {
			where.append(" AND t2.TRCODIGOREL = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrcodigorel());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridnotifplatea() != null) {
			where.append(" AND t2.TRIDNOTIFPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTridnotifplatea());
		}

		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecregs());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtipocom() != null) {
			where.append(" AND t2.TRTIPOCOM = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrtipocom());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrestadoacuse() != null) {
			where.append(" AND t2.TRESTADOACUSE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrestadoacuse());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrnumregs() != null) {
			where.append(" AND t2.TRNUMREGS = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrnumregs());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecacuse() != null) {
			where.append(" AND t2.TRFECACUSE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecacuse());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridesperaplatea() != null) {
			where.append(" AND t2.TRIDESPERAPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTridesperaplatea());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrmatarespera() != null) {
			where.append(" AND t2.TRMATARESPERA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrmatarespera());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrasuntocomunicacion() != null) {
			where.append(" AND t2.TRASUNTOCOMUNICACION = ?");
			params.add(arbenvio.getArbtramexpByEntrid()
					.getTrasuntocomunicacion());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtiponotplatea() != null) {
			where.append(" AND t2.TRTIPONOTPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrtiponotplatea());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrsede() != null) {
			where.append(" AND t2.TRSEDE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrsede());
		}

		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrcodrem() != null) {
			where.append(" AND t2.TRCODREM = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrcodrem());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrenvrem() != null) {
			where.append(" AND t2.TRENVREM = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrenvrem());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridmailorigen() != null) {
			where.append(" AND t2.TRIDMAILORIGEN = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTridmailorigen());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrmailorigen() != null) {
			where.append(" AND t2.TRMAILORIGEN = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrmailorigen());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridmaildestino() != null) {
			where.append(" AND t2.TRIDMAILDESTINO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTridmaildestino());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrmaildestino() != null) {
			where.append(" AND t2.TRMAILDESTINO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrmaildestino());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfechaenviobopvboe() != null) {
			where.append(" AND t2.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbenvio.getArbtramexpByEntrid()
					.getTrfechaenviobopvboe());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrproceedingsidplatea() != null) {
			where.append(" AND t2.TRIDESPERAPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntrid()
					.getTrproceedingsidplatea());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(arbenvio.getArbinterv().getUaidinterv());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanombre() != null) {
			where.append(" AND t3.UANOMBRE = ?");
			params.add(arbenvio.getArbinterv().getUanombre());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanif() != null) {
			where.append(" AND t3.UANIF = ?");
			params.add(arbenvio.getArbinterv().getUanif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanrtel() != null) {
			where.append(" AND t3.UANRTEL = ?");
			params.add(arbenvio.getArbinterv().getUanrtel());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanrtel2() != null) {
			where.append(" AND t3.UANRTEL2 = ?");
			params.add(arbenvio.getArbinterv().getUanrtel2());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaprovId() != null) {
			where.append(" AND t3.UAPROV_ID = ?");
			params.add(arbenvio.getArbinterv().getUaprovId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUamunId() != null) {
			where.append(" AND t3.UAMUN_ID = ?");
			params.add(arbenvio.getArbinterv().getUamunId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUalocId() != null) {
			where.append(" AND t3.UALOC_ID = ?");
			params.add(arbenvio.getArbinterv().getUalocId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUacalleId() != null) {
			where.append(" AND t3.UACALLE_ID = ?");
			params.add(arbenvio.getArbinterv().getUacalleId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUacpId() != null) {
			where.append(" AND t3.UACP_ID = ?");
			params.add(arbenvio.getArbinterv().getUacpId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaportalId() != null) {
			where.append(" AND t3.UAPORTAL_ID = ?");
			params.add(arbenvio.getArbinterv().getUaportalId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanombrePiso() != null) {
			where.append(" AND t3.UANOMBRE_PISO = ?");
			params.add(arbenvio.getArbinterv().getUanombrePiso());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUadireNocapv() != null) {
			where.append(" AND t3.UADIRE_NOCAPV = ?");
			params.add(arbenvio.getArbinterv().getUadireNocapv());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUadireAnt() != null) {
			where.append(" AND t3.UADIRE_ANT = ?");
			params.add(arbenvio.getArbinterv().getUadireAnt());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatipointerv() != null) {
			where.append(" AND t3.UATIPOINTERV = ?");
			params.add(arbenvio.getArbinterv().getUatipointerv());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaexcodigo() != null) {
			where.append(" AND t3.UAEXCODIGO = ?");
			params.add(arbenvio.getArbinterv().getUaexcodigo());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUadtcodigo() != null) {
			where.append(" AND t3.UADTCODIGO = ?");
			params.add(arbenvio.getArbinterv().getUadtcodigo());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaescodigo() != null) {
			where.append(" AND t3.UAESCODIGO = ?");
			params.add(arbenvio.getArbinterv().getUaescodigo());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(arbenvio.getArbinterv().getUatrfecalta());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(arbenvio.getArbinterv().getUatrfecmodif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrusualta() != null) {
			where.append(" AND t3.UATRUSUALTA = ?");
			params.add(arbenvio.getArbinterv().getUatrusualta());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrusumodif() != null) {
			where.append(" AND t3.UATRUSUMODIF = ?");
			params.add(arbenvio.getArbinterv().getUatrusumodif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(arbenvio.getArbinterv().getUafecalta());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(arbenvio.getArbinterv().getUafecmodif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUausualta() != null) {
			where.append(" AND t3.UAUSUALTA = ?");
			params.add(arbenvio.getArbinterv().getUausualta());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUausumodif() != null) {
			where.append(" AND t3.UAUSUMODIF = ?");
			params.add(arbenvio.getArbinterv().getUausumodif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUacoem() != null) {
			where.append(" AND t3.UACOEM = ?");
			params.add(arbenvio.getArbinterv().getUacoem());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanodir() != null) {
			where.append(" AND t3.UANODIR = ?");
			params.add(arbenvio.getArbinterv().getUanodir());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaapellido1() != null) {
			where.append(" AND t3.UAAPELLIDO1 = ?");
			params.add(arbenvio.getArbinterv().getUaapellido1());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaapellido2() != null) {
			where.append(" AND t3.UAAPELLIDO2 = ?");
			params.add(arbenvio.getArbinterv().getUaapellido2());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUapaisId() != null) {
			where.append(" AND t3.UAPAIS_ID = ?");
			params.add(arbenvio.getArbinterv().getUapaisId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaentidadId() != null) {
			where.append(" AND t3.UAENTIDAD_ID = ?");
			params.add(arbenvio.getArbinterv().getUaentidadId());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanoco() != null) {
			where.append(" AND t3.UANOCO = ?");
			params.add(arbenvio.getArbinterv().getUanoco());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanopeco() != null) {
			where.append(" AND t3.UANOPECO = ?");
			params.add(arbenvio.getArbinterv().getUanopeco());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaurl() != null) {
			where.append(" AND t3.UAURL = ?");
			params.add(arbenvio.getArbinterv().getUaurl());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasecodigo() != null) {
			where.append(" AND t3.UASECODIGO = ?");
			params.add(arbenvio.getArbinterv().getUasecodigo());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasenombre() != null) {
			where.append(" AND t3.UASENOMBRE = ?");
			params.add(arbenvio.getArbinterv().getUasenombre());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasenombree() != null) {
			where.append(" AND t3.UASENOMBREE = ?");
			params.add(arbenvio.getArbinterv().getUasenombree());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUafecultmod() != null) {
			where.append(" AND t3.UAFECULTMOD = ?");
			params.add(arbenvio.getArbinterv().getUafecultmod());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUausuultmod() != null) {
			where.append(" AND t3.UAUSUULTMOD = ?");
			params.add(arbenvio.getArbinterv().getUausuultmod());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaformanotificacion() != null) {
			where.append(" AND t3.UAFORMANOTIFICACION = ?");
			params.add(arbenvio.getArbinterv().getUaformanotificacion());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaidioma() != null) {
			where.append(" AND t3.UAIDIOMA = ?");
			params.add(arbenvio.getArbinterv().getUaidioma());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasexo() != null) {
			where.append(" AND t3.UASEXO = ?");
			params.add(arbenvio.getArbinterv().getUasexo());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaedad() != null) {
			where.append(" AND t3.UAEDAD = ?");
			params.add(arbenvio.getArbinterv().getUaedad());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatipoidentificacion() != null) {
			where.append(" AND t3.UATIPOIDENTIFICACION = ?");
			params.add(arbenvio.getArbinterv().getUatipoidentificacion());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrid() != null) {
			where.append(" AND t4.TRID = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrid());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getArbinterv() != null
				&& arbenvio.getArbtramexpByEntridacuse().getArbinterv()
						.getUaidinterv() != null) {
			where.append(" AND t4.TRUAIDINTERV = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getArbinterv()
					.getUaidinterv());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtridrel() != null) {
			where.append(" AND t4.TRTRIDREL = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrtridrel());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTramite() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND t4.TRCODIGO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTramite()
					.getTrcodigo());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecini() != null) {
			where.append(" AND t4.TRFECINI = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecini());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecfin() != null) {
			where.append(" AND t4.TRFECFIN = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecfin());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrnomtrames() != null) {
			where.append(" AND t4.TRNOMTRAMES = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrnomtrames());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getCensoMonitor() != null
				&& arbenvio.getArbtramexpByEntridacuse().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t4.TRMOCODIGO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getCensoMonitor()
					.getMocodigo());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getCensoMonitorEj() != null
				&& arbenvio.getArbtramexpByEntridacuse().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t4.TRMOCODIGOEJ = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getCensoMonitorEj().getMocodigo());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresultado() != null) {
			where.append(" AND t4.TRRESULTADO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrresultado());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresofecha() != null) {
			where.append(" AND t4.TRRESOFECHA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrresofecha());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresotipo() != null) {
			where.append(" AND t4.TRRESOTIPO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrresotipo());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresoimporte() != null) {
			where.append(" AND t4.TRRESOIMPORTE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrresoimporte());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecenvio() != null) {
			where.append(" AND t4.TRFECENVIO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecenvio());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfeccierre() != null) {
			where.append(" AND t4.TRFECCIERRE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfeccierre());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getFase() != null
				&& arbenvio.getArbtramexpByEntridacuse().getFase().getFcodigo() != null) {
			where.append(" AND t4.TRFCODIGO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getFase()
					.getFcodigo());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtiponot() != null) {
			where.append(" AND t4.TRTIPONOT = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrtiponot());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrestado() != null) {
			where.append(" AND t4.TRESTADO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrestado());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecalta() != null) {
			where.append(" AND t4.TRFECALTA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecalta());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecmodif() != null) {
			where.append(" AND t4.TRFECMODIF = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecmodif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrusualta() != null) {
			where.append(" AND t4.TRUSUALTA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrusualta());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrusumodif() != null) {
			where.append(" AND t4.TRUSUMODIF = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrusumodif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecbopv() != null) {
			where.append(" AND t4.TRFECBOPV = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecbopv());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecinitabl() != null) {
			where.append(" AND t4.TRFECINITABL = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecinitabl());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecnotif() != null) {
			where.append(" AND t4.TRFECNOTIF = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecnotif());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrcodigorel() != null) {
			where.append(" AND t4.TRCODIGOREL = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrcodigorel());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridnotifplatea() != null) {
			where.append(" AND t4.TRIDNOTIFPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTridnotifplatea());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecregs() != null) {
			where.append(" AND t4.TRFECREGS = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecregs());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtipocom() != null) {
			where.append(" AND t4.TRTIPOCOM = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrtipocom());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrestadoacuse() != null) {
			where.append(" AND t4.TRESTADOACUSE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrestadoacuse());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrnumregs() != null) {
			where.append(" AND t4.TRNUMREGS = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrnumregs());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecacuse() != null) {
			where.append(" AND t4.TRFECACUSE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecacuse());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridesperaplatea() != null) {
			where.append(" AND t4.TRIDESPERAPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTridesperaplatea());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrmatarespera() != null) {
			where.append(" AND t4.TRMATARESPERA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrmatarespera());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse()
						.getTrasuntocomunicacion() != null) {
			where.append(" AND t4.TRASUNTOCOMUNICACION = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTrasuntocomunicacion());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtiponotplatea() != null) {
			where.append(" AND t4.TRTIPONOTPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTrtiponotplatea());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrsede() != null) {
			where.append(" AND t4.TRSEDE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrsede());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrcodrem() != null) {
			where.append(" AND t4.TRCODREM = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrcodrem());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrenvrem() != null) {
			where.append(" AND t4.TRENVREM = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrenvrem());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridmailorigen() != null) {
			where.append(" AND t4.TRIDMAILORIGEN = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTridmailorigen());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrmailorigen() != null) {
			where.append(" AND t4.TRMAILORIGEN = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrmailorigen());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridmaildestino() != null) {
			where.append(" AND t4.TRIDMAILDESTINO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTridmaildestino());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrmaildestino() != null) {
			where.append(" AND t4.TRMAILDESTINO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrmaildestino());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse()
						.getTrfechaenviobopvboe() != null) {
			where.append(" AND t4.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTrfechaenviobopvboe());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse()
						.getTrproceedingsidplatea() != null) {
			where.append(" AND t4.TRIDESPERAPLATEA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTrproceedingsidplatea());
		}
		if (arbenvio != null && arbenvio.getEnexid() != null) {
			where.append(" AND t1.ENEXID = ?");
			params.add(arbenvio.getEnexid());
		}
		if (arbenvio != null && arbenvio.getEnfecenvio() != null) {
			where.append(" AND t1.ENFECENVIO = ?");
			params.add(arbenvio.getEnfecenvio());
		}
		if (arbenvio != null && arbenvio.getEnfecacuse() != null) {
			where.append(" AND t1.ENFECACUSE = ?");
			params.add(arbenvio.getEnfecacuse());
		}
		if (arbenvio != null && arbenvio.getEnestado() != null) {
			where.append(" AND t1.ENESTADO = ?");
			params.add(arbenvio.getEnestado());
		}
		if (arbenvio != null && arbenvio.getEnfecalta() != null) {
			where.append(" AND t1.ENFECALTA = ?");
			params.add(arbenvio.getEnfecalta());
		}
		if (arbenvio != null && arbenvio.getEnfecmodif() != null) {
			where.append(" AND t1.ENFECMODIF = ?");
			params.add(arbenvio.getEnfecmodif());
		}
		if (arbenvio != null && arbenvio.getEnusualta() != null) {
			where.append(" AND t1.ENUSUALTA = ?");
			params.add(arbenvio.getEnusualta());
		}
		if (arbenvio != null && arbenvio.getEnusumodif() != null) {
			where.append(" AND t1.ENUSUMODIF = ?");
			params.add(arbenvio.getEnusumodif());
		}
		if (arbenvio != null && arbenvio.getEntipoenvio() != null) {
			where.append(" AND t1.ENTIPOENVIO = ?");
			params.add(arbenvio.getEntipoenvio());
		}

		if (arbenvio != null && arbenvio.getSolarb() != null
				&& arbenvio.getSolarb().getSacodigo() != null) {
			where.append(" AND t5.SACODIGO = ?");
			params.add(arbenvio.getSolarb().getSacodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbenvio entity
	 * 
	 * @param arbenvio
	 *            Arbenvio Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbenvio arbenvio, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbenvioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbenvio != null && arbenvio.getEnid() != null) {
			where.append(" AND t1.ENID = ?");
			params.add(arbenvio.getEnid());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrid() != null) {
			where.append(" AND t2.TRID = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrid());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getArbinterv() != null
				&& arbenvio.getArbtramexpByEntrid().getArbinterv()
						.getUaidinterv() != null) {
			where.append(" AND t2.TRUAIDINTERV = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getArbinterv()
					.getUaidinterv());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtridrel() != null) {
			where.append(" AND t2.TRTRIDREL = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrtridrel());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecini() != null) {
			where.append(" AND t2.TRFECINI = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecini());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecfin() != null) {
			where.append(" AND t2.TRFECFIN = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecfin());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrnomtrames() != null) {
			where.append(" AND UPPER(t2.TRNOMTRAMES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrnomtrames()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrnomtrames()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNOMTRAMES IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresultado() != null) {
			where.append(" AND t2.TRRESULTADO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresultado());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresofecha() != null) {
			where.append(" AND t2.TRRESOFECHA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresofecha());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresotipo() != null) {
			where.append(" AND UPPER(t2.TRRESOTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrresotipo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrresotipo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRRESOTIPO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrresoimporte() != null) {
			where.append(" AND t2.TRRESOIMPORTE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrresoimporte());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecenvio() != null) {
			where.append(" AND t2.TRFECENVIO = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecenvio());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfeccierre() != null) {
			where.append(" AND t2.TRFECCIERRE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfeccierre());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtiponot() != null) {
			where.append(" AND UPPER(t2.TRTIPONOT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrtiponot()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrtiponot()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRTIPONOT IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrestado() != null) {
			where.append(" AND UPPER(t2.TRESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrestado()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrestado()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTADO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecalta() != null) {
			where.append(" AND t2.TRFECALTA = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecalta());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecmodif() != null) {
			where.append(" AND t2.TRFECMODIF = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecmodif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrusualta() != null) {
			where.append(" AND UPPER(t2.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUALTA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrusumodif() != null) {
			where.append(" AND UPPER(t2.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRUSUMODIF IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecbopv() != null) {
			where.append(" AND t2.TRFECBOPV = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecbopv());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecinitabl() != null) {
			where.append(" AND t2.TRFECINITABL = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecinitabl());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecnotif() != null) {
			where.append(" AND t2.TRFECNOTIF = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecnotif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrcodigorel() != null) {
			where.append(" AND UPPER(t2.TRCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrcodigorel()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrcodigorel()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRCODIGOREL IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridnotifplatea() != null) {
			where.append(" AND UPPER(t2.TRIDNOTIFPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid()
						.getTridnotifplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTridnotifplatea()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRIDNOTIFPLATEA IS NOT NULL");
		}

		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecregs() != null) {
			where.append(" AND t2.TRFECREGS = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecregs());
		}

		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtipocom() != null) {
			where.append(" AND UPPER(t2.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrtipocom()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrtipocom()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRTIPOCOM IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t2.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrestadoacuse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrestadoacuse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRESTADOACUSE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrnumregs() != null) {
			where.append(" AND UPPER(t2.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrnumregs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrnumregs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRNUMREGS IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfecacuse() != null) {
			where.append(" AND t2.TRFECACUSE = ?");
			params.add(arbenvio.getArbtramexpByEntrid().getTrfecacuse());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridesperaplatea() != null) {
			where.append(" AND UPPER(t2.TRIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid()
						.getTridesperaplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid()
								.getTridesperaplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.TRIDESPERAPLATEA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrmatarespera() != null) {
			where.append(" AND UPPER(t2.TRMATARESPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrmatarespera()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrmatarespera()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRMATARESPERA IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrasuntocomunicacion() != null) {
			where.append(" AND UPPER(t2.TRASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid()
						.getTrasuntocomunicacion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid()
								.getTrasuntocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t2.TRASUNTOCOMUNICACION IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrtiponotplatea() != null) {
			where.append(" AND UPPER(t2.TRTIPONOTPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid()
						.getTrtiponotplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrtiponotplatea()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRTIPONOTPLATEA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrsede() != null) {
			where.append(" AND UPPER(t2.TRSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrsede()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrsede()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRSEDE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrcodrem() != null) {
			where.append(" AND UPPER(t2.TRCODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrcodrem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrcodrem()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRCODREM IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrenvrem() != null) {
			where.append(" AND UPPER(t2.TRENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrenvrem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrenvrem()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRENVREM IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridmailorigen() != null) {
			where.append(" AND UPPER(t2.TRIDMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTridmailorigen()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTridmailorigen()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRIDMAILORIGEN IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrmailorigen() != null) {
			where.append(" AND UPPER(t2.TRMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrmailorigen()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrmailorigen()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRMAILORIGEN IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTridmaildestino() != null) {
			where.append(" AND UPPER(t2.TRIDMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid()
						.getTridmaildestino().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTridmaildestino()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRIDMAILDESTINO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrmaildestino() != null) {
			where.append(" AND UPPER(t2.TRMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid().getTrmaildestino()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid().getTrmaildestino()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TRMAILDESTINO IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrfechaenviobopvboe() != null) {
			where.append(" AND t2.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbenvio.getArbtramexpByEntrid()
					.getTrfechaenviobopvboe());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntrid() != null
				&& arbenvio.getArbtramexpByEntrid().getTrproceedingsidplatea() != null) {
			where.append(" AND UPPER(t2.TRIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntrid()
						.getTrproceedingsidplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntrid()
								.getTrproceedingsidplatea().toUpperCase() + "%");
			}
			where.append(" AND t2.TRIDESPERAPLATEA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(arbenvio.getArbinterv().getUaidinterv());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanombre() != null) {
			where.append(" AND UPPER(t3.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANOMBRE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanif() != null) {
			where.append(" AND UPPER(t3.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANIF IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanrtel() != null) {
			where.append(" AND UPPER(t3.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanrtel().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANRTEL IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanrtel2() != null) {
			where.append(" AND UPPER(t3.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanrtel2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANRTEL2 IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaprovId() != null) {
			where.append(" AND UPPER(t3.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaprovId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaprovId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAPROV_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUamunId() != null) {
			where.append(" AND UPPER(t3.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUamunId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUamunId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAMUN_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUalocId() != null) {
			where.append(" AND UPPER(t3.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUalocId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUalocId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UALOC_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUacalleId() != null) {
			where.append(" AND UPPER(t3.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUacalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUacalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UACALLE_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUacpId() != null) {
			where.append(" AND UPPER(t3.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUacpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUacpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UACP_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaportalId() != null) {
			where.append(" AND UPPER(t3.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaportalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaportalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAPORTAL_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanombrePiso() != null) {
			where.append(" AND UPPER(t3.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UANOMBRE_PISO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUadireNocapv() != null) {
			where.append(" AND UPPER(t3.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUadireNocapv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUadireNocapv()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UADIRE_NOCAPV IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUadireAnt() != null) {
			where.append(" AND UPPER(t3.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUadireAnt().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUadireAnt().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UADIRE_ANT IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatipointerv() != null) {
			where.append(" AND UPPER(t3.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUatipointerv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUatipointerv()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATIPOINTERV IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaexcodigo() != null) {
			where.append(" AND UPPER(t3.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaexcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaexcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAEXCODIGO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUadtcodigo() != null) {
			where.append(" AND UPPER(t3.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUadtcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUadtcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UADTCODIGO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaescodigo() != null) {
			where.append(" AND UPPER(t3.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaescodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaescodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAESCODIGO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(arbenvio.getArbinterv().getUatrfecalta());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(arbenvio.getArbinterv().getUatrfecmodif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrusualta() != null) {
			where.append(" AND UPPER(t3.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUatrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUatrusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUALTA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatrusumodif() != null) {
			where.append(" AND UPPER(t3.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUatrusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUatrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUMODIF IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(arbenvio.getArbinterv().getUafecalta());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(arbenvio.getArbinterv().getUafecmodif());
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUausualta() != null) {
			where.append(" AND UPPER(t3.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUausualta().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUausualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAUSUALTA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUausumodif() != null) {
			where.append(" AND UPPER(t3.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUausumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUausumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAUSUMODIF IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUacoem() != null) {
			where.append(" AND UPPER(t3.UACOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUacoem().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUacoem().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UACOEM IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanodir() != null) {
			where.append(" AND UPPER(t3.UANODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanodir().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanodir().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANODIR IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaapellido1() != null) {
			where.append(" AND UPPER(t3.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaapellido1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaapellido1()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAAPELLIDO1 IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaapellido2() != null) {
			where.append(" AND UPPER(t3.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaapellido2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaapellido2()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAAPELLIDO2 IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUapaisId() != null) {
			where.append(" AND UPPER(t3.UAPAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUapaisId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUapaisId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAPAIS_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaentidadId() != null) {
			where.append(" AND UPPER(t3.UAENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaentidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaentidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAENTIDAD_ID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanoco() != null) {
			where.append(" AND UPPER(t3.UANOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANOCO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUanopeco() != null) {
			where.append(" AND UPPER(t3.UANOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUanopeco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUanopeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UANOPECO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaurl() != null) {
			where.append(" AND UPPER(t3.UAURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaurl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaurl().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAURL IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasecodigo() != null) {
			where.append(" AND UPPER(t3.UASECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUasecodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUasecodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UASECODIGO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasenombre() != null) {
			where.append(" AND UPPER(t3.UASENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUasenombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUasenombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UASENOMBRE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasenombree() != null) {
			where.append(" AND UPPER(t3.UASENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUasenombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUasenombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UASENOMBREE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUafecultmod() != null) {
			where.append(" AND UPPER(t3.UAFECULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUafecultmod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUafecultmod()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAFECULTMOD IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUausuultmod() != null) {
			where.append(" AND UPPER(t3.UAUSUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUausuultmod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUausuultmod()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAUSUULTMOD IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaformanotificacion() != null) {
			where.append(" AND UPPER(t3.UAFORMANOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaformanotificacion()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaformanotificacion()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UAFORMANOTIFICACION IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaidioma() != null) {
			where.append(" AND UPPER(t3.UAIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaidioma().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaidioma().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAIDIOMA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUasexo() != null) {
			where.append(" AND UPPER(t3.UASEXO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUasexo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUasexo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UASEXO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUaedad() != null) {
			where.append(" AND UPPER(t3.UAEDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUaedad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUaedad().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.UAEDAD IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbinterv() != null
				&& arbenvio.getArbinterv().getUatipoidentificacion() != null) {
			where.append(" AND UPPER(t3.UATIPOIDENTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbinterv().getUatipoidentificacion()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbinterv().getUatipoidentificacion()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.UATIPOIDENTIFICACION IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrid() != null) {
			where.append(" AND t4.TRID = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrid());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getArbinterv() != null
				&& arbenvio.getArbtramexpByEntridacuse().getArbinterv()
						.getUaidinterv() != null) {
			where.append(" AND t4.TRUAIDINTERV = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getArbinterv()
					.getUaidinterv());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtridrel() != null) {
			where.append(" AND t4.TRTRIDREL = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrtridrel());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecini() != null) {
			where.append(" AND t4.TRFECINI = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecini());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecfin() != null) {
			where.append(" AND t4.TRFECFIN = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecfin());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrnomtrames() != null) {
			where.append(" AND UPPER(t4.TRNOMTRAMES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrnomtrames().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrnomtrames().toUpperCase() + "%");
			}
			where.append(" AND t4.TRNOMTRAMES IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresofecha() != null) {
			where.append(" AND t4.TRRESOFECHA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrresofecha());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresotipo() != null) {
			where.append(" AND UPPER(t4.TRRESOTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrresotipo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrresotipo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRRESOTIPO IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrresoimporte() != null) {
			where.append(" AND t4.TRRESOIMPORTE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrresoimporte());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecenvio() != null) {
			where.append(" AND t4.TRFECENVIO = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecenvio());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfeccierre() != null) {
			where.append(" AND t4.TRFECCIERRE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfeccierre());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtiponot() != null) {
			where.append(" AND UPPER(t4.TRTIPONOT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrtiponot()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrtiponot()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRTIPONOT IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrestado() != null) {
			where.append(" AND UPPER(t4.TRESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrestado()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrestado()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRESTADO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecalta() != null) {
			where.append(" AND t4.TRFECALTA = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecalta());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecmodif() != null) {
			where.append(" AND t4.TRFECMODIF = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecmodif());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrusualta() != null) {
			where.append(" AND UPPER(t4.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrusualta()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRUSUALTA IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrusumodif() != null) {
			where.append(" AND UPPER(t4.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrusumodif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRUSUMODIF IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecbopv() != null) {
			where.append(" AND t4.TRFECBOPV = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecbopv());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecinitabl() != null) {
			where.append(" AND t4.TRFECINITABL = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecinitabl());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecnotif() != null) {
			where.append(" AND t4.TRFECNOTIF = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecnotif());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrcodigorel() != null) {
			where.append(" AND UPPER(t4.TRCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrcodigorel().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrcodigorel().toUpperCase() + "%");
			}
			where.append(" AND t4.TRCODIGOREL IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridnotifplatea() != null) {
			where.append(" AND UPPER(t4.TRIDNOTIFPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTridnotifplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTridnotifplatea().toUpperCase() + "%");
			}
			where.append(" AND t4.TRIDNOTIFPLATEA IS NOT NULL");
		}

		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecregs() != null) {
			where.append(" AND t4.TRFECREGS = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecregs());
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtipocom() != null) {
			where.append(" AND UPPER(t4.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrtipocom()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrtipocom()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRTIPOCOM IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrestadoacuse() != null) {
			where.append(" AND UPPER(t4.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrestadoacuse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrestadoacuse().toUpperCase() + "%");
			}
			where.append(" AND t4.TRESTADOACUSE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrnumregs() != null) {
			where.append(" AND UPPER(t4.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrnumregs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrnumregs()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRNUMREGS IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrfecacuse() != null) {
			where.append(" AND t4.TRFECACUSE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse().getTrfecacuse());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridesperaplatea() != null) {
			where.append(" AND UPPER(t4.TRIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTridesperaplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTridesperaplatea().toUpperCase() + "%");
			}
			where.append(" AND t4.TRIDESPERAPLATEA IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrmatarespera() != null) {
			where.append(" AND UPPER(t4.TRMATARESPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrmatarespera().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrmatarespera().toUpperCase() + "%");
			}
			where.append(" AND t4.TRMATARESPERA IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse()
						.getTrasuntocomunicacion() != null) {
			where.append(" AND UPPER(t4.TRASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrasuntocomunicacion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrasuntocomunicacion().toUpperCase() + "%");
			}
			where.append(" AND t4.TRASUNTOCOMUNICACION IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrtiponotplatea() != null) {
			where.append(" AND UPPER(t4.TRTIPONOTPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrtiponotplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrtiponotplatea().toUpperCase() + "%");
			}
			where.append(" AND t4.TRTIPONOTPLATEA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrsede() != null) {
			where.append(" AND UPPER(t4.TRSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrsede()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrsede()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRSEDE IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrcodrem() != null) {
			where.append(" AND UPPER(t4.TRCODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrcodrem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrcodrem()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRCODREM IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrenvrem() != null) {
			where.append(" AND UPPER(t4.TRENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse().getTrenvrem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse().getTrenvrem()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TRENVREM IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridmailorigen() != null) {
			where.append(" AND UPPER(t4.TRIDMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTridmailorigen().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTridmailorigen().toUpperCase() + "%");
			}
			where.append(" AND t4.TRIDMAILORIGEN IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrmailorigen() != null) {
			where.append(" AND UPPER(t4.TRMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrmailorigen().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrmailorigen().toUpperCase() + "%");
			}
			where.append(" AND t4.TRMAILORIGEN IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTridmaildestino() != null) {
			where.append(" AND UPPER(t4.TRIDMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTridmaildestino().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTridmaildestino().toUpperCase() + "%");
			}
			where.append(" AND t4.TRIDMAILDESTINO IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse().getTrmaildestino() != null) {
			where.append(" AND UPPER(t4.TRMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrmaildestino().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrmaildestino().toUpperCase() + "%");
			}
			where.append(" AND t4.TRMAILDESTINO IS NOT NULL");
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse()
						.getTrfechaenviobopvboe() != null) {
			where.append(" AND t4.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbenvio.getArbtramexpByEntridacuse()
					.getTrfechaenviobopvboe());
		}
		if (arbenvio != null
				&& arbenvio.getArbtramexpByEntridacuse() != null
				&& arbenvio.getArbtramexpByEntridacuse()
						.getTrproceedingsidplatea() != null) {
			where.append(" AND UPPER(t4.TRIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getArbtramexpByEntridacuse()
						.getTrproceedingsidplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbenvio.getArbtramexpByEntridacuse()
								.getTrproceedingsidplatea().toUpperCase() + "%");
			}
			where.append(" AND t4.TRIDESPERAPLATEA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getEnexid() != null) {
			where.append(" AND UPPER(t1.ENEXID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getEnexid().toUpperCase() + "%");
			} else {
				params.add("%" + arbenvio.getEnexid().toUpperCase() + "%");
			}
			where.append(" AND t1.ENEXID IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getEnfecenvio() != null) {
			where.append(" AND t1.ENFECENVIO = ?");
			params.add(arbenvio.getEnfecenvio());
		}
		if (arbenvio != null && arbenvio.getEnfecacuse() != null) {
			where.append(" AND t1.ENFECACUSE = ?");
			params.add(arbenvio.getEnfecacuse());
		}
		if (arbenvio != null && arbenvio.getEnestado() != null) {
			where.append(" AND UPPER(t1.ENESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getEnestado().toUpperCase() + "%");
			} else {
				params.add("%" + arbenvio.getEnestado().toUpperCase() + "%");
			}
			where.append(" AND t1.ENESTADO IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getEnfecalta() != null) {
			where.append(" AND t1.ENFECALTA = ?");
			params.add(arbenvio.getEnfecalta());
		}
		if (arbenvio != null && arbenvio.getEnfecmodif() != null) {
			where.append(" AND t1.ENFECMODIF = ?");
			params.add(arbenvio.getEnfecmodif());
		}
		if (arbenvio != null && arbenvio.getEnusualta() != null) {
			where.append(" AND UPPER(t1.ENUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getEnusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbenvio.getEnusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.ENUSUALTA IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getEnusumodif() != null) {
			where.append(" AND UPPER(t1.ENUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getEnusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbenvio.getEnusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.ENUSUMODIF IS NOT NULL");
		}
		if (arbenvio != null && arbenvio.getEntipoenvio() != null) {
			where.append(" AND UPPER(t1.ENTIPOENVIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbenvio.getEntipoenvio().toUpperCase() + "%");
			} else {
				params.add("%" + arbenvio.getEntipoenvio().toUpperCase() + "%");
			}
			where.append(" AND t1.ENTIPOENVIO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
