package com.ejie.y41b.dao;

import ch.qos.logback.classic.Logger;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * ArbdoctempDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ArbdoctempDaoImpl implements ArbdoctempDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = (Logger) LoggerFactory.getLogger(ArbdoctempDaoImpl.class);

	private RowMapper<Arbdoctemp> rwMap = new RowMapper<Arbdoctemp>() {
		public Arbdoctemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Arbdoctemp(resultSet.getString("X5CODOCUMENTO"), resultSet.getString("X5EXCODIGO"),
					resultSet.getString("X5NOFILE"), resultSet.getBlob("X5DATAFILE"), resultSet.getInt("X5SIZEFILE"),
					resultSet.getString("X5TEDESFILE"), resultSet.getString("X5ORIGEN"),
					resultSet.getString("X5TRAMITE"), resultSet.getDate("X5FECHA"), resultSet.getString("X5CONTTYPE"),
					resultSet.getString("X5INDMAIL"), resultSet.getString("X5TRMAIL"),
					resultSet.getString("X5IDDOCUMENTUM"), resultSet.getDate("X5FECHAAPORTACION"),
					resultSet.getDate("X5FECHAENTRADA"), resultSet.getString("X5NUMREGISTROENTRADA"),
					resultSet.getString("X5IDPERFILFIRMA"), resultSet.getString("X5ESTADODOCUMENTO"),
					resultSet.getDate("X5FECHASOLFIRMA"), resultSet.getDate("X5FECHAFIRMA"),
					resultSet.getString("X5COMOFIRMA"), resultSet.getDate("X5FECALTA"), resultSet.getDate("X5FECMODIF"),
					resultSet.getString("X5USUALTA"), resultSet.getString("X5USUMODIF"),
					resultSet.getDate("X5FECHALIMFIRMA"), resultSet.getString("X5DESTINO"),
					resultSet.getString("X5PTCODIGO"), resultSet.getTimestamp("X5FECHASOLLOCALIZADOR"),
					resultSet.getString("X5NUMREGISTROORIGEN"), resultSet.getDate("X5FECHAREGISTROORIGEN"),
					resultSet.getString("X5TIPODOCUMENTO"), resultSet.getString("PCODIGO"),
					resultSet.getString("X5IDINTERVINIENTE"));
		}
	};

	private RowMapper<DocumentoExpediente> rwMapDocExp = new RowMapper<DocumentoExpediente>() {
		public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return new DocumentoExpediente(resultSet.getString("X5CODOCUMENTO"), resultSet.getString("X5EXCODIGO"),
					resultSet.getString("X5NOFILE"), null, resultSet.getInt("X5SIZEFILE"),
					resultSet.getString("X5CONTTYPE"), resultSet.getString("X5TEDESFILE"),
					resultSet.getString("X5ORIGEN"), resultSet.getDate("X5FECHA"),
					resultSet.getString("X5IDDOCUMENTUM"), null, null, null, resultSet.getString("IDTIPODOC"),
					resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE"), null, null, null, null, null,
					null, null, null);

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Pagination
	 * @return Arbdoctemp
	 */
	public Arbdoctemp add(Arbdoctemp arbdoctemp) {
		String query = "INSERT INTO ARBDOCTEMP (X5CODOCUMENTO, X5TIPODOCUMENTO, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, X5FECHA, X5CONTTYPE, X5INDMAIL, X5TRMAIL, X5IDDOCUMENTUM, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5FECALTA, X5FECMODIF, X5USUALTA, X5USUMODIF, X5FECHALIMFIRMA, X5DESTINO, X5PTCODIGO, X5FECHASOLLOCALIZADOR, X5NUMREGISTROORIGEN, X5FECHAREGISTROORIGEN, X5IDINTERVINIENTE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getArbtipdocTdidAux = null;
		if (arbdoctemp.getArbtipdoc() != null && arbdoctemp.getArbtipdoc().getTdid() != null) {
			getArbtipdocTdidAux = arbdoctemp.getArbtipdoc().getTdid();
		}
		this.jdbcTemplate.update(query, arbdoctemp.getX5codocumento(), getArbtipdocTdidAux, arbdoctemp.getX5excodigo(),
				arbdoctemp.getX5nofile(),
				arbdoctemp.getX5datafile() == null ? null : Y41bJdbcUtils.ConvertBlobToByte(arbdoctemp.getX5datafile()),
				arbdoctemp.getX5sizefile(), arbdoctemp.getX5tedesfile(), arbdoctemp.getX5origen(),
				arbdoctemp.getArbtramexp() == null ? null : arbdoctemp.getArbtramexp().getTrid(),
				arbdoctemp.getX5fecha(), arbdoctemp.getX5conttype(), arbdoctemp.getX5indmail(),
				arbdoctemp.getX5trmail(), arbdoctemp.getX5iddocumentum(), arbdoctemp.getX5fechaaportacion(),
				arbdoctemp.getX5fechaentrada(), arbdoctemp.getX5numregistroentrada(), arbdoctemp.getX5idPerfilfirma(),
				arbdoctemp.getX5estadodocumento(), arbdoctemp.getX5fechasolfirma(), arbdoctemp.getX5fechafirma(),
				arbdoctemp.getX5comofirma(), arbdoctemp.getX5fecalta(), arbdoctemp.getX5fecmodif(),
				arbdoctemp.getX5usualta(), arbdoctemp.getX5usumodif(), arbdoctemp.getX5fechalimfirma(),
				arbdoctemp.getX5destino(), arbdoctemp.getX5ptcodigo(), arbdoctemp.getX5fechasollocalizador(),
				arbdoctemp.getX5numregistroorigen(), arbdoctemp.getX5fecharegistroorigen(),
				arbdoctemp.getX5idinterviniente());
		return arbdoctemp;
	}

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Pagination
	 * @return Arbdoctemp
	 */
	public Arbdoctemp update(Arbdoctemp arbdoctemp) {
		String query = "UPDATE ARBDOCTEMP SET X5TIPODOCUMENTO=?, X5EXCODIGO=?, X5NOFILE=?, X5DATAFILE=?, X5SIZEFILE=?, X5TEDESFILE=?, X5ORIGEN=?, X5TRAMITE=?, X5FECHA=?, X5CONTTYPE=?, X5INDMAIL=?, X5TRMAIL=?, X5IDDOCUMENTUM=?, X5FECHAAPORTACION=?, X5FECHAENTRADA=?, X5NUMREGISTROENTRADA=?, X5ID_PERFILFIRMA=?, X5ESTADODOCUMENTO=?, X5FECHASOLFIRMA=?, X5FECHAFIRMA=?, X5COMOFIRMA=?, X5FECALTA=?, X5FECMODIF=?, X5USUALTA=?, X5USUMODIF=?, X5FECHALIMFIRMA=?, X5DESTINO=?, X5PTCODIGO=?, X5FECHASOLLOCALIZADOR=?, X5NUMREGISTROORIGEN=?, X5FECHAREGISTROORIGEN=?, X5IDINTERVINIENTE=? WHERE X5CODOCUMENTO=?";
		Object getArbtipdocTdidAux = null;
		if (arbdoctemp.getArbtipdoc() != null && arbdoctemp.getArbtipdoc().getTdid() != null) {
			getArbtipdocTdidAux = arbdoctemp.getArbtipdoc().getTdid();
		}
		this.jdbcTemplate.update(query, getArbtipdocTdidAux, arbdoctemp.getX5excodigo(), arbdoctemp.getX5nofile(),
				Y41bJdbcUtils.ConvertBlobToByte(arbdoctemp.getX5datafile()), arbdoctemp.getX5sizefile(),
				arbdoctemp.getX5tedesfile(), arbdoctemp.getX5origen(),
				arbdoctemp.getArbtramexp() == null ? null : arbdoctemp.getArbtramexp().getTrid(),
				arbdoctemp.getX5fecha(), arbdoctemp.getX5conttype(), arbdoctemp.getX5indmail(),
				arbdoctemp.getX5trmail(), arbdoctemp.getX5iddocumentum(), arbdoctemp.getX5fechaaportacion(),
				arbdoctemp.getX5fechaentrada(), arbdoctemp.getX5numregistroentrada(), arbdoctemp.getX5idPerfilfirma(),
				arbdoctemp.getX5estadodocumento(), arbdoctemp.getX5fechasolfirma(), arbdoctemp.getX5fechafirma(),
				arbdoctemp.getX5comofirma(), arbdoctemp.getX5fecalta(), arbdoctemp.getX5fecmodif(),
				arbdoctemp.getX5usualta(), arbdoctemp.getX5usumodif(), arbdoctemp.getX5fechalimfirma(),
				arbdoctemp.getX5destino(), arbdoctemp.getX5ptcodigo(), arbdoctemp.getX5fechasollocalizador(),
				arbdoctemp.getX5numregistroorigen(), arbdoctemp.getX5fecharegistroorigen(),
				arbdoctemp.getX5idinterviniente(), arbdoctemp.getX5codocumento());
		return arbdoctemp;
	}

	/**
	 * Finds a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Pagination
	 * @return Arbdoctemp
	 */
	@Transactional(readOnly = true)
	public Arbdoctemp find(Arbdoctemp arbdoctemp) {
		String query = "SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5CONTTYPE X5CONTTYPE, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5FECALTA X5FECALTA, t1.X5FECMODIF X5FECMODIF, t1.X5USUALTA X5USUALTA, t1.X5USUMODIF X5USUMODIF, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5DESTINO X5DESTINO, t1.X5PTCODIGO X5PTCODIGO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN, t1.X5TIPODOCUMENTO, null PCODIGO, t1.X5IDINTERVINIENTE FROM ARBDOCTEMP t1 WHERE t1.X5CODOCUMENTO = ?  ";

		List<Arbdoctemp> arbdoctempList = this.jdbcTemplate.query(query, this.rwMap, arbdoctemp.getX5codocumento());
		return (Arbdoctemp) DataAccessUtils.uniqueResult(arbdoctempList);
	}

	/**
	 * Removes a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Pagination
	 * @return
	 */
	public void remove(Arbdoctemp arbdoctemp) {
		String query = "DELETE FROM ARBDOCTEMP WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbdoctemp.getX5codocumento());
	}

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAll(Arbdoctemp arbdoctemp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, null PCODIGO,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE ");
		query.append("FROM ARBDOCTEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbdoctemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbdoctemp arbdoctemp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBDOCTEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbdoctemp);
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllLike(Arbdoctemp arbdoctemp, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, null PCODIGO,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE ");
		query.append("FROM ARBDOCTEMP t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbdoctemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1  ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbdoctemp arbdoctemp, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBDOCTEMP t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbdoctemp, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbdoctemp entity
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereMap(Arbdoctemp arbdoctemp) {

		StringBuilder where = new StringBuilder(ArbdoctempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbdoctemp != null && arbdoctemp.getX5codocumento() != null) {
			where.append(" AND t1.X5CODOCUMENTO = ?");
			params.add(arbdoctemp.getX5codocumento());
		}
		if (arbdoctemp != null && arbdoctemp.getX5tipodocumento() != null
				&& arbdoctemp.getArbtipdoc().getTdid() != null) {
			where.append(" AND t1.X5TIPODOCUMENTO  = ?");
			params.add(arbdoctemp.getX5tipodocumento());
		}

		if (arbdoctemp != null && arbdoctemp.getX5excodigo() != null) {
			where.append(" AND t1.X5EXCODIGO = ?");
			params.add(arbdoctemp.getX5excodigo());
		}
		if (arbdoctemp != null && arbdoctemp.getX5nofile() != null) {
			where.append(" AND t1.X5NOFILE = ?");
			params.add(arbdoctemp.getX5nofile());
		}
		if (arbdoctemp != null && arbdoctemp.getX5sizefile() != null) {
			where.append(" AND t1.X5SIZEFILE = ?");
			params.add(arbdoctemp.getX5sizefile());
		}
		if (arbdoctemp != null && arbdoctemp.getX5tedesfile() != null) {
			where.append(" AND t1.X5TEDESFILE = ?");
			params.add(arbdoctemp.getX5tedesfile());
		}
		if (arbdoctemp != null && arbdoctemp.getX5origen() != null) {
			where.append(" AND t1.X5ORIGEN = ?");
			params.add(arbdoctemp.getX5origen());
		}
		if (arbdoctemp != null && arbdoctemp.getArbtramexp() != null && arbdoctemp.getArbtramexp().getTrid() != null) {
			where.append(" AND t1.X5TRAMITE = ?");
			/* where.append(" AND t3.EHCODIGO = ?"); */
			params.add(arbdoctemp.getArbtramexp().getTrid());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecha() != null) {
			where.append(" AND t1.X5FECHA = ?");
			params.add(arbdoctemp.getX5fecha());
		}
		if (arbdoctemp != null && arbdoctemp.getX5conttype() != null) {
			where.append(" AND t1.X5CONTTYPE = ?");
			params.add(arbdoctemp.getX5conttype());
		}
		if (arbdoctemp != null && arbdoctemp.getX5indmail() != null) {
			where.append(" AND t1.X5INDMAIL = ?");
			params.add(arbdoctemp.getX5indmail());
		}
		if (arbdoctemp != null && arbdoctemp.getX5trmail() != null) {
			where.append(" AND t1.X5TRMAIL = ?");
			params.add(arbdoctemp.getX5trmail());
		}
		if (arbdoctemp != null && arbdoctemp.getX5iddocumentum() != null) {
			where.append(" AND t1.X5IDDOCUMENTUM = ?");
			params.add(arbdoctemp.getX5iddocumentum());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechaaportacion() != null) {
			where.append(" AND t1.X5FECHAAPORTACION = ?");
			params.add(arbdoctemp.getX5fechaaportacion());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechaentrada() != null) {
			where.append(" AND t1.X5FECHAENTRADA = ?");
			params.add(arbdoctemp.getX5fechaentrada());
		}
		if (arbdoctemp != null && arbdoctemp.getX5numregistroentrada() != null) {
			where.append(" AND t1.X5NUMREGISTROENTRADA = ?");
			params.add(arbdoctemp.getX5numregistroentrada());
		}
		if (arbdoctemp != null && arbdoctemp.getX5idPerfilfirma() != null) {
			where.append(" AND t1.X5ID_PERFILFIRMA = ?");
			params.add(arbdoctemp.getX5idPerfilfirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5estadodocumento() != null) {
			where.append(" AND t1.X5ESTADODOCUMENTO = ?");
			params.add(arbdoctemp.getX5estadodocumento());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechasolfirma() != null) {
			where.append(" AND t1.X5FECHASOLFIRMA = ?");
			params.add(arbdoctemp.getX5fechasolfirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechafirma() != null) {
			where.append(" AND t1.X5FECHAFIRMA = ?");
			params.add(arbdoctemp.getX5fechafirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5comofirma() != null) {
			where.append(" AND t1.X5COMOFIRMA = ?");
			params.add(arbdoctemp.getX5comofirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecalta() != null) {
			where.append(" AND t1.X5FECALTA = ?");
			params.add(arbdoctemp.getX5fecalta());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecmodif() != null) {
			where.append(" AND t1.X5FECMODIF = ?");
			params.add(arbdoctemp.getX5fecmodif());
		}
		if (arbdoctemp != null && arbdoctemp.getX5usualta() != null) {
			where.append(" AND t1.X5USUALTA = ?");
			params.add(arbdoctemp.getX5usualta());
		}
		if (arbdoctemp != null && arbdoctemp.getX5usumodif() != null) {
			where.append(" AND t1.X5USUMODIF = ?");
			params.add(arbdoctemp.getX5usumodif());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechalimfirma() != null) {
			where.append(" AND t1.X5FECHALIMFIRMA = ?");
			params.add(arbdoctemp.getX5fechalimfirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5destino() != null) {
			where.append(" AND t1.X5DESTINO = ?");
			params.add(arbdoctemp.getX5destino());
		}
		if (arbdoctemp != null && arbdoctemp.getX5ptcodigo() != null) {
			where.append(" AND t1.X5PTCODIGO = ?");
			params.add(arbdoctemp.getX5ptcodigo());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechasollocalizador() != null) {
			where.append(" AND t1.X5FECHASOLLOCALIZADOR = ?");
			params.add(arbdoctemp.getX5fechasollocalizador());
		}
		if (arbdoctemp != null && arbdoctemp.getX5numregistroorigen() != null) {
			where.append(" AND t1.X5NUMREGISTROORIGEN = ?");
			params.add(arbdoctemp.getX5numregistroorigen());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecharegistroorigen() != null) {
			where.append(" AND t1.X5FECHAREGISTROORIGEN = ?");
			params.add(arbdoctemp.getX5fecharegistroorigen());
		}
		if (arbdoctemp != null && arbdoctemp.getX5idinterviniente() != null) {
			where.append(" AND t1.X5IDINTERVINIENTE = ?");
			params.add(arbdoctemp.getX5idinterviniente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbdoctemp entity
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacion de codigo de UDA
	private Map<String, ?> getWhereLikeMap(Arbdoctemp arbdoctemp, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArbdoctempDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbdoctemp != null && arbdoctemp.getX5codocumento() != null) {
			where.append(" AND t1.X5CODOCUMENTO = ?");
			params.add(arbdoctemp.getX5codocumento());
		}
		if (arbdoctemp != null && arbdoctemp.getX5tipodocumento() != null
				&& arbdoctemp.getArbtipdoc().getTdid() != null) {
			where.append(" AND t1.X5TIPODOCUMENTO  = ?");
			params.add(arbdoctemp.getX5tipodocumento());
		}
		if (arbdoctemp != null && arbdoctemp.getX5excodigo() != null) {
			where.append(" AND UPPER(t1.X5EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5excodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5excodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.X5EXCODIGO IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5nofile() != null) {
			where.append(" AND UPPER(t1.X5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.X5NOFILE IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5sizefile() != null) {
			where.append(" AND t1.X5SIZEFILE = ?");
			params.add(arbdoctemp.getX5sizefile());
		}
		if (arbdoctemp != null && arbdoctemp.getX5tedesfile() != null) {
			where.append(" AND UPPER(t1.X5TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5tedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.X5TEDESFILE IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5origen() != null) {
			where.append(" AND UPPER(t1.X5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5origen().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5origen().toUpperCase() + "%");
			}
			where.append(" AND t1.X5ORIGEN IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getArbtramexp() != null && arbdoctemp.getArbtramexp().getTrid() != null) {
			where.append(" AND t1.X5TRAMITE = ?");
			params.add(arbdoctemp.getArbtramexp().getTrid());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecha() != null) {
			where.append(" AND t1.X5FECHA = ?");
			params.add(arbdoctemp.getX5fecha());
		}
		if (arbdoctemp != null && arbdoctemp.getX5conttype() != null) {
			where.append(" AND UPPER(t1.X5CONTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5conttype().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5conttype().toUpperCase() + "%");
			}
			where.append(" AND t1.X5CONTTYPE IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5indmail() != null) {
			where.append(" AND UPPER(t1.X5INDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5indmail().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5indmail().toUpperCase() + "%");
			}
			where.append(" AND t1.X5INDMAIL IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5trmail() != null) {
			where.append(" AND UPPER(t1.X5TRMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5trmail().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5trmail().toUpperCase() + "%");
			}
			where.append(" AND t1.X5TRMAIL IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5iddocumentum() != null) {
			where.append(" AND UPPER(t1.X5IDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5iddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5iddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.X5IDDOCUMENTUM IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechaaportacion() != null) {
			where.append(" AND t1.X5FECHAAPORTACION = ?");
			params.add(arbdoctemp.getX5fechaaportacion());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechaentrada() != null) {
			where.append(" AND t1.X5FECHAENTRADA = ?");
			params.add(arbdoctemp.getX5fechaentrada());
		}
		if (arbdoctemp != null && arbdoctemp.getX5numregistroentrada() != null) {
			where.append(" AND UPPER(t1.X5NUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5numregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5numregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t1.X5NUMREGISTROENTRADA IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5idPerfilfirma() != null) {
			where.append(" AND UPPER(t1.X5ID_PERFILFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5idPerfilfirma().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5idPerfilfirma().toUpperCase() + "%");
			}
			where.append(" AND t1.X5ID_PERFILFIRMA IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5estadodocumento() != null) {
			where.append(" AND UPPER(t1.X5ESTADODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5estadodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5estadodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.X5ESTADODOCUMENTO IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechasolfirma() != null) {
			where.append(" AND t1.X5FECHASOLFIRMA = ?");
			params.add(arbdoctemp.getX5fechasolfirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechafirma() != null) {
			where.append(" AND t1.X5FECHAFIRMA = ?");
			params.add(arbdoctemp.getX5fechafirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5comofirma() != null) {
			where.append(" AND UPPER(t1.X5COMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5comofirma().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5comofirma().toUpperCase() + "%");
			}
			where.append(" AND t1.X5COMOFIRMA IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecalta() != null) {
			where.append(" AND t1.X5FECALTA = ?");
			params.add(arbdoctemp.getX5fecalta());
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecmodif() != null) {
			where.append(" AND t1.X5FECMODIF = ?");
			params.add(arbdoctemp.getX5fecmodif());
		}
		if (arbdoctemp != null && arbdoctemp.getX5usualta() != null) {
			where.append(" AND UPPER(t1.X5USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5usualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.X5USUALTA IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5usumodif() != null) {
			where.append(" AND UPPER(t1.X5USUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5usumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5usumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.X5USUMODIF IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechalimfirma() != null) {
			where.append(" AND t1.X5FECHALIMFIRMA = ?");
			params.add(arbdoctemp.getX5fechalimfirma());
		}
		if (arbdoctemp != null && arbdoctemp.getX5destino() != null) {
			where.append(" AND UPPER(t1.X5DESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5destino().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5destino().toUpperCase() + "%");
			}
			where.append(" AND t1.X5DESTINO IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5ptcodigo() != null) {
			where.append(" AND UPPER(t1.X5PTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5ptcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5ptcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.X5PTCODIGO IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5fechasollocalizador() != null) {
			where.append(" AND t1.X5FECHASOLLOCALIZADOR = ?");
			params.add(arbdoctemp.getX5fechasollocalizador());
		}
		if (arbdoctemp != null && arbdoctemp.getX5numregistroorigen() != null) {
			where.append(" AND UPPER(t1.X5NUMREGISTROORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbdoctemp.getX5numregistroorigen().toUpperCase() + "%");
			} else {
				params.add("%" + arbdoctemp.getX5numregistroorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.X5NUMREGISTROORIGEN IS NOT NULL");
		}
		if (arbdoctemp != null && arbdoctemp.getX5fecharegistroorigen() != null) {
			where.append(" AND t1.X5FECHAREGISTROORIGEN = ?");
			params.add(arbdoctemp.getX5fecharegistroorigen());
		}
		if (arbdoctemp != null && arbdoctemp.getX5idinterviniente() != null) {
			where.append(" AND t1.X5IDINTERVINIENTE = ?");
			params.add(arbdoctemp.getX5idinterviniente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacion de codigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosExpediente(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder("");
		try {
			query = new StringBuilder(
					"SELECT DISTINCT X5CODOCUMENTO, X5EXCODIGO, X5NOFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, DECODE(X5FECHAREGISTROORIGEN, null, DECODE(X5FECHAENTRADA,null,X5FECHA,X5FECHAENTRADA),X5FECHAREGISTROORIGEN) X5FECHA, X5CONTTYPE, X5INDMAIL, X5TRMAIL, X5IDDOCUMENTUM, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM ARBDOCTEMP, ARBTIPDOC t2 WHERE X5TIPODOCUMENTO = t2.TDID(+) AND X5EXCODIGO = ? ");

			List<Object> params = new ArrayList<Object>();

			params.add(tramiteComun.getIdExpediente());

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(), params.toArray(),
					this.rwMapDocExp);
		} catch (Exception e) {
			e.printStackTrace();
			ArbdoctempDaoImpl.logger.error("Error producido en findAllDocumentosHechoComunicacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts number of rows in the Arbdoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */

	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder("SELECT COUNT(DISTINCT X5CODOCUMENTO) ");
		query.append("FROM ARBDOCTEMP, ARBTIPDOC t2 WHERE X5TIPODOCUMENTO = t2.TDID(+) AND X5EXCODIGO=? ");

		// Where clause & Params
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		params.add(tramiteComun.getIdExpediente());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, null X5DATAFILE, t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5TIPODOCUMENTO,t3.THPCODIGO PCODIGO,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE ");
			query.append("FROM ARBDOCTEMP t1, ARBDOCTRAMITE t3 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t3.EHCODIGO = ? ");
			params.add(tramiteComun.getIdTramite().toString());
			where.append(" AND t3.TRPCODIGO = ? ");
			params.add(Y41bConstantes.TIPO_PROC_ARBITRAJE);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbdoctempDaoImpl.logger.error("Error producido en findAllDocumentosTramite: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllDocumentosTramiteApertura(TramiteComun tramiteComun, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, null X5DATAFILE, t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5TIPODOCUMENTO,t3.THPCODIGO PCODIGO,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE ");
			query.append("FROM ARBDOCTEMP t1, ARBDOCTRAMITE t3 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t3.EHCODIGO = ? ");
			params.add(tramiteComun.getIdTramite().toString());
			where.append(" AND t3.TRPCODIGO = ? ");
			params.add(Y41bConstantes.TIPO_PROC_ARBITRAJE);
			// Se comenta estas lineas porque en la apertura pueden llegar
			// documentos de distintos tipos (realmente este filtrado no parece
			// tener mucho sentido)
			// where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			// params.add(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbdoctempDaoImpl.logger.error("Error producido en findAllDocumentosTramite: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */

	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1)");
		query.append("FROM ARBDOCTEMP t1, ARBDOCTRAMITE t3 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO ");

		// Where clause & Params
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t3.EHCODIGO = ? ");
		params.add(tramiteComun.getIdTramite().toString());
		where.append(" AND t3.TRPCODIGO = ? ");
		params.add(Y41bConstantes.TIPO_PROC_ARBITRAJE);

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT SEQ_L21Q5T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());

	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addArbAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, TRPCODIGO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ "SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t2.TRPCODIGO TRPCODIGO, t2.THPCODIGO THPCODIGO,  t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA, t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, t2.EHCODIGO, t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5CONTTYPE X5CONTTYPE, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5DESTINO X5DESTINO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, T1.X5PTCODIGO X5PTCODIGO, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN, t1.X5IDINTERVINIENTE X5IDINTERVINIENTE "
				+ " FROM ARBDOCTEMP t1, ARBDOCTRAMITE t2 "
				+ " WHERE t1.X5CODOCUMENTO=t2.CODOCUMENTO AND t2.EHCODIGO = ? AND t2.TRPCODIGO = ? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(),
				(tramiteComun != null && tramiteComun.getTipoProcedimiento() != null
						&& tramiteComun.getTipoProcedimiento().getPcodigo() != null
								? tramiteComun.getTipoProcedimiento().getPcodigo()
								: Y41bConstantes.TIPO_PROC_ARBITRAJE));
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllDocumentosEliminados(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM ");
		query.append("FROM ARBDOCTEMP t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		where.append(
				" AND t1.X5CODOCUMENTO NOT IN (SELECT tt1.THCODOCUMENTO FROM ADJUNTARDOCS tt1 WHERE tt1.THID_TRAMITE = ? AND tt1.TRPCODIGO=? )");
		params.add(tramiteComun.getIdTramite());
		params.add(Y41bConstantes.TIPO_PROC_ARBITRAJE);
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), new RowMapper<Arbdoctemp>() {
			public Arbdoctemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Arbdoctemp(resultSet.getString("X5CODOCUMENTO"), resultSet.getString("X5IDDOCUMENTUM"));
			}
		}, params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllDocumentosEliminadosEst(TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM ");
		query.append("FROM ARBDOCTEMP t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		where.append(
				" AND t1.X5CODOCUMENTO NOT IN (SELECT tt1.THCODOCUMENTO FROM ADJUNTARDOCS tt1 WHERE tt1.THID_TRAMITE = ? AND tt1.TRPCODIGO=? )");
		params.add(tramiteComun.getIdTramite());
		params.add("EST");
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), new RowMapper<Arbdoctemp>() {
			public Arbdoctemp mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new Arbdoctemp(resultSet.getString("X5CODOCUMENTO"), resultSet.getString("X5IDDOCUMENTUM"));
			}
		}, params.toArray());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeArbDocTramite(TramiteComun tramiteComun) {
		String query = "DELETE FROM ARBDOCTRAMITE WHERE EHCODIGO = ? AND TRPCODIGO ='"
				+ Y41bConstantes.TIPO_PROC_ARBITRAJE + "'";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "DELETE FROM ARBDOCTEMP WHERE X5TRAMITE = ? AND X5EXCODIGO=?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(), tramiteComun.getIdExpediente());

	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocsArbDocTramite(TramiteComun tramiteComun) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) SELECT THID_TRAMITE,THCODOCUMENTO,THPCODIGO,TRPCODIGO FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_TRAMITE=? ";
		this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento().getPcodigo(), tramiteComun.getIdTramite());
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		try {
			String query = "INSERT INTO ARBDOCTEMP (X5CODOCUMENTO, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, X5FECHA, X5INDMAIL, X5TRMAIL, X5CONTTYPE, X5IDDOCUMENTUM, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHALIMFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5TIPODOCUMENTO, X5DESTINO, X5FECHASOLLOCALIZADOR, X5PTCODIGO,X5NUMREGISTROORIGEN,X5FECHAREGISTROORIGEN, X5IDINTERVINIENTE)"
					+ " SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO ,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN, THIDINTERVINIENTE "
					+ " FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THCODOCUMENTO NOT IN (SELECT X5CODOCUMENTO FROM ARBDOCTEMP) AND THID_TRAMITE=?";

			this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento().getPcodigo(),
					tramiteComun.getIdTramite());
		} catch (Exception e) {
			e.printStackTrace();
			ArbdoctempDaoImpl.logger.error("Error producido en addDocumentosHechoAdjuntarDocs: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocsApertura(TramiteComun tramiteComun) {
		try {
			String query = "INSERT INTO ARBDOCTEMP (X5CODOCUMENTO, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, X5FECHA, X5INDMAIL, X5TRMAIL, X5CONTTYPE, X5IDDOCUMENTUM, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHALIMFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5TIPODOCUMENTO, X5DESTINO, X5FECHASOLLOCALIZADOR, X5PTCODIGO,X5NUMREGISTROORIGEN,X5FECHAREGISTROORIGEN,X5IDINTERVINIENTE)"
					+ " SELECT SEQ_L21Q5T00.NEXTVAL, ?, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO ,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN,THIDINTERVINIENTE "
					+ " FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_TRAMITE=?";

			this.jdbcTemplate.update(query, tramiteComun.getIdExpediente(),
					tramiteComun.getTipoProcedimiento().getPcodigo(), tramiteComun.getIdTramite());

			query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) SELECT X5TRAMITE,X5CODOCUMENTO,?,? FROM ARBDOCTEMP WHERE X5EXCODIGO = ? AND X5TRAMITE=? ";
			this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento().getPcodigo(),
					tramiteComun.getTipoProcedimiento().getPcodigo(), tramiteComun.getIdExpediente(),
					tramiteComun.getIdTramite());

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en addDocumentosHechoAdjuntarDocs: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts rows in the table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocTramiteHechoCount(Arbdoctemp arbdoctemp) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBDOCTRAMITE WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND CODOCUMENTO = ? ");
		params.add(arbdoctemp.getX5codocumento());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	public void copiaArbDocTramite(String tridOrigen, String tridDestino) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) "
				+ " SELECT ?, CODOCUMENTO, THPCODIGO,TRPCODIGO "
				+ " FROM ARBDOCTRAMITE WHERE 1=1 AND TRPCODIGO = ? AND EHCODIGO = ?";

		this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_ARBITRAJE, tridOrigen);
	}

	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.1. Nuevo tipo de alegación que no genere comunicación a la otra parte
	/**
	 * @param tridDestino
	 *            String
	 */
	public void copiaArbDocAlegacion(String tridDestino, String excodigo) {
		this.copiaArbDocTipo(tridDestino, Y41bConstantes.TIPO_DOC_ARB_ALEGACIONES, excodigo,
				Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO);
	}

	/**
	 * @param tridDestino
	 *            String
	 */
	public void copiaArbDocRechazo(String tridDestino, String excodigo) {
		this.copiaArbDocTipo(tridDestino, Y41bConstantes.TIPO_DOC_ARB_RECHAZO_ARBITRAJE, excodigo,
				Y41bConstantes.ORIGEN_ARB_APORTADO_RECLAMADO);
	}

	/**
	 * @param tridDestino
	 *            String
	 */
	public void copiaArbDocLaudo(String tridDestino, String excodigo) {
		this.copiaArbDocTipo(tridDestino, Y41bConstantes.TIPO_DOC_ARB_LAUDO, excodigo, null);
	}

	/**
	 * @param tridDestino
	 *            String
	 * @param tipoDocumento
	 *            String
	 */
	private void copiaArbDocTipo(String tridDestino, String tipoDocumento, String excodigo, String origen) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) "
				+ " SELECT DISTINCT ?, CODOCUMENTO, THPCODIGO,TRPCODIGO "
				+ " FROM ARBDOCTRAMITE, ARBDOCTEMP WHERE 1=1 AND TRPCODIGO = ? AND CODOCUMENTO=X5CODOCUMENTO "
				+ (origen != null ? "AND X5ORIGEN=?" : "") + " AND X5TIPODOCUMENTO = ? AND X5EXCODIGO = ? ";

		if (origen != null) {
			this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_ARBITRAJE, origen, tipoDocumento,
					excodigo);
		} else {
			this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_ARBITRAJE, tipoDocumento, excodigo);
		}

	}

	/**
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	public void copiaArbDocOrigen(String origen, String tridDestino, String excodigo) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) "
				+ " SELECT DISTINCT ?, CODOCUMENTO, THPCODIGO,TRPCODIGO "
				+ " FROM ARBDOCTRAMITE, ARBDOCTEMP WHERE 1=1 AND TRPCODIGO = ? AND CODOCUMENTO=X5CODOCUMENTO AND X5ORIGEN=? AND X5EXCODIGO = ?";

		this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_ARBITRAJE, origen, excodigo);
	}

	// 0150948: Evolutivo Arbitraje Marzo-2020
	// 2.1. Nuevo tipo de alegación que no genere comunicación a la otra parte
	/**
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	public void copiaArbDocTramiteDeUnTipo(String tridOrigen, String tridDestino, String tipo) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) "
				+ " SELECT ?, CODOCUMENTO, THPCODIGO,TRPCODIGO "
				+ " FROM ARBDOCTRAMITE,ARBDOCTEMP WHERE 1=1 AND X5CODOCUMENTO=CODOCUMENTO AND TRPCODIGO = ? AND EHCODIGO = ? AND X5TIPODOCUMENTO=?";

		this.jdbcTemplate.update(query, tridDestino, Y41bConstantes.TIPO_PROC_ARBITRAJE, tridOrigen, tipo);
	}

	/**
	 * updateOIDDokusi
	 * 
	 * @param documentoHecho
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	public Arbdoctemp updateOIDDokusi(Arbdoctemp documentoHecho) {
		ArbdoctempDaoImpl.logger.debug("updateOIDDokusi(). X5CODOCUMENTO: " + documentoHecho.getX5codocumento()
				+ ".X5IDDOCUMENTUM:" + documentoHecho.getX5iddocumentum() + ".");
		String query = "UPDATE ARBDOCTEMP SET X5IDDOCUMENTUM=? WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getX5iddocumentum(), documentoHecho.getX5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	public Arbdoctemp removeBlobFromOIDDokusi(Arbdoctemp arbdoctemp) {
		String query = "UPDATE ARBDOCTEMP SET X5DATAFILE=null WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbdoctemp.getX5codocumento());
		return arbdoctemp;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return DocumentoHecho
	 */
	public Arbdoctemp updateFechaLocalizacion(Arbdoctemp arbdoctemp) {
		String query = "UPDATE ARBDOCTEMP SET X5FECHASOLLOCALIZADOR=SYSDATE WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbdoctemp.getX5codocumento());
		return arbdoctemp;
	}

	/**
	 * addAdjuntarDoc
	 * 
	 * @param documentoHecho
	 *            Arbdoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDoc(Arbdoctemp documentoHecho, TramiteComun tramiteComun) {

		String query = " INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO,TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN,THIDINTERVINIENTE) "
				+ " SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, '" + documentoHecho.getX5pcodigo() + "', '"
				+ Y41bConstantes.TIPO_PROC_ARBITRAJE
				+ "',  t1.X5ID_PERFILFIRMA X5ID_PERFILFIRMA, t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, '"
				+ tramiteComun.getIdTramite()
				+ "', t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5CONTTYPE X5CONTTYPE, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5DESTINO X5DESTINO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, T1.X5PTCODIGO X5PTCODIGO, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE "
				+ " FROM ARBDOCTEMP t1 WHERE t1.X5CODOCUMENTO = ?";
		this.jdbcTemplate.update(query, documentoHecho.getX5codocumento());
	}

	/**
	 * 
	 * @param idNuevoTramite
	 *            idNuevoTramite
	 * @param codocumento
	 *            codocumento
	 * @param tipoProcedimiento
	 *            tipoProcedimiento
	 */
	public void insertArbDocTramite(String idNuevoTramite, String codocumento, String tipoProcedimiento) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) VALUES(?,?,?,?)";
		this.jdbcTemplate.update(query, idNuevoTramite, codocumento, tipoProcedimiento, tipoProcedimiento);
	}

	/**
	 * 
	 * @param idNuevoTramite
	 *            idNuevoTramite
	 * @param codocumento
	 *            codocumento
	 * @param tipoProcedimiento
	 *            tipoProcedimiento
	 * @param tipoProcedimiento2
	 *            tipoProcedimiento2
	 */
	public void insertArbDocTramite(String idNuevoTramite, String codocumento, String tipoProcedimiento,
			String tipoProcedimiento2) {
		String query = "INSERT INTO ARBDOCTRAMITE (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) VALUES(?,?,?,?)";
		this.jdbcTemplate.update(query, idNuevoTramite, codocumento, tipoProcedimiento, tipoProcedimiento2);
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	public Arbdoctemp updateOrigen(Arbdoctemp documentoHecho) {
		String query = "UPDATE ARBDOCTEMP SET X5ORIGEN=? WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getX5origen(), documentoHecho.getX5codocumento());
		return documentoHecho;
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT  count(1) FROM ARBDOCTEMP t1,ARBTIPDOC t2 WHERE t1.X5TIPODOCUMENTO = t2.TDID(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_ACEPTACION_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_SOLICITUD_COPIA_EXPE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_INFORME_PERICIAL);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_ACLARACION);
		}

		where.append(
				" AND t1.X5TRAMITE IN (SELECT tt1.TRID FROM ARBTRAMEXP tt1 WHERE tt1.TREXCODIGO=? AND (tt1.TRESTADO=? OR tt1.TRESTADO IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun,
			Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN, DECODE(t1.X5FECHAREGISTROORIGEN, null, DECODE(t1.X5FECHAENTRADA,null,t1.X5FECHA,t1.X5FECHAENTRADA),t1.X5FECHAREGISTROORIGEN) X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM ARBDOCTEMP t1,ARBTIPDOC t2 WHERE t1.X5TIPODOCUMENTO = t2.TDID(+) ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.X5EXCODIGO = ? ");
			params.add(tramiteComun.getIdExpediente());

			if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.X5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.X5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_ACEPTACION_ARBITRAJE);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.X5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_SOLICITUD_COPIA_EXPE);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.X5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_INFORME_PERICIAL);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.X5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.X5TIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_ACLARACION);
			}
			where.append(
					" AND t1.X5TRAMITE IN (SELECT tt1.TRID FROM ARBTRAMEXP tt1 WHERE tt1.TREXCODIGO=? AND (tt1.TRESTADO=? OR tt1.TRESTADO IS NULL))");
			params.add(tramiteComun.getIdExpediente());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(query.toString(),
					new RowMapper<DocumentoExpediente>() {
						public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum) throws SQLException {
							return new DocumentoExpediente(resultSet.getString("X5CODOCUMENTO"),
									resultSet.getString("X5EXCODIGO"), resultSet.getString("X5NOFILE"), null,
									resultSet.getInt("X5SIZEFILE"), resultSet.getString("X5CONTTYPE"),
									resultSet.getString("X5TEDESFILE"), resultSet.getString("X5ORIGEN"),
									resultSet.getDate("X5FECHA"), resultSet.getString("X5IDDOCUMENTUM"),
									resultSet.getDate("X5FECHAAPORTACION"), resultSet.getDate("X5FECHAENTRADA"),
									resultSet.getString("X5NUMREGISTROENTRADA"), resultSet.getString("IDTIPODOC"),
									resultSet.getString("TDNOMBRE"), resultSet.getString("TDNOMBREE"), null, null, null,
									null, null, null, null, null);
						}
					}, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbdoctempDaoImpl.logger.error("Error producido en findAllDocumentosHechoComunicacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return int
	 */
	public int updateArbDocTemp(Arbdoctemp arbdoctemp) {
		String query = "UPDATE ARBDOCTEMP SET X5NOFILE=?,X5DATAFILE=?, X5SIZEFILE=?, X5CONTTYPE=? WHERE X5IDDOCUMENTUM=?";
		return this.jdbcTemplate.update(query, arbdoctemp.getX5nofile(),
				Y41bJdbcUtils.ConvertBlobToByte(arbdoctemp.getX5datafile()), arbdoctemp.getX5sizefile(),
				arbdoctemp.getX5conttype(), arbdoctemp.getX5iddocumentum());
	}

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return DocumentoHecho
	 */
	public Arbdoctemp updateDatosFirma(Arbdoctemp arbdoctemp) {
		String query = "UPDATE ARBDOCTEMP SET X5ESTADODOCUMENTO=?, X5FECHAFIRMA=?, X5COMOFIRMA=? WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbdoctemp.getX5estadodocumento(), arbdoctemp.getX5fechafirma(),
				arbdoctemp.getX5comofirma(), arbdoctemp.getX5codocumento());
		return arbdoctemp;
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param idTramiteApertura
	 *            String
	 */
	public void volcarDocumentosReclamacionPrevia(String hdcodigo, String idTramiteApertura) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN,TRPCODIGO,THIDINTERVINIENTE) SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, ?,  t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA, DECODE (t1.Q5ID_TIPODOC, ?, ?, ?), t1.Q5HDCODIGO Q5HDCODIGO, ?, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5TRAMITE Q5TRAMITE, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5TRMAIL Q5TRMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM, t1.Q5FECHAAPORTACION Q5FECHAAPORTACION, t1.Q5FECHAENTRADA Q5FECHAENTRADA, t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA, t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO, t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA, t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA, t1.Q5FECHAFIRMA Q5FECHAFIRMA, t1.Q5COMOFIRMA Q5COMOFIRMA, t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO, t1.Q5NUMREGISTROORIGEN Q5NUMREGISTROORIGEN, t1.Q5FECHAREGISTROORIGEN Q5FECHAREGISTROORIGEN, ?, t1.Q5IDINTERVINIENTE Q5IDINTERVINIENTE FROM DOCUMENTO_HECHO t1, DOC_TRAMITE_HECHO t2  WHERE t1.Q5CODOCUMENTO=t2.CODOCUMENTO(+) AND t1.Q5TRAMITE=t2.EHCODIGO(+) AND t1.Q5HDCODIGO = ? AND t1.Q5ORIGEN !=?";
		this.jdbcTemplate.update(query, Y41bConstantes.TIPO_PROC_SOLICITUDES, Y41bConstantes.TIPO_DOC_SOL_ARBITRAJE,
				Y41bConstantes.TIPO_DOC_ARB_SOLICITUD, Y41bConstantes.TIPO_DOC_ARB_OTROS, idTramiteApertura,
				Y41bConstantes.TIPO_PROC_ARBITRAJE, hdcodigo, Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);
	}

	/**
	 * removeDocumentosReclamacionPrevia
	 * 
	 * @param idTramite
	 *            String
	 */
	public void removeDocumentosReclamacionPrevia(String idTramite) {
		String query = "DELETE FROM ADJUNTARDOCS WHERE THID_TRAMITE=? AND TRPCODIGO=? AND THPCODIGO=?";
		this.jdbcTemplate.update(query, idTramite, Y41bConstantes.TIPO_PROC_ARBITRAJE,
				Y41bConstantes.TIPO_PROC_SOLICITUDES);
	}

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllOrdenesPago(Arbdoctemp arbdoctemp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, null PCODIGO,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE ");
		query.append(
				"FROM ARBDOCTEMP t1, CENSO_MONITOR t2 WHERE t1.X5COMOFIRMA=t2.MOCODIGO AND t1.X5FECHAFIRMA IS NOT NULL ");
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(arbdoctemp.getX5excodigo());
		where.append(" AND (t1.X5TIPODOCUMENTO = ? ");
		params.add(Y41bConstantes.TIPO_DOC_ARB_PAGO_LAUDO);
		where.append(" OR t1.X5TIPODOCUMENTO = ? ");
		params.add(Y41bConstantes.TIPO_DOC_ARB_PAGO_PERICIAL_COLEGIO);
		where.append(" ) AND t2.ID_PERFILARBITRAJE = ? ");
		params.add(Y41bConstantes.PERFIL_DIRECTOR);

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbdoctemp> findAllDocumentosPagos(Arbdoctemp arbdoctemp, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,t1.X5DATAFILE X5DATAFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, null PCODIGO,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE ");
		query.append("FROM ARBDOCTEMP t1 WHERE 1=1 ");
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(arbdoctemp.getX5excodigo());
		where.append(" AND (t1.X5TIPODOCUMENTO = ? ");
		params.add(Y41bConstantes.TIPO_DOC_ARB_PAGO_LAUDO);
		where.append(" OR t1.X5TIPODOCUMENTO = ? ");
		params.add(Y41bConstantes.TIPO_DOC_ARB_PAGO_PERICIAL_COLEGIO);
		where.append(" ) ");

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbdoctemp>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	// 0145820: Empresas adheridas: falta de incorporar acceso a documentos
	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addArbAdjuntarDocsEst(TramiteComun tramiteComun) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, TRPCODIGO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ "SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, 'EST', 'EST',  t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA, t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, t1.X5EXCODIGO X5EXCODIGO2, t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5CONTTYPE X5CONTTYPE, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5DESTINO X5DESTINO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, T1.X5PTCODIGO X5PTCODIGO, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN, t1.X5IDINTERVINIENTE X5IDINTERVINIENTE "
				+ " FROM ARBDOCTEMP t1" + " WHERE t1.X5EXCODIGO = ? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
	}
}
