package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbdoctempDao  
 * 
 *  
 */

public interface ArbdoctempDao {

	/**
	 * Inserts a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp add(Arbdoctemp arbdoctemp);

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp update(Arbdoctemp arbdoctemp);

	/**
	 * Finds a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp find(Arbdoctemp arbdoctemp);

	/**
	 * Deletes a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return
	 */
	void remove(Arbdoctemp arbdoctemp);

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbdoctemp> findAll(Arbdoctemp arbdoctemp, Pagination pagination);

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Long
	 */
	Long findAllCount(Arbdoctemp arbdoctemp);

	/**
	 * Finds rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbdoctemp> findAllLike(Arbdoctemp arbdoctemp, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbdoctemp table using like.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbdoctemp arbdoctemp, Boolean startsWith);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	List<DocumentoExpediente> findAllDocumentosExpediente(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 * @return Long
	 */
	Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	List<Arbdoctemp> findAllDocumentosTramite(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Arbdoctemp> findAllDocumentosTramiteApertura(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts rows in the Arbdoctemp table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * getNewPK
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addArbAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbdoctemp> findAllDocumentosEliminados(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void removeArbDocTramite(TramiteComun tramiteComun);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addAdjuntarDocsArbDocTramite(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocumentosHechoAdjuntarDocsApertura(TramiteComun tramiteComun);

	/**
	 * findAllDocTramiteHechoCount
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Long
	 */
	Long findAllDocTramiteHechoCount(Arbdoctemp arbdoctemp);

	/**
	 * copiaArbDocTramite
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	void copiaArbDocTramite(String tridOrigen, String tridDestino);

	/**
	 * copiaArbDocTramiteDeUnTipo
	 * 
	 * @param tridOrigen
	 *            String
	 * @param tridDestino
	 *            String
	 * @param tipo
	 *            String
	 */
	void copiaArbDocTramiteDeUnTipo(String tridOrigen, String tridDestino, String tipo);

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param documentoHecho
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp updateOIDDokusi(Arbdoctemp documentoHecho);

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	public Arbdoctemp removeBlobFromOIDDokusi(Arbdoctemp arbdoctemp);

	/**
	 * updateFechaLocalizacion
	 * 
	 * @param documentoHecho
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp updateFechaLocalizacion(Arbdoctemp documentoHecho);

	/**
	 * addAdjuntarDoc
	 * 
	 * @param documentoHechoAux
	 *            Arbdoctemp
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addAdjuntarDoc(Arbdoctemp documentoHechoAux, TramiteComun tramiteComun);

	/**
	 * 
	 * @param idNuevoTramite
	 *            idNuevoTramite
	 * @param codocumento
	 *            codocumento
	 * @param tipoProcedimiento
	 *            tipoProcedimiento
	 * @param tipoProcedimiento2
	 *            tipoProcedimiento2
	 */
	void insertArbDocTramite(String idNuevoTramite, String codocumento, String tipoProcedimiento,
			String tipoProcedimiento2);

	/**
	 * 
	 * @param idNuevoTramite
	 *            idNuevoTramite
	 * @param codocumento
	 *            codocumento
	 * @param tipoProcedimiento
	 *            tipoProcedimiento
	 */
	void insertArbDocTramite(String idNuevoTramite, String codocumento, String tipoProcedimiento);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	Arbdoctemp updateOrigen(Arbdoctemp documentoHecho);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosHechoComunicacion(TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return int
	 */
	int updateArbDocTemp(Arbdoctemp arbdoctemp);

	/**
	 * Updates a single row in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return Arbdoctemp
	 */
	public Arbdoctemp updateDatosFirma(Arbdoctemp arbdoctemp);

	/**
	 * @param hdcodigo
	 *            String
	 * @param idTramiteApertura
	 *            String
	 */
	void volcarDocumentosReclamacionPrevia(String hdcodigo, String idTramiteApertura);

	/**
	 * @param idTramiteApertura
	 *            String
	 */
	void removeDocumentosReclamacionPrevia(String idTramiteApertura);

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbdoctemp> findAllOrdenesPago(Arbdoctemp arbdoctemp, Pagination pagination);

	/**
	 * Finds a List of rows in the Arbdoctemp table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbdoctemp> findAllDocumentosPagos(Arbdoctemp arbdoctemp, Pagination pagination);

	/**
	 * registra los temporales para documentos de establecimientos
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addArbAdjuntarDocsEst(TramiteComun tramiteComun);

	List<Arbdoctemp> findAllDocumentosEliminadosEst(TramiteComun tramiteComun, Pagination pagination);

	// 0150948
	/**
	 * copiaArbDocTramiteAlegacion
	 * 
	 * @param tridDestino
	 *            String
	 */
	void copiaArbDocAlegacion(String tridDestino, String excodigo);

	/**
	 * copiaArbDocTramiteRechazo
	 * 
	 * @param tridDestino
	 *            String
	 */
	void copiaArbDocRechazo(String tridDestino, String excodigo);

	/**
	 * copiaArbDocOrigen
	 * 
	 * @param origen
	 *            String
	 * @param tridDestino
	 *            String
	 */
	void copiaArbDocOrigen(String origen, String tridDestino, String excodigo);

	/**
	 * copiaArbDocLaudo
	 * 
	 * @param tridDestino
	 *            String
	 */
	void copiaArbDocLaudo(String tridDestino, String excodigo);
	// 0150948
}
