package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbcolegio;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbcolegioDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbcolegioDaoImpl implements ArbcolegioDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbcolegio> rwMap = new RowMapper<Arbcolegio>() {
		public Arbcolegio mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils
					.cargarDatosBDVO(resultSet);
			Arbcolegio retorno = new Arbcolegio(
					(columnasSeleccionadas.contains("XJTRID")) ? resultSet.getString("XJTRID")
							: null,
					new Arbitro(
							(columnasSeleccionadas.contains("XJARCODIGOP")) ? resultSet
									.getString("XJARCODIGOP") : null,
							(columnasSeleccionadas.contains("ARNOMBREPT")) ? resultSet
									.getString("ARNOMBREPT") : null,
							(columnasSeleccionadas.contains("ARNIFPT")) ? resultSet
									.getString("ARNIFPT") : null),
					new Arbitro(
							(columnasSeleccionadas.contains("XJARCODIGOPSUP")) ? resultSet
									.getString("XJARCODIGOPSUP") : null,
							(columnasSeleccionadas.contains("ARNOMBREPS")) ? resultSet
									.getString("ARNOMBREPS") : null,
							(columnasSeleccionadas.contains("ARNIFPS")) ? resultSet
									.getString("ARNIFPS") : null),
					new Arbitro(
							(columnasSeleccionadas.contains("XJARCODIGOAACC")) ? resultSet
									.getString("XJARCODIGOAACC") : null,
							(columnasSeleccionadas.contains("ARNOMBRETT")) ? resultSet
									.getString("ARNOMBRETT") : null,
							(columnasSeleccionadas.contains("ARNIFTT")) ? resultSet
									.getString("ARNIFTT") : null),
					new Arbitro(
							(columnasSeleccionadas
									.contains("XJARCODIGOAACCSUP")) ? resultSet
									.getString("XJARCODIGOAACCSUP") : null,
							(columnasSeleccionadas.contains("ARNOMBRETS")) ? resultSet
									.getString("ARNOMBRETS") : null,
							(columnasSeleccionadas.contains("ARNIFTS")) ? resultSet
									.getString("ARNIFTS") : null),
					new Arbitro(
							(columnasSeleccionadas.contains("XJARCODIGOOOEE")) ? resultSet
									.getString("XJARCODIGOOOEE") : null,
							(columnasSeleccionadas.contains("ARNOMBRERT")) ? resultSet
									.getString("ARNOMBRERT") : null,
							(columnasSeleccionadas.contains("ARNIFRT")) ? resultSet
									.getString("ARNIFRT") : null),
					new Arbitro(
							(columnasSeleccionadas
									.contains("XJARCODIGOOOEESUP")) ? resultSet
									.getString("XJARCODIGOOOEESUP") : null,
							(columnasSeleccionadas.contains("ARNOMBRERS")) ? resultSet
									.getString("ARNOMBRERS") : null,
							(columnasSeleccionadas.contains("ARNIFRS")) ? resultSet
									.getString("ARNIFRS") : null),
					new Secretar(
							(columnasSeleccionadas.contains("XJSRCODIGO")) ? resultSet
									.getString("XJSRCODIGO") : null,
							(columnasSeleccionadas.contains("SRNOMBREST")) ? resultSet
									.getString("SRNOMBREST") : null),
					new Secretar(
							(columnasSeleccionadas.contains("XJSRCODIGOSUP")) ? resultSet
									.getString("XJSRCODIGOSUP") : null,
							(columnasSeleccionadas.contains("SRNOMBRESS")) ? resultSet
									.getString("SRNOMBRESS") : null));

			retorno.setXjactivop((columnasSeleccionadas.contains("XJACTIVOP")) ? resultSet
					.getString("XJACTIVOP") : null);
			retorno.setXjactivopsup((columnasSeleccionadas
					.contains("XJACTIVOPSUP")) ? resultSet
					.getString("XJACTIVOPSUP") : null);
			retorno.setXjactivoaacc((columnasSeleccionadas
					.contains("XJACTIVOAACC")) ? resultSet
					.getString("XJACTIVOAACC") : null);
			retorno.setXjactivoaaccsup((columnasSeleccionadas
					.contains("XJACTIVOAACCSUP")) ? resultSet
					.getString("XJACTIVOAACCSUP") : null);
			retorno.setXjactivoooee((columnasSeleccionadas
					.contains("XJACTIVOOOEE")) ? resultSet
					.getString("XJACTIVOOOEE") : null);
			retorno.setXjactivoooeesup((columnasSeleccionadas
					.contains("XJACTIVOOOEESUP")) ? resultSet
					.getString("XJACTIVOOOEESUP") : null);

			return retorno;
		}

	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Pagination
	 * @return Arbcolegio
	 */
	public Arbcolegio add(Arbcolegio arbcolegio) {
		String query = "INSERT INTO ARBCOLEGIO (XJTRID, XJARCODIGOP, XJARCODIGOPSUP, XJARCODIGOAACC, XJARCODIGOAACCSUP, XJARCODIGOOOEE, XJARCODIGOOOEESUP, XJSRCODIGO, XJSRCODIGOSUP, XJACTIVOP, XJACTIVOAACC, XJACTIVOOOEE, XJFECALTA, XJFECMODIF, XJUSUALTA, XJUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbcolegio.getXjtrid(),
				arbcolegio.getXjarcodigop(), arbcolegio.getXjarcodigopsup(),
				arbcolegio.getXjarcodigoaacc(),
				arbcolegio.getXjarcodigoaaccsup(),
				arbcolegio.getXjarcodigoooee(),
				arbcolegio.getXjarcodigoooeesup(), arbcolegio.getXjsrcodigo(),
				arbcolegio.getXjsrcodigosup(), arbcolegio.getXjactivop(),
				arbcolegio.getXjactivoaacc(), arbcolegio.getXjactivoooee(),
				arbcolegio.getXjfecalta(), arbcolegio.getXjfecmodif(),
				arbcolegio.getXjusualta(), arbcolegio.getXjusumodif());
		return arbcolegio;
	}

	/**
	 * Updates a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Pagination
	 * @return Arbcolegio
	 */
	public Arbcolegio update(Arbcolegio arbcolegio) {
		String query = "UPDATE ARBCOLEGIO SET XJARCODIGOP=?, XJARCODIGOPSUP=?, XJARCODIGOAACC=?, XJARCODIGOAACCSUP=?, XJARCODIGOOOEE=?, XJARCODIGOOOEESUP=?, XJSRCODIGO=?, XJSRCODIGOSUP=?, "
				+ "XJACTIVOP=?, XJACTIVOPSUP=?, XJACTIVOAACC=?, XJACTIVOAACCSUP=?, XJACTIVOOOEE=?, XJACTIVOOOEESUP=?,"
				+ "XJFECALTA=?, XJFECMODIF=?, XJUSUALTA=?, XJUSUMODIF=? WHERE XJTRID=?";

		this.jdbcTemplate.update(query, arbcolegio.getXjarcodigop(),
				arbcolegio.getXjarcodigopsup(), arbcolegio.getXjarcodigoaacc(),
				arbcolegio.getXjarcodigoaaccsup(),
				arbcolegio.getXjarcodigoooee(),
				arbcolegio.getXjarcodigoooeesup(), arbcolegio.getXjsrcodigo(),
				arbcolegio.getXjsrcodigosup(), arbcolegio.getXjactivop(),
				arbcolegio.getXjactivopsup(), arbcolegio.getXjactivoaacc(),
				arbcolegio.getXjactivoaaccsup(), arbcolegio.getXjactivoooee(),
				arbcolegio.getXjactivoooeesup(), arbcolegio.getXjfecalta(),
				arbcolegio.getXjfecmodif(), arbcolegio.getXjusualta(),
				arbcolegio.getXjusumodif(), arbcolegio.getXjtrid());
		return arbcolegio;
	}

	/**
	 * Metodo para actualizar los indicadores de activo de cada arbitro del
	 * colegio
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	public Arbcolegio updateActivos(Arbcolegio arbcolegio) {
		String query = "UPDATE ARBCOLEGIO SET "
				+ "XJACTIVOP=?, XJACTIVOPSUP=?, XJACTIVOAACC=?, XJACTIVOAACCSUP=?, XJACTIVOOOEE=?, XJACTIVOOOEESUP=?,"
				+ "XJFECMODIF=?, XJUSUMODIF=? WHERE XJTRID=?";

		this.jdbcTemplate.update(query, arbcolegio.getXjactivop(),
				arbcolegio.getXjactivopsup(), arbcolegio.getXjactivoaacc(),
				arbcolegio.getXjactivoaaccsup(), arbcolegio.getXjactivoooee(),
				arbcolegio.getXjactivoooeesup(), arbcolegio.getXjfecmodif(),
				arbcolegio.getXjusumodif(), arbcolegio.getXjtrid());
		return arbcolegio;
	}

	/**
	 * Finds a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Pagination
	 * @return Arbcolegio
	 */
	@Transactional(readOnly = true)
	public Arbcolegio find(Arbcolegio arbcolegio) {
		String query = "SELECT t1.XJTRID XJTRID, t1.XJARCODIGOP XJARCODIGOP, pt.ARNOMBRE ARNOMBREPT,pt.ARNIF ARNIFPT, t1.XJARCODIGOPSUP XJARCODIGOPSUP, ps.ARNOMBRE ARNOMBREPS, ps.ARNIF ARNIFPS, t1.XJARCODIGOAACC XJARCODIGOAACC, tt.ARNOMBRE ARNOMBRETT, tt.ARNIF ARNIFTT, t1.XJARCODIGOAACCSUP XJARCODIGOAACCSUP, ts.ARNOMBRE ARNOMBRETS, ts.ARNIF ARNIFTS, t1.XJARCODIGOOOEE XJARCODIGOOOEE, rt.ARNOMBRE ARNOMBRERT, rt.ARNIF ARNIFRT, t1.XJARCODIGOOOEESUP XJARCODIGOOOEESUP, rs.ARNOMBRE ARNOMBRERS, rs.ARNIF ARNIFRS, t1.XJSRCODIGO XJSRCODIGO, st.SRNOMBRE SRNOMBREST,  t1.XJSRCODIGOSUP XJSRCODIGOSUP, ss.SRNOMBRE SRNOMBRESS, "
				+ " t1.XJACTIVOP XJACTIVOP, t1.XJACTIVOPSUP XJACTIVOPSUP, t1.XJACTIVOAACC XJACTIVOAACC, t1.XJACTIVOAACCSUP XJACTIVOAACCSUP, t1.XJACTIVOOOEE XJACTIVOOOEE, t1.XJACTIVOOOEESUP XJACTIVOOOEESUP"
				+ " FROM ARBCOLEGIO t1, ARBITRO pt, ARBITRO ps, ARBITRO tt, ARBITRO ts, ARBITRO rt, ARBITRO rs, SECRETAR st, SECRETAR ss "
				+ " WHERE t1.XJTRID = ? AND t1.XJARCODIGOP = pt.ARCODIGO(+) AND t1.XJARCODIGOPSUP = ps.ARCODIGO(+) AND t1.XJARCODIGOAACC = tt.ARCODIGO(+) AND t1.XJARCODIGOAACCSUP = ts.ARCODIGO(+)"
				+ " AND t1.XJARCODIGOOOEE = rt.ARCODIGO(+) AND t1.XJARCODIGOOOEESUP = rs.ARCODIGO(+) "
				+ " AND t1.XJSRCODIGO = st.SRCODIGO(+) AND t1.XJSRCODIGOSUP = ss.SRCODIGO(+) ";

		List<Arbcolegio> arbcolegioList = this.jdbcTemplate.query(query,
				this.rwMap, arbcolegio.getXjtrid());
		return (Arbcolegio) DataAccessUtils.uniqueResult(arbcolegioList);
	}

	/**
	 * Removes a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Pagination
	 * @return
	 */
	public void remove(Arbcolegio arbcolegio) {
		String query = "DELETE FROM ARBCOLEGIO WHERE XJTRID=?";
		this.jdbcTemplate.update(query, arbcolegio.getXjtrid());
	}

	/**
	 * Finds a List of rows in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbcolegio> findAll(Arbcolegio arbcolegio, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.XJTRID XJTRID, t1.XJARCODIGOP XJARCODIGOP, pt.ARNOMBRE ARNOMBREPT,pt.ARNIF ARNIFPT, t1.XJARCODIGOPSUP XJARCODIGOPSUP, ps.ARNOMBRE ARNOMBREPS, ps.ARNIF ARNIFPS, t1.XJARCODIGOAACC XJARCODIGOAACC, tt.ARNOMBRE ARNOMBRETT, tt.ARNIF ARNIFTT, t1.XJARCODIGOAACCSUP XJARCODIGOAACCSUP, ts.ARNOMBRE ARNOMBRETS, ts.ARNIF ARNIFTS, t1.XJARCODIGOOOEE XJARCODIGOOOEE, rt.ARNOMBRE ARNOMBRERT, rt.ARNIF ARNIFRT, t1.XJARCODIGOOOEESUP XJARCODIGOOOEESUP, rs.ARNOMBRE ARNOMBRERS, rs.ARNIF ARNIFRS, t1.XJSRCODIGO XJSRCODIGO, st.SRNOMBRE SRNOMBREST,  t1.XJSRCODIGOSUP XJSRCODIGOSUP, ss.SRNOMBRE SRNOMBRESS"
						+ " FROM ARBCOLEGIO t1, ARBITRO pt, ARBITRO ps, ARBITRO tt, ARBITRO ts, ARBITRO rt, ARBITRO rs, SECRETAR st, SECRETAR ss "
						+ " WHERE t1.XJARCODIGOP = pt.ARCODIGO(+) AND t1.XJARCODIGOPSUP = ps.ARCODIGO(+) AND t1.XJARCODIGOAACC = tt.ARCODIGO(+) AND t1.XJARCODIGOAACCSUP = ts.ARCODIGO(+)"
						+ " AND t1.XJARCODIGOOOEE = rt.ARCODIGO(+) AND t1.XJARCODIGOOOEESUP = rs.ARCODIGO(+) "
						+ " AND t1.XJSRCODIGO = st.SRCODIGO(+) AND t1.XJSRCODIGOSUP = ss.SRCODIGO(+) ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbcolegio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbcolegio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbcolegio arbcolegio) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBCOLEGIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbcolegio);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbcolegio table using like.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbcolegio> findAllLike(Arbcolegio arbcolegio,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.XJTRID XJTRID, t1.XJARCODIGOP XJARCODIGOP, pt.ARNOMBRE ARNOMBREPT,pt.ARNIF ARNIFPT, t1.XJARCODIGOPSUP XJARCODIGOPSUP, ps.ARNOMBRE ARNOMBREPS, ps.ARNIF ARNIFPS, t1.XJARCODIGOAACC XJARCODIGOAACC, tt.ARNOMBRE ARNOMBRETT, tt.ARNIF ARNIFTT, t1.XJARCODIGOAACCSUP XJARCODIGOAACCSUP, ts.ARNOMBRE ARNOMBRETS, ts.ARNIF ARNIFTS, t1.XJARCODIGOOOEE XJARCODIGOOOEE, rt.ARNOMBRE ARNOMBRERT, rt.ARNIF ARNIFRT, t1.XJARCODIGOOOEESUP XJARCODIGOOOEESUP, rs.ARNOMBRE ARNOMBRERS, rs.ARNIF ARNIFRS, t1.XJSRCODIGO XJSRCODIGO, st.SRNOMBRE SRNOMBREST,  t1.XJSRCODIGOSUP XJSRCODIGOSUP, ss.SRNOMBRE SRNOMBRESS"
						+ " FROM ARBCOLEGIO t1, ARBITRO pt, ARBITRO ps, ARBITRO tt, ARBITRO ts, ARBITRO rt, ARBITRO rs, SECRETAR st, SECRETAR ss "
						+ " WHERE t1.XJARCODIGOP = pt.ARCODIGO(+) AND t1.XJARCODIGOPSUP = ps.ARCODIGO(+) AND t1.XJARCODIGOAACC = tt.ARCODIGO(+) AND t1.XJARCODIGOAACCSUP = ts.ARCODIGO(+)"
						+ " AND t1.XJARCODIGOOOEE = rt.ARCODIGO(+) AND t1.XJARCODIGOOOEESUP = rs.ARCODIGO(+) "
						+ " AND t1.XJSRCODIGO = st.SRCODIGO(+) AND t1.XJSRCODIGOSUP = ss.SRCODIGO(+) ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbcolegio, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbcolegio>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbcolegio table using like.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbcolegio arbcolegio, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBCOLEGIO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbcolegio, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbcolegio entity
	 * 
	 * @param arbcolegio
	 *            Arbcolegio Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbcolegio arbcolegio) {

		StringBuilder where = new StringBuilder(
				ArbcolegioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbcolegio != null && arbcolegio.getXjtrid() != null) {
			where.append(" AND t1.XJTRID = ?");
			params.add(arbcolegio.getXjtrid());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigop() != null) {
			where.append(" AND t1.XJARCODIGOP = ?");
			params.add(arbcolegio.getXjarcodigop());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigopsup() != null) {
			where.append(" AND t1.XJARCODIGOPSUP = ?");
			params.add(arbcolegio.getXjarcodigopsup());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoaacc() != null) {
			where.append(" AND t1.XJARCODIGOAACC = ?");
			params.add(arbcolegio.getXjarcodigoaacc());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoaaccsup() != null) {
			where.append(" AND t1.XJARCODIGOAACCSUP = ?");
			params.add(arbcolegio.getXjarcodigoaaccsup());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoooee() != null) {
			where.append(" AND t1.XJARCODIGOOOEE = ?");
			params.add(arbcolegio.getXjarcodigoooee());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoooeesup() != null) {
			where.append(" AND t1.XJARCODIGOOOEESUP = ?");
			params.add(arbcolegio.getXjarcodigoooeesup());
		}
		if (arbcolegio != null && arbcolegio.getXjsrcodigo() != null) {
			where.append(" AND t1.XJSRCODIGO = ?");
			params.add(arbcolegio.getXjsrcodigo());
		}
		if (arbcolegio != null && arbcolegio.getXjsrcodigosup() != null) {
			where.append(" AND t1.XJSRCODIGOSUP = ?");
			params.add(arbcolegio.getXjsrcodigosup());
		}
		if (arbcolegio != null && arbcolegio.getXjfecalta() != null) {
			where.append(" AND t1.XJFECALTA = ?");
			params.add(arbcolegio.getXjfecalta());
		}
		if (arbcolegio != null && arbcolegio.getXjfecmodif() != null) {
			where.append(" AND t1.XJFECMODIF = ?");
			params.add(arbcolegio.getXjfecmodif());
		}
		if (arbcolegio != null && arbcolegio.getXjusualta() != null) {
			where.append(" AND t1.XJUSUALTA = ?");
			params.add(arbcolegio.getXjusualta());
		}
		if (arbcolegio != null && arbcolegio.getXjusumodif() != null) {
			where.append(" AND t1.XJUSUMODIF = ?");
			params.add(arbcolegio.getXjusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbcolegio entity
	 * 
	 * @param arbcolegio
	 *            Arbcolegio Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbcolegio arbcolegio,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbcolegioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbcolegio != null && arbcolegio.getXjtrid() != null) {
			where.append(" AND t1.XJTRID = ?");
			params.add(arbcolegio.getXjtrid());
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigop() != null) {
			where.append(" AND UPPER(t1.XJARCODIGOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjarcodigop().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjarcodigop().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XJARCODIGOP IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigopsup() != null) {
			where.append(" AND UPPER(t1.XJARCODIGOPSUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjarcodigopsup().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjarcodigopsup().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XJARCODIGOPSUP IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoaacc() != null) {
			where.append(" AND UPPER(t1.XJARCODIGOAACC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjarcodigoaacc().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjarcodigoaacc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XJARCODIGOAACC IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoaaccsup() != null) {
			where.append(" AND UPPER(t1.XJARCODIGOAACCSUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjarcodigoaaccsup().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbcolegio.getXjarcodigoaaccsup().toUpperCase() + "%");
			}
			where.append(" AND t1.XJARCODIGOAACCSUP IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoooee() != null) {
			where.append(" AND UPPER(t1.XJARCODIGOOOEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjarcodigoooee().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjarcodigoooee().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XJARCODIGOOOEE IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjarcodigoooeesup() != null) {
			where.append(" AND UPPER(t1.XJARCODIGOOOEESUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjarcodigoooeesup().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbcolegio.getXjarcodigoooeesup().toUpperCase() + "%");
			}
			where.append(" AND t1.XJARCODIGOOOEESUP IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjsrcodigo() != null) {
			where.append(" AND UPPER(t1.XJSRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjsrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjsrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.XJSRCODIGO IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjsrcodigosup() != null) {
			where.append(" AND UPPER(t1.XJSRCODIGOSUP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjsrcodigosup().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjsrcodigosup().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XJSRCODIGOSUP IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjfecalta() != null) {
			where.append(" AND t1.XJFECALTA = ?");
			params.add(arbcolegio.getXjfecalta());
		}
		if (arbcolegio != null && arbcolegio.getXjfecmodif() != null) {
			where.append(" AND t1.XJFECMODIF = ?");
			params.add(arbcolegio.getXjfecmodif());
		}
		if (arbcolegio != null && arbcolegio.getXjusualta() != null) {
			where.append(" AND UPPER(t1.XJUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.XJUSUALTA IS NOT NULL");
		}
		if (arbcolegio != null && arbcolegio.getXjusumodif() != null) {
			where.append(" AND UPPER(t1.XJUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbcolegio.getXjusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbcolegio.getXjusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.XJUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
