package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbcolegio;

/**
 * ArbcolegioDao  
 * 
 *  
 */

public interface ArbcolegioDao {

	/**
	 * Inserts a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	Arbcolegio add(Arbcolegio arbcolegio);

	/**
	 * Updates a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	Arbcolegio update(Arbcolegio arbcolegio);

	/**
	 * Finds a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	Arbcolegio find(Arbcolegio arbcolegio);

	/**
	 * Deletes a single row in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return
	 */
	void remove(Arbcolegio arbcolegio);

	/**
	 * Finds a List of rows in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbcolegio> findAll(Arbcolegio arbcolegio, Pagination pagination);

	/**
	 * Counts rows in the Arbcolegio table.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Long
	 */
	Long findAllCount(Arbcolegio arbcolegio);

	/**
	 * Finds rows in the Arbcolegio table using like.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbcolegio> findAllLike(Arbcolegio arbcolegio, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbcolegio table using like.
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbcolegio arbcolegio, Boolean startsWith);

	/**
	 * Metodo para actualizar los indicadores de activo de cada arbitro del
	 * colegio
	 * 
	 * @param arbcolegio
	 *            Arbcolegio
	 * @return Arbcolegio
	 */
	Arbcolegio updateActivos(Arbcolegio arbcolegio);
}
