/*
 * 
 */
package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbexp;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.Arbtramexp;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbbandejaDaoImpl  
 * 
 *  
 */

@Repository()
@Transactional()
public class ArbbandejaDaoImpl implements ArbbandejaDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger LOGGER = LoggerFactory.getLogger(ArbbandejaDaoImpl.class);

	private RowMapper<Arbbandeja> rwMap = new RowMapper<Arbbandeja>() {
		public Arbbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Arbexp arbexp = new Arbexp();
			arbexp.setExcodigo(resultSet.getString("SOLARBSACODIGO"));
			arbexp.setExdesces(resultSet.getString("EXDESCES"));
			arbexp.setExdesces(resultSet.getString("EXDESCEU"));

			Solarb solarb = new Solarb(resultSet.getString("SOLARBSACODIGO"));
			solarb.setArbexp(arbexp);

			Arbinterv arbinterv = new Arbinterv(resultSet.getBigDecimal("ArbintervUAIDINTERV"));
			arbinterv.setUanombre(resultSet.getString("ArbintervUANOMBRE"));
			arbinterv.setUaapellido1(resultSet.getString("ArbintervUAAPELLIDO1"));
			arbinterv.setUaapellido2(resultSet.getString("ArbintervUAAPELLIDO2"));
			arbinterv.setUanif(resultSet.getString("ArbintervUANIF"));

			CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MONITORMOCODIGO"),
					resultSet.getString("MONITORMONOMBRE"), null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null);
			Tramite tramite = new Tramite(resultSet.getString("ARBTRAMEXPTRCODIGO"), resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null, null, null);
			Arbtramexp arbtramexp = new Arbtramexp(resultSet.getString("ABTRID"));
			arbtramexp.setTramite(tramite);
			arbtramexp.setTrcodigo(resultSet.getString("ARBTRAMEXPTRCODIGO"));
			arbtramexp.setTrnomtrames(resultSet.getString("ARBTRAMEXPTRNOMTRAMES"));
			arbtramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

			Fase fase = new Fase(resultSet.getString("ABFASE"), resultSet.getString("FASEFNOMBRE"),
					resultSet.getString("FASEFNOMBREE"), null, null);

			return new Arbbandeja(resultSet.getString("ABID"), resultSet.getString("ABTRID"),
					resultSet.getDate("ABFEC"), resultSet.getString("ABESTADO"), resultSet.getDate("ABFECLIMITE"),
					resultSet.getString("ABFASE"), resultSet.getString("ABNOMDOC"), resultSet.getDate("ABFECALTA"),
					resultSet.getDate("ABFECMODIF"), resultSet.getString("ABUSUALTA"),
					resultSet.getString("ABUSUMODIF"), solarb, arbinterv, censoMonitor, arbtramexp, fase,
					resultSet.getString("ABTIPO"), resultSet.getDate("ABFECINI"), resultSet.getString("ABTEXTO"),
					resultSet.getString("ABTEXTOE"));
		}
	};

	private RowMapper<Arbbandeja> rwMapBandejaArbitrajes = new RowMapper<Arbbandeja>() {
		public Arbbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			try {
				/*
				 * Arbexp arbexp = new Arbexp(
				 * resultSet.getString("SOLARBSACODIGO"), null, null,
				 * resultSet.getString("EXDESCES"),
				 * resultSet.getString("EXDESCEU"), null, null, null, null,
				 * null, null, null, null, null, null, null, null, null, null,
				 * null, null, null, null, null, null, null, null, null, null,
				 * null, null, null, null, null, null, null, null);
				 */
				Arbexp arbexp = new Arbexp(resultSet.getString("SOLARBSACODIGO"));

				Solarb solarb = new Solarb(resultSet.getString("SOLARBSACODIGO"));
				solarb.setArbexp(arbexp);
				solarb.setcodCompleto(resultSet.getString("CODCOMPLETO"));
				solarb.setDtnombre(resultSet.getString("SOLARBDTNOMBRE"));
				Arbinterv arbinterv = new Arbinterv(resultSet.getBigDecimal("ArbintervUAIDINTERV"));
				arbinterv.setUanombre(resultSet.getString("ArbintervUANOMBRE"));
				arbinterv.setUaapellido1(resultSet.getString("ArbintervUAAPELLIDO1"));
				arbinterv.setUaapellido2(resultSet.getString("ArbintervUAAPELLIDO2"));
				// arbinterv.setUanif(resultSet.getString("ArbintervUANIF"));

				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MONITORMOCODIGO"),
						resultSet.getString("MONITORMONOMBRE"), null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null);
				Tramite tramite = new Tramite(resultSet.getString("ARBTRAMEXPTRCODIGO"),
						resultSet.getString("TRNOMBRE"), resultSet.getString("TRNOMBREE"), null, null, null, null, null,
						null);
				Fase fase = new Fase(resultSet.getString("ABFASE"), resultSet.getString("FASEFNOMBRE"),
						resultSet.getString("FASEFNOMBREE"), null, null);

				Arbtramexp arbtramexp = new Arbtramexp(resultSet.getString("ABTRID"));
				arbtramexp.setTramite(tramite);
				arbtramexp.setTrcodigo(resultSet.getString("ARBTRAMEXPTRCODIGO"));
				arbtramexp.setTrnomtrames(resultSet.getString("ARBTRAMEXPTRNOMTRAMES"));
				arbtramexp.setTrfecini(resultSet.getDate("TRFECINI"));
				arbtramexp.setTrfecfin(resultSet.getDate("TRFECFIN"));
				arbtramexp.setTrfechaenviobopvboe(resultSet.getDate("ARBTRAMEXPTRFECHAENVIOBOPVBOE"));

				arbtramexp.setTrestadoacuse(resultSet.getString("TRESTADOACUSE"));
				arbtramexp.setTrresotipo(resultSet.getString("TRRESOTIPO"));
				arbtramexp.setTrresultado(resultSet.getString("TRRESULTADO"));

				arbtramexp.setEnvcdessitcorreoses(resultSet.getString("ENVCDESSITCORREOSES"));
				arbtramexp.setEnvcdessitcorreoseu(resultSet.getString("ENVCDESSITCORREOSEU"));
				arbtramexp.setTristelematica(resultSet.getString("TRISTELEMATICA"));

				Arbbandeja arbbandeja = new Arbbandeja(resultSet.getString("ABID"), resultSet.getString("ABTRID"),
						resultSet.getDate("ABFEC"), resultSet.getString("ABESTADO"), resultSet.getDate("ABFECLIMITE"),
						resultSet.getString("ABFASE"), resultSet.getString("ABNOMDOC"), resultSet.getDate("ABFECALTA"),
						resultSet.getDate("ABFECMODIF"), resultSet.getString("ABUSUALTA"),
						resultSet.getString("ABUSUMODIF"), solarb, arbinterv, censoMonitor, arbtramexp, fase,
						resultSet.getString("ABTIPO"), resultSet.getDate("ABFECINI"), resultSet.getString("ABTEXTO"),
						resultSet.getString("ABTEXTOE"));
				arbbandeja.setAvisos(resultSet.getString("AVISOS"));
				arbbandeja.setTramitesPendientes(resultSet.getString("TRAMITESPENDIENTES"));
				return arbbandeja;

			} catch (Exception e) {
				e.printStackTrace();
				ArbbandejaDaoImpl.LOGGER.error("Error producido en rwMapBandejaArbciones: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	};

	private RowMapper<Arbbandeja> rwMapAvisoAlegaciones = new RowMapper<Arbbandeja>() {
		public Arbbandeja mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			try {

				Solarb solarb = new Solarb(resultSet.getString("SOLARBSACODIGO"));
				Arbinterv arbinterv = new Arbinterv(resultSet.getBigDecimal("ArbintervUAIDINTERV"));
				CensoMonitor censoMonitor = new CensoMonitor(resultSet.getString("MonitorMOCODIGO"), null);
				Arbtramexp arbtramexp = new Arbtramexp(resultSet.getString("ABTRID"));
				Fase fase = new Fase(resultSet.getString("ABFASE"), null, null, null, null);

				return new Arbbandeja(resultSet.getString("ABID"), resultSet.getString("ABTRID"),
						resultSet.getDate("ABFEC"), resultSet.getString("ABESTADO"), resultSet.getDate("ABFECLIMITE"),
						resultSet.getString("ABFASE"), resultSet.getString("ABNOMDOC"), resultSet.getDate("ABFECALTA"),
						resultSet.getDate("ABFECMODIF"), resultSet.getString("ABUSUALTA"),
						resultSet.getString("ABUSUMODIF"), solarb, arbinterv, censoMonitor, arbtramexp, fase,
						resultSet.getString("ABTIPO"), resultSet.getDate("ABFECINI"), resultSet.getString("ABTEXTO"),
						resultSet.getString("ABTEXTOE"));
			} catch (Exception e) {
				e.printStackTrace();
				ArbbandejaDaoImpl.LOGGER.error("Error producido en rwMapBandejaArbciones: " + e.getMessage(), e);
				throw new Y41bUDAException("error.generico", true, e);
			}
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Pagination
	 * @return Arbbandeja
	 */
	public Arbbandeja add(Arbbandeja arbbandeja) {
		try {
			String query = "INSERT INTO ARBBANDEJA (ABSACODIGO, ABUAIDINTERV, ABULTINSTR, ABTRID, ABFEC, ABESTADO, ABFECLIMITE, ABFASE, ABNOMDOC, ABTIPO, ABFECINI, ABTEXTO, ABTEXTOE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
			Object getSolarbExcodigoAux = null;
			if (arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSacodigo() != null) {
				getSolarbExcodigoAux = arbbandeja.getSolarb().getSacodigo();
			}
			Object getArbintervUaidintervAux = null;
			if (arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUaidinterv() != null) {
				getArbintervUaidintervAux = arbbandeja.getArbinterv().getUaidinterv();
			}
			Object getMonitorMocodigoAux = null;
			if (arbbandeja.getMonitor() != null && arbbandeja.getMonitor().getMocodigo() != null) {
				getMonitorMocodigoAux = arbbandeja.getMonitor().getMocodigo();
			}
			this.jdbcTemplate.update(query, getSolarbExcodigoAux, getArbintervUaidintervAux, getMonitorMocodigoAux,
					arbbandeja.getAbtrid(), arbbandeja.getAbfec(), arbbandeja.getAbestado(),
					arbbandeja.getAbfeclimite(), arbbandeja.getAbfase(), arbbandeja.getAbnomdoc(),
					arbbandeja.getAbtipo(), arbbandeja.getAbfecini(), arbbandeja.getAbtexto(),
					arbbandeja.getAbtextoe());
			return arbbandeja;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Updates a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Pagination
	 * @return Arbbandeja
	 */
	public Arbbandeja update(Arbbandeja arbbandeja) {
		String query = "UPDATE ARBBANDEJA SET ABSACODIGO=?, ABUAIDINTERV=?, ABULTINSTR=?, ABTRID=?, ABFEC=?, ABESTADO=?, ABFECLIMITE=?, ABFASE=?, ABNOMDOC=?, ABFECALTA=?, ABFECMODIF=?, ABUSUALTA=?, ABUSUMODIF=?, ABTIPO=?, ABFECINI=?, ABTEXTO=?, ABTEXTOE=? WHERE ABID=?";
		Object getSolarbExcodigoAux = null;
		if (arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSacodigo() != null) {
			getSolarbExcodigoAux = arbbandeja.getSolarb().getSacodigo();
		}
		Object getArbintervUaidintervAux = null;
		if (arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUaidinterv() != null) {
			getArbintervUaidintervAux = arbbandeja.getArbinterv().getUaidinterv();
		}
		Object getMonitorMocodigoAux = null;
		if (arbbandeja.getMonitor() != null && arbbandeja.getMonitor().getMocodigo() != null) {
			getMonitorMocodigoAux = arbbandeja.getMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, getSolarbExcodigoAux, getArbintervUaidintervAux, getMonitorMocodigoAux,
				arbbandeja.getAbtrid(), arbbandeja.getAbfec(), arbbandeja.getAbestado(), arbbandeja.getAbfeclimite(),
				arbbandeja.getAbfase(), arbbandeja.getAbnomdoc(), arbbandeja.getAbfecalta(), arbbandeja.getAbfecmodif(),
				arbbandeja.getAbusualta(), arbbandeja.getAbusumodif(), arbbandeja.getAbtipo(), arbbandeja.getAbfecini(),
				arbbandeja.getAbtexto(), arbbandeja.getAbtextoe(), arbbandeja.getAbid());
		return arbbandeja;
	}

	/**
	 * Finds a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Pagination
	 * @return Arbbandeja
	 */
	@Transactional(readOnly = true)
	public Arbbandeja find(Arbbandeja arbbandeja) {
		String query = "SELECT t1.ABID ABID, t1.ABTRID ABTRID, t1.ABFEC ABFEC, t1.ABESTADO ABESTADO, t1.ABFECLIMITE ABFECLIMITE, t1.ABFASE ABFASE, t1.ABNOMDOC ABNOMDOC, t1.ABFECALTA ABFECALTA, t1.ABFECMODIF ABFECMODIF, t1.ABUSUALTA ABUSUALTA, t1.ABUSUMODIF ABUSUMODIF, t1.ABTIPO ABTIPO, t1.ABFECINI ABFECINI,t1.ABTEXTO ABTEXTO,t1.ABTEXTOE ABTEXTOE, "
				+ " t2.SACODIGO SOLARBSACODIGO, t3.UAIDINTERV ARBINTERVUAIDINTERV, t3.UANOMBRE ARBINTERVUANOMBRE, t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2, t3.UANIF ARBINTERVUANIF, t3.UANRTEL ARBINTERVUANRTEL, t3.UANRTEL2 ARBINTERVUANRTEL2, t3.UAPROV_ID ARBINTERVUAPROVID, t3.UAMUN_ID ARBINTERVUAMUNID, t3.UALOC_ID ARBINTERVUALOCID, t3.UACALLE_ID ARBINTERVUACALLEID, t3.UACP_ID ARBINTERVUACPID, t3.UAPORTAL_ID ARBINTERVUAPORTALID, t3.UANOMBRE_PISO ARBINTERVUANOMBREPISO, t3.UADIRE_NOCAPV ARBINTERVUADIRENOCAPV, t3.UADIRE_ANT ARBINTERVUADIREANT, t3.UATIPOINTERV ARBINTERVUATIPOINTERV, t3.UADTCODIGO ARBINTERVUADTCODIGO, t3.UAESCODIGO ARBINTERVUAESCODIGO, t3.UATRFECALTA ARBINTERVUATRFECALTA, t3.UATRFECMODIF ARBINTERVUATRFECMODIF, t3.UATRUSUALTA ARBINTERVUATRUSUALTA, t3.UATRUSUMODIF ARBINTERVUATRUSUMODIF, t3.UAFECALTA ARBINTERVUAFECALTA, t3.UAFECMODIF ARBINTERVUAFECMODIF, t3.UAUSUALTA ARBINTERVUAUSUALTA, t3.UAUSUMODIF ARBINTERVUAUSUMODIF, t4.MOCODIGO MONITORMOCODIGO, t4.MONOMBRE MONITORMONOMBRE, t4.MOCOOR MONITORMOCOOR, t4.MOCOEM MONITORMOCOEM, t4.MOUSU MONITORMOUSU, t4.MOCLAVE MONITORMOCLAVE, t4.MOFECBAJA MONITORMOFECBAJA, t4.MOADMIN MONITORMOADMIN, t4.MOPRIMERA MONITORMOPRIMERA, t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES, t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE, t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES, t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE, t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION, t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS, t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO, t4.USUARIOXLNET MONITORUSUARIOXLNET, t3.UAEXCODIGO ARBINTERVUAEXCODIGO "
				+ " FROM ARBBANDEJA t1 , SOLARB t2 , ARBINTERV t3 , CENSO_MONITOR t4  WHERE t1.ABID = ?   AND t1.ABSACODIGO= t2.SACODIGO(+) AND t1.ABUAIDINTERV= t3.UAIDINTERV(+) AND t1.ABULTINSTR= t4.MOCODIGO(+)";

		List<Arbbandeja> arbbandejaList = this.jdbcTemplate.query(query, this.rwMap, arbbandeja.getAbid());
		return (Arbbandeja) DataAccessUtils.uniqueResult(arbbandejaList);
	}

	/**
	 * Borra la bandeja para un solarbte.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 */
	@Transactional(readOnly = true)
	public void deleteBandejaPorExpediente(Arbbandeja arbbandeja) {
		StringBuffer query = new StringBuffer("DELETE FROM ARBBANDEJA WHERE ABSACODIGO=? AND ABTIPO IS NULL");
		ArbbandejaDaoImpl.LOGGER.info(
				"ArbbandejaDaoImpl - deleteBandejaPorExpediente - Inicio " + arbbandeja.getSolarb().getSacodigo());
		this.jdbcTemplate.update(query.toString(), arbbandeja.getSolarb().getSacodigo());

	}

	/**
	 * Borra los avisos caducados de la bandeja.
	 * 
	 */

	public void deleteBandejaAvisosCaducados() {

		/*
		 * borramos los caducados siempre que el aviso sea visualizable antes de
		 * la fecha limite
		 */
		StringBuffer query = new StringBuffer(
				"DELETE FROM ARBBANDEJA WHERE ABTIPO IN (" + "'" + Y41bConstantes.TIPO_AVISO_ARBITRAJE_ALEGACIONES
						+ "'," + "'" + Y41bConstantes.TIPO_AVISO_ARBITRAJE_REQ_SUBSANACION + "'," + "'"
						+ Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACLARACION + "'," + "'"
						+ Y41bConstantes.TIPO_AVISO_ARBITRAJE_NULIDAD + "'" + ") AND (ABFECLIMITE < sysdate) ");
		/*
		 * Los que no se borran por visualizarse tras la fecha limite son:
		 * TIPO_AVISO_ARBITRAJE_CONVENIO, TIPO_AVISO_ARBITRAJE_LAUDO_RESO,
		 * TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE,
		 * TIPO_AVISO_ARBITRAJE_ADMISION
		 */
		this.jdbcTemplate.update(query.toString());

	}

	/**
	 * Removes a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Pagination
	 * @return
	 */
	public void remove(Arbbandeja arbbandeja) {
		String query = "DELETE FROM ARBBANDEJA WHERE ABID=?";
		ArbbandejaDaoImpl.LOGGER
				.info("ArbbandejaDaoImpl - *** Remove - Elimino Registro de la bandeja " + arbbandeja.getAbid());
		this.jdbcTemplate.update(query, arbbandeja.getAbid());
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbbandeja> findAll(Arbbandeja arbbandeja, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ABID ABID,t1.ABTRID ABTRID,t1.ABFEC ABFEC,t1.ABESTADO ABESTADO,t1.ABFECLIMITE ABFECLIMITE,t1.ABFASE ABFASE,t1.ABNOMDOC ABNOMDOC,t1.ABFECALTA ABFECALTA,t1.ABFECMODIF ABFECMODIF,t1.ABUSUALTA ABUSUALTA,t1.ABUSUMODIF ABUSUMODIF, t1.ABTIPO ABTIPO, t1.ABFECINI ABFECINI,t1.ABTEXTO ABTEXTO,t1.ABTEXTOE ABTEXTOE "
						+ " ,t2.SACODIGO SOLARBSACODIGO,(SELECT EXDESCES FROM ARBEXP WHERE T2.SACODIGO = EXCODIGO) AS EXDESCES, (SELECT EXDESCEU FROM ARBEXP WHERE T2.SACODIGO = EXCODIGO) AS EXDESCEU, t2.SACOJA SOLARBSACOJA,t2.SANRAN SOLARBEXNRAN,t2.SANROR SOLARBEXNROR,t2.SACOJA || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP
						+ "' || t2.SANRAN CODCOMPLETO, t3.UAIDINTERV ARBINTERVUAIDINTERV,t3.UANOMBRE ARBINTERVUANOMBRE,t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2, t3.UANIF ARBINTERVUANIF,t3.UANRTEL ARBINTERVUANRTEL,t3.UANRTEL2 ARBINTERVUANRTEL2,t3.UAPROV_ID ARBINTERVUAPROVID,t3.UAMUN_ID ARBINTERVUAMUNID,t3.UALOC_ID ARBINTERVUALOCID,t3.UACALLE_ID ARBINTERVUACALLEID,t3.UACP_ID ARBINTERVUACPID,t3.UAPORTAL_ID ARBINTERVUAPORTALID,t3.UANOMBRE_PISO ARBINTERVUANOMBREPISO,t3.UADIRE_NOCAPV ARBINTERVUADIRENOCAPV,t3.UADIRE_ANT ARBINTERVUADIREANT,t3.UATIPOINTERV ARBINTERVUATIPOINTERV,t3.UADTCODIGO ARBINTERVUADTCODIGO,t3.UAESCODIGO ARBINTERVUAESCODIGO,t3.UATRFECALTA ARBINTERVUATRFECALTA,t3.UATRFECMODIF ARBINTERVUATRFECMODIF,t3.UATRUSUALTA ARBINTERVUATRUSUALTA,t3.UATRUSUMODIF ARBINTERVUATRUSUMODIF,t3.UAFECALTA ARBINTERVUAFECALTA,t3.UAFECMODIF ARBINTERVUAFECMODIF,t3.UAUSUALTA ARBINTERVUAUSUALTA,t3.UAUSUMODIF ARBINTERVUAUSUMODIF,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE,t4.MOCOOR MONITORMOCOOR,t4.MOCOEM MONITORMOCOEM,t4.MOUSU MONITORMOUSU,t4.MOCLAVE MONITORMOCLAVE,t4.MOFECBAJA MONITORMOFECBAJA,t4.MOADMIN MONITORMOADMIN,t4.MOPRIMERA MONITORMOPRIMERA,t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES,t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE,t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES,t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE,t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION,t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS,t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO,t4.USUARIOXLNET MONITORUSUARIOXLNET,t3.UAEXCODIGO ARBINTERVUAEXCODIGO, T5.TRNOMTRAMES ARBTRAMEXPTRNOMTRAMES, t5.TRCODIGO ARBTRAMEXPTRCODIGO, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE" + ", t5.TRISTELEMATICA TRISTELEMATICA ");
		query.append(
				"FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,CENSO_MONITOR t4, ARBTRAMEXP t5, FASE t6, TRAMITE t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbbandeja);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND t5.TRUAIDINTERV = t3.UAIDINTERV(+) AND t1.ABULTINSTR= t4.MOCODIGO(+) AND t1.ABTRID = t5.TRID(+) AND t1.ABFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null && pagination.getSort() != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbbandeja>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbbandeja arbbandeja) {
		/*
		 * StringBuilder query = new StringBuilder(
		 * "SELECT COUNT(1) FROM ARBBANDEJA t1 , SOLARB t2 , ARBINTERV t3 , CENSO_MONITOR t4 "
		 * );
		 */
		try {
			StringBuilder query = new StringBuilder("SELECT COUNT(1) "
					+ " FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,CENSO_MONITOR t4, ARBTRAMEXP t5, FASE t6, TRAMITE t7 ");
			// Where clause & Params
			Map<String, ?> mapaWhere = this.getWhereMap(arbbandeja);

			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND t5.TRUAIDINTERV = t3.UAIDINTERV(+) AND t1.ABULTINSTR= t4.MOCODIGO(+) AND t1.ABTRID = t5.TRID(+) AND t1.ABFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			List<?> params = (List<?>) mapaWhere.get("params");

			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbbandejaDaoImpl.LOGGER.error("Error producido en findAllDocumentosHechoComunicacion: " + e.getMessage(),
					e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbbandeja> findAllLike(Arbbandeja arbbandeja, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ABID ABID,t1.ABTRID ABTRID,t1.ABFEC ABFEC,t1.ABESTADO ABESTADO,t1.ABFECLIMITE ABFECLIMITE,t1.ABFASE ABFASE,t1.ABNOMDOC ABNOMDOC,t1.ABFECALTA ABFECALTA,t1.ABFECMODIF ABFECMODIF,t1.ABUSUALTA ABUSUALTA,t1.ABUSUMODIF ABUSUMODIF, t1.ABTIPO ABTIPO, t1.ABFECINI ABFECINI,t1.ABTEXTO ABTEXTO,t1.ABTEXTOE ABTEXTOE, "
						+ " t2.SACODIGO SOLARBSACODIGO,t2.SACOJA SOLARBSACOJA,t2.SANRAN SOLARBEXNRAN,t2.SANROR SOLARBEXNROR,t3.UAIDINTERV ARBINTERVUAIDINTERV,t3.UANOMBRE ARBINTERVUANOMBRE,t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2, t3.UANIF ARBINTERVUANIF,t3.UANRTEL ARBINTERVUANRTEL,t3.UANRTEL2 ARBINTERVUANRTEL2,t3.UAPROV_ID ARBINTERVUAPROVID,t3.UAMUN_ID ARBINTERVUAMUNID,t3.UALOC_ID ARBINTERVUALOCID,t3.UACALLE_ID ARBINTERVUACALLEID,t3.UACP_ID ARBINTERVUACPID,t3.UAPORTAL_ID ARBINTERVUAPORTALID,t3.UANOMBRE_PISO ARBINTERVUANOMBREPISO,t3.UADIRE_NOCAPV ARBINTERVUADIRENOCAPV,t3.UADIRE_ANT ARBINTERVUADIREANT,t3.UATIPOINTERV ARBINTERVUATIPOINTERV,t3.UADTCODIGO ARBINTERVUADTCODIGO,t3.UAESCODIGO ARBINTERVUAESCODIGO,t3.UATRFECALTA ARBINTERVUATRFECALTA,t3.UATRFECMODIF ARBINTERVUATRFECMODIF,t3.UATRUSUALTA ARBINTERVUATRUSUALTA,t3.UATRUSUMODIF ARBINTERVUATRUSUMODIF,t3.UAFECALTA ARBINTERVUAFECALTA,t3.UAFECMODIF ARBINTERVUAFECMODIF,t3.UAUSUALTA ARBINTERVUAUSUALTA,t3.UAUSUMODIF ARBINTERVUAUSUMODIF,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE,t4.MOCOOR MONITORMOCOOR,t4.MOCOEM MONITORMOCOEM,t4.MOUSU MONITORMOUSU,t4.MOCLAVE MONITORMOCLAVE,t4.MOFECBAJA MONITORMOFECBAJA,t4.MOADMIN MONITORMOADMIN,t4.MOPRIMERA MONITORMOPRIMERA,t4.ID_PERFILSOLICITUDES MONITORIDPERFILSOLICITUDES,t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE,t4.ID_PERFILINSPECCIONES MONITORIDPERFILINSPECCIONES,t4.ID_PERFILARBITRAJE MONITORIDPERFILARBITRAJE,t4.ID_PERFILORGANIZACION MONITORIDPERFILORGANIZACION,t4.ID_PERFILMAESTROS MONITORIDPERFILMAESTROS,t4.ID_PERFILECONOMICO MONITORIDPERFILECONOMICO,t4.USUARIOXLNET MONITORUSUARIOXLNET,t3.UAEXCODIGO ARBINTERVUAEXCODIGO ");
		query.append("FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,CENSO_MONITOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbbandeja, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND t1.ABUAIDINTERV= t3.UAIDINTERV(+) AND t1.ABULTINSTR= t4.MOCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbbandeja>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbbandeja arbbandeja, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,MONITOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbbandeja, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND t1.ABUAIDINTERV= t3.UAIDINTERV(+) AND t1.ABULTINSTR= t4.MOCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbbandeja entity
	 * 
	 * @param arbbandeja
	 *            Arbbandeja Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbbandeja arbbandeja) {

		StringBuilder where = new StringBuilder(ArbbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbbandeja != null && arbbandeja.getAbid() != null) {
			where.append(" AND t1.ABID = ?");
			params.add(arbbandeja.getAbid());
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSacodigo() != null) {
			where.append(" AND t2.SACODIGO = ?");
			params.add(arbbandeja.getSolarb().getSacodigo());
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSacoja() != null) {
			where.append(" AND t2.SACOJA = ?");
			params.add(arbbandeja.getSolarb().getSacoja());
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSanran() != null) {
			where.append(" AND t2.SANRAN = ?");
			params.add(arbbandeja.getSolarb().getSanran());
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSanror() != null) {
			where.append(" AND t2.SANROR = ?");
			params.add(arbbandeja.getSolarb().getSanror());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(arbbandeja.getArbinterv().getUaidinterv());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getSolarb() != null
				&& arbbandeja.getArbinterv().getSolarb().getSacodigo() != null) {
			where.append(" AND t3.UAEXCODIGO = ?");
			params.add(arbbandeja.getArbinterv().getSolarb().getSacodigo());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUanombre() != null) {
			where.append(" AND t3.UANOMBRE = ?");
			params.add(arbbandeja.getArbinterv().getUanombre());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaapellido1() != null) {
			where.append(" AND t3.UAAPELLIDO1 = ?");
			params.add(arbbandeja.getArbinterv().getUaapellido1());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaapellido2() != null) {
			where.append(" AND t3.UAAPELLIDO2 = ?");
			params.add(arbbandeja.getArbinterv().getUaapellido2());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUanif() != null) {
			where.append(" AND t3.UANIF = ?");
			params.add(arbbandeja.getArbinterv().getUanif());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUanrtel() != null) {
			where.append(" AND t3.UANRTEL = ?");
			params.add(arbbandeja.getArbinterv().getUanrtel());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUanrtel2() != null) {
			where.append(" AND t3.UANRTEL2 = ?");
			params.add(arbbandeja.getArbinterv().getUanrtel2());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaprovId() != null) {
			where.append(" AND t3.UAPROV_ID = ?");
			params.add(arbbandeja.getArbinterv().getUaprovId());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUamunId() != null) {
			where.append(" AND t3.UAMUN_ID = ?");
			params.add(arbbandeja.getArbinterv().getUamunId());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUalocId() != null) {
			where.append(" AND t3.UALOC_ID = ?");
			params.add(arbbandeja.getArbinterv().getUalocId());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUacalleId() != null) {
			where.append(" AND t3.UACALLE_ID = ?");
			params.add(arbbandeja.getArbinterv().getUacalleId());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUacpId() != null) {
			where.append(" AND t3.UACP_ID = ?");
			params.add(arbbandeja.getArbinterv().getUacpId());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaportalId() != null) {
			where.append(" AND t3.UAPORTAL_ID = ?");
			params.add(arbbandeja.getArbinterv().getUaportalId());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUanombrePiso() != null) {
			where.append(" AND t3.UANOMBRE_PISO = ?");
			params.add(arbbandeja.getArbinterv().getUanombrePiso());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUadireNocapv() != null) {
			where.append(" AND t3.UADIRE_NOCAPV = ?");
			params.add(arbbandeja.getArbinterv().getUadireNocapv());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUadireAnt() != null) {
			where.append(" AND t3.UADIRE_ANT = ?");
			params.add(arbbandeja.getArbinterv().getUadireAnt());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatipointerv() != null) {
			where.append(" AND t3.UATIPOINTERV = ?");
			params.add(arbbandeja.getArbinterv().getUatipointerv());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUadtcodigo() != null) {
			where.append(" AND t3.UADTCODIGO = ?");
			params.add(arbbandeja.getArbinterv().getUadtcodigo());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaescodigo() != null) {
			where.append(" AND t3.UAESCODIGO = ?");
			params.add(arbbandeja.getArbinterv().getUaescodigo());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(arbbandeja.getArbinterv().getUatrfecalta());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(arbbandeja.getArbinterv().getUatrfecmodif());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrusualta() != null) {
			where.append(" AND t3.UATRUSUALTA = ?");
			params.add(arbbandeja.getArbinterv().getUatrusualta());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrusumodif() != null) {
			where.append(" AND t3.UATRUSUMODIF = ?");
			params.add(arbbandeja.getArbinterv().getUatrusumodif());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(arbbandeja.getArbinterv().getUafecalta());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(arbbandeja.getArbinterv().getUafecmodif());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUausualta() != null) {
			where.append(" AND t3.UAUSUALTA = ?");
			params.add(arbbandeja.getArbinterv().getUausualta());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUausumodif() != null) {
			where.append(" AND t3.UAUSUMODIF = ?");
			params.add(arbbandeja.getArbinterv().getUausumodif());
		}
		if (arbbandeja != null && arbbandeja.getMonitor() != null && arbbandeja.getMonitor().getMocodigo() != null) {
			where.append(" AND t4.MOCODIGO = ?");
			params.add(arbbandeja.getMonitor().getMocodigo());
		}
		if (arbbandeja != null && arbbandeja.getAbtrid() != null) {
			where.append(" AND t1.ABTRID = ?");
			params.add(arbbandeja.getAbtrid());
		}
		if (arbbandeja != null && arbbandeja.getAbfec() != null) {
			where.append(" AND t1.ABFEC = ?");
			params.add(arbbandeja.getAbfec());
		}
		if (arbbandeja != null && arbbandeja.getAbestado() != null) {
			where.append(" AND t1.ABESTADO = ?");
			params.add(arbbandeja.getAbestado());
		}
		if (arbbandeja != null && arbbandeja.getAbfeclimite() != null) {
			where.append(" AND t1.ABFECLIMITE = ?");
			params.add(arbbandeja.getAbfeclimite());
		}
		if (arbbandeja != null && arbbandeja.getAbfase() != null) {
			where.append(" AND t1.ABFASE = ?");
			params.add(arbbandeja.getAbfase());
		}
		if (arbbandeja != null && arbbandeja.getAbnomdoc() != null) {
			where.append(" AND t1.ABNOMDOC = ?");
			params.add(arbbandeja.getAbnomdoc());
		}
		if (arbbandeja != null && arbbandeja.getAbfecalta() != null) {
			where.append(" AND t1.ABFECALTA = ?");
			params.add(arbbandeja.getAbfecalta());
		}
		if (arbbandeja != null && arbbandeja.getAbfecmodif() != null) {
			where.append(" AND t1.ABFECMODIF = ?");
			params.add(arbbandeja.getAbfecmodif());
		}
		if (arbbandeja != null && arbbandeja.getAbusualta() != null) {
			where.append(" AND t1.ABUSUALTA = ?");
			params.add(arbbandeja.getAbusualta());
		}
		if (arbbandeja != null && arbbandeja.getAbusumodif() != null) {
			where.append(" AND t1.ABUSUMODIF = ?");
			params.add(arbbandeja.getAbusumodif());
		}
		if (arbbandeja != null && arbbandeja.getAbtipo() != null) {
			where.append(" AND t1.ABTIPO = ?");
			params.add(arbbandeja.getAbtipo());
		}
		if (arbbandeja != null && arbbandeja.getAbfecini() != null) {
			where.append(" AND t1.ABFECINI = ?");
			params.add(arbbandeja.getAbfecini());
		}
		if (arbbandeja != null && arbbandeja.getAbtexto() != null) {
			where.append(" AND t1.ABTEXTO = ?");
			params.add(arbbandeja.getAbtexto());
		}
		if (arbbandeja != null && arbbandeja.getAbtextoe() != null) {
			where.append(" AND t1.ABTEXTOE = ?");
			params.add(arbbandeja.getAbtextoe());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbbandeja entity
	 * 
	 * @param arbbandeja
	 *            Arbbandeja Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbbandeja arbbandeja, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArbbandejaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbbandeja != null && arbbandeja.getAbid() != null) {
			where.append(" AND UPPER(t1.ABID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbid().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbid().toUpperCase() + "%");
			}
			where.append(" AND t1.ABID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSacodigo() != null) {
			where.append(" AND t2.SACODIGO = ?");
			params.add(arbbandeja.getSolarb().getSacodigo());
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSacoja() != null) {
			where.append(" AND UPPER(t2.SACOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getSolarb().getSacoja().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getSolarb().getSacoja().toUpperCase() + "%");
			}
			where.append(" AND t2.SACOJA IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSanran() != null) {
			where.append(" AND t2.SANRAN = ?");
			params.add(arbbandeja.getSolarb().getSanran());
		}
		if (arbbandeja != null && arbbandeja.getSolarb() != null && arbbandeja.getSolarb().getSanror() != null) {
			where.append(" AND t2.SANROR = ?");
			params.add(arbbandeja.getSolarb().getSanror());
		}

		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaidinterv() != null) {
			where.append(" AND t3.UAIDINTERV = ?");
			params.add(arbbandeja.getArbinterv().getUaidinterv());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getSolarb() != null
				&& arbbandeja.getArbinterv().getSolarb().getSacodigo() != null) {
			where.append(" AND UPPER(t3.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getSolarb().getSacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getSolarb().getSacodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.UAEXCODIGO IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUanombre() != null) {
			where.append(" AND UPPER(t3.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUanombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUanombre().toUpperCase() + "%");
			}
			where.append(" AND t3.UANOMBRE IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaapellido1() != null) {
			where.append(" AND UPPER(t3.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUaapellido1().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUaapellido1().toUpperCase() + "%");
			}
			where.append(" AND t3.UAAPELLIDO1 IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaapellido2() != null) {
			where.append(" AND UPPER(t3.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUaapellido2().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUaapellido2().toUpperCase() + "%");
			}
			where.append(" AND t3.UAAPELLIDO2 IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUanif() != null) {
			where.append(" AND UPPER(t3.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUanif().toUpperCase() + "%");
			}
			where.append(" AND t3.UANIF IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUanrtel() != null) {
			where.append(" AND UPPER(t3.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUanrtel().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUanrtel().toUpperCase() + "%");
			}
			where.append(" AND t3.UANRTEL IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUanrtel2() != null) {
			where.append(" AND UPPER(t3.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUanrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUanrtel2().toUpperCase() + "%");
			}
			where.append(" AND t3.UANRTEL2 IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaprovId() != null) {
			where.append(" AND UPPER(t3.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUaprovId().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUaprovId().toUpperCase() + "%");
			}
			where.append(" AND t3.UAPROV_ID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUamunId() != null) {
			where.append(" AND UPPER(t3.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUamunId().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUamunId().toUpperCase() + "%");
			}
			where.append(" AND t3.UAMUN_ID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUalocId() != null) {
			where.append(" AND UPPER(t3.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUalocId().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUalocId().toUpperCase() + "%");
			}
			where.append(" AND t3.UALOC_ID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUacalleId() != null) {
			where.append(" AND UPPER(t3.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUacalleId().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUacalleId().toUpperCase() + "%");
			}
			where.append(" AND t3.UACALLE_ID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null && arbbandeja.getArbinterv().getUacpId() != null) {
			where.append(" AND UPPER(t3.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUacpId().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUacpId().toUpperCase() + "%");
			}
			where.append(" AND t3.UACP_ID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaportalId() != null) {
			where.append(" AND UPPER(t3.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUaportalId().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUaportalId().toUpperCase() + "%");
			}
			where.append(" AND t3.UAPORTAL_ID IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUanombrePiso() != null) {
			where.append(" AND UPPER(t3.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUanombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUanombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t3.UANOMBRE_PISO IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUadireNocapv() != null) {
			where.append(" AND UPPER(t3.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUadireNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUadireNocapv().toUpperCase() + "%");
			}
			where.append(" AND t3.UADIRE_NOCAPV IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUadireAnt() != null) {
			where.append(" AND UPPER(t3.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUadireAnt().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUadireAnt().toUpperCase() + "%");
			}
			where.append(" AND t3.UADIRE_ANT IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatipointerv() != null) {
			where.append(" AND UPPER(t3.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUatipointerv().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUatipointerv().toUpperCase() + "%");
			}
			where.append(" AND t3.UATIPOINTERV IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUadtcodigo() != null) {
			where.append(" AND UPPER(t3.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUadtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUadtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.UADTCODIGO IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUaescodigo() != null) {
			where.append(" AND UPPER(t3.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUaescodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUaescodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.UAESCODIGO IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrfecalta() != null) {
			where.append(" AND t3.UATRFECALTA = ?");
			params.add(arbbandeja.getArbinterv().getUatrfecalta());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrfecmodif() != null) {
			where.append(" AND t3.UATRFECMODIF = ?");
			params.add(arbbandeja.getArbinterv().getUatrfecmodif());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrusualta() != null) {
			where.append(" AND UPPER(t3.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUatrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUatrusualta().toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUALTA IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUatrusumodif() != null) {
			where.append(" AND UPPER(t3.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUatrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUatrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t3.UATRUSUMODIF IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUafecalta() != null) {
			where.append(" AND t3.UAFECALTA = ?");
			params.add(arbbandeja.getArbinterv().getUafecalta());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUafecmodif() != null) {
			where.append(" AND t3.UAFECMODIF = ?");
			params.add(arbbandeja.getArbinterv().getUafecmodif());
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUausualta() != null) {
			where.append(" AND UPPER(t3.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUausualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUausualta().toUpperCase() + "%");
			}
			where.append(" AND t3.UAUSUALTA IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getArbinterv() != null
				&& arbbandeja.getArbinterv().getUausumodif() != null) {
			where.append(" AND UPPER(t3.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getArbinterv().getUausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getArbinterv().getUausumodif().toUpperCase() + "%");
			}
			where.append(" AND t3.UAUSUMODIF IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getMonitor() != null && arbbandeja.getMonitor().getMocodigo() != null) {
			where.append(" AND t4.MOCODIGO = ?");
			params.add(arbbandeja.getMonitor().getMocodigo());
		}
		if (arbbandeja != null && arbbandeja.getMonitor() != null && arbbandeja.getMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t4.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getMonitor().getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getMonitor().getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t4.MONOMBRE IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbtrid() != null) {
			where.append(" AND t1.ABTRID = ?");
			params.add(arbbandeja.getAbtrid());
		}
		if (arbbandeja != null && arbbandeja.getAbfec() != null) {
			where.append(" AND t1.ABFEC = ?");
			params.add(arbbandeja.getAbfec());
		}
		if (arbbandeja != null && arbbandeja.getAbestado() != null) {
			where.append(" AND UPPER(t1.ABESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbestado().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbestado().toUpperCase() + "%");
			}
			where.append(" AND t1.ABESTADO IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbfeclimite() != null) {
			where.append(" AND t1.ABFECLIMITE = ?");
			params.add(arbbandeja.getAbfeclimite());
		}
		if (arbbandeja != null && arbbandeja.getAbfase() != null) {
			where.append(" AND UPPER(t1.ABFASE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbfase().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbfase().toUpperCase() + "%");
			}
			where.append(" AND t1.ABFASE IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbnomdoc() != null) {
			where.append(" AND UPPER(t1.ABNOMDOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbnomdoc().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbnomdoc().toUpperCase() + "%");
			}
			where.append(" AND t1.ABNOMDOC IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbfecalta() != null) {
			where.append(" AND t1.ABFECALTA = ?");
			params.add(arbbandeja.getAbfecalta());
		}
		if (arbbandeja != null && arbbandeja.getAbfecmodif() != null) {
			where.append(" AND t1.ABFECMODIF = ?");
			params.add(arbbandeja.getAbfecmodif());
		}
		if (arbbandeja != null && arbbandeja.getAbusualta() != null) {
			where.append(" AND UPPER(t1.ABUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.ABUSUALTA IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbusumodif() != null) {
			where.append(" AND UPPER(t1.ABUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.ABUSUMODIF IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbtipo() != null) {
			where.append(" AND t1.ABTIPO = ?");
			params.add(arbbandeja.getAbtipo());
		}
		if (arbbandeja != null && arbbandeja.getAbfecini() != null) {
			where.append(" AND t1.ABFECINI = ?");
			params.add(arbbandeja.getAbfecini());
		}
		if (arbbandeja != null && arbbandeja.getAbtexto() != null) {
			where.append(" AND UPPER(t1.ABTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbtexto().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbtexto().toUpperCase() + "%");
			}
			where.append(" AND t1.ABTEXTO IS NOT NULL");
		}
		if (arbbandeja != null && arbbandeja.getAbtextoe() != null) {
			where.append(" AND UPPER(t1.ABTEXTOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbbandeja.getAbtextoe().toUpperCase() + "%");
			} else {
				params.add("%" + arbbandeja.getAbtextoe().toUpperCase() + "%");
			}
			where.append(" AND t1.ABTEXTOE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue() {
		String query = "SELECT L21U3Q00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		return this.jdbcTemplate.queryForInt(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public List<Arbbandeja> dameBandeja(Arbbandeja arbbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		StringBuilder queryNueva = new StringBuilder("");
		StringBuilder query1 = new StringBuilder(
				"SELECT  t1.ABID ABID,t1.ABTRID ABTRID,t1.ABFEC ABFEC,t1.ABESTADO ABESTADO,t1.ABFECLIMITE ABFECLIMITE,t1.ABFASE ABFASE,t1.ABNOMDOC ABNOMDOC,t1.ABFECALTA ABFECALTA,t1.ABFECMODIF ABFECMODIF,t1.ABUSUALTA ABUSUALTA,t1.ABUSUMODIF ABUSUMODIF, t1.ABTIPO ABTIPO, t1.ABFECINI ABFECINI,t1.ABTEXTO ABTEXTO,t1.ABTEXTOE ABTEXTOE "
						+ " ,t2.SACODIGO SOLARBSACODIGO, t2.SACOJA SOLARBSACOJA,t2.SANRAN SOLARBEXNRAN,t2.SANROR SOLARBEXNROR, LPAD(T2.SANROR,12,'0') CORRELATIVOPAD, t2.SACOJA || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANRAN CODCOMPLETO "
						+ " ,t3.UAIDINTERV ARBINTERVUAIDINTERV,t3.UANOMBRE ARBINTERVUANOMBRE,t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2"
						+ " ,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE "
						+ ",T5.TRNOMTRAMES ARBTRAMEXPTRNOMTRAMES, t5.TRCODIGO ARBTRAMEXPTRCODIGO, t5.TRFECHAENVIOBOPVBOE ARBTRAMEXPTRFECHAENVIOBOPVBOE, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE, t5.TRFECINI TRFECINI, t5.TRFECFIN TRFECFIN "
						+ ", (SELECT count(t12.TRID) FROM ARBTRAMEXP t12 WHERE t12.TREXCODIGO=T1.ABSACODIGO AND t12.TRESTADO!='T') TRAMITESPENDIENTES, "
						+ " (SELECT count(t13.ABID) FROM ARBBANDEJA t13 WHERE t13.ABSACODIGO=T1.ABSACODIGO AND ABTIPO IS NOT NULL AND ((SYSDATE > ABFECINI AND ABFECLIMITE IS NOT NULL AND ABFECINI <= ABFECLIMITE))) AVISOS "
						+ ",t5.TRRESOTIPO,t5.TRRESULTADO, t5.TRESTADOACUSE, t9.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t9.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU "
						+ ",t5.TRISTELEMATICA TRISTELEMATICA "
						+ ",t10.UANOMBRE||' '||nvl(t10.UAAPELLIDO1,'')||' '||nvl(t10.UAAPELLIDO2,'') SOLARBDTNOMBRE ");
		query1.append(
				"FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,CENSO_MONITOR t4, ARBTRAMEXP t5, FASE t6, TRAMITE t7, ARBEXP t8, ENVIOS_POR_REMESA t9, ARBINTERV t10 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				// " WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND T2.SACODIGO
				// = T3.UAEXCODIGO AND t2.SACOSES = t3.UAESCODIGO AND
				// t3.UATIPOINTERV='E' AND t1.ABULTINSTR= t4.MOCODIGO(+) AND
				// t1.ABTRID = t5.TRID(+) AND t1.ABFASE = t6.FCODIGO(+) AND
				// t5.TRCODIGO = t7.TRCODIGO(+) AND ABTIPO IS NULL AND
				// T2.SACODIGO = T8.EXCODIGO(+) AND to_char(t5.TRTRIDREL) =
				// t9.EHCODIGO(+) ");
				" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND T2.SACODIGO = T3.UAEXCODIGO AND t3.UATIPOINTERV='"
						+ Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO
						+ "' AND T2.SACODIGO = T10.UAEXCODIGO AND t10.UATIPOINTERV='"
						+ Y41bConstantes.TIPO_INTERVINIENTE_INTERESADO
						+ "' AND t8.EXMOCODIGO= t4.MOCODIGO(+) AND t1.ABTRID = t5.TRID(+) AND t1.ABFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO(+) AND ABTIPO IS NULL AND T2.SACODIGO = T8.EXCODIGO(+)  AND to_char(t5.TRTRIDREL) = t9.EHCODIGO(+)  ");
		// ultimo tramite pendiente o tramitado
		where.append(
				" AND t1.ABFEC = (SELECT MIN(t11.ABFEC) FROM ARBBANDEJA t11 WHERE t11.ABSACODIGO=t1.ABSACODIGO AND t11.ABTIPO IS NULL) ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder wherePerfil = new StringBuilder("");

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(
					" AND (EXISTS (SELECT 1 FROM ARBTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.ABSACODIGO AND AUX.TRESTADO NOT IN ('"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND AUX.TRCODIGO=?");
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE);
			where.append(") OR ( 1=1 ");
		}

		if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) {
			/* ve todo */
			wherePerfil.append(" AND 1 = 1 ");
		} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
			wherePerfil
					// .append(" AND (T1.ABULTINSTR =? OR t8.EXMOCODIGO = ?) AND
					// T8.EXCOORACTUAL = ? ");
					.append(" AND (T1.ABULTINSTR =? OR t8.EXMOCODIGO = ?)");
			params.add(arbbandeja.getMonitor().getMocodigo());
			params.add(arbbandeja.getMonitor().getMocodigo());
			// params.add(arbbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
			// wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
			// params.add(arbbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
			// EL ADMINISTRATIVO EN SU BANDEJA VE LAS NOTIFICACIONES
			// COMUNICACIONES Y ACUSES QUE ESTEN PENDIENTES DE TRAMITAR DE SU
			// OFICINA
			wherePerfil
					.append(" AND EXISTS(SELECT 1 FROM ARBTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.ABSACODIGO AND AUX.TRESTADO <> '"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "' AND (AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO + "' )) ");
			// wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
			// params.add(arbbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else if (Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else {
			wherePerfil.append(" AND T1.ABULTINSTR = ? ");
			params.add(arbbandeja.getMonitor().getMocodigo());
		}

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			wherePerfil.append(" )) ");
		}

		// EVOLUTIVO 0134898 2.11
		if (arbbandeja.getTrFechaDesde() != null && arbbandeja.getUltimoTramiteAsigRes() == null
				&& !arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(" AND T1.ABFEC >= ? ");
			params.add(arbbandeja.getTrFechaDesde());
		}

		if (arbbandeja.getTrFechaHasta() != null && arbbandeja.getUltimoTramiteAsigRes() == null
				&& !arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(" AND T1.ABFEC <= ? ");
			params.add(arbbandeja.getTrFechaHasta());
		}

		if (arbbandeja.getTrcodigo() != null && arbbandeja.getUltimoTramiteAsigRes() == null
				&& !arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(
					" AND EXISTS ( SELECT 1 FROM ARBBANDEJA t15, ARBTRAMEXP t16 WHERE t15.ABSACODIGO = t1.ABSACODIGO AND t15.ABTRID = t16.TRID(+) AND t15.ABTIPO IS NULL AND t16.TRCODIGO = ? AND t15.ABESTADO <> ?)");
			params.add(arbbandeja.getTrcodigo());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		}
		if (arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(
					" AND EXISTS ( SELECT 1 FROM ARBTRAMEXP t17 WHERE t1.ABSACODIGO = t17.TREXCODIGO AND t17.TRCODIGO = ? AND t17.TRESTADO = ?)");
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO);
			params.add(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
		}
		if (arbbandeja.getMocodigo() != null) {
			wherePerfil.append(" AND t4.MOCODIGO = ? ");
			params.add(arbbandeja.getMocodigo());
		}
		// EVOLUTIVO 0134898 2.11

		// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevosexpedientes
		// que el ultimo tramite sea Asignacion de responsable tramitado

		// si clickas nuevos inhabilitar los filtros de arriba
		if (arbbandeja.getUltimoTramiteAsigRes() != null) {

			wherePerfil.append(
					" AND (( t5.TRID= ( SELECT B0.TRID FROM ARBTRAMEXP B0, ( SELECT TREXCODIGO, MAX(TRFECFIN) AS MAXFECHA FROM ARBTRAMEXP WHERE UPPER(TRCODIGO)=? AND UPPER(TRESTADO)=? GROUP BY TREXCODIGO ) TRAMITE WHERE B0.TRCODIGO=? AND B0.TRESTADO=? AND B0.TRFECFIN=TRAMITE.MAXFECHA AND B0.TREXCODIGO = TRAMITE.TREXCODIGO AND B0.TREXCODIGO=t5.TREXCODIGO )");

			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE);
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE);
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			wherePerfil.append(
					" ) OR(NOT EXISTS ( SELECT B2.TRID FROM ARBTRAMEXP B2 WHERE B2.TRESTADO=? AND B2.TREXCODIGO=T2.SACODIGO AND B2.TRMOCODIGOEJ = t4.MOCODIGO )))");
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		}

		where.append(wherePerfil);
		query1.append(where);

		queryNueva.append(query1);

		if (pagination != null && pagination.getSort() != null) {
			queryNueva = pagination.getPaginationQuery(queryNueva);
		}

		return (List<Arbbandeja>) this.jdbcTemplate.query(queryNueva.toString(), this.rwMapBandejaArbitrajes,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaCount(Arbbandeja arbbandeja, CensoMonitor censoMonitor, String perfil) {

		StringBuilder query1 = new StringBuilder("SELECT COUNT (ABID) ");
		query1.append("FROM ARBBANDEJA t1 , SOLARB t2, ARBINTERV t3 , ARBTRAMEXP t5,  ARBEXP t8, CENSO_MONITOR t4 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				// " WHERE 1=1 AND t1.ABTRID = t5.TRID(+) AND t1.ABSACODIGO=
				// t2.SACODIGO(+) AND t2.SACODIGO = t3.UAEXCODIGO AND t2.SACOSES
				// = t3.UAESCODIGO AND t3.UATIPOINTERV='E' AND ABTIPO IS NULL
				// AND T1.ABSACODIGO = T8.EXCODIGO(+) ");
				" WHERE 1=1 AND t1.ABTRID = t5.TRID(+) AND t1.ABSACODIGO= t2.SACODIGO(+) AND t2.SACODIGO = t3.UAEXCODIGO AND t3.UATIPOINTERV='E'  AND ABTIPO IS NULL AND T1.ABSACODIGO = T8.EXCODIGO(+)  AND  t8.EXMOCODIGO= t4.MOCODIGO(+)  ");
		// ultimo tramite pendiente o tramitado
		where.append(
				" AND t1.ABFEC = (SELECT MIN(t11.ABFEC) FROM ARBBANDEJA t11 WHERE t11.ABSACODIGO=t1.ABSACODIGO AND t11.ABTIPO IS NULL) ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder wherePerfil = new StringBuilder("");

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			where.append(
					" AND (EXISTS (SELECT 1 FROM ARBTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.ABSACODIGO AND AUX.TRESTADO NOT IN ('"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "') AND AUX.TRCODIGO=?");
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_PUBLICACION_BOPVBOE);
			where.append(") OR ( 1=1 ");
		}
		if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil)) {
			/* ve todo */
			wherePerfil.append(" AND 1 = 1");
		} else if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)) {
			wherePerfil
					// .append(" AND (T1.ABULTINSTR = ? OR T8.EXMOCODIGO = ?)
					// AND T8.EXCOORACTUAL = ?");
					.append(" AND (T1.ABULTINSTR = ? OR T8.EXMOCODIGO = ?)");
			params.add(arbbandeja.getMonitor().getMocodigo());
			params.add(arbbandeja.getMonitor().getMocodigo());
			// params.add(arbbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)) {
			// wherePerfil.append(" AND T8.EXCOORACTUAL = ?");
			// params.add(arbbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_ADMINISTRATIVO.equals(perfil)) {
			// EL ADMINISTRATIVO EN SU BANDEJA VE LAS NOTIFICACIONES
			// COMUNICACIONES Y ACUSES QUE ESTEN PENDIENTES DE TRAMITAR DE SU
			// OFICINA
			wherePerfil
					.append(" AND EXISTS(SELECT 1 FROM ARBTRAMEXP AUX WHERE AUX.TREXCODIGO=T1.ABSACODIGO AND AUX.TRESTADO <> '"
							+ Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "' AND (AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_COMUNICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_NOTIFICACION + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_ELABORACION_BOPVBOE + "' OR AUX.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO + "' )) ");
			// wherePerfil.append(" AND T8.EXCOORACTUAL = ? ");
			// params.add(arbbandeja.getMonitor().getOrganismo().getCodOrg());
		} else if (Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else if (Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			wherePerfil.append(" AND 1 = 0 ");
		} else {
			wherePerfil.append(" AND T1.ABULTINSTR = ?");
			params.add(arbbandeja.getMonitor().getMocodigo());
		}

		if (censoMonitor.getMobopvboe() != null && censoMonitor.getMobopvboe().equals(Y41bConstantes.SI)) {
			wherePerfil.append(" )) ");
		}

		// EVOLUTIVO 0134898 2.11
		if (arbbandeja.getTrFechaDesde() != null && arbbandeja.getUltimoTramiteAsigRes() == null
				&& !arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(" AND ")

					.append("T1.ABFEC>= to_date ('")
					.append(Y41bUtils.parseDateToString(arbbandeja.getTrFechaDesde(), Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (arbbandeja.getTrFechaHasta() != null && arbbandeja.getUltimoTramiteAsigRes() == null
				&& !arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(" AND ")

					.append("T1.ABFEC<= to_date ('")
					.append(Y41bUtils.parseDateToString(arbbandeja.getTrFechaHasta(), Y41bConstantes.EUSKERA))
					.append("', 'YYYY/MM/DD')");
		}

		if (arbbandeja.getTrcodigo() != null && arbbandeja.getUltimoTramiteAsigRes() == null
				&& !arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil.append(" AND (").append("T5.TRCODIGO='").append(arbbandeja.getTrcodigo()).append("' AND")
					.append(" T5.TRESTADO <> '" + Y41bConstantes.ESTADO_TRAMITE_TRAMITADO + "'  )");
		}
		if (arbbandeja.getLaudoPendienteFirma()) {
			wherePerfil
					.append(" AND EXISTS ( SELECT 1 FROM ARBTRAMEXP t17 WHERE t1.ABSACODIGO = t17.TREXCODIGO AND t17.TRCODIGO = '"
							+ Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO + "' AND t17.TRESTADO = '"
							+ Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA + "')");
		}
		if (arbbandeja.getMocodigo() != null) {
			wherePerfil.append(" AND t4.MOCODIGO = '").append(arbbandeja.getMocodigo()).append("'");
		}
		// EVOLUTIVO 0134898 2.11

		// EVOLUTIVO 0159047: Bandeja de arbitraje. Control de nuevosexpedientes
		// que el ultimo tramite sea Asignacion de responsable tramitado

		// si clickas nuevos inhabilitar los filtros de arriba
		if (arbbandeja.getUltimoTramiteAsigRes() != null) {

			wherePerfil.append(
					" AND (( t5.TRID= ( SELECT B0.TRID FROM ARBTRAMEXP B0, ( SELECT TREXCODIGO, MAX(TRFECFIN) AS MAXFECHA FROM ARBTRAMEXP WHERE UPPER(TRCODIGO)=? AND UPPER(TRESTADO)=? GROUP BY TREXCODIGO ) TRAMITE WHERE B0.TRCODIGO=? AND B0.TRESTADO=? AND B0.TRFECFIN=TRAMITE.MAXFECHA AND B0.TREXCODIGO = TRAMITE.TREXCODIGO AND B0.TREXCODIGO=t5.TREXCODIGO )");

			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE);
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			params.add(Y41bConstantes.TRAMITE_ARBITRAJE_ASIGNACION_RESPONSABLE);
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			wherePerfil.append(
					" ) OR(NOT EXISTS ( SELECT B2.TRID FROM ARBTRAMEXP B2 WHERE B2.TRESTADO=? AND B2.TREXCODIGO=T2.SACODIGO AND B2.TRMOCODIGOEJ = t4.MOCODIGO )))");
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		}

		where.append(wherePerfil);
		query1.append(where);

		Long numeroRegistros1 = this.jdbcTemplate.queryForLong(query1.toString(), params.toArray());

		return numeroRegistros1;
	}

	/**
	 * Aniade aviso bandeja apertura solarbte.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	// public void aniadeAvisoBandejaMeses(Solarb solarb,
	// CensoMonitor censoMonitor, Long numeroMeses, String textoc,
	// String textoe, BigDecimal idTramite, Date fechaDesde, String batipo) {
	//
	// logger.info("ArbbandejaDaoImpl - aniadeAvisoBandejaMeses - Inicio "
	// + batipo);
	//
	// Arbbandeja arbbandeja = new Arbbandeja();
	// arbbandeja.setSolarb(solarb);
	// /* conseguimos el letrado del solarbte */
	// arbbandeja.setMonitor(censoMonitor);
	// arbbandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
	// /* Fecha de hoy */
	//
	// arbbandeja.setAbfecini(fechaDesde);
	// arbbandeja.setAbtexto(textoc);
	// arbbandeja.setAbtextoe(textoe);
	// arbbandeja.setAbtrid(idTramite);
	// Date fechaLimite = Y41bUtils.addMonth(fechaDesde,
	// Integer.parseInt(numeroMeses.toString()));
	// Date fechaEmpezarPitar = Y41bUtils.addDays(fechaLimite, (-1)
	// * Y41bConstantes.TIPO_AVISO_ARBITRAJE_NUMERODIASANTES);
	// arbbandeja.setAbtipo(batipo);
	// arbbandeja.setAbfecini(fechaEmpezarPitar);
	// arbbandeja.setAbfeclimite(fechaLimite);
	// logger.info("ArbbandejaDaoImpl - aniadeAvisoBandejaMeses - Fin ");
	// this.add(arbbandeja);
	// }

	/**
	 * Aniade aviso bandeja apertura solarbte.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	public void aniadeAvisoBandejaDias(Solarb solarb, CensoMonitor censoMonitor, Long numeroMeses, String textoc,
			String textoe, String idTramite, Date fechaDesde, String batipo) {
		ArbbandejaDaoImpl.LOGGER.info("ArbbandejaDaoImpl - aniadeAvisoBandejaDias - Inicio " + batipo);
		// Antes de crear aviso, borramos
		Arbbandeja aviso = new Arbbandeja();
		aviso.setSolarb(new Solarb(solarb.getSacodigo()));
		aviso.setAbtipo(batipo);
		List<Arbbandeja> lavisos = this.findAll(aviso, null);
		if (lavisos != null) {
			for (int i = 0; i < lavisos.size(); i++) {
				this.remove(lavisos.get(i));
			}
		}
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setSolarb(solarb);
		/* conseguimos el letrado del solarbte */
		arbbandeja.setMonitor(censoMonitor);
		arbbandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);

		arbbandeja.setAbtexto(textoc);
		arbbandeja.setAbtextoe(textoe);
		arbbandeja.setAbtrid(idTramite.toString());
		Date fechaLimite = Y41bUtils.addDays(fechaDesde, Integer.parseInt(numeroMeses.toString()));
		Date fechaEmpezarPitar = Y41bUtils.addDays(fechaLimite,
				(-1) * Y41bConstantes.TIPO_AVISO_ARBITRAJE_NUMERODIASANTES);
		ArbbandejaDaoImpl.LOGGER.info("ArbbandejaDaoImpl - aniadeAvisoBandejaDias - Insertado aviso. Desde: "
				+ fechaEmpezarPitar.toString() + " . Hasta: " + fechaLimite);

		arbbandeja.setAbtipo(batipo);
		// La fecha de inicio es diferente segun el aviso tenga un periodo de
		// validez hasta la fecha limite
		// o a partir de la fecha limite
		if (Y41bConstantes.TIPO_AVISO_ARBITRAJE_CONVENIO.equals(batipo)
				|| Y41bConstantes.TIPO_AVISO_ARBITRAJE_LAUDO_RESO.equals(batipo)
				|| Y41bConstantes.TIPO_AVISO_ARBITRAJE_ACEPTACION_ARBITRAJE.equals(batipo)
				|| Y41bConstantes.TIPO_AVISO_ARBITRAJE_ADMISION.equals(batipo)) {
			arbbandeja.setAbfecini(fechaEmpezarPitar);
		} else {
			arbbandeja.setAbfecini(fechaDesde);
		}
		// --------------------------------------------

		arbbandeja.setAbfeclimite(fechaLimite);
		ArbbandejaDaoImpl.LOGGER.info("ArbbandejaDaoImpl - aniadeAvisoBandejaDias - Fin ");
		this.add(arbbandeja);
	}

	/**
	 * Removes a single row in the Arbbandeja table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 */
	public void removeAllEntradas(String excodigo) {
		String query = "DELETE FROM ARBBANDEJA WHERE ABSACODIGO=?";
		ArbbandejaDaoImpl.LOGGER.info("ArbbandejaDaoImpl - *** Remove - Elimino removeAllEntradas " + excodigo);
		this.jdbcTemplate.update(query, excodigo);
	}

	/**
	 * Crea tramite apertura bandeja.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 */
	public void creaTramiteAperturaBandeja(Arbtramexp arbtramexp) {
		Arbbandeja arbbandeja = new Arbbandeja();
		arbbandeja.setSolarb(arbtramexp.getSolarb());
		arbbandeja.setMonitor(arbtramexp.getCensoMonitorEj());
		arbbandeja.setAbtrid(arbtramexp.getTrid());
		arbbandeja.setAbestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		arbbandeja.setAbfec(arbtramexp.getTrfecini());
		arbbandeja.setAbfase(arbtramexp.getFase().getFcodigo());
		this.add(arbbandeja);
	}

	/**
	 * Updates a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Pagination
	 * @return Arbbandeja
	 */
	public Arbbandeja updateCensoMonitorNoTramitados(Arbbandeja arbbandeja) {
		String query = "UPDATE ARBBANDEJA SET ABULTINSTR=? WHERE ABSACODIGO=? AND ABESTADO!='T'";
		Object getMonitorMocodigoAux = null;
		if (arbbandeja.getMonitor() != null && arbbandeja.getMonitor().getMocodigo() != null) {
			getMonitorMocodigoAux = arbbandeja.getMonitor().getMocodigo();
		}
		this.jdbcTemplate.update(query, getMonitorMocodigoAux, arbbandeja.getSolarb().getSacodigo());
		return arbbandeja;
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public List<Arbbandeja> dameBandejaTP(Arbbandeja arbbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		StringBuilder queryNueva = new StringBuilder("");
		StringBuilder query1 = new StringBuilder(
				"SELECT  t1.ABID ABID,t1.ABTRID ABTRID,t1.ABFEC ABFEC,t1.ABESTADO ABESTADO,t1.ABFECLIMITE ABFECLIMITE,t1.ABFASE ABFASE,t1.ABNOMDOC ABNOMDOC,t1.ABFECALTA ABFECALTA,t1.ABFECMODIF ABFECMODIF,t1.ABUSUALTA ABUSUALTA,t1.ABUSUMODIF ABUSUMODIF, t1.ABTIPO ABTIPO, t1.ABFECINI ABFECINI,t1.ABTEXTO ABTEXTO,t1.ABTEXTOE ABTEXTOE "
						+ " ,t2.SACODIGO SOLARBSACODIGO, t2.SACOJA SOLARBSACOJA,t2.SANRAN SOLARBEXNRAN,t2.SANROR SOLARBEXNROR, LPAD(T2.SANROR,12,'0') CORRELATIVOPAD, t2.SACOJA || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANRAN CODCOMPLETO "
						+ " ,t3.UAIDINTERV ARBINTERVUAIDINTERV,t3.UANOMBRE ARBINTERVUANOMBRE,t3.UAAPELLIDO1 ARBINTERVUAAPELLIDO1,t3.UAAPELLIDO2 ARBINTERVUAAPELLIDO2"
						+ " ,t4.MOCODIGO MONITORMOCODIGO,t4.MONOMBRE MONITORMONOMBRE "
						+ ",T5.TRNOMTRAMES ARBTRAMEXPTRNOMTRAMES, t5.TRCODIGO ARBTRAMEXPTRCODIGO, t5.TRFECHAENVIOBOPVBOE ARBTRAMEXPTRFECHAENVIOBOPVBOE, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE, t5.TRFECINI TRFECINI, t5.TRFECFIN TRFECFIN , t5.TRRESOTIPO,t5.TRRESULTADO , t5.TRESTADOACUSE TRESTADOACUSE, t9.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t9.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU "
						+ ", t5.TRISTELEMATICA TRISTELEMATICA"
						+ ", '' SOLARBDTNOMBRE, 0 TRAMITESPENDIENTES, 0 AVISOS ");
		query1.append(
				"FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,CENSO_MONITOR t4, ARBTRAMEXP t5, FASE t6, TRAMITE t7, ARBEXP t8, ENVIOS_POR_REMESA t9 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND T2.SACODIGO = T3.UAEXCODIGO AND t3.UATIPOINTERV='E' AND t1.ABULTINSTR= t4.MOCODIGO(+) AND t1.ABTRID = t5.TRID(+) AND t1.ABFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO AND ABTIPO IS NULL AND T2.SACODIGO = T8.EXCODIGO AND T5.TRESTADO!='T'  AND to_char(t5.TRTRIDREL)  = t9.EHCODIGO(+)  ");

		List<Object> params = new ArrayList<Object>();

		where.append("AND t1.ABSACODIGO=? ");
		params.add(arbbandeja.getSolarb().getSacodigo());

		query1.append(where);

		queryNueva.append(query1);

		if (pagination != null && pagination.getSort() != null) {
			queryNueva = pagination.getPaginationQuery(queryNueva);
		}

		return (List<Arbbandeja>) this.jdbcTemplate.query(queryNueva.toString(), this.rwMapBandejaArbitrajes,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaTPCount(Arbbandeja arbbandeja, CensoMonitor censoMonitor, String perfil) {

		StringBuilder query1 = new StringBuilder("SELECT COUNT (ABID) ");
		query1.append(
				"FROM ARBBANDEJA t1 ,SOLARB t2 ,ARBINTERV t3 ,CENSO_MONITOR t4, ARBTRAMEXP t5, FASE t6, TRAMITE t7, ARBEXP t8, ENVIOS_POR_REMESA t9  ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ABSACODIGO= t2.SACODIGO(+) AND T2.SACODIGO = T3.UAEXCODIGO AND t3.UATIPOINTERV='E' AND t1.ABULTINSTR= t4.MOCODIGO(+) AND t1.ABTRID = t5.TRID(+) AND t1.ABFASE = t6.FCODIGO(+) AND t5.TRCODIGO = t7.TRCODIGO AND ABTIPO IS NULL AND T2.SACODIGO = T8.EXCODIGO  AND to_char(t5.TRTRIDREL)  = t9.EHCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.ABSACODIGO=? ");
		params.add(arbbandeja.getSolarb().getSacodigo());

		query1.append(where);

		return this.jdbcTemplate.queryForLong(query1.toString(), params.toArray());

	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public List<Arbbandeja> dameBandejaAvisos(Arbbandeja arbbandeja, Pagination pagination, CensoMonitor censoMonitor,
			String perfil) {
		StringBuilder queryNueva = new StringBuilder("");

		// sacamos los avisos que estan apunto de terminar tambien
		StringBuilder queryAvisos = new StringBuilder(
				"SELECT  t1.ABID ABID,t1.ABTRID ABTRID,t1.ABFEC ABFEC,t1.ABESTADO ABESTADO,t1.ABFECLIMITE ABFECLIMITE,t1.ABFASE ABFASE,t1.ABNOMDOC ABNOMDOC,t1.ABFECALTA ABFECALTA,t1.ABFECMODIF ABFECMODIF,t1.ABUSUALTA ABUSUALTA,t1.ABUSUMODIF ABUSUMODIF, t1.ABTIPO ABTIPO, t1.ABFECINI ABFECINI, t1.ABTEXTO ABTEXTO, t1.ABTEXTOE ABTEXTOE, t8.TRISTELEMATICA TRISTELEMATICA "
						+ " ,t2.SACODIGO SOLARBSACODIGO, t2.SACOJA SOLARBSACOJA,t2.SANRAN SOLARBEXNRAN,t2.SANROR SOLARBEXNROR,LPAD(T2.SANROR,12,'0') CORRELATIVOPAD, t2.SACOJA || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANROR || '"
						+ Y41bConstantes.SEPARADOR_COD_COMPLETO_EXP + "' || t2.SANRAN CODCOMPLETO "
						+ " ,0 ARBINTERVUAIDINTERV,'' ARBINTERVUANOMBRE,'' ARBINTERVUAAPELLIDO1,'' ARBINTERVUAAPELLIDO2"
						+ " ,'' MONITORMOCODIGO,'' MONITORMONOMBRE "
						+ ", '' ARBTRAMEXPTRNOMTRAMES, '' ARBTRAMEXPTRCODIGO, null ARBTRAMEXPTRFECHAENVIOBOPVBOE, T6.FNOMBRE FASEFNOMBRE, T6.FNOMBREE FASEFNOMBREE, "
						+ " t7.TRNOMBRE TRNOMBRE, t7.TRNOMBREE TRNOMBREE, null TRFECINI, null TRFECFIN, 0 TRAMITESPENDIENTES, 0 AVISOS "
						+ ", '' TRESTADOACUSE,'' TRRESOTIPO, '' TRRESULTADO, '' ENVCDESSITCORREOSES, '' ENVCDESSITCORREOSEU, '' SOLARBDTNOMBRE "
						+ " FROM ARBBANDEJA T1 , SOLARB T2, ARBEXP T3, FASE t6, TRAMITE t7, ARBTRAMEXP t8 "
						+ " WHERE 1=1 AND T1.ABSACODIGO=T2.SACODIGO(+) AND T2.SACODIGO=T3.EXCODIGO(+) AND ((SYSDATE > ABFECINI AND ABFECLIMITE IS NOT NULL AND ABFECINI <= ABFECLIMITE)) AND ABTIPO IS NOT NULL "
						+ " AND T3.EXFCODIGO = t6.FCODIGO(+) AND T1.ABTRID=t8.TRID(+) AND T1.ABSACODIGO=T8.TREXCODIGO(+) AND T8.TRCODIGO=t7.TRCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();
		queryAvisos.append("AND t1.ABSACODIGO=? ");
		params.add(arbbandeja.getSolarb().getSacodigo());

		queryNueva.append(queryAvisos);

		if (pagination != null && pagination.getSort() != null) {
			queryNueva = pagination.getPaginationQuery(queryNueva);
		}

		return (List<Arbbandeja>) this.jdbcTemplate.query(queryNueva.toString(), this.rwMapBandejaArbitrajes,
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaAvisosCount(Arbbandeja arbbandeja, CensoMonitor censoMonitor, String perfil) {

		// sacamos los avisos que estan apunto de terminar tambien
		StringBuilder queryAvisos = new StringBuilder("SELECT COUNT (ABID)"
				+ " FROM ARBBANDEJA T1 , SOLARB T2, ARBEXP T3, FASE t6, TRAMITE t7, ARBTRAMEXP t8 "
				+ " WHERE 1=1 AND T1.ABSACODIGO= T2.SACODIGO(+) AND T2.SACODIGO=T3.EXCODIGO(+) AND ((SYSDATE > ABFECINI AND ABFECLIMITE IS NOT NULL AND ABFECINI <= ABFECLIMITE)) AND ABTIPO IS NOT NULL "
				+ " AND T3.EXFCODIGO = t6.FCODIGO(+) AND T1.ABTRID=t8.TRID(+) AND T1.ABSACODIGO=T8.TREXCODIGO(+) AND T8.TRCODIGO=t7.TRCODIGO(+) ");

		List<Object> params = new ArrayList<Object>();
		queryAvisos.append(" AND t1.ABSACODIGO=? ");
		params.add(arbbandeja.getSolarb().getSacodigo());

		return this.jdbcTemplate.queryForLong(queryAvisos.toString(), params.toArray());

	}
}
