package com.ejie.y41b.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Solarb;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbtramexp;

/**
 * ArbbandejaDao  
 * 
 *  
 */

public interface ArbbandejaDao {

	/**
	 * Inserts a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja add(Arbbandeja arbbandeja);

	/**
	 * Updates a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja update(Arbbandeja arbbandeja);

	/**
	 * Finds a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja find(Arbbandeja arbbandeja);

	/**
	 * Deletes a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return
	 */
	void remove(Arbbandeja arbbandeja);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbbandeja> findAll(Arbbandeja arbbandeja, Pagination pagination);

	/**
	 * Counts rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Long
	 */
	Long findAllCount(Arbbandeja arbbandeja);

	/**
	 * Finds rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbbandeja> findAllLike(Arbbandeja arbbandeja, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbbandeja table using like.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbbandeja arbbandeja, Boolean startsWith);

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public Integer currentValue();

	/**
	 * Finds a single row in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Pagination
	 * 
	 */

	public void deleteBandejaPorExpediente(Arbbandeja arbbandeja);

	/**
	 * Borra los avisos caducados de la bandeja de sancionadores
	 */
	public void deleteBandejaAvisosCaducados();

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	List<Arbbandeja> dameBandeja(Arbbandeja arbbandeja, Pagination pagination,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaCount(Arbbandeja arbbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Aniade aviso bandeja apertura solarbte.
	 * 
	 * @param solarb
	 *            the solarb
	 * @param censoMonitor
	 *            the censo monitor
	 * @param numeroMeses
	 *            the numero meses
	 * @param textoc
	 *            the textoc
	 * @param textoe
	 *            the textoe
	 * @param idTramite
	 *            the id tramite
	 * @param fechaDesde
	 *            the fecha desde
	 * @param batipo
	 *            the batipo
	 */
	public void aniadeAvisoBandejaDias(Solarb solarb,
			CensoMonitor censoMonitor, Long numeroMeses, String textoc,
			String textoe, String idTramite, Date fechaDesde, String batipo);

	/**
	 * Removes a single row in the Arbbandeja table.
	 * 
	 * @param excodigo
	 *            the excodigo
	 */
	public void removeAllEntradas(String excodigo);

	/**
	 * Crea tramite apertura bandeja.
	 * 
	 * @param arbtramexp
	 *            the arbtramexp
	 */
	public void creaTramiteAperturaBandeja(Arbtramexp arbtramexp);

	/**
	 * updateCensoMonitorNoTramitados
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @return Arbbandeja
	 */
	Arbbandeja updateCensoMonitorNoTramitados(Arbbandeja arbbandeja);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	List<Arbbandeja> dameBandejaTP(Arbbandeja arbbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaTPCount(Arbbandeja arbbandeja,
			CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param pagination
	 *            Pagination
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */
	List<Arbbandeja> dameBandejaAvisos(Arbbandeja arbbandeja,
			Pagination pagination, CensoMonitor censoMonitor, String perfil);

	/**
	 * Finds a List of rows in the Arbbandeja table.
	 * 
	 * @param arbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            the censo monitor
	 * @param perfil
	 *            the perfil
	 * @return List
	 */

	public Long dameBandejaAvisosCount(Arbbandeja arbbandeja,
			CensoMonitor censoMonitor, String perfil);
}
