package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbainstancia;

/**
 * ArbainstanciaDaoImpl  
 *  
 */
 
@Repository
@Transactional
public class ArbainstanciaDaoImpl implements ArbainstanciaDao {
    private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbainstancia> rwMap = new RowMapper<Arbainstancia>() {
		public Arbainstancia mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Arbainstancia(
               resultSet.getString("AICODIGO"), resultSet.getString("AITEXTOES"), resultSet.getString("AITEXTOEU"), resultSet.getDate("AIFECALTA"), resultSet.getDate("AIFECMODIF"), resultSet.getString("AIUSUALTA"), resultSet.getString("AIUSUMODIF")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Arbainstancia table.
     *
     * @param arbainstancia Pagination
     * @return Arbainstancia
     */
	public Arbainstancia add(Arbainstancia arbainstancia) {
    	String query = "INSERT INTO ARBAINSTANCIA (AICODIGO, AITEXTOES, AITEXTOEU, AIFECALTA, AIFECMODIF, AIUSUALTA, AIUSUMODIF) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbainstancia.getAicodigo(), arbainstancia.getAitextoes(), arbainstancia.getAitextoeu(), arbainstancia.getAifecalta(), arbainstancia.getAifecmodif(), arbainstancia.getAiusualta(), arbainstancia.getAiusumodif());
		return arbainstancia;
	}

    /**
     * Updates a single row in the Arbainstancia table.
     *
     * @param arbainstancia Pagination
     * @return Arbainstancia
     */
    public Arbainstancia update(Arbainstancia arbainstancia) {
		String query = "UPDATE ARBAINSTANCIA SET AITEXTOES=?, AITEXTOEU=?, AIFECALTA=?, AIFECMODIF=?, AIUSUALTA=?, AIUSUMODIF=? WHERE AICODIGO=?";
		this.jdbcTemplate.update(query, arbainstancia.getAitextoes(), arbainstancia.getAitextoeu(), arbainstancia.getAifecalta(), arbainstancia.getAifecmodif(), arbainstancia.getAiusualta(), arbainstancia.getAiusumodif(), arbainstancia.getAicodigo());
		return arbainstancia;
	}

    /**
     * Finds a single row in the Arbainstancia table.
     *
     * @param arbainstancia Pagination
     * @return Arbainstancia
     */
    @Transactional (readOnly = true)
    public Arbainstancia find(Arbainstancia arbainstancia) {
		String query = "SELECT t1.AICODIGO AICODIGO, t1.AITEXTOES AITEXTOES, t1.AITEXTOEU AITEXTOEU, t1.AIFECALTA AIFECALTA, t1.AIFECMODIF AIFECMODIF, t1.AIUSUALTA AIUSUALTA, t1.AIUSUMODIF AIUSUMODIF FROM ARBAINSTANCIA t1  WHERE t1.AICODIGO = ?  ";
		
		List<Arbainstancia> arbainstanciaList = this.jdbcTemplate.query(query, this.rwMap, arbainstancia.getAicodigo());
		return (Arbainstancia) DataAccessUtils.uniqueResult(arbainstanciaList);
    }

    /**
     * Removes a single row in the Arbainstancia table.
     *
     * @param arbainstancia Pagination
     * @return
     */
    public void remove(Arbainstancia arbainstancia) {
		String query = "DELETE FROM ARBAINSTANCIA WHERE AICODIGO=?";
		this.jdbcTemplate.update(query, arbainstancia.getAicodigo());
    }
    
   /**
    * Finds a List of rows in the Arbainstancia table.
    * 
    * @param arbainstancia Arbainstancia
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Arbainstancia> findAll(Arbainstancia arbainstancia, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.AICODIGO AICODIGO,t1.AITEXTOES AITEXTOES,t1.AITEXTOEU AITEXTOEU,t1.AIFECALTA AIFECALTA,t1.AIFECMODIF AIFECMODIF,t1.AIUSUALTA AIUSUALTA,t1.AIUSUMODIF AIUSUMODIF "); 
		query.append("FROM ARBAINSTANCIA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbainstancia); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Arbainstancia>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Arbainstancia table.
     * 
     * @param arbainstancia Arbainstancia
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Arbainstancia arbainstancia) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBAINSTANCIA t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbainstancia); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Arbainstancia table using like.
     * 
     * @param arbainstancia Arbainstancia
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Arbainstancia> findAllLike(Arbainstancia arbainstancia, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.AICODIGO AICODIGO,t1.AITEXTOES AITEXTOES,t1.AITEXTOEU AITEXTOEU,t1.AIFECALTA AIFECALTA,t1.AIFECMODIF AIFECMODIF,t1.AIUSUALTA AIUSUALTA,t1.AIUSUMODIF AIUSUMODIF "); 
        query.append("FROM ARBAINSTANCIA t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbainstancia,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		
		return (List<Arbainstancia>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Counts rows in the Arbainstancia table using like.
     * 
     * @param arbainstancia Arbainstancia
     * @param startsWith Boolean
     * @return Long 
     */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Arbainstancia arbainstancia, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBAINSTANCIA t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbainstancia,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Arbainstancia entity 
	 * 
	 * @param arbainstancia Arbainstancia
	 *            Bean with the criteria values to filter by.
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Arbainstancia arbainstancia){
		
		StringBuilder where = new StringBuilder(ArbainstanciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbainstancia  != null  && arbainstancia.getAicodigo() != null ) {
			where.append(" AND t1.AICODIGO = ?");
			params.add(arbainstancia.getAicodigo());
		}
		if (arbainstancia  != null  && arbainstancia.getAitextoes() != null ) {
			where.append(" AND t1.AITEXTOES = ?");
			params.add(arbainstancia.getAitextoes());
		}
		if (arbainstancia  != null  && arbainstancia.getAitextoeu() != null ) {
			where.append(" AND t1.AITEXTOEU = ?");
			params.add(arbainstancia.getAitextoeu());
		}
		if (arbainstancia  != null  && arbainstancia.getAifecalta() != null ) {
			where.append(" AND t1.AIFECALTA = ?");
			params.add(arbainstancia.getAifecalta());
		}
		if (arbainstancia  != null  && arbainstancia.getAifecmodif() != null ) {
			where.append(" AND t1.AIFECMODIF = ?");
			params.add(arbainstancia.getAifecmodif());
		}
		if (arbainstancia  != null  && arbainstancia.getAiusualta() != null ) {
			where.append(" AND t1.AIUSUALTA = ?");
			params.add(arbainstancia.getAiusualta());
		}
		if (arbainstancia  != null  && arbainstancia.getAiusumodif() != null ) {
			where.append(" AND t1.AIUSUMODIF = ?");
			params.add(arbainstancia.getAiusumodif());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Arbainstancia entity 
	 * 
	 * @param arbainstancia Arbainstancia
	 *            Bean with the criteria values to filter by.
     * @param startsWith Boolean	 
	 * @return Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap (Arbainstancia arbainstancia, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(ArbainstanciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbainstancia  != null  && arbainstancia.getAicodigo() != null ) {
			where.append(" AND UPPER(t1.AICODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbainstancia.getAicodigo().toUpperCase() +"%");
			}else{
				params.add("%"+arbainstancia.getAicodigo().toUpperCase() +"%");
			}
			where.append(" AND t1.AICODIGO IS NOT NULL");
	     }			
		if (arbainstancia  != null  && arbainstancia.getAitextoes() != null ) {
			where.append(" AND UPPER(t1.AITEXTOES) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbainstancia.getAitextoes().toUpperCase() +"%");
			}else{
				params.add("%"+arbainstancia.getAitextoes().toUpperCase() +"%");
			}
			where.append(" AND t1.AITEXTOES IS NOT NULL");
	     }			
		if (arbainstancia  != null  && arbainstancia.getAitextoeu() != null ) {
			where.append(" AND UPPER(t1.AITEXTOEU) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbainstancia.getAitextoeu().toUpperCase() +"%");
			}else{
				params.add("%"+arbainstancia.getAitextoeu().toUpperCase() +"%");
			}
			where.append(" AND t1.AITEXTOEU IS NOT NULL");
	     }			
		if (arbainstancia  != null  && arbainstancia.getAifecalta() != null ) {
			where.append(" AND t1.AIFECALTA = ?");
			params.add(arbainstancia.getAifecalta());
	     }			
		if (arbainstancia  != null  && arbainstancia.getAifecmodif() != null ) {
			where.append(" AND t1.AIFECMODIF = ?");
			params.add(arbainstancia.getAifecmodif());
	     }			
		if (arbainstancia  != null  && arbainstancia.getAiusualta() != null ) {
			where.append(" AND UPPER(t1.AIUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbainstancia.getAiusualta().toUpperCase() +"%");
			}else{
				params.add("%"+arbainstancia.getAiusualta().toUpperCase() +"%");
			}
			where.append(" AND t1.AIUSUALTA IS NOT NULL");
	     }			
		if (arbainstancia  != null  && arbainstancia.getAiusumodif() != null ) {
			where.append(" AND UPPER(t1.AIUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(arbainstancia.getAiusumodif().toUpperCase() +"%");
			}else{
				params.add("%"+arbainstancia.getAiusumodif().toUpperCase() +"%");
			}
			where.append(" AND t1.AIUSUMODIF IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

