package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Arbadocorrel;

/**
 * ArbadocorrelDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbadocorrelDaoImpl implements ArbadocorrelDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbadocorrel> rwMap = new RowMapper<Arbadocorrel>() {
		public Arbadocorrel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbadocorrel(resultSet.getString("ANYO"),
					resultSet.getLong("CORREL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Pagination
	 * @return Arbadocorrel
	 */
	public Arbadocorrel add(Arbadocorrel arbadocorrel) {
		String query = "INSERT INTO ARBADOCORREL (ANYO, CORREL) VALUES (?,?)";
		this.jdbcTemplate.update(query, arbadocorrel.getAnyo(),
				arbadocorrel.getCorrel());
		return arbadocorrel;
	}

	/**
	 * Updates a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Pagination
	 * @return Arbadocorrel
	 */
	public Arbadocorrel update(Arbadocorrel arbadocorrel) {
		String query = "UPDATE ARBADOCORREL SET CORREL=? WHERE ANYO=?";
		this.jdbcTemplate.update(query, arbadocorrel.getCorrel(),
				arbadocorrel.getAnyo());
		return arbadocorrel;
	}

	/**
	 * Finds a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Pagination
	 * @return Arbadocorrel
	 */
	@Transactional(readOnly = true)
	public Arbadocorrel find(Arbadocorrel arbadocorrel) {
		String query = "SELECT t1.ANYO ANYO, t1.CORREL CORREL FROM ARBADOCORREL t1  WHERE t1.ANYO = ?  ";

		List<Arbadocorrel> arbadocorrelList = this.jdbcTemplate.query(query,
				this.rwMap, arbadocorrel.getAnyo());
		return (Arbadocorrel) DataAccessUtils.uniqueResult(arbadocorrelList);
	}

	/**
	 * Removes a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Pagination
	 * @return
	 */
	public void remove(Arbadocorrel arbadocorrel) {
		String query = "DELETE FROM ARBADOCORREL WHERE ANYO=?";
		this.jdbcTemplate.update(query, arbadocorrel.getAnyo());
	}

	/**
	 * Finds a List of rows in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadocorrel> findAll(Arbadocorrel arbadocorrel,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANYO ANYO,t1.CORREL CORREL ");
		query.append("FROM ARBADOCORREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadocorrel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadocorrel>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbadocorrel arbadocorrel) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADOCORREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadocorrel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbadocorrel table using like.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadocorrel> findAllLike(Arbadocorrel arbadocorrel,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANYO ANYO,t1.CORREL CORREL ");
		query.append("FROM ARBADOCORREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadocorrel,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadocorrel>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadocorrel table using like.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbadocorrel arbadocorrel, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADOCORREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadocorrel,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadocorrel entity
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbadocorrel arbadocorrel) {

		StringBuilder where = new StringBuilder(
				ArbadocorrelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadocorrel != null && arbadocorrel.getAnyo() != null) {
			where.append(" AND t1.ANYO = ?");
			params.add(arbadocorrel.getAnyo());
		}
		if (arbadocorrel != null && arbadocorrel.getCorrel() != null) {
			where.append(" AND t1.CORREL = ?");
			params.add(arbadocorrel.getCorrel());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadocorrel entity
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbadocorrel arbadocorrel,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbadocorrelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadocorrel != null && arbadocorrel.getAnyo() != null) {
			where.append(" AND UPPER(t1.ANYO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadocorrel.getAnyo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadocorrel.getAnyo().toUpperCase() + "%");
			}
			where.append(" AND t1.ANYO IS NOT NULL");
		}
		if (arbadocorrel != null && arbadocorrel.getCorrel() != null) {
			where.append(" AND t1.CORREL = ?");
			params.add(arbadocorrel.getCorrel());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Counts rows in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Long
	 */
	public Long getNextContador(Arbadocorrel arbadocorrel) {

		String queryLock = "LOCK TABLE ARBADOCORREL IN SHARE ROW EXCLUSIVE MODE";
		this.jdbcTemplate.update(queryLock);

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANYO ANYO,t1.CORREL+1 CORREL");
		query.append(" FROM ARBADOCORREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadocorrel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<Object> params = (List<Object>) mapaWhere.get("params");

		List<Arbadocorrel> listaContador = (List<Arbadocorrel>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
		long nuevoContadorLong = 0;
		query.setLength(0);
		params.clear();
		// actualizamos el valor del contador
		if (listaContador != null && listaContador.size() > 0) {
			nuevoContadorLong = listaContador.get(0).getCorrel();

			params.add(new Long(nuevoContadorLong));
			params.add(arbadocorrel.getAnyo());

			query.append("UPDATE ARBADOCORREL SET CORREL=? WHERE ANYO=?");
			this.jdbcTemplate.update(query.toString(), params.toArray());

		} else {
			nuevoContadorLong++;
			params.add(arbadocorrel.getAnyo());
			params.add(new Long(nuevoContadorLong));

			query.append("INSERT INTO ARBADOCORREL (ANYO, CORREL) VALUES (?,?)");
			this.jdbcTemplate.update(query.toString(), params.toArray());
		}

		return new Long(nuevoContadorLong);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
