package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbadocorrel;

/**
 * ArbadocorrelDao  
 * 
 *  
 */

public interface ArbadocorrelDao {

	/**
	 * Inserts a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Arbadocorrel
	 */
	Arbadocorrel add(Arbadocorrel arbadocorrel);

	/**
	 * Updates a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Arbadocorrel
	 */
	Arbadocorrel update(Arbadocorrel arbadocorrel);

	/**
	 * Finds a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Arbadocorrel
	 */
	Arbadocorrel find(Arbadocorrel arbadocorrel);

	/**
	 * Deletes a single row in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return
	 */
	void remove(Arbadocorrel arbadocorrel);

	/**
	 * Finds a List of rows in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadocorrel> findAll(Arbadocorrel arbadocorrel, Pagination pagination);

	/**
	 * Counts rows in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Long
	 */
	Long findAllCount(Arbadocorrel arbadocorrel);

	/**
	 * Finds rows in the Arbadocorrel table using like.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadocorrel> findAllLike(Arbadocorrel arbadocorrel,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbadocorrel table using like.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadocorrel arbadocorrel, Boolean startsWith);

	/**
	 * Counts rows in the Arbadocorrel table.
	 * 
	 * @param arbadocorrel
	 *            Arbadocorrel
	 * @return Long
	 */
	Long getNextContador(Arbadocorrel arbadocorrel);
}
