package com.ejie.y41b.dao;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbadhtramDaoImpl  
 * 
 *  
 * 
 */

@Repository
@Transactional
public class ArbadhtramDaoImpl implements ArbadhtramDao {

	private static final Logger logger = LoggerFactory
			.getLogger(ArbadhtramDaoImpl.class);

	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbadhtram> rwMap = new RowMapper<Arbadhtram>() {
		public Arbadhtram mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			List<String> columnasSeleccionadas = Y41bUtils
					.cargarDatosBDVO(resultSet);

			CensoMonitor censoMonitor = new CensoMonitor(
					resultSet.getString("TRMOCODIGO"),
					resultSet.getString("MONOMBRE"));

			CensoMonitor censoMonitorEj = new CensoMonitor(
					resultSet.getString("TRMOCODIGOEJ"),
					resultSet.getString("MONOMBREEJ"));

			Tramite tramite = new Tramite(resultSet.getString("TRCODIGO"),
					resultSet.getString("TRNOMBRE"),
					resultSet.getString("TRNOMBREE"), null, null, null, null,
					null, null);

			Arbadhtram arbadhtram = new Arbadhtram(resultSet.getString("TRID"),
					resultSet.getString("TRCODIGO"),
					resultSet.getString("TREXCODIGO"),
					resultSet.getTimestamp("TRFECINI"),
					resultSet.getTimestamp("TRFECFIN"),
					resultSet.getString("TRNOMTRAMES"),
					resultSet.getDate("TRRESOFECHA"),
					resultSet.getString("TRRESOTIPO"),
					resultSet.getDate("TRFECCIERRE"),
					resultSet.getString("TRFCODIGO"),
					resultSet.getString("TRTIPONOT"),
					resultSet.getString("TRESTADO"),
					resultSet.getDate("TRFECNOTIF"),
					resultSet.getBigDecimal("TRUAIDINTERV"),
					resultSet.getString("TRCODIGOREL"),
					resultSet.getString("TRIDNOTIFPLATEA"),
					resultSet.getDate("TRFECREGS"),
					resultSet.getString("TRTIPOCOM"),
					resultSet.getString("TRESTADOACUSE"),
					resultSet.getString("TRNUMREGS"),
					resultSet.getDate("TRFECACUSE"),
					resultSet.getString("TRIDESPERAPLATEA"),
					resultSet.getString("TRMATARESPERA"),
					resultSet.getString("TRASUNTOCOMUNICACION"),
					resultSet.getString("TRTIPONOTPLATEA"),
					resultSet.getString("TRSEDE"),
					resultSet.getString("TRCODREM"),
					resultSet.getString("TRENVREM"),
					resultSet.getString("TRIDMAILORIGEN"),
					resultSet.getString("TRMAILORIGEN"),
					resultSet.getString("TRIDMAILDESTINO"),
					resultSet.getString("TRMAILDESTINO"),
					resultSet.getClob("TRTEXTO"),
					resultSet.getClob("TROBSERVES"),
					resultSet.getDate("TRFECHAENVIOBOPVBOE"),
					resultSet.getString("TRPROCEEDINGSIDPLATEA"),
					resultSet.getString("TRMONITOR"),
					resultSet.getClob("TRSIGUIENTESTRAMITES"),
					resultSet.getString("TRNOTCOMSOLICI"),
					resultSet.getDate("TRFECREM"),
					resultSet.getTimestamp("TRFECALTA"),
					resultSet.getTimestamp("TRFECMODIF"),
					resultSet.getString("TRUSUALTA"),
					resultSet.getString("TRUSUMODIF"),
					resultSet.getString("TRTRIDREL"), null, null, censoMonitor,
					censoMonitorEj, tramite);

			arbadhtram.setRmestado(resultSet.getString("RMESTADO"));
			arbadhtram.setTracusereintentado((columnasSeleccionadas
					.contains("TRACUSEREINTENTADO")) ? resultSet
					.getString("TRACUSEREINTENTADO") : null);
			arbadhtram.setTrnotreintentado((columnasSeleccionadas
					.contains("TRNOTREINTENTADO")) ? resultSet
					.getString("TRNOTREINTENTADO") : null);
			arbadhtram.setTrautomatico((columnasSeleccionadas
					.contains("TRAUTOMATICO")) ? resultSet
					.getString("TRAUTOMATICO") : null);
			return arbadhtram;
		}

	};

	private RowMapper<NotificacionesComunicacionesBusqueda> rwMapNotifiComunica = new RowMapper<NotificacionesComunicacionesBusqueda>() {
		public NotificacionesComunicacionesBusqueda mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {
			NotificacionesComunicacionesBusqueda retorno = new NotificacionesComunicacionesBusqueda(
					resultSet.getString("TRID"),
					resultSet.getString("CODEXPEDIENTE"),
					resultSet.getString("EXCOOR"),
					resultSet.getString("EXNRAN"),
					resultSet.getBigDecimal("EXNROR"), null,
					resultSet.getDate("EHFECHAINICIO"),
					resultSet.getString("EHNUMREGISTROSALIDA"),
					resultSet.getString("EHTIPONOTIFICACIONPLATEA"),
					resultSet.getString("TRMOCODIGOEJ"),
					resultSet.getString("MONOMBRE"),
					resultSet.getString("UAIDINTERV"),
					resultSet.getString("NIF"),
					resultSet.getString("NOMBREDESTINATARIO"),
					resultSet.getString("NOMBRECOMERCIALDESTINATARIO"),
					resultSet.getString("EXTRANJERO"),
					resultSet.getString("NOMBRE_PROVINCIA"),
					resultSet.getString("NOMBRE_MUNICIPIO"),
					resultSet.getString("NOMBRE_LOCALIDAD"),
					resultSet.getString("NOMBRE_CP"),
					resultSet.getString("NOMBRE_CALLE"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("DIRECCIONANTIGUA"),
					resultSet.getString("DIRECCION1"),
					resultSet.getString("DIRECCION2"),
					resultSet.getString("TRASUNTOCOMUNICACION"),
					resultSet.getString("EHESTADOTRAMITE"),
					resultSet.getString("EHSEDE"),
					resultSet.getString("ESCODIGO"),
					resultSet.getString("EXCODIGO"),
					resultSet.getString("CODORG"),
					resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIAORG"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIOORG"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDADORG"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLEORG"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECPORG"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTALORG"),
					resultSet.getString("TELEFONOORGANISMO"),
					resultSet.getString("FAXORGANISMO"),
					resultSet.getString("EMAILORGANISMO"),
					resultSet.getString("WEBORGANISMO"),
					resultSet.getString("TRCODIGO"),
					resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("USUARIOXLNET"),
					resultSet.getString("PUESTOXLNET"),
					resultSet.getString("ENVCESTADO"),
					resultSet.getString("ENVCDESERRORES"),
					resultSet.getString("ENVCDESERROREU"),
					resultSet.getInt("ENVCIDENVIO"),
					resultSet.getString("ENVCCODSITCORREOS"),
					resultSet.getString("ENVCDESSITCORREOSES"),
					resultSet.getString("ENVCDESSITCORREOSEU"),
					resultSet.getDate("ENVFECHAACTUALIZACION"),
					resultSet.getString("ENVCCODBARRAS"),
					resultSet.getString("IDTRAMITEACUSERELACIONADO"),
					resultSet.getString("EHACUSERECIBORECIBIDO"));
			StringBuffer numeroExpediente = new StringBuffer("");
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(resultSet
					.getString("ADHTIPO"))) {
				numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(resultSet
					.getString("ADHTIPO"))
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(resultSet
							.getString("ADHTIPO"))) {
				numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_BAJA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(resultSet
					.getString("ADHTIPO"))) {
				numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_MOD);
			}

			numeroExpediente.append("-").append(resultSet.getString("EXCOOR"))
					.append("-").append(resultSet.getBigDecimal("EXNROR"))
					.append("-").append(resultSet.getBigDecimal("EXNRAN"));
			retorno.setNumExpediente(numeroExpediente.toString());

			return retorno;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Pagination
	 * @return Arbadhtram
	 */
	public Arbadhtram add(Arbadhtram arbadhtram) {
		String query = "INSERT INTO ARBADHTRAM (TRID, TRTRIDREL, TRCODIGO, TREXCODIGO, TRFECINI, TRFECFIN, TRNOMTRAMES, TRMOCODIGO, TRMOCODIGOEJ, TRRESOFECHA, TRRESOTIPO, TRFECCIERRE, TRFCODIGO, TRTIPONOT, TRESTADO, TRFECNOTIF, TRUAIDINTERV, TRCODIGOREL, TRIDNOTIFPLATEA, TRFECREGS, TRTIPOCOM, TRESTADOACUSE, TRNUMREGS, TRFECACUSE, TRIDESPERAPLATEA, TRMATARESPERA, TRASUNTOCOMUNICACION, TRTIPONOTPLATEA, TRSEDE, TRCODREM, TRENVREM, TRIDMAILORIGEN, TRMAILORIGEN, TRIDMAILDESTINO, TRMAILDESTINO, TRTEXTO, TROBSERVES, TRFECHAENVIOBOPVBOE, TRPROCEEDINGSIDPLATEA, TRMONITOR, TRSIGUIENTESTRAMITES, TRNOTCOMSOLICI, TRFECREM, TRFECALTA, TRFECMODIF, TRUSUALTA, TRUSUMODIF, TRAUTOMATICO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getCensoMonitorAux = null;
		Object getCensoMonitorEjAux = null;
		if (arbadhtram.getCensoMonitor() != null
				&& arbadhtram.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorAux = arbadhtram.getCensoMonitor().getMocodigo();
		}
		if (arbadhtram.getCensoMonitorEj() != null
				&& arbadhtram.getCensoMonitorEj().getMocodigo() != null) {
			getCensoMonitorEjAux = arbadhtram.getCensoMonitorEj().getMocodigo();
		}
		arbadhtram.setTrfecini(new Date());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbadhtram
				.getTrestado())) {
			arbadhtram.setTrfecfin(new Date());
		}
		String sqlCompleta = "";
		try {
			Object[] params = { arbadhtram.getTrid(),
					arbadhtram.getTrtridrel(), arbadhtram.getTrcodigo(),
					arbadhtram.getTrexcodigo(), arbadhtram.getTrfecini(),
					arbadhtram.getTrfecfin(), arbadhtram.getTrnomtrames(),
					getCensoMonitorAux, getCensoMonitorEjAux,
					arbadhtram.getTrresofecha(), arbadhtram.getTrresotipo(),
					arbadhtram.getTrfeccierre(), arbadhtram.getTrfcodigo(),
					arbadhtram.getTrtiponot(), arbadhtram.getTrestado(),
					arbadhtram.getTrfecnotif(), arbadhtram.getTruaidinterv(),
					arbadhtram.getTrcodigorel(),
					arbadhtram.getTridnotifplatea(), arbadhtram.getTrfecregs(),
					arbadhtram.getTrtipocom(), arbadhtram.getTrestadoacuse(),
					arbadhtram.getTrnumregs(), arbadhtram.getTrfecacuse(),
					arbadhtram.getTridesperaplatea(),
					arbadhtram.getTrmatarespera(),
					arbadhtram.getTrasuntocomunicacion(),
					arbadhtram.getTrtiponotplatea(), arbadhtram.getTrsede(),
					arbadhtram.getTrcodrem(), arbadhtram.getTrenvrem(),
					arbadhtram.getTridmailorigen(),
					arbadhtram.getTrmailorigen(),
					arbadhtram.getTridmaildestino(),
					arbadhtram.getTrmaildestino(),
					Y41bUtils.clobToString(arbadhtram.getTrtexto()),
					Y41bUtils.clobToString(arbadhtram.getTrobserves()),
					arbadhtram.getTrfechaenviobopvboe(),
					arbadhtram.getTrproceedingsidplatea(),
					arbadhtram.getTrmonitor(),
					arbadhtram.getTrsiguientestramites(),
					arbadhtram.getTrnotcomsolici(), arbadhtram.getTrfecrem(),
					arbadhtram.getTrfecalta(), arbadhtram.getTrfecmodif(),
					arbadhtram.getTrusualta(), arbadhtram.getTrusumodif(),
					arbadhtram.getTrautomatico() };

			sqlCompleta = Y41bUtils.dameSQL(query, params);
			this.jdbcTemplate.update(query, params);
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhtramDaoImpl.logger.error(e.getMessage() + ".SQL FORMATEADA:"
					+ sqlCompleta + ".");
			throw new Y41bUDAException(e.getMessage(), true, e);
		}
		return arbadhtram;
	}

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Pagination
	 * @return Arbadhtram
	 */
	public Arbadhtram update(Arbadhtram arbadhtram) {
		String query = "UPDATE ARBADHTRAM SET TRTRIDREL=?, TRCODIGO=?, TREXCODIGO=?, TRFECFIN=?, TRNOMTRAMES=?, TRMOCODIGO=?, TRMOCODIGOEJ=?, TRRESOFECHA=?, TRRESOTIPO=?, TRFECCIERRE=?, TRFCODIGO=?, TRTIPONOT=?, TRESTADO=?, TRFECNOTIF=?, TRUAIDINTERV=?, TRCODIGOREL=?, TRIDNOTIFPLATEA=?, TRFECREGS=?, TRTIPOCOM=?, TRESTADOACUSE=?, TRNUMREGS=?, TRFECACUSE=?, TRIDESPERAPLATEA=?, TRMATARESPERA=?, TRASUNTOCOMUNICACION=?, TRTIPONOTPLATEA=?, TRSEDE=?, TRCODREM=?, TRENVREM=?, TRIDMAILORIGEN=?, TRMAILORIGEN=?, TRIDMAILDESTINO=?, TRMAILDESTINO=?, TRTEXTO=?, TROBSERVES=?, TRFECHAENVIOBOPVBOE=?, TRPROCEEDINGSIDPLATEA=?, TRMONITOR=?, TRSIGUIENTESTRAMITES=?, TRNOTCOMSOLICI=?, TRFECREM=?, TRFECALTA=?, TRFECMODIF=?, TRUSUALTA=?, TRUSUMODIF=? WHERE TRID=?";
		Object getCensoMonitorAux = null;
		Object getCensoMonitorEjAux = null;
		if (arbadhtram.getCensoMonitor() != null
				&& arbadhtram.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorAux = arbadhtram.getCensoMonitor().getMocodigo();
		}
		if (arbadhtram.getCensoMonitorEj() != null
				&& arbadhtram.getCensoMonitorEj().getMocodigo() != null) {
			getCensoMonitorEjAux = arbadhtram.getCensoMonitorEj().getMocodigo();
		}

		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbadhtram
				.getTrestado())) {
			arbadhtram.setTrfecfin(new Date());
		}

		this.jdbcTemplate.update(query, arbadhtram.getTrtridrel(),
				arbadhtram.getTrcodigo(), arbadhtram.getTrexcodigo(),
				arbadhtram.getTrfecfin(), arbadhtram.getTrnomtrames(),
				getCensoMonitorAux, getCensoMonitorEjAux,
				arbadhtram.getTrresofecha(), arbadhtram.getTrresotipo(),
				arbadhtram.getTrfeccierre(), arbadhtram.getTrfcodigo(),
				arbadhtram.getTrtiponot(), arbadhtram.getTrestado(),
				arbadhtram.getTrfecnotif(), arbadhtram.getTruaidinterv(),
				arbadhtram.getTrcodigorel(), arbadhtram.getTridnotifplatea(),
				arbadhtram.getTrfecregs(), arbadhtram.getTrtipocom(),
				arbadhtram.getTrestadoacuse(), arbadhtram.getTrnumregs(),
				arbadhtram.getTrfecacuse(), arbadhtram.getTridesperaplatea(),
				arbadhtram.getTrmatarespera(),
				arbadhtram.getTrasuntocomunicacion(),
				arbadhtram.getTrtiponotplatea(), arbadhtram.getTrsede(),
				arbadhtram.getTrcodrem(), arbadhtram.getTrenvrem(),
				arbadhtram.getTridmailorigen(), arbadhtram.getTrmailorigen(),
				arbadhtram.getTridmaildestino(), arbadhtram.getTrmaildestino(),
				Y41bUtils.clobToString(arbadhtram.getTrtexto()),
				Y41bUtils.clobToString(arbadhtram.getTrobserves()),
				arbadhtram.getTrfechaenviobopvboe(),
				arbadhtram.getTrproceedingsidplatea(),
				arbadhtram.getTrmonitor(),
				arbadhtram.getTrsiguientestramites(),
				arbadhtram.getTrnotcomsolici(), arbadhtram.getTrfecrem(),
				arbadhtram.getTrfecalta(), arbadhtram.getTrfecmodif(),
				arbadhtram.getTrusualta(), arbadhtram.getTrusumodif(),
				arbadhtram.getTrid());
		return arbadhtram;
	}

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Pagination
	 * @return Arbadhtram
	 */
	@Transactional(readOnly = true)
	public Arbadhtram find(Arbadhtram arbadhtram) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID TRID,t1.TRCODIGO TRCODIGO,t1.TREXCODIGO TREXCODIGO,t1.TRTRIDREL,t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,t1.TRNOMTRAMES TRNOMTRAMES,t1.TRMOCODIGO TRMOCODIGO,t1.TRMOCODIGOEJ TRMOCODIGOEJ,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFCODIGO TRFCODIGO,t1.TRTIPONOT TRTIPONOT,t1.TRESTADO TRESTADO,t1.TRFECNOTIF TRFECNOTIF,t1.TRUAIDINTERV TRUAIDINTERV,t1.TRCODIGOREL TRCODIGOREL,t1.TRIDNOTIFPLATEA TRIDNOTIFPLATEA,t1.TRFECREGS TRFECREGS,t1.TRTIPOCOM TRTIPOCOM,t1.TRESTADOACUSE TRESTADOACUSE,t1.TRNUMREGS TRNUMREGS,t1.TRFECACUSE TRFECACUSE,t1.TRIDESPERAPLATEA TRIDESPERAPLATEA,t1.TRMATARESPERA TRMATARESPERA,t1.TRASUNTOCOMUNICACION TRASUNTOCOMUNICACION,t1.TRTIPONOTPLATEA TRTIPONOTPLATEA,t1.TRSEDE TRSEDE,t1.TRCODREM TRCODREM,t1.TRENVREM TRENVREM,t1.TRIDMAILORIGEN TRIDMAILORIGEN,t1.TRMAILORIGEN TRMAILORIGEN,t1.TRIDMAILDESTINO TRIDMAILDESTINO,t1.TRMAILDESTINO TRMAILDESTINO,t1.TRTEXTO TRTEXTO,t1.TROBSERVES TROBSERVES,t1.TRFECHAENVIOBOPVBOE TRFECHAENVIOBOPVBOE,t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA,t1.TRMONITOR TRMONITOR,t1.TRSIGUIENTESTRAMITES TRSIGUIENTESTRAMITES,t1.TRNOTCOMSOLICI TRNOTCOMSOLICI,t1.TRFECREM TRFECREM,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIf, '' RMESTADO ");
		query.append(" ,t2.ADHID, t2.ADHSOLCOOR, t2.ADHSOLNROR, t2.ADHSOLNRAN ");
		query.append(" ,t3.FCODIGO FASEFCODIGO, t3.FNOMBRE FASEFNOMBRE, t3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE, t6.TRNOMBREE, t1.TRACUSEREINTENTADO, t1.TRAUTOMATICO");
		query.append(" FROM ARBADHTRAM t1 , ARBADHSOL t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6 ");

		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE t1.TRID=? AND t1.TREXCODIGO= t2.ADHID(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) AND t6.TRCODIGO(+) = t1.TRCODIGO AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+)  ");
		query.append(where);

		List<Arbadhtram> arbadhtramList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, arbadhtram.getTrid());
		return (Arbadhtram) DataAccessUtils.uniqueResult(arbadhtramList);
	}

	/**
	 * Finds a Single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param codocumento
	 *            String
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findDocTramiteResolucion(Arbadhtram arbadhtram,
			String codocumento) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ( ");
		query.append("SELECT DISTINCT T1.TRCODIGO TRCODIGO, T1.TREXCODIGO TREXCODIGO, T1.TRESTADO TRESTADO, T3.XMCODOCUMENTO XMCODOCUMENTO, T3.XMEXCODIGO XMEXCODIGO, T4.CODOCUMENTO CODOCUMENTO ");
		query.append("FROM ARBADHTRAM T1, ARBADHSOL T2, ARBADHSOLCOMDOC T3, ARBADHDOCTRAM T4 ");
		// Where clause & Params
		StringBuilder where = new StringBuilder(
				" WHERE T1.TREXCODIGO=? AND T1.TRESTADO=? AND (T1.TRCODIGO=? OR  T1.TRCODIGO=? OR  T1.TRCODIGO=?) AND T4.CODOCUMENTO=? AND T1.TREXCODIGO=T3.XMEXCODIGO AND T3.XMCODOCUMENTO=T4.CODOCUMENTO AND T1.TREXCODIGO=T2.ADHID(+)) ");
		query.append(where);

		Long l = (Long) this.jdbcTemplate.queryForLong(query.toString(),
				arbadhtram.getTrexcodigo(),
				Y41bConstantes.ESTADO_TRAMITE_TRAMITADO,
				Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_ALTA,
				Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_MOD,
				Y41bConstantes.TRAMITE_ADHESION_RESOLUCION_BAJA, codocumento);
		return l;
	}

	/**
	 * Removes a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Pagination
	 * @return
	 */
	public void remove(Arbadhtram arbadhtram) {
		String query = "DELETE FROM ARBADHTRAM WHERE TRID=?";
		this.jdbcTemplate.update(query, arbadhtram.getTrid());
	}

	/**
	 * Finds a List of rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhtram> findAll(Arbadhtram arbadhtram, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID TRID,t1.TRCODIGO TRCODIGO,t1.TREXCODIGO TREXCODIGO,t1.TRTRIDREL,t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,t1.TRNOMTRAMES TRNOMTRAMES,t1.TRMOCODIGO TRMOCODIGO,t1.TRMOCODIGOEJ TRMOCODIGOEJ,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFCODIGO TRFCODIGO,t1.TRTIPONOT TRTIPONOT,t1.TRESTADO TRESTADO,t1.TRFECNOTIF TRFECNOTIF,t1.TRUAIDINTERV TRUAIDINTERV,t1.TRCODIGOREL TRCODIGOREL,t1.TRIDNOTIFPLATEA TRIDNOTIFPLATEA,t1.TRFECREGS TRFECREGS,t1.TRTIPOCOM TRTIPOCOM,t1.TRESTADOACUSE TRESTADOACUSE,t1.TRNUMREGS TRNUMREGS,t1.TRFECACUSE TRFECACUSE,t1.TRIDESPERAPLATEA TRIDESPERAPLATEA,t1.TRMATARESPERA TRMATARESPERA,t1.TRASUNTOCOMUNICACION TRASUNTOCOMUNICACION,t1.TRTIPONOTPLATEA TRTIPONOTPLATEA,t1.TRSEDE TRSEDE,t1.TRCODREM TRCODREM,t1.TRENVREM TRENVREM,t1.TRIDMAILORIGEN TRIDMAILORIGEN,t1.TRMAILORIGEN TRMAILORIGEN,t1.TRIDMAILDESTINO TRIDMAILDESTINO,t1.TRMAILDESTINO TRMAILDESTINO,t1.TRTEXTO TRTEXTO,t1.TROBSERVES TROBSERVES,t1.TRFECHAENVIOBOPVBOE TRFECHAENVIOBOPVBOE,t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA,t1.TRMONITOR TRMONITOR,t1.TRSIGUIENTESTRAMITES TRSIGUIENTESTRAMITES,t1.TRNOTCOMSOLICI TRNOTCOMSOLICI,t1.TRFECREM TRFECREM,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF ");
		query.append(" ,(SELECT TRACUSEREINTENTADO FROM ARBADHTRAM ACUSREIN WHERE ACUSREIN.TRTRIDREL=t1.TRID) AS TRNOTREINTENTADO");
		query.append(" ,TRACUSEREINTENTADO");
		query.append(" ,t2.ADHID, t2.ADHSOLCOOR, t2.ADHSOLNROR, t2.ADHSOLNRAN ");
		query.append(" ,t3.FCODIGO FASEFCODIGO, t3.FNOMBRE FASEFNOMBRE, t3.FNOMBREE FASEFNOMBREE, t4.MONOMBRE, t5.MONOMBRE MONOMBREEJ, t6.TRNOMBRE, t6.TRNOMBREE, t7.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, t7.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU,  t8.RMESTADO RMESTADO  ");
		query.append(" FROM ARBADHTRAM t1 , ARBADHSOL t2, FASE t3, CENSO_MONITOR t4, CENSO_MONITOR t5, TRAMITE t6, ENVIOS_POR_REMESA t7,REMESA t8   ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhtram);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.TREXCODIGO= t2.ADHID(+) AND t1.TRMOCODIGOEJ = t5.MOCODIGO(+) AND t6.TRCODIGO(+) = t1.TRCODIGO AND T3.FCODIGO(+) = T1.TRFCODIGO AND t1.TRMOCODIGO = t4.MOCODIGO(+) AND to_char(t1.TRTRIDREL) = t7.EHCODIGO(+) AND t1.TRCODREM=t8.RMCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhtram>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbadhtram arbadhtram) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHTRAM t1 , ARBADHSOL t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhtram);
		StringBuilder where = new StringBuilder(
				"WHERE 1=1 AND t1.TREXCODIGO= t2.ADHID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhtram> findAllLike(Arbadhtram arbadhtram,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRID TRID,t1.TRCODIGO TRCODIGO,t1.TREXCODIGO TREXCODIGO,t1.TRFECINI TRFECINI,t1.TRFECFIN TRFECFIN,t1.TRNOMTRAMES TRNOMTRAMES,t1.TRMOCODIGO TRMOCODIGO,t1.TRMOCODIGOEJ TRMOCODIGOEJ,t1.TRRESOFECHA TRRESOFECHA,t1.TRRESOTIPO TRRESOTIPO,t1.TRFECCIERRE TRFECCIERRE,t1.TRFCODIGO TRFCODIGO,t1.TRTIPONOT TRTIPONOT,t1.TRESTADO TRESTADO,t1.TRFECNOTIF TRFECNOTIF,t1.TRUAIDINTERV TRUAIDINTERV,t1.TRCODIGOREL TRCODIGOREL,t1.TRIDNOTIFPLATEA TRIDNOTIFPLATEA,t1.TRFECREGS TRFECREGS,t1.TRTIPOCOM TRTIPOCOM,t1.TRESTADOACUSE TRESTADOACUSE,t1.TRNUMREGS TRNUMREGS,t1.TRFECACUSE TRFECACUSE,t1.TRIDESPERAPLATEA TRIDESPERAPLATEA,t1.TRMATARESPERA TRMATARESPERA,t1.TRASUNTOCOMUNICACION TRASUNTOCOMUNICACION,t1.TRTIPONOTPLATEA TRTIPONOTPLATEA,t1.TRSEDE TRSEDE,t1.TRCODREM TRCODREM,t1.TRENVREM TRENVREM,t1.TRIDMAILORIGEN TRIDMAILORIGEN,t1.TRMAILORIGEN TRMAILORIGEN,t1.TRIDMAILDESTINO TRIDMAILDESTINO,t1.TRMAILDESTINO TRMAILDESTINO,t1.TRTEXTO TRTEXTO,t1.TROBSERVES TROBSERVES,t1.TRFECHAENVIOBOPVBOE TRFECHAENVIOBOPVBOE,t1.TRPROCEEDINGSIDPLATEA TRPROCEEDINGSIDPLATEA,t1.TRMONITOR TRMONITOR,t1.TRSIGUIENTESTRAMITES TRSIGUIENTESTRAMITES,t1.TRNOTCOMSOLICI TRNOTCOMSOLICI,t1.TRFECREM TRFECREM,t1.TRFECALTA TRFECALTA,t1.TRFECMODIF TRFECMODIF,t1.TRUSUALTA TRUSUALTA,t1.TRUSUMODIF TRUSUMODIF ,t2.TRID ARBADHTRAMTRID,t2.TRCODIGO ARBADHTRAMTRCODIGO,t2.TREXCODIGO ARBADHTRAMTREXCODIGO,t2.TRFECINI ARBADHTRAMTRFECINI,t2.TRFECFIN ARBADHTRAMTRFECFIN,t2.TRNOMTRAMES ARBADHTRAMTRNOMTRAMES,t2.TRMOCODIGO ARBADHTRAMTRMOCODIGO,t2.TRMOCODIGOEJ ARBADHTRAMTRMOCODIGOEJ,t2.TRRESOFECHA ARBADHTRAMTRRESOFECHA,t2.TRRESOTIPO ARBADHTRAMTRRESOTIPO,t2.TRFECCIERRE ARBADHTRAMTRFECCIERRE,t2.TRFCODIGO ARBADHTRAMTRFCODIGO,t2.TRTIPONOT ARBADHTRAMTRTIPONOT,t2.TRESTADO ARBADHTRAMTRESTADO,t2.TRFECNOTIF ARBADHTRAMTRFECNOTIF,t2.TRUAIDINTERV ARBADHTRAMTRUAIDINTERV,t2.TRCODIGOREL ARBADHTRAMTRCODIGOREL,t2.TRIDNOTIFPLATEA ARBADHTRAMTRIDNOTIFPLATEA,t2.TRFECREGS ARBADHTRAMTRFECREGS,t2.TRTIPOCOM ARBADHTRAMTRTIPOCOM,t2.TRESTADOACUSE ARBADHTRAMTRESTADOACUSE,t2.TRNUMREGS ARBADHTRAMTRNUMREGS,t2.TRFECACUSE ARBADHTRAMTRFECACUSE,t2.TRIDESPERAPLATEA ARBADHTRAMTRIDESPERAPLATEA,t2.TRMATARESPERA ARBADHTRAMTRMATARESPERA,t2.TRASUNTOCOMUNICACION ARBADHTRAMTRASUNTOCOMUNICACION,t2.TRTIPONOTPLATEA ARBADHTRAMTRTIPONOTPLATEA,t2.TRSEDE ARBADHTRAMTRSEDE,t2.TRCODREM ARBADHTRAMTRCODREM,t2.TRENVREM ARBADHTRAMTRENVREM,t2.TRIDMAILORIGEN ARBADHTRAMTRIDMAILORIGEN,t2.TRMAILORIGEN ARBADHTRAMTRMAILORIGEN,t2.TRIDMAILDESTINO ARBADHTRAMTRIDMAILDESTINO,t2.TRMAILDESTINO ARBADHTRAMTRMAILDESTINO,t2.TRTEXTO ARBADHTRAMTRTEXTO,t2.TROBSERVES ARBADHTRAMTROBSERVES,t2.TRFECHAENVIOBOPVBOE ARBADHTRAMTRFECHAENVIOBOPVBOE,t2.TRPROCEEDINGSIDPLATEA TRAMTRPROCEEDINGSIDPLATEA,t2.TRMONITOR ARBADHTRAMTRMONITOR,t2.TRSIGUIENTESTRAMITES ARBADHTRAMTRSIGUIENTESTRAMITES,t2.TRNOTCOMSOLICI ARBADHTRAMTRNOTCOMSOLICI,t2.TRFECREM ARBADHTRAMTRFECREM,t2.TRFECALTA ARBADHTRAMTRFECALTA,t2.TRFECMODIF ARBADHTRAMTRFECMODIF,t2.TRUSUALTA ARBADHTRAMTRUSUALTA,t2.TRUSUMODIF ARBADHTRAMTRUSUMODIF,t2.TRTRIDREL ARBADHTRAMTRTRIDREL, '' RMESTADO ");
		query.append("FROM ARBADHTRAM t1 ,ARBADHTRAM t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhtram, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.TRTRIDREL= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhtram>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbadhtram arbadhtram, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHTRAM t1 ,ARBADHTRAM t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhtram, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.TRTRIDREL= t2.TRID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhtram entity
	 * 
	 * @param arbadhtram
	 *            Arbadhtram Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbadhtram arbadhtram) {

		StringBuilder where = new StringBuilder(
				ArbadhtramDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhtram != null && arbadhtram.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(arbadhtram.getTrid());
		}
		if (arbadhtram != null && arbadhtram.getTrtridrel() != null) {
			where.append(" AND t1.TRTRIDREL = ?");
			params.add(arbadhtram.getTrtridrel());
		}
		if (arbadhtram != null && arbadhtram.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(arbadhtram.getTrcodigo());
		}
		if (arbadhtram != null && arbadhtram.getTrexcodigo() != null) {
			where.append(" AND t1.TREXCODIGO = ?");
			params.add(arbadhtram.getTrexcodigo());
		}
		if (arbadhtram != null && arbadhtram.getTrfecini() != null) {
			where.append(" AND t1.TRFECINI = ?");
			params.add(arbadhtram.getTrfecini());
		}
		if (arbadhtram != null && arbadhtram.getTrfecfin() != null) {
			where.append(" AND t1.TRFECFIN = ?");
			params.add(arbadhtram.getTrfecfin());
		}
		if (arbadhtram != null && arbadhtram.getTrnomtrames() != null) {
			where.append(" AND t1.TRNOMTRAMES = ?");
			params.add(arbadhtram.getTrnomtrames());
		}
		if (arbadhtram != null && arbadhtram.getCensoMonitor() != null
				&& arbadhtram.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t1.TRMOCODIGO = ?");
			params.add(arbadhtram.getCensoMonitor().getMocodigo());
		}
		if (arbadhtram != null && arbadhtram.getCensoMonitorEj() != null
				&& arbadhtram.getCensoMonitorEj().getMocodigo() != null) {
			where.append(" AND t1.TRMOCODIGOEJ = ?");
			params.add(arbadhtram.getCensoMonitorEj().getMocodigo());
		}
		if (arbadhtram != null && arbadhtram.getTrresofecha() != null) {
			where.append(" AND t1.TRRESOFECHA = ?");
			params.add(arbadhtram.getTrresofecha());
		}
		if (arbadhtram != null && arbadhtram.getTrresotipo() != null) {
			where.append(" AND t1.TRRESOTIPO = ?");
			params.add(arbadhtram.getTrresotipo());
		}
		if (arbadhtram != null && arbadhtram.getTrfeccierre() != null) {
			where.append(" AND t1.TRFECCIERRE = ?");
			params.add(arbadhtram.getTrfeccierre());
		}
		if (arbadhtram != null && arbadhtram.getTrfcodigo() != null) {
			where.append(" AND t1.TRFCODIGO = ?");
			params.add(arbadhtram.getTrfcodigo());
		}
		if (arbadhtram != null && arbadhtram.getTrtiponot() != null) {
			where.append(" AND t1.TRTIPONOT = ?");
			params.add(arbadhtram.getTrtiponot());
		}
		if (arbadhtram != null && arbadhtram.getTrestado() != null) {
			where.append(" AND t1.TRESTADO = ?");
			params.add(arbadhtram.getTrestado());
		}
		if (arbadhtram != null && arbadhtram.getTrfecnotif() != null) {
			where.append(" AND t1.TRFECNOTIF = ?");
			params.add(arbadhtram.getTrfecnotif());
		}
		if (arbadhtram != null && arbadhtram.getTruaidinterv() != null) {
			where.append(" AND t1.TRUAIDINTERV = ?");
			params.add(arbadhtram.getTruaidinterv());
		}
		if (arbadhtram != null && arbadhtram.getTrcodigorel() != null) {
			where.append(" AND t1.TRCODIGOREL = ?");
			params.add(arbadhtram.getTrcodigorel());
		}
		if (arbadhtram != null && arbadhtram.getTridnotifplatea() != null) {
			where.append(" AND t1.TRIDNOTIFPLATEA = ?");
			params.add(arbadhtram.getTridnotifplatea());
		}
		if (arbadhtram != null && arbadhtram.getTrfecregs() != null) {
			where.append(" AND t1.TRFECREGS = ?");
			params.add(arbadhtram.getTrfecregs());
		}
		if (arbadhtram != null && arbadhtram.getTrtipocom() != null) {
			where.append(" AND t1.TRTIPOCOM = ?");
			params.add(arbadhtram.getTrtipocom());
		}
		if (arbadhtram != null && arbadhtram.getTrestadoacuse() != null) {
			where.append(" AND t1.TRESTADOACUSE = ?");
			params.add(arbadhtram.getTrestadoacuse());
		}
		if (arbadhtram != null && arbadhtram.getTrnumregs() != null) {
			where.append(" AND t1.TRNUMREGS = ?");
			params.add(arbadhtram.getTrnumregs());
		}
		if (arbadhtram != null && arbadhtram.getTrfecacuse() != null) {
			where.append(" AND t1.TRFECACUSE = ?");
			params.add(arbadhtram.getTrfecacuse());
		}
		if (arbadhtram != null && arbadhtram.getTridesperaplatea() != null) {
			where.append(" AND t1.TRIDESPERAPLATEA = ?");
			params.add(arbadhtram.getTridesperaplatea());
		}
		if (arbadhtram != null && arbadhtram.getTrmatarespera() != null) {
			where.append(" AND t1.TRMATARESPERA = ?");
			params.add(arbadhtram.getTrmatarespera());
		}
		if (arbadhtram != null && arbadhtram.getTrasuntocomunicacion() != null) {
			where.append(" AND t1.TRASUNTOCOMUNICACION = ?");
			params.add(arbadhtram.getTrasuntocomunicacion());
		}
		if (arbadhtram != null && arbadhtram.getTrtiponotplatea() != null) {
			where.append(" AND t1.TRTIPONOTPLATEA = ?");
			params.add(arbadhtram.getTrtiponotplatea());
		}
		if (arbadhtram != null && arbadhtram.getTrsede() != null) {
			where.append(" AND t1.TRSEDE = ?");
			params.add(arbadhtram.getTrsede());
		}
		if (arbadhtram != null && arbadhtram.getTrcodrem() != null) {
			where.append(" AND t1.TRCODREM = ?");
			params.add(arbadhtram.getTrcodrem());
		}
		if (arbadhtram != null && arbadhtram.getTrenvrem() != null) {
			where.append(" AND t1.TRENVREM = ?");
			params.add(arbadhtram.getTrenvrem());
		}
		if (arbadhtram != null && arbadhtram.getTridmailorigen() != null) {
			where.append(" AND t1.TRIDMAILORIGEN = ?");
			params.add(arbadhtram.getTridmailorigen());
		}
		if (arbadhtram != null && arbadhtram.getTrmailorigen() != null) {
			where.append(" AND t1.TRMAILORIGEN = ?");
			params.add(arbadhtram.getTrmailorigen());
		}
		if (arbadhtram != null && arbadhtram.getTridmaildestino() != null) {
			where.append(" AND t1.TRIDMAILDESTINO = ?");
			params.add(arbadhtram.getTridmaildestino());
		}
		if (arbadhtram != null && arbadhtram.getTrmaildestino() != null) {
			where.append(" AND t1.TRMAILDESTINO = ?");
			params.add(arbadhtram.getTrmaildestino());
		}
		if (arbadhtram != null && arbadhtram.getTrfechaenviobopvboe() != null) {
			where.append(" AND t1.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbadhtram.getTrfechaenviobopvboe());
		}
		if (arbadhtram != null && arbadhtram.getTrproceedingsidplatea() != null) {
			where.append(" AND t1.TRPROCEEDINGSIDPLATEA = ?");
			params.add(arbadhtram.getTrproceedingsidplatea());
		}
		if (arbadhtram != null && arbadhtram.getTrmonitor() != null) {
			where.append(" AND t1.TRMONITOR = ?");
			params.add(arbadhtram.getTrmonitor());
		}
		if (arbadhtram != null && arbadhtram.getTrnotcomsolici() != null) {
			where.append(" AND t1.TRNOTCOMSOLICI = ?");
			params.add(arbadhtram.getTrnotcomsolici());
		}
		if (arbadhtram != null && arbadhtram.getTrfecrem() != null) {
			where.append(" AND t1.TRFECREM = ?");
			params.add(arbadhtram.getTrfecrem());
		}
		if (arbadhtram != null && arbadhtram.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(arbadhtram.getTrfecalta());
		}
		if (arbadhtram != null && arbadhtram.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(arbadhtram.getTrfecmodif());
		}
		if (arbadhtram != null && arbadhtram.getTrusualta() != null) {
			where.append(" AND t1.TRUSUALTA = ?");
			params.add(arbadhtram.getTrusualta());
		}
		if (arbadhtram != null && arbadhtram.getTrusumodif() != null) {
			where.append(" AND t1.TRUSUMODIF = ?");
			params.add(arbadhtram.getTrusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhtram entity
	 * 
	 * @param arbadhtram
	 *            Arbadhtram Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbadhtram arbadhtram,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbadhtramDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhtram != null && arbadhtram.getTrid() != null) {
			where.append(" AND t1.TRID = ?");
			params.add(arbadhtram.getTrid());
		}

		if (arbadhtram != null && arbadhtram.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrexcodigo() != null) {
			where.append(" AND t1.TREXCODIGO = ?");
			params.add(arbadhtram.getTrexcodigo());
		}
		if (arbadhtram != null && arbadhtram.getTrfecini() != null) {
			where.append(" AND t1.TRFECINI = ?");
			params.add(arbadhtram.getTrfecini());
		}
		if (arbadhtram != null && arbadhtram.getTrfecfin() != null) {
			where.append(" AND t1.TRFECFIN = ?");
			params.add(arbadhtram.getTrfecfin());
		}
		if (arbadhtram != null && arbadhtram.getTrnomtrames() != null) {
			where.append(" AND UPPER(t1.TRNOMTRAMES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrnomtrames().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrnomtrames().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRNOMTRAMES IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getCensoMonitor() != null
				&& arbadhtram.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t1.TRMOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getCensoMonitor().getMocodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhtram.getCensoMonitor().getMocodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TRMOCODIGO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getCensoMonitorEj() != null
				&& arbadhtram.getCensoMonitorEj().getMocodigo() != null) {
			where.append(" AND UPPER(t1.TRMOCODIGOEJ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getCensoMonitorEj().getMocodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhtram.getCensoMonitorEj().getMocodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TRMOCODIGOEJ IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrresofecha() != null) {
			where.append(" AND t1.TRRESOFECHA = ?");
			params.add(arbadhtram.getTrresofecha());
		}
		if (arbadhtram != null && arbadhtram.getTrresotipo() != null) {
			where.append(" AND UPPER(t1.TRRESOTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrresotipo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrresotipo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRRESOTIPO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrfeccierre() != null) {
			where.append(" AND t1.TRFECCIERRE = ?");
			params.add(arbadhtram.getTrfeccierre());
		}
		if (arbadhtram != null && arbadhtram.getTrfcodigo() != null) {
			where.append(" AND UPPER(t1.TRFCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrfcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrfcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRFCODIGO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrtiponot() != null) {
			where.append(" AND UPPER(t1.TRTIPONOT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrtiponot().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrtiponot().toUpperCase() + "%");
			}
			where.append(" AND t1.TRTIPONOT IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrestado() != null) {
			where.append(" AND UPPER(t1.TRESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrestado().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrestado().toUpperCase() + "%");
			}
			where.append(" AND t1.TRESTADO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrfecnotif() != null) {
			where.append(" AND t1.TRFECNOTIF = ?");
			params.add(arbadhtram.getTrfecnotif());
		}
		if (arbadhtram != null && arbadhtram.getTruaidinterv() != null) {
			where.append(" AND t1.TRUAIDINTERV = ?");
			params.add(arbadhtram.getTruaidinterv());
		}
		if (arbadhtram != null && arbadhtram.getTrcodigorel() != null) {
			where.append(" AND UPPER(t1.TRCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrcodigorel().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrcodigorel().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRCODIGOREL IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTridnotifplatea() != null) {
			where.append(" AND UPPER(t1.TRIDNOTIFPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTridnotifplatea().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTridnotifplatea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRIDNOTIFPLATEA IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrfecregs() != null) {
			where.append(" AND t1.TRFECREGS = ?");
			params.add(arbadhtram.getTrfecregs());
		}
		if (arbadhtram != null && arbadhtram.getTrtipocom() != null) {
			where.append(" AND UPPER(t1.TRTIPOCOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrtipocom().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrtipocom().toUpperCase() + "%");
			}
			where.append(" AND t1.TRTIPOCOM IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrestadoacuse() != null) {
			where.append(" AND UPPER(t1.TRESTADOACUSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrestadoacuse().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrestadoacuse().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRESTADOACUSE IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrnumregs() != null) {
			where.append(" AND UPPER(t1.TRNUMREGS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrnumregs().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrnumregs().toUpperCase() + "%");
			}
			where.append(" AND t1.TRNUMREGS IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrfecacuse() != null) {
			where.append(" AND t1.TRFECACUSE = ?");
			params.add(arbadhtram.getTrfecacuse());
		}
		if (arbadhtram != null && arbadhtram.getTridesperaplatea() != null) {
			where.append(" AND UPPER(t1.TRIDESPERAPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTridesperaplatea().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTridesperaplatea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRIDESPERAPLATEA IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrmatarespera() != null) {
			where.append(" AND UPPER(t1.TRMATARESPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrmatarespera().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrmatarespera().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRMATARESPERA IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrasuntocomunicacion() != null) {
			where.append(" AND UPPER(t1.TRASUNTOCOMUNICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrasuntocomunicacion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhtram.getTrasuntocomunicacion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRASUNTOCOMUNICACION IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrtiponotplatea() != null) {
			where.append(" AND UPPER(t1.TRTIPONOTPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrtiponotplatea().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrtiponotplatea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRTIPONOTPLATEA IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrsede() != null) {
			where.append(" AND UPPER(t1.TRSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrsede().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrsede().toUpperCase() + "%");
			}
			where.append(" AND t1.TRSEDE IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrcodrem() != null) {
			where.append(" AND UPPER(t1.TRCODREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrcodrem().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrcodrem().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODREM IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrenvrem() != null) {
			where.append(" AND UPPER(t1.TRENVREM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrenvrem().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrenvrem().toUpperCase() + "%");
			}
			where.append(" AND t1.TRENVREM IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTridmailorigen() != null) {
			where.append(" AND UPPER(t1.TRIDMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTridmailorigen().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTridmailorigen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRIDMAILORIGEN IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrmailorigen() != null) {
			where.append(" AND UPPER(t1.TRMAILORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrmailorigen().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrmailorigen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRMAILORIGEN IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTridmaildestino() != null) {
			where.append(" AND UPPER(t1.TRIDMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTridmaildestino().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTridmaildestino().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRIDMAILDESTINO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrmaildestino() != null) {
			where.append(" AND UPPER(t1.TRMAILDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrmaildestino().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrmaildestino().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRMAILDESTINO IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrfechaenviobopvboe() != null) {
			where.append(" AND t1.TRFECHAENVIOBOPVBOE = ?");
			params.add(arbadhtram.getTrfechaenviobopvboe());
		}
		if (arbadhtram != null && arbadhtram.getTrproceedingsidplatea() != null) {
			where.append(" AND UPPER(t1.TRPROCEEDINGSIDPLATEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrproceedingsidplatea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhtram.getTrproceedingsidplatea().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRPROCEEDINGSIDPLATEA IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrmonitor() != null) {
			where.append(" AND UPPER(t1.TRMONITOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrmonitor().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrmonitor().toUpperCase() + "%");
			}
			where.append(" AND t1.TRMONITOR IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrnotcomsolici() != null) {
			where.append(" AND UPPER(t1.TRNOTCOMSOLICI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrnotcomsolici().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrnotcomsolici().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TRNOTCOMSOLICI IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrfecrem() != null) {
			where.append(" AND t1.TRFECREM = ?");
			params.add(arbadhtram.getTrfecrem());
		}
		if (arbadhtram != null && arbadhtram.getTrfecalta() != null) {
			where.append(" AND t1.TRFECALTA = ?");
			params.add(arbadhtram.getTrfecalta());
		}
		if (arbadhtram != null && arbadhtram.getTrfecmodif() != null) {
			where.append(" AND t1.TRFECMODIF = ?");
			params.add(arbadhtram.getTrfecmodif());
		}
		if (arbadhtram != null && arbadhtram.getTrusualta() != null) {
			where.append(" AND UPPER(t1.TRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.TRUSUALTA IS NOT NULL");
		}
		if (arbadhtram != null && arbadhtram.getTrusumodif() != null) {
			where.append(" AND UPPER(t1.TRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhtram.getTrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhtram.getTrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.TRUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer(
					"SELECT L21U2Q00.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		} catch (Exception e) {
			ArbadhtramDaoImpl.logger.debug(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Get a New PK. Proceedings Platea
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPKProceedingsPlatea() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer(
					"SELECT L21X2Q03.NEXTVAL FROM  DUAL ");
			return this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		} catch (Exception e) {
			ArbadhtramDaoImpl.logger.debug(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram updateProceedingsIdPlatea(Arbadhtram tramite) {
		String query = "UPDATE ARBADHTRAM SET TRPROCEEDINGSIDPLATEA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, tramite.getTrproceedingsidplatea(),
				tramite.getTrid());
		return tramite;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return boolean
	 */
	@Transactional(readOnly = true)
	public boolean exists(Arbadhtram arbadhtram) {
		String query = "SELECT COUNT(1) FROM ARBADHTRAM WHERE 1=1 AND TRID = ?";

		List<String> params = new ArrayList<String>();
		if (arbadhtram.getTrid() == null) {
			return false;
		}
		params.add(arbadhtram.getTrid().toString());

		Long numResultado = this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
		if (numResultado == null) {
			return false;
		} else {
			return numResultado > 0;
		}
	}

	/**
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram updateMatarEspera(Arbadhtram arbadhtram) {
		String query = "UPDATE ARBADHTRAM SET TRMATARESPERA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbadhtram.getTrmatarespera(),
				arbadhtram.getTrid());
		return arbadhtram;
	}

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram updateIdNotificacionPlatea(Arbadhtram arbadhtram) {
		String query = "UPDATE ARBADHTRAM SET TRIDNOTIFPLATEA=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbadhtram.getTridnotifplatea(),
				arbadhtram.getTrid());
		return arbadhtram;
	}

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram updateRegistroSalidaPlatea(Arbadhtram arbadhtram) {
		String query = "UPDATE ARBADHTRAM SET TRNUMREGS=?, TRFECREGS=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbadhtram.getTrnumregs(),
				arbadhtram.getTrfecregs(), arbadhtram.getTrid());
		return arbadhtram;
	}

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	public NotificacionAcuseRecibo addNotificacionAcuseRecibo(
			NotificacionAcuseRecibo notificacionAcuseRecibo) {
		String query = "INSERT INTO NOTIFICACION_ACUSERECIBO (EHIDNOTIFICACIONPLATEA, EHCODIGOACUSE, EHPCODIGO) VALUES (?,?,?)";
		this.jdbcTemplate.update(query,
				notificacionAcuseRecibo.getEhidnotificacionplatea(),
				notificacionAcuseRecibo.getEhcodigoacuse(),
				notificacionAcuseRecibo.getEhpcodigo());
		return notificacionAcuseRecibo;
	}

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	public Arbadhtram completaAcuseRecibo(Arbadhtram tramitehechoAcuse,
			String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo)
			throws Exception {
		try {
			ArbadhtramDaoImpl.logger.info("completaAcuseRecibo. Inicio");

			Date today = new Date();
			Date todayWithZeroTime = Y41bUtils.parseDate(today, new Locale(
					Y41bConstantes.CASTELLANO));

			ArbadhtramDaoImpl.logger.info("completaAcuseRecibo. Paso1: "
					+ todayWithZeroTime + ".");
			tramitehechoAcuse.setTrfecfin(todayWithZeroTime);
			tramitehechoAcuse
					.setTrestado(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
			tramitehechoAcuse.setTrestadoacuse(situacionNotificacion);
			ArbadhtramDaoImpl.logger.info("completaAcuseRecibo. Paso2: "
					+ todayWithZeroTime + ".");
			if (Y41bUtils.isFilled(deliveredNotificationInfo
					.getDeliveryTimestamp())) {
				try {
					SimpleDateFormat formatterAcuseRecibo = new SimpleDateFormat(
							"yyyy-MM-dd'T'HH:mm:ss");
					Date dateAcuseRecibo = formatterAcuseRecibo
							.parse(deliveredNotificationInfo
									.getDeliveryTimestamp());
					ArbadhtramDaoImpl.logger
							.info("completaAcuseRecibo. Paso3: "
									+ dateAcuseRecibo + ".");
					;
					tramitehechoAcuse.setTrfecacuse(dateAcuseRecibo);
				} catch (Exception e) {
					ArbadhtramDaoImpl.logger.error(
							"Error producido al parsear la fecha del acuse: ",
							e);
					// Si falla el parseo meto la fecha de hoy
					tramitehechoAcuse.setTrfecacuse(todayWithZeroTime);
				}
			} else {
				tramitehechoAcuse.setTrfecacuse(todayWithZeroTime);
			}
			ArbadhtramDaoImpl.logger
					.info("completaAcuseRecibo. Paso4: ANTES DEL UPDATE.");
			this.update(tramitehechoAcuse);
			ArbadhtramDaoImpl.logger.info("completaAcuseRecibo. Fin");
			return tramitehechoAcuse;
		} catch (Exception e) {
			ArbadhtramDaoImpl.logger.error("completaAcuseRecibo. ERROR"
					+ e.getMessage());
			throw e;

		} finally {
			ArbadhtramDaoImpl.logger.info("completaAcuseRecibo. Fin");
		}
	}

	/**
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List<NotificacionesComunicacionesBusqueda>
	 */
	public List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni,
			Pagination pagination) {
		// Nota: en la sql idtramite es el codigo del expediente y codexpediente
		// es el id del tramite
		StringBuilder query = new StringBuilder(
				"SELECT T3.ADHTIPO ADHTIPO, "
						+ "T1.TRID TRID, "
						+ "T3.ADHSOLCOOR||' '||T3.ADHSOLNRAN||' '||T3.ADHSOLNROR idTramite, "
						+ "T3.ADHSOLCOOR EXCOOR, "
						+ "T3.ADHSOLNRAN EXNRAN, "
						+ "T3.ADHSOLNROR EXNROR, "
						+ "T3.ADHID EXCODIGO, "
						+ "T1.TRID CODEXPEDIENTE, "
						+ "T1.TRFECINI TRFECINI, "
						+ "T1.TRFECINI EHFECHAINICIO, "
						+ "T1.TRNUMREGS EHNUMREGISTROSALIDA, "
						// " T1.TRASUNTOCOMUNICACION ASUNTO, "+
						// " T1.TRASUNTOCOMUNICACION ACTO, "+
						+ "T9.TRESTADO EHESTADOTRAMITE, "
						+ "T1.TRTIPONOTPLATEA ACTO, "
						+ "T1.TRUAIDINTERV UAIDINTERV, "
						+ "T1.TRUAIDINTERV  EHIDDESTINATARIO, "
						+ "T1.TRMOCODIGOEJ, "
						+ "T1.TRTIPONOTPLATEA EHTIPONOTIFICACIONPLATEA, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESNOM,T3.ADHESNOM),T2.UANOMBRE) UANOMBRE, DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHNIF,T3.ADHNIF),T2.UANIF) NIF, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESNOM,T3.ADHESNOM),T2.UANOMBRE) AS NOMBREDESTINATARIO, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESNOCO,T3.ADHESNOCO),T2.UANOCO) AS NOMBRECOMERCIALDESTINATARIO, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESNOMBRECP,T3.ADHESNOMBRECP),T2.UACP_ID) AS NOMBRE_CP, "
						+ "(SELECT DS_O FROM T17I.T17_PROVINCIA WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESPROVIN,T3.ADHESPROVIN),T2.UAPROV_ID) = ID) AS NOMBRE_PROVINCIA, "
						+ "(SELECT DS_O FROM T17I.T17_MUNICIPIO WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESPROVIN,T3.ADHESPROVIN),T2.UAPROV_ID) = PROVINCIA_ID AND DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESMUNICI,T3.ADHESMUNICI),T2.UAMUN_ID) = ID) AS NOMBRE_MUNICIPIO, "
						+ "(SELECT DS_O FROM T17I.T17_LOCALIDAD WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESLOCALI,T3.ADHESLOCALI),T2.UALOC_ID) = ID) AS NOMBRE_LOCALIDAD, "
						+ "(SELECT TIPO_VIA||' '||DS_O FROM T17I.T17_CALLE WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESCALLE,T3.ADHESCALLE),T2.UACALLE_ID) = ID) AS NOMBRE_CALLE, "
						+ "(SELECT NUMERO||(CASE WHEN BIS IS NULL THEN '' ELSE '-' || BIS END) FROM T17I.T17_PORTAL WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESPORTAL,T3.ADHESPORTAL),T2.UAPORTAL_ID) = ID) AS NOMBREPORTAL, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESPISO,T3.ADHESPISO),T2.UANOMBRE_PISO) AS NOMBREPISO, "
						+ "(SELECT DS_O FROM T17I.T17_PAIS WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESPAISID,T3.ADHESPAISID),T2.UAPAIS_ID) = ID) AS NOMBREPAIS, "
						+ "((SELECT TIPO_VIA||' '||DS_O FROM T17I.T17_CALLE WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESCALLE,T3.ADHESCALLE),T2.UACALLE_ID) = ID)||' '||(SELECT NUMERO||(CASE WHEN BIS IS NULL THEN '' ELSE '-' || BIS END) FROM T17I.T17_PORTAL WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESPORTAL,T3.ADHESPORTAL),T2.UAPORTAL_ID) = ID)) AS DIRECCION1, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESNOMBRECP,T3.ADHESNOMBRECP),T2.UACP_ID)||' '||(SELECT DS_O FROM T17I.T17_LOCALIDAD WHERE DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESLOCALI,T3.ADHESLOCALI),T2.UALOC_ID) = ID) AS DIRECCION2, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESDIRECNOCAPV,T3.ADHESDIRECNOCAPV),T2.UADIRE_NOCAPV) AS DIRECCIONNOCAPV, "
						+ "DECODE(T1.TRUAIDINTERV,-1,'',T2.UADIRE_ANT) AS DIRECCIONANTIGUA, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESEXTRANJERO,T3.ADHESEXTRANJERO),DECODE(NVL(T2.UAPAIS_ID,"
						+ Y41bConstantes.COD_PAIS_ESTADO
						+ "),"
						+ Y41bConstantes.COD_PAIS_ESTADO
						+ ",'"
						+ Y41bConstantes.NO
						+ "','"
						+ Y41bConstantes.SI
						+ "')) AS EXTRANJERO, "
						+ "DECODE(T1.TRUAIDINTERV,-1,'F',T2.UATIPOINTERV) TIPOINTERVINIENTE, "
						+ "T1.TRSEDE EHSEDE, "
						+ "DECODE(T1.TRUAIDINTERV,-1,NVL2(T4.ADHID,T4.ADHESCODIGO,T3.ADHESCODIGO),T2.UAESCODIGO) ESCODIGO, "
						+ "T5.MONOMBRE MONOMBRE, T1.TRASUNTOCOMUNICACION, "
						+ " T7.COD_ORG CODORG, T7.NOMBRE_ES NOMBREES, T7.NOMBRE_EU NOMBREEU,  T7.NORA_PROVINCIA_ID NORAPROVINCIAID, T7.NOMBRE_PROVINCIA NOMBREPROVINCIAORG, T7.NORA_MUNICIPIO_ID NORAMUNICIPIOID, T7.NOMBRE_MUNICIPIO NOMBREMUNICIPIOORG, "
						+ " T7.NORA_LOCALIDAD_ID NORALOCALIDADID, T7.NOMBRE_LOCALIDAD NOMBRELOCALIDADORG, T7.NORA_CALLE_ID NORACALLEID, T7.NOMBRE_CALLE NOMBRECALLEORG, T7.NORA_CP_ID NORACPID, T7.NOMBRE_CP NOMBRECPORG, T7.NORA_PORTAL_ID NORAPORTALID, "
						+ " T7.NOMBRE_PORTAL NOMBREPORTALORG, T7.TELEFONO TELEFONOORGANISMO, T7.FAX FAXORGANISMO, T7.EMAIL EMAILORGANISMO, T7.URL WEBORGANISMO, "
						+ " T1.TRCODIGO TRCODIGO, T1.TRID EHCODIGO, T5.USUARIOXLNET USUARIOXLNET, T5.PUESTOXLNET PUESTOXLNET, "
						+ " T8.ENVCESTADO ENVCESTADO, T8.ENVCDESERRORES ENVCDESERRORES, T8.ENVCDESERROREU ENVCDESERROREU, T8.ENVC_ID_ENVIO ENVCIDENVIO, T8.ENVCCOD_SIT_CORREOS ENVCCODSITCORREOS, T8.ENVCDES_SIT_CORREOS_ES ENVCDESSITCORREOSES, T8.ENVCDES_SIT_CORREOS_EU ENVCDESSITCORREOSEU, "
						+ " T8.ENVFECHAACTUALIZACION ENVFECHAACTUALIZACION, T8.ENVCCODBARRAS ENVCCODBARRAS,"
						+ " T9.TRID IDTRAMITEACUSERELACIONADO, T9.TRESTADOACUSE EHACUSERECIBORECIBIDO"
						+ " FROM ARBADHTRAM T1, ARBADHINTERV T2, ARBADHSOL T3, ARBADHSOLTEMP T4, CENSO_MONITOR T5, ORGANISMO T7, ENVIOS_POR_REMESA T8, ARBADHTRAM T9 ");

		Map<String, ?> mapaWhere = this
				.getWhereMapNotifiComunica(filterNotifComuni);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TRUAIDINTERV=T2.UAIDINTERV(+) AND T3.ADHID = T1.TREXCODIGO AND T1.TREXCODIGO=T4.ADHID(+) AND T1.TRMOCODIGOEJ = T5.MOCODIGO AND t3.ADHSOLCOOR= t7.COD_ORG  AND T1.TRCODIGO IN ('"
						+ Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA
						+ "') "
						+ " AND to_char(T1.TRID) = T8.EHCODIGO(+) "
						+ " AND T1.TRID = T9.TRTRIDREL(+) "); // T9 seria el
																// tramite de
																// acuse
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate
				.query(query.toString(), this.rwMapNotifiComunica,
						params.toArray());
	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMapNotifiComunica(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder where = new StringBuilder(
				SantramexpDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (!Y41bUtils.esNullOCadenaVacia(notificacionComunicacionDetalle
				.getTipoProcedimiento())) {
			if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA
					.equals(notificacionComunicacionDetalle
							.getTipoProcedimiento())) {
				where.append(" AND T3.ADHTIPO = ? ");
				params.add(Y41bConstantes.ADH_TIPO_ALTA);
			} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA
					.equals(notificacionComunicacionDetalle
							.getTipoProcedimiento())) {
				where.append(" AND (T3.ADHTIPO = ? OR T3.ADHTIPO = ?) ");
				params.add(Y41bConstantes.ADH_TIPO_BAJA);
				params.add(Y41bConstantes.ADH_TIPO_BAJA_OFICIO);
			} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_MOD
					.equals(notificacionComunicacionDetalle
							.getTipoProcedimiento())) {
				where.append(" AND T3.ADHTIPO = ? ");
				params.add(Y41bConstantes.ADH_TIPO_MODIF);
			}
		}

		if (notificacionComunicacionDetalle != null
				&& notificacionComunicacionDetalle.getRmcodigo() == null) {
			where.append(" AND T1.TRENVREM=? ");
			params.add(Y41bConstantes.SI);

			where.append(" AND T1.TRESTADO=? ");
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			where.append(" AND T1.TRCODREM IS NULL ");
		}
		if (notificacionComunicacionDetalle != null
				&& notificacionComunicacionDetalle.getRmcodigo() != null) {
			where.append(" AND T1.TRCODREM = ? ");
			params.add(notificacionComunicacionDetalle.getRmcodigo());

		}

		if (notificacionComunicacionDetalle.getRmtipo() != null
				&& notificacionComunicacionDetalle.getModoRemesa() != null
				&& notificacionComunicacionDetalle.getModoRemesa()
						.equalsIgnoreCase(Y41bConstantes.MODO_POPUP_ALTA)) {
			String tipo = notificacionComunicacionDetalle.getRmtipo();
			if (tipo.contains(Y41bConstantes.TRAMITE_NOTIFICACION)) {
				if (notificacionComunicacionDetalle.isCompatibleAA66()) {
					if (tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
						where.append(" AND (T2.UAPAIS_ID IS NULL OR T2.UAPAIS_ID = '");
						where.append(Y41bConstantes.COD_PAIS_ESTADO);
						where.append("')");
					} else {
						where.append(" AND T2.UAPAIS_ID<> '");
						where.append(Y41bConstantes.COD_PAIS_ESTADO);
						where.append("' ");
					}
				}
				tipo = Y41bConstantes.TRAMITE_NOTIFICACION;
			}
			where.append(" AND T1.TRCODIGO IN ('");
			if (tipo.equals(Y41bConstantes.TRAMITE_COMUNICACION)) {
				where.append(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA);
				where.append("','");
				where.append(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD);
				where.append("','");
				where.append(Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA);
			} else if (tipo.equals(Y41bConstantes.TRAMITE_NOTIFICACION)
					|| tipo.equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {
				where.append(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA);
				where.append("','");
				where.append(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD);
				where.append("','");
				where.append(Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA);
			}
			where.append("')");
		}
		if (notificacionComunicacionDetalle != null
				&& notificacionComunicacionDetalle.isRmcapv() != null) {
			where.append(" AND T3.ADHESPROVINCI IN ('48','01','20') ");
		}
		if (notificacionComunicacionDetalle != null
				/* && notificacionComunicacionDetalle.getRmorganico() != null */
				&& !Y41bUtils
						.esNullOCadenaVacia(notificacionComunicacionDetalle
								.getRmorganico())) {
			where.append(" AND T3.ADHSOLCOOR = ? ");
			params.add(notificacionComunicacionDetalle.getRmorganico());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param notificacionComunicacionDetalle
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findAllNotifiComuniCount(
			NotificacionesComunicacionesBusqueda notificacionComunicacionDetalle) {

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHTRAM T1, ARBADHINTERV T2, ARBADHSOL T3, CENSO_MONITOR T5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapNotifiComunica(notificacionComunicacionDetalle);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND T1.TRUAIDINTERV=T2.UAIDINTERV(+) AND T3.ADHID = T1.TREXCODIGO AND T1.TRMOCODIGOEJ = T5.MOCODIGO AND T1.TRCODIGO IN ('"
						+ Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_ALTA
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_MOD
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_NOTIFICACION_BAJA
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_ALTA
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_MOD
						+ "','"
						+ Y41bConstantes.TRAMITE_ADHESION_COMUNICACION_BAJA
						+ "') ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(readOnly = true)
	public List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni) {
		try {
			String query = "SELECT T2.TRCODREM DHCODREM, T2.TRID DHTRCODIGO, T1.X5CODOCUMENTO DHCODDOC, T1.X5DATAFILE DHDATAFILE, NULL DHFECHA, T1.X5IDDOCUMENTUM "
					+ " FROM ARBADHDOC T1, ARBADHTRAM T2, ARBADHDOCTRAM T3 WHERE T3.EHCODIGO = T2.TRID AND T3.TRPCODIGO=? AND T1.X5CODOCUMENTO = T3.CODOCUMENTO AND T2.TRCODREM = ? ";

			return (List<NotificacionesComunicacionesBusqueda>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<NotificacionesComunicacionesBusqueda>() {
								public NotificacionesComunicacionesBusqueda mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new NotificacionesComunicacionesBusqueda(
											resultSet.getString("DHCODREM"),
											resultSet.getString("DHTRCODIGO"),
											resultSet.getString("DHCODDOC"),
											resultSet.getBlob("DHDATAFILE"),
											resultSet
													.getString("X5IDDOCUMENTUM"));
								}
							}, notifiComuni.getRmtipoExpediente(), notifiComuni
									.getRmcodigo());

		} catch (EmptyResultDataAccessException e) {
			return null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbadhsolDao#updateRemesa(com.ejie.y41b.model.Arbadhsol
	 * )
	 */
	@Override
	public Arbadhtram updateRemesa(Arbadhtram arbadhtram) {
		String query = "UPDATE ARBADHTRAM SET TRCODREM=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbadhtram.getTrcodrem(),
				arbadhtram.getTrid());
		return arbadhtram;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbadhsolDao#removeRemesaFromTramitesByEhcodigo(java
	 * .lang.String)
	 */
	@Override
	public void removeRemesaFromTramitesByEhcodigo(String idTramite) {
		String query = "UPDATE ARBADHTRAM SET TRCODREM = NULL WHERE TRID=?";

		this.jdbcTemplate.update(query, idTramite);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbadhsolDao#removeRemesaFromTramites(java.lang.String)
	 */
	@Override
	public void removeRemesaFromTramites(String rmcodigo) {
		String query = "UPDATE ARBADHTRAM SET TRCODREM = NULL WHERE TRCODREM=?";

		this.jdbcTemplate.update(query, rmcodigo);
	}

	/**
	 * Mtodo para actualizar el reintento del acuse
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	public Arbadhtram updateAcuseReintentado(Arbadhtram arbadhtram) {
		String query = "UPDATE ARBADHTRAM SET TRACUSEREINTENTADO=? WHERE TRID=?";

		this.jdbcTemplate.update(query, arbadhtram.getTracusereintentado(),
				arbadhtram.getTrid());
		return arbadhtram;
	}

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findSumSizeBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda notifiComuni) {

		String query = "SELECT SUM(T1.X5SIZEFILE) TAMANO "
				+ " FROM ARBADHDOC T1, ARBADHTRAM T2, ARBADHDOCTRAM T3 WHERE T3.EHCODIGO = T2.TRID AND T3.TRPCODIGO=? AND T1.X5CODOCUMENTO = T3.CODOCUMENTO AND T2.TRCODREM = ? ";

		List<Object> params = new ArrayList<Object>();
		params.add(notifiComuni.getRmtipoExpediente());
		params.add(notifiComuni.getRmcodigo());

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
