package com.ejie.y41b.dao;

import com.ejie.horizontalSystemOfNotification.xml.DeliveredNotificationInfoDocument.DeliveredNotificationInfo;
import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbadhtram;
import com.ejie.y41b.model.NotificacionAcuseRecibo;
import com.ejie.y41b.model.NotificacionesComunicacionesBusqueda;

/**
 * ArbadhtramDao  
 * 
 *  
 */

public interface ArbadhtramDao {

	/**
	 * Inserts a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram add(Arbadhtram arbadhtram);

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram update(Arbadhtram arbadhtram);

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram find(Arbadhtram arbadhtram);

	/**
	 * Finds a Single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param codocumento
	 *            String
	 * @return Long
	 */
	Long findDocTramiteResolucion(Arbadhtram arbadhtram, String codocumento);

	/**
	 * Deletes a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return
	 */
	void remove(Arbadhtram arbadhtram);

	/**
	 * Finds a List of rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhtram> findAll(Arbadhtram arbadhtram, Pagination pagination);

	/**
	 * Counts rows in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Long
	 */
	Long findAllCount(Arbadhtram arbadhtram);

	/**
	 * Finds rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhtram> findAllLike(Arbadhtram arbadhtram, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbadhtram table using like.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhtram arbadhtram, Boolean startsWith);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Get a New PK. Proceedings Platea
	 * 
	 * @return Long
	 */
	Long getNewPKProceedingsPlatea();

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramite
	 *            Arbtramexp
	 * @return Arbtramexp
	 */
	Arbadhtram updateProceedingsIdPlatea(Arbadhtram tramite);

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return boolean
	 */
	boolean exists(Arbadhtram arbadhtram);

	/**
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram updateMatarEspera(Arbadhtram arbadhtram);

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram updateIdNotificacionPlatea(Arbadhtram arbadhtram);

	/**
	 * Updates a single row in the Arbadhtram table.
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram updateRegistroSalidaPlatea(Arbadhtram arbadhtram);

	/**
	 * Inserts a single row in the NotificacionAcuseRecibo table.
	 * 
	 * @param notificacionAcuseRecibo
	 *            NotificacionAcuseRecibo
	 * @return NotificacionAcuseRecibo
	 */
	NotificacionAcuseRecibo addNotificacionAcuseRecibo(
			NotificacionAcuseRecibo notificacionAcuseRecibo);

	/**
	 * Completa acuse recibo.
	 * 
	 * @param tramitehechoAcuse
	 *            the tramitehecho acuse
	 * @param situacionNotificacion
	 *            the situacion notificacion
	 * @param deliveredNotificationInfo
	 *            the delivered notification info
	 * @return the tramite hecho
	 * @throws Exception
	 *             the exception
	 */
	Arbadhtram completaAcuseRecibo(Arbadhtram tramitehechoAcuse,
			String situacionNotificacion,
			DeliveredNotificationInfo deliveredNotificationInfo)
			throws Exception;

	/**
	 * @param filterNotifComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List<NotificacionesComunicacionesBusqueda>
	 */
	List<NotificacionesComunicacionesBusqueda> findAllNotifiComuni(
			NotificacionesComunicacionesBusqueda filterNotifComuni,
			Pagination pagination);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	List<NotificacionesComunicacionesBusqueda> findBlobTablaDocumentosHecho(
			NotificacionesComunicacionesBusqueda notifiComuni);

	/**
	 * @param filterNotifComuni
	 * @return
	 */
	Long findAllNotifiComuniCount(
			NotificacionesComunicacionesBusqueda filterNotifComuni);

	/**
	 * @param arbadhtram
	 * @return
	 */
	Arbadhtram updateRemesa(Arbadhtram arbadhtram);

	/**
	 * @param idTramite
	 */
	void removeRemesaFromTramitesByEhcodigo(String idTramite);

	/**
	 * @param rmcodigo
	 */
	void removeRemesaFromTramites(String rmcodigo);

	/**
	 * Mtodo para actualizar el reintento del acuse
	 * 
	 * @param arbadhtram
	 *            Arbadhtram
	 * @return Arbadhtram
	 */
	Arbadhtram updateAcuseReintentado(Arbadhtram arbadhtram);

	/**
	 * Finds a single row in the Arbadhtram table.
	 * 
	 * @param notifiComuni
	 *            NotificacionesComunicacionesBusqueda
	 * @return Long
	 */
	public Long findSumSizeBlobNotifiComuni(
			NotificacionesComunicacionesBusqueda notifiComuni);

}
