package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import ch.qos.logback.classic.Logger;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhsolcomdoc;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * ArbadhsolcomdocDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbadhsolcomdocDaoImpl implements ArbadhsolcomdocDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = (Logger) LoggerFactory
			.getLogger(ArbadhsolcomdocDaoImpl.class);

	private RowMapper<Arbadhsolcomdoc> rwMap = new RowMapper<Arbadhsolcomdoc>() {
		public Arbadhsolcomdoc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbadhsolcomdoc(resultSet.getString("XMCODOCUMENTO"),
					resultSet.getString("XMEXCODIGO"),
					resultSet.getString("XMNOFILE"),
					resultSet.getBlob("XMDATAFILE"),
					resultSet.getInt("XMSIZEFILE"),
					resultSet.getString("XMTEDESFILE"),
					resultSet.getString("XMORIGEN"),
					resultSet.getLong("XMTRAMITE"),
					resultSet.getDate("XMFECHA"),
					resultSet.getString("XMCONTTYPE"),
					resultSet.getString("XMINDMAIL"),
					resultSet.getString("XMTRMAIL"),
					resultSet.getString("XMIDDOCUMENTUM"),
					resultSet.getString("XMTIPODOCUMENTO"),
					resultSet.getDate("XMFECHAAPORTACION"),
					resultSet.getDate("XMFECHAENTRADA"),
					resultSet.getString("XMNUMREGISTROENTRADA"),
					resultSet.getString("XMIDPERFILFIRMA"),
					resultSet.getString("XMESTADODOCUMENTO"),
					resultSet.getDate("XMFECHASOLFIRMA"),
					resultSet.getDate("XMFECHAFIRMA"),
					resultSet.getString("XMCOMOFIRMA"),
					resultSet.getDate("XMFECHALIMFIRMA"),
					resultSet.getString("XMDESTINO"),
					resultSet.getString("XMPTCODIGO"),
					resultSet.getTimestamp("XMFECHASOLLOCALIZADOR"),
					resultSet.getString("XMNUMREGISTROORIGEN"),
					resultSet.getDate("XMFECHAREGISTROORIGEN"),
					resultSet.getDate("XMFECALTA"),
					resultSet.getDate("XMFECMODIF"),
					resultSet.getString("XMUSUALTA"),
					resultSet.getString("XMUSUMODIF"));
		}
	};

	private RowMapper<DocumentoExpediente> rwMapDocExp = new RowMapper<DocumentoExpediente>() {
		public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new DocumentoExpediente(
					resultSet.getString("XMCODOCUMENTO"),
					resultSet.getString("XMEXCODIGO"),
					resultSet.getString("XMNOFILE"), null,
					resultSet.getInt("XMSIZEFILE"),
					resultSet.getString("XMCONTTYPE"),
					resultSet.getString("XMTEDESFILE"),
					resultSet.getString("XMORIGEN"),
					resultSet.getDate("XMFECHA"),
					resultSet.getString("XMIDDOCUMENTUM"), null, null, null,
					resultSet.getString("IDTIPODOC"),
					resultSet.getString("TDNOMBRE"),
					resultSet.getString("TDNOMBREE"), null, null, null, null,
					null, null, null, null);

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Pagination
	 * @return Arbadhsolcomdoc
	 */
	public Arbadhsolcomdoc add(Arbadhsolcomdoc arbadhsolcomdoc) {
		String query = "INSERT INTO ARBADHSOLCOMDOC (XMCODOCUMENTO, XMEXCODIGO, XMNOFILE, XMDATAFILE, XMSIZEFILE, XMTEDESFILE, XMORIGEN, XMTRAMITE, XMFECHA, XMCONTTYPE, XMINDMAIL, XMTRMAIL, XMIDDOCUMENTUM, XMTIPODOCUMENTO, XMFECHAAPORTACION, XMFECHAENTRADA, XMNUMREGISTROENTRADA, XMID_PERFILFIRMA, XMESTADODOCUMENTO, XMFECHASOLFIRMA, XMFECHAFIRMA, XMCOMOFIRMA, XMFECHALIMFIRMA, XMDESTINO, XMPTCODIGO, XMFECHASOLLOCALIZADOR, XMNUMREGISTROORIGEN, XMFECHAREGISTROORIGEN, XMFECALTA, XMFECMODIF, XMUSUALTA, XMUSUMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate
				.update(query, arbadhsolcomdoc.getXmcodocumento(),
						arbadhsolcomdoc.getXmexcodigo(),
						arbadhsolcomdoc.getXmnofile(),
						arbadhsolcomdoc.getXmdatafile(),
						arbadhsolcomdoc.getXmsizefile(),
						arbadhsolcomdoc.getXmtedesfile(),
						arbadhsolcomdoc.getXmorigen(),
						arbadhsolcomdoc.getXmtramite(),
						arbadhsolcomdoc.getXmfecha(),
						arbadhsolcomdoc.getXmconttype(),
						arbadhsolcomdoc.getXmindmail(),
						arbadhsolcomdoc.getXmtrmail(),
						arbadhsolcomdoc.getXmiddocumentum(),
						arbadhsolcomdoc.getXmtipodocumento(),
						arbadhsolcomdoc.getXmfechaaportacion(),
						arbadhsolcomdoc.getXmfechaentrada(),
						arbadhsolcomdoc.getXmnumregistroentrada(),
						arbadhsolcomdoc.getXmidPerfilfirma(),
						arbadhsolcomdoc.getXmestadodocumento(),
						arbadhsolcomdoc.getXmfechasolfirma(),
						arbadhsolcomdoc.getXmfechafirma(),
						arbadhsolcomdoc.getXmcomofirma(),
						arbadhsolcomdoc.getXmfechalimfirma(),
						arbadhsolcomdoc.getXmdestino(),
						arbadhsolcomdoc.getXmptcodigo(),
						arbadhsolcomdoc.getXmfechasollocalizador(),
						arbadhsolcomdoc.getXmnumregistroorigen(),
						arbadhsolcomdoc.getXmfecharegistroorigen(),
						arbadhsolcomdoc.getXmfecalta(),
						arbadhsolcomdoc.getXmfecmodif(),
						arbadhsolcomdoc.getXmusualta(),
						arbadhsolcomdoc.getXmusumodif());
		return arbadhsolcomdoc;
	}

	/**
	 * Updates a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Pagination
	 * @return Arbadhsolcomdoc
	 */
	public Arbadhsolcomdoc update(Arbadhsolcomdoc arbadhsolcomdoc) {
		String query = "UPDATE ARBADHSOLCOMDOC SET XMEXCODIGO=?, XMNOFILE=?, XMDATAFILE=?, XMSIZEFILE=?, XMTEDESFILE=?, XMORIGEN=?, XMTRAMITE=?, XMFECHA=?, XMCONTTYPE=?, XMINDMAIL=?, XMTRMAIL=?, XMIDDOCUMENTUM=?, XMTIPODOCUMENTO=?, XMFECHAAPORTACION=?, XMFECHAENTRADA=?, XMNUMREGISTROENTRADA=?, XMID_PERFILFIRMA=?, XMESTADODOCUMENTO=?, XMFECHASOLFIRMA=?, XMFECHAFIRMA=?, XMCOMOFIRMA=?, XMFECHALIMFIRMA=?, XMDESTINO=?, XMPTCODIGO=?, XMFECHASOLLOCALIZADOR=?, XMNUMREGISTROORIGEN=?, XMFECHAREGISTROORIGEN=?, XMFECALTA=?, XMFECMODIF=?, XMUSUALTA=?, XMUSUMODIF=? WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhsolcomdoc.getXmexcodigo(),
				arbadhsolcomdoc.getXmnofile(), arbadhsolcomdoc.getXmdatafile(),
				arbadhsolcomdoc.getXmsizefile(),
				arbadhsolcomdoc.getXmtedesfile(),
				arbadhsolcomdoc.getXmorigen(), arbadhsolcomdoc.getXmtramite(),
				arbadhsolcomdoc.getXmfecha(), arbadhsolcomdoc.getXmconttype(),
				arbadhsolcomdoc.getXmindmail(), arbadhsolcomdoc.getXmtrmail(),
				arbadhsolcomdoc.getXmiddocumentum(),
				arbadhsolcomdoc.getXmtipodocumento(),
				arbadhsolcomdoc.getXmfechaaportacion(),
				arbadhsolcomdoc.getXmfechaentrada(),
				arbadhsolcomdoc.getXmnumregistroentrada(),
				arbadhsolcomdoc.getXmidPerfilfirma(),
				arbadhsolcomdoc.getXmestadodocumento(),
				arbadhsolcomdoc.getXmfechasolfirma(),
				arbadhsolcomdoc.getXmfechafirma(),
				arbadhsolcomdoc.getXmcomofirma(),
				arbadhsolcomdoc.getXmfechalimfirma(),
				arbadhsolcomdoc.getXmdestino(),
				arbadhsolcomdoc.getXmptcodigo(),
				arbadhsolcomdoc.getXmfechasollocalizador(),
				arbadhsolcomdoc.getXmnumregistroorigen(),
				arbadhsolcomdoc.getXmfecharegistroorigen(),
				arbadhsolcomdoc.getXmfecalta(),
				arbadhsolcomdoc.getXmfecmodif(),
				arbadhsolcomdoc.getXmusualta(),
				arbadhsolcomdoc.getXmusumodif(),
				arbadhsolcomdoc.getXmcodocumento());
		return arbadhsolcomdoc;
	}

	/**
	 * Finds a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Pagination
	 * @return Arbadhsolcomdoc
	 */
	@Transactional(readOnly = true)
	public Arbadhsolcomdoc find(Arbadhsolcomdoc arbadhsolcomdoc) {
		String query = "SELECT t1.XMCODOCUMENTO XMCODOCUMENTO, t1.XMEXCODIGO XMEXCODIGO, t1.XMNOFILE XMNOFILE, t1.XMDATAFILE XMDATAFILE, t1.XMSIZEFILE XMSIZEFILE, t1.XMTEDESFILE XMTEDESFILE, t1.XMORIGEN XMORIGEN, t1.XMTRAMITE XMTRAMITE, t1.XMFECHA XMFECHA, t1.XMCONTTYPE XMCONTTYPE, t1.XMINDMAIL XMINDMAIL, t1.XMTRMAIL XMTRMAIL, t1.XMIDDOCUMENTUM XMIDDOCUMENTUM, t1.XMTIPODOCUMENTO XMTIPODOCUMENTO, t1.XMFECHAAPORTACION XMFECHAAPORTACION, t1.XMFECHAENTRADA XMFECHAENTRADA, t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA, t1.XMID_PERFILFIRMA XMIDPERFILFIRMA, t1.XMESTADODOCUMENTO XMESTADODOCUMENTO, t1.XMFECHASOLFIRMA XMFECHASOLFIRMA, t1.XMFECHAFIRMA XMFECHAFIRMA, t1.XMCOMOFIRMA XMCOMOFIRMA, t1.XMFECHALIMFIRMA XMFECHALIMFIRMA, t1.XMDESTINO XMDESTINO, t1.XMPTCODIGO XMPTCODIGO, t1.XMFECHASOLLOCALIZADOR XMFECHASOLLOCALIZADOR, t1.XMNUMREGISTROORIGEN XMNUMREGISTROORIGEN, t1.XMFECHAREGISTROORIGEN XMFECHAREGISTROORIGEN, t1.XMFECALTA XMFECALTA, t1.XMFECMODIF XMFECMODIF, t1.XMUSUALTA XMUSUALTA, t1.XMUSUMODIF XMUSUMODIF FROM ARBADHSOLCOMDOC t1  WHERE t1.XMCODOCUMENTO = ?  ";

		List<Arbadhsolcomdoc> arbadhsolcomdocList = this.jdbcTemplate.query(
				query, this.rwMap, arbadhsolcomdoc.getXmcodocumento());
		return (Arbadhsolcomdoc) DataAccessUtils
				.uniqueResult(arbadhsolcomdocList);
	}

	/**
	 * Removes a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Pagination
	 * @return
	 */
	public void remove(Arbadhsolcomdoc arbadhsolcomdoc) {
		String query = "DELETE FROM ARBADHSOLCOMDOC WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhsolcomdoc.getXmcodocumento());
	}

	/**
	 * Finds a List of rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsolcomdoc> findAll(Arbadhsolcomdoc arbadhsolcomdoc,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT  t1.XMCODOCUMENTO XMCODOCUMENTO,t1.XMEXCODIGO XMEXCODIGO,t1.XMNOFILE XMNOFILE,null XMDATAFILE,t1.XMSIZEFILE XMSIZEFILE,t1.XMTEDESFILE XMTEDESFILE,t1.XMORIGEN XMORIGEN,t1.XMTRAMITE XMTRAMITE,t1.XMFECHA XMFECHA,t1.XMCONTTYPE XMCONTTYPE,t1.XMINDMAIL XMINDMAIL,t1.XMTRMAIL XMTRMAIL,t1.XMIDDOCUMENTUM XMIDDOCUMENTUM,t1.XMTIPODOCUMENTO XMTIPODOCUMENTO,t1.XMFECHAAPORTACION XMFECHAAPORTACION,t1.XMFECHAENTRADA XMFECHAENTRADA,t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA,t1.XMID_PERFILFIRMA XMIDPERFILFIRMA,t1.XMESTADODOCUMENTO XMESTADODOCUMENTO,t1.XMFECHASOLFIRMA XMFECHASOLFIRMA,t1.XMFECHAFIRMA XMFECHAFIRMA,t1.XMCOMOFIRMA XMCOMOFIRMA,t1.XMFECHALIMFIRMA XMFECHALIMFIRMA,t1.XMDESTINO XMDESTINO,t1.XMPTCODIGO XMPTCODIGO,t1.XMFECHASOLLOCALIZADOR XMFECHASOLLOCALIZADOR,t1.XMNUMREGISTROORIGEN XMNUMREGISTROORIGEN,t1.XMFECHAREGISTROORIGEN XMFECHAREGISTROORIGEN,t1.XMFECALTA XMFECALTA,t1.XMFECMODIF XMFECMODIF,t1.XMUSUALTA XMUSUALTA,t1.XMUSUMODIF XMUSUMODIF ");
		query.append("FROM ARBADHSOLCOMDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhsolcomdoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<Arbadhsolcomdoc>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());

	}

	/**
	 * Counts rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbadhsolcomdoc arbadhsolcomdoc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHSOLCOMDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhsolcomdoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbadhsolcomdoc table using like.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsolcomdoc> findAllLike(Arbadhsolcomdoc arbadhsolcomdoc,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.XMCODOCUMENTO XMCODOCUMENTO,t1.XMEXCODIGO XMEXCODIGO,t1.XMNOFILE XMNOFILE,null XMDATAFILE,t1.XMSIZEFILE XMSIZEFILE,t1.XMTEDESFILE XMTEDESFILE,t1.XMORIGEN XMORIGEN,t1.XMTRAMITE XMTRAMITE,t1.XMFECHA XMFECHA,t1.XMCONTTYPE XMCONTTYPE,t1.XMINDMAIL XMINDMAIL,t1.XMTRMAIL XMTRMAIL,t1.XMIDDOCUMENTUM XMIDDOCUMENTUM,t1.XMTIPODOCUMENTO XMTIPODOCUMENTO,t1.XMFECHAAPORTACION XMFECHAAPORTACION,t1.XMFECHAENTRADA XMFECHAENTRADA,t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA,t1.XMID_PERFILFIRMA XMIDPERFILFIRMA,t1.XMESTADODOCUMENTO XMESTADODOCUMENTO,t1.XMFECHASOLFIRMA XMFECHASOLFIRMA,t1.XMFECHAFIRMA XMFECHAFIRMA,t1.XMCOMOFIRMA XMCOMOFIRMA,t1.XMFECHALIMFIRMA XMFECHALIMFIRMA,t1.XMDESTINO XMDESTINO,t1.XMPTCODIGO XMPTCODIGO,t1.XMFECHASOLLOCALIZADOR XMFECHASOLLOCALIZADOR,t1.XMNUMREGISTROORIGEN XMNUMREGISTROORIGEN,t1.XMFECHAREGISTROORIGEN XMFECHAREGISTROORIGEN,t1.XMFECALTA XMFECALTA,t1.XMFECMODIF XMFECMODIF,t1.XMUSUALTA XMUSUALTA,t1.XMUSUMODIF XMUSUMODIF ");
		query.append("FROM ARBADHSOLCOMDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhsolcomdoc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhsolcomdoc>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhsolcomdoc table using like.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbadhsolcomdoc arbadhsolcomdoc,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHSOLCOMDOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhsolcomdoc,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhsolcomdoc entity
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbadhsolcomdoc arbadhsolcomdoc) {

		StringBuilder where = new StringBuilder(
				ArbadhsolcomdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmcodocumento() != null) {
			where.append(" AND t1.XMCODOCUMENTO = ?");
			params.add(arbadhsolcomdoc.getXmcodocumento());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmexcodigo() != null) {
			where.append(" AND t1.XMEXCODIGO = ?");
			params.add(arbadhsolcomdoc.getXmexcodigo());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmnofile() != null) {
			where.append(" AND t1.XMNOFILE = ?");
			params.add(arbadhsolcomdoc.getXmnofile());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmsizefile() != null) {
			where.append(" AND t1.XMSIZEFILE = ?");
			params.add(arbadhsolcomdoc.getXmsizefile());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmtedesfile() != null) {
			where.append(" AND t1.XMTEDESFILE = ?");
			params.add(arbadhsolcomdoc.getXmtedesfile());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmorigen() != null) {
			where.append(" AND t1.XMORIGEN = ?");
			params.add(arbadhsolcomdoc.getXmorigen());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmtramite() != null) {
			where.append(" AND t1.XMTRAMITE = ?");
			params.add(arbadhsolcomdoc.getXmtramite());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmfecha() != null) {
			where.append(" AND t1.XMFECHA = ?");
			params.add(arbadhsolcomdoc.getXmfecha());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmconttype() != null) {
			where.append(" AND t1.XMCONTTYPE = ?");
			params.add(arbadhsolcomdoc.getXmconttype());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmindmail() != null) {
			where.append(" AND t1.XMINDMAIL = ?");
			params.add(arbadhsolcomdoc.getXmindmail());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmtrmail() != null) {
			where.append(" AND t1.XMTRMAIL = ?");
			params.add(arbadhsolcomdoc.getXmtrmail());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmiddocumentum() != null) {
			where.append(" AND t1.XMIDDOCUMENTUM = ?");
			params.add(arbadhsolcomdoc.getXmiddocumentum());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmtipodocumento() != null) {
			where.append(" AND t1.XMTIPODOCUMENTO = ?");
			params.add(arbadhsolcomdoc.getXmtipodocumento());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechaaportacion() != null) {
			where.append(" AND t1.XMFECHAAPORTACION = ?");
			params.add(arbadhsolcomdoc.getXmfechaaportacion());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechaentrada() != null) {
			where.append(" AND t1.XMFECHAENTRADA = ?");
			params.add(arbadhsolcomdoc.getXmfechaentrada());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmnumregistroentrada() != null) {
			where.append(" AND t1.XMNUMREGISTROENTRADA = ?");
			params.add(arbadhsolcomdoc.getXmnumregistroentrada());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmidPerfilfirma() != null) {
			where.append(" AND t1.XMID_PERFILFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmidPerfilfirma());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmestadodocumento() != null) {
			where.append(" AND t1.XMESTADODOCUMENTO = ?");
			params.add(arbadhsolcomdoc.getXmestadodocumento());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechasolfirma() != null) {
			where.append(" AND t1.XMFECHASOLFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmfechasolfirma());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechafirma() != null) {
			where.append(" AND t1.XMFECHAFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmfechafirma());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmcomofirma() != null) {
			where.append(" AND t1.XMCOMOFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmcomofirma());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechalimfirma() != null) {
			where.append(" AND t1.XMFECHALIMFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmfechalimfirma());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmdestino() != null) {
			where.append(" AND t1.XMDESTINO = ?");
			params.add(arbadhsolcomdoc.getXmdestino());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmptcodigo() != null) {
			where.append(" AND t1.XMPTCODIGO = ?");
			params.add(arbadhsolcomdoc.getXmptcodigo());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechasollocalizador() != null) {
			where.append(" AND t1.XMFECHASOLLOCALIZADOR = ?");
			params.add(arbadhsolcomdoc.getXmfechasollocalizador());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmnumregistroorigen() != null) {
			where.append(" AND t1.XMNUMREGISTROORIGEN = ?");
			params.add(arbadhsolcomdoc.getXmnumregistroorigen());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfecharegistroorigen() != null) {
			where.append(" AND t1.XMFECHAREGISTROORIGEN = ?");
			params.add(arbadhsolcomdoc.getXmfecharegistroorigen());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmfecalta() != null) {
			where.append(" AND t1.XMFECALTA = ?");
			params.add(arbadhsolcomdoc.getXmfecalta());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmfecmodif() != null) {
			where.append(" AND t1.XMFECMODIF = ?");
			params.add(arbadhsolcomdoc.getXmfecmodif());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmusualta() != null) {
			where.append(" AND t1.XMUSUALTA = ?");
			params.add(arbadhsolcomdoc.getXmusualta());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmusumodif() != null) {
			where.append(" AND t1.XMUSUMODIF = ?");
			params.add(arbadhsolcomdoc.getXmusumodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhsolcomdoc entity
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbadhsolcomdoc arbadhsolcomdoc,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbadhsolcomdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmcodocumento() != null) {
			where.append(" AND t1.XMCODOCUMENTO = ?");
			params.add(arbadhsolcomdoc.getXmcodocumento());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmexcodigo() != null) {
			where.append(" AND t1.XMEXCODIGO = ?");
			params.add(arbadhsolcomdoc.getXmexcodigo());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmnofile() != null) {
			where.append(" AND UPPER(t1.XMNOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmnofile().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmnofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMNOFILE IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmsizefile() != null) {
			where.append(" AND t1.XMSIZEFILE = ?");
			params.add(arbadhsolcomdoc.getXmsizefile());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmtedesfile() != null) {
			where.append(" AND UPPER(t1.XMTEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmtedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmtedesfile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMTEDESFILE IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmorigen() != null) {
			where.append(" AND UPPER(t1.XMORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmorigen().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmorigen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMORIGEN IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmtramite() != null) {
			where.append(" AND t1.XMTRAMITE = ?");
			params.add(arbadhsolcomdoc.getXmtramite());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmfecha() != null) {
			where.append(" AND t1.XMFECHA = ?");
			params.add(arbadhsolcomdoc.getXmfecha());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmconttype() != null) {
			where.append(" AND UPPER(t1.XMCONTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmconttype().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmconttype().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMCONTTYPE IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmindmail() != null) {
			where.append(" AND UPPER(t1.XMINDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmindmail().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmindmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMINDMAIL IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmtrmail() != null) {
			where.append(" AND UPPER(t1.XMTRMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmtrmail().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmtrmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMTRMAIL IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmiddocumentum() != null) {
			where.append(" AND UPPER(t1.XMIDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmiddocumentum().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhsolcomdoc.getXmiddocumentum().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMIDDOCUMENTUM IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmtipodocumento() != null) {
			where.append(" AND UPPER(t1.XMTIPODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmtipodocumento().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhsolcomdoc.getXmtipodocumento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMTIPODOCUMENTO IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechaaportacion() != null) {
			where.append(" AND t1.XMFECHAAPORTACION = ?");
			params.add(arbadhsolcomdoc.getXmfechaaportacion());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechaentrada() != null) {
			where.append(" AND t1.XMFECHAENTRADA = ?");
			params.add(arbadhsolcomdoc.getXmfechaentrada());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmnumregistroentrada() != null) {
			where.append(" AND UPPER(t1.XMNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmnumregistroentrada()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ arbadhsolcomdoc.getXmnumregistroentrada()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.XMNUMREGISTROENTRADA IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmidPerfilfirma() != null) {
			where.append(" AND UPPER(t1.XMID_PERFILFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmidPerfilfirma().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhsolcomdoc.getXmidPerfilfirma().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMID_PERFILFIRMA IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmestadodocumento() != null) {
			where.append(" AND UPPER(t1.XMESTADODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmestadodocumento().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhsolcomdoc.getXmestadodocumento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMESTADODOCUMENTO IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechasolfirma() != null) {
			where.append(" AND t1.XMFECHASOLFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmfechasolfirma());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechafirma() != null) {
			where.append(" AND t1.XMFECHAFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmfechafirma());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmcomofirma() != null) {
			where.append(" AND UPPER(t1.XMCOMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmcomofirma().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmcomofirma().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMCOMOFIRMA IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechalimfirma() != null) {
			where.append(" AND t1.XMFECHALIMFIRMA = ?");
			params.add(arbadhsolcomdoc.getXmfechalimfirma());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmdestino() != null) {
			where.append(" AND UPPER(t1.XMDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmdestino().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmdestino().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMDESTINO IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmptcodigo() != null) {
			where.append(" AND UPPER(t1.XMPTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmptcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmptcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMPTCODIGO IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfechasollocalizador() != null) {
			where.append(" AND t1.XMFECHASOLLOCALIZADOR = ?");
			params.add(arbadhsolcomdoc.getXmfechasollocalizador());
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmnumregistroorigen() != null) {
			where.append(" AND UPPER(t1.XMNUMREGISTROORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmnumregistroorigen()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ arbadhsolcomdoc.getXmnumregistroorigen()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.XMNUMREGISTROORIGEN IS NOT NULL");
		}
		if (arbadhsolcomdoc != null
				&& arbadhsolcomdoc.getXmfecharegistroorigen() != null) {
			where.append(" AND t1.XMFECHAREGISTROORIGEN = ?");
			params.add(arbadhsolcomdoc.getXmfecharegistroorigen());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmfecalta() != null) {
			where.append(" AND t1.XMFECALTA = ?");
			params.add(arbadhsolcomdoc.getXmfecalta());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmfecmodif() != null) {
			where.append(" AND t1.XMFECMODIF = ?");
			params.add(arbadhsolcomdoc.getXmfecmodif());
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmusualta() != null) {
			where.append(" AND UPPER(t1.XMUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMUSUALTA IS NOT NULL");
		}
		if (arbadhsolcomdoc != null && arbadhsolcomdoc.getXmusumodif() != null) {
			where.append(" AND UPPER(t1.XMUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsolcomdoc.getXmusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsolcomdoc.getXmusumodif().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.XMUSUMODIF IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder("");
		try {
			query = new StringBuilder(
					"SELECT DISTINCT XMCODOCUMENTO, XMEXCODIGO, XMNOFILE, XMSIZEFILE, XMTEDESFILE, XMORIGEN, XMTRAMITE, DECODE(XMFECHAREGISTROORIGEN, null, DECODE(XMFECHAENTRADA,null,XMFECHA,XMFECHAENTRADA),XMFECHAREGISTROORIGEN) XMFECHA, XMCONTTYPE, XMINDMAIL, XMTRMAIL, XMIDDOCUMENTUM, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM ARBADHSOLCOMDOC, ARBTIPDOC t2 WHERE XMTIPODOCUMENTO = t2.TDID(+) AND XMCODOCUMENTO = CODOCUMENTO AND XMCODIGO = '"
					+ tramiteComun.getIdExpediente() + "'");

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(
					query.toString(), this.rwMapDocExp);
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhsolcomdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosHechoComunicacion: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts number of rows in the Arbadhsolcomdoc table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT XMCODOCUMENTO) ");
		query.append("FROM ARBADHSOLCOMDOC WHERE XMCODOCUMENTO = CODOCUMENTO AND XMEXCODIGO=? )");
		// Where clause & Params
		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();

		params.add(tramiteComun.getIdExpediente());
		params.add(tramiteComun.getTipoProcedimiento().getPcodigo());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsolcomdoc> findAllDocumentosRespuesta(
			TramiteComun tramiteComun, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT t1.XMCODOCUMENTO XMCODOCUMENTO,t1.XMEXCODIGO XMEXCODIGO,t1.XMNOFILE XMNOFILE,null XMDATAFILE,t1.XMSIZEFILE XMSIZEFILE,t1.XMTEDESFILE XMTEDESFILE,t1.XMORIGEN XMORIGEN,t1.XMTRAMITE XMTRAMITE,t1.XMFECHA XMFECHA,t1.XMCONTTYPE XMCONTTYPE,t1.XMINDMAIL XMINDMAIL,t1.XMTRMAIL XMTRMAIL,t1.XMIDDOCUMENTUM XMIDDOCUMENTUM,t1.XMFECHAAPORTACION XMFECHAAPORTACION,t1.XMFECHAENTRADA XMFECHAENTRADA,t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA,t1.XMID_PERFILFIRMA XMIDPERFILFIRMA,t1.XMESTADODOCUMENTO XMESTADODOCUMENTO,t1.XMFECHASOLFIRMA XMFECHASOLFIRMA,t1.XMFECHAFIRMA XMFECHAFIRMA,t1.XMCOMOFIRMA XMCOMOFIRMA,t1.XMFECALTA XMFECALTA,t1.XMFECMODIF XMFECMODIF,t1.XMUSUALTA XMUSUALTA,t1.XMUSUMODIF XMUSUMODIF,t1.XMFECHALIMFIRMA XMFECHALIMFIRMA,t1.XMDESTINO XMDESTINO,t1.XMPTCODIGO XMPTCODIGO,t1.XMFECHASOLLOCALIZADOR XMFECHASOLLOCALIZADOR,t1.XMNUMREGISTROORIGEN XMNUMREGISTROORIGEN,t1.XMFECHAREGISTROORIGEN XMFECHAREGISTROORIGEN,t1.XMTIPODOCUMENTO XMTIPODOCUMENTO, t2.TDID ARBTIPDOCTDID,t2.ID_TIPODOC ARBTIPDOCIDTIPODOC,t2.TDNOMBRE ARBTIPDOCTDNOMBRE,t2.TDNOMBREE ARBTIPDOCTDNOMBREE,t2.TDPCODIGO ARBTIPDOCTDPCODIGO,t2.TDFECALTA ARBTIPDOCTDFECALTA,t2.TDFECMODIF ARBTIPDOCTDFECMODIF,t2.TDUSUALTA ARBTIPDOCTDUSUALTA,t2.TDUSUMODIF ARBTIPDOCTDUSUMODIF, t2.TDTIPO ARBTIPDOCTDTIPO ");
			query.append("FROM ARBADHSOLCOMDOC t1, ARBTIPDOC t2 WHERE t2.TDID=t1.XMTIPODOCUMENTO ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.XMEXCODIGO = ? ");
			params.add(tramiteComun.getIdExpediente().toString());
			where.append(" AND t1.XMTRAMITE = ? ");
			params.add(tramiteComun.getIdExpediente().toString());

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Arbadhsolcomdoc>) this.jdbcTemplate.query(
					query.toString(), this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhsolcomdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosTramite: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21Q5T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 */
	public void addArbAdjuntarDocs(Arbadhsol arbadhsol) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ "SELECT t1.XMCODOCUMENTO XMCODOCUMENTO, ?,  t1.XMID_PERFILFIRMA XMIDPERFILFIRMA, t1.XMTIPODOCUMENTO XMTIPODOCUMENTO, t1.XMEXCODIGO XMEXCODIGO, t1.XMTRAMITE XMTRAMITE, t1.XMNOFILE XMNOFILE, t1.XMDATAFILE XMDATAFILE, t1.XMSIZEFILE XMSIZEFILE, t1.XMTEDESFILE XMTEDESFILE, t1.XMORIGEN XMORIGEN, t1.XMTRAMITE XMTRAMITE, t1.XMFECHA XMFECHA, t1.XMINDMAIL XMINDMAIL, t1.XMTRMAIL XMTRMAIL, t1.XMCONTTYPE XMCONTTYPE, t1.XMIDDOCUMENTUM XMIDDOCUMENTUM, t1.XMFECHAAPORTACION XMFECHAAPORTACION, t1.XMFECHAENTRADA XMFECHAENTRADA, t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA, t1.XMESTADODOCUMENTO XMESTADODOCUMENTO, t1.XMFECHASOLFIRMA XMFECHASOLFIRMA, t1.XMFECHALIMFIRMA XMFECHALIMFIRMA, t1.XMFECHAFIRMA XMFECHAFIRMA, t1.XMCOMOFIRMA XMCOMOFIRMA, t1.XMDESTINO XMDESTINO, t1.XMFECHASOLLOCALIZADOR XMFECHASOLLOCALIZADOR, T1.XMPTCODIGO XMPTCODIGO, t1.XMNUMREGISTROORIGEN XMNUMREGISTROORIGEN, t1.XMFECHAREGISTROORIGEN XMFECHAREGISTROORIGEN, t1.XMIDINTERVINIENTE XMIDINTERVINIENTE "
				+ " FROM ARBADHSOLCOMDOC t1 "
				+ " WHERE t1.XMEXCODIGO = ? AND t1.XMTRAMITE = ? ";
		this.jdbcTemplate.update(query, arbadhsol.getTipoProcedimiento(),
				arbadhsol.getAdhid(), arbadhsol.getAdhid());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsolcomdoc> findAllDocumentosEliminados(
			TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.XMCODOCUMENTO XMCODOCUMENTO, t1.XMIDDOCUMENTUM XMIDDOCUMENTUM ");
		query.append("FROM ARBADHSOLCOMDOC t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.XMTRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());
		where.append(" AND t1.XMEXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		where.append(" AND t1.XMCODOCUMENTO NOT IN (SELECT tt1.THCODOCUMENTO FROM ADJUNTARDOCS tt1 WHERE tt1.THID_TRAMITE = ? AND tt1.TRPCODIGO=? )");
		params.add(tramiteComun.getIdTramite());
		params.add(tramiteComun.getTipoProcedimiento().getPcodigo());
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhsolcomdoc>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<Arbadhsolcomdoc>() {
					public Arbadhsolcomdoc mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new Arbadhsolcomdoc(resultSet
								.getString("XMCODOCUMENTO"), resultSet
								.getString("XMIDDOCUMENTUM"));
					}
				}, params.toArray());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "DELETE FROM ARBADHSOLCOMDOC WHERE XMTRAMITE = ? AND XMEXCODIGO=?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(),
				tramiteComun.getIdExpediente());
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		try {
			String query = "INSERT INTO ARBADHSOLCOMDOC (XMCODOCUMENTO, XMEXCODIGO, XMNOFILE, XMDATAFILE, XMSIZEFILE, XMTEDESFILE, XMORIGEN, XMTRAMITE, XMFECHA, XMINDMAIL, XMTRMAIL, XMCONTTYPE, XMIDDOCUMENTUM, XMFECHAAPORTACION, XMFECHAENTRADA, XMNUMREGISTROENTRADA, XMID_PERFILFIRMA, XMESTADODOCUMENTO, XMFECHASOLFIRMA, XMFECHALIMFIRMA, XMFECHAFIRMA, XMCOMOFIRMA, XMTIPODOCUMENTO, XMDESTINO, XMFECHASOLLOCALIZADOR, XMPTCODIGO,XMNUMREGISTROORIGEN,XMFECHAREGISTROORIGEN,XMIDINTERVINIENTE)"
					+ " SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO ,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN,THIDINTERVINIENTE "
					+ " FROM ADJUNTARDOCS WHERE THPCODIGO = ? AND THCODOCUMENTO NOT IN (SELECT XMCODOCUMENTO FROM ARBADHSOLCOMDOC WHERE XMEXCODIGO=?) AND THID_EXPEDIENTE=? AND THID_TRAMITE=?";

			this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento()
					.getPcodigo(), tramiteComun.getIdExpediente(), tramiteComun
					.getIdExpediente(), tramiteComun.getIdTramite());
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en addDocumentosHechoAdjuntarDocs: "
					+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * updateOIDDokusi
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	public Arbadhsolcomdoc updateOIDDokusi(Arbadhsolcomdoc documentoHecho) {
		logger.debug("updateOIDDokusi(). XMCODOCUMENTO: "
				+ documentoHecho.getXmcodocumento() + ".XMIDDOCUMENTUM:"
				+ documentoHecho.getXmiddocumentum() + ".");
		String query = "UPDATE ARBADHSOLCOMDOC SET XMIDDOCUMENTUM=? WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getXmiddocumentum(),
				documentoHecho.getXmcodocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	public Arbadhsolcomdoc removeBlobFromOIDDokusi(
			Arbadhsolcomdoc arbadhsolcomdoc) {
		String query = "UPDATE ARBADHSOLCOMDOC SET XMDATAFILE=null WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhsolcomdoc.getXmcodocumento());
		return arbadhsolcomdoc;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbdoctemp
	 *            Arbadhsolcomdoc
	 * @return DocumentoHecho
	 */
	public Arbadhsolcomdoc updateFechaLocalizacion(Arbadhsolcomdoc arbdoctemp) {
		String query = "UPDATE ARBADHSOLCOMDOC SET XMFECHASOLLOCALIZADOR=SYSDATE WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbdoctemp.getXmcodocumento());
		return arbdoctemp;
	}

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addArbAdhAdjuntarDocs(TramiteComun tramiteComun) {

		String query = " INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN,THIDINTERVINIENTE) "
				+ " SELECT t1.XMCODOCUMENTO XMCODOCUMENTO, '"
				+ tramiteComun.getTipoProcedimiento().getPcodigo()
				+ "', '"
				+ tramiteComun.getTipoProcedimiento().getPcodigo()
				+ "',  t1.XMID_PERFILFIRMA XMID_PERFILFIRMA, t1.XMTIPODOCUMENTO XMTIPODOCUMENTO, t1.XMEXCODIGO XMEXCODIGO, '"
				+ tramiteComun.getIdTramite()
				+ "', t1.XMNOFILE XMNOFILE, t1.XMDATAFILE XMDATAFILE, t1.XMSIZEFILE XMSIZEFILE, t1.XMTEDESFILE XMTEDESFILE, t1.XMORIGEN XMORIGEN, t1.XMTRAMITE XMTRAMITE, t1.XMFECHA XMFECHA, t1.XMINDMAIL XMINDMAIL, t1.XMTRMAIL XMTRMAIL, t1.XMCONTTYPE XMCONTTYPE, t1.XMIDDOCUMENTUM XMIDDOCUMENTUM, t1.XMFECHAAPORTACION XMFECHAAPORTACION, t1.XMFECHAENTRADA XMFECHAENTRADA, t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA, t1.XMESTADODOCUMENTO XMESTADODOCUMENTO, t1.XMFECHASOLFIRMA XMFECHASOLFIRMA, t1.XMFECHALIMFIRMA XMFECHALIMFIRMA, t1.XMFECHAFIRMA XMFECHAFIRMA, t1.XMCOMOFIRMA XMCOMOFIRMA, t1.XMDESTINO XMDESTINO, t1.XMFECHASOLLOCALIZADOR XMFECHASOLLOCALIZADOR, T1.XMPTCODIGO XMPTCODIGO, t1.XMNUMREGISTROORIGEN XMNUMREGISTROORIGEN, t1.XMFECHAREGISTROORIGEN XMFECHAREGISTROORIGEN,t1.XMIDINTERVINIENTE XMIDINTERVINIENTE "
				+ " FROM ARBADHSOLCOMDOC t1 WHERE t1.XMEXCODIGO = ?";
		this.jdbcTemplate.update(query, tramiteComun.getIdExpediente());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	public Arbadhsolcomdoc updateOrigen(Arbadhsolcomdoc documentoHecho) {
		String query = "UPDATE ARBADHSOLCOMDOC SET XMORIGEN=? WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getXmorigen(),
				documentoHecho.getXmcodocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param Arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	public void updateDatosFirma(Arbadhsolcomdoc documentoHecho) {
		String query = "UPDATE ARBADHSOLCOMDOC SET XMESTADODOCUMENTO=?, XMFECHAFIRMA=?, XMCOMOFIRMA=? WHERE XMCODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getXmestadodocumento(),
				documentoHecho.getXmfechafirma(),
				documentoHecho.getXmcomofirma(),
				documentoHecho.getXmcodocumento());
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosHechoComunicacionCount(
			TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT  count(1) FROM ARBADHSOLCOMDOC t1,ARBTIPDOC t2 WHERE t1.XMTIPODOCUMENTO = t2.TDID(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.XMEXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.XMTIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.XMTIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_ACEPTACION_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.XMTIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.XMTIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_ACLARACION);
		}

		where.append(" AND t1.XMTRAMITE IN (SELECT tt1.ADHID FROM ARBADHSOL tt1 WHERE tt1.ADHID=? AND (tt1.ADHESTADO=? OR tt1.ADHESTADO IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(
			TramiteComun tramiteComun, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.XMCODOCUMENTO XMCODOCUMENTO,t1.XMEXCODIGO XMEXCODIGO,t1.XMNOFILE XMNOFILE,t1.XMSIZEFILE XMSIZEFILE,t1.XMTEDESFILE XMTEDESFILE,t1.XMORIGEN XMORIGEN, DECODE(t1.XMFECHAREGISTROORIGEN, null, DECODE(t1.XMFECHAENTRADA,null,t1.XMFECHA,t1.XMFECHAENTRADA),t1.XMFECHAREGISTROORIGEN) XMFECHA,t1.XMCONTTYPE XMCONTTYPE,t1.XMIDDOCUMENTUM XMIDDOCUMENTUM,t1.XMFECHAAPORTACION XMFECHAAPORTACION,t1.XMFECHAENTRADA XMFECHAENTRADA,t1.XMNUMREGISTROENTRADA XMNUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM ARBADHSOLCOMDOC t1,ARBTIPDOC t2 WHERE t1.XMTIPODOCUMENTO = t2.TDID(+) ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.XMEXCODIGO = ? ");
			params.add(tramiteComun.getIdExpediente());

			if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.XMTIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.XMTIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_ACEPTACION_ARBITRAJE);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.XMTIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION);
			} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION
					.equals(tramiteComun.getIdTipoTramite())) {
				where.append(" AND t1.XMTIPODOCUMENTO = ? ");
				params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_ACLARACION);
			}

			where.append(" AND t1.XMTRAMITE IN (SELECT tt1.ADHID FROM ARBADHSOL tt1 WHERE tt1.ADHID=? AND (tt1.ADHESTADO=? OR tt1.ADHESTADO IS NULL))");
			params.add(tramiteComun.getIdExpediente());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(
					query.toString(), new RowMapper<DocumentoExpediente>() {
						public DocumentoExpediente mapRow(ResultSet resultSet,
								int rowNum) throws SQLException {
							return new DocumentoExpediente(resultSet
									.getString("XMCODOCUMENTO"), resultSet
									.getString("XMEXCODIGO"), resultSet
									.getString("XMNOFILE"), null, resultSet
									.getInt("XMSIZEFILE"), resultSet
									.getString("XMCONTTYPE"), resultSet
									.getString("XMTEDESFILE"), resultSet
									.getString("XMORIGEN"), resultSet
									.getDate("XMFECHA"), resultSet
									.getString("XMIDDOCUMENTUM"), resultSet
									.getDate("XMFECHAAPORTACION"), resultSet
									.getDate("XMFECHAENTRADA"), resultSet
									.getString("XMNUMREGISTROENTRADA"),
									resultSet.getString("IDTIPODOC"), resultSet
											.getString("TDNOMBRE"), resultSet
											.getString("TDNOMBREE"), null,
									null, null, null, null, null, null, null);
						}
					}, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(
					"Error producido en findAllDocumentosHechoComunicacion: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateArbAdhSolComDoc(Arbadhsolcomdoc arbadhsolcomdoc) {
		String query = "UPDATE ARBADHSOLCOMDOC SET XMNOFILE=?,XMDATAFILE=?, XMSIZEFILE=?, XMCONTTYPE=? WHERE XMIDDOCUMENTUM=?";
		return this.jdbcTemplate
				.update(query, arbadhsolcomdoc.getXmnofile(), Y41bJdbcUtils
						.ConvertBlobToByte(arbadhsolcomdoc.getXmdatafile()),
						arbadhsolcomdoc.getXmsizefile(), arbadhsolcomdoc
								.getXmconttype(), arbadhsolcomdoc
								.getXmiddocumentum());
	}

}
