package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbadhsolcomdoc;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbadhsolcomdocDao  
 * 
 *  
 */

public interface ArbadhsolcomdocDao {

	/**
	 * Inserts a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	Arbadhsolcomdoc add(Arbadhsolcomdoc arbadhsolcomdoc);

	/**
	 * Updates a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	Arbadhsolcomdoc update(Arbadhsolcomdoc arbadhsolcomdoc);

	/**
	 * Finds a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	Arbadhsolcomdoc find(Arbadhsolcomdoc arbadhsolcomdoc);

	/**
	 * Deletes a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return
	 */
	void remove(Arbadhsolcomdoc arbadhsolcomdoc);

	/**
	 * Finds a List of rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhsolcomdoc> findAll(Arbadhsolcomdoc arbadhsolcomdoc,
			Pagination pagination);

	/**
	 * Counts rows in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Long
	 */
	Long findAllCount(Arbadhsolcomdoc arbadhsolcomdoc);

	/**
	 * Finds rows in the Arbadhsolcomdoc table using like.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhsolcomdoc> findAllLike(Arbadhsolcomdoc arbadhsolcomdoc,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbadhsolcomdoc table using like.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhsolcomdoc arbadhsolcomdoc, Boolean startsWith);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	List<Arbadhsolcomdoc> findAllDocumentosRespuesta(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * getNewPK
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * addArbAdjuntarDocs
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 */
	void addArbAdjuntarDocs(Arbadhsol arbadhsol);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhsolcomdoc> findAllDocumentosEliminados(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * updateOIDDokusi
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	Arbadhsolcomdoc updateOIDDokusi(Arbadhsolcomdoc documentoHecho);

	/**
	 * Updates a single row in the Arbadhsolcomdoc table.
	 * 
	 * @param arbadhsolcomdoc
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	public Arbadhsolcomdoc removeBlobFromOIDDokusi(
			Arbadhsolcomdoc arbadhsolcomdoc);

	/**
	 * updateFechaLocalizacion
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	Arbadhsolcomdoc updateFechaLocalizacion(Arbadhsolcomdoc documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Arbadhsolcomdoc
	 * @return Arbadhsolcomdoc
	 */
	Arbadhsolcomdoc updateOrigen(Arbadhsolcomdoc documentoHecho);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosHechoComunicacion(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * @param documentohechoAux
	 *            Arbadhsolcomdoc
	 * @return int
	 */
	int updateArbAdhSolComDoc(Arbadhsolcomdoc documentohechoAux);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addArbAdhAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * updateDatosFirma
	 * 
	 * @param arbdoctemp
	 *            Arbadhsolcomdoc
	 */
	void updateDatosFirma(Arbadhsolcomdoc arbdoctemp);
}
