package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdhesionTele;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ArbadhsolDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbadhsolDaoImpl implements ArbadhsolDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbadhsol> rwMap = new RowMapper<Arbadhsol>() {
		public Arbadhsol mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Arbadhsol retorno = new Arbadhsol(resultSet.getString("ADHID"), resultSet.getString("ADHTIPO"),
					resultSet.getString("ADHNIF"), resultSet.getString("ADHESNOM"), resultSet.getString("ADHESNOCO"),
					resultSet.getString("ADHESCOIDCO"), resultSet.getString("ADHORGEMP"),
					resultSet.getString("ADHESURL"), resultSet.getString("ADHESNOPECO"),
					resultSet.getString("ADHESCOEM"), resultSet.getString("ADHESNRTEL"),
					resultSet.getString("ADHESNRTEL2"), resultSet.getString("ADHESEXTRANJERO"),
					resultSet.getString("ADHESNOMBRECP"), resultSet.getString("ADHESPROVIN"),
					resultSet.getString("ADHESMUNICI"), resultSet.getString("ADHESLOCALI"),
					resultSet.getString("ADHESCALLE"), resultSet.getString("ADHESPORTAL"),
					resultSet.getString("ADHESPISO"), resultSet.getString("ADHESDIRECNOCAPV"),
					resultSet.getString("ADHESNOREP"), resultSet.getString("ADHESNIFREP"),
					resultSet.getString("ADHESINTIAR"), resultSet.getString("ADHESMEDIA"),
					resultSet.getString("ADHINDEF"), resultSet.getDate("ADHFECFIN"),
					resultSet.getString("ADHSOLTIPNOTIF"), resultSet.getString("ADHSOLIDIOMA"),
					resultSet.getString("ADHSOLTELEM"), resultSet.getString("ADHSOLEMAIL"),
					resultSet.getString("ADHSOLSMS"), resultSet.getString("ADHSECTORID"),
					resultSet.getDate("ADHFECALTA"), resultSet.getString("ADHSOLCOOR"),
					resultSet.getBigDecimal("ADHSOLNRAN"), resultSet.getBigDecimal("ADHSOLNROR"),
					resultSet.getString("ADHSOLREGEN"), resultSet.getString("ADHESPAISID"),
					resultSet.getDate("ADHFECREGEN"), resultSet.getString("ADHESCODIGO"),
					resultSet.getString("ADHESTADO"), resultSet.getString("ADHUSUALTA"),
					resultSet.getString("ADHUSUMODIF"), resultSet.getDate("ADHFECMODIF"));

			StringBuffer numeroExpediente = new StringBuffer("");
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(resultSet.getString("ADHTIPO"))) {
				numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_ALTA);
				retorno.setTipoProcedimiento(Y41bConstantes.PREFIJO_ADHESIONES_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(resultSet.getString("ADHTIPO"))
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(resultSet.getString("ADHTIPO"))) {
				numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_BAJA);
				retorno.setTipoProcedimiento(Y41bConstantes.PREFIJO_ADHESIONES_BAJA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(resultSet.getString("ADHTIPO"))) {
				numeroExpediente.append(Y41bConstantes.PREFIJO_ADHESIONES_MOD);
				retorno.setTipoProcedimiento(Y41bConstantes.PREFIJO_ADHESIONES_MOD);
			}

			numeroExpediente.append("-").append(resultSet.getString("ADHSOLCOOR")).append("-")
					.append(resultSet.getBigDecimal("ADHSOLNROR")).append("-")
					.append(resultSet.getBigDecimal("ADHSOLNRAN"));
			retorno.setNumExpediente(numeroExpediente.toString());
			retorno.setAdhnrdi(resultSet.getBigDecimal("ADHNRDI"));
			retorno.setAdhfecnrdi(resultSet.getDate("ADHFECNRDI"));
			retorno.setAdhlimitaciones(Y41bUtils.clobToString(resultSet.getClob("ADHLIMITACIONES")));
			retorno.setAdhSectorCampania(resultSet.getString("ADHSECTORCAMP"));
			return retorno;
		}
	};

	private RowMapper<Arbadhsol> rwMapComunicacion = new RowMapper<Arbadhsol>() {
		public Arbadhsol mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Arbadhsol retorno = new Arbadhsol(resultSet.getString("ADHID"));
			retorno.setAdhfechacom(resultSet.getDate("ADHFECHACOM"));
			retorno.setAdhsede(resultSet.getString("ADHSEDE"));
			retorno.setAdhasunto(resultSet.getString("ADHASUNTO"));
			retorno.setAdhtipocom(resultSet.getString("ADHTIPOCOM"));
			retorno.setAdhcodrem(resultSet.getString("ADHCODREM"));
			retorno.setAdhenvrem(resultSet.getString("ADHENVREM"));
			retorno.setAdhfecregs(resultSet.getDate("ADHFECREGS"));
			retorno.setAdhnumregs(resultSet.getString("ADHNUMREGS"));
			retorno.setAdhidmailorigen(resultSet.getString("ADHIDMAILORIGEN"));
			retorno.setAdhmailorigen(resultSet.getString("ADHMAILORIGEN"));
			retorno.setAdhidmaildestino(resultSet.getString("ADHIDMAILDESTINO"));
			retorno.setAdhmaildestino(resultSet.getString("ADHMAILDESTINO"));
			retorno.setAdhtexto(Y41bUtils.clobToString(resultSet.getClob("ADHTEXTO")));
			retorno.setAdhcommail(resultSet.getString("ADHCOMMAIL"));
			return retorno;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return Arbadhsol
	 */
	public Arbadhsol add(Arbadhsol arbadhsol) {

		String query = "SELECT NVL(MAX(ABS(ADHSOLNROR)),0)+1 ADHSOLNROR FROM NUMSOLADH WHERE ADHSOLCOOR = ? AND ADHSOLNRAN = ? AND ADHTIPO=?";

		BigDecimal arbsolnror = new BigDecimal(this.jdbcTemplate.queryForLong(query, arbadhsol.getAdhsolcoor(),
				arbadhsol.getAdhsolnran(), arbadhsol.getAdhtipo()));
		arbadhsol.setAdhsolnror(arbsolnror);

		query = "INSERT INTO NUMSOLADH (ADHSOLCOOR, ADHSOLNRAN, ADHSOLNROR,ADHTIPO) VALUES (?,?,?,?)";
		this.jdbcTemplate.update(query, arbadhsol.getAdhsolcoor(), arbadhsol.getAdhsolnran(), arbsolnror,
				arbadhsol.getAdhtipo());

		query = "INSERT INTO ARBADHSOL (ADHTIPO, ADHNIF, ADHESNOM, ADHESNOCO, ADHESCOIDCO, ADHORGEMP, ADHESURL, ADHESNOPECO, ADHESCOEM, ADHESNRTEL, ADHESNRTEL2, ADHESEXTRANJERO, ADHESNOMBRECP, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, ADHESNOREP, ADHESNIFREP, ADHESINTIAR, ADHESMEDIA, ADHINDEF, ADHFECFIN, ADHSOLTIPNOTIF, ADHSOLIDIOMA, ADHSOLTELEM, ADHSOLEMAIL, ADHSOLSMS, ADHSECTORID, ADHFECALTA, ADHSOLCOOR, ADHSOLNRAN, ADHSOLNROR, ADHSOLREGEN, ADHESPAISID, ADHFECREGEN, ADHESCODIGO, ADHESTADO, ADHUSUALTA, ADHUSUMODIF, ADHFECMODIF,ADHNRDI,ADHFECNRDI, ADHSECTORCAMP) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbadhsol.getAdhtipo(), arbadhsol.getAdhnif(), arbadhsol.getAdhesnom(),
				arbadhsol.getAdhesnoco(), arbadhsol.getAdhescoidco(), arbadhsol.getAdhorgemp(), arbadhsol.getAdhesurl(),
				arbadhsol.getAdhesnopeco(), arbadhsol.getAdhescoem(), arbadhsol.getAdhesnrtel(),
				arbadhsol.getAdhesnrtel2(), arbadhsol.getAdhesextranjero(), arbadhsol.getAdhesnombrecp(),
				arbadhsol.getAdhesprovin(), arbadhsol.getAdhesmunici(), arbadhsol.getAdheslocali(),
				arbadhsol.getAdhescalle(), arbadhsol.getAdhesportal(), arbadhsol.getAdhespiso(),
				arbadhsol.getAdhesdirecnocapv(), arbadhsol.getAdhesnorep(), arbadhsol.getAdhesnifrep(),
				arbadhsol.getAdhesintiar(), arbadhsol.getAdhesmedia(), arbadhsol.getAdhindef(),
				arbadhsol.getAdhfecfin(), arbadhsol.getAdhsoltipnotif(), arbadhsol.getAdhsolidioma(),
				arbadhsol.getAdhsoltelem(), arbadhsol.getAdhsolemail(), arbadhsol.getAdhsolsms(),
				arbadhsol.getAdhsectorid(), arbadhsol.getAdhfecalta(), arbadhsol.getAdhsolcoor(),
				arbadhsol.getAdhsolnran(), arbadhsol.getAdhsolnror(), arbadhsol.getAdhsolregen(),
				arbadhsol.getAdhespaisid(), arbadhsol.getAdhfecregen(), arbadhsol.getAdhescodigo(),
				arbadhsol.getAdhestado(), arbadhsol.getAdhusualta(), arbadhsol.getAdhusumodif(),
				arbadhsol.getAdhfecmodif(), arbadhsol.getAdhnrdi(), arbadhsol.getAdhfecnrdi(),
				arbadhsol.getAdhSectorCampania());

		arbadhsol.setAdhid(this.currentValue());

		return arbadhsol;
	}

	/**
	 * Updates a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return Arbadhsol
	 */
	public Arbadhsol update(Arbadhsol arbadhsol) {
		String query = "UPDATE ARBADHSOL SET ADHTIPO=?, ADHNIF=?, ADHESNOM=?, ADHESNOCO=?, ADHESCOIDCO=?, ADHORGEMP=?, ADHESURL=?, ADHESNOPECO=?, ADHESCOEM=?, ADHESNRTEL=?, ADHESNRTEL2=?, ADHESEXTRANJERO=?, ADHESNOMBRECP=?, ADHESPROVIN=?, ADHESMUNICI=?, ADHESLOCALI=?, ADHESCALLE=?, ADHESPORTAL=?, ADHESPISO=?, ADHESDIRECNOCAPV=?, ADHESNOREP=?, ADHESNIFREP=?, ADHESINTIAR=?, ADHESMEDIA=?, ADHINDEF=?, ADHFECFIN=?, ADHSOLTIPNOTIF=?, ADHSOLIDIOMA=?, ADHSOLTELEM=?, ADHSOLEMAIL=?, ADHSOLSMS=?, ADHSECTORID=?, ADHFECALTA=?, ADHSOLCOOR=?, ADHSOLNRAN=?, ADHSOLNROR=?, ADHSOLREGEN=?, ADHESPAISID=?, ADHFECREGEN=?, ADHESCODIGO=?, ADHESTADO=?, ADHUSUALTA=?, ADHUSUMODIF=?, ADHFECMODIF=?, ADHNRDI=?, ADHFECNRDI=?, ADHSECTORCAMP=? WHERE ADHID=?";
		this.jdbcTemplate.update(query, arbadhsol.getAdhtipo(), arbadhsol.getAdhnif(), arbadhsol.getAdhesnom(),
				arbadhsol.getAdhesnoco(), arbadhsol.getAdhescoidco(), arbadhsol.getAdhorgemp(), arbadhsol.getAdhesurl(),
				arbadhsol.getAdhesnopeco(), arbadhsol.getAdhescoem(), arbadhsol.getAdhesnrtel(),
				arbadhsol.getAdhesnrtel2(), arbadhsol.getAdhesextranjero(), arbadhsol.getAdhesnombrecp(),
				arbadhsol.getAdhesprovin(), arbadhsol.getAdhesmunici(), arbadhsol.getAdheslocali(),
				arbadhsol.getAdhescalle(), arbadhsol.getAdhesportal(), arbadhsol.getAdhespiso(),
				arbadhsol.getAdhesdirecnocapv(), arbadhsol.getAdhesnorep(), arbadhsol.getAdhesnifrep(),
				arbadhsol.getAdhesintiar(), arbadhsol.getAdhesmedia(), arbadhsol.getAdhindef(),
				arbadhsol.getAdhfecfin(), arbadhsol.getAdhsoltipnotif(), arbadhsol.getAdhsolidioma(),
				arbadhsol.getAdhsoltelem(), arbadhsol.getAdhsolemail(), arbadhsol.getAdhsolsms(),
				arbadhsol.getAdhsectorid(), arbadhsol.getAdhfecalta(), arbadhsol.getAdhsolcoor(),
				arbadhsol.getAdhsolnran(), arbadhsol.getAdhsolnror(), arbadhsol.getAdhsolregen(),
				arbadhsol.getAdhespaisid(), arbadhsol.getAdhfecregen(), arbadhsol.getAdhescodigo(),
				arbadhsol.getAdhestado(), arbadhsol.getAdhusualta(), arbadhsol.getAdhusumodif(),
				arbadhsol.getAdhfecmodif(), arbadhsol.getAdhnrdi(), arbadhsol.getAdhfecnrdi(),
				arbadhsol.getAdhSectorCampania(), arbadhsol.getAdhid());

		query = "UPDATE ARBADHSOL SET ADHLIMITACIONES=? WHERE ADHID=?";
		Object[] params = { arbadhsol.getAdhlimitaciones(), arbadhsol.getAdhid() };
		this.jdbcTemplate.update(query, params);
		return arbadhsol;
	}

	/**
	 * Finds a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return Arbadhsol
	 */
	@Transactional(readOnly = true)
	public Arbadhsol find(Arbadhsol arbadhsol) {
		String query = "SELECT t1.ADHID ADHID, t1.ADHLIMITACIONES ADHLIMITACIONES, t1.ADHTIPO ADHTIPO, t1.ADHNIF ADHNIF, t1.ADHESNOM ADHESNOM, t1.ADHESNOCO ADHESNOCO, t1.ADHESCOIDCO ADHESCOIDCO, t1.ADHORGEMP ADHORGEMP, t1.ADHESURL ADHESURL, t1.ADHESNOPECO ADHESNOPECO, t1.ADHESCOEM ADHESCOEM, t1.ADHESNRTEL ADHESNRTEL, t1.ADHESNRTEL2 ADHESNRTEL2, t1.ADHESEXTRANJERO ADHESEXTRANJERO, t1.ADHESNOMBRECP ADHESNOMBRECP, t1.ADHESPROVIN ADHESPROVIN, t1.ADHESMUNICI ADHESMUNICI, t1.ADHESLOCALI ADHESLOCALI, t1.ADHESCALLE ADHESCALLE, t1.ADHESPORTAL ADHESPORTAL, t1.ADHESPISO ADHESPISO, t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV, t1.ADHESNOREP ADHESNOREP, t1.ADHESNIFREP ADHESNIFREP, t1.ADHESINTIAR ADHESINTIAR, t1.ADHESMEDIA ADHESMEDIA, t1.ADHINDEF ADHINDEF, t1.ADHFECFIN ADHFECFIN, t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF, t1.ADHSOLIDIOMA ADHSOLIDIOMA, t1.ADHSOLTELEM ADHSOLTELEM, t1.ADHSOLEMAIL ADHSOLEMAIL, t1.ADHSOLSMS ADHSOLSMS, t1.ADHSECTORID ADHSECTORID, t1.ADHFECALTA ADHFECALTA, t1.ADHSOLCOOR ADHSOLCOOR, t1.ADHSOLNRAN ADHSOLNRAN, t1.ADHSOLNROR ADHSOLNROR, t1.ADHSOLREGEN ADHSOLREGEN, t1.ADHESPAISID ADHESPAISID, t1.ADHFECREGEN ADHFECREGEN, t1.ADHESCODIGO ADHESCODIGO, t1.ADHESTADO ADHESTADO, t1.ADHUSUALTA ADHUSUALTA, t1.ADHUSUMODIF ADHUSUMODIF, t1.ADHFECMODIF ADHFECMODIF, ADHNRDI, ADHFECNRDI, t1.ADHSECTORCAMP ADHSECTORCAMP FROM ARBADHSOL t1  WHERE t1.ADHID = ?  ";

		List<Arbadhsol> arbadhsolList = this.jdbcTemplate.query(query, this.rwMap, arbadhsol.getAdhid());
		return (Arbadhsol) DataAccessUtils.uniqueResult(arbadhsolList);
	}

	/**
	 * Removes a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return
	 */
	public void remove(Arbadhsol arbadhsol) {
		String query = "DELETE FROM ARBADHSOL WHERE ADHID=?";
		this.jdbcTemplate.update(query, arbadhsol.getAdhid());
	}

	/**
	 * Removes a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return
	 */
	public void removeDatosValidacion(Arbadhsol arbadhsol) {
		String query = "DELETE FROM ARBADHSOLTEMP WHERE ADHID=?";
		this.jdbcTemplate.update(query, arbadhsol.getAdhid());
	}

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsol> findAll(Arbadhsol arbadhsol, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADHID ADHID,t1.ADHTIPO ADHTIPO,t1.ADHNIF ADHNIF,t1.ADHESNOM ADHESNOM,t1.ADHESNOCO ADHESNOCO,t1.ADHESCOIDCO ADHESCOIDCO,t1.ADHORGEMP ADHORGEMP,t1.ADHESURL ADHESURL,t1.ADHESNOPECO ADHESNOPECO,t1.ADHESCOEM ADHESCOEM,t1.ADHESNRTEL ADHESNRTEL,t1.ADHESNRTEL2 ADHESNRTEL2,t1.ADHESEXTRANJERO ADHESEXTRANJERO,t1.ADHESNOMBRECP ADHESNOMBRECP,t1.ADHESPROVIN ADHESPROVIN,t1.ADHESMUNICI ADHESMUNICI,t1.ADHESLOCALI ADHESLOCALI,t1.ADHESCALLE ADHESCALLE,t1.ADHESPORTAL ADHESPORTAL,t1.ADHESPISO ADHESPISO,t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV,t1.ADHESNOREP ADHESNOREP,t1.ADHESNIFREP ADHESNIFREP,t1.ADHESINTIAR ADHESINTIAR,t1.ADHESMEDIA ADHESMEDIA,t1.ADHINDEF ADHINDEF,t1.ADHFECFIN ADHFECFIN,t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF,t1.ADHSOLIDIOMA ADHSOLIDIOMA,t1.ADHSOLTELEM ADHSOLTELEM,t1.ADHSOLEMAIL ADHSOLEMAIL,t1.ADHSOLSMS ADHSOLSMS,t1.ADHSECTORID ADHSECTORID,t1.ADHFECALTA ADHFECALTA,t1.ADHSOLCOOR ADHSOLCOOR,t1.ADHSOLNRAN ADHSOLNRAN,t1.ADHSOLNROR ADHSOLNROR,t1.ADHSOLREGEN ADHSOLREGEN,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN,t1.ADHESCODIGO ADHESCODIGO,t1.ADHESTADO ADHESTADO,t1.ADHUSUALTA ADHUSUALTA,t1.ADHUSUMODIF ADHUSUMODIF,t1.ADHFECMODIF ADHFECMODIF, ADHNRDI, ADHFECNRDI ");
		query.append(" ,null ADHLIMITACIONES, t1.ADHSECTORCAMP ADHSECTORCAMP ");
		query.append("FROM ARBADHSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhsol);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhsol>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbadhsol arbadhsol) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBADHSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhsol);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsol> findAllLike(Arbadhsol arbadhsol, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADHID ADHID,t1.ADHTIPO ADHTIPO,t1.ADHNIF ADHNIF,t1.ADHESNOM ADHESNOM,t1.ADHESNOCO ADHESNOCO,t1.ADHESCOIDCO ADHESCOIDCO,t1.ADHORGEMP ADHORGEMP,t1.ADHESURL ADHESURL,t1.ADHESNOPECO ADHESNOPECO,t1.ADHESCOEM ADHESCOEM,t1.ADHESNRTEL ADHESNRTEL,t1.ADHESNRTEL2 ADHESNRTEL2,t1.ADHESEXTRANJERO ADHESEXTRANJERO,t1.ADHESNOMBRECP ADHESNOMBRECP,t1.ADHESPROVIN ADHESPROVIN,t1.ADHESMUNICI ADHESMUNICI,t1.ADHESLOCALI ADHESLOCALI,t1.ADHESCALLE ADHESCALLE,t1.ADHESPORTAL ADHESPORTAL,t1.ADHESPISO ADHESPISO,t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV,t1.ADHESNOREP ADHESNOREP,t1.ADHESNIFREP ADHESNIFREP,t1.ADHESINTIAR ADHESINTIAR,t1.ADHESMEDIA ADHESMEDIA,t1.ADHINDEF ADHINDEF,t1.ADHFECFIN ADHFECFIN,t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF,t1.ADHSOLIDIOMA ADHSOLIDIOMA,t1.ADHSOLTELEM ADHSOLTELEM,t1.ADHSOLEMAIL ADHSOLEMAIL,t1.ADHSOLSMS ADHSOLSMS,t1.ADHSECTORID ADHSECTORID,t1.ADHFECALTA ADHFECALTA,t1.ADHSOLCOOR ADHSOLCOOR,t1.ADHSOLNRAN ADHSOLNRAN,t1.ADHSOLNROR ADHSOLNROR,t1.ADHSOLREGEN ADHSOLREGEN,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN,t1.ADHESCODIGO ADHESCODIGO,t1.ADHESTADO ADHESTADO,t1.ADHUSUALTA ADHUSUALTA,t1.ADHUSUMODIF ADHUSUMODIF,t1.ADHFECMODIF ADHFECMODIF, ADHNRDI, ADHFECNRDI ");
		query.append(" ,null ADHLIMITACIONES, t1.ADHSECTORCAMP ADHSECTORCAMP ");
		query.append("FROM ARBADHSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhsol, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhsol>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbadhsol arbadhsol, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBADHSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhsol, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMap(Arbadhsol arbadhsol) {
		return this.getWhereMap(arbadhsol, null);
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhsol entity
	 * 
	 * @param arbadhsol
	 *            Arbadhsol Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMap(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {

		StringBuilder where = new StringBuilder(ArbadhsolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhsol != null && arbadhsol.getAdhid() != null) {
			where.append(" AND t1.ADHID = ?");
			params.add(arbadhsol.getAdhid());
		}
		if (arbadhsol != null && arbadhsol.getAdhtipo() != null) {
			where.append(" AND t1.ADHTIPO = ?");
			params.add(arbadhsol.getAdhtipo());
		}
		/*
		 * if (arbadhsol != null && arbadhsol.getAdhnif() != null) {
		 * where.append(" AND t1.ADHNIF = ?");
		 * params.add(arbadhsol.getAdhnif()); } if (arbadhsol != null &&
		 * arbadhsol.getAdhesnom() != null) {
		 * where.append(" AND t1.ADHESNOM = ?");
		 * params.add(arbadhsol.getAdhesnom()); } if (arbadhsol != null &&
		 * arbadhsol.getAdhesnoco() != null) {
		 * where.append(" AND t1.ADHESNOCO = ?");
		 * params.add(arbadhsol.getAdhesnoco()); }
		 */
		if (arbadhsol != null && arbadhsol.getAdhnif() != null) {
			where.append(" AND UPPER(t1.ADHNIF) like ? ESCAPE  '\\'");
			params.add("%" + arbadhsol.getAdhnif().toUpperCase() + "%");
			where.append(" AND t1.ADHNIF IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnom() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ADHESNOM),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + arbadhsol.getAdhesnom().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ADHESNOM IS NOT NULL) ");
			where.append(" OR (TRANSLATE(UPPER(t1.ADHESNOCO),'','AEIOU') like ? ESCAPE  '\\'");
			params.add("%" + arbadhsol.getAdhesnom().toUpperCase().replaceAll("", "A").replaceAll("", "E")
					.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U") + "%");
			where.append(" AND t1.ADHESNOCO IS NOT NULL)) ");
		}
		if (arbadhsol != null && arbadhsol.getAdhescoidco() != null) {
			where.append(" AND t1.ADHESCOIDCO = ?");
			params.add(arbadhsol.getAdhescoidco());
		}
		if (arbadhsol != null && arbadhsol.getAdhorgemp() != null) {
			where.append(" AND t1.ADHORGEMP = ?");
			params.add(arbadhsol.getAdhorgemp());
		}
		if (arbadhsol != null && arbadhsol.getAdhesurl() != null) {
			where.append(" AND t1.ADHESURL = ?");
			params.add(arbadhsol.getAdhesurl());
		}
		if (arbadhsol != null && arbadhsol.getAdhesnopeco() != null) {
			where.append(" AND t1.ADHESNOPECO = ?");
			params.add(arbadhsol.getAdhesnopeco());
		}
		if (arbadhsol != null && arbadhsol.getAdhescoem() != null) {
			where.append(" AND t1.ADHESCOEM = ?");
			params.add(arbadhsol.getAdhescoem());
		}
		if (arbadhsol != null && arbadhsol.getAdhesnrtel() != null) {
			where.append(" AND t1.ADHESNRTEL = ?");
			params.add(arbadhsol.getAdhesnrtel());
		}
		if (arbadhsol != null && arbadhsol.getAdhesnrtel2() != null) {
			where.append(" AND t1.ADHESNRTEL2 = ?");
			params.add(arbadhsol.getAdhesnrtel2());
		}
		if (arbadhsol != null && arbadhsol.getAdhesextranjero() != null) {
			where.append(" AND t1.ADHESEXTRANJERO = ?");
			params.add(arbadhsol.getAdhesextranjero());
		}
		if (arbadhsol != null && arbadhsol.getAdhesnombrecp() != null) {
			where.append(" AND t1.ADHESNOMBRECP = ?");
			params.add(arbadhsol.getAdhesnombrecp());
		}
		if (arbadhsol != null && arbadhsol.getAdhesprovin() != null) {
			where.append(" AND t1.ADHESPROVIN = ?");
			params.add(arbadhsol.getAdhesprovin());
		}
		if (arbadhsol != null && arbadhsol.getAdhesmunici() != null) {
			where.append(" AND t1.ADHESMUNICI = ?");
			params.add(arbadhsol.getAdhesmunici());
		}
		if (arbadhsol != null && arbadhsol.getAdheslocali() != null) {
			where.append(" AND t1.ADHESLOCALI = ?");
			params.add(arbadhsol.getAdheslocali());
		}
		if (arbadhsol != null && arbadhsol.getAdhescalle() != null) {
			where.append(" AND t1.ADHESCALLE = ?");
			params.add(arbadhsol.getAdhescalle());
		}
		if (arbadhsol != null && arbadhsol.getAdhesportal() != null) {
			where.append(" AND t1.ADHESPORTAL = ?");
			params.add(arbadhsol.getAdhesportal());
		}
		if (arbadhsol != null && arbadhsol.getAdhespiso() != null) {
			where.append(" AND t1.ADHESPISO = ?");
			params.add(arbadhsol.getAdhespiso());
		}
		if (arbadhsol != null && arbadhsol.getAdhesdirecnocapv() != null) {
			where.append(" AND t1.ADHESDIRECNOCAPV = ?");
			params.add(arbadhsol.getAdhesdirecnocapv());
		}
		if (arbadhsol != null && arbadhsol.getAdhesnorep() != null) {
			where.append(" AND t1.ADHESNOREP = ?");
			params.add(arbadhsol.getAdhesnorep());
		}
		if (arbadhsol != null && arbadhsol.getAdhesnifrep() != null) {
			where.append(" AND t1.ADHESNIFREP = ?");
			params.add(arbadhsol.getAdhesnifrep());
		}
		if (arbadhsol != null && arbadhsol.getAdhesintiar() != null) {
			where.append(" AND t1.ADHESINTIAR = ?");
			params.add(arbadhsol.getAdhesintiar());
		}
		if (arbadhsol != null && arbadhsol.getAdhesmedia() != null) {
			where.append(" AND t1.ADHESMEDIA = ?");
			params.add(arbadhsol.getAdhesmedia());
		}
		if (arbadhsol != null && arbadhsol.getAdhindef() != null) {
			where.append(" AND t1.ADHINDEF = ?");
			params.add(arbadhsol.getAdhindef());
		}
		if (arbadhsol != null && arbadhsol.getAdhfecfin() != null) {
			where.append(" AND t1.ADHFECFIN = ?");
			params.add(arbadhsol.getAdhfecfin());
		}
		if (arbadhsol != null && arbadhsol.getAdhsoltipnotif() != null) {
			where.append(" AND t1.ADHSOLTIPNOTIF = ?");
			params.add(arbadhsol.getAdhsoltipnotif());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolidioma() != null) {
			where.append(" AND t1.ADHSOLIDIOMA = ?");
			params.add(arbadhsol.getAdhsolidioma());
		}
		if (arbadhsol != null && arbadhsol.getAdhsoltelem() != null) {
			where.append(" AND t1.ADHSOLTELEM = ?");
			params.add(arbadhsol.getAdhsoltelem());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolemail() != null) {
			where.append(" AND t1.ADHSOLEMAIL = ?");
			params.add(arbadhsol.getAdhsolemail());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolsms() != null) {
			where.append(" AND t1.ADHSOLSMS = ?");
			params.add(arbadhsol.getAdhsolsms());
		}
		if (arbadhsol != null && arbadhsol.getAdhsectorid() != null) {
			where.append(" AND t1.ADHSECTORID = ?");
			params.add(arbadhsol.getAdhsectorid());
		}
		if (arbadhsol != null && arbadhsol.getAdhfecalta() != null) {
			where.append(" AND t1.ADHFECALTA = ?");
			params.add(arbadhsol.getAdhfecalta());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolcoor() != null) {
			where.append(" AND t1.ADHSOLCOOR = ?");
			params.add(arbadhsol.getAdhsolcoor());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolnran() != null) {
			where.append(" AND t1.ADHSOLNRAN = ?");
			params.add(arbadhsol.getAdhsolnran());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolnror() != null) {
			where.append(" AND t1.ADHSOLNROR = ?");
			params.add(arbadhsol.getAdhsolnror());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolregen() != null) {
			where.append(" AND t1.ADHSOLREGEN = ?");
			params.add(arbadhsol.getAdhsolregen());
		}
		if (arbadhsol != null && arbadhsol.getAdhespaisid() != null) {
			where.append(" AND t1.ADHESPAISID = ?");
			params.add(arbadhsol.getAdhespaisid());
		}
		if (arbadhsol != null && arbadhsol.getAdhfecregen() != null) {
			where.append(" AND t1.ADHFECREGEN = ?");
			params.add(arbadhsol.getAdhfecregen());
		}
		if (arbadhsol != null && arbadhsol.getAdhescodigo() != null) {
			where.append(" AND t1.ADHESCODIGO = ?");
			params.add(arbadhsol.getAdhescodigo());
		}
		if (arbadhsol != null && arbadhsol.getAdhestado() != null) {
			where.append(" AND t1.ADHESTADO = ?");
			params.add(arbadhsol.getAdhestado());
		}
		if (arbadhsol != null && arbadhsol.getAdhusualta() != null) {
			where.append(" AND t1.ADHUSUALTA = ?");
			params.add(arbadhsol.getAdhusualta());
		}
		if (arbadhsol != null && arbadhsol.getAdhusumodif() != null) {
			where.append(" AND t1.ADHUSUMODIF = ?");
			params.add(arbadhsol.getAdhusumodif());
		}
		if (arbadhsol != null && arbadhsol.getAdhfecmodif() != null) {
			where.append(" AND t1.ADHFECMODIF = ?");
			params.add(arbadhsol.getAdhfecmodif());
		}

		if (arbadhsol != null && arbadhsol.getAdhfechaDesde() != null && arbadhsol.getAdhfechaDesde() instanceof Date) {
			where.append(" AND t1.ADHFECALTA >= ?");
			params.add(arbadhsol.getAdhfechaDesde());
		}
		if (arbadhsol != null && arbadhsol.getAdhfechaHasta() != null && arbadhsol.getAdhfechaHasta() instanceof Date) {
			where.append(" AND t1.ADHFECALTA <= ?");
			params.add(arbadhsol.getAdhfechaHasta());
		}
		if (arbadhsol != null && (arbadhsol.getAdhestadoP() != null || arbadhsol.getAdhestadoA() != null
				|| arbadhsol.getAdhestadoR() != null)) {
			where.append(" AND ( ");
			if (arbadhsol != null && arbadhsol.getAdhestadoP() != null) {
				where.append(" t1.ADHESTADO = ?");
				params.add(arbadhsol.getAdhestadoP());
				if (arbadhsol != null && arbadhsol.getAdhestadoA() != null) {
					where.append(" OR t1.ADHESTADO = ?");
					params.add(arbadhsol.getAdhestadoA());
					if (arbadhsol != null && arbadhsol.getAdhestadoR() != null) {
						where.append(" OR t1.ADHESTADO = ?");
						params.add(arbadhsol.getAdhestadoR());
					}
				} else if (arbadhsol != null && arbadhsol.getAdhestadoR() != null) {
					where.append(" OR t1.ADHESTADO = ?");
					params.add(arbadhsol.getAdhestadoR());
				}
			} else if (arbadhsol != null && arbadhsol.getAdhestadoA() != null) {
				where.append(" t1.ADHESTADO = ?");
				params.add(arbadhsol.getAdhestadoA());
				if (arbadhsol != null && arbadhsol.getAdhestadoR() != null) {
					where.append(" OR t1.ADHESTADO = ?");
					params.add(arbadhsol.getAdhestadoR());
				}
			} else if (arbadhsol != null && arbadhsol.getAdhestadoR() != null) {
				where.append(" t1.ADHESTADO = ?");
				params.add(arbadhsol.getAdhestadoR());
			}
			where.append(")");
		}

		if (censoMonitor != null) {

			String perfil = censoMonitor.getPerfilArbitraje().getIdPerfil();

			if (Y41bConstantes.PERFIL_SUPERVISOR.equals(perfil) || Y41bConstantes.PERFIL_DIRECTOR.equals(perfil)) {
				// ve todo
			} else if (Y41bConstantes.PERFIL_COORDINADOR.equals(perfil)
					|| Y41bConstantes.PERFIL_INSTRUCTOR.equals(perfil)
					|| Y41bConstantes.PERFIL_CONSULTAS.equals(perfil)) {
				/*
				 * // ve lo de su organismo String oficina = ""; oficina =
				 * censoMonitor.getOrganismo().getCodOrg(); if (oficina != null)
				 * { where.append(" AND t1.ADHSOLCOOR = ?");
				 * params.add(oficina); }
				 */
				// ve todo

			} else if (Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO.equals(perfil)) {
				where.append(" AND 1 = 0 ");
			} else if (Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
				where.append(" AND 1 = 0 ");
			}

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhsol entity
	 * 
	 * @param arbadhsol
	 *            Arbadhsol Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereLikeMap(Arbadhsol arbadhsol, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArbadhsolDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhsol != null && arbadhsol.getAdhid() != null) {
			where.append(" AND t1.ADHID = ?");
			params.add(arbadhsol.getAdhid());
		}
		if (arbadhsol != null && arbadhsol.getAdhtipo() != null) {
			where.append(" AND UPPER(t1.ADHTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhtipo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhtipo().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHTIPO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhnif() != null) {
			where.append(" AND UPPER(t1.ADHNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhnif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHNIF IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnom() != null) {
			where.append(" AND UPPER(t1.ADHESNOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnom().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnom().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNOM IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnoco() != null) {
			where.append(" AND UPPER(t1.ADHESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnoco().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnoco().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNOCO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhescoidco() != null) {
			where.append(" AND UPPER(t1.ADHESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhescoidco().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhescoidco().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESCOIDCO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhorgemp() != null) {
			where.append(" AND UPPER(t1.ADHORGEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhorgemp().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhorgemp().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHORGEMP IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesurl() != null) {
			where.append(" AND UPPER(t1.ADHESURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesurl().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesurl().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESURL IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnopeco() != null) {
			where.append(" AND UPPER(t1.ADHESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnopeco().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnopeco().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNOPECO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhescoem() != null) {
			where.append(" AND UPPER(t1.ADHESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhescoem().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhescoem().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESCOEM IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnrtel() != null) {
			where.append(" AND UPPER(t1.ADHESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNRTEL IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnrtel2() != null) {
			where.append(" AND UPPER(t1.ADHESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNRTEL2 IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesextranjero() != null) {
			where.append(" AND UPPER(t1.ADHESEXTRANJERO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesextranjero().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesextranjero().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESEXTRANJERO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnombrecp() != null) {
			where.append(" AND UPPER(t1.ADHESNOMBRECP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnombrecp().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnombrecp().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNOMBRECP IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesprovin() != null) {
			where.append(" AND UPPER(t1.ADHESPROVIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesprovin().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesprovin().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESPROVIN IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesmunici() != null) {
			where.append(" AND UPPER(t1.ADHESMUNICI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesmunici().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesmunici().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESMUNICI IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdheslocali() != null) {
			where.append(" AND UPPER(t1.ADHESLOCALI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdheslocali().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdheslocali().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESLOCALI IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhescalle() != null) {
			where.append(" AND UPPER(t1.ADHESCALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhescalle().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhescalle().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESCALLE IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesportal() != null) {
			where.append(" AND UPPER(t1.ADHESPORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesportal().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesportal().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESPORTAL IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhespiso() != null) {
			where.append(" AND UPPER(t1.ADHESPISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhespiso().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhespiso().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESPISO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesdirecnocapv() != null) {
			where.append(" AND UPPER(t1.ADHESDIRECNOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesdirecnocapv().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesdirecnocapv().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESDIRECNOCAPV IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnorep() != null) {
			where.append(" AND UPPER(t1.ADHESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnorep().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnorep().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNOREP IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesnifrep() != null) {
			where.append(" AND UPPER(t1.ADHESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesnifrep().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESNIFREP IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesintiar() != null) {
			where.append(" AND UPPER(t1.ADHESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesintiar().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesintiar().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESINTIAR IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhesmedia() != null) {
			where.append(" AND UPPER(t1.ADHESMEDIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhesmedia().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhesmedia().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESMEDIA IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhindef() != null) {
			where.append(" AND UPPER(t1.ADHINDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhindef().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhindef().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHINDEF IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhfecfin() != null) {
			where.append(" AND t1.ADHFECFIN = ?");
			params.add(arbadhsol.getAdhfecfin());
		}
		if (arbadhsol != null && arbadhsol.getAdhsoltipnotif() != null) {
			where.append(" AND UPPER(t1.ADHSOLTIPNOTIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsoltipnotif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsoltipnotif().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLTIPNOTIF IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhsolidioma() != null) {
			where.append(" AND UPPER(t1.ADHSOLIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsolidioma().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsolidioma().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLIDIOMA IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhsoltelem() != null) {
			where.append(" AND UPPER(t1.ADHSOLTELEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsoltelem().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsoltelem().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLTELEM IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhsolemail() != null) {
			where.append(" AND UPPER(t1.ADHSOLEMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsolemail().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsolemail().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLEMAIL IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhsolsms() != null) {
			where.append(" AND UPPER(t1.ADHSOLSMS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsolsms().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsolsms().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLSMS IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhsectorid() != null) {
			where.append(" AND UPPER(t1.ADHSECTORID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsectorid().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsectorid().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSECTORID IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhfecalta() != null) {
			where.append(" AND t1.ADHFECALTA = ?");
			params.add(arbadhsol.getAdhfecalta());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolcoor() != null) {
			where.append(" AND UPPER(t1.ADHSOLCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsolcoor().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsolcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLCOOR IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhsolnran() != null) {
			where.append(" AND t1.ADHSOLNRAN = ?");
			params.add(arbadhsol.getAdhsolnran());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolnror() != null) {
			where.append(" AND t1.ADHSOLNROR = ?");
			params.add(arbadhsol.getAdhsolnror());
		}
		if (arbadhsol != null && arbadhsol.getAdhsolregen() != null) {
			where.append(" AND UPPER(t1.ADHSOLREGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhsolregen().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhsolregen().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHSOLREGEN IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhespaisid() != null) {
			where.append(" AND UPPER(t1.ADHESPAISID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhespaisid().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhespaisid().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESPAISID IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhfecregen() != null) {
			where.append(" AND t1.ADHFECREGEN = ?");
			params.add(arbadhsol.getAdhfecregen());
		}
		if (arbadhsol != null && arbadhsol.getAdhescodigo() != null) {
			where.append(" AND UPPER(t1.ADHESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhescodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhescodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESCODIGO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhestado() != null) {
			where.append(" AND UPPER(t1.ADHESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhestado().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhestado().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHESTADO IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhusualta() != null) {
			where.append(" AND UPPER(t1.ADHUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHUSUALTA IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhusumodif() != null) {
			where.append(" AND UPPER(t1.ADHUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhsol.getAdhusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhsol.getAdhusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.ADHUSUMODIF IS NOT NULL");
		}
		if (arbadhsol != null && arbadhsol.getAdhfecmodif() != null) {
			where.append(" AND t1.ADHFECMODIF = ?");
			params.add(arbadhsol.getAdhfecmodif());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * Finds EXNROR
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return long
	 */
	public long findCorrelativoSig(Arbadhsol arbadhsol) {
		String query = "SELECT  MAX(t1.ADHSOLNROR)+1 " + "FROM ARBADHSOL t1   "
				+ "WHERE t1.ADHSOLCOOR = ?   AND t1.ADHSOLNRAN= ? AND t1.ADHTIPO=?";

		List<Object> params = new ArrayList<Object>();
		params.add(arbadhsol.getAdhsolcoor());
		params.add(arbadhsol.getAdhsolnran());
		params.add(arbadhsol.getAdhtipo());

		long correlativo = 0;
		correlativo = this.jdbcTemplate.queryForLong(query, params.toArray());

		if (correlativo == 0) {
			correlativo = 1;
		}
		return correlativo;
	}

	/**
	 * Inserts a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param adhesionTele
	 *            adhesionTele
	 * @return Arbadhsol
	 * 
	 *         NOTA: EN UN PRINCIPIO SE HACA EL nuevo inserta dndole en este
	 *         instante los valores del nmero de expediente por peticin se
	 *         pide que se d en Y41R en el momento de enviar la solicitud.
	 */
	public Arbadhsol addDesdeTelematica(Arbadhsol arbadhsol, AdhesionTele adhesionTele) {
		StringBuilder query = new StringBuilder(ArbadhsolDaoImpl.STRING_BUILDER_INIT);
		query.append("INSERT INTO ARBADHSOL ");
		query.append(
				" ( ADHTIPO, ADHNIF, ADHESNOM, ADHESNOCO, ADHESCOIDCO, ADHORGEMP, ADHESURL, ADHESNOPECO, ADHESCOEM, ADHESNRTEL, ADHESNRTEL2, ADHESEXTRANJERO, ADHESNOMBRECP, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, ADHESNOREP, ADHESNIFREP, ADHESINTIAR, ADHESMEDIA, ADHINDEF, ADHFECFIN, ADHSOLTIPNOTIF, ADHSOLIDIOMA, ADHSOLTELEM, ADHSOLEMAIL, ADHSOLSMS, ADHSECTORID, ADHSOLCOOR, ADHSOLNRAN, ADHSOLNROR, ADHSOLREGEN, ADHESPAISID, ADHFECREGEN, ADHESCODIGO, ADHESTADO) ");
		query.append(" SELECT ");
		query.append(
				"   ADHTIPO, ADHNIF, ADHESNOM, ADHESNOCO, ADHESCOIDCO, ADHORGEMP, ADHESURL, ADHESNOPECO, ADHESCOEM, ADHESNRTEL, ADHESNRTEL2, ADHESEXTRANJERO, ADHESNOMBRECP, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, ADHESNOREP, ADHESNIFREP, ADHESINTIAR, ADHESMEDIA, ADHINDEF, ADHFECFIN, ?, ADHSOLIDIOMA, ADHSOLTELEM, ADHSOLEMAIL, ADHSOLSMS, ADHSECTORID,  ?, ?, ?, ADHSOLREGEN, ADHESPAISID, ADHFECREGEN, ADHESCODIGO, ?");
		query.append(" FROM ADHESION_TELE WHERE ADHESION_TELE.ADHSOLREGEN=? AND ADHESION_TELE.ADHID=?");

		this.jdbcTemplate.update(query.toString(), arbadhsol.getAdhsoltipnotif(), arbadhsol.getAdhsolcoor(),
				arbadhsol.getAdhsolnran(), arbadhsol.getAdhsolnror(), arbadhsol.getAdhestado(),
				adhesionTele.getAdhsolregen(), adhesionTele.getAdhid());
		return arbadhsol;
	}

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return Integer
	 */
	public String currentValue() {
		String query = "SELECT SEQ_L21XHSQ00.CURRVAL FROM DUAL";
		List<Object> params = new ArrayList<Object>();
		Integer entero = this.jdbcTemplate.queryForInt(query.toString(), params.toArray());
		return String.valueOf(entero);
	}

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhsol> findBandeja(Arbadhsol arbadhsol, CensoMonitor censoMonitor, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ADHID ADHID,t1.ADHTIPO ADHTIPO,CASE WHEN t1.ADHTIPO='O' THEN 'B' ELSE t1.ADHTIPO END ADHTIPOAUX,t1.ADHNIF ADHNIF,t1.ADHESNOM ADHESNOM,t1.ADHESNOCO ADHESNOCO,t1.ADHESCOIDCO ADHESCOIDCO,t1.ADHORGEMP ADHORGEMP,t1.ADHESURL ADHESURL,t1.ADHESNOPECO ADHESNOPECO,t1.ADHESCOEM ADHESCOEM,t1.ADHESNRTEL ADHESNRTEL,t1.ADHESNRTEL2 ADHESNRTEL2,t1.ADHESEXTRANJERO ADHESEXTRANJERO,t1.ADHESNOMBRECP ADHESNOMBRECP,t1.ADHESPROVIN ADHESPROVIN,t1.ADHESMUNICI ADHESMUNICI,t1.ADHESLOCALI ADHESLOCALI,t1.ADHESCALLE ADHESCALLE,t1.ADHESPORTAL ADHESPORTAL,t1.ADHESPISO ADHESPISO,t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV,t1.ADHESNOREP ADHESNOREP,t1.ADHESNIFREP ADHESNIFREP,t1.ADHESINTIAR ADHESINTIAR,t1.ADHESMEDIA ADHESMEDIA,t1.ADHINDEF ADHINDEF,t1.ADHFECFIN ADHFECFIN,t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF,t1.ADHSOLIDIOMA ADHSOLIDIOMA,t1.ADHSOLTELEM ADHSOLTELEM,t1.ADHSOLEMAIL ADHSOLEMAIL,t1.ADHSOLSMS ADHSOLSMS,t1.ADHSECTORID ADHSECTORID,t1.ADHFECALTA ADHFECALTA,t1.ADHSOLCOOR ADHSOLCOOR,t1.ADHSOLNRAN ADHSOLNRAN,t1.ADHSOLNROR ADHSOLNROR,t1.ADHSOLREGEN ADHSOLREGEN,t1.ADHESPAISID ADHESPAISID,t1.ADHFECREGEN ADHFECREGEN,t1.ADHESCODIGO ADHESCODIGO,t1.ADHESTADO ADHESTADO,t1.ADHUSUALTA ADHUSUALTA,t1.ADHUSUMODIF ADHUSUMODIF,t1.ADHFECMODIF ADHFECMODIF, ADHNRDI,ADHFECNRDI  ");
		query.append(" ,t1.ADHLIMITACIONES ADHLIMITACIONES, t1.ADHSECTORCAMP ADHSECTORCAMP ");
		query.append("FROM ARBADHSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhsol, censoMonitor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhsol>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findBandejaCount(Arbadhsol arbadhsol, CensoMonitor censoMonitor) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBADHSOL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhsol, censoMonitor);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	public Arbadhsol guardarDatosValidacion(Arbadhsol arbadhsol) {
		String query = "DELETE FROM ARBADHSOLTEMP WHERE ADHID=?";
		this.jdbcTemplate.update(query, arbadhsol.getAdhid());

		query = "INSERT INTO ARBADHSOLTEMP (ADHID, ADHTIPO, ADHNIF, ADHESNOM, ADHESNOCO, ADHESCOIDCO, ADHORGEMP, ADHESURL, ADHESNOPECO, ADHESCOEM, ADHESNRTEL, ADHESNRTEL2, ADHESEXTRANJERO, ADHESNOMBRECP, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, ADHESNOREP, ADHESNIFREP, ADHESINTIAR, ADHESMEDIA, ADHINDEF, ADHFECFIN, ADHSOLTIPNOTIF, ADHSOLIDIOMA, ADHSOLTELEM, ADHSOLEMAIL, ADHSOLSMS, ADHSECTORID, ADHFECALTA, ADHSOLCOOR, ADHSOLNRAN, ADHSOLNROR, ADHSOLREGEN, ADHESPAISID, ADHFECREGEN, ADHESCODIGO, ADHESTADO, ADHUSUALTA, ADHUSUMODIF, ADHFECMODIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbadhsol.getAdhid(), arbadhsol.getAdhtipo(), arbadhsol.getAdhnif(),
				arbadhsol.getAdhesnom(), arbadhsol.getAdhesnoco(), arbadhsol.getAdhescoidco(), arbadhsol.getAdhorgemp(),
				arbadhsol.getAdhesurl(), arbadhsol.getAdhesnopeco(), arbadhsol.getAdhescoem(),
				arbadhsol.getAdhesnrtel(), arbadhsol.getAdhesnrtel2(), arbadhsol.getAdhesextranjero(),
				arbadhsol.getAdhesnombrecp(), arbadhsol.getAdhesprovin(), arbadhsol.getAdhesmunici(),
				arbadhsol.getAdheslocali(), arbadhsol.getAdhescalle(), arbadhsol.getAdhesportal(),
				arbadhsol.getAdhespiso(), arbadhsol.getAdhesdirecnocapv(), arbadhsol.getAdhesnorep(),
				arbadhsol.getAdhesnifrep(), arbadhsol.getAdhesintiar(), arbadhsol.getAdhesmedia(),
				arbadhsol.getAdhindef(), arbadhsol.getAdhfecfin(), arbadhsol.getAdhsoltipnotif(),
				arbadhsol.getAdhsolidioma(), arbadhsol.getAdhsoltelem(), arbadhsol.getAdhsolemail(),
				arbadhsol.getAdhsolsms(), arbadhsol.getAdhsectorid(), arbadhsol.getAdhfecalta(),
				arbadhsol.getAdhsolcoor(), arbadhsol.getAdhsolnran(), arbadhsol.getAdhsolnror(),
				arbadhsol.getAdhsolregen(), arbadhsol.getAdhespaisid(), arbadhsol.getAdhfecregen(),
				arbadhsol.getAdhescodigo(), arbadhsol.getAdhestado(), arbadhsol.getAdhusualta(),
				arbadhsol.getAdhusumodif(), arbadhsol.getAdhfecmodif());
		return arbadhsol;
	}

	/**
	 * Finds a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return Arbadhsol
	 */
	@Transactional(readOnly = true)
	public Arbadhsol findDatosValidacion(Arbadhsol arbadhsol) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.ADHID ADHID, t1.ADHLIMITACIONES ADHLIMITACIONES, t1.ADHTIPO ADHTIPO, t1.ADHNIF ADHNIF, t1.ADHESNOM ADHESNOM, t1.ADHESNOCO ADHESNOCO, t1.ADHESCOIDCO ADHESCOIDCO, t1.ADHORGEMP ADHORGEMP, t1.ADHESURL ADHESURL, t1.ADHESNOPECO ADHESNOPECO, t1.ADHESCOEM ADHESCOEM, t1.ADHESNRTEL ADHESNRTEL, t1.ADHESNRTEL2 ADHESNRTEL2, t1.ADHESEXTRANJERO ADHESEXTRANJERO, t1.ADHESNOMBRECP ADHESNOMBRECP, t1.ADHESPROVIN ADHESPROVIN, t1.ADHESMUNICI ADHESMUNICI, t1.ADHESLOCALI ADHESLOCALI, t1.ADHESCALLE ADHESCALLE, t1.ADHESPORTAL ADHESPORTAL, t1.ADHESPISO ADHESPISO, t1.ADHESDIRECNOCAPV ADHESDIRECNOCAPV, t1.ADHESNOREP ADHESNOREP, t1.ADHESNIFREP ADHESNIFREP, t1.ADHESINTIAR ADHESINTIAR, t1.ADHESMEDIA ADHESMEDIA, t1.ADHINDEF ADHINDEF, t1.ADHFECFIN ADHFECFIN, t1.ADHSOLTIPNOTIF ADHSOLTIPNOTIF, t1.ADHSOLIDIOMA ADHSOLIDIOMA, t1.ADHSOLTELEM ADHSOLTELEM, t1.ADHSOLEMAIL ADHSOLEMAIL, t1.ADHSOLSMS ADHSOLSMS, t1.ADHSECTORID ADHSECTORID, t1.ADHFECALTA ADHFECALTA, t1.ADHSOLCOOR ADHSOLCOOR, t1.ADHSOLNRAN ADHSOLNRAN, t1.ADHSOLNROR ADHSOLNROR, t1.ADHSOLREGEN ADHSOLREGEN, t1.ADHESPAISID ADHESPAISID, t1.ADHFECREGEN ADHFECREGEN, t1.ADHESCODIGO ADHESCODIGO, t1.ADHESTADO ADHESTADO, t1.ADHUSUALTA ADHUSUALTA, t1.ADHUSUMODIF ADHUSUMODIF, t1.ADHFECMODIF ADHFECMODIF, null ADHNRDI,null ADHFECNRDI ");
		query.append(" ,t1.ADHLIMITACIONES ADHLIMITACIONES, t1.ADHSECTORCAMP ADHSECTORCAMP ");
		query.append(" FROM ARBADHSOLTEMP t1  WHERE t1.ADHID = ? ");
		List<Arbadhsol> arbadhsolList = this.jdbcTemplate.query(query.toString(), this.rwMap, arbadhsol.getAdhid());
		if (arbadhsolList != null && arbadhsolList.size() > 0) {
			return arbadhsolList.get(0);
		} else {
			return null;
		}
	}

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	public Arbadhsol guardarDatosComunicacion(Arbadhsol arbadhsol) {
		String query = "SELECT COUNT(1) FROM ARBADHSOLCOM t1 WHERE ADHID=?";
		long cont = this.jdbcTemplate.queryForLong(query, arbadhsol.getAdhid());
		if (cont == 0L) {
			query = "INSERT INTO ARBADHSOLCOM (ADHID, ADHFECHACOM, ADHTEXTO, ADHSEDE, ADHASUNTO, ADHTIPOCOM, ADHCODREM, ADHENVREM, ADHFECREGS, ADHNUMREGS, ADHIDMAILORIGEN, ADHMAILORIGEN, ADHIDMAILDESTINO, ADHMAILDESTINO, ADHCOMMAIL) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			this.jdbcTemplate.update(query, arbadhsol.getAdhid(), arbadhsol.getAdhfechacom(), arbadhsol.getAdhtexto(),
					arbadhsol.getAdhsede(), arbadhsol.getAdhasunto(), arbadhsol.getAdhtipocom(),
					arbadhsol.getAdhcodrem(), arbadhsol.getAdhenvrem(), arbadhsol.getAdhfecregs(),
					arbadhsol.getAdhnumregs(), arbadhsol.getAdhidmailorigen(), arbadhsol.getAdhmailorigen(),
					arbadhsol.getAdhidmaildestino(), arbadhsol.getAdhmaildestino(), arbadhsol.getAdhcommail());
		} else {
			query = "UPDATE ARBADHSOLCOM SET ADHFECHACOM=?, ADHTEXTO=?, ADHSEDE=?, ADHASUNTO=?, ADHTIPOCOM=?, ADHCODREM=?, ADHENVREM=?, ADHFECREGS=?, ADHNUMREGS=?, ADHIDMAILORIGEN=?, ADHMAILORIGEN=?, ADHIDMAILDESTINO=?, ADHMAILDESTINO=?, ADHCOMMAIL=? WHERE ADHID=?";
			this.jdbcTemplate.update(query, arbadhsol.getAdhfechacom(), arbadhsol.getAdhtexto(), arbadhsol.getAdhsede(),
					arbadhsol.getAdhasunto(), arbadhsol.getAdhtipocom(), arbadhsol.getAdhcodrem(),
					arbadhsol.getAdhenvrem(), arbadhsol.getAdhfecregs(), arbadhsol.getAdhnumregs(),
					arbadhsol.getAdhidmailorigen(), arbadhsol.getAdhmailorigen(), arbadhsol.getAdhidmaildestino(),
					arbadhsol.getAdhmaildestino(), arbadhsol.getAdhcommail(), arbadhsol.getAdhid());
		}

		return arbadhsol;
	}

	/**
	 * Finds a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Pagination
	 * @return Arbadhsol
	 */
	@Transactional(readOnly = true)
	public Arbadhsol findDatosComunicacion(Arbadhsol arbadhsol) {
		StringBuilder query = new StringBuilder(
				"SELECT ADHID, ADHFECHACOM, ADHSEDE, ADHASUNTO, ADHTIPOCOM, ADHCODREM, ADHENVREM, ADHFECREGS, ADHNUMREGS, ADHIDMAILORIGEN, ADHMAILORIGEN, ADHIDMAILDESTINO, ADHMAILDESTINO ");
		query.append(", ADHTEXTO, ADHCOMMAIL ");
		query.append("FROM ARBADHSOLCOM t1  WHERE t1.ADHID = ? ");
		List<Arbadhsol> arbadhsolList = this.jdbcTemplate.query(query.toString(), this.rwMapComunicacion,
				arbadhsol.getAdhid());
		if (arbadhsolList != null && arbadhsolList.size() > 0) {
			return arbadhsolList.get(0);
		} else {
			return null;
		}
	}

	// /**
	// * @return long
	// */
	// public int obtenerNumeroAdhesion() {
	// List<Object> params = new ArrayList<Object>();
	// StringBuffer query = new StringBuffer(
	// "SELECT L21XHQ01.NEXTVAL FROM DUAL ");
	// return this.jdbcTemplate
	// .queryForInt(query.toString(), params.toArray());
	// }

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param arbadhsol
	 *            arbadhsol
	 * @return arbadhsol
	 */
	public Arbadhsol updateComRegistroSalidaPlatea(Arbadhsol arbadhsol) {
		String query = "UPDATE ARBADHSOLCOM SET ADHNUMREGS=?, ADHFECREGS=? WHERE ADHID=?";

		this.jdbcTemplate.update(query, arbadhsol.getAdhnumregs(), arbadhsol.getAdhfecregs(), arbadhsol.getAdhid());
		return arbadhsol;
	}

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public int getNewEsperaPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer("SELECT L21XHQ02.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForInt(query.toString(), params.toArray());
	}

}
