package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.y41b.model.AdhesionTele;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.CensoMonitor;

/**
 * ArbadhsolDao  
 * 
 *  
 */

public interface ArbadhsolDao {

	/**
	 * Inserts a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol add(Arbadhsol arbadhsol);

	/**
	 * Updates a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol update(Arbadhsol arbadhsol);

	/**
	 * Finds a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol find(Arbadhsol arbadhsol);

	/**
	 * Deletes a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return
	 */
	void remove(Arbadhsol arbadhsol);

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhsol> findAll(Arbadhsol arbadhsol, Pagination pagination);

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Long
	 */
	Long findAllCount(Arbadhsol arbadhsol);

	/**
	 * Finds rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhsol> findAllLike(Arbadhsol arbadhsol, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbadhsol table using like.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhsol arbadhsol, Boolean startsWith);

	/**
	 * Finds correlativo siguiente
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return long
	 */
	long findCorrelativoSig(Arbadhsol arbadhsol);

	/**
	 * Inserts a single row in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param adhesionTele
	 *            adhesionTele
	 * @return Arbadhsol
	 */
	Arbadhsol addDesdeTelematica(Arbadhsol arbadhsol, AdhesionTele adhesionTele);

	/**
	 * Devuelve el numero de una secuencia
	 * 
	 * @return BigDecimal
	 */
	String currentValue();

	/**
	 * Finds a List of rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhsol> findBandeja(Arbadhsol arbadhsol, CensoMonitor censoMonitor,
			Pagination pagination);

	/**
	 * Counts rows in the Arbadhsol table.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @param censoMonitor
	 *            {@link CensoMonitor}
	 * 
	 * @return Long
	 */
	Long findBandejaCount(Arbadhsol arbadhsol, CensoMonitor censoMonitor);

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol guardarDatosValidacion(Arbadhsol arbadhsol);

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 */
	void removeDatosValidacion(Arbadhsol arbadhsol);

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol findDatosValidacion(Arbadhsol arbadhsol);

	/**
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return Arbadhsol
	 */
	Arbadhsol guardarDatosComunicacion(Arbadhsol arbadhsol);

	/**
	 * @param arbadhsol
	 * @return
	 */
	Arbadhsol findDatosComunicacion(Arbadhsol arbadhsol);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param arbadhsol
	 *            arbadhsol
	 * @return arbadhsol
	 */
	Arbadhsol updateComRegistroSalidaPlatea(Arbadhsol arbadhsol);

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	int getNewEsperaPK();

}
