package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ArbadhintervDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbadhintervDaoImpl implements ArbadhintervDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Arbadhinterv> rwMap = new RowMapper<Arbadhinterv>() {
		public Arbadhinterv mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Arbadhinterv arbadhinterv = new Arbadhinterv(resultSet.getBigDecimal("UAIDINTERV"),
					resultSet.getString("UANOMBRE"), resultSet.getString("UANIF"), resultSet.getString("UANRTEL"),
					resultSet.getString("UANRTEL2"), resultSet.getString("UAPROVID"), resultSet.getString("UAMUNID"),
					resultSet.getString("UALOCID"), resultSet.getString("UACALLEID"), resultSet.getString("UACPID"),
					resultSet.getString("UAPORTALID"), resultSet.getString("UANOMBREPISO"),
					resultSet.getString("UADIRENOCAPV"), resultSet.getString("UADIREANT"),
					resultSet.getString("UATIPOINTERV"), resultSet.getString("UAEXCODIGO"),
					resultSet.getString("UADTCODIGO"), resultSet.getString("UAESCODIGO"),
					resultSet.getDate("UATRFECALTA"), resultSet.getDate("UATRFECMODIF"),
					resultSet.getString("UATRUSUALTA"), resultSet.getString("UATRUSUMODIF"),
					resultSet.getDate("UAFECALTA"), resultSet.getDate("UAFECMODIF"), resultSet.getString("UAUSUALTA"),
					resultSet.getString("UAUSUMODIF"), resultSet.getString("UACOEM"), resultSet.getString("UANODIR"),
					resultSet.getString("UAAPELLIDO1"), resultSet.getString("UAAPELLIDO2"),
					resultSet.getString("UAPAISID"), resultSet.getString("UAENTIDADID"), resultSet.getString("UANOCO"),
					resultSet.getString("UANOPECO"), resultSet.getString("UAURL"), resultSet.getString("UASECODIGO"),
					resultSet.getString("UASENOMBRE"), resultSet.getString("UASENOMBREE"),
					resultSet.getString("UAFECULTMOD"), resultSet.getString("UAUSUULTMOD"),
					resultSet.getString("UAFORMANOTIFICACION"), resultSet.getString("UAIDIOMA"),
					resultSet.getString("UASEXO"), resultSet.getString("UAEDAD"),
					resultSet.getString("UATIPOIDENTIFICACION"));

			arbadhinterv.setUsuarioxlnet(resultSet.getString("CENSOMONITORUSUARIOXLNET"));

			return arbadhinterv;
		}
	};

	private RowMapper<Intervinientes> rwMapInterviniente = new RowMapper<Intervinientes>() {
		public Intervinientes mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Intervinientes interviniente = new Intervinientes();
			interviniente.setNombre(resultSet.getString("UANOMBRE"));
			interviniente.setApellido1(resultSet.getString("UAAPELLIDO1"));
			interviniente.setApellido2(resultSet.getString("UAAPELLIDO2"));
			interviniente.setIdinterviniente(resultSet.getString("UAIDINTERV"));
			return interviniente;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Pagination
	 * @return Arbadhinterv
	 */
	public Arbadhinterv add(Arbadhinterv arbadhinterv) {
		String query = "INSERT INTO ARBADHINTERV (UAIDINTERV, UANOMBRE, UANIF, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UADIRE_ANT, UATIPOINTERV, UAEXCODIGO, UADTCODIGO, UAESCODIGO, UATRFECALTA, UATRFECMODIF, UATRUSUALTA, UATRUSUMODIF, UAFECALTA, UAFECMODIF, UAUSUALTA, UAUSUMODIF, UACOEM, UANODIR, UAAPELLIDO1, UAAPELLIDO2, UAPAIS_ID, UAENTIDAD_ID, UANOCO, UANOPECO, UAURL, UASECODIGO, UASENOMBRE, UASENOMBREE, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UAIDIOMA, UASEXO, UAEDAD, UATIPOIDENTIFICACION) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, arbadhinterv.getUaidinterv(), arbadhinterv.getUanombre(),
				arbadhinterv.getUanif(), arbadhinterv.getUanrtel(), arbadhinterv.getUanrtel2(),
				arbadhinterv.getUaprovId(), arbadhinterv.getUamunId(), arbadhinterv.getUalocId(),
				arbadhinterv.getUacalleId(), arbadhinterv.getUacpId(), arbadhinterv.getUaportalId(),
				arbadhinterv.getUanombrePiso(), arbadhinterv.getUadireNocapv(), arbadhinterv.getUadireAnt(),
				arbadhinterv.getUatipointerv(), arbadhinterv.getUaexcodigo(), arbadhinterv.getUadtcodigo(),
				arbadhinterv.getUaescodigo(), arbadhinterv.getUatrfecalta(), arbadhinterv.getUatrfecmodif(),
				arbadhinterv.getUatrusualta(), arbadhinterv.getUatrusumodif(), arbadhinterv.getUafecalta(),
				arbadhinterv.getUafecmodif(), arbadhinterv.getUausualta(), arbadhinterv.getUausumodif(),
				arbadhinterv.getUacoem(), arbadhinterv.getUanodir(), arbadhinterv.getUaapellido1(),
				arbadhinterv.getUaapellido2(), arbadhinterv.getUapaisId(), arbadhinterv.getUaentidadId(),
				arbadhinterv.getUanoco(), arbadhinterv.getUanopeco(), arbadhinterv.getUaurl(),
				arbadhinterv.getUasecodigo(), arbadhinterv.getUasenombre(), arbadhinterv.getUasenombree(),
				arbadhinterv.getUafecultmod(), arbadhinterv.getUausuultmod(), arbadhinterv.getUaformanotificacion(),
				arbadhinterv.getUaidioma(), arbadhinterv.getUasexo(), arbadhinterv.getUaedad(),
				arbadhinterv.getUatipoidentificacion());
		return arbadhinterv;
	}

	/**
	 * Updates a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Pagination
	 * @return Arbadhinterv
	 */
	public Arbadhinterv actualizaFormaNotificacion(Arbadhinterv arbadhinterv) {
		String query = "UPDATE ARBADHINTERV SET UAFORMANOTIFICACION=? WHERE UAIDINTERV=?";
		this.jdbcTemplate.update(query, arbadhinterv.getUaformanotificacion(), arbadhinterv.getUaidinterv());
		return arbadhinterv;
	}

	/**
	 * Updates a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Pagination
	 * @return Arbadhinterv
	 */
	public Arbadhinterv update(Arbadhinterv arbadhinterv) {
		String query = "UPDATE ARBADHINTERV SET UANOMBRE=?, UANIF=?, UANRTEL=?, UANRTEL2=?, UAPROV_ID=?, UAMUN_ID=?, UALOC_ID=?, UACALLE_ID=?, UACP_ID=?, UAPORTAL_ID=?, UANOMBRE_PISO=?, UADIRE_NOCAPV=?, UADIRE_ANT=?, UATIPOINTERV=?, UAEXCODIGO=?, UADTCODIGO=?, UAESCODIGO=?, UATRFECALTA=?, UATRFECMODIF=?, UATRUSUALTA=?, UATRUSUMODIF=?, UAFECALTA=?, UAFECMODIF=?, UAUSUALTA=?, UAUSUMODIF=?, UACOEM=?, UANODIR=?, UAAPELLIDO1=?, UAAPELLIDO2=?, UAPAIS_ID=?, UAENTIDAD_ID=?, UANOCO=?, UANOPECO=?, UAURL=?, UASECODIGO=?, UASENOMBRE=?, UASENOMBREE=?, UAFECULTMOD=?, UAUSUULTMOD=?, UAFORMANOTIFICACION=?, UAIDIOMA=?, UASEXO=?, UAEDAD=?, UATIPOIDENTIFICACION=? WHERE UAIDINTERV=?";
		this.jdbcTemplate.update(query, arbadhinterv.getUanombre(), arbadhinterv.getUanif(), arbadhinterv.getUanrtel(),
				arbadhinterv.getUanrtel2(), arbadhinterv.getUaprovId(), arbadhinterv.getUamunId(),
				arbadhinterv.getUalocId(), arbadhinterv.getUacalleId(), arbadhinterv.getUacpId(),
				arbadhinterv.getUaportalId(), arbadhinterv.getUanombrePiso(), arbadhinterv.getUadireNocapv(),
				arbadhinterv.getUadireAnt(), arbadhinterv.getUatipointerv(), arbadhinterv.getUaexcodigo(),
				arbadhinterv.getUadtcodigo(), arbadhinterv.getUaescodigo(), arbadhinterv.getUatrfecalta(),
				arbadhinterv.getUatrfecmodif(), arbadhinterv.getUatrusualta(), arbadhinterv.getUatrusumodif(),
				arbadhinterv.getUafecalta(), arbadhinterv.getUafecmodif(), arbadhinterv.getUausualta(),
				arbadhinterv.getUausumodif(), arbadhinterv.getUacoem(), arbadhinterv.getUanodir(),
				arbadhinterv.getUaapellido1(), arbadhinterv.getUaapellido2(), arbadhinterv.getUapaisId(),
				arbadhinterv.getUaentidadId(), arbadhinterv.getUanoco(), arbadhinterv.getUanopeco(),
				arbadhinterv.getUaurl(), arbadhinterv.getUasecodigo(), arbadhinterv.getUasenombre(),
				arbadhinterv.getUasenombree(), arbadhinterv.getUafecultmod(), arbadhinterv.getUausuultmod(),
				arbadhinterv.getUaformanotificacion(), arbadhinterv.getUaidioma(), arbadhinterv.getUasexo(),
				arbadhinterv.getUaedad(), arbadhinterv.getUatipoidentificacion(), arbadhinterv.getUaidinterv());
		return arbadhinterv;
	}

	/**
	 * Finds a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Pagination
	 * @return Arbadhinterv
	 */
	@Transactional(readOnly = true)
	public Arbadhinterv find(Arbadhinterv arbadhinterv) {
		String query = "SELECT t1.UAIDINTERV UAIDINTERV, t1.UANOMBRE UANOMBRE, t1.UANIF UANIF, t1.UANRTEL UANRTEL, t1.UANRTEL2 UANRTEL2, t1.UAPROV_ID UAPROVID, t1.UAMUN_ID UAMUNID, t1.UALOC_ID UALOCID, t1.UACALLE_ID UACALLEID, t1.UACP_ID UACPID, t1.UAPORTAL_ID UAPORTALID, t1.UANOMBRE_PISO UANOMBREPISO, t1.UADIRE_NOCAPV UADIRENOCAPV, t1.UADIRE_ANT UADIREANT, t1.UATIPOINTERV UATIPOINTERV, t1.UAEXCODIGO UAEXCODIGO, t1.UADTCODIGO UADTCODIGO, t1.UAESCODIGO UAESCODIGO, t1.UATRFECALTA UATRFECALTA, t1.UATRFECMODIF UATRFECMODIF, t1.UATRUSUALTA UATRUSUALTA, t1.UATRUSUMODIF UATRUSUMODIF, t1.UAFECALTA UAFECALTA, t1.UAFECMODIF UAFECMODIF, t1.UAUSUALTA UAUSUALTA, t1.UAUSUMODIF UAUSUMODIF, t1.UACOEM UACOEM, t1.UANODIR UANODIR, t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2, t1.UAPAIS_ID UAPAISID, t1.UAENTIDAD_ID UAENTIDADID, t1.UANOCO UANOCO, t1.UANOPECO UANOPECO, t1.UAURL UAURL, t1.UASECODIGO UASECODIGO, t1.UASENOMBRE UASENOMBRE, t1.UASENOMBREE UASENOMBREE, t1.UAFECULTMOD UAFECULTMOD, t1.UAUSUULTMOD UAUSUULTMOD, t1.UAFORMANOTIFICACION UAFORMANOTIFICACION, t1.UAIDIOMA UAIDIOMA, t1.UASEXO UASEXO, t1.UAEDAD UAEDAD, t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION, t3.USUARIOXLNET CENSOMONITORUSUARIOXLNET  FROM ARBADHINTERV t1, CENSO_MONITOR t3  WHERE t1.UAIDINTERV = ? AND t1.UAUSUULTMOD=t3.MOCODIGO(+) ";

		List<Arbadhinterv> arbadhintervList = this.jdbcTemplate.query(query, this.rwMap, arbadhinterv.getUaidinterv());
		return (Arbadhinterv) DataAccessUtils.uniqueResult(arbadhintervList);
	}

	/**
	 * Removes a single row in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Pagination
	 * @return
	 */
	public void remove(Arbadhinterv arbadhinterv) {
		String query = "DELETE FROM ARBADHINTERV WHERE UAIDINTERV=?";
		this.jdbcTemplate.update(query, arbadhinterv.getUaidinterv());
	}

	/**
	 * Finds a List of rows in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhinterv> findAll(Arbadhinterv arbadhinterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE UANOMBRE,t1.UANIF UANIF,t1.UANRTEL UANRTEL,t1.UANRTEL2 UANRTEL2,t1.UAPROV_ID UAPROVID,t1.UAMUN_ID UAMUNID,t1.UALOC_ID UALOCID,t1.UACALLE_ID UACALLEID,t1.UACP_ID UACPID,t1.UAPORTAL_ID UAPORTALID,t1.UANOMBRE_PISO UANOMBREPISO,t1.UADIRE_NOCAPV UADIRENOCAPV,t1.UADIRE_ANT UADIREANT,t1.UATIPOINTERV UATIPOINTERV,t1.UAEXCODIGO UAEXCODIGO,t1.UADTCODIGO UADTCODIGO,t1.UAESCODIGO UAESCODIGO,t1.UATRFECALTA UATRFECALTA,t1.UATRFECMODIF UATRFECMODIF,t1.UATRUSUALTA UATRUSUALTA,t1.UATRUSUMODIF UATRUSUMODIF,t1.UAFECALTA UAFECALTA,t1.UAFECMODIF UAFECMODIF,t1.UAUSUALTA UAUSUALTA,t1.UAUSUMODIF UAUSUMODIF,t1.UACOEM UACOEM,t1.UANODIR UANODIR,t1.UAAPELLIDO1 UAAPELLIDO1,t1.UAAPELLIDO2 UAAPELLIDO2,t1.UAPAIS_ID UAPAISID,t1.UAENTIDAD_ID UAENTIDADID,t1.UANOCO UANOCO,t1.UANOPECO UANOPECO,t1.UAURL UAURL,t1.UASECODIGO UASECODIGO,t1.UASENOMBRE UASENOMBRE,t1.UASENOMBREE UASENOMBREE,t1.UAFECULTMOD UAFECULTMOD,t1.UAUSUULTMOD UAUSUULTMOD,t1.UAFORMANOTIFICACION UAFORMANOTIFICACION,t1.UAIDIOMA UAIDIOMA,t1.UASEXO UASEXO,t1.UAEDAD UAEDAD,t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION, t3.USUARIOXLNET CENSOMONITORUSUARIOXLNET  ");
		query.append("FROM ARBADHINTERV t1, ARBADHSOL t2, CENSO_MONITOR t3   ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhinterv);
		StringBuilder where = new StringBuilder(
				" WHERE t1.UAEXCODIGO = t2.ADHID(+) AND t1.UAUSUULTMOD=t3.MOCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhinterv>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbadhinterv arbadhinterv) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBADHINTERV t1, ARBADHSOL t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhinterv);
		StringBuilder where = new StringBuilder(" WHERE t1.UAEXCODIGO = t2.ADHID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Arbadhinterv table using like.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhinterv> findAllLike(Arbadhinterv arbadhinterv, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE UANOMBRE,t1.UANIF UANIF,t1.UANRTEL UANRTEL,t1.UANRTEL2 UANRTEL2,t1.UAPROV_ID UAPROVID,t1.UAMUN_ID UAMUNID,t1.UALOC_ID UALOCID,t1.UACALLE_ID UACALLEID,t1.UACP_ID UACPID,t1.UAPORTAL_ID UAPORTALID,t1.UANOMBRE_PISO UANOMBREPISO,t1.UADIRE_NOCAPV UADIRENOCAPV,t1.UADIRE_ANT UADIREANT,t1.UATIPOINTERV UATIPOINTERV,t1.UAEXCODIGO UAEXCODIGO,t1.UADTCODIGO UADTCODIGO,t1.UAESCODIGO UAESCODIGO,t1.UATRFECALTA UATRFECALTA,t1.UATRFECMODIF UATRFECMODIF,t1.UATRUSUALTA UATRUSUALTA,t1.UATRUSUMODIF UATRUSUMODIF,t1.UAFECALTA UAFECALTA,t1.UAFECMODIF UAFECMODIF,t1.UAUSUALTA UAUSUALTA,t1.UAUSUMODIF UAUSUMODIF,t1.UACOEM UACOEM,t1.UANODIR UANODIR,t1.UAAPELLIDO1 UAAPELLIDO1,t1.UAAPELLIDO2 UAAPELLIDO2,t1.UAPAIS_ID UAPAISID,t1.UAENTIDAD_ID UAENTIDADID,t1.UANOCO UANOCO,t1.UANOPECO UANOPECO,t1.UAURL UAURL,t1.UASECODIGO UASECODIGO,t1.UASENOMBRE UASENOMBRE,t1.UASENOMBREE UASENOMBREE,t1.UAFECULTMOD UAFECULTMOD,t1.UAUSUULTMOD UAUSUULTMOD,t1.UAFORMANOTIFICACION UAFORMANOTIFICACION,t1.UAIDIOMA UAIDIOMA,t1.UASEXO UASEXO,t1.UAEDAD UAEDAD,t1.UATIPOIDENTIFICACION UATIPOIDENTIFICACION, t3.USUARIOXLNET CENSOMONITORUSUARIOXLNET  ");
		query.append("FROM ARBADHINTERV t1, ARBADHSOL t2, CENSO_MONITOR t3   ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhinterv, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.UAEXCODIGO = t2.ADHID(+) AND t1.UAUSUULTMOD=t3.MOCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhinterv>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhinterv table using like.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbadhinterv arbadhinterv, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ARBADHINTERV t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhinterv, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhinterv entity
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbadhinterv arbadhinterv) {

		StringBuilder where = new StringBuilder(ArbadhintervDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhinterv != null && arbadhinterv.getUaidinterv() != null) {
			where.append(" AND t1.UAIDINTERV = ?");
			params.add(arbadhinterv.getUaidinterv());
		}
		if (arbadhinterv != null && arbadhinterv.getUanombre() != null) {
			where.append(" AND t1.UANOMBRE = ?");
			params.add(arbadhinterv.getUanombre());
		}
		if (arbadhinterv != null && arbadhinterv.getUanif() != null) {
			where.append(" AND t1.UANIF = ?");
			params.add(arbadhinterv.getUanif());
		}
		if (arbadhinterv != null && arbadhinterv.getUanrtel() != null) {
			where.append(" AND t1.UANRTEL = ?");
			params.add(arbadhinterv.getUanrtel());
		}
		if (arbadhinterv != null && arbadhinterv.getUanrtel2() != null) {
			where.append(" AND t1.UANRTEL2 = ?");
			params.add(arbadhinterv.getUanrtel2());
		}
		if (arbadhinterv != null && arbadhinterv.getUaprovId() != null) {
			where.append(" AND t1.UAPROV_ID = ?");
			params.add(arbadhinterv.getUaprovId());
		}
		if (arbadhinterv != null && arbadhinterv.getUamunId() != null) {
			where.append(" AND t1.UAMUN_ID = ?");
			params.add(arbadhinterv.getUamunId());
		}
		if (arbadhinterv != null && arbadhinterv.getUalocId() != null) {
			where.append(" AND t1.UALOC_ID = ?");
			params.add(arbadhinterv.getUalocId());
		}
		if (arbadhinterv != null && arbadhinterv.getUacalleId() != null) {
			where.append(" AND t1.UACALLE_ID = ?");
			params.add(arbadhinterv.getUacalleId());
		}
		if (arbadhinterv != null && arbadhinterv.getUacpId() != null) {
			where.append(" AND t1.UACP_ID = ?");
			params.add(arbadhinterv.getUacpId());
		}
		if (arbadhinterv != null && arbadhinterv.getUaportalId() != null) {
			where.append(" AND t1.UAPORTAL_ID = ?");
			params.add(arbadhinterv.getUaportalId());
		}
		if (arbadhinterv != null && arbadhinterv.getUanombrePiso() != null) {
			where.append(" AND t1.UANOMBRE_PISO = ?");
			params.add(arbadhinterv.getUanombrePiso());
		}
		if (arbadhinterv != null && arbadhinterv.getUadireNocapv() != null) {
			where.append(" AND t1.UADIRE_NOCAPV = ?");
			params.add(arbadhinterv.getUadireNocapv());
		}
		if (arbadhinterv != null && arbadhinterv.getUadireAnt() != null) {
			where.append(" AND t1.UADIRE_ANT = ?");
			params.add(arbadhinterv.getUadireAnt());
		}
		if (arbadhinterv != null && arbadhinterv.getUatipointerv() != null) {
			where.append(" AND t1.UATIPOINTERV = ?");
			params.add(arbadhinterv.getUatipointerv());
		}
		if (arbadhinterv != null && arbadhinterv.getUaexcodigo() != null) {
			where.append(" AND t1.UAEXCODIGO = ?");
			params.add(arbadhinterv.getUaexcodigo());
		}
		if (arbadhinterv != null && arbadhinterv.getUadtcodigo() != null) {
			where.append(" AND t1.UADTCODIGO = ?");
			params.add(arbadhinterv.getUadtcodigo());
		}
		if (arbadhinterv != null && arbadhinterv.getUaescodigo() != null) {
			where.append(" AND t1.UAESCODIGO = ?");
			params.add(arbadhinterv.getUaescodigo());
		}
		if (arbadhinterv != null && arbadhinterv.getUatrfecalta() != null) {
			where.append(" AND t1.UATRFECALTA = ?");
			params.add(arbadhinterv.getUatrfecalta());
		}
		if (arbadhinterv != null && arbadhinterv.getUatrfecmodif() != null) {
			where.append(" AND t1.UATRFECMODIF = ?");
			params.add(arbadhinterv.getUatrfecmodif());
		}
		if (arbadhinterv != null && arbadhinterv.getUatrusualta() != null) {
			where.append(" AND t1.UATRUSUALTA = ?");
			params.add(arbadhinterv.getUatrusualta());
		}
		if (arbadhinterv != null && arbadhinterv.getUatrusumodif() != null) {
			where.append(" AND t1.UATRUSUMODIF = ?");
			params.add(arbadhinterv.getUatrusumodif());
		}
		if (arbadhinterv != null && arbadhinterv.getUafecalta() != null) {
			where.append(" AND t1.UAFECALTA = ?");
			params.add(arbadhinterv.getUafecalta());
		}
		if (arbadhinterv != null && arbadhinterv.getUafecmodif() != null) {
			where.append(" AND t1.UAFECMODIF = ?");
			params.add(arbadhinterv.getUafecmodif());
		}
		if (arbadhinterv != null && arbadhinterv.getUausualta() != null) {
			where.append(" AND t1.UAUSUALTA = ?");
			params.add(arbadhinterv.getUausualta());
		}
		if (arbadhinterv != null && arbadhinterv.getUausumodif() != null) {
			where.append(" AND t1.UAUSUMODIF = ?");
			params.add(arbadhinterv.getUausumodif());
		}
		if (arbadhinterv != null && arbadhinterv.getUacoem() != null) {
			where.append(" AND t1.UACOEM = ?");
			params.add(arbadhinterv.getUacoem());
		}
		if (arbadhinterv != null && arbadhinterv.getUanodir() != null) {
			where.append(" AND t1.UANODIR = ?");
			params.add(arbadhinterv.getUanodir());
		}
		if (arbadhinterv != null && arbadhinterv.getUaapellido1() != null) {
			where.append(" AND t1.UAAPELLIDO1 = ?");
			params.add(arbadhinterv.getUaapellido1());
		}
		if (arbadhinterv != null && arbadhinterv.getUaapellido2() != null) {
			where.append(" AND t1.UAAPELLIDO2 = ?");
			params.add(arbadhinterv.getUaapellido2());
		}
		if (arbadhinterv != null && arbadhinterv.getUapaisId() != null) {
			where.append(" AND t1.UAPAIS_ID = ?");
			params.add(arbadhinterv.getUapaisId());
		}
		if (arbadhinterv != null && arbadhinterv.getUaentidadId() != null) {
			where.append(" AND t1.UAENTIDAD_ID = ?");
			params.add(arbadhinterv.getUaentidadId());
		}
		if (arbadhinterv != null && arbadhinterv.getUanoco() != null) {
			where.append(" AND t1.UANOCO = ?");
			params.add(arbadhinterv.getUanoco());
		}
		if (arbadhinterv != null && arbadhinterv.getUanopeco() != null) {
			where.append(" AND t1.UANOPECO = ?");
			params.add(arbadhinterv.getUanopeco());
		}
		if (arbadhinterv != null && arbadhinterv.getUaurl() != null) {
			where.append(" AND t1.UAURL = ?");
			params.add(arbadhinterv.getUaurl());
		}
		if (arbadhinterv != null && arbadhinterv.getUasecodigo() != null) {
			where.append(" AND t1.UASECODIGO = ?");
			params.add(arbadhinterv.getUasecodigo());
		}
		if (arbadhinterv != null && arbadhinterv.getUasenombre() != null) {
			where.append(" AND t1.UASENOMBRE = ?");
			params.add(arbadhinterv.getUasenombre());
		}
		if (arbadhinterv != null && arbadhinterv.getUasenombree() != null) {
			where.append(" AND t1.UASENOMBREE = ?");
			params.add(arbadhinterv.getUasenombree());
		}
		if (arbadhinterv != null && arbadhinterv.getUafecultmod() != null) {
			where.append(" AND t1.UAFECULTMOD = ?");
			params.add(arbadhinterv.getUafecultmod());
		}
		if (arbadhinterv != null && arbadhinterv.getUausuultmod() != null) {
			where.append(" AND t1.UAUSUULTMOD = ?");
			params.add(arbadhinterv.getUausuultmod());
		}
		if (arbadhinterv != null && arbadhinterv.getUaformanotificacion() != null) {
			where.append(" AND t1.UAFORMANOTIFICACION = ?");
			params.add(arbadhinterv.getUaformanotificacion());
		}
		if (arbadhinterv != null && arbadhinterv.getUaidioma() != null) {
			where.append(" AND t1.UAIDIOMA = ?");
			params.add(arbadhinterv.getUaidioma());
		}
		if (arbadhinterv != null && arbadhinterv.getUasexo() != null) {
			where.append(" AND t1.UASEXO = ?");
			params.add(arbadhinterv.getUasexo());
		}
		if (arbadhinterv != null && arbadhinterv.getUaedad() != null) {
			where.append(" AND t1.UAEDAD = ?");
			params.add(arbadhinterv.getUaedad());
		}
		if (arbadhinterv != null && arbadhinterv.getUatipoidentificacion() != null) {
			where.append(" AND t1.UATIPOIDENTIFICACION = ?");
			params.add(arbadhinterv.getUatipoidentificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhinterv entity
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbadhinterv arbadhinterv, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ArbadhintervDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhinterv != null && arbadhinterv.getUaidinterv() != null) {
			where.append(" AND t1.UAIDINTERV = ?");
			params.add(arbadhinterv.getUaidinterv());
		}
		if (arbadhinterv != null && arbadhinterv.getUanombre() != null) {
			where.append(" AND UPPER(t1.UANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanombre().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOMBRE IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanif() != null) {
			where.append(" AND UPPER(t1.UANIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanif().toUpperCase() + "%");
			}
			where.append(" AND t1.UANIF IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanrtel() != null) {
			where.append(" AND UPPER(t1.UANRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanrtel().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.UANRTEL IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanrtel2() != null) {
			where.append(" AND UPPER(t1.UANRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.UANRTEL2 IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaprovId() != null) {
			where.append(" AND UPPER(t1.UAPROV_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaprovId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaprovId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPROV_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUamunId() != null) {
			where.append(" AND UPPER(t1.UAMUN_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUamunId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUamunId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAMUN_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUalocId() != null) {
			where.append(" AND UPPER(t1.UALOC_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUalocId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUalocId().toUpperCase() + "%");
			}
			where.append(" AND t1.UALOC_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUacalleId() != null) {
			where.append(" AND UPPER(t1.UACALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUacalleId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUacalleId().toUpperCase() + "%");
			}
			where.append(" AND t1.UACALLE_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUacpId() != null) {
			where.append(" AND UPPER(t1.UACP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUacpId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUacpId().toUpperCase() + "%");
			}
			where.append(" AND t1.UACP_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaportalId() != null) {
			where.append(" AND UPPER(t1.UAPORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaportalId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaportalId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPORTAL_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanombrePiso() != null) {
			where.append(" AND UPPER(t1.UANOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOMBRE_PISO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUadireNocapv() != null) {
			where.append(" AND UPPER(t1.UADIRE_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUadireNocapv().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUadireNocapv().toUpperCase() + "%");
			}
			where.append(" AND t1.UADIRE_NOCAPV IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUadireAnt() != null) {
			where.append(" AND UPPER(t1.UADIRE_ANT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUadireAnt().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUadireAnt().toUpperCase() + "%");
			}
			where.append(" AND t1.UADIRE_ANT IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUatipointerv() != null) {
			where.append(" AND UPPER(t1.UATIPOINTERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUatipointerv().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUatipointerv().toUpperCase() + "%");
			}
			where.append(" AND t1.UATIPOINTERV IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaexcodigo() != null) {
			where.append(" AND UPPER(t1.UAEXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaexcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaexcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UAEXCODIGO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUadtcodigo() != null) {
			where.append(" AND UPPER(t1.UADTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUadtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUadtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UADTCODIGO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaescodigo() != null) {
			where.append(" AND UPPER(t1.UAESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaescodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaescodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UAESCODIGO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUatrfecalta() != null) {
			where.append(" AND t1.UATRFECALTA = ?");
			params.add(arbadhinterv.getUatrfecalta());
		}
		if (arbadhinterv != null && arbadhinterv.getUatrfecmodif() != null) {
			where.append(" AND t1.UATRFECMODIF = ?");
			params.add(arbadhinterv.getUatrfecmodif());
		}
		if (arbadhinterv != null && arbadhinterv.getUatrusualta() != null) {
			where.append(" AND UPPER(t1.UATRUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUatrusualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUatrusualta().toUpperCase() + "%");
			}
			where.append(" AND t1.UATRUSUALTA IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUatrusumodif() != null) {
			where.append(" AND UPPER(t1.UATRUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUatrusumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUatrusumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.UATRUSUMODIF IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUafecalta() != null) {
			where.append(" AND t1.UAFECALTA = ?");
			params.add(arbadhinterv.getUafecalta());
		}
		if (arbadhinterv != null && arbadhinterv.getUafecmodif() != null) {
			where.append(" AND t1.UAFECMODIF = ?");
			params.add(arbadhinterv.getUafecmodif());
		}
		if (arbadhinterv != null && arbadhinterv.getUausualta() != null) {
			where.append(" AND UPPER(t1.UAUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUausualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUausualta().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUALTA IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUausumodif() != null) {
			where.append(" AND UPPER(t1.UAUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUausumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUausumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUMODIF IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUacoem() != null) {
			where.append(" AND UPPER(t1.UACOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUacoem().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUacoem().toUpperCase() + "%");
			}
			where.append(" AND t1.UACOEM IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanodir() != null) {
			where.append(" AND UPPER(t1.UANODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanodir().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanodir().toUpperCase() + "%");
			}
			where.append(" AND t1.UANODIR IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaapellido1() != null) {
			where.append(" AND UPPER(t1.UAAPELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaapellido1().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaapellido1().toUpperCase() + "%");
			}
			where.append(" AND t1.UAAPELLIDO1 IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaapellido2() != null) {
			where.append(" AND UPPER(t1.UAAPELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaapellido2().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaapellido2().toUpperCase() + "%");
			}
			where.append(" AND t1.UAAPELLIDO2 IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUapaisId() != null) {
			where.append(" AND UPPER(t1.UAPAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUapaisId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUapaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAPAIS_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaentidadId() != null) {
			where.append(" AND UPPER(t1.UAENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaentidadId().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaentidadId().toUpperCase() + "%");
			}
			where.append(" AND t1.UAENTIDAD_ID IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanoco() != null) {
			where.append(" AND UPPER(t1.UANOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanoco().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanoco().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOCO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUanopeco() != null) {
			where.append(" AND UPPER(t1.UANOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUanopeco().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUanopeco().toUpperCase() + "%");
			}
			where.append(" AND t1.UANOPECO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaurl() != null) {
			where.append(" AND UPPER(t1.UAURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaurl().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaurl().toUpperCase() + "%");
			}
			where.append(" AND t1.UAURL IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUasecodigo() != null) {
			where.append(" AND UPPER(t1.UASECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUasecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUasecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.UASECODIGO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUasenombre() != null) {
			where.append(" AND UPPER(t1.UASENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUasenombre().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUasenombre().toUpperCase() + "%");
			}
			where.append(" AND t1.UASENOMBRE IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUasenombree() != null) {
			where.append(" AND UPPER(t1.UASENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUasenombree().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUasenombree().toUpperCase() + "%");
			}
			where.append(" AND t1.UASENOMBREE IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUafecultmod() != null) {
			where.append(" AND UPPER(t1.UAFECULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUafecultmod().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUafecultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.UAFECULTMOD IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUausuultmod() != null) {
			where.append(" AND UPPER(t1.UAUSUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUausuultmod().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUausuultmod().toUpperCase() + "%");
			}
			where.append(" AND t1.UAUSUULTMOD IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaformanotificacion() != null) {
			where.append(" AND UPPER(t1.UAFORMANOTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaformanotificacion().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaformanotificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.UAFORMANOTIFICACION IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaidioma() != null) {
			where.append(" AND UPPER(t1.UAIDIOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaidioma().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaidioma().toUpperCase() + "%");
			}
			where.append(" AND t1.UAIDIOMA IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUasexo() != null) {
			where.append(" AND UPPER(t1.UASEXO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUasexo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUasexo().toUpperCase() + "%");
			}
			where.append(" AND t1.UASEXO IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUaedad() != null) {
			where.append(" AND UPPER(t1.UAEDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUaedad().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUaedad().toUpperCase() + "%");
			}
			where.append(" AND t1.UAEDAD IS NOT NULL");
		}
		if (arbadhinterv != null && arbadhinterv.getUatipoidentificacion() != null) {
			where.append(" AND UPPER(t1.UATIPOIDENTIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhinterv.getUatipoidentificacion().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhinterv.getUatipoidentificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.UATIPOIDENTIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Dame reclamado.
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbadhinterv
	 */
	public Arbadhinterv dameInterviniente(String sacodigo, String tipo) {
		{
			Arbadhinterv arbadhinterv = new Arbadhinterv();
			arbadhinterv.setUaexcodigo(sacodigo);
			arbadhinterv.setUatipointerv(tipo);
			List<Arbadhinterv> listaArbadhinterv = this.findAll(arbadhinterv, null);
			if (listaArbadhinterv != null) {
				if (listaArbadhinterv.size() > 0) {
					arbadhinterv = listaArbadhinterv.get(0);
					return arbadhinterv;
				}
			}
			return null;

		}
	}

	/**
	 * Finds a List of rows in the Arbadhinterv table.
	 * 
	 * @param arbadhinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	public List<Intervinientes> findAllIntervinientes(Intervinientes arbadhinterv, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.UAIDINTERV UAIDINTERV,t1.UANOMBRE||' '||nvl(t1.UAAPELLIDO1,'')||' '||nvl(t1.UAAPELLIDO2,'') UANOMBRE,t1.UAAPELLIDO1 UAAPELLIDO1, t1.UAAPELLIDO2 UAAPELLIDO2 ");
		query.append(" FROM ARBADHINTERV t1 ,ARBADHSOL t2 ");

		// Where clause & Params

		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 AND t1.UAEXCODIGO= t2.ADHID(+) AND t2.ADHID = ? ");
		params.add(arbadhinterv.getIdExpediente());

		if (arbadhinterv.getTipoInterviniente() != null) {
			where.append(" AND t1.UATIPOINTERV IN (").append(arbadhinterv.getTipoInterviniente()).append(")");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(), this.rwMapInterviniente,
				params.toArray());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.ArbadhintervDao#volcarDatosValidacion(java.math.
	 * BigDecimal )
	 */
	@Override
	public Long volcarDatosValidacion(String adhid) {
		Long idInterv = this.getNewPK();
		StringBuffer query = new StringBuffer(
				"INSERT INTO ARBADHINTERV (UAIDINTERV, UANOMBRE, UANIF, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UADIRE_ANT, UATIPOINTERV, UAEXCODIGO, UADTCODIGO, UAESCODIGO, UACOEM, UANODIR, UAAPELLIDO1, UAAPELLIDO2, UAPAIS_ID, UAENTIDAD_ID, UANOCO, UANOPECO, UAURL, UASECODIGO, UASENOMBRE, UASENOMBREE, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UAIDIOMA, UASEXO, UAEDAD, UATIPOIDENTIFICACION)");
		query.append(
				"SELECT ?, ADHESNOM, ADHNIF, ADHESNRTEL, ADHESNRTEL2, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESNOMBRECP, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, null, ?, ADHID, null, ADHESCODIGO, ADHESCOEM, null, null, null, ADHESPAISID, null, ADHESNOCO, ADHESNOPECO, ADHESURL, ADHSECTORID, null, null, null, null, ADHSOLTIPNOTIF, ADHESCOIDCO, null, null, null FROM ARBADHSOLTEMP WHERE ADHID=?");
		this.jdbcTemplate.update(query.toString(), idInterv, Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO,
				adhid);
		return idInterv;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.y41b.dao.ArbadhintervDao#volcarDatosValidacion(java.math.
	 * BigDecimal )
	 */
	@Override
	public Long volcarDatosSolicitud(String adhid) {
		Long idInterv = this.getNewPK();
		StringBuffer query = new StringBuffer(
				"INSERT INTO ARBADHINTERV (UAIDINTERV, UANOMBRE, UANIF, UANRTEL, UANRTEL2, UAPROV_ID, UAMUN_ID, UALOC_ID, UACALLE_ID, UACP_ID, UAPORTAL_ID, UANOMBRE_PISO, UADIRE_NOCAPV, UADIRE_ANT, UATIPOINTERV, UAEXCODIGO, UADTCODIGO, UAESCODIGO, UACOEM, UANODIR, UAAPELLIDO1, UAAPELLIDO2, UAPAIS_ID, UAENTIDAD_ID, UANOCO, UANOPECO, UAURL, UASECODIGO, UASENOMBRE, UASENOMBREE, UAFECULTMOD, UAUSUULTMOD, UAFORMANOTIFICACION, UAIDIOMA, UASEXO, UAEDAD, UATIPOIDENTIFICACION)");
		query.append(
				"SELECT ?, ADHESNOM, ADHNIF, ADHESNRTEL, ADHESNRTEL2, ADHESPROVIN, ADHESMUNICI, ADHESLOCALI, ADHESCALLE, ADHESNOMBRECP, ADHESPORTAL, ADHESPISO, ADHESDIRECNOCAPV, null, ?, ADHID, null, ADHESCODIGO, ADHESCOEM, null, null, null, ADHESPAISID, null, ADHESNOCO, ADHESNOPECO, ADHESURL, ADHSECTORID, null, null, null, null, ADHSOLTIPNOTIF, ADHESCOIDCO, null, null, null FROM ARBADHSOL WHERE ADHID=?");
		this.jdbcTemplate.update(query.toString(), idInterv, Y41bConstantes.TIPO_INTERVINIENTEARB_ESTABLECIMIENTO,
				adhid);
		return idInterv;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {
		try {
			List<Object> params = new ArrayList<Object>();

			StringBuffer query = new StringBuffer("SELECT L21XAQ02.NEXTVAL FROM DUAL");
			return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates rows in the Arbadhinterv table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar) {
		try {
			String query = "UPDATE ARBADHINTERV SET UAESCODIGO=? WHERE UAESCODIGO=? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {

		}
	}
}
