package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Arbadhinterv;
import com.ejie.y41b.model.Intervinientes;

/**
 * ArbadhintervDao  
 * 
 *  
 */

public interface ArbadhintervDao {

	/**
	 * Inserts a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv add(Arbadhinterv arbinterv);

	/**
	 * Updates a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv update(Arbadhinterv arbinterv);

	/**
	 * Updates a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv actualizaFormaNotificacion(Arbadhinterv arbinterv);

	/**
	 * Finds a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Arbadhinterv
	 */
	Arbadhinterv find(Arbadhinterv arbinterv);

	/**
	 * Deletes a single row in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return
	 */
	void remove(Arbadhinterv arbinterv);

	/**
	 * Finds a List of rows in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhinterv> findAll(Arbadhinterv arbinterv, Pagination pagination);

	/**
	 * Counts rows in the Arbadhinterv table.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @return Long
	 */
	Long findAllCount(Arbadhinterv arbinterv);

	/**
	 * Finds rows in the Arbadhinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhinterv> findAllLike(Arbadhinterv arbinterv, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Arbadhinterv table using like.
	 * 
	 * @param arbinterv
	 *            Arbadhinterv
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhinterv arbinterv, Boolean startsWith);

	/**
	 * 
	 * @param sacodigo
	 *            String
	 * @param tipo
	 *            String
	 * @return Arbadhinterv
	 */
	Arbadhinterv dameInterviniente(String sacodigo, String tipo);

	/**
	 * @param intervinientes
	 * @param pagination
	 * @return
	 */
	List<Intervinientes> findAllIntervinientes(Intervinientes intervinientes, Pagination pagination);

	/**
	 * @param adhid
	 *            String
	 * @return Long
	 */
	Long volcarDatosValidacion(String adhid);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * @param adhid
	 *            String
	 * @return
	 */
	Long volcarDatosSolicitud(String adhid);

	/**
	 * Updates rows in the Arbadhinterv table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno, String escodigoAfusionar);

}
