package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbtipdoc;
import com.ejie.y41b.model.Docadhtele;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * ArbadhdocDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ArbadhdocDaoImpl implements ArbadhdocDao {
	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory
			.getLogger(JdbcTemplate.class);

	private RowMapper<Arbadhdoc> rwMap = new RowMapper<Arbadhdoc>() {
		public Arbadhdoc mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Arbadhdoc(resultSet.getString("X5CODOCUMENTO"),
					resultSet.getString("X5EXCODIGO"),
					resultSet.getString("X5NOFILE"),
					resultSet.getBlob("X5DATAFILE"),
					resultSet.getInt("X5SIZEFILE"),
					resultSet.getString("X5TEDESFILE"),
					resultSet.getString("X5ORIGEN"),
					resultSet.getString("X5TRAMITE"),
					resultSet.getDate("X5FECHA"),
					resultSet.getString("X5CONTTYPE"),
					resultSet.getString("X5INDMAIL"),
					resultSet.getString("X5TRMAIL"),
					resultSet.getString("X5IDDOCUMENTUM"),
					resultSet.getDate("X5FECHAAPORTACION"),
					resultSet.getDate("X5FECHAENTRADA"),
					resultSet.getString("X5NUMREGISTROENTRADA"),
					resultSet.getString("X5IDPERFILFIRMA"),
					resultSet.getString("X5ESTADODOCUMENTO"),
					resultSet.getDate("X5FECHASOLFIRMA"),
					resultSet.getDate("X5FECHAFIRMA"),
					resultSet.getString("X5COMOFIRMA"),
					resultSet.getDate("X5FECALTA"),
					resultSet.getDate("X5FECMODIF"),
					resultSet.getString("X5USUALTA"),
					resultSet.getString("X5USUMODIF"),
					resultSet.getDate("X5FECHALIMFIRMA"),
					resultSet.getString("X5DESTINO"),
					resultSet.getString("X5PTCODIGO"),
					resultSet.getTimestamp("X5FECHASOLLOCALIZADOR"),
					resultSet.getString("X5NUMREGISTROORIGEN"),
					resultSet.getDate("X5FECHAREGISTROORIGEN"), new Arbtipdoc(
							resultSet.getString("ArbtipdocTDID"),
							resultSet.getString("ArbtipdocIDTIPODOC"),
							resultSet.getString("ArbtipdocTDNOMBRE"),
							resultSet.getString("ArbtipdocTDNOMBREE"),
							resultSet.getString("ArbtipdocTDPCODIGO"),
							resultSet.getDate("ArbtipdocTDFECALTA"),
							resultSet.getDate("ArbtipdocTDFECMODIF"),
							resultSet.getString("ArbtipdocTDUSUALTA"),
							resultSet.getString("ArbtipdocTDUSUMODIF"),
							resultSet.getString("ArbtipdocTDTIPO")),
					resultSet.getString("PCODIGO"));
		}
	};

	private RowMapper<DocumentoExpediente> rwMapDocExp = new RowMapper<DocumentoExpediente>() {
		public DocumentoExpediente mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			return new DocumentoExpediente(
					resultSet.getString("X5CODOCUMENTO"),
					resultSet.getString("X5EXCODIGO"),
					resultSet.getString("X5NOFILE"), null,
					resultSet.getInt("X5SIZEFILE"),
					resultSet.getString("X5CONTTYPE"),
					resultSet.getString("X5TEDESFILE"),
					resultSet.getString("X5ORIGEN"),
					resultSet.getDate("X5FECHA"),
					resultSet.getString("X5IDDOCUMENTUM"), null, null, null,
					resultSet.getString("IDTIPODOC"),
					resultSet.getString("TDNOMBRE"),
					resultSet.getString("TDNOMBREE"), null, null, null, null,
					null, null, null, null);

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Pagination
	 * @return Arbadhdoc
	 */
	public Arbadhdoc add(Arbadhdoc arbadhdoc) {
		String query = "INSERT INTO ARBADHDOC (X5CODOCUMENTO, X5TRAMITE, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5FECHA, X5CONTTYPE, X5INDMAIL, X5TRMAIL, X5IDDOCUMENTUM, X5TIPODOCUMENTO, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5FECALTA, X5FECMODIF, X5USUALTA, X5USUMODIF, X5FECHALIMFIRMA, X5DESTINO, X5PTCODIGO, X5FECHASOLLOCALIZADOR, X5NUMREGISTROORIGEN, X5FECHAREGISTROORIGEN) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getArbtipdocTdidAux = null;
		if (arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdid() != null) {
			getArbtipdocTdidAux = arbadhdoc.getArbtipdoc().getTdid();
		}
		this.jdbcTemplate.update(
				query,
				arbadhdoc.getX5codocumento(),
				arbadhdoc.getArbadhtram() == null ? null : arbadhdoc
						.getArbadhtram().getTrid(),
				arbadhdoc.getX5excodigo(),
				arbadhdoc.getX5nofile(),
				arbadhdoc.getX5datafile() == null ? null : Y41bJdbcUtils
						.ConvertBlobToByte(arbadhdoc.getX5datafile()),
				arbadhdoc.getX5sizefile(), arbadhdoc.getX5tedesfile(),
				arbadhdoc.getX5origen(), arbadhdoc.getX5fecha(), arbadhdoc
						.getX5conttype(), arbadhdoc.getX5indmail(), arbadhdoc
						.getX5trmail(), arbadhdoc.getX5iddocumentum(),
				getArbtipdocTdidAux, arbadhdoc.getX5fechaaportacion(),
				arbadhdoc.getX5fechaentrada(), arbadhdoc
						.getX5numregistroentrada(), arbadhdoc
						.getX5idPerfilfirma(),
				arbadhdoc.getX5estadodocumento(), arbadhdoc
						.getX5fechasolfirma(), arbadhdoc.getX5fechafirma(),
				arbadhdoc.getX5comofirma(), arbadhdoc.getX5fecalta(), arbadhdoc
						.getX5fecmodif(), arbadhdoc.getX5usualta(), arbadhdoc
						.getX5usumodif(), arbadhdoc.getX5fechalimfirma(),
				arbadhdoc.getX5destino(), arbadhdoc.getX5ptcodigo(), arbadhdoc
						.getX5fechasollocalizador(), arbadhdoc
						.getX5numregistroorigen(), arbadhdoc
						.getX5fecharegistroorigen());
		return arbadhdoc;
	}

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Pagination
	 * @return Arbadhdoc
	 */
	public Arbadhdoc update(Arbadhdoc arbadhdoc) {
		String query = "UPDATE ARBADHDOC SET X5TRAMITE=?, X5EXCODIGO=?, X5NOFILE=?, X5DATAFILE=?, X5SIZEFILE=?, X5TEDESFILE=?, X5ORIGEN=?, X5FECHA=?, X5CONTTYPE=?, X5INDMAIL=?, X5TRMAIL=?, X5IDDOCUMENTUM=?, X5TIPODOCUMENTO=?, X5FECHAAPORTACION=?, X5FECHAENTRADA=?, X5NUMREGISTROENTRADA=?, X5ID_PERFILFIRMA=?, X5ESTADODOCUMENTO=?, X5FECHASOLFIRMA=?, X5FECHAFIRMA=?, X5COMOFIRMA=?, X5FECALTA=?, X5FECMODIF=?, X5USUALTA=?, X5USUMODIF=?, X5FECHALIMFIRMA=?, X5DESTINO=?, X5PTCODIGO=?, X5FECHASOLLOCALIZADOR=?, X5NUMREGISTROORIGEN=?, X5FECHAREGISTROORIGEN=? WHERE X5CODOCUMENTO=?";
		Object getArbtipdocTdidAux = null;
		if (arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdid() != null) {
			getArbtipdocTdidAux = arbadhdoc.getArbtipdoc().getTdid();
		}
		this.jdbcTemplate.update(query,
				arbadhdoc.getArbadhtram() == null ? null : arbadhdoc
						.getArbadhtram().getTrid(), arbadhdoc.getX5excodigo(),
				arbadhdoc.getX5nofile(), arbadhdoc.getX5datafile(), arbadhdoc
						.getX5sizefile(), arbadhdoc.getX5tedesfile(), arbadhdoc
						.getX5origen(), arbadhdoc.getX5fecha(), arbadhdoc
						.getX5conttype(), arbadhdoc.getX5indmail(), arbadhdoc
						.getX5trmail(), arbadhdoc.getX5iddocumentum(),
				getArbtipdocTdidAux, arbadhdoc.getX5fechaaportacion(),
				arbadhdoc.getX5fechaentrada(), arbadhdoc
						.getX5numregistroentrada(), arbadhdoc
						.getX5idPerfilfirma(),
				arbadhdoc.getX5estadodocumento(), arbadhdoc
						.getX5fechasolfirma(), arbadhdoc.getX5fechafirma(),
				arbadhdoc.getX5comofirma(), arbadhdoc.getX5fecalta(), arbadhdoc
						.getX5fecmodif(), arbadhdoc.getX5usualta(), arbadhdoc
						.getX5usumodif(), arbadhdoc.getX5fechalimfirma(),
				arbadhdoc.getX5destino(), arbadhdoc.getX5ptcodigo(), arbadhdoc
						.getX5fechasollocalizador(), arbadhdoc
						.getX5numregistroorigen(), arbadhdoc
						.getX5fecharegistroorigen(), arbadhdoc
						.getX5codocumento());
		return arbadhdoc;
	}

	/**
	 * Finds a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Pagination
	 * @return Arbadhdoc
	 */
	@Transactional(readOnly = true)
	public Arbadhdoc find(Arbadhdoc arbadhdoc) {
		String query = "SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5CONTTYPE X5CONTTYPE, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5FECALTA X5FECALTA, t1.X5FECMODIF X5FECMODIF, t1.X5USUALTA X5USUALTA, t1.X5USUMODIF X5USUMODIF, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5DESTINO X5DESTINO, t1.X5PTCODIGO X5PTCODIGO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN, t2.TDID ARBTIPDOCTDID, t2.ID_TIPODOC ARBTIPDOCIDTIPODOC, t2.TDNOMBRE ARBTIPDOCTDNOMBRE, t2.TDNOMBREE ARBTIPDOCTDNOMBREE, t2.TDPCODIGO ARBTIPDOCTDPCODIGO, t2.TDFECALTA ARBTIPDOCTDFECALTA, t2.TDFECMODIF ARBTIPDOCTDFECMODIF, t2.TDUSUALTA ARBTIPDOCTDUSUALTA, t2.TDUSUMODIF ARBTIPDOCTDUSUMODIF, t2.TDTIPO ARBTIPDOCTDTIPO, null PCODIGO FROM ARBDOCTEMP t1 , ARBTIPDOC t2 WHERE t1.X5CODOCUMENTO = ?   AND t1.X5TIPODOCUMENTO= t2.TDID(+) ";

		List<Arbadhdoc> arbadhdocList = this.jdbcTemplate.query(query,
				this.rwMap, arbadhdoc.getX5codocumento());
		return (Arbadhdoc) DataAccessUtils.uniqueResult(arbadhdocList);
	}

	/**
	 * Removes a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Pagination
	 * @return
	 */
	public void remove(Arbadhdoc arbadhdoc) {
		String query = "DELETE FROM ARBADHDOC WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhdoc.getX5codocumento());
	}

	/**
	 * Finds a List of rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhdoc> findAll(Arbadhdoc arbadhdoc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t2.TDID ARBTIPDOCTDID,t2.ID_TIPODOC ARBTIPDOCIDTIPODOC,t2.TDNOMBRE ARBTIPDOCTDNOMBRE,t2.TDNOMBREE ARBTIPDOCTDNOMBREE,t2.TDPCODIGO ARBTIPDOCTDPCODIGO,t2.TDFECALTA ARBTIPDOCTDFECALTA,t2.TDFECMODIF ARBTIPDOCTDFECMODIF,t2.TDUSUALTA ARBTIPDOCTDUSUALTA,t2.TDUSUMODIF ARBTIPDOCTDUSUMODIF,t2.TDTIPO ARBTIPDOCTDTIPO, null PCODIGO  ");
		query.append("FROM ARBADHDOC t1 ,ARBTIPDOC t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhdoc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.X5TIPODOCUMENTO= t2.TDID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhdoc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Arbadhdoc arbadhdoc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHDOC t1 ,ARBTIPDOC t2");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(arbadhdoc);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.X5TIPODOCUMENTO= t2.TDID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhdoc> findAllLike(Arbadhdoc arbadhdoc,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t2.TDID ARBTIPDOCTDID,t2.ID_TIPODOC ARBTIPDOCIDTIPODOC,t2.TDNOMBRE ARBTIPDOCTDNOMBRE,t2.TDNOMBREE ARBTIPDOCTDNOMBREE,t2.TDPCODIGO ARBTIPDOCTDPCODIGO,t2.TDFECALTA ARBTIPDOCTDFECALTA,t2.TDFECMODIF ARBTIPDOCTDFECMODIF,t2.TDUSUALTA ARBTIPDOCTDUSUALTA,t2.TDUSUMODIF ARBTIPDOCTDUSUMODIF,t2.TDTIPO ARBTIPDOCTDTIPO, null PCODIGO ");
		query.append("FROM ARBADHDOC t1 ,ARBTIPDOC t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhdoc, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.X5TIPODOCUMENTO= t2.TDID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhdoc>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Arbadhdoc arbadhdoc, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHDOC t1 ,ARBTIPDOC t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(arbadhdoc, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.X5TIPODOCUMENTO= t2.TDID(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhdoc entity
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Arbadhdoc arbadhdoc) {

		StringBuilder where = new StringBuilder(
				ArbadhdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhdoc != null && arbadhdoc.getX5codocumento() != null) {
			where.append(" AND t1.X5CODOCUMENTO = ?");
			params.add(arbadhdoc.getX5codocumento());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdid() != null) {
			where.append(" AND t2.TDID = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdid());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getIdTipodoc() != null) {
			where.append(" AND t2.ID_TIPODOC = ?");
			params.add(arbadhdoc.getArbtipdoc().getIdTipodoc());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdnombre() != null) {
			where.append(" AND t2.TDNOMBRE = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdnombre());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdnombree() != null) {
			where.append(" AND t2.TDNOMBREE = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdnombree());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdpcodigo() != null) {
			where.append(" AND t2.TDPCODIGO = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdpcodigo());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdfecalta() != null) {
			where.append(" AND t2.TDFECALTA = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdfecalta());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdfecmodif() != null) {
			where.append(" AND t2.TDFECMODIF = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdfecmodif());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdusualta() != null) {
			where.append(" AND t2.TDUSUALTA = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdusualta());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdusumodif() != null) {
			where.append(" AND t2.TDUSUMODIF = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdusumodif());
		}
		if (arbadhdoc != null && arbadhdoc.getX5excodigo() != null) {
			where.append(" AND t1.X5EXCODIGO = ?");
			params.add(arbadhdoc.getX5excodigo());
		}
		if (arbadhdoc != null && arbadhdoc.getX5nofile() != null) {
			where.append(" AND t1.X5NOFILE = ?");
			params.add(arbadhdoc.getX5nofile());
		}
		if (arbadhdoc != null && arbadhdoc.getX5sizefile() != null) {
			where.append(" AND t1.X5SIZEFILE = ?");
			params.add(arbadhdoc.getX5sizefile());
		}
		if (arbadhdoc != null && arbadhdoc.getX5tedesfile() != null) {
			where.append(" AND t1.X5TEDESFILE = ?");
			params.add(arbadhdoc.getX5tedesfile());
		}
		if (arbadhdoc != null && arbadhdoc.getX5origen() != null) {
			where.append(" AND t1.X5ORIGEN = ?");
			params.add(arbadhdoc.getX5origen());
		}
		if (arbadhdoc != null && arbadhdoc.getArbadhtram() != null
				&& arbadhdoc.getArbadhtram().getTrid() != null) {
			where.append(" AND t1.X5TRAMITE = ?");
			/* where.append(" AND t3.EHCODIGO = ?"); */
			params.add(arbadhdoc.getArbadhtram().getTrid());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecha() != null) {
			where.append(" AND t1.X5FECHA = ?");
			params.add(arbadhdoc.getX5fecha());
		}
		if (arbadhdoc != null && arbadhdoc.getX5conttype() != null) {
			where.append(" AND t1.X5CONTTYPE = ?");
			params.add(arbadhdoc.getX5conttype());
		}
		if (arbadhdoc != null && arbadhdoc.getX5indmail() != null) {
			where.append(" AND t1.X5INDMAIL = ?");
			params.add(arbadhdoc.getX5indmail());
		}
		if (arbadhdoc != null && arbadhdoc.getX5trmail() != null) {
			where.append(" AND t1.X5TRMAIL = ?");
			params.add(arbadhdoc.getX5trmail());
		}
		if (arbadhdoc != null && arbadhdoc.getX5iddocumentum() != null) {
			where.append(" AND t1.X5IDDOCUMENTUM = ?");
			params.add(arbadhdoc.getX5iddocumentum());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechaaportacion() != null) {
			where.append(" AND t1.X5FECHAAPORTACION = ?");
			params.add(arbadhdoc.getX5fechaaportacion());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechaentrada() != null) {
			where.append(" AND t1.X5FECHAENTRADA = ?");
			params.add(arbadhdoc.getX5fechaentrada());
		}
		if (arbadhdoc != null && arbadhdoc.getX5numregistroentrada() != null) {
			where.append(" AND t1.X5NUMREGISTROENTRADA = ?");
			params.add(arbadhdoc.getX5numregistroentrada());
		}
		if (arbadhdoc != null && arbadhdoc.getX5idPerfilfirma() != null) {
			where.append(" AND t1.X5ID_PERFILFIRMA = ?");
			params.add(arbadhdoc.getX5idPerfilfirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5estadodocumento() != null) {
			where.append(" AND t1.X5ESTADODOCUMENTO = ?");
			params.add(arbadhdoc.getX5estadodocumento());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechasolfirma() != null) {
			where.append(" AND t1.X5FECHASOLFIRMA = ?");
			params.add(arbadhdoc.getX5fechasolfirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechafirma() != null) {
			where.append(" AND t1.X5FECHAFIRMA = ?");
			params.add(arbadhdoc.getX5fechafirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5comofirma() != null) {
			where.append(" AND t1.X5COMOFIRMA = ?");
			params.add(arbadhdoc.getX5comofirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecalta() != null) {
			where.append(" AND t1.X5FECALTA = ?");
			params.add(arbadhdoc.getX5fecalta());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecmodif() != null) {
			where.append(" AND t1.X5FECMODIF = ?");
			params.add(arbadhdoc.getX5fecmodif());
		}
		if (arbadhdoc != null && arbadhdoc.getX5usualta() != null) {
			where.append(" AND t1.X5USUALTA = ?");
			params.add(arbadhdoc.getX5usualta());
		}
		if (arbadhdoc != null && arbadhdoc.getX5usumodif() != null) {
			where.append(" AND t1.X5USUMODIF = ?");
			params.add(arbadhdoc.getX5usumodif());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechalimfirma() != null) {
			where.append(" AND t1.X5FECHALIMFIRMA = ?");
			params.add(arbadhdoc.getX5fechalimfirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5destino() != null) {
			where.append(" AND t1.X5DESTINO = ?");
			params.add(arbadhdoc.getX5destino());
		}
		if (arbadhdoc != null && arbadhdoc.getX5ptcodigo() != null) {
			where.append(" AND t1.X5PTCODIGO = ?");
			params.add(arbadhdoc.getX5ptcodigo());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechasollocalizador() != null) {
			where.append(" AND t1.X5FECHASOLLOCALIZADOR = ?");
			params.add(arbadhdoc.getX5fechasollocalizador());
		}
		if (arbadhdoc != null && arbadhdoc.getX5numregistroorigen() != null) {
			where.append(" AND t1.X5NUMREGISTROORIGEN = ?");
			params.add(arbadhdoc.getX5numregistroorigen());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecharegistroorigen() != null) {
			where.append(" AND t1.X5FECHAREGISTROORIGEN = ?");
			params.add(arbadhdoc.getX5fecharegistroorigen());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Arbadhdoc entity
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Arbadhdoc arbadhdoc,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ArbadhdocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (arbadhdoc != null && arbadhdoc.getX5codocumento() != null) {
			where.append(" AND t1.X5CODOCUMENTO = ?");
			params.add(arbadhdoc.getX5codocumento());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdid() != null) {
			where.append(" AND t2.TDID = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdid());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getIdTipodoc() != null) {
			where.append(" AND UPPER(t2.ID_TIPODOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getArbtipdoc().getIdTipodoc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getArbtipdoc().getIdTipodoc().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ID_TIPODOC IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdnombre() != null) {
			where.append(" AND UPPER(t2.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getArbtipdoc().getTdnombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getArbtipdoc().getTdnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TDNOMBRE IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdnombree() != null) {
			where.append(" AND UPPER(t2.TDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getArbtipdoc().getTdnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getArbtipdoc().getTdnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TDNOMBREE IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdpcodigo() != null) {
			where.append(" AND UPPER(t2.TDPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getArbtipdoc().getTdpcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getArbtipdoc().getTdpcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TDPCODIGO IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdfecalta() != null) {
			where.append(" AND t2.TDFECALTA = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdfecalta());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdfecmodif() != null) {
			where.append(" AND t2.TDFECMODIF = ?");
			params.add(arbadhdoc.getArbtipdoc().getTdfecmodif());
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdusualta() != null) {
			where.append(" AND UPPER(t2.TDUSUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getArbtipdoc().getTdusualta()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getArbtipdoc().getTdusualta().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.TDUSUALTA IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getArbtipdoc() != null
				&& arbadhdoc.getArbtipdoc().getTdusumodif() != null) {
			where.append(" AND UPPER(t2.TDUSUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getArbtipdoc().getTdusumodif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getArbtipdoc().getTdusumodif()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TDUSUMODIF IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5excodigo() != null) {
			where.append(" AND UPPER(t1.X5EXCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5excodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5excodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.X5EXCODIGO IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5nofile() != null) {
			where.append(" AND UPPER(t1.X5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.X5NOFILE IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5sizefile() != null) {
			where.append(" AND t1.X5SIZEFILE = ?");
			params.add(arbadhdoc.getX5sizefile());
		}
		if (arbadhdoc != null && arbadhdoc.getX5tedesfile() != null) {
			where.append(" AND UPPER(t1.X5TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5tedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.X5TEDESFILE IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5origen() != null) {
			where.append(" AND UPPER(t1.X5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5origen().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5origen().toUpperCase() + "%");
			}
			where.append(" AND t1.X5ORIGEN IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getArbadhtram() != null
				&& arbadhdoc.getArbadhtram().getTrid() != null) {
			where.append(" AND t1.X5TRAMITE = ?");
			params.add(arbadhdoc.getArbadhtram().getTrid());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecha() != null) {
			where.append(" AND t1.X5FECHA = ?");
			params.add(arbadhdoc.getX5fecha());
		}
		if (arbadhdoc != null && arbadhdoc.getX5conttype() != null) {
			where.append(" AND UPPER(t1.X5CONTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5conttype().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5conttype().toUpperCase() + "%");
			}
			where.append(" AND t1.X5CONTTYPE IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5indmail() != null) {
			where.append(" AND UPPER(t1.X5INDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5indmail().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5indmail().toUpperCase() + "%");
			}
			where.append(" AND t1.X5INDMAIL IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5trmail() != null) {
			where.append(" AND UPPER(t1.X5TRMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5trmail().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5trmail().toUpperCase() + "%");
			}
			where.append(" AND t1.X5TRMAIL IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5iddocumentum() != null) {
			where.append(" AND UPPER(t1.X5IDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5iddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5iddocumentum().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.X5IDDOCUMENTUM IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechaaportacion() != null) {
			where.append(" AND t1.X5FECHAAPORTACION = ?");
			params.add(arbadhdoc.getX5fechaaportacion());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechaentrada() != null) {
			where.append(" AND t1.X5FECHAENTRADA = ?");
			params.add(arbadhdoc.getX5fechaentrada());
		}
		if (arbadhdoc != null && arbadhdoc.getX5numregistroentrada() != null) {
			where.append(" AND UPPER(t1.X5NUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5numregistroentrada().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getX5numregistroentrada().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.X5NUMREGISTROENTRADA IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5idPerfilfirma() != null) {
			where.append(" AND UPPER(t1.X5ID_PERFILFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5idPerfilfirma().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5idPerfilfirma().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.X5ID_PERFILFIRMA IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5estadodocumento() != null) {
			where.append(" AND UPPER(t1.X5ESTADODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5estadodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5estadodocumento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.X5ESTADODOCUMENTO IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechasolfirma() != null) {
			where.append(" AND t1.X5FECHASOLFIRMA = ?");
			params.add(arbadhdoc.getX5fechasolfirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechafirma() != null) {
			where.append(" AND t1.X5FECHAFIRMA = ?");
			params.add(arbadhdoc.getX5fechafirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5comofirma() != null) {
			where.append(" AND UPPER(t1.X5COMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5comofirma().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5comofirma().toUpperCase() + "%");
			}
			where.append(" AND t1.X5COMOFIRMA IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecalta() != null) {
			where.append(" AND t1.X5FECALTA = ?");
			params.add(arbadhdoc.getX5fecalta());
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecmodif() != null) {
			where.append(" AND t1.X5FECMODIF = ?");
			params.add(arbadhdoc.getX5fecmodif());
		}
		if (arbadhdoc != null && arbadhdoc.getX5usualta() != null) {
			where.append(" AND UPPER(t1.X5USUALTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5usualta().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5usualta().toUpperCase() + "%");
			}
			where.append(" AND t1.X5USUALTA IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5usumodif() != null) {
			where.append(" AND UPPER(t1.X5USUMODIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5usumodif().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5usumodif().toUpperCase() + "%");
			}
			where.append(" AND t1.X5USUMODIF IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechalimfirma() != null) {
			where.append(" AND t1.X5FECHALIMFIRMA = ?");
			params.add(arbadhdoc.getX5fechalimfirma());
		}
		if (arbadhdoc != null && arbadhdoc.getX5destino() != null) {
			where.append(" AND UPPER(t1.X5DESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5destino().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5destino().toUpperCase() + "%");
			}
			where.append(" AND t1.X5DESTINO IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5ptcodigo() != null) {
			where.append(" AND UPPER(t1.X5PTCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5ptcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + arbadhdoc.getX5ptcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.X5PTCODIGO IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5fechasollocalizador() != null) {
			where.append(" AND t1.X5FECHASOLLOCALIZADOR = ?");
			params.add(arbadhdoc.getX5fechasollocalizador());
		}
		if (arbadhdoc != null && arbadhdoc.getX5numregistroorigen() != null) {
			where.append(" AND UPPER(t1.X5NUMREGISTROORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(arbadhdoc.getX5numregistroorigen().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ arbadhdoc.getX5numregistroorigen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.X5NUMREGISTROORIGEN IS NOT NULL");
		}
		if (arbadhdoc != null && arbadhdoc.getX5fecharegistroorigen() != null) {
			where.append(" AND t1.X5FECHAREGISTROORIGEN = ?");
			params.add(arbadhdoc.getX5fecharegistroorigen());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder("");
		try {
			query = new StringBuilder(
					"SELECT DISTINCT X5CODOCUMENTO, X5EXCODIGO, X5NOFILE,X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, DECODE(X5FECHAREGISTROORIGEN, null, DECODE(X5FECHAENTRADA,null,X5FECHA,X5FECHAENTRADA),X5FECHAREGISTROORIGEN) X5FECHA, X5CONTTYPE, X5INDMAIL, X5TRMAIL, X5IDDOCUMENTUM, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM ARBADHDOC, ARBTIPDOC t2 WHERE X5TIPODOCUMENTO = t2.TDID(+) AND X5EXCODIGO  = ?");
			List<Object> params = new ArrayList<Object>();

			params.add(tramiteComun.getIdExpediente());
			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(
					query.toString(), this.rwMapDocExp, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosHechoComunicacion: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts number of rows in the Arbadhdoc table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */

	public Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(DISTINCT X5CODOCUMENTO) ");
		query.append("FROM ARBADHDOC, ARBTIPDOC t2 WHERE X5TIPODOCUMENTO = t2.TDID(+) AND X5EXCODIGO  = ?");

		List<Object> params = new ArrayList<Object>();

		params.add(tramiteComun.getIdExpediente());

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhdoc> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t2.TDID ARBTIPDOCTDID,t2.ID_TIPODOC ARBTIPDOCIDTIPODOC,t2.TDNOMBRE ARBTIPDOCTDNOMBRE,t2.TDNOMBREE ARBTIPDOCTDNOMBREE,t2.TDPCODIGO ARBTIPDOCTDPCODIGO,t2.TDFECALTA ARBTIPDOCTDFECALTA,t2.TDFECMODIF ARBTIPDOCTDFECMODIF,t2.TDUSUALTA ARBTIPDOCTDUSUALTA,t2.TDUSUMODIF ARBTIPDOCTDUSUMODIF, t2.TDTIPO ARBTIPDOCTDTIPO,t3.THPCODIGO PCODIGO  ");
			query.append("FROM ARBADHDOC t1, ARBTIPDOC t2, ARBADHDOCTRAM t3 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO AND T1.X5TIPODOCUMENTO=T2.TDID(+) ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t3.EHCODIGO = ? ");
			params.add(tramiteComun.getIdTramite().toString());
			where.append(" AND t3.TRPCODIGO = ? ");
			params.add(tramiteComun.getTipoProcedimiento().getPcodigo());
			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Arbadhdoc>) this.jdbcTemplate.query(query.toString(),
					this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosTramite: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosTramiteCount(TramiteComun tramiteComun) {
		try {
			StringBuilder query = new StringBuilder("SELECT  COUNT(1) ");
			query.append("FROM ARBADHDOC t1, ARBTIPDOC t2, ARBADHDOCTRAM t3 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO AND T1.X5TIPODOCUMENTO=T2.TDID(+) ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t3.EHCODIGO = ? ");
			params.add(tramiteComun.getIdTramite().toString());
			where.append(" AND t3.TRPCODIGO = ? ");
			params.add(tramiteComun.getTipoProcedimiento().getPcodigo());
			query.append(where);

			return this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosTramite: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addArbAdhAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO,TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ "SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t2.THPCODIGO THPCODIGO, t2.TRPCODIGO TRPCODIGO, t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA, t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, t2.EHCODIGO, t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5CONTTYPE X5CONTTYPE, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5DESTINO X5DESTINO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, T1.X5PTCODIGO X5PTCODIGO, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE "
				+ " FROM ARBADHDOC t1, ARBADHDOCTRAM t2 "
				+ " WHERE t1.X5CODOCUMENTO=t2.CODOCUMENTO AND t2.EHCODIGO = ? AND t1.X5EXCODIGO=? AND t2.TRPCODIGO = ? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(),
				tramiteComun.getIdExpediente(), tramiteComun
						.getTipoProcedimiento().getPcodigo());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Arbadhdoc> findAllDocumentosEliminados(
			TramiteComun tramiteComun, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM ");
		query.append("FROM ARBADHDOC t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		where.append(" AND t1.X5CODOCUMENTO NOT IN (SELECT tt1.THCODOCUMENTO FROM ADJUNTARDOCS tt1 WHERE tt1.THID_TRAMITE = ? AND tt1.TRPCODIGO=? )");
		params.add(tramiteComun.getIdTramite());
		params.add(tramiteComun.getTipoProcedimiento().getPcodigo());
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Arbadhdoc>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<Arbadhdoc>() {
					public Arbadhdoc mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Arbadhdoc(resultSet
								.getString("X5CODOCUMENTO"), resultSet
								.getString("X5IDDOCUMENTUM"));
					}
				}, params.toArray());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeAdhDocTramite(TramiteComun tramiteComun) {
		String query = "DELETE FROM ARBADHDOCTRAM WHERE EHCODIGO = ? AND TRPCODIGO=? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(),
				tramiteComun.getTipoProcedimiento().getPcodigo());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "DELETE FROM ARBADHDOC WHERE X5TRAMITE = ? AND X5EXCODIGO=?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(),
				tramiteComun.getIdExpediente());

	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addAdjuntarDocsAdhDocTramite(TramiteComun tramiteComun) {
		String query = "INSERT INTO ARBADHDOCTRAM (EHCODIGO, CODOCUMENTO, THPCODIGO, TRPCODIGO) SELECT THID_TRAMITE,THCODOCUMENTO,THPCODIGO,TRPCODIGO FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_TRAMITE=? ";
		this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento()
				.getPcodigo(), tramiteComun.getIdTramite());
	}

	/**
	 * Inserta los documentos de un trmite de adjuntardocs en la tabla de
	 * documentos de trmites
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "INSERT INTO ARBADHDOC (X5CODOCUMENTO, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, X5FECHA, X5INDMAIL, X5TRMAIL, X5CONTTYPE, X5IDDOCUMENTUM, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHALIMFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5TIPODOCUMENTO, X5DESTINO, X5FECHASOLLOCALIZADOR, X5PTCODIGO,X5NUMREGISTROORIGEN,X5FECHAREGISTROORIGEN,X5IDINTERVINIENTE)"
				+ " SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THID_TRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO ,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN,THIDINTERVINIENTE "
				+ " FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THCODOCUMENTO NOT IN (SELECT X5CODOCUMENTO FROM ARBADHDOC ) AND THID_TRAMITE=?";

		this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento()
				.getPcodigo(), tramiteComun.getIdTramite());

	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocsComAdjuntarDocsTramite(TramiteComun tramiteComun) {
		String query = "INSERT INTO ARBADHDOCTRAM (EHCODIGO, CODOCUMENTO, THPCODIGO, TRPCODIGO) SELECT "
				+ tramiteComun.getIdTramite()
				+ ",THCODOCUMENTO,THPCODIGO,TRPCODIGO FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THID_TRAMITE=? ";
		this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento()
				.getPcodigo(), tramiteComun.getIdExpediente());// En la
																// respuesta no
																// tenemos id de
																// tramite,
																// usamos id del
																// expediente
	}

	/**
	 * Inserta los documentos de la respuesta de adjuntardocs en la tabla de
	 * documentos de trmites
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	public void addDocsComAdjuntarDocs(TramiteComun tramiteComun) {
		String query = "INSERT INTO ARBADHDOC (X5CODOCUMENTO, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, X5FECHA, X5INDMAIL, X5TRMAIL, X5CONTTYPE, X5IDDOCUMENTUM, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHALIMFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5TIPODOCUMENTO, X5DESTINO, X5FECHASOLLOCALIZADOR, X5PTCODIGO,X5NUMREGISTROORIGEN,X5FECHAREGISTROORIGEN,X5IDINTERVINIENTE)"
				+ " SELECT THCODOCUMENTO, THID_EXPEDIENTE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, "
				+ tramiteComun.getIdTramite()
				+ ", THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THID_PERFILFIRMA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THID_TIPODOC, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO ,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN,THIDINTERVINIENTE "
				+ " FROM ADJUNTARDOCS WHERE TRPCODIGO = ? AND THCODOCUMENTO NOT IN (SELECT X5CODOCUMENTO FROM ARBADHDOC ) AND THID_TRAMITE=?";

		this.jdbcTemplate.update(query, tramiteComun.getTipoProcedimiento()
				.getPcodigo(), tramiteComun.getIdExpediente());// En la
																// respuesta no
																// tenemos id de
																// tramite,
																// usamos id del
																// expediente

	}

	/**
	 * Counts rows in the table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocTramiteHechoCount(Arbadhdoc arbadhdoc) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ARBADHDOCTRAM WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND CODOCUMENTO = ? ");
		params.add(arbadhdoc.getX5codocumento());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tridOrigen
	 *            String
	 */
	public void copiaArbAdhDocTramite(TramiteComun tramiteComun,
			String tridOrigen) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ "SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, t2.THPCODIGO THPCODIGO, t2.TRPCODIGO TRPCODIGO, t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA, t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, ?, t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5CONTTYPE X5CONTTYPE, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5DESTINO X5DESTINO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, T1.X5PTCODIGO X5PTCODIGO, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t1.X5IDINTERVINIENTE X5IDINTERVINIENTE "
				+ " FROM ARBADHDOC t1, ARBADHDOCTRAM t2 "
				+ " WHERE t1.X5CODOCUMENTO=t2.CODOCUMENTO AND t2.EHCODIGO = ? AND t2.TRPCODIGO = ? ";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(),
				tridOrigen, tramiteComun.getTipoProcedimiento().getPcodigo());
	}

	/**
	 * updateOIDDokusi
	 * 
	 * @param documentoHecho
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	public Arbadhdoc updateOIDDokusi(Arbadhdoc documentoHecho) {
		ArbadhdocDaoImpl.logger.debug("updateOIDDokusi(). X5CODOCUMENTO: "
				+ documentoHecho.getX5codocumento() + ".X5IDDOCUMENTUM:"
				+ documentoHecho.getX5iddocumentum() + ".");
		String query = "UPDATE ARBADHDOC SET X5IDDOCUMENTUM=? WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getX5iddocumentum(),
				documentoHecho.getX5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	public Arbadhdoc removeBlobFromOIDDokusi(Arbadhdoc arbadhdoc) {
		String query = "UPDATE ARBADHDOC SET X5DATAFILE=null WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhdoc.getX5codocumento());
		return arbadhdoc;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return DocumentoHecho
	 */
	public Arbadhdoc updateFechaLocalizacion(Arbadhdoc arbadhdoc) {
		String query = "UPDATE ARBADHDOC SET X5FECHASOLLOCALIZADOR=SYSDATE WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhdoc.getX5codocumento());
		return arbadhdoc;
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21Q5T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());

	}

	/**
	 * @param documentoHecho
	 * @param tramiteComun
	 */
	public void addAdjuntarDoc(Arbadhdoc documentoHecho,
			TramiteComun tramiteComun) {

		String query = " INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO, TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO, THFECHASOLLOCALIZADOR, THPTCODIGO, THNUMREGISTROORIGEN, THFECHAREGISTROORIGEN, THIDINTERVINIENTE) "
				+ " SELECT t1.X5CODOCUMENTO X5CODOCUMENTO, '"
				+ documentoHecho.getX5pcodigo()
				+ "', '"
				+ tramiteComun.getTipoProcedimiento().getPcodigo()
				+ "',  t1.X5ID_PERFILFIRMA X5ID_PERFILFIRMA, t1.X5TIPODOCUMENTO X5TIPODOCUMENTO, t1.X5EXCODIGO X5EXCODIGO, '"
				+ tramiteComun.getIdTramite()
				+ "', t1.X5NOFILE X5NOFILE, t1.X5DATAFILE X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE, t1.X5TEDESFILE X5TEDESFILE, t1.X5ORIGEN X5ORIGEN, t1.X5TRAMITE X5TRAMITE, t1.X5FECHA X5FECHA, t1.X5INDMAIL X5INDMAIL, t1.X5TRMAIL X5TRMAIL, t1.X5CONTTYPE X5CONTTYPE, t1.X5IDDOCUMENTUM X5IDDOCUMENTUM, t1.X5FECHAAPORTACION X5FECHAAPORTACION, t1.X5FECHAENTRADA X5FECHAENTRADA, t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO, t1.X5FECHASOLFIRMA X5FECHASOLFIRMA, t1.X5FECHALIMFIRMA X5FECHALIMFIRMA, t1.X5FECHAFIRMA X5FECHAFIRMA, t1.X5COMOFIRMA X5COMOFIRMA, t1.X5DESTINO X5DESTINO, t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR, T1.X5PTCODIGO X5PTCODIGO, t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN, t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN, t1.X5IDINTERVINIENTE X5IDINTERVINIENTE "
				+ " FROM ARBADHDOC t1 WHERE t1.X5CODOCUMENTO = ?";
		this.jdbcTemplate.update(query, documentoHecho.getX5codocumento());
	}

	/**
	 * 
	 * @param idNuevoTramite
	 *            idNuevoTramite
	 * @param codocumento
	 *            codocumento
	 * @param tipoProcedimiento
	 *            tipoProcedimiento
	 */
	public void insertArbDocTramite(String idNuevoTramite, String codocumento,
			String tipoProcedimiento) {
		String query = "INSERT INTO ARBADHDOCTRAM (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) VALUES(?,?,?,?)";
		this.jdbcTemplate.update(query, idNuevoTramite, codocumento,
				tipoProcedimiento, tipoProcedimiento);
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	public Arbadhdoc updateOrigen(Arbadhdoc documentoHecho) {
		String query = "UPDATE ARBADHDOC SET X5ORIGEN=? WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getX5origen(),
				documentoHecho.getX5codocumento());
		return documentoHecho;
	}

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	public Long findAllDocumentosHechoComunicacionCount(
			TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT  count(1) FROM ARBADHDOC t1,ARBTIPDOC t2 WHERE t1.X5TIPODOCUMENTO = t2.TDID(+) ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.X5EXCODIGO = ? ");
		params.add(tramiteComun.getIdExpediente());

		if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SUBSANACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_DOCUMENTACION_SUBSANADA);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACEPTACION_ARBITRAJE
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_ACEPTACION_ARBITRAJE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_COPIA_EXPE
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_SOLICITUD_COPIA_EXPE);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_INFORME_PERICIAL
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_INFORME_PERICIAL);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_RECEPCION_SOLICITUD_ACLARACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_SOLICITUD_ACLARACION);
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACLARACION
				.equals(tramiteComun.getIdTipoTramite())) {
			where.append(" AND t1.X5TIPODOCUMENTO = ? ");
			params.add(Y41bConstantes.TIPO_DOC_ARB_RECEPCION_ACLARACION);
		}

		where.append(" AND t1.X5TRAMITE IN (SELECT tt1.TRID FROM ARBADHTRAM tt1 WHERE tt1.TREXCODIGO=? AND (tt1.TRESTADO=? OR tt1.TRESTADO IS NULL))");
		params.add(tramiteComun.getIdExpediente());
		params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoExpediente> findAllDocumentosHechoComunicacion(
			TramiteComun tramiteComun, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN, DECODE(t1.X5FECHAREGISTROORIGEN, null, DECODE(t1.X5FECHAENTRADA,null,t1.X5FECHA,t1.X5FECHAENTRADA),t1.X5FECHAREGISTROORIGEN) X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA, t2.ID_TIPODOC IDTIPODOC, t2.TDNOMBRE TDNOMBRE, t2.TDNOMBREE TDNOMBREE ");
			query.append("FROM ARBADHDOC t1,ARBTIPDOC t2 WHERE t1.X5TIPODOCUMENTO = t2.TDID(+) ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.X5EXCODIGO = ? ");
			params.add(tramiteComun.getIdExpediente());
			where.append(" AND t1.X5TRAMITE IN (SELECT tt1.TRID FROM ARBADHTRAM tt1 WHERE tt1.TREXCODIGO=? AND (tt1.TRESTADO=? OR tt1.TRESTADO IS NULL))");
			params.add(tramiteComun.getIdExpediente());
			params.add(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<DocumentoExpediente>) this.jdbcTemplate.query(
					query.toString(), new RowMapper<DocumentoExpediente>() {
						public DocumentoExpediente mapRow(ResultSet resultSet,
								int rowNum) throws SQLException {
							return new DocumentoExpediente(resultSet
									.getString("X5CODOCUMENTO"), resultSet
									.getString("X5EXCODIGO"), resultSet
									.getString("X5NOFILE"), null, resultSet
									.getInt("X5SIZEFILE"), resultSet
									.getString("X5CONTTYPE"), resultSet
									.getString("X5TEDESFILE"), resultSet
									.getString("X5ORIGEN"), resultSet
									.getDate("X5FECHA"), resultSet
									.getString("X5IDDOCUMENTUM"), resultSet
									.getDate("X5FECHAAPORTACION"), resultSet
									.getDate("X5FECHAENTRADA"), resultSet
									.getString("X5NUMREGISTROENTRADA"),
									resultSet.getString("IDTIPODOC"), resultSet
											.getString("TDNOMBRE"), resultSet
											.getString("TDNOMBREE"), null,
									null, null, null, null, null, null, null);
						}
					}, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(
					"Error producido en findAllDocumentosHechoComunicacion: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateArbAdhDoc(Arbadhdoc arbadhdoc) {
		String query = "UPDATE ARBADHDOC SET X5NOFILE=?,X5DATAFILE=?, X5SIZEFILE=?, X5CONTTYPE=? WHERE X5IDDOCUMENTUM=?";
		return this.jdbcTemplate.update(query, arbadhdoc.getX5nofile(),
				Y41bJdbcUtils.ConvertBlobToByte(arbadhdoc.getX5datafile()),
				arbadhdoc.getX5sizefile(), arbadhdoc.getX5conttype(),
				arbadhdoc.getX5iddocumentum());
	}

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param Arbadhdoc
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public Arbadhdoc updateDatosFirma(Arbadhdoc arbadhdoc) {
		String query = "UPDATE ARBADHDOC SET X5ESTADODOCUMENTO=?, X5FECHAFIRMA=?, X5COMOFIRMA=? WHERE X5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, arbadhdoc.getX5estadodocumento(),
				arbadhdoc.getX5fechafirma(), arbadhdoc.getX5comofirma(),
				arbadhdoc.getX5codocumento());
		return arbadhdoc;
	}

	/**
	 * 
	 * @param docSolicitudDestino
	 *            Arbdocsoladh
	 * @param docSolicitudOrigen
	 *            Docadhtele
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Arbdocsoladh
	 */
	public Arbadhdoc addDesdeDocumentoTelematico(Arbadhdoc docSolicitudDestino,
			Docadhtele docSolicitudOrigen, TramiteComun tramiteComun) {

		StringBuilder query = new StringBuilder(
				ArbadhdocDaoImpl.STRING_BUILDER_INIT);
		query.append("INSERT INTO ARBADHDOC (X5CODOCUMENTO, X5EXCODIGO, X5NOFILE, X5DATAFILE, X5SIZEFILE, X5TEDESFILE, X5ORIGEN, X5TRAMITE, X5FECHA, X5INDMAIL, X5TRMAIL, X5CONTTYPE, X5IDDOCUMENTUM, X5FECHAAPORTACION, X5FECHAENTRADA, X5NUMREGISTROENTRADA, X5ID_PERFILFIRMA, X5ESTADODOCUMENTO, X5FECHASOLFIRMA, X5FECHALIMFIRMA, X5FECHAFIRMA, X5COMOFIRMA, X5TIPODOCUMENTO, X5DESTINO, X5FECHASOLLOCALIZADOR, X5PTCODIGO,X5NUMREGISTROORIGEN,X5FECHAREGISTROORIGEN)");
		query.append(" SELECT ");
		query.append("  ?, ?, XBNOFILE, NULL, XBSIZEFILE, XBTEDESFILE, ?, ?, XBFECHA, NULL, NULL,XBCONTENTTYPEFILE, XBIDDOCUMENTUM, XBFECHAAPORTACION, ?, ?, NULL, NULL, NULL, NULL, NULL, NULL, ?, NULL, NULL, NULL, NULL, NULL ");
		query.append(" FROM DOCADHTELE,ADHESION_TELE WHERE XBADHID=ADHID AND XBADHID=? ");

		String tipoDoc = "";
		if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(tramiteComun
				.getTipoProcedimiento().getPcodigo())) {
			tipoDoc = Y41bConstantes.TIPO_DOC_ADH_ALTA_APORTACIONDOCUMENTACION;
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(tramiteComun
				.getTipoProcedimiento().getPcodigo())) {
			tipoDoc = Y41bConstantes.TIPO_DOC_ADH_BAJA_APORTACIONDOCUMENTACION;
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(tramiteComun
				.getTipoProcedimiento().getPcodigo())) {
			tipoDoc = Y41bConstantes.TIPO_DOC_ADH_MOD_APORTACIONDOCUMENTACION;
		}

		this.jdbcTemplate.update(query.toString(),
				docSolicitudDestino.getX5codocumento(),
				tramiteComun.getIdExpediente(),
				docSolicitudDestino.getX5origen(), tramiteComun.getIdTramite(),
				docSolicitudOrigen.getXbfechaentrada(),
				docSolicitudOrigen.getXbnumregistroentrada(), tipoDoc,
				docSolicitudOrigen.getXbadhid());

		String query2 = "INSERT INTO ARBADHDOCTRAM (EHCODIGO, CODOCUMENTO, THPCODIGO,TRPCODIGO) VALUES(?,?,?,?) ";
		this.jdbcTemplate.update(query2, tramiteComun.getIdTramite(),
				docSolicitudDestino.getX5codocumento(), tramiteComun
						.getTipoProcedimiento().getPcodigo(), tramiteComun
						.getTipoProcedimiento().getPcodigo());

		return docSolicitudDestino;
	}

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * @return
	 */
	public void removeTelematicosAntiguas() {

		String query = "DELETE FROM DOCADHTELE WHERE EXISTS (SELECT 1 FROM ADHESION_TELE WHERE ADHESION_TELE.ADHID=DOCADHTELE.XBADHID AND ADHESION_TELE.ADHFECALTA+8<SYSDATE AND ADHESION_TELE.ADHSOLREGEN IS NULL )";

		this.jdbcTemplate.update(query);

	}

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * @param documentoTelematico
	 *            Docadhtele
	 * @return
	 */
	public void removeTelematicos(Docadhtele documentoTelematico) {
		String query = "DELETE FROM DOCADHTELE WHERE XBADHID=?";

		this.jdbcTemplate.update(query, documentoTelematico.getXbadhid());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbadhdocDao#findAllDocumentosSolicitud(java.lang.String
	 * , java.lang.String, com.ejie.x38.dto.Pagination)
	 */
	@Override
	public List<Arbadhdoc> findAllDocumentosSolicitud(String tipo,
			String adhid, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT distinct t1.X5CODOCUMENTO X5CODOCUMENTO,t1.X5EXCODIGO X5EXCODIGO,t1.X5NOFILE X5NOFILE,null X5DATAFILE, t1.X5SIZEFILE X5SIZEFILE,t1.X5TEDESFILE X5TEDESFILE,t1.X5ORIGEN X5ORIGEN,t1.X5TRAMITE X5TRAMITE,t1.X5FECHA X5FECHA,t1.X5CONTTYPE X5CONTTYPE,t1.X5INDMAIL X5INDMAIL,t1.X5TRMAIL X5TRMAIL,t1.X5IDDOCUMENTUM X5IDDOCUMENTUM,t1.X5FECHAAPORTACION X5FECHAAPORTACION,t1.X5FECHAENTRADA X5FECHAENTRADA,t1.X5NUMREGISTROENTRADA X5NUMREGISTROENTRADA,t1.X5ID_PERFILFIRMA X5IDPERFILFIRMA,t1.X5ESTADODOCUMENTO X5ESTADODOCUMENTO,t1.X5FECHASOLFIRMA X5FECHASOLFIRMA,t1.X5FECHAFIRMA X5FECHAFIRMA,t1.X5COMOFIRMA X5COMOFIRMA,t1.X5FECALTA X5FECALTA,t1.X5FECMODIF X5FECMODIF,t1.X5USUALTA X5USUALTA,t1.X5USUMODIF X5USUMODIF,t1.X5FECHALIMFIRMA X5FECHALIMFIRMA,t1.X5DESTINO X5DESTINO,t1.X5PTCODIGO X5PTCODIGO,t1.X5FECHASOLLOCALIZADOR X5FECHASOLLOCALIZADOR,t1.X5NUMREGISTROORIGEN X5NUMREGISTROORIGEN,t1.X5FECHAREGISTROORIGEN X5FECHAREGISTROORIGEN,t2.TDID ARBTIPDOCTDID,t2.ID_TIPODOC ARBTIPDOCIDTIPODOC,t2.TDNOMBRE ARBTIPDOCTDNOMBRE,t2.TDNOMBREE ARBTIPDOCTDNOMBREE,t2.TDPCODIGO ARBTIPDOCTDPCODIGO,t2.TDFECALTA ARBTIPDOCTDFECALTA,t2.TDFECMODIF ARBTIPDOCTDFECMODIF,t2.TDUSUALTA ARBTIPDOCTDUSUALTA,t2.TDUSUMODIF ARBTIPDOCTDUSUMODIF, t2.TDTIPO ARBTIPDOCTDTIPO, t3.THPCODIGO PCODIGO ");
			query.append("FROM ARBADHDOC t1, ARBTIPDOC t2, ARBADHDOCTRAM t3, ARBADHTRAM t4 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO AND T1.X5TIPODOCUMENTO=T2.TDID(+) AND t1.X5EXCODIGO=t4.TREXCODIGO AND t1.X5TRAMITE=t4.TRID ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.X5EXCODIGO = ? ");
			params.add(adhid);
			where.append(" AND t1.X5ORIGEN = ? ");
			params.add(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
			where.append(" AND t4.TRCODIGO IN (?,?) ");
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(tipo)) {
				params.add(Y41bConstantes.TRAMITE_ADHESION_APERTURA_ALTA);
				params.add(Y41bConstantes.TRAMITE_ADHESION_APORTAR_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(tipo)) {
				params.add(Y41bConstantes.TRAMITE_ADHESION_APERTURA_MOD);
				params.add(Y41bConstantes.TRAMITE_ADHESION_APORTAR_MOD);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(tipo)
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(tipo)) {
				params.add(Y41bConstantes.TRAMITE_ADHESION_APERTURA_BAJA);
				params.add(Y41bConstantes.TRAMITE_ADHESION_APORTAR_BAJA);
			}
			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Arbadhdoc>) this.jdbcTemplate.query(query.toString(),
					this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosTramite: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.dao.ArbadhdocDao#findAllDocumentosSolicitudCount(java.lang
	 * .String, java.lang.String)
	 */
	@Override
	public Long findAllDocumentosSolicitudCount(String tipo, String adhid) {
		try {
			StringBuilder query = new StringBuilder("SELECT  COUNT(1) ");
			query.append("FROM ARBADHDOC t1, ARBTIPDOC t2, ARBADHDOCTRAM t3, ARBADHTRAM t4 WHERE t1.X5CODOCUMENTO=t3.CODOCUMENTO AND T1.X5TIPODOCUMENTO=T2.TDID(+) AND t1.X5EXCODIGO=t4.TREXCODIGO AND t1.X5TRAMITE=t4.TRID ");

			StringBuilder where = new StringBuilder();

			List<Object> params = new ArrayList<Object>();
			where.append(" AND t1.X5EXCODIGO = ? ");
			params.add(adhid);
			where.append(" AND t1.X5ORIGEN = ? ");
			params.add(Y41bConstantes.ORIGEN_ADH_APORTADO_ESTABLECIMIENTO);
			where.append(" AND t4.TRCODIGO IN (?,?) ");
			if (Y41bConstantes.ADH_TIPO_ALTA.equals(tipo)) {
				params.add(Y41bConstantes.TRAMITE_ADHESION_APERTURA_ALTA);
				params.add(Y41bConstantes.TRAMITE_ADHESION_APORTAR_ALTA);
			} else if (Y41bConstantes.ADH_TIPO_MODIF.equals(tipo)) {
				params.add(Y41bConstantes.TRAMITE_ADHESION_APERTURA_MOD);
				params.add(Y41bConstantes.TRAMITE_ADHESION_APORTAR_MOD);
			} else if (Y41bConstantes.ADH_TIPO_BAJA.equals(tipo)
					|| Y41bConstantes.ADH_TIPO_BAJA_OFICIO.equals(tipo)) {
				params.add(Y41bConstantes.TRAMITE_ADHESION_APERTURA_BAJA);
				params.add(Y41bConstantes.TRAMITE_ADHESION_APORTAR_BAJA);
			}
			query.append(where);

			return this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			ArbadhdocDaoImpl.logger.error(
					"Error producido en findAllDocumentosTramite: "
							+ e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

}
