package com.ejie.y41b.dao;

import com.ejie.x38.dto.Pagination;

//import java.math.BigDecimal;
import java.util.List;

import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Docadhtele;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.TramiteComun;

/**
 * ArbadhdocDao  
 * 
 *  
 */

public interface ArbadhdocDao {

	/**
	 * Inserts a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc add(Arbadhdoc arbadhdoc);

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc update(Arbadhdoc arbadhdoc);

	/**
	 * Finds a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc find(Arbadhdoc arbadhdoc);

	/**
	 * Deletes a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return
	 */
	void remove(Arbadhdoc arbadhdoc);

	/**
	 * Finds a List of rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhdoc> findAll(Arbadhdoc arbadhdoc, Pagination pagination);

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Long
	 */
	Long findAllCount(Arbadhdoc arbadhdoc);

	/**
	 * Finds rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Arbadhdoc> findAllLike(Arbadhdoc arbadhdoc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Arbadhdoc table using like.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Arbadhdoc arbadhdoc, Boolean startsWith);

	/**
	 * 
	 * @return Integer
	 */
	Long getNewPK();

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return DocumentoHecho
	 */
	Arbadhdoc updateFechaLocalizacion(Arbadhdoc arbadhdoc);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhdoc> findAllDocumentosTramite(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Counts rows in the Arbadhdoc table.
	 * 
	 * @param tramiteComun
	 *            tramiteComun
	 * @return Long
	 */

	Long findAllDocumentosTramiteCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Arbadhdoc> findAllDocumentosEliminados(TramiteComun tramiteComun,
			Pagination pagination);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void removeAdhDocTramite(TramiteComun tramiteComun);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void removeDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addAdjuntarDocsAdhDocTramite(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocumentosHechoAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocsComAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param tridOrigen
	 *            String
	 */
	void copiaArbAdhDocTramite(TramiteComun tramiteComun, String tridOrigen);

	/**
	 * updateOIDDokusi
	 * 
	 * @param documentoHecho
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	Arbadhdoc updateOIDDokusi(Arbadhdoc documentoHecho);

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	public Arbadhdoc removeBlobFromOIDDokusi(Arbadhdoc arbadhdoc);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return int
	 */
	int updateArbAdhDoc(Arbadhdoc arbadhdoc);

	/**
	 * Inserts a single row in the ADJUNTARDOCS table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addArbAdhAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosExpediente(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Counts number of rows in the Arbadhdoc table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosExpedienteCount(TramiteComun tramiteComun);

	/**
	 * Counts rows in the table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return Long
	 */
	Long findAllDocTramiteHechoCount(Arbadhdoc arbadhdoc);

	/**
	 * 
	 * @param idNuevoTramite
	 *            idNuevoTramite
	 * @param codocumento
	 *            codocumento
	 * @param tipoProcedimiento
	 *            tipoProcedimiento
	 */
	void insertArbDocTramite(String idNuevoTramite, String codocumento,
			String tipoProcedimiento);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Arbadhdoc
	 * @return Arbadhdoc
	 */
	public Arbadhdoc updateOrigen(Arbadhdoc documentoHecho);

	/**
	 * addAdjuntarDoc
	 * 
	 * @param documentoHecho
	 *            Arbadhdoc
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addAdjuntarDoc(Arbadhdoc documentoHecho, TramiteComun tramiteComun);

	/**
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Long
	 */
	Long findAllDocumentosHechoComunicacionCount(TramiteComun tramiteComun);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoExpediente> findAllDocumentosHechoComunicacion(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Updates a single row in the Arbadhdoc table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return DocumentoHecho
	 */
	Arbadhdoc updateDatosFirma(Arbadhdoc arbadhdoc);

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 */
	void addDocsComAdjuntarDocsTramite(TramiteComun tramiteComun);

	/**
	 * 
	 * @param docSolicitudDestino
	 *            Arbadhdoc
	 * @param docSolicitudOrigen
	 *            Docadhtele
	 * @param tramiteComun
	 *            TramiteComun
	 * @return Arbdocsoladh
	 */
	Arbadhdoc addDesdeDocumentoTelematico(Arbadhdoc docSolicitudDestino,
			Docadhtele docSolicitudOrigen, TramiteComun tramiteComun);

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * 
	 * @return
	 */
	void removeTelematicosAntiguas();

	/**
	 * Removes a single row in the Arbdocsoladh table.
	 * 
	 * @param documentoTelematico
	 *            Docadhtele
	 * @return
	 */
	void removeTelematicos(Docadhtele documentoTelematico);

	/**
	 * findAllDocumentosSolicitud
	 * 
	 * @param tipo
	 *            String
	 * @param adhid
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return List<Arbadhdoc>
	 */
	List<Arbadhdoc> findAllDocumentosSolicitud(String tipo, String adhid,
			Pagination pagination);

	/**
	 * findAllDocumentosSolicitudCount
	 * 
	 * @param tipo
	 *            String
	 * @param adhid
	 *            String
	 * @return Long
	 */
	Long findAllDocumentosSolicitudCount(String tipo, String adhid);
}
