package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;
import com.ejie.y41b.model.Distribuidor;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.NaturalezaPeligro;
import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * AlertaProgramacionDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AlertaProgramacionDaoImpl implements AlertaProgramacionDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AlertaProgramacion> rwMap = new RowMapper<AlertaProgramacion>() {
		public AlertaProgramacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AlertaProgramacion(
					resultSet.getString("CRCODIGO"),
					resultSet.getString("CRCOOR"),
					resultSet.getDate("CRFERERE"),
					resultSet.getString("CRTEINFO"),
					resultSet.getInt("CRCNACTU"),
					resultSet.getString("CRINPRSE"),
					resultSet.getDate("CRFECHACOMUNICACION"),
					resultSet.getDate("CRFECHAPLAZO"),
					resultSet.getDate("CRFECHACIERRE"),
					new Alerta(resultSet.getString("AlertaALCODIGO"), resultSet
							.getString("AlertaALCOOR"), resultSet
							.getLong("AlertaALNRAN"), resultSet
							.getString("AlertaALNROR"), resultSet
							.getDate("AlertaALFEEN"), resultSet
							.getDate("AlertaALFEPLRR"), resultSet
							.getString("AlertaALCOPS"), null, null, resultSet
							.getString("AlertaALNOPRSE"), resultSet
							.getString("AlertaALNRLOPS"), resultSet
							.getString("AlertaALNOMAPS"), resultSet
							.getString("AlertaALNOMOPS"), resultSet
							.getDate("AlertaALFEDUMI"), resultSet
							.getString("AlertaALCOCA"), resultSet
							.getString("AlertaALCOPA"), resultSet
							.getString("AlertaALCOTOP"), resultSet
							.getString("AlertaALTEIN"), resultSet
							.getString("AlertaALCOES"), resultSet
							.getDate("AlertaALFERRIN"), resultSet
							.getString("AlertaALINRE"), resultSet
							.getDate("AlertaALFECOOR"), resultSet
							.getString("AlertaALCOTMO"), resultSet
							.getString("AlertaALAECOSAN"), resultSet
							.getString("AlertaALACTIVA"), resultSet
							.getString("AlertaALANULADA"), resultSet
							.getDate("AlertaALFECHAANULACION"), resultSet
							.getString("AlertaALINDICACIONES"), resultSet
							.getString("AlertaALCODIGOBARRAS"), resultSet
							.getString("AlertaALORIGENPRODUCTO"), resultSet
							.getString("AlertaALCCAAPRODUCTO"), resultSet
							.getString("AlertaALPAISPRODUCTO"), new Alerta(
							resultSet.getString("AlertaALCODIGOREL"), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null), new NaturalezaPeligro(resultSet
							.getString("AlertaALIDNATURALEZAPELIGRO"), null,
							null, null), null),
					new TipoCaracterAlerta(resultSet
							.getString("TipoCaracterAlertaTCACODIGO"),
							resultSet.getString("TipoCaracterAlertaTCANOMBRE"),
							resultSet.getString("TipoCaracterAlertaTCANOMBREE")),
					new Distribuidor(resultSet
							.getString("DistribuidorRDCODIGO"), resultSet
							.getString("DistribuidorRDCOES"), resultSet
							.getString("DistribuidorRDFABRICANTE"), resultSet
							.getString("DistribuidorRDIDINTERVINIENTE"),
							new Alerta(resultSet
									.getString("DistribuidorRDCOAL"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new Intervinientes(resultSet
									.getString("IntervinienteID"), resultSet
									.getString("IntervinienteNOMBRE"),
									resultSet.getString("IntervinienteNIF"),
									resultSet.getString("IntervinienteESNOCO"))),
					resultSet.getString("CRACUERDOINICIO"), resultSet
							.getString("CRINSPECCIONSOLICITADA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            Pagination
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion add(AlertaProgramacion alertaprogramacion) {
		String query = "INSERT INTO ALERTA_PROGRAMACION (CRCODIGO, CRCOAL, CRTIPO, CRCODIGODISTRIBUIDOR, CRCOOR, CRFERERE, CRTEINFO, CRCNACTU, CRINPRSE, CRFECHACOMUNICACION, CRFECHAPLAZO, CRFECHACIERRE, CRACUERDOINICIO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getAlertaAlcodigoAux = null;
		if (alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alertaprogramacion.getAlerta().getAlcodigo();
		}
		Object getTipoCaracterAlertaTcacodigoAux = null;
		if (alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcacodigo() != null) {
			getTipoCaracterAlertaTcacodigoAux = alertaprogramacion
					.getTipoCaracterAlerta().getTcacodigo();
		}
		Object getDistribuidorRdcodigoAux = null;
		if (alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdcodigo() != null) {
			getDistribuidorRdcodigoAux = alertaprogramacion.getDistribuidor()
					.getRdcodigo();
		}
		this.jdbcTemplate.update(query, alertaprogramacion.getCrcodigo(),
				getAlertaAlcodigoAux, getTipoCaracterAlertaTcacodigoAux,
				getDistribuidorRdcodigoAux, alertaprogramacion.getCrcoor(),
				alertaprogramacion.getCrferere(),
				alertaprogramacion.getCrteinfo(),
				alertaprogramacion.getCrcnactu(),
				alertaprogramacion.getCrinprse(),
				alertaprogramacion.getCrfechacomunicacion(),
				alertaprogramacion.getCrfechaplazo(),
				alertaprogramacion.getCrfechacierre(),
				alertaprogramacion.getCracuerdoinicio());
		return alertaprogramacion;
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            Pagination
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion update(AlertaProgramacion alertaprogramacion) {
		String query = "UPDATE ALERTA_PROGRAMACION SET CRCOAL=?, CRTIPO=?, CRCODIGODISTRIBUIDOR=?, CRCOOR=?, CRFERERE=?, CRTEINFO=?, CRCNACTU=?, CRINPRSE=?, CRFECHACOMUNICACION=?, CRFECHAPLAZO=?, CRFECHACIERRE=?, CRACUERDOINICIO=? WHERE CRCODIGO=?";
		Object getAlertaAlcodigoAux = null;
		if (alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alertaprogramacion.getAlerta().getAlcodigo();
		}
		Object getTipoCaracterAlertaTcacodigoAux = null;
		if (alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcacodigo() != null) {
			getTipoCaracterAlertaTcacodigoAux = alertaprogramacion
					.getTipoCaracterAlerta().getTcacodigo();
		}
		Object getDistribuidorRdcodigoAux = null;
		if (alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdcodigo() != null) {
			getDistribuidorRdcodigoAux = alertaprogramacion.getDistribuidor()
					.getRdcodigo();
		}
		this.jdbcTemplate.update(query, getAlertaAlcodigoAux,
				getTipoCaracterAlertaTcacodigoAux, getDistribuidorRdcodigoAux,
				alertaprogramacion.getCrcoor(),
				alertaprogramacion.getCrferere(),
				alertaprogramacion.getCrteinfo(),
				alertaprogramacion.getCrcnactu(),
				alertaprogramacion.getCrinprse(),
				alertaprogramacion.getCrfechacomunicacion(),
				alertaprogramacion.getCrfechaplazo(),
				alertaprogramacion.getCrfechacierre(),
				alertaprogramacion.getCracuerdoinicio(),
				alertaprogramacion.getCrcodigo());
		return alertaprogramacion;
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            Pagination
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion updateFechaCierre(
			AlertaProgramacion alertaprogramacion) {
		String query = "UPDATE ALERTA_PROGRAMACION SET CRFECHACIERRE=? WHERE CRCODIGO=?";

		this.jdbcTemplate.update(query, alertaprogramacion.getCrfechacierre(),
				alertaprogramacion.getCrcodigo());
		return alertaprogramacion;
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion updateNumActuaciones(
			AlertaProgramacion alertaprogramacion) {
		String query = "UPDATE ALERTA_PROGRAMACION SET CRCNACTU=? WHERE CRCODIGO=?";

		this.jdbcTemplate.update(query, alertaprogramacion.getCrcnactu(),
				alertaprogramacion.getCrcodigo());
		return alertaprogramacion;
	}

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion updateEliminarInspeccionNumActuaciones(
			AlertaProgramacion alertaprogramacion) {
		String query = "UPDATE ALERTA_PROGRAMACION SET CRCNACTU=NVL(CRCNACTU,0) - 1 WHERE CRCODIGO=?";

		this.jdbcTemplate.update(query, alertaprogramacion.getCrcodigo());
		return alertaprogramacion;
	}

	/**
	 * Finds a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            Pagination
	 * @return AlertaProgramacion
	 */
	@Transactional(readOnly = true)
	public AlertaProgramacion find(AlertaProgramacion alertaprogramacion) {
		String query = "SELECT t1.CRCODIGO CRCODIGO, t1.CRCOOR CRCOOR, t1.CRFERERE CRFERERE, t1.CRTEINFO CRTEINFO, t1.CRCNACTU CRCNACTU, t1.CRINPRSE CRINPRSE, t1.CRFECHACOMUNICACION CRFECHACOMUNICACION, t1.CRFECHAPLAZO CRFECHAPLAZO, t1.CRFECHACIERRE CRFECHACIERRE, t1.CRACUERDOINICIO CRACUERDOINICIO, t1.CRINSPECCIONSOLICITADA CRINSPECCIONSOLICITADA, t2.ALCODIGO ALERTAALCODIGO, t2.ALCOOR ALERTAALCOOR, t2.ALNRAN ALERTAALNRAN, t2.ALNROR ALERTAALNROR, t2.ALFEEN ALERTAALFEEN, t2.ALFEPLRR ALERTAALFEPLRR, t2.ALCOPS ALERTAALCOPS, t2.ALNOPRSE ALERTAALNOPRSE, t2.ALNRLOPS ALERTAALNRLOPS, t2.ALNOMAPS ALERTAALNOMAPS, t2.ALNOMOPS ALERTAALNOMOPS, t2.ALFEDUMI ALERTAALFEDUMI, t2.ALCOCA ALERTAALCOCA, t2.ALCOPA ALERTAALCOPA, t2.ALCOTOP ALERTAALCOTOP, t2.ALTEIN ALERTAALTEIN, t2.ALCOES ALERTAALCOES, t2.ALFERRIN ALERTAALFERRIN, t2.ALINRE ALERTAALINRE, t2.ALFECOOR ALERTAALFECOOR, t2.ALCOTMO ALERTAALCOTMO, t2.ALAECOSAN ALERTAALAECOSAN, t2.ALACTIVA ALERTAALACTIVA, t2.ALANULADA ALERTAALANULADA, t2.ALFECHAANULACION ALERTAALFECHAANULACION, t2.ALINDICACIONES ALERTAALINDICACIONES, t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS, t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO, t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO, t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO, t3.TCACODIGO TIPOCARACTERALERTATCACODIGO, t3.TCANOMBRE TIPOCARACTERALERTATCANOMBRE, t3.TCANOMBREE TIPOCARACTERALERTATCANOMBREE, t4.RDCODIGO DISTRIBUIDORRDCODIGO, t4.RDCOES DISTRIBUIDORRDCOES, t4.RDFABRICANTE DISTRIBUIDORRDFABRICANTE, t4.RDIDINTERVINIENTE DISTRIBUIDORRDIDINTERVINIENTE, t2.ALCODIGOREL ALERTAALCODIGOREL, t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO, t4.RDCOAL DISTRIBUIDORRDCOAL, t5.IDINTERVINIENTE IntervinienteID, t5.NOMBRE IntervinienteNOMBRE, t5.NIF IntervinienteNIF, t5.ESNOCO IntervinienteESNOCO FROM ALERTA_PROGRAMACION t1 , ALERTA t2 , TIPO_CARACTER_ALERTA t3 , DISTRIBUIDOR t4, INTERVINIENTES t5  WHERE t1.CRCODIGO = ?   AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) AND t1.CRCODIGODISTRIBUIDOR= t4.RDCODIGO(+) AND t4.RDIDINTERVINIENTE = t5.IDINTERVINIENTE(+)";

		List<AlertaProgramacion> alertaprogramacionList = this.jdbcTemplate
				.query(query, this.rwMap, alertaprogramacion.getCrcodigo());
		return (AlertaProgramacion) DataAccessUtils
				.uniqueResult(alertaprogramacionList);
	}

	/**
	 * Removes a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            Pagination
	 * @return
	 */
	public void remove(AlertaProgramacion alertaprogramacion) {
		String query = "DELETE FROM ALERTA_PROGRAMACION WHERE CRCODIGO=?";
		this.jdbcTemplate.update(query, alertaprogramacion.getCrcodigo());
	}

	/**
	 * Removes a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	public void removeAlertaprograNoAdjunta(Alerta alerta) {
		String query = "DELETE FROM ALERTA_PROGRAMACION WHERE CRCODIGO NOT IN (SELECT CRCODIGO FROM ADJUNTAR_ALERTAPROGRA) AND CRCOAL=?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Finds a List of rows in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaProgramacion> findAll(
			AlertaProgramacion alertaprogramacion, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CRCODIGO CRCODIGO,t1.CRCOOR CRCOOR,t1.CRFERERE CRFERERE,t1.CRTEINFO CRTEINFO,t1.CRCNACTU CRCNACTU,t1.CRINPRSE CRINPRSE,t1.CRFECHACOMUNICACION CRFECHACOMUNICACION,t1.CRFECHAPLAZO CRFECHAPLAZO,t1.CRFECHACIERRE CRFECHACIERRE,t1.CRACUERDOINICIO CRACUERDOINICIO, t1.CRINSPECCIONSOLICITADA CRINSPECCIONSOLICITADA,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t3.TCACODIGO TIPOCARACTERALERTATCACODIGO,t3.TCANOMBRE TIPOCARACTERALERTATCANOMBRE,t3.TCANOMBREE TIPOCARACTERALERTATCANOMBREE,t4.RDCODIGO DISTRIBUIDORRDCODIGO,t4.RDCOES DISTRIBUIDORRDCOES,t4.RDFABRICANTE DISTRIBUIDORRDFABRICANTE,t4.RDIDINTERVINIENTE DISTRIBUIDORRDIDINTERVINIENTE,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO,t4.RDCOAL DISTRIBUIDORRDCOAL, t5.IDINTERVINIENTE IntervinienteID, t5.NOMBRE IntervinienteNOMBRE, t5.NIF IntervinienteNIF, t5.ESNOCO IntervinienteESNOCO ");
		query.append("FROM ALERTA_PROGRAMACION t1, ALERTA t2, TIPO_CARACTER_ALERTA t3, DISTRIBUIDOR t4, INTERVINIENTES t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(alertaprogramacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) AND t1.CRCODIGODISTRIBUIDOR= t4.RDCODIGO(+) AND t4.RDIDINTERVINIENTE = t5.IDINTERVINIENTE ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AlertaProgramacion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AlertaProgramacion alertaprogramacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ALERTA_PROGRAMACION t1 , ALERTA t2 , TIPO_CARACTER_ALERTA t3 , DISTRIBUIDOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(alertaprogramacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) AND t1.CRCODIGODISTRIBUIDOR= t4.RDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaProgramacion> findAllLike(
			AlertaProgramacion alertaprogramacion, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CRCODIGO CRCODIGO,t1.CRCOOR CRCOOR,t1.CRFERERE CRFERERE,t1.CRTEINFO CRTEINFO,t1.CRCNACTU CRCNACTU,t1.CRINPRSE CRINPRSE,t1.CRFECHACOMUNICACION CRFECHACOMUNICACION,t1.CRFECHAPLAZO CRFECHAPLAZO,t1.CRFECHACIERRE CRFECHACIERRE,t1.CRACUERDOINICIO CRACUERDOINICIO, t1.CRINSPECCIONSOLICITADA CRINSPECCIONSOLICITADA,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t3.TCACODIGO TIPOCARACTERALERTATCACODIGO,t3.TCANOMBRE TIPOCARACTERALERTATCANOMBRE,t3.TCANOMBREE TIPOCARACTERALERTATCANOMBREE,t4.RDCODIGO DISTRIBUIDORRDCODIGO,t4.RDCOES DISTRIBUIDORRDCOES,t4.RDFABRICANTE DISTRIBUIDORRDFABRICANTE,t4.RDIDINTERVINIENTE DISTRIBUIDORRDIDINTERVINIENTE,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO,t4.RDCOAL DISTRIBUIDORRDCOAL, t5.IDINTERVINIENTE IntervinienteID, t5.NOMBRE IntervinienteNOMBRE, t5.NIF IntervinienteNIF, t5.ESNOCO IntervinienteESNOCO ");
		query.append("FROM ALERTA_PROGRAMACION t1 ,ALERTA t2 ,TIPO_CARACTER_ALERTA t3 ,DISTRIBUIDOR t4, INTERVINIENTES t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(alertaprogramacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) AND t1.CRCODIGODISTRIBUIDOR= t4.RDCODIGO(+) AND t4.RDIDINTERVINIENTE = t5.IDINTERVINIENTE ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AlertaProgramacion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AlertaProgramacion alertaprogramacion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ALERTA_PROGRAMACION t1 ,ALERTA t2 ,TIPO_CARACTER_ALERTA t3 ,DISTRIBUIDOR t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(alertaprogramacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) AND t1.CRCODIGODISTRIBUIDOR= t4.RDCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AlertaProgramacion entity
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AlertaProgramacion alertaprogramacion) {

		StringBuilder where = new StringBuilder(
				AlertaProgramacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (alertaprogramacion != null
				&& alertaprogramacion.getCrcodigo() != null) {
			where.append(" AND t1.CRCODIGO = ?");
			params.add(alertaprogramacion.getCrcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(alertaprogramacion.getAlerta().getAlcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGOREL = ?");
			params.add(alertaprogramacion.getAlerta().getAlerta().getAlcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getNaturalezaPeligro() != null
				&& alertaprogramacion.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro() != null) {
			where.append(" AND t2.ALIDNATURALEZAPELIGRO = ?");
			params.add(alertaprogramacion.getAlerta().getNaturalezaPeligro()
					.getIdnaturalezapeligro());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(alertaprogramacion.getAlerta().getAlcoor());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(alertaprogramacion.getAlerta().getAlnran());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(alertaprogramacion.getAlerta().getAlnror());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(alertaprogramacion.getAlerta().getAlfeen());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(alertaprogramacion.getAlerta().getAlfeplrr());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcops() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(alertaprogramacion.getAlerta().getAlcops());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(alertaprogramacion.getAlerta().getAlnoprse());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(alertaprogramacion.getAlerta().getAlnrlops());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(alertaprogramacion.getAlerta().getAlnomaps());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(alertaprogramacion.getAlerta().getAlnomops());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(alertaprogramacion.getAlerta().getAlfedumi());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcoca() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(alertaprogramacion.getAlerta().getAlcoca());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcopa() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(alertaprogramacion.getAlerta().getAlcopa());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcotop() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(alertaprogramacion.getAlerta().getAlcotop());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(alertaprogramacion.getAlerta().getAltein());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcoes() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(alertaprogramacion.getAlerta().getAlcoes());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(alertaprogramacion.getAlerta().getAlferrin());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(alertaprogramacion.getAlerta().getAlinre());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(alertaprogramacion.getAlerta().getAlfecoor());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(alertaprogramacion.getAlerta().getAlcotmo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlaecosan() != null) {
			where.append(" AND t2.ALAECOSAN = ?");
			params.add(alertaprogramacion.getAlerta().getAlaecosan());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlactiva() != null) {
			where.append(" AND t2.ALACTIVA = ?");
			params.add(alertaprogramacion.getAlerta().getAlactiva());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlanulada() != null) {
			where.append(" AND t2.ALANULADA = ?");
			params.add(alertaprogramacion.getAlerta().getAlanulada());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfechaanulacion() != null) {
			where.append(" AND t2.ALFECHAANULACION = ?");
			params.add(alertaprogramacion.getAlerta().getAlfechaanulacion());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcodigobarras() != null) {
			where.append(" AND t2.ALCODIGOBARRAS = ?");
			params.add(alertaprogramacion.getAlerta().getAlcodigobarras());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlorigenproducto() != null) {
			where.append(" AND t2.ALORIGENPRODUCTO = ?");
			params.add(alertaprogramacion.getAlerta().getAlorigenproducto());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlccaaproducto() != null) {
			where.append(" AND t2.ALCCAAPRODUCTO = ?");
			params.add(alertaprogramacion.getAlerta().getAlccaaproducto());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlpaisproducto() != null) {
			where.append(" AND t2.ALPAISPRODUCTO = ?");
			params.add(alertaprogramacion.getAlerta().getAlpaisproducto());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcacodigo() != null) {
			where.append(" AND t3.TCACODIGO = ?");
			params.add(alertaprogramacion.getTipoCaracterAlerta()
					.getTcacodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcanombre() != null) {
			where.append(" AND t3.TCANOMBRE = ?");
			params.add(alertaprogramacion.getTipoCaracterAlerta()
					.getTcanombre());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcanombree() != null) {
			where.append(" AND t3.TCANOMBREE = ?");
			params.add(alertaprogramacion.getTipoCaracterAlerta()
					.getTcanombree());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdcodigo() != null) {
			where.append(" AND t4.RDCODIGO = ?");
			params.add(alertaprogramacion.getDistribuidor().getRdcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getAlerta() != null
				&& alertaprogramacion.getDistribuidor().getAlerta()
						.getAlcodigo() != null) {
			where.append(" AND t4.RDCOAL = ?");
			params.add(alertaprogramacion.getDistribuidor().getAlerta()
					.getAlcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdcoes() != null) {
			where.append(" AND t4.RDCOES = ?");
			params.add(alertaprogramacion.getDistribuidor().getRdcoes());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdfabricante() != null) {
			where.append(" AND t4.RDFABRICANTE = ?");
			params.add(alertaprogramacion.getDistribuidor().getRdfabricante());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdidinterviniente() != null) {
			where.append(" AND t4.RDIDINTERVINIENTE = ?");
			params.add(alertaprogramacion.getDistribuidor()
					.getRdidinterviniente());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrcoor() != null) {
			where.append(" AND t1.CRCOOR = ?");
			params.add(alertaprogramacion.getCrcoor());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrferere() != null) {
			where.append(" AND t1.CRFERERE = ?");
			params.add(alertaprogramacion.getCrferere());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrteinfo() != null) {
			where.append(" AND t1.CRTEINFO = ?");
			params.add(alertaprogramacion.getCrteinfo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(alertaprogramacion.getCrcnactu());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrinprse() != null) {
			where.append(" AND t1.CRINPRSE = ?");
			params.add(alertaprogramacion.getCrinprse());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrfechacomunicacion() != null) {
			where.append(" AND t1.CRFECHACOMUNICACION = ?");
			params.add(alertaprogramacion.getCrfechacomunicacion());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrfechaplazo() != null) {
			where.append(" AND t1.CRFECHAPLAZO = ?");
			params.add(alertaprogramacion.getCrfechaplazo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrfechacierre() != null) {
			where.append(" AND t1.CRFECHACIERRE = ?");
			params.add(alertaprogramacion.getCrfechacierre());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCracuerdoinicio() != null) {
			where.append(" AND t1.CRACUERDOINICIO = ?");
			params.add(alertaprogramacion.getCracuerdoinicio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AlertaProgramacion entity
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AlertaProgramacion alertaprogramacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AlertaProgramacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (alertaprogramacion != null
				&& alertaprogramacion.getCrcodigo() != null) {
			where.append(" AND UPPER(t1.CRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getCrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + alertaprogramacion.getCrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCODIGO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(alertaprogramacion.getAlerta().getAlcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND UPPER(t2.ALCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlerta()
						.getAlcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlerta()
								.getAlcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ALCODIGOREL IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getNaturalezaPeligro() != null
				&& alertaprogramacion.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro() != null) {
			where.append(" AND UPPER(t2.ALIDNATURALEZAPELIGRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta()
						.getNaturalezaPeligro().getIdnaturalezapeligro()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getNaturalezaPeligro()
								.getIdnaturalezapeligro().toUpperCase() + "%");
			}
			where.append(" AND t2.ALIDNATURALEZAPELIGRO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcoor() != null) {
			where.append(" AND UPPER(t2.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOOR IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(alertaprogramacion.getAlerta().getAlnran());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnror() != null) {
			where.append(" AND UPPER(t2.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlnror()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlnror()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNROR IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(alertaprogramacion.getAlerta().getAlfeen());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(alertaprogramacion.getAlerta().getAlfeplrr());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcops() != null) {
			where.append(" AND UPPER(t2.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOPS IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnoprse() != null) {
			where.append(" AND UPPER(t2.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlnoprse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlnoprse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNOPRSE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnrlops() != null) {
			where.append(" AND UPPER(t2.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlnrlops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNRLOPS IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnomaps() != null) {
			where.append(" AND UPPER(t2.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlnomaps()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNOMAPS IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlnomops() != null) {
			where.append(" AND UPPER(t2.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlnomops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNOMOPS IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(alertaprogramacion.getAlerta().getAlfedumi());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcoca() != null) {
			where.append(" AND UPPER(t2.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcoca()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcoca()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOCA IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcopa() != null) {
			where.append(" AND UPPER(t2.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcopa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcopa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOPA IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcotop() != null) {
			where.append(" AND UPPER(t2.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcotop()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcotop()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOTOP IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAltein() != null) {
			where.append(" AND UPPER(t2.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAltein()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAltein()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALTEIN IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcoes() != null) {
			where.append(" AND UPPER(t2.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcoes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcoes()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOES IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(alertaprogramacion.getAlerta().getAlferrin());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlinre() != null) {
			where.append(" AND UPPER(t2.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlinre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlinre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALINRE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(alertaprogramacion.getAlerta().getAlfecoor());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcotmo() != null) {
			where.append(" AND UPPER(t2.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcotmo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcotmo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOTMO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlaecosan() != null) {
			where.append(" AND UPPER(t2.ALAECOSAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlaecosan()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlaecosan()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALAECOSAN IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlactiva() != null) {
			where.append(" AND UPPER(t2.ALACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlactiva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlactiva()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALACTIVA IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlanulada() != null) {
			where.append(" AND UPPER(t2.ALANULADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlanulada()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlanulada()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALANULADA IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlfechaanulacion() != null) {
			where.append(" AND t2.ALFECHAANULACION = ?");
			params.add(alertaprogramacion.getAlerta().getAlfechaanulacion());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlcodigobarras() != null) {
			where.append(" AND UPPER(t2.ALCODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlcodigobarras()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlcodigobarras()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCODIGOBARRAS IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlorigenproducto() != null) {
			where.append(" AND UPPER(t2.ALORIGENPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlorigenproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlorigenproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALORIGENPRODUCTO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlccaaproducto() != null) {
			where.append(" AND UPPER(t2.ALCCAAPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlccaaproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlccaaproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCCAAPRODUCTO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getAlerta() != null
				&& alertaprogramacion.getAlerta().getAlpaisproducto() != null) {
			where.append(" AND UPPER(t2.ALPAISPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getAlerta().getAlpaisproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getAlerta().getAlpaisproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALPAISPRODUCTO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcacodigo() != null) {
			where.append(" AND t3.TCACODIGO = ?");
			params.add(alertaprogramacion.getTipoCaracterAlerta()
					.getTcacodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcanombre() != null) {
			where.append(" AND UPPER(t3.TCANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getTipoCaracterAlerta()
						.getTcanombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getTipoCaracterAlerta()
								.getTcanombre().toUpperCase() + "%");
			}
			where.append(" AND t3.TCANOMBRE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getTipoCaracterAlerta() != null
				&& alertaprogramacion.getTipoCaracterAlerta().getTcanombree() != null) {
			where.append(" AND UPPER(t3.TCANOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getTipoCaracterAlerta()
						.getTcanombree().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getTipoCaracterAlerta()
								.getTcanombree().toUpperCase() + "%");
			}
			where.append(" AND t3.TCANOMBREE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdcodigo() != null) {
			where.append(" AND t4.RDCODIGO = ?");
			params.add(alertaprogramacion.getDistribuidor().getRdcodigo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getAlerta() != null
				&& alertaprogramacion.getDistribuidor().getAlerta()
						.getAlcodigo() != null) {
			where.append(" AND UPPER(t4.RDCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getDistribuidor().getAlerta()
						.getAlcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getDistribuidor().getAlerta()
								.getAlcodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.RDCOAL IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdcoes() != null) {
			where.append(" AND UPPER(t4.RDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getDistribuidor().getRdcoes()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getDistribuidor().getRdcoes()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.RDCOES IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdfabricante() != null) {
			where.append(" AND UPPER(t4.RDFABRICANTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getDistribuidor()
						.getRdfabricante().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getDistribuidor()
								.getRdfabricante().toUpperCase() + "%");
			}
			where.append(" AND t4.RDFABRICANTE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getDistribuidor() != null
				&& alertaprogramacion.getDistribuidor().getRdidinterviniente() != null) {
			where.append(" AND UPPER(t4.RDIDINTERVINIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getDistribuidor()
						.getRdidinterviniente().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertaprogramacion.getDistribuidor()
								.getRdidinterviniente().toUpperCase() + "%");
			}
			where.append(" AND t4.RDIDINTERVINIENTE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrcoor() != null) {
			where.append(" AND UPPER(t1.CRCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getCrcoor().toUpperCase() + "%");
			} else {
				params.add("%" + alertaprogramacion.getCrcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCOOR IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrferere() != null) {
			where.append(" AND t1.CRFERERE = ?");
			params.add(alertaprogramacion.getCrferere());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrteinfo() != null) {
			where.append(" AND UPPER(t1.CRTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getCrteinfo().toUpperCase() + "%");
			} else {
				params.add("%" + alertaprogramacion.getCrteinfo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRTEINFO IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(alertaprogramacion.getCrcnactu());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrinprse() != null) {
			where.append(" AND UPPER(t1.CRINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertaprogramacion.getCrinprse().toUpperCase() + "%");
			} else {
				params.add("%" + alertaprogramacion.getCrinprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRINPRSE IS NOT NULL");
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrfechacomunicacion() != null) {
			where.append(" AND t1.CRFECHACOMUNICACION = ?");
			params.add(alertaprogramacion.getCrfechacomunicacion());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrfechaplazo() != null) {
			where.append(" AND t1.CRFECHAPLAZO = ?");
			params.add(alertaprogramacion.getCrfechaplazo());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCrfechacierre() != null) {
			where.append(" AND t1.CRFECHACIERRE = ?");
			params.add(alertaprogramacion.getCrfechacierre());
		}
		if (alertaprogramacion != null
				&& alertaprogramacion.getCracuerdoinicio() != null) {
			where.append(" AND t1.CRACUERDOINICIO = ?");
			params.add(alertaprogramacion.getCracuerdoinicio());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Inserts a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllAlertaProgramacion(Alerta alerta, String codCampanhaAlta) {

		String query = "INSERT INTO ALERTA_PROGRAMACION (CRCODIGO, CRCOAL, CRTIPO, CRCODIGODISTRIBUIDOR, CRCOOR, CRFERERE, CRCNACTU, CRINPRSE, CRFECHACOMUNICACION, CRFECHAPLAZO, CRFECHACIERRE, CRACUERDOINICIO, CRINSPECCIONSOLICITADA) SELECT CRCODIGO, ?, CRTIPO, CRCODIGODISTRIBUIDOR, CRCOOR, CRFERERE, CRCNACTU, CRINPRSE, CRFECHACOMUNICACION, CRFECHAPLAZO, CRFECHACIERRE, CRACUERDOINICIO, CRINSPECCIONSOLICITADA FROM ADJUNTAR_ALERTAPROGRA WHERE 1=1 AND CRCODIGO NOT IN (SELECT CRCODIGO FROM ALERTA_PROGRAMACION) AND CRCOAL = ? ";
		this.jdbcTemplate.update(query, alerta.getAlcodigo(), codCampanhaAlta);
	}

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAlertaProgramacion(Alerta alerta) {
		String query = "DELETE  FROM ALERTA_PROGRAMACION WHERE 1=1 AND CRCOAL=?";

		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAllAlertaProgramacion(Alerta alerta) {
		String query = "DELETE  FROM ALERTA_PROGRAMACION WHERE CRCOAL=?";

		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Finds a List of rows in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaProgramacion> findAllAlertaProgramacionEliminadas(
			Alerta alerta, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT t1.CRCODIGO CRCODIGO ");
		query.append("FROM ALERTA_PROGRAMACION t1 WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.CRCOAL = ? ");
		params.add(alerta.getAlcodigo());

		where.append(" AND t1.CRCODIGO NOT IN (SELECT  tt1.CRCODIGO FROM ADJUNTAR_ALERTAPROGRA tt1 WHERE tt1.CRCOAL = ?)");
		params.add(alerta.getAlcodigo());

		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AlertaProgramacion>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<AlertaProgramacion>() {
					public AlertaProgramacion mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AlertaProgramacion(resultSet
								.getString("CRCODIGO"));
					}
				}, params.toArray());
	}

	/**
	 * Finds a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	@Transactional(readOnly = true)
	public AlertaProgramacion findLimitesAlerta(
			AlertaProgramacion alertaprogramacion) {
		String query = "SELECT MAX(t1.CRFECHAPLAZO) CRFECHAPLAZO FROM ALERTA_PROGRAMACION t1  WHERE t1.CRCOAL= ? ";

		List<AlertaProgramacion> alertaprogramacionList = this.jdbcTemplate
				.query(query, new RowMapper<AlertaProgramacion>() {
					public AlertaProgramacion mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new AlertaProgramacion(resultSet
								.getDate("CRFECHAPLAZO"));
					}
				}, alertaprogramacion.getAlerta().getAlcodigo());
		return (AlertaProgramacion) DataAccessUtils
				.uniqueResult(alertaprogramacionList);
	}
}
