package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaProgramacion;

/**
 * AlertaProgramacionDao  
 * 
 *  
 */

public interface AlertaProgramacionDao {

	/**
	 * Inserts a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	AlertaProgramacion add(AlertaProgramacion alertaprogramacion);

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	AlertaProgramacion update(AlertaProgramacion alertaprogramacion);

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            Pagination
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion updateFechaCierre(
			AlertaProgramacion alertaprogramacion);

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion updateNumActuaciones(
			AlertaProgramacion alertaprogramacion);

	/**
	 * Updates a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion updateEliminarInspeccionNumActuaciones(
			AlertaProgramacion alertaprogramacion);

	/**
	 * Finds a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	AlertaProgramacion find(AlertaProgramacion alertaprogramacion);

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return
	 */
	void remove(AlertaProgramacion alertaprogramacion);

	/**
	 * Removes a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return
	 */
	public void removeAlertaprograNoAdjunta(Alerta alerta);

	/**
	 * Finds a List of rows in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AlertaProgramacion> findAll(AlertaProgramacion alertaprogramacion,
			Pagination pagination);

	/**
	 * Counts rows in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return Long
	 */
	Long findAllCount(AlertaProgramacion alertaprogramacion);

	/**
	 * Finds rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AlertaProgramacion> findAllLike(AlertaProgramacion alertaprogramacion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the AlertaProgramacion table using like.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AlertaProgramacion alertaprogramacion,
			Boolean startsWith);

	/**
	 * Inserts a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param codCampanhaAlta
	 *            String
	 */
	public void addAllAlertaProgramacion(Alerta alerta, String codCampanhaAlta);

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAlertaProgramacion(Alerta alerta);

	/**
	 * Deletes a single row in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void removeAllAlertaProgramacion(Alerta alerta);

	/**
	 * Finds a List of rows in the AlertaProgramacion table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AlertaProgramacion> findAllAlertaProgramacionEliminadas(
			Alerta alerta, Pagination pagination);

	/**
	 * Finds a single row in the AlertaProgramacion table.
	 * 
	 * @param alertaprogramacion
	 *            AlertaProgramacion
	 * @return AlertaProgramacion
	 */
	public AlertaProgramacion findLimitesAlerta(
			AlertaProgramacion alertaprogramacion);
}
