package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaDetalle;
import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * AlertaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AlertaDaoImpl implements AlertaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Alerta> rwMap = new RowMapper<Alerta>() {
		public Alerta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Alerta(
					resultSet.getString("ALCODIGO"),
					resultSet.getString("ALCOOR"),
					resultSet.getLong("ALNRAN"),
					resultSet.getString("ALNROR"),
					resultSet.getDate("ALFEEN"),
					resultSet.getDate("ALFEPLRR"),
					resultSet.getString("ALCOPS"),
					resultSet.getString("PRODUCTOPSNOMBRE"),
					resultSet.getString("PRODUCTOPSNOMBREE"),
					resultSet.getString("ALNOPRSE"),
					resultSet.getString("ALNRLOPS"),
					resultSet.getString("ALNOMAPS"),
					resultSet.getString("ALNOMOPS"),
					resultSet.getDate("ALFEDUMI"),
					resultSet.getString("ALCOCA"),
					resultSet.getString("ALCOPA"),
					resultSet.getString("ALCOTOP"),
					resultSet.getString("ALTEIN"),
					resultSet.getString("ALCOES"),
					resultSet.getDate("ALFERRIN"),
					resultSet.getString("ALINRE"),
					resultSet.getDate("ALFECOOR"),
					resultSet.getString("ALCOTMO"),
					resultSet.getString("ALAECOSAN"),
					resultSet.getString("ALACTIVA"),
					resultSet.getString("ALANULADA"),
					resultSet.getDate("ALFECHAANULACION"),
					resultSet.getString("ALINDICACIONES"),
					resultSet.getString("ALCODIGOBARRAS"),
					resultSet.getString("ALORIGENPRODUCTO"),
					resultSet.getString("ALCCAAPRODUCTO"),
					resultSet.getString("ALPAISPRODUCTO"),
					new Alerta(resultSet.getString("AlertaALCODIGO"), resultSet
							.getString("AlertaALCOOR"), resultSet
							.getLong("AlertaALNRAN"), resultSet
							.getString("AlertaALNROR"), resultSet
							.getDate("AlertaALFEEN"), resultSet
							.getDate("AlertaALFEPLRR"), resultSet
							.getString("AlertaALCOPS"), null, null, resultSet
							.getString("AlertaALNOPRSE"), resultSet
							.getString("AlertaALNRLOPS"), resultSet
							.getString("AlertaALNOMAPS"), resultSet
							.getString("AlertaALNOMOPS"), resultSet
							.getDate("AlertaALFEDUMI"), resultSet
							.getString("AlertaALCOCA"), resultSet
							.getString("AlertaALCOPA"), resultSet
							.getString("AlertaALCOTOP"), resultSet
							.getString("AlertaALTEIN"), resultSet
							.getString("AlertaALCOES"), resultSet
							.getDate("AlertaALFERRIN"), resultSet
							.getString("AlertaALINRE"), resultSet
							.getDate("AlertaALFECOOR"), resultSet
							.getString("AlertaALCOTMO"), resultSet
							.getString("AlertaALAECOSAN"), resultSet
							.getString("AlertaALACTIVA"), resultSet
							.getString("AlertaALANULADA"), resultSet
							.getDate("AlertaALFECHAANULACION"), resultSet
							.getString("AlertaALINDICACIONES"), resultSet
							.getString("AlertaALCODIGOBARRAS"), resultSet
							.getString("AlertaALORIGENPRODUCTO"), resultSet
							.getString("AlertaALCCAAPRODUCTO"), resultSet
							.getString("AlertaALPAISPRODUCTO"), new Alerta(
							resultSet.getString("AlertaALCODIGOREL"), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null), new NaturalezaPeligro(resultSet
							.getString("AlertaALIDNATURALEZAPELIGRO"), null,
							null, null), null),
					new NaturalezaPeligro(resultSet
							.getString("NatPeligroIDNATURALEZAPELIGRO"),
							resultSet.getString("NatPeligroNATURALEZAPELIGRO"),
							resultSet.getString("NatPeligroNATURALEZAPELIGROE")),
					resultSet.getDate("MAXFECHAPLAZO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	public Alerta add(Alerta alerta) {
		String query = "INSERT INTO ALERTA (ALCODIGO, ALCODIGOREL, ALIDNATURALEZAPELIGRO, ALCOOR, ALNRAN, ALNROR, ALFEEN, ALFEPLRR, ALCOPS, ALNOPRSE, ALNRLOPS, ALNOMAPS, ALNOMOPS, ALFEDUMI, ALCOCA, ALCOPA, ALCOTOP, ALTEIN, ALCOES, ALFERRIN, ALINRE, ALFECOOR, ALCOTMO, ALAECOSAN, ALACTIVA, ALANULADA, ALFECHAANULACION, ALINDICACIONES, ALCODIGOBARRAS, ALORIGENPRODUCTO, ALCCAAPRODUCTO, ALPAISPRODUCTO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getAlertaAlcodigoAux = null;
		if (alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alerta.getAlerta().getAlcodigo();
		}
		Object getNaturalezaPeligroIdnaturalezapeligroAux = null;
		if (alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getIdnaturalezapeligro() != null) {
			getNaturalezaPeligroIdnaturalezapeligroAux = alerta
					.getNaturalezaPeligro().getIdnaturalezapeligro();
		}
		this.jdbcTemplate.update(query, alerta.getAlcodigo(),
				getAlertaAlcodigoAux,
				getNaturalezaPeligroIdnaturalezapeligroAux, alerta.getAlcoor(),
				alerta.getAlnran(), alerta.getAlnror(), alerta.getAlfeen(),
				alerta.getAlfeplrr(), alerta.getAlcops(), alerta.getAlnoprse(),
				alerta.getAlnrlops(), alerta.getAlnomaps(),
				alerta.getAlnomops(), alerta.getAlfedumi(), alerta.getAlcoca(),
				alerta.getAlcopa(), alerta.getAlcotop(), alerta.getAltein(),
				alerta.getAlcoes(), alerta.getAlferrin(), alerta.getAlinre(),
				alerta.getAlfecoor(), alerta.getAlcotmo(),
				alerta.getAlaecosan(), alerta.getAlactiva(),
				alerta.getAlanulada(), alerta.getAlfechaanulacion(),
				alerta.getAlindicaciones(), alerta.getAlcodigobarras(),
				alerta.getAlorigenproducto(), alerta.getAlccaaproducto(),
				alerta.getAlpaisproducto());
		return alerta;
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	public Alerta update(Alerta alerta) {
		String query = "UPDATE ALERTA SET ALCODIGOREL=?, ALIDNATURALEZAPELIGRO=?, ALCOOR=?, ALNRAN=?, ALNROR=?, ALFEEN=?, ALFEPLRR=?, ALCOPS=?, ALNOPRSE=?, ALNRLOPS=?, ALNOMAPS=?, ALNOMOPS=?, ALFEDUMI=?, ALCOCA=?, ALCOPA=?, ALCOTOP=?, ALTEIN=?, ALCOES=?, ALFERRIN=?, ALINRE=?, ALFECOOR=?, ALCOTMO=?, ALAECOSAN=?, ALACTIVA=?, ALANULADA=?, ALFECHAANULACION=?, ALINDICACIONES=?, ALCODIGOBARRAS=?, ALORIGENPRODUCTO=?, ALCCAAPRODUCTO=?, ALPAISPRODUCTO=? WHERE ALCODIGO=?";
		Object getAlertaAlcodigoAux = null;
		if (alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alerta.getAlerta().getAlcodigo();
		}
		Object getNaturalezaPeligroIdnaturalezapeligroAux = null;
		if (alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getIdnaturalezapeligro() != null) {
			getNaturalezaPeligroIdnaturalezapeligroAux = alerta
					.getNaturalezaPeligro().getIdnaturalezapeligro();
		}
		this.jdbcTemplate.update(query, getAlertaAlcodigoAux,
				getNaturalezaPeligroIdnaturalezapeligroAux, alerta.getAlcoor(),
				alerta.getAlnran(), alerta.getAlnror(), alerta.getAlfeen(),
				alerta.getAlfeplrr(), alerta.getAlcops(), alerta.getAlnoprse(),
				alerta.getAlnrlops(), alerta.getAlnomaps(),
				alerta.getAlnomops(), alerta.getAlfedumi(), alerta.getAlcoca(),
				alerta.getAlcopa(), alerta.getAlcotop(), alerta.getAltein(),
				alerta.getAlcoes(), alerta.getAlferrin(), alerta.getAlinre(),
				alerta.getAlfecoor(), alerta.getAlcotmo(),
				alerta.getAlaecosan(), alerta.getAlactiva(),
				alerta.getAlanulada(), alerta.getAlfechaanulacion(),
				alerta.getAlindicaciones(), alerta.getAlcodigobarras(),
				alerta.getAlorigenproducto(), alerta.getAlccaaproducto(),
				alerta.getAlpaisproducto(), alerta.getAlcodigo());
		return alerta;
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	public Alerta updateAlertaRelacionada(Alerta alerta) {
		String query = "UPDATE ALERTA SET ALCODIGOREL=? WHERE ALCODIGO=?";
		Object getAlertaAlcodigoAux = null;
		if (alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alerta.getAlerta().getAlcodigo();
		}
		this.jdbcTemplate.update(query, getAlertaAlcodigoAux,
				alerta.getAlcodigo());
		return alerta;
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	@Transactional(readOnly = true)
	public Alerta find(Alerta alerta) {
		String query = "SELECT t1.ALCODIGO ALCODIGO, t1.ALCOOR ALCOOR, t1.ALNRAN ALNRAN, t1.ALNROR ALNROR, t1.ALFEEN ALFEEN, t1.ALFEPLRR ALFEPLRR, t1.ALCOPS ALCOPS, t4.PSNOMBRE PRODUCTOPSNOMBRE, t4.PSNOMBREE PRODUCTOPSNOMBREE, t1.ALNOPRSE ALNOPRSE, t1.ALNRLOPS ALNRLOPS, t1.ALNOMAPS ALNOMAPS, t1.ALNOMOPS ALNOMOPS, t1.ALFEDUMI ALFEDUMI, t1.ALCOCA ALCOCA, t1.ALCOPA ALCOPA, t1.ALCOTOP ALCOTOP, t1.ALTEIN ALTEIN, t1.ALCOES ALCOES, t1.ALFERRIN ALFERRIN, t1.ALINRE ALINRE, t1.ALFECOOR ALFECOOR, t1.ALCOTMO ALCOTMO, t1.ALAECOSAN ALAECOSAN, t1.ALACTIVA ALACTIVA, t1.ALANULADA ALANULADA, t1.ALFECHAANULACION ALFECHAANULACION, t1.ALINDICACIONES ALINDICACIONES, t1.ALCODIGOBARRAS ALCODIGOBARRAS, t1.ALORIGENPRODUCTO ALORIGENPRODUCTO, t1.ALCCAAPRODUCTO ALCCAAPRODUCTO, t1.ALPAISPRODUCTO ALPAISPRODUCTO, t2.ALCODIGO ALERTAALCODIGO, t2.ALCOOR ALERTAALCOOR, t2.ALNRAN ALERTAALNRAN, t2.ALNROR ALERTAALNROR, t2.ALFEEN ALERTAALFEEN, t2.ALFEPLRR ALERTAALFEPLRR, t2.ALCOPS ALERTAALCOPS, t2.ALNOPRSE ALERTAALNOPRSE, t2.ALNRLOPS ALERTAALNRLOPS, t2.ALNOMAPS ALERTAALNOMAPS, t2.ALNOMOPS ALERTAALNOMOPS, t2.ALFEDUMI ALERTAALFEDUMI, t2.ALCOCA ALERTAALCOCA, t2.ALCOPA ALERTAALCOPA, t2.ALCOTOP ALERTAALCOTOP, t2.ALTEIN ALERTAALTEIN, t2.ALCOES ALERTAALCOES, t2.ALFERRIN ALERTAALFERRIN, t2.ALINRE ALERTAALINRE, t2.ALFECOOR ALERTAALFECOOR, t2.ALCOTMO ALERTAALCOTMO, t2.ALAECOSAN ALERTAALAECOSAN, t2.ALACTIVA ALERTAALACTIVA, t2.ALANULADA ALERTAALANULADA, t2.ALFECHAANULACION ALERTAALFECHAANULACION, t2.ALINDICACIONES ALERTAALINDICACIONES, t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS, t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO, t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO, t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO, t3.IDNATURALEZAPELIGRO NATPELIGROIDNATURALEZAPELIGRO, t3.NATURALEZAPELIGRO NATPELIGRONATURALEZAPELIGRO, t3.NATURALEZAPELIGROE NATPELIGRONATURALEZAPELIGROE, t2.ALCODIGOREL ALERTAALCODIGOREL, t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO, NULL MAXFECHAPLAZO FROM ALERTA t1 , ALERTA t2 , NATURALEZA_PELIGRO t3, PRODUCTO t4  WHERE t1.ALCODIGO = ?   AND t1.ALCODIGOREL= t2.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) ";

		List<Alerta> alertaList = this.jdbcTemplate.query(query, this.rwMap,
				alerta.getAlcodigo());
		return (Alerta) DataAccessUtils.uniqueResult(alertaList);
	}

	/**
	 * Removes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return
	 */
	public void remove(Alerta alerta) {
		String query = "DELETE FROM ALERTA WHERE ALCODIGO=?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Alerta> findAll(Alerta alerta, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALCOPS ALCOPS, t4.PSNOMBRE PRODUCTOPSNOMBRE, t4.PSNOMBREE PRODUCTOPSNOMBREE,t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALCOCA ALCOCA,t1.ALCOPA ALCOPA,t1.ALCOTOP ALCOTOP,t1.ALTEIN ALTEIN,t1.ALCOES ALCOES,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t1.ALAECOSAN ALAECOSAN,t1.ALACTIVA ALACTIVA,t1.ALANULADA ALANULADA,t1.ALFECHAANULACION ALFECHAANULACION,t1.ALINDICACIONES ALINDICACIONES,t1.ALCODIGOBARRAS ALCODIGOBARRAS,t1.ALORIGENPRODUCTO ALORIGENPRODUCTO,t1.ALCCAAPRODUCTO ALCCAAPRODUCTO,t1.ALPAISPRODUCTO ALPAISPRODUCTO,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t3.IDNATURALEZAPELIGRO NATPELIGROIDNATURALEZAPELIGRO,t3.NATURALEZAPELIGRO NATPELIGRONATURALEZAPELIGRO,t3.NATURALEZAPELIGROE NATPELIGRONATURALEZAPELIGROE,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO, (SELECT MAX(CRFECHAPLAZO) FROM ALERTA_PROGRAMACION t11 WHERE 1=1 AND t11.CRCOAL=t1.ALCODIGO) MAXFECHAPLAZO ");
		query.append("FROM ALERTA t1 ,ALERTA t2 ,NATURALEZA_PELIGRO t3, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(alerta);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ALCODIGOREL= t2.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Alerta>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Alerta alerta) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ALERTA t1 , ALERTA t2 , NATURALEZA_PELIGRO t3, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(alerta);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ALCODIGOREL= t2.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALCOPS ALCOPS, t4.PSNOMBRE PRODUCTOPSNOMBRE, t4.PSNOMBREE PRODUCTOPSNOMBREE, t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALCOCA ALCOCA,t1.ALCOPA ALCOPA,t1.ALCOTOP ALCOTOP,t1.ALTEIN ALTEIN,t1.ALCOES ALCOES,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t1.ALAECOSAN ALAECOSAN,t1.ALACTIVA ALACTIVA,t1.ALANULADA ALANULADA,t1.ALFECHAANULACION ALFECHAANULACION,t1.ALINDICACIONES ALINDICACIONES,t1.ALCODIGOBARRAS ALCODIGOBARRAS,t1.ALORIGENPRODUCTO ALORIGENPRODUCTO,t1.ALCCAAPRODUCTO ALCCAAPRODUCTO,t1.ALPAISPRODUCTO ALPAISPRODUCTO,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALCOPS ALERTAALCOPS,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALCOCA ALERTAALCOCA,t2.ALCOPA ALERTAALCOPA,t2.ALCOTOP ALERTAALCOTOP,t2.ALTEIN ALERTAALTEIN,t2.ALCOES ALERTAALCOES,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t2.ALAECOSAN ALERTAALAECOSAN,t2.ALACTIVA ALERTAALACTIVA,t2.ALANULADA ALERTAALANULADA,t2.ALFECHAANULACION ALERTAALFECHAANULACION,t2.ALINDICACIONES ALERTAALINDICACIONES,t2.ALCODIGOBARRAS ALERTAALCODIGOBARRAS,t2.ALORIGENPRODUCTO ALERTAALORIGENPRODUCTO,t2.ALCCAAPRODUCTO ALERTAALCCAAPRODUCTO,t2.ALPAISPRODUCTO ALERTAALPAISPRODUCTO,t3.IDNATURALEZAPELIGRO NATPELIGROIDNATURALEZAPELIGRO,t3.NATURALEZAPELIGRO NATPELIGRONATURALEZAPELIGRO,t3.NATURALEZAPELIGROE NATPELIGRONATURALEZAPELIGROE,t2.ALCODIGOREL ALERTAALCODIGOREL,t2.ALIDNATURALEZAPELIGRO ALERTAALIDNATURALEZAPELIGRO, (SELECT MAX(CRFECHAPLAZO) FROM ALERTA_PROGRAMACION t11 WHERE 1=1 AND t11.CRCOAL=t1.ALCODIGO) MAXFECHAPLAZO ");
		query.append("FROM ALERTA t1 ,ALERTA t2 ,NATURALEZA_PELIGRO t3, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(alerta, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ALCODIGOREL= t2.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Alerta>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Alerta alerta, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ALERTA t1 ,ALERTA t2 ,NATURALEZA_PELIGRO t3, PRODUCTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(alerta, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ALCODIGOREL= t2.ALCODIGO(+) AND t1.ALIDNATURALEZAPELIGRO= t3.IDNATURALEZAPELIGRO(+) AND t1.ALCOPS= t4.PSCODIGO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Alerta entity
	 * 
	 * @param alerta
	 *            Alerta Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Alerta alerta) {

		StringBuilder where = new StringBuilder(
				AlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (alerta != null && alerta.getAlcodigo() != null) {
			where.append(" AND t1.ALCODIGO = ?");
			params.add(alerta.getAlcodigo());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(alerta.getAlerta().getAlcodigo());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlerta() != null
				&& alerta.getAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGOREL = ?");
			params.add(alerta.getAlerta().getAlerta().getAlcodigo());
		}
		if (alerta != null
				&& alerta.getAlerta() != null
				&& alerta.getAlerta().getNaturalezaPeligro() != null
				&& alerta.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro() != null) {
			where.append(" AND t2.ALIDNATURALEZAPELIGRO = ?");
			params.add(alerta.getAlerta().getNaturalezaPeligro()
					.getIdnaturalezapeligro());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(alerta.getAlerta().getAlcoor());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(alerta.getAlerta().getAlnran());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(alerta.getAlerta().getAlnror());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(alerta.getAlerta().getAlfeen());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(alerta.getAlerta().getAlfeplrr());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcops() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(alerta.getAlerta().getAlcops());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(alerta.getAlerta().getAlnoprse());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(alerta.getAlerta().getAlnrlops());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(alerta.getAlerta().getAlnomaps());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(alerta.getAlerta().getAlnomops());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(alerta.getAlerta().getAlfedumi());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcoca() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(alerta.getAlerta().getAlcoca());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcopa() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(alerta.getAlerta().getAlcopa());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcotop() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(alerta.getAlerta().getAlcotop());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(alerta.getAlerta().getAltein());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcoes() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(alerta.getAlerta().getAlcoes());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(alerta.getAlerta().getAlferrin());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(alerta.getAlerta().getAlinre());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(alerta.getAlerta().getAlfecoor());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(alerta.getAlerta().getAlcotmo());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlaecosan() != null) {
			where.append(" AND t2.ALAECOSAN = ?");
			params.add(alerta.getAlerta().getAlaecosan());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlactiva() != null) {
			where.append(" AND t2.ALACTIVA = ?");
			params.add(alerta.getAlerta().getAlactiva());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlanulada() != null) {
			where.append(" AND t2.ALANULADA = ?");
			params.add(alerta.getAlerta().getAlanulada());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfechaanulacion() != null) {
			where.append(" AND t2.ALFECHAANULACION = ?");
			params.add(alerta.getAlerta().getAlfechaanulacion());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigobarras() != null) {
			where.append(" AND t2.ALCODIGOBARRAS = ?");
			params.add(alerta.getAlerta().getAlcodigobarras());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlorigenproducto() != null) {
			where.append(" AND t2.ALORIGENPRODUCTO = ?");
			params.add(alerta.getAlerta().getAlorigenproducto());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlccaaproducto() != null) {
			where.append(" AND t2.ALCCAAPRODUCTO = ?");
			params.add(alerta.getAlerta().getAlccaaproducto());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlpaisproducto() != null) {
			where.append(" AND t2.ALPAISPRODUCTO = ?");
			params.add(alerta.getAlerta().getAlpaisproducto());
		}
		if (alerta != null
				&& alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getIdnaturalezapeligro() != null) {
			where.append(" AND t3.IDNATURALEZAPELIGRO = ?");
			params.add(alerta.getNaturalezaPeligro().getIdnaturalezapeligro());
		}
		if (alerta != null && alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getNaturalezapeligro() != null) {
			where.append(" AND t3.NATURALEZAPELIGRO = ?");
			params.add(alerta.getNaturalezaPeligro().getNaturalezapeligro());
		}
		if (alerta != null
				&& alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getNaturalezapeligroe() != null) {
			where.append(" AND t3.NATURALEZAPELIGROE = ?");
			params.add(alerta.getNaturalezaPeligro().getNaturalezapeligroe());
		}
		if (alerta != null && alerta.getAlcoor() != null) {
			where.append(" AND t1.ALCOOR = ?");
			params.add(alerta.getAlcoor());
		}
		if (alerta != null && alerta.getAlnran() != null) {
			where.append(" AND t1.ALNRAN = ?");
			params.add(alerta.getAlnran());
		}
		if (alerta != null && alerta.getAlnror() != null) {
			where.append(" AND t1.ALNROR = ?");
			params.add(alerta.getAlnror());
		}
		if (alerta != null && alerta.getAlfeen() != null) {
			where.append(" AND t1.ALFEEN = ?");
			params.add(alerta.getAlfeen());
		}
		if (alerta != null && alerta.getAlfeplrr() != null) {
			where.append(" AND t1.ALFEPLRR = ?");
			params.add(alerta.getAlfeplrr());
		}
		if (alerta != null && alerta.getAlcops() != null) {
			where.append(" AND t1.ALCOPS = ?");
			params.add(alerta.getAlcops());
		}
		if (alerta != null && alerta.getAlnoprse() != null) {
			where.append(" AND t1.ALNOPRSE = ?");
			params.add(alerta.getAlnoprse());
		}
		if (alerta != null && alerta.getAlnrlops() != null) {
			where.append(" AND t1.ALNRLOPS = ?");
			params.add(alerta.getAlnrlops());
		}
		if (alerta != null && alerta.getAlnomaps() != null) {
			where.append(" AND t1.ALNOMAPS = ?");
			params.add(alerta.getAlnomaps());
		}
		if (alerta != null && alerta.getAlnomops() != null) {
			where.append(" AND t1.ALNOMOPS = ?");
			params.add(alerta.getAlnomops());
		}
		if (alerta != null && alerta.getAlfedumi() != null) {
			where.append(" AND t1.ALFEDUMI = ?");
			params.add(alerta.getAlfedumi());
		}
		if (alerta != null && alerta.getAlcoca() != null) {
			where.append(" AND t1.ALCOCA = ?");
			params.add(alerta.getAlcoca());
		}
		if (alerta != null && alerta.getAlcopa() != null) {
			where.append(" AND t1.ALCOPA = ?");
			params.add(alerta.getAlcopa());
		}
		if (alerta != null && alerta.getAlcotop() != null) {
			where.append(" AND t1.ALCOTOP = ?");
			params.add(alerta.getAlcotop());
		}
		if (alerta != null && alerta.getAltein() != null) {
			where.append(" AND t1.ALTEIN = ?");
			params.add(alerta.getAltein());
		}
		if (alerta != null && alerta.getAlcoes() != null) {
			where.append(" AND t1.ALCOES = ?");
			params.add(alerta.getAlcoes());
		}
		if (alerta != null && alerta.getAlferrin() != null) {
			where.append(" AND t1.ALFERRIN = ?");
			params.add(alerta.getAlferrin());
		}
		if (alerta != null && alerta.getAlinre() != null) {
			where.append(" AND t1.ALINRE = ?");
			params.add(alerta.getAlinre());
		}
		if (alerta != null && alerta.getAlfecoor() != null) {
			where.append(" AND t1.ALFECOOR = ?");
			params.add(alerta.getAlfecoor());
		}
		if (alerta != null && alerta.getAlcotmo() != null) {
			where.append(" AND t1.ALCOTMO = ?");
			params.add(alerta.getAlcotmo());
		}
		if (alerta != null && alerta.getAlaecosan() != null) {
			where.append(" AND t1.ALAECOSAN = ?");
			params.add(alerta.getAlaecosan());
		}
		if (alerta != null && alerta.getAlactiva() != null) {
			where.append(" AND t1.ALACTIVA = ?");
			params.add(alerta.getAlactiva());
		}
		if (alerta != null && alerta.getAlanulada() != null) {
			where.append(" AND t1.ALANULADA = ?");
			params.add(alerta.getAlanulada());
		}
		if (alerta != null && alerta.getAlfechaanulacion() != null) {
			where.append(" AND t1.ALFECHAANULACION = ?");
			params.add(alerta.getAlfechaanulacion());
		}
		if (alerta != null && alerta.getAlcodigobarras() != null) {
			where.append(" AND t1.ALCODIGOBARRAS = ?");
			params.add(alerta.getAlcodigobarras());
		}
		if (alerta != null && alerta.getAlorigenproducto() != null) {
			where.append(" AND t1.ALORIGENPRODUCTO = ?");
			params.add(alerta.getAlorigenproducto());
		}
		if (alerta != null && alerta.getAlccaaproducto() != null) {
			where.append(" AND t1.ALCCAAPRODUCTO = ?");
			params.add(alerta.getAlccaaproducto());
		}
		if (alerta != null && alerta.getAlpaisproducto() != null) {
			where.append(" AND t1.ALPAISPRODUCTO = ?");
			params.add(alerta.getAlpaisproducto());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Alerta entity
	 * 
	 * @param alerta
	 *            Alerta Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Alerta alerta, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AlertaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (alerta != null && alerta.getAlcodigo() != null) {
			where.append(" AND UPPER(t1.ALCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCODIGO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(alerta.getAlerta().getAlcodigo());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlerta() != null
				&& alerta.getAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND UPPER(t2.ALCODIGOREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlerta().getAlcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlerta().getAlcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCODIGOREL IS NOT NULL");
		}
		if (alerta != null
				&& alerta.getAlerta() != null
				&& alerta.getAlerta().getNaturalezaPeligro() != null
				&& alerta.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro() != null) {
			where.append(" AND UPPER(t2.ALIDNATURALEZAPELIGRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getNaturalezaPeligro()
						.getIdnaturalezapeligro().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getNaturalezaPeligro()
								.getIdnaturalezapeligro().toUpperCase() + "%");
			}
			where.append(" AND t2.ALIDNATURALEZAPELIGRO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcoor() != null) {
			where.append(" AND UPPER(t2.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcoor().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOOR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnran() != null) {
			where.append(" AND UPPER(t2.ALNRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlnran().toString()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlnran().toString()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNRAN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnror() != null) {
			where.append(" AND UPPER(t2.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlnror().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNROR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(alerta.getAlerta().getAlfeen());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(alerta.getAlerta().getAlfeplrr());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcops() != null) {
			where.append(" AND UPPER(t2.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND UPPER(t2.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlnoprse().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOPRSE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND UPPER(t2.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNRLOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND UPPER(t2.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOMAPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlnomops() != null) {
			where.append(" AND UPPER(t2.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlnomops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOMOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(alerta.getAlerta().getAlfedumi());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcoca() != null) {
			where.append(" AND UPPER(t2.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcoca().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcoca().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOCA IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcopa() != null) {
			where.append(" AND UPPER(t2.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcopa().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcopa().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOPA IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcotop() != null) {
			where.append(" AND UPPER(t2.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcotop().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcotop().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOTOP IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAltein() != null) {
			where.append(" AND UPPER(t2.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAltein().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAltein().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALTEIN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcoes() != null) {
			where.append(" AND UPPER(t2.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcoes().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcoes().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOES IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(alerta.getAlerta().getAlferrin());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlinre() != null) {
			where.append(" AND UPPER(t2.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlinre().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALINRE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(alerta.getAlerta().getAlfecoor());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND UPPER(t2.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOTMO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlaecosan() != null) {
			where.append(" AND UPPER(t2.ALAECOSAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlaecosan().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlaecosan().toUpperCase() + "%");
			}
			where.append(" AND t2.ALAECOSAN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlactiva() != null) {
			where.append(" AND UPPER(t2.ALACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlactiva().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlerta().getAlactiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALACTIVA IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlanulada() != null) {
			where.append(" AND UPPER(t2.ALANULADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlanulada().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlanulada().toUpperCase() + "%");
			}
			where.append(" AND t2.ALANULADA IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlfechaanulacion() != null) {
			where.append(" AND t2.ALFECHAANULACION = ?");
			params.add(alerta.getAlerta().getAlfechaanulacion());
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlcodigobarras() != null) {
			where.append(" AND UPPER(t2.ALCODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlcodigobarras().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlcodigobarras().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCODIGOBARRAS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlorigenproducto() != null) {
			where.append(" AND UPPER(t2.ALORIGENPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlorigenproducto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlorigenproducto()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALORIGENPRODUCTO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlccaaproducto() != null) {
			where.append(" AND UPPER(t2.ALCCAAPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlccaaproducto().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlccaaproducto().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCCAAPRODUCTO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlerta() != null
				&& alerta.getAlerta().getAlpaisproducto() != null) {
			where.append(" AND UPPER(t2.ALPAISPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlerta().getAlpaisproducto().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getAlerta().getAlpaisproducto().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALPAISPRODUCTO IS NOT NULL");
		}
		if (alerta != null
				&& alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getIdnaturalezapeligro() != null) {
			where.append(" AND t3.IDNATURALEZAPELIGRO = ?");
			params.add(alerta.getNaturalezaPeligro().getIdnaturalezapeligro());
		}
		if (alerta != null && alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getNaturalezapeligro() != null) {
			where.append(" AND UPPER(t3.NATURALEZAPELIGRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getNaturalezaPeligro().getNaturalezapeligro()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getNaturalezaPeligro().getNaturalezapeligro()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NATURALEZAPELIGRO IS NOT NULL");
		}
		if (alerta != null
				&& alerta.getNaturalezaPeligro() != null
				&& alerta.getNaturalezaPeligro().getNaturalezapeligroe() != null) {
			where.append(" AND UPPER(t3.NATURALEZAPELIGROE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getNaturalezaPeligro()
						.getNaturalezapeligroe().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getNaturalezaPeligro().getNaturalezapeligroe()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.NATURALEZAPELIGROE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlcoor() != null) {
			where.append(" AND UPPER(t1.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcoor().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOOR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnran() != null) {
			where.append(" AND UPPER(t1.ALNRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnran().toString().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnran().toString().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ALNRAN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnror() != null) {
			where.append(" AND UPPER(t1.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnror().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnror().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNROR IS NOT NULL");
		}

		if (alerta != null && alerta.getAlfeenDesde() != null) {
			where.append(" AND t1.ALFEEN >= ?");
			params.add(alerta.getAlfeenDesde());
		}
		if (alerta != null && alerta.getAlfeenHasta() != null) {
			where.append(" AND t1.ALFEEN <= ?");
			params.add(alerta.getAlfeenHasta());
		}
		if (alerta != null && alerta.getAlfeComunicacionDesde() != null) {
			where.append(" AND (SELECT COUNT(1) FROM ALERTA_PROGRAMACION t11 WHERE 1=1 AND t11.CRCOAL=t1.ALCODIGO AND t11.CRFECHACOMUNICACION>=?)>0 ");
			params.add(alerta.getAlfeComunicacionDesde());
		}
		if (alerta != null && alerta.getAlfeComunicacionHasta() != null) {
			where.append(" AND (SELECT COUNT(1) FROM ALERTA_PROGRAMACION t11 WHERE 1=1 AND t11.CRCOAL=t1.ALCODIGO AND t11.CRFECHACOMUNICACION<=?)>0 ");
			params.add(alerta.getAlfeComunicacionHasta());
		}

		if (alerta != null && alerta.getAlfePlazoDesde() != null) {
			where.append(" AND (SELECT COUNT(1) FROM ALERTA_PROGRAMACION t11 WHERE 1=1 AND t11.CRCOAL=t1.ALCODIGO AND t11.CRFECHAPLAZO>=?)>0 ");
			params.add(alerta.getAlfePlazoDesde());
		}
		if (alerta != null && alerta.getAlfePlazoHasta() != null) {
			where.append(" AND (SELECT COUNT(1) FROM ALERTA_PROGRAMACION t11 WHERE 1=1 AND t11.CRCOAL=t1.ALCODIGO AND t11.CRFECHAPLAZO<=?)>0 ");
			params.add(alerta.getAlfePlazoHasta());
		}

		if (alerta != null && alerta.getAlcops() != null) {
			where.append(" AND UPPER(t1.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcops().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnoprse() != null) {
			where.append(" AND UPPER(t1.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnoprse().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnoprse().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNOPRSE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnrlops() != null) {
			where.append(" AND UPPER(t1.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnrlops().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNRLOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnomaps() != null) {
			where.append(" AND UPPER(t1.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnomaps().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNOMAPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnomops() != null) {
			where.append(" AND UPPER(t1.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnomops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnomops().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNOMOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlfedumi() != null) {
			where.append(" AND t1.ALFEDUMI = ?");
			params.add(alerta.getAlfedumi());
		}
		if (alerta != null && alerta.getAlcoca() != null) {
			where.append(" AND UPPER(t1.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcoca().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcoca().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOCA IS NOT NULL");
		}
		if (alerta != null && alerta.getAlcopa() != null) {
			where.append(" AND UPPER(t1.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcopa().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcopa().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOPA IS NOT NULL");
		}
		if (alerta != null && alerta.getAlcotop() != null) {
			where.append(" AND UPPER(t1.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcotop().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcotop().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOTOP IS NOT NULL");
		}
		if (alerta != null && alerta.getAltein() != null) {
			where.append(" AND UPPER(t1.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAltein().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAltein().toUpperCase() + "%");
			}
			where.append(" AND t1.ALTEIN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlcoes() != null) {
			where.append(" AND UPPER(t1.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcoes().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcoes().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOES IS NOT NULL");
		}
		if (alerta != null && alerta.getAlferrin() != null) {
			where.append(" AND t1.ALFERRIN = ?");
			params.add(alerta.getAlferrin());
		}
		if (alerta != null && alerta.getAlinre() != null) {
			where.append(" AND UPPER(t1.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlinre().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlinre().toUpperCase() + "%");
			}
			where.append(" AND t1.ALINRE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlfecoor() != null) {
			where.append(" AND t1.ALFECOOR = ?");
			params.add(alerta.getAlfecoor());
		}
		if (alerta != null && alerta.getAlcotmo() != null) {
			where.append(" AND UPPER(t1.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcotmo().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOTMO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlaecosan() != null) {
			where.append(" AND UPPER(t1.ALAECOSAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlaecosan().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlaecosan().toUpperCase() + "%");
			}
			where.append(" AND t1.ALAECOSAN IS NOT NULL");
		}

		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND (SELECT COUNT(1) FROM DISTRIBUIDOR t11 WHERE 1=1 AND t11.RDCOAL=t1.ALCODIGO AND t11.RDCOES=?)>0 ");
			params.add(alerta.getEstablecimiento().getEscodigo());
		}

		if (alerta != null
				&& (alerta.getAlactiva() == null || alerta.getAlactiva()
						.equals(Y41bConstantes.VALOR_NO))) {
			where.append(" AND t1.ALACTIVA = ? ");
			params.add(Y41bConstantes.VALOR_SI);
		}

		if (alerta != null
				&& (alerta.getAlanulada() == null || alerta.getAlanulada()
						.equals(Y41bConstantes.VALOR_NO))) {
			where.append(" AND (t1.ALANULADA != ? OR t1.ALANULADA IS NULL) ");
			params.add(Y41bConstantes.VALOR_SI);
		}
		if (alerta != null && alerta.getAlfechaanulacion() != null) {
			where.append(" AND t1.ALFECHAANULACION = ?");
			params.add(alerta.getAlfechaanulacion());
		}
		if (alerta != null && alerta.getAlcodigobarras() != null) {
			where.append(" AND UPPER(t1.ALCODIGOBARRAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcodigobarras().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcodigobarras().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCODIGOBARRAS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlorigenproducto() != null) {
			where.append(" AND UPPER(t1.ALORIGENPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlorigenproducto().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlorigenproducto().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ALORIGENPRODUCTO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlccaaproducto() != null) {
			where.append(" AND UPPER(t1.ALCCAAPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlccaaproducto().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlccaaproducto().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCCAAPRODUCTO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlpaisproducto() != null) {
			where.append(" AND UPPER(t1.ALPAISPRODUCTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlpaisproducto().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlpaisproducto().toUpperCase() + "%");
			}
			where.append(" AND t1.ALPAISPRODUCTO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaDetalle> findAllAlertaEstablecimiento(Alerta alerta,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41bConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT t1.ALCODIGO ALCODIGO "
				+ "FROM ALERTA t1 ");

		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t1.ALCOES = ?");
			params.add(alerta.getEstablecimiento().getEscodigo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(Y41bConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<AlertaDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<AlertaDetalle>() {
					public AlertaDetalle mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new AlertaDetalle(resultSet
								.getString("ALCODIGO"), null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alertaDetalle
	 *            AlertaDetalle
	 * @return Alerta
	 */
	public AlertaDetalle updateEstablecimiento(AlertaDetalle alertaDetalle) {
		String query = "UPDATE ALERTA SET ALCOES=? WHERE ALCODIGO=?";

		this.jdbcTemplate.update(query, alertaDetalle.getEscodigo(),
				alertaDetalle.getAlcodigo());
		return alertaDetalle;
	}
}
