package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.AlertaDetalle;

/**
 * AlertaDao  
 * 
 *  
 */

public interface AlertaDao {

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta add(Alerta alerta);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta update(Alerta alerta);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	public Alerta updateAlertaRelacionada(Alerta alerta);

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta find(Alerta alerta);

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	void remove(Alerta alerta);

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Alerta> findAll(Alerta alerta, Pagination pagination);

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	Long findAllCount(Alerta alerta);

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Alerta alerta, Boolean startsWith);

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<AlertaDetalle> findAllAlertaEstablecimiento(Alerta alerta,
			Pagination pagination);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alertaDetalle
	 *            AlertaDetalle
	 * @return Alerta
	 */
	public AlertaDetalle updateEstablecimiento(AlertaDetalle alertaDetalle);
}
