package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntartipPregProtoc;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;

/**
 * AdjuntartipPregProtocDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntartipPregProtocDaoImpl implements AdjuntartipPregProtocDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntartipPregProtoc> rwMap = new RowMapper<AdjuntartipPregProtoc>() {
		public AdjuntartipPregProtoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new AdjuntartipPregProtoc(resultSet.getString("TRCODIGO"), resultSet.getString("TRCOTP"),
					resultSet.getLong("TRNRTIPP"), resultSet.getString("TRCOTIPP"), resultSet.getString("TRDETIPP"),
					resultSet.getString("TRCOTTI"), resultSet.getString("TRINTI"), resultSet.getString("TRINRE"),
					resultSet.getString("TRREES"), resultSet.getString("TREXCLUIROBI"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            Pagination
	 * @return AdjuntartipPregProtoc
	 */
	public AdjuntartipPregProtoc add(AdjuntartipPregProtoc adjuntartippregprotoc) {
		String query = "INSERT INTO ADJUNTARTIP_PREG_PROTOC (TRCODIGO, TRCOTP, TRNRTIPP, TRCOTIPP, TRDETIPP, TRCOTTI, TRINTI, TRINRE, TRREES, TREXCLUIROBI) VALUES (?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjuntartippregprotoc.getTrcodigo(), adjuntartippregprotoc.getTrcotp(),
				adjuntartippregprotoc.getTrnrtipp(), adjuntartippregprotoc.getTrcotipp(),
				adjuntartippregprotoc.getTrdetipp(), adjuntartippregprotoc.getTrcotti(),
				adjuntartippregprotoc.getTrinti(), adjuntartippregprotoc.getTrinre(), adjuntartippregprotoc.getTrrees(),
				adjuntartippregprotoc.getTrexcluirobi());
		return adjuntartippregprotoc;
	}

	/**
	 * Updates a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            Pagination
	 * @return AdjuntartipPregProtoc
	 */
	public AdjuntartipPregProtoc update(AdjuntartipPregProtoc adjuntartippregprotoc) {
		String query = "UPDATE ADJUNTARTIP_PREG_PROTOC SET TRCOTP=?, TRNRTIPP=?, TRCOTIPP=?, TRDETIPP=?, TRCOTTI=?, TRINTI=?, TRINRE=?, TRREES=?, TREXCLUIROBI=? WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, adjuntartippregprotoc.getTrcotp(), adjuntartippregprotoc.getTrnrtipp(),
				adjuntartippregprotoc.getTrcotipp(), adjuntartippregprotoc.getTrdetipp(),
				adjuntartippregprotoc.getTrcotti(), adjuntartippregprotoc.getTrinti(),
				adjuntartippregprotoc.getTrinre(), adjuntartippregprotoc.getTrrees(),
				adjuntartippregprotoc.getTrexcluirobi(), adjuntartippregprotoc.getTrcodigo());
		return adjuntartippregprotoc;
	}

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            Pagination
	 * @return AdjuntartipPregProtoc
	 */
	@Transactional(readOnly = true)
	public AdjuntartipPregProtoc find(AdjuntartipPregProtoc adjuntartippregprotoc) {
		String query = "SELECT t1.TRCODIGO TRCODIGO, t1.TRCOTP TRCOTP, t1.TRNRTIPP TRNRTIPP, t1.TRCOTIPP TRCOTIPP, t1.TRDETIPP TRDETIPP, t1.TRCOTTI TRCOTTI, t1.TRINTI TRINTI, t1.TRINRE TRINRE, t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI FROM ADJUNTARTIP_PREG_PROTOC t1  WHERE t1.TRCODIGO = ?  ";

		List<AdjuntartipPregProtoc> adjuntartippregprotocList = this.jdbcTemplate.query(query, this.rwMap,
				adjuntartippregprotoc.getTrcodigo());
		return (AdjuntartipPregProtoc) DataAccessUtils.uniqueResult(adjuntartippregprotocList);
	}

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            Pagination
	 * @return String
	 */
	@Transactional(readOnly = true)
	public String findNumOrden(AdjuntartipPregProtoc adjuntartippregprotoc) {
		String query = "SELECT NVL(MAX(ABS(t1.TRNRTIPP)),0)+1 TRNRTIPP FROM ADJUNTARTIP_PREG_PROTOC t1  WHERE t1.TRCOTP = ?  ";

		return this.jdbcTemplate.queryForObject(query, String.class,
				new Object[] { adjuntartippregprotoc.getTrcotp() });
	}

	/**
	 * Removes a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntartipPregProtoc adjuntartippregprotoc) {
		String query = "DELETE FROM ADJUNTARTIP_PREG_PROTOC WHERE TRCODIGO=?";
		this.jdbcTemplate.update(query, adjuntartippregprotoc.getTrcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntartipPregProtoc> findAll(AdjuntartipPregProtoc adjuntartippregprotoc, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRCOTP TRCOTP,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRCOTTI TRCOTTI,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI ");
		query.append("FROM ADJUNTARTIP_PREG_PROTOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntartippregprotoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntartipPregProtoc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntartipPregProtoc adjuntartippregprotoc) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ADJUNTARTIP_PREG_PROTOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntartippregprotoc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAllProtocoloOrdenado(TipPregProtoc tippregprotoc) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.TPCOCM TIPPROTOCOLOTPCOCM "
						+ "FROM ADJUNTARTIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ,TIP_REQ_NORMATIVO t3 ");

		if (tippregprotoc != null && tippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(tippregprotoc.getTrcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t1.TRCOTP = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getCampanha() != null
				&& tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(tippregprotoc.getTipProtocolo().getCampanha().getCmcodigo());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpnombre());
		}
		if (tippregprotoc != null && tippregprotoc.getTipProtocolo() != null
				&& tippregprotoc.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(tippregprotoc.getTipProtocolo().getTpcotmo());
		}
		if (tippregprotoc != null && tippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(tippregprotoc.getTrnrtipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null
				&& tippregprotoc.getTrcotipp().equalsIgnoreCase("S")) {
			where.append(" AND t1.TRCOTIPP is not null");
		} else if (tippregprotoc != null && tippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(tippregprotoc.getTrcotipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(tippregprotoc.getTrdetipp());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(tippregprotoc.getTrinti());
		}
		if (tippregprotoc != null && tippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(tippregprotoc.getTrinre());
		}
		if (tippregprotoc != null && tippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(tippregprotoc.getTrrees());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY TRNRTIPP");
		query.append(order);

		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(), new RowMapper<TipPregProtoc>() {
			public TipPregProtoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TipPregProtoc(resultSet.getString("TRCODIGO"), resultSet.getLong("TRNRTIPP"),
						resultSet.getString("TRCOTIPP"), resultSet.getString("TRDETIPP"),
						resultSet.getString("TIPREQNORMATIVOTTICODIGO"), resultSet.getString("TRINTI"),
						resultSet.getString("TRINRE"), resultSet.getString("TRREES"),
						resultSet.getString("TREXCLUIROBI"),
						new TipProtocolo(resultSet.getString("TipProtocoloTPCODIGO"),
								resultSet.getString("TipProtocoloTPNOMBRE"), resultSet.getString("TipProtocoloTPCOTMO"),
								null, new Campanha(resultSet.getString("TipProtocoloTPCOCM"), null, null, null, null,
										null, null, null, null, null, null, null, null, null, null, null, null)));
			}
		}, params.toArray());
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<TipPregProtoc> findAllProtocoloOrdenadoInspeccion(TipPregProtoc tippregprotoc) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.TRCOTP= t2.TPCODIGO(+) AND t1.TRCOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.TPCOCM TIPPROTOCOLOTPCOCM "
						+ "FROM TIP_PREG_PROTOC t1 ,TIP_PROTOCOLO t2 ,TIP_REQ_NORMATIVO t3 ");

		where.append(" AND t1.TRCOTP = ?");
		params.add(tippregprotoc.getTipProtocolo().getTpcodigo());

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		order.append(" ORDER BY TRNRTIPP");
		query.append(order);

		return (List<TipPregProtoc>) this.jdbcTemplate.query(query.toString(), new RowMapper<TipPregProtoc>() {
			public TipPregProtoc mapRow(ResultSet resultSet, int rowNum) throws SQLException {
				return new TipPregProtoc(resultSet.getString("TRCODIGO"), resultSet.getLong("TRNRTIPP"),
						resultSet.getString("TRCOTIPP"), resultSet.getString("TRDETIPP"),
						resultSet.getString("TIPREQNORMATIVOTTICODIGO"), resultSet.getString("TRINTI"),
						resultSet.getString("TRINRE"), resultSet.getString("TRREES"),
						resultSet.getString("TREXCLUIROBI"),
						new TipProtocolo(resultSet.getString("TipProtocoloTPCODIGO"),
								resultSet.getString("TipProtocoloTPNOMBRE"), resultSet.getString("TipProtocoloTPCOTMO"),
								null, new Campanha(resultSet.getString("TipProtocoloTPCOCM"), null, null, null, null,
										null, null, null, null, null, null, null, null, null, null, null, null)));
			}
		}, params.toArray());
	}

	/**
	 * Finds rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntartipPregProtoc> findAllLike(AdjuntartipPregProtoc adjuntartippregprotoc, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TRCODIGO TRCODIGO,t1.TRCOTP TRCOTP,t1.TRNRTIPP TRNRTIPP,t1.TRCOTIPP TRCOTIPP,t1.TRDETIPP TRDETIPP,t1.TRCOTTI TRCOTTI,t1.TRINTI TRINTI,t1.TRINRE TRINRE,t1.TRREES TRREES, t1.TREXCLUIROBI TREXCLUIROBI ");
		query.append("FROM ADJUNTARTIP_PREG_PROTOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntartippregprotoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntartipPregProtoc>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjuntartipPregProtoc adjuntartippregprotoc, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM ADJUNTARTIP_PREG_PROTOC t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntartippregprotoc, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntartipPregProtoc entity
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdjuntartipPregProtoc adjuntartippregprotoc) {

		StringBuilder where = new StringBuilder(AdjuntartipPregProtocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcodigo() != null) {
			where.append(" AND t1.TRCODIGO = ?");
			params.add(adjuntartippregprotoc.getTrcodigo());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcotp() != null) {
			where.append(" AND t1.TRCOTP = ?");
			params.add(adjuntartippregprotoc.getTrcotp());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(adjuntartippregprotoc.getTrnrtipp());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcotipp() != null) {
			where.append(" AND t1.TRCOTIPP = ?");
			params.add(adjuntartippregprotoc.getTrcotipp());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrdetipp() != null) {
			where.append(" AND t1.TRDETIPP = ?");
			params.add(adjuntartippregprotoc.getTrdetipp());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcotti() != null) {
			where.append(" AND t1.TRCOTTI = ?");
			params.add(adjuntartippregprotoc.getTrcotti());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrinti() != null) {
			where.append(" AND t1.TRINTI = ?");
			params.add(adjuntartippregprotoc.getTrinti());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrinre() != null) {
			where.append(" AND t1.TRINRE = ?");
			params.add(adjuntartippregprotoc.getTrinre());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrrees() != null) {
			where.append(" AND t1.TRREES = ?");
			params.add(adjuntartippregprotoc.getTrrees());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntartipPregProtoc entity
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(AdjuntartipPregProtoc adjuntartippregprotoc, Boolean startsWith) {

		StringBuilder where = new StringBuilder(AdjuntartipPregProtocDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcodigo() != null) {
			where.append(" AND UPPER(t1.TRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGO IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcotp() != null) {
			where.append(" AND UPPER(t1.TRCOTP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrcotp().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrcotp().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCOTP IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrnrtipp() != null) {
			where.append(" AND t1.TRNRTIPP = ?");
			params.add(adjuntartippregprotoc.getTrnrtipp());
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcotipp() != null) {
			where.append(" AND UPPER(t1.TRCOTIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrcotipp().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrcotipp().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCOTIPP IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrdetipp() != null) {
			where.append(" AND UPPER(t1.TRDETIPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrdetipp().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrdetipp().toUpperCase() + "%");
			}
			where.append(" AND t1.TRDETIPP IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrcotti() != null) {
			where.append(" AND UPPER(t1.TRCOTTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrcotti().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrcotti().toUpperCase() + "%");
			}
			where.append(" AND t1.TRCOTTI IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrinti() != null) {
			where.append(" AND UPPER(t1.TRINTI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrinti().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrinti().toUpperCase() + "%");
			}
			where.append(" AND t1.TRINTI IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrinre() != null) {
			where.append(" AND UPPER(t1.TRINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrinre().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrinre().toUpperCase() + "%");
			}
			where.append(" AND t1.TRINRE IS NOT NULL");
		}
		if (adjuntartippregprotoc != null && adjuntartippregprotoc.getTrrees() != null) {
			where.append(" AND UPPER(t1.TRREES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntartippregprotoc.getTrrees().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntartippregprotoc.getTrrees().toUpperCase() + "%");
			}
			where.append(" AND t1.TRREES IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return
	 */
	public void removeAllTipPregProtoc(TipProtocolo tipProtocolo) {
		String query = "DELETE FROM ADJUNTARTIP_PREG_PROTOC WHERE TRCOTP = ?";
		this.jdbcTemplate.update(query, tipProtocolo.getTpcodigo());
	}

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	public void addTipPregProtoc(TipProtocolo tipProtocolo) {

		String query = "INSERT INTO ADJUNTARTIP_PREG_PROTOC (TRCODIGO, TRCOTP, TRNRTIPP, TRCOTIPP, TRDETIPP, TRCOTTI, TRINTI, TRINRE, TRREES, TREXCLUIROBI) SELECT TRCODIGO, TRCOTP, TRNRTIPP, TRCOTIPP, TRDETIPP, TRCOTTI, TRINTI, TRINRE, TRREES, TREXCLUIROBI FROM TIP_PREG_PROTOC t1 WHERE TRCOTP = ?";
		this.jdbcTemplate.update(query, tipProtocolo.getTpcodigo());
	}
}
