package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntartipPregProtoc;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;

/**
 * AdjuntartipPregProtocDao  
 * 
 *  
 */

public interface AdjuntartipPregProtocDao {

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	AdjuntartipPregProtoc add(AdjuntartipPregProtoc adjuntartippregprotoc);

	/**
	 * Updates a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	AdjuntartipPregProtoc update(AdjuntartipPregProtoc adjuntartippregprotoc);

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @return AdjuntartipPregProtoc
	 */
	AdjuntartipPregProtoc find(AdjuntartipPregProtoc adjuntartippregprotoc);

	/**
	 * Finds a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            Pagination
	 * @return String
	 */
	public String findNumOrden(AdjuntartipPregProtoc adjuntartippregprotoc);

	/**
	 * Deletes a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @return
	 */
	void remove(AdjuntartipPregProtoc adjuntartippregprotoc);

	/**
	 * Finds a List of rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntartipPregProtoc> findAll(AdjuntartipPregProtoc adjuntartippregprotoc, Pagination pagination);

	/**
	 * Counts rows in the AdjuntartipPregProtoc table.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @return Long
	 */
	Long findAllCount(AdjuntartipPregProtoc adjuntartippregprotoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(TipPregProtoc tippregprotoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tippregprotoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenadoInspeccion(TipPregProtoc tippregprotoc);

	/**
	 * Finds rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntartipPregProtoc> findAllLike(AdjuntartipPregProtoc adjuntartippregprotoc, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntartipPregProtoc table using like.
	 * 
	 * @param adjuntartippregprotoc
	 *            AdjuntartipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntartipPregProtoc adjuntartippregprotoc, Boolean startsWith);

	/**
	 * Removes a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return
	 */
	public void removeAllTipPregProtoc(TipProtocolo tipProtocolo);

	/**
	 * Inserts a single row in the AdjuntartipPregProtoc table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	public void addTipPregProtoc(TipProtocolo tipProtocolo);
}
