package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntarprodagrupado;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.ProdAgrupado;

/**
 * AdjuntarprodagrupadoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarprodagrupadoDaoImpl implements AdjuntarprodagrupadoDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Adjuntarprodagrupado> rwMap = new RowMapper<Adjuntarprodagrupado>() {
		public Adjuntarprodagrupado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Adjuntarprodagrupado(resultSet.getString("E8CODIGO"),
					resultSet.getString("TIRCODIGO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Pagination
	 * @return Adjuntarprodagrupado
	 */
	public Adjuntarprodagrupado add(Adjuntarprodagrupado adjuntarprodagrupado) {
		String query = "INSERT INTO ADJUNTARPRODAGRUPADO (E8CODIGO, TIRCODIGO) VALUES (?,?)";
		this.jdbcTemplate.update(query, adjuntarprodagrupado.getE8codigo(),
				adjuntarprodagrupado.getTircodigo());
		return adjuntarprodagrupado;
	}

	/**
	 * Updates a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Pagination
	 * @return Adjuntarprodagrupado
	 */
	public Adjuntarprodagrupado update(Adjuntarprodagrupado adjuntarprodagrupado) {
		String query = "UPDATE ADJUNTARPRODAGRUPADO SET  WHERE E8CODIGO=? AND TIRCODIGO=?";
		this.jdbcTemplate.update(query, adjuntarprodagrupado.getE8codigo(),
				adjuntarprodagrupado.getTircodigo());
		return adjuntarprodagrupado;
	}

	/**
	 * Finds a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Pagination
	 * @return Adjuntarprodagrupado
	 */
	@Transactional(readOnly = true)
	public Adjuntarprodagrupado find(Adjuntarprodagrupado adjuntarprodagrupado) {
		String query = "SELECT t1.E8CODIGO E8CODIGO, t1.TIRCODIGO TIRCODIGO FROM ADJUNTARPRODAGRUPADO t1  WHERE t1.E8CODIGO = ?   AND t1.TIRCODIGO = ?  ";

		List<Adjuntarprodagrupado> adjuntarprodagrupadoList = this.jdbcTemplate
				.query(query, this.rwMap, adjuntarprodagrupado.getE8codigo(),
						adjuntarprodagrupado.getTircodigo());
		return (Adjuntarprodagrupado) DataAccessUtils
				.uniqueResult(adjuntarprodagrupadoList);
	}

	/**
	 * Removes a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Pagination
	 * @return
	 */
	public void remove(Adjuntarprodagrupado adjuntarprodagrupado) {
		String query = "DELETE FROM ADJUNTARPRODAGRUPADO WHERE E8CODIGO=? AND TIRCODIGO=?";
		this.jdbcTemplate.update(query, adjuntarprodagrupado.getE8codigo(),
				adjuntarprodagrupado.getTircodigo());
	}

	/**
	 * Finds a List of rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntarprodagrupado> findAll(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.E8CODIGO E8CODIGO,t1.TIRCODIGO TIRCODIGO ");
		query.append("FROM ADJUNTARPRODAGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarprodagrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Adjuntarprodagrupado>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Adjuntarprodagrupado adjuntarprodagrupado) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTARPRODAGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarprodagrupado);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ProdAgrupado> findAllProdAgrupados(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t2.E8CODIGO E8CODIGO,t2.E8NOMBRE E8NOMBRE,t2.E8NOMBREE E8NOMBREE ");
		query.append("FROM ADJUNTARPRODAGRUPADO t1, PROD_AGRUPADO t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.E8CODIGO = t2.E8CODIGO ");

		List<Object> params = new ArrayList<Object>();

		if (adjuntarprodagrupado != null
				&& adjuntarprodagrupado.getTircodigo() != null) {
			where.append(" AND t1.TIRCODIGO = ? ");
			params.add(adjuntarprodagrupado.getTircodigo());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<ProdAgrupado>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<ProdAgrupado>() {
					public ProdAgrupado mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new ProdAgrupado(
								resultSet.getString("E8CODIGO"), resultSet
										.getString("E8NOMBRE"), resultSet
										.getString("E8NOMBREE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Adjuntarprodagrupado table.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllProdAgrupadosCount(
			Adjuntarprodagrupado adjuntarprodagrupado) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTARPRODAGRUPADO t1, PROD_AGRUPADO t2 ");

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.E8CODIGO = t2.E8CODIGO ");

		List<Object> params = new ArrayList<Object>();

		if (adjuntarprodagrupado != null
				&& adjuntarprodagrupado.getTircodigo() != null) {
			where.append(" AND t1.TIRCODIGO = ? ");
			params.add(adjuntarprodagrupado.getTircodigo());
		}
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Adjuntarprodagrupado table using like.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntarprodagrupado> findAllLike(
			Adjuntarprodagrupado adjuntarprodagrupado, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.E8CODIGO E8CODIGO,t1.TIRCODIGO TIRCODIGO ");
		query.append("FROM ADJUNTARPRODAGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntarprodagrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Adjuntarprodagrupado>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Adjuntarprodagrupado table using like.
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Adjuntarprodagrupado adjuntarprodagrupado,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTARPRODAGRUPADO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntarprodagrupado,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Adjuntarprodagrupado entity
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Adjuntarprodagrupado adjuntarprodagrupado) {

		StringBuilder where = new StringBuilder(
				AdjuntarprodagrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarprodagrupado != null
				&& adjuntarprodagrupado.getE8codigo() != null) {
			where.append(" AND t1.E8CODIGO = ?");
			params.add(adjuntarprodagrupado.getE8codigo());
		}
		if (adjuntarprodagrupado != null
				&& adjuntarprodagrupado.getTircodigo() != null) {
			where.append(" AND t1.TIRCODIGO = ?");
			params.add(adjuntarprodagrupado.getTircodigo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Adjuntarprodagrupado entity
	 * 
	 * @param adjuntarprodagrupado
	 *            Adjuntarprodagrupado Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			Adjuntarprodagrupado adjuntarprodagrupado, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarprodagrupadoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarprodagrupado != null
				&& adjuntarprodagrupado.getE8codigo() != null) {
			where.append(" AND UPPER(t1.E8CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarprodagrupado.getE8codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarprodagrupado.getE8codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.E8CODIGO IS NOT NULL");
		}
		if (adjuntarprodagrupado != null
				&& adjuntarprodagrupado.getTircodigo() != null) {
			where.append(" AND UPPER(t1.TIRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarprodagrupado.getTircodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarprodagrupado.getTircodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIRCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return
	 */
	public void removeAllProdAgrupados(Motivo motivo) {
		String query = "DELETE FROM ADJUNTARPRODAGRUPADO WHERE TIRCODIGO = ?";
		this.jdbcTemplate.update(query, motivo.getTircodigo());
	}

	/**
	 * Inserts a single row in the Adjuntarprodagrupado table.
	 * 
	 * @param motivo
	 *            Motivo
	 */
	public void addProdAgrupados(Motivo motivo) {

		String query = "INSERT INTO ADJUNTARPRODAGRUPADO (TIRCODIGO, E8CODIGO) SELECT t1.Q9COTIR Q9COTIR, t1.Q9COE8 Q9COE8 FROM PROD_MOTIVO t1 WHERE t1.Q9COTIR = ?";
		this.jdbcTemplate.update(query, motivo.getTircodigo());
	}
}
