package com.ejie.y41b.dao;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.OracleLobHandler;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.jdbc.Y41bJdbcUtils;

/**
 * AdjuntardocsDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntardocsDaoImpl implements AdjuntardocsDao {
	private JdbcTemplate jdbcTemplate;
	@Autowired
	private OracleLobHandler oracleLobHandler;

	private RowMapper<Adjuntardocs> rwMap = new RowMapper<Adjuntardocs>() {
		public Adjuntardocs mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Adjuntardocs(resultSet.getString("THCODOCUMENTO"), resultSet.getString("THIDEXPEDIENTE"),
					resultSet.getString("THIDTRAMITE"), resultSet.getString("THNOFILE"),
					resultSet.getBlob("THDATAFILE"), resultSet.getInt("THSIZEFILE"), resultSet.getString("THTEDESFILE"),
					resultSet.getString("THORIGEN"), resultSet.getString("THNUMREGISTROORIGEN"),
					resultSet.getDate("THFECHAREGISTROORIGEN"), resultSet.getString("THTRAMITE"),
					resultSet.getDate("THFECHA"), resultSet.getString("THINDMAIL"), resultSet.getString("THTRMAIL"),
					resultSet.getString("THCONTENTTYPEFILE"), resultSet.getString("THIDDOCUMENTUM"),
					resultSet.getDate("THFECHAAPORTACION"), resultSet.getDate("THFECHAENTRADA"),
					resultSet.getString("THNUMREGISTROENTRADA"), resultSet.getString("THESTADODOCUMENTO"),
					resultSet.getDate("THFECHASOLFIRMA"), resultSet.getDate("THFECHALIMFIRMA"),
					resultSet.getDate("THFECHAFIRMA"), resultSet.getString("THCOMOFIRMA"),
					resultSet.getString("THDESTINO"), resultSet.getTimestamp("THFECHASOLLOCALIZADOR"),
					resultSet.getString("THPTCODIGO"),
					new TipoProcedimiento(resultSet.getString("TipoProcedimientoPCODIGO"),
							resultSet.getString("TipoProcedimientoPNOMBRE"),
							resultSet.getString("TipoProcedimientoPNOMBREE"),
							resultSet.getDate("TipoProcedimientoPBAJA")),
					new Perfil(resultSet.getString("PerfilIDPERFIL"), resultSet.getString("PerfilNOMBREES"),
							resultSet.getString("PerfilNOMBREEU"), resultSet.getString("PerfilISMANTENIMIENTO")),
					new TipoDocumento(resultSet.getString("TipoDocumentoIDTIPODOC"),
							resultSet.getString("TipoDocumentoTDNOMBRE"),
							resultSet.getString("TipoDocumentoTDNOMBREE")),
					resultSet.getString("TRPCODIGO"), resultSet.getString("THIDINTERVINIENTE"),
					resultSet.getString("THHASHFILE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	public Adjuntardocs add(Adjuntardocs adjuntardocs) {
		String query = "INSERT INTO ADJUNTARDOCS (THCODOCUMENTO, THPCODIGO,TRPCODIGO, THID_PERFILFIRMA, THID_TIPODOC, THID_EXPEDIENTE, THID_TRAMITE, THNOFILE, THDATAFILE, THSIZEFILE, THTEDESFILE, THORIGEN, THTRAMITE, THFECHA, THINDMAIL, THTRMAIL, THCONTENTTYPEFILE, THIDDOCUMENTUM, THFECHAAPORTACION, THFECHAENTRADA, THNUMREGISTROENTRADA, THESTADODOCUMENTO, THFECHASOLFIRMA, THFECHALIMFIRMA, THFECHAFIRMA, THCOMOFIRMA, THDESTINO,THPTCODIGO,THNUMREGISTROORIGEN,THFECHAREGISTROORIGEN, THIDINTERVINIENTE, THHASHFILE) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Object getTipoProcedimientoPcodigoAux = null;
		if (adjuntardocs.getTipoProcedimiento() != null && adjuntardocs.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = adjuntardocs.getTipoProcedimiento().getPcodigo();
		}
		Object getPerfilIdPerfilAux = null;
		if (adjuntardocs.getPerfil() != null && adjuntardocs.getPerfil().getIdPerfil() != null) {
			getPerfilIdPerfilAux = adjuntardocs.getPerfil().getIdPerfil();
		}
		Object getTipoDocumentoIdTipodocAux = null;
		if (adjuntardocs.getTipoDocumento() != null && adjuntardocs.getTipoDocumento().getIdTipodoc() != null) {
			getTipoDocumentoIdTipodocAux = adjuntardocs.getTipoDocumento().getIdTipodoc();
		}
		if (adjuntardocs.getThdatafileinputstream() == null) {
			this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento(), getTipoProcedimientoPcodigoAux,
					adjuntardocs.getTrpcodigo(), getPerfilIdPerfilAux, getTipoDocumentoIdTipodocAux,
					adjuntardocs.getThidExpediente(), adjuntardocs.getThidTramite(), adjuntardocs.getThnofile(),
					Y41bJdbcUtils.ConvertBlobToByte(adjuntardocs.getThdatafile()), adjuntardocs.getThsizefile(),
					adjuntardocs.getThtedesfile(), adjuntardocs.getThorigen(), adjuntardocs.getThtramite(),
					adjuntardocs.getThfecha(), adjuntardocs.getThindmail(), adjuntardocs.getThtrmail(),
					adjuntardocs.getThcontenttypefile(), adjuntardocs.getThiddocumentum(),
					adjuntardocs.getThfechaaportacion(), adjuntardocs.getThfechaentrada(),
					adjuntardocs.getThnumregistroentrada(), adjuntardocs.getThestadodocumento(),
					adjuntardocs.getThfechasolfirma(), adjuntardocs.getThfechalimfirma(),
					adjuntardocs.getThfechafirma(), adjuntardocs.getThcomofirma(), adjuntardocs.getThdestino(),
					adjuntardocs.getPtcodigo(), adjuntardocs.getThnumregistroorigen(),
					adjuntardocs.getThfecharegistroorigen(), adjuntardocs.getIdInterviniente(),
					adjuntardocs.getThhashfile());
		} else {
			this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento(), getTipoProcedimientoPcodigoAux,
					adjuntardocs.getTrpcodigo(), getPerfilIdPerfilAux, getTipoDocumentoIdTipodocAux,
					adjuntardocs.getThidExpediente(), adjuntardocs.getThidTramite(), adjuntardocs.getThnofile(), null,
					adjuntardocs.getThsizefile(), adjuntardocs.getThtedesfile(), adjuntardocs.getThorigen(),
					adjuntardocs.getThtramite(), adjuntardocs.getThfecha(), adjuntardocs.getThindmail(),
					adjuntardocs.getThtrmail(), adjuntardocs.getThcontenttypefile(), adjuntardocs.getThiddocumentum(),
					adjuntardocs.getThfechaaportacion(), adjuntardocs.getThfechaentrada(),
					adjuntardocs.getThnumregistroentrada(), adjuntardocs.getThestadodocumento(),
					adjuntardocs.getThfechasolfirma(), adjuntardocs.getThfechalimfirma(),
					adjuntardocs.getThfechafirma(), adjuntardocs.getThcomofirma(), adjuntardocs.getThdestino(),
					adjuntardocs.getPtcodigo(), adjuntardocs.getThnumregistroorigen(),
					adjuntardocs.getThfecharegistroorigen(), adjuntardocs.getIdInterviniente(),
					adjuntardocs.getThhashfile());
			this.updateBlob(adjuntardocs.getThdatafileinputstream(), adjuntardocs.getThcodocumento());
		}
		return adjuntardocs;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	@Override()
	public Adjuntardocs update(Adjuntardocs adjuntardocs) {
		String query = "UPDATE ADJUNTARDOCS SET THPCODIGO=?,TRPCODIGO=?, THID_PERFILFIRMA=?, THID_TIPODOC=?, THID_EXPEDIENTE=?, THID_TRAMITE=?, THNOFILE=?, THDATAFILE=?, THSIZEFILE=?, THTEDESFILE=?, THORIGEN=?, THTRAMITE=?, THFECHA=?, THINDMAIL=?, THTRMAIL=?, THCONTENTTYPEFILE=?, THIDDOCUMENTUM=?, THFECHAAPORTACION=?, THFECHAENTRADA=?, THNUMREGISTROENTRADA=?, THESTADODOCUMENTO=?, THFECHASOLFIRMA=?, THFECHALIMFIRMA=?, THFECHAFIRMA=?, THCOMOFIRMA=?, THDESTINO=?, THHASHFILE=? WHERE THCODOCUMENTO=?";
		Object getTipoProcedimientoPcodigoAux = null;
		if (adjuntardocs.getTipoProcedimiento() != null && adjuntardocs.getTipoProcedimiento().getPcodigo() != null) {
			getTipoProcedimientoPcodigoAux = adjuntardocs.getTipoProcedimiento().getPcodigo();
		}
		Object getPerfilIdPerfilAux = null;
		if (adjuntardocs.getPerfil() != null && adjuntardocs.getPerfil().getIdPerfil() != null) {
			getPerfilIdPerfilAux = adjuntardocs.getPerfil().getIdPerfil();
		}
		Object getTipoDocumentoIdTipodocAux = null;
		if (adjuntardocs.getTipoDocumento() != null && adjuntardocs.getTipoDocumento().getIdTipodoc() != null) {
			getTipoDocumentoIdTipodocAux = adjuntardocs.getTipoDocumento().getIdTipodoc();
		}
		if (adjuntardocs.getThdatafileinputstream() == null) {
			this.jdbcTemplate.update(query, getTipoProcedimientoPcodigoAux, adjuntardocs.getTrpcodigo(),
					getPerfilIdPerfilAux, getTipoDocumentoIdTipodocAux, adjuntardocs.getThidExpediente(),
					adjuntardocs.getThidTramite(), adjuntardocs.getThnofile(),
					Y41bJdbcUtils.ConvertBlobToByte(adjuntardocs.getThdatafile()), adjuntardocs.getThsizefile(),
					adjuntardocs.getThtedesfile(), adjuntardocs.getThorigen(), adjuntardocs.getThtramite(),
					adjuntardocs.getThfecha(), adjuntardocs.getThindmail(), adjuntardocs.getThtrmail(),
					adjuntardocs.getThcontenttypefile(), adjuntardocs.getThiddocumentum(),
					adjuntardocs.getThfechaaportacion(), adjuntardocs.getThfechaentrada(),
					adjuntardocs.getThnumregistroentrada(), adjuntardocs.getThestadodocumento(),
					adjuntardocs.getThfechasolfirma(), adjuntardocs.getThfechalimfirma(),
					adjuntardocs.getThfechafirma(), adjuntardocs.getThcomofirma(), adjuntardocs.getThdestino(),
					adjuntardocs.getThhashfile(), adjuntardocs.getThcodocumento());
		} else {
			this.jdbcTemplate.update(query, getTipoProcedimientoPcodigoAux, adjuntardocs.getTrpcodigo(),
					getPerfilIdPerfilAux, getTipoDocumentoIdTipodocAux, adjuntardocs.getThidExpediente(),
					adjuntardocs.getThidTramite(), adjuntardocs.getThnofile(), null, adjuntardocs.getThsizefile(),
					adjuntardocs.getThtedesfile(), adjuntardocs.getThorigen(), adjuntardocs.getThtramite(),
					adjuntardocs.getThfecha(), adjuntardocs.getThindmail(), adjuntardocs.getThtrmail(),
					adjuntardocs.getThcontenttypefile(), adjuntardocs.getThiddocumentum(),
					adjuntardocs.getThfechaaportacion(), adjuntardocs.getThfechaentrada(),
					adjuntardocs.getThnumregistroentrada(), adjuntardocs.getThestadodocumento(),
					adjuntardocs.getThfechasolfirma(), adjuntardocs.getThfechalimfirma(),
					adjuntardocs.getThfechafirma(), adjuntardocs.getThcomofirma(), adjuntardocs.getThdestino(),
					adjuntardocs.getThhashfile(), adjuntardocs.getThcodocumento());
			this.updateBlob(adjuntardocs.getThdatafileinputstream(), adjuntardocs.getThcodocumento());
		}

		return adjuntardocs;
	}

	/**
	 * Updates blob in the Adjuntardocs table.
	 * 
	 * @param is
	 *            InputStream
	 * @param codocumento
	 *            String
	 * @return int
	 */
	private int updateBlob(final InputStream is, final String codocumento) {
		String sql = "UPDATE ADJUNTARDOCS SET THDATAFILE=? WHERE THCODOCUMENTO=?";
		return jdbcTemplate.update(sql, new PreparedStatementSetter() {
			@Override()
			public void setValues(PreparedStatement ps) throws SQLException {
				oracleLobHandler.getLobCreator().setBlobAsBinaryStream(ps, 1, is, -1);
				ps.setString(2, codocumento);
			}
		});
	}

	/**
	 * Updates blob in the Adjuntardocs table.
	 * 
	 * @param is
	 *            InputStream
	 * @param codocumento
	 *            String
	 * @param idTramite
	 *            String
	 * @return int
	 */
	private int updateBlob2(final InputStream is, final String codocumento, final String idTramite) {
		String sql = "UPDATE ADJUNTARDOCS SET THDATAFILE=? WHERE THCODOCUMENTO=? AND THID_TRAMITE=?";
		return jdbcTemplate.update(sql, new PreparedStatementSetter() {
			@Override()
			public void setValues(PreparedStatement ps) throws SQLException {
				oracleLobHandler.getLobCreator().setBlobAsBinaryStream(ps, 1, is, -1);
				ps.setString(2, codocumento);
				ps.setString(3, idTramite);
			}
		});
	}

	/**
	 * Updates blob in the Adjuntardocs table.
	 * 
	 * @param is
	 *            InputStream
	 * @param idDocumentum
	 *            String
	 * @return int
	 */
	private int updateBlob3(final InputStream is, final String idDocumentum) {
		String sql = "UPDATE ADJUNTARDOCS SET THDATAFILE=? WHERE THIDDOCUMENTUM=?";
		return jdbcTemplate.update(sql, new PreparedStatementSetter() {
			@Override()
			public void setValues(PreparedStatement ps) throws SQLException {
				oracleLobHandler.getLobCreator().setBlobAsBinaryStream(ps, 1, is, -1);
				ps.setString(2, idDocumentum);
			}
		});
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateAdjuntarDocumentos(final Adjuntardocs adjuntardocs) {
		List<Object> parametros = new ArrayList<Object>();

		StringBuilder query = new StringBuilder("UPDATE ADJUNTARDOCS SET ");

		if (adjuntardocs.getThnumregistroentrada() != null && !"".equals(adjuntardocs.getThnumregistroentrada())) {
			query.append("THNUMREGISTROENTRADA = ?, ");
			parametros.add(adjuntardocs.getThnumregistroentrada());
		}

		if (adjuntardocs.getThfechaentrada() != null) {
			query.append("THFECHAENTRADA = ?, ");
			parametros.add(adjuntardocs.getThfechaentrada());
		}

		// if (adjuntardocs.getThnumregistroorigen() != null
		// && !"".equals(adjuntardocs.getThnumregistroorigen())) {
		query.append("THNUMREGISTROORIGEN = ?, ");
		parametros.add(adjuntardocs.getThnumregistroorigen());
		// }

		if (adjuntardocs.getThorigen() != null && !"".equals(adjuntardocs.getThorigen())) {
			query.append("THORIGEN = ?, ");
			parametros.add(adjuntardocs.getThorigen());
		}

		// if (adjuntardocs.getThfecharegistroorigen() != null) {
		query.append("THFECHAREGISTROORIGEN = ?, ");
		parametros.add(adjuntardocs.getThfecharegistroorigen());
		// }

		if (adjuntardocs.getThdestino() != null && !"".equals(adjuntardocs.getThdestino())) {
			query.append("THDESTINO = ?, ");
			parametros.add(adjuntardocs.getThdestino());
		}

		if (adjuntardocs.getThtedesfile() != null && !"".equals(adjuntardocs.getThtedesfile())) {
			query.append("THTEDESFILE = ?, ");
			parametros.add(adjuntardocs.getThtedesfile());
		}

		// if (adjuntardocs.getThidtipodoc() != null
		// && !"".equals(adjuntardocs.getThidtipodoc())) {
		// query.append("THID_TIPODOC = ?, ");
		// parametros.add(adjuntardocs.getThidtipodoc());
		// }

		if (adjuntardocs.getTipoDocumento() != null && adjuntardocs.getTipoDocumento().getIdTipodoc() != null
				&& !"".equals(adjuntardocs.getTipoDocumento().getIdTipodoc())) {
			query.append("THID_TIPODOC = ?, ");
			parametros.add(adjuntardocs.getTipoDocumento().getIdTipodoc());
		}

		if (adjuntardocs.getIdInterviniente() != null && !"".equals(adjuntardocs.getIdInterviniente())) {
			query.append("THIDINTERVINIENTE = ?, ");
			parametros.add(adjuntardocs.getIdInterviniente());
		}

		if (adjuntardocs.getPerfil() != null
		/*
		 * && adjuntardocs.getPerfil().getIdPerfil() != null &&
		 * !"".equals(adjuntardocs.getPerfil().getIdPerfil())
		 */) {
			query.append("THID_PERFILFIRMA = ?, ");
			parametros.add(adjuntardocs.getPerfil().getIdPerfil());

			query.append("THESTADODOCUMENTO = ?, ");
			parametros.add(adjuntardocs.getThestadodocumento());

			query.append("THFECHASOLFIRMA = ?, ");
			parametros.add(adjuntardocs.getThfechasolfirma());
		}

		// Viene con archivo a guardar?
		if (adjuntardocs.getThdatafileinputstream() == null && adjuntardocs.getThdatafile() != null) {
			query.append("THDATAFILE = ?, THCONTENTTYPEFILE = ?, THNOFILE = ?, THSIZEFILE = ?, ");
			parametros.add(Y41bJdbcUtils.ConvertBlobToByte(adjuntardocs.getThdatafile()));
			parametros.add(adjuntardocs.getThcontenttypefile());
			parametros.add(adjuntardocs.getThnofile());
			parametros.add(adjuntardocs.getThsizefile());
		} else if (adjuntardocs.getThdatafileinputstream() != null) {
			query.append("THCONTENTTYPEFILE = ?, THNOFILE = ?, THSIZEFILE = ?, ");
			parametros.add(adjuntardocs.getThcontenttypefile());
			parametros.add(adjuntardocs.getThnofile());
			parametros.add(adjuntardocs.getThsizefile());
		}

		// Quitamos la coma y el espacio del final del SET.
		query.setLength(query.length() - 2);

		query.append(" WHERE THCODOCUMENTO = ? AND THID_TRAMITE = ?");
		parametros.add(adjuntardocs.getThcodocumento());
		parametros.add(adjuntardocs.getThidTramite());

		Object[] parametrosArr = parametros.toArray(new Object[parametros.size()]);

		this.jdbcTemplate.update(query.toString(), parametrosArr);

		if (adjuntardocs.getThdatafileinputstream() != null) {
			this.updateBlob2(adjuntardocs.getThdatafileinputstream(), adjuntardocs.getThcodocumento(),
					adjuntardocs.getThidTramite());
		}

		return adjuntardocs;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateOIDDokusi(Adjuntardocs adjuntardocs) {
		String query = "UPDATE ADJUNTARDOCS SET THIDDOCUMENTUM=? WHERE THCODOCUMENTO=?";
		this.jdbcTemplate.update(query, adjuntardocs.getThiddocumentum(), adjuntardocs.getThcodocumento());
		return adjuntardocs;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateHash(Adjuntardocs adjuntardocs) {
		String query = "UPDATE ADJUNTARDOCS SET THHASHFILE=? WHERE THCODOCUMENTO=?";
		this.jdbcTemplate.update(query, adjuntardocs.getThhashfile(), adjuntardocs.getThcodocumento());
		return adjuntardocs;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateHashByOIDDokusi(DocumentoHecho documentoHecho) {
		String query = "UPDATE ADJUNTARDOCS SET THHASHFILE=? WHERE THIDDOCUMENTUM=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5hashfile(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs removeBlobFromOIDDokusi(Adjuntardocs adjuntardocs) {
		String query = "UPDATE ADJUNTARDOCS SET THDATAFILE=null WHERE THCODOCUMENTO=?";
		this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento());
		return adjuntardocs;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateFechaLocalizacion(Adjuntardocs adjuntardocs) {
		String query = "UPDATE ADJUNTARDOCS SET THFECHASOLLOCALIZADOR=SYSDATE WHERE THCODOCUMENTO=?";
		this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento());
		return adjuntardocs;
	}

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return int
	 */
	public int updateTipoDocumento(Adjuntardocs adjuntardocs) {
		String query = "UPDATE ADJUNTARDOCS SET THID_TIPODOC=? WHERE THCODOCUMENTO=?";
		return this.jdbcTemplate.update(query, adjuntardocs.getTipoDocumento().getIdTipodoc(),
				adjuntardocs.getThcodocumento());
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param sandoctemp
	 *            Sandoctemp
	 * @return int
	 */
	public int updateSanDocTemp(Sandoctemp sandoctemp) {
		String query = "UPDATE ADJUNTARDOCS SET THNOFILE=?,THDATAFILE=?, THSIZEFILE=?, THCONTENTTYPEFILE=? WHERE THIDDOCUMENTUM=?";
		if (sandoctemp.getU5datafileinputstream() == null) {
			return this.jdbcTemplate.update(query, sandoctemp.getU5nofile(),
					Y41bJdbcUtils.ConvertBlobToByte(sandoctemp.getU5datafile()), sandoctemp.getU5sizefile(),
					sandoctemp.getU5conttype(), sandoctemp.getU5iddocumentum());
		} else {
			int resultado = this.jdbcTemplate.update(query, sandoctemp.getU5nofile(), null, sandoctemp.getU5sizefile(),
					sandoctemp.getU5conttype(), sandoctemp.getU5iddocumentum());
			this.updateBlob3(sandoctemp.getU5datafileinputstream(), sandoctemp.getU5iddocumentum());
			return resultado;
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateDocumentoHecho(DocumentoHecho documentoHecho) {
		String query = "UPDATE ADJUNTARDOCS SET THNOFILE=?,THDATAFILE=?, THSIZEFILE=?, THCONTENTTYPEFILE=? WHERE THIDDOCUMENTUM=?";
		if (documentoHecho.getQ5datafileinputstream() == null) {
			return this.jdbcTemplate.update(query, documentoHecho.getQ5nofile(),
					Y41bJdbcUtils.ConvertBlobToByte(documentoHecho.getQ5datafile()), documentoHecho.getQ5sizefile(),
					documentoHecho.getQ5contenttypefile(), documentoHecho.getQ5iddocumentum());
		} else {
			int resultado = this.jdbcTemplate.update(query, documentoHecho.getQ5nofile(), null,
					documentoHecho.getQ5sizefile(), documentoHecho.getQ5contenttypefile(),
					documentoHecho.getQ5iddocumentum());
			this.updateBlob3(documentoHecho.getQ5datafileinputstream(), documentoHecho.getQ5iddocumentum());
			return resultado;
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateDatosFirma(DocumentoHecho documentoHecho) {
		String query = "UPDATE ADJUNTARDOCS SET THESTADODOCUMENTO=?, THFECHAFIRMA=?, THCOMOFIRMA=? WHERE THCODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentoHecho.getQ5estadodocumento(), documentoHecho.getQ5fechafirma(),
				documentoHecho.getQ5comofirma(), documentoHecho.getQ5codocumento());
		return documentoHecho;
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	@Transactional(readOnly = true)
	public Adjuntardocs find(Adjuntardocs adjuntardocs) {
		String query = "SELECT t1.THCODOCUMENTO THCODOCUMENTO, t1.THDATAFILE THDATAFILE, t1.THID_EXPEDIENTE THIDEXPEDIENTE, t1.THID_TRAMITE THIDTRAMITE, t1.THNOFILE THNOFILE, t1.THSIZEFILE THSIZEFILE, t1.THTEDESFILE THTEDESFILE, t1.THORIGEN THORIGEN, t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN, t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN, t1.THTRAMITE THTRAMITE, t1.THFECHA THFECHA, t1.THINDMAIL THINDMAIL, t1.THTRMAIL THTRMAIL, t1.THCONTENTTYPEFILE THCONTENTTYPEFILE, t1.THIDDOCUMENTUM THIDDOCUMENTUM, t1.THFECHAAPORTACION THFECHAAPORTACION, t1.THFECHAENTRADA THFECHAENTRADA, t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA, t1.THESTADODOCUMENTO THESTADODOCUMENTO, t1.THFECHASOLFIRMA THFECHASOLFIRMA, t1.THFECHALIMFIRMA THFECHALIMFIRMA, t1.THFECHAFIRMA THFECHAFIRMA, t1.THCOMOFIRMA THCOMOFIRMA, t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA, t3.ID_PERFIL PERFILIDPERFIL, t3.NOMBRE_ES PERFILNOMBREES, t3.NOMBRE_EU PERFILNOMBREEU, t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO, t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC, t4.TDNOMBRE TIPODOCUMENTOTDNOMBRE, t4.TDNOMBREE TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE FROM ADJUNTARDOCS t1 , TIPO_PROCEDIMIENTO t2 , PERFIL t3 , TIPO_DOCUMENTO t4  WHERE t1.THCODOCUMENTO = ?   AND  T1.THID_TRAMITE  = ? AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+)";

		List<Adjuntardocs> adjuntardocsList = this.jdbcTemplate.query(query, this.rwMap,
				adjuntardocs.getThcodocumento(), adjuntardocs.getThidTramite());
		return (Adjuntardocs) DataAccessUtils.uniqueResult(adjuntardocsList);
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	@Transactional(readOnly = true)
	public Adjuntardocs findAdjuntarDocs(Adjuntardocs adjuntardocs) {
		String query = "SELECT t1.THCODOCUMENTO THCODOCUMENTO, t1.THDATAFILE THDATAFILE, t1.THID_EXPEDIENTE THIDEXPEDIENTE, t1.THID_TRAMITE THIDTRAMITE, t1.THNOFILE THNOFILE, t1.THSIZEFILE THSIZEFILE, t1.THTEDESFILE THTEDESFILE, t1.THORIGEN THORIGEN, t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN, t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN, t1.THTRAMITE THTRAMITE, t1.THFECHA THFECHA, t1.THINDMAIL THINDMAIL, t1.THTRMAIL THTRMAIL, t1.THCONTENTTYPEFILE THCONTENTTYPEFILE, t1.THIDDOCUMENTUM THIDDOCUMENTUM, t1.THFECHAAPORTACION THFECHAAPORTACION, t1.THFECHAENTRADA THFECHAENTRADA, t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA, t1.THESTADODOCUMENTO THESTADODOCUMENTO, t1.THFECHASOLFIRMA THFECHASOLFIRMA, t1.THFECHALIMFIRMA THFECHALIMFIRMA, t1.THFECHAFIRMA THFECHAFIRMA, t1.THCOMOFIRMA THCOMOFIRMA, t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA, t3.ID_PERFIL PERFILIDPERFIL, t3.NOMBRE_ES PERFILNOMBREES, t3.NOMBRE_EU PERFILNOMBREEU, t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO, t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC, t4.TDNOMBRE TIPODOCUMENTOTDNOMBRE, t4.TDNOMBREE TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE FROM ADJUNTARDOCS t1 , TIPO_PROCEDIMIENTO t2 , PERFIL t3 , TIPO_DOCUMENTO t4  WHERE t1.THCODOCUMENTO = ? AND t1.THID_TRAMITE = ? AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+)";

		List<Adjuntardocs> adjuntardocsList = this.jdbcTemplate.query(query, this.rwMap,
				adjuntardocs.getThcodocumento(), adjuntardocs.getThidTramite());
		return (Adjuntardocs) DataAccessUtils.uniqueResult(adjuntardocsList);
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	@Transactional(readOnly = true)
	public Adjuntardocs findAdjuntarDocsByExpediente(Adjuntardocs adjuntardocs) {
		String query = "SELECT t1.THCODOCUMENTO THCODOCUMENTO, t1.THDATAFILE THDATAFILE, t1.THID_EXPEDIENTE THIDEXPEDIENTE, t1.THID_TRAMITE THIDTRAMITE, t1.THNOFILE THNOFILE, t1.THSIZEFILE THSIZEFILE, t1.THTEDESFILE THTEDESFILE, t1.THORIGEN THORIGEN, t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN, t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN, t1.THTRAMITE THTRAMITE, t1.THFECHA THFECHA, t1.THINDMAIL THINDMAIL, t1.THTRMAIL THTRMAIL, t1.THCONTENTTYPEFILE THCONTENTTYPEFILE, t1.THIDDOCUMENTUM THIDDOCUMENTUM, t1.THFECHAAPORTACION THFECHAAPORTACION, t1.THFECHAENTRADA THFECHAENTRADA, t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA, t1.THESTADODOCUMENTO THESTADODOCUMENTO, t1.THFECHASOLFIRMA THFECHASOLFIRMA, t1.THFECHALIMFIRMA THFECHALIMFIRMA, t1.THFECHAFIRMA THFECHAFIRMA, t1.THCOMOFIRMA THCOMOFIRMA, t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA, t3.ID_PERFIL PERFILIDPERFIL, t3.NOMBRE_ES PERFILNOMBREES, t3.NOMBRE_EU PERFILNOMBREEU, t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO, t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC, t4.TDNOMBRE TIPODOCUMENTOTDNOMBRE, t4.TDNOMBREE TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE FROM ADJUNTARDOCS t1 , TIPO_PROCEDIMIENTO t2 , PERFIL t3 , TIPO_DOCUMENTO t4  WHERE t1.THCODOCUMENTO = ? AND t1.THID_EXPEDIENTE = ? AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+)";

		List<Adjuntardocs> adjuntardocsList = this.jdbcTemplate.query(query, this.rwMap,
				adjuntardocs.getThcodocumento(), adjuntardocs.getThidExpediente());
		return (Adjuntardocs) DataAccessUtils.uniqueResult(adjuntardocsList);
	}

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	@Transactional(readOnly = true)
	public Adjuntardocs findDocByPK(Adjuntardocs adjuntardocs) {
		String query = "SELECT t1.THCODOCUMENTO THCODOCUMENTO, t1.THDATAFILE THDATAFILE, t1.THID_EXPEDIENTE THIDEXPEDIENTE, t1.THID_TRAMITE THIDTRAMITE, t1.THNOFILE THNOFILE, t1.THSIZEFILE THSIZEFILE, t1.THTEDESFILE THTEDESFILE, t1.THORIGEN THORIGEN, t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN, t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN, t1.THTRAMITE THTRAMITE, t1.THFECHA THFECHA, t1.THINDMAIL THINDMAIL, t1.THTRMAIL THTRMAIL, t1.THCONTENTTYPEFILE THCONTENTTYPEFILE, t1.THIDDOCUMENTUM THIDDOCUMENTUM, t1.THFECHAAPORTACION THFECHAAPORTACION, t1.THFECHAENTRADA THFECHAENTRADA, t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA, t1.THESTADODOCUMENTO THESTADODOCUMENTO, t1.THFECHASOLFIRMA THFECHASOLFIRMA, t1.THFECHALIMFIRMA THFECHALIMFIRMA, t1.THFECHAFIRMA THFECHAFIRMA, t1.THCOMOFIRMA THCOMOFIRMA, t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA, t3.ID_PERFIL PERFILIDPERFIL, t3.NOMBRE_ES PERFILNOMBREES, t3.NOMBRE_EU PERFILNOMBREEU, t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO, t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC, t4.TDNOMBRE TIPODOCUMENTOTDNOMBRE, t4.TDNOMBREE TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE FROM ADJUNTARDOCS t1 , TIPO_PROCEDIMIENTO t2 , PERFIL t3 , TIPO_DOCUMENTO t4  WHERE t1.THCODOCUMENTO = ? AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+)";

		List<Adjuntardocs> adjuntardocsList = this.jdbcTemplate.query(query, this.rwMap,
				adjuntardocs.getThcodocumento());
		return (Adjuntardocs) DataAccessUtils.uniqueResult(adjuntardocsList);
	}

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return
	 */
	public void remove(Adjuntardocs adjuntardocs) {
		String query = "DELETE FROM ADJUNTARDOCS WHERE THCODOCUMENTO=?";
		this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento());
	}

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return
	 */
	public void removeAdjuntarDocs(Adjuntardocs adjuntardocs) {
		String query = "DELETE FROM ADJUNTARDOCS WHERE THCODOCUMENTO = ? AND THID_EXPEDIENTE = ? AND THID_TRAMITE=? ";
		this.jdbcTemplate.update(query, adjuntardocs.getThcodocumento(), adjuntardocs.getThidExpediente(),
				adjuntardocs.getThidTramite());
	}

	/**
	 * 
	 * @param expediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idProcedimiento
	 *            String
	 */
	public void removeAdjuntarDocsTramite(TramiteComun tramiteComun) {
		String query = "DELETE FROM ADJUNTARDOCS WHERE THID_TRAMITE=? AND TRPCODIGO=?";
		this.jdbcTemplate.update(query, tramiteComun.getIdTramite(), tramiteComun.getTipoProcedimiento().getPcodigo());
	}

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllAdjuntarDocs(TramiteComun tramiteComun) {
		try {
			String query = "DELETE FROM ADJUNTARDOCS WHERE THID_TRAMITE=?";
			this.jdbcTemplate.update(query, tramiteComun.getIdTramite());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param claveTablaMaestra
	 *            String
	 * @return
	 */
	public void removeAllDocsTableTemporal(String claveTablaMaestra) {
		String query = "DELETE FROM ADJUNTARDOCS WHERE THID_EXPEDIENTE = ? ";
		this.jdbcTemplate.update(query, claveTablaMaestra);
	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntardocs> findAll(Adjuntardocs adjuntardocs, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.THCODOCUMENTO THCODOCUMENTO,null THDATAFILE,t1.THID_EXPEDIENTE THIDEXPEDIENTE,t1.THID_TRAMITE THIDTRAMITE,t1.THNOFILE THNOFILE,t1.THSIZEFILE THSIZEFILE,t1.THTEDESFILE THTEDESFILE,t1.THORIGEN THORIGEN,t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN,t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN,t1.THTRAMITE THTRAMITE,t1.THFECHA THFECHA,t1.THINDMAIL THINDMAIL,t1.THTRMAIL THTRMAIL,t1.THCONTENTTYPEFILE THCONTENTTYPEFILE,t1.THIDDOCUMENTUM THIDDOCUMENTUM,t1.THFECHAAPORTACION THFECHAAPORTACION,t1.THFECHAENTRADA THFECHAENTRADA,t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA,t1.THESTADODOCUMENTO THESTADODOCUMENTO,t1.THFECHASOLFIRMA THFECHASOLFIRMA,t1.THFECHALIMFIRMA THFECHALIMFIRMA,t1.THFECHAFIRMA THFECHAFIRMA,t1.THCOMOFIRMA THCOMOFIRMA,t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA,t3.ID_PERFIL PERFILIDPERFIL,t3.NOMBRE_ES PERFILNOMBREES,t3.NOMBRE_EU PERFILNOMBREEU,t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO,t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC,null TIPODOCUMENTOTDNOMBRE,null TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE ");
			query.append("FROM ADJUNTARDOCS t1 ,TIPO_PROCEDIMIENTO t2 ,PERFIL t3 ,TIPO_DOCUMENTO t4 ");

			// Where clause & Params
			Map<String, ?> mapaWhere = this.getWhereMap(adjuntardocs);
			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+) ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			List<?> params = (List<?>) mapaWhere.get("params");

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Adjuntardocs>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntardocs> findAllTipoDocInspecciones(Adjuntardocs adjuntardocs, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT t1.THCODOCUMENTO THCODOCUMENTO, null THDATAFILE, t1.THID_EXPEDIENTE THIDEXPEDIENTE, t1.THID_TRAMITE THIDTRAMITE, t1.THNOFILE THNOFILE, t1.THSIZEFILE THSIZEFILE, t1.THTEDESFILE THTEDESFILE, t1.THORIGEN THORIGEN, t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN, t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN, t1.THTRAMITE THTRAMITE, t1.THFECHA THFECHA, t1.THINDMAIL THINDMAIL, t1.THTRMAIL THTRMAIL, t1.THCONTENTTYPEFILE THCONTENTTYPEFILE, t1.THIDDOCUMENTUM THIDDOCUMENTUM, t1.THFECHAAPORTACION THFECHAAPORTACION, t1.THFECHAENTRADA THFECHAENTRADA, t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA, t1.THESTADODOCUMENTO THESTADODOCUMENTO, t1.THFECHASOLFIRMA THFECHASOLFIRMA, t1.THFECHALIMFIRMA THFECHALIMFIRMA, t1.THFECHAFIRMA THFECHAFIRMA, t1.THCOMOFIRMA THCOMOFIRMA, t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO, t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE, t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE, t2.PBAJA TIPOPROCEDIMIENTOPBAJA, t3.ID_PERFIL PERFILIDPERFIL, t3.NOMBRE_ES PERFILNOMBREES, t3.NOMBRE_EU PERFILNOMBREEU, t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO, t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC, t4.TDNOMBRE TIPODOCUMENTOTDNOMBRE, t4.TDNOMBREE TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE ");
			query.append("FROM ADJUNTARDOCS t1, TIPO_PROCEDIMIENTO t2, PERFIL t3, INSPECCIONES_TIPO_DOCUMENTO t4 ");

			// Where clause & Params
			Map<String, ?> mapaWhere = this.getWhereMap(adjuntardocs);
			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+) ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			List<?> params = (List<?>) mapaWhere.get("params");

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Adjuntardocs>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllActasTramiteCount(Adjuntardocs adjuntardocs) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM documento_hecho t1 , doc_tramite_hecho t2 ");

		// Where clause & Params

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 and t1.Q5CODOCUMENTO = t2.CODOCUMENTO and t2.EHCODIGO = ? and t2.PCODIGO = ? and t1.Q5ID_TIPODOC= ? ");

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), adjuntardocs.getThidTramite(),
				adjuntardocs.getTipoProcedimiento().getPcodigo(), adjuntardocs.getTipoDocumento().getIdTipodoc());
	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntardocs> findAllTipoDocNuevo(Adjuntardocs adjuntardocs, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.THCODOCUMENTO THCODOCUMENTO,null THDATAFILE,t1.THID_EXPEDIENTE THIDEXPEDIENTE,t1.THID_TRAMITE THIDTRAMITE,t1.THNOFILE THNOFILE,t1.THSIZEFILE THSIZEFILE,t1.THTEDESFILE THTEDESFILE,t1.THORIGEN THORIGEN,t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN,t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN,t1.THTRAMITE THTRAMITE,t1.THFECHA THFECHA,t1.THINDMAIL THINDMAIL,t1.THTRMAIL THTRMAIL,t1.THCONTENTTYPEFILE THCONTENTTYPEFILE,t1.THIDDOCUMENTUM THIDDOCUMENTUM,t1.THFECHAAPORTACION THFECHAAPORTACION,t1.THFECHAENTRADA THFECHAENTRADA,t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA,t1.THESTADODOCUMENTO THESTADODOCUMENTO,t1.THFECHASOLFIRMA THFECHASOLFIRMA,t1.THFECHALIMFIRMA THFECHALIMFIRMA,t1.THFECHAFIRMA THFECHAFIRMA,t1.THCOMOFIRMA THCOMOFIRMA,t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA,t3.ID_PERFIL PERFILIDPERFIL,t3.NOMBRE_ES PERFILNOMBREES,t3.NOMBRE_EU PERFILNOMBREEU,t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO,t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC,null TIPODOCUMENTOTDNOMBRE,null TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE ");
			query.append("FROM ADJUNTARDOCS t1 ,TIPO_PROCEDIMIENTO t2 ,PERFIL t3 ");

			// Where clause & Params
			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) ");
			where.append(" AND  T1.THID_TRAMITE  = ? AND t1.TRPCODIGO=? ");

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Adjuntardocs>) this.jdbcTemplate.query(query.toString(), this.rwMap,
					adjuntardocs.getThidTramite(), adjuntardocs.getTrpcodigo());
		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Counts rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Adjuntardocs adjuntardocs) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTARDOCS t1 , TIPO_PROCEDIMIENTO t2 , PERFIL t3 , TIPO_DOCUMENTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntardocs);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntardocs> findAllLike(Adjuntardocs adjuntardocs, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.THCODOCUMENTO THCODOCUMENTO,null THDATAFILE,t1.THID_EXPEDIENTE THIDEXPEDIENTE,t1.THID_TRAMITE THIDTRAMITE,t1.THNOFILE THNOFILE,t1.THSIZEFILE THSIZEFILE,t1.THTEDESFILE THTEDESFILE,t1.THORIGEN THORIGEN,t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN,t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN,t1.THTRAMITE THTRAMITE,t1.THFECHA THFECHA,t1.THINDMAIL THINDMAIL,t1.THTRMAIL THTRMAIL,t1.THCONTENTTYPEFILE THCONTENTTYPEFILE,t1.THIDDOCUMENTUM THIDDOCUMENTUM,t1.THFECHAAPORTACION THFECHAAPORTACION,t1.THFECHAENTRADA THFECHAENTRADA,t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA,t1.THESTADODOCUMENTO THESTADODOCUMENTO,t1.THFECHASOLFIRMA THFECHASOLFIRMA,t1.THFECHALIMFIRMA THFECHALIMFIRMA,t1.THFECHAFIRMA THFECHAFIRMA,t1.THCOMOFIRMA THCOMOFIRMA,t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO, t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA,t3.ID_PERFIL PERFILIDPERFIL,t3.NOMBRE_ES PERFILNOMBREES,t3.NOMBRE_EU PERFILNOMBREEU,t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO,t4.ID_TIPODOC TIPODOCUMENTOIDTIPODOC,t4.TDNOMBRE TIPODOCUMENTOTDNOMBRE,t4.TDNOMBREE TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE ");
		query.append("FROM ADJUNTARDOCS t1 ,TIPO_PROCEDIMIENTO t2 ,PERFIL t3 ,TIPO_DOCUMENTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntardocs, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Adjuntardocs>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Adjuntardocs adjuntardocs, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTARDOCS t1 ,TIPO_PROCEDIMIENTO t2 ,PERFIL t3 ,TIPO_DOCUMENTO t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntardocs, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+) AND t1.THID_TIPODOC= t4.ID_TIPODOC(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Adjuntardocs entity
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Adjuntardocs adjuntardocs) {

		StringBuilder where = new StringBuilder(AdjuntardocsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntardocs != null && adjuntardocs.getThcodocumento() != null) {
			where.append(" AND t1.THCODOCUMENTO = ?");
			params.add(adjuntardocs.getThcodocumento());
		}
		if (adjuntardocs != null && adjuntardocs.getTrpcodigo() != null) {
			where.append(" AND t1.TRPCODIGO = ?");
			params.add(adjuntardocs.getTrpcodigo());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(adjuntardocs.getTipoProcedimiento().getPcodigo());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPnombre() != null) {
			where.append(" AND t2.PNOMBRE = ?");
			params.add(adjuntardocs.getTipoProcedimiento().getPnombre());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPnombree() != null) {
			where.append(" AND t2.PNOMBREE = ?");
			params.add(adjuntardocs.getTipoProcedimiento().getPnombree());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPbaja() != null) {
			where.append(" AND t2.PBAJA = ?");
			params.add(adjuntardocs.getTipoProcedimiento().getPbaja());
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getIdPerfil() != null) {
			where.append(" AND t3.ID_PERFIL = ?");
			params.add(adjuntardocs.getPerfil().getIdPerfil());
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getNombreEs() != null) {
			where.append(" AND t3.NOMBRE_ES = ?");
			params.add(adjuntardocs.getPerfil().getNombreEs());
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getNombreEu() != null) {
			where.append(" AND t3.NOMBRE_EU = ?");
			params.add(adjuntardocs.getPerfil().getNombreEu());
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getIsmantenimiento() != null) {
			where.append(" AND t3.ISMANTENIMIENTO = ?");
			params.add(adjuntardocs.getPerfil().getIsmantenimiento());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoDocumento() != null
				&& adjuntardocs.getTipoDocumento().getIdTipodoc() != null) {
			where.append(" AND t1.THID_TIPODOC = ?");
			params.add(adjuntardocs.getTipoDocumento().getIdTipodoc());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoDocumento() != null
				&& adjuntardocs.getTipoDocumento().getTdnombre() != null) {
			where.append(" AND t4.TDNOMBRE = ?");
			params.add(adjuntardocs.getTipoDocumento().getTdnombre());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoDocumento() != null
				&& adjuntardocs.getTipoDocumento().getTdnombree() != null) {
			where.append(" AND t4.TDNOMBREE = ?");
			params.add(adjuntardocs.getTipoDocumento().getTdnombree());
		}
		if (adjuntardocs != null && adjuntardocs.getThidExpediente() != null) {
			where.append(" AND t1.THID_EXPEDIENTE = ?");
			params.add(adjuntardocs.getThidExpediente());
		}
		if (adjuntardocs != null && adjuntardocs.getThidTramite() != null) {
			where.append(" AND t1.THID_TRAMITE = ?");
			params.add(adjuntardocs.getThidTramite());
		}
		if (adjuntardocs != null && adjuntardocs.getThnofile() != null) {
			where.append(" AND t1.THNOFILE = ?");
			params.add(adjuntardocs.getThnofile());
		}
		if (adjuntardocs != null && adjuntardocs.getThsizefile() != null) {
			where.append(" AND t1.THSIZEFILE = ?");
			params.add(adjuntardocs.getThsizefile());
		}
		if (adjuntardocs != null && adjuntardocs.getThtedesfile() != null) {
			where.append(" AND t1.THTEDESFILE = ?");
			params.add(adjuntardocs.getThtedesfile());
		}
		if (adjuntardocs != null && adjuntardocs.getThorigen() != null) {
			where.append(" AND t1.THORIGEN = ?");
			params.add(adjuntardocs.getThorigen());
		}
		if (adjuntardocs != null && adjuntardocs.getThtramite() != null) {
			where.append(" AND t1.THTRAMITE = ?");
			params.add(adjuntardocs.getThtramite());
		}
		if (adjuntardocs != null && adjuntardocs.getThfecha() != null) {
			where.append(" AND t1.THFECHA = ?");
			params.add(adjuntardocs.getThfecha());
		}
		if (adjuntardocs != null && adjuntardocs.getThindmail() != null) {
			where.append(" AND t1.THINDMAIL = ?");
			params.add(adjuntardocs.getThindmail());
		}
		if (adjuntardocs != null && adjuntardocs.getThtrmail() != null) {
			where.append(" AND t1.THTRMAIL = ?");
			params.add(adjuntardocs.getThtrmail());
		}
		if (adjuntardocs != null && adjuntardocs.getThcontenttypefile() != null) {
			where.append(" AND t1.THCONTENTTYPEFILE = ?");
			params.add(adjuntardocs.getThcontenttypefile());
		}
		if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null) {
			where.append(" AND t1.THIDDOCUMENTUM = ?");
			params.add(adjuntardocs.getThiddocumentum());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechaaportacion() != null) {
			where.append(" AND t1.THFECHAAPORTACION = ?");
			params.add(adjuntardocs.getThfechaaportacion());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechaentrada() != null) {
			where.append(" AND t1.THFECHAENTRADA = ?");
			params.add(adjuntardocs.getThfechaentrada());
		}
		if (adjuntardocs != null && adjuntardocs.getThnumregistroentrada() != null) {
			where.append(" AND t1.THNUMREGISTROENTRADA = ?");
			params.add(adjuntardocs.getThnumregistroentrada());
		}
		if (adjuntardocs != null && adjuntardocs.getThestadodocumento() != null) {
			where.append(" AND t1.THESTADODOCUMENTO = ?");
			params.add(adjuntardocs.getThestadodocumento());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechasolfirma() != null) {
			where.append(" AND t1.THFECHASOLFIRMA = ?");
			params.add(adjuntardocs.getThfechasolfirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechalimfirma() != null) {
			where.append(" AND t1.THFECHALIMFIRMA = ?");
			params.add(adjuntardocs.getThfechalimfirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechafirma() != null) {
			where.append(" AND t1.THFECHAFIRMA = ?");
			params.add(adjuntardocs.getThfechafirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThcomofirma() != null) {
			where.append(" AND t1.THCOMOFIRMA = ?");
			params.add(adjuntardocs.getThcomofirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThdestino() != null) {
			where.append(" AND t1.THDESTINO = ?");
			params.add(adjuntardocs.getThdestino());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Adjuntardocs entity
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Adjuntardocs adjuntardocs, Boolean startsWith) {

		StringBuilder where = new StringBuilder(AdjuntardocsDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntardocs != null && adjuntardocs.getThcodocumento() != null) {
			where.append(" AND UPPER(t1.THCODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThcodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThcodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.THCODOCUMENTO IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPcodigo() != null) {
			where.append(" AND t2.PCODIGO = ?");
			params.add(adjuntardocs.getTipoProcedimiento().getPcodigo());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPnombre() != null) {
			where.append(" AND UPPER(t2.PNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getTipoProcedimiento().getPnombre().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getTipoProcedimiento().getPnombre().toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBRE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPnombree() != null) {
			where.append(" AND UPPER(t2.PNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getTipoProcedimiento().getPnombree().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getTipoProcedimiento().getPnombree().toUpperCase() + "%");
			}
			where.append(" AND t2.PNOMBREE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getTipoProcedimiento() != null
				&& adjuntardocs.getTipoProcedimiento().getPbaja() != null) {
			where.append(" AND t2.PBAJA = ?");
			params.add(adjuntardocs.getTipoProcedimiento().getPbaja());
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getIdPerfil() != null) {
			where.append(" AND t3.ID_PERFIL = ?");
			params.add(adjuntardocs.getPerfil().getIdPerfil());
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getNombreEs() != null) {
			where.append(" AND UPPER(t3.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getPerfil().getNombreEs().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getPerfil().getNombreEs().toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_ES IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getNombreEu() != null) {
			where.append(" AND UPPER(t3.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getPerfil().getNombreEu().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getPerfil().getNombreEu().toUpperCase() + "%");
			}
			where.append(" AND t3.NOMBRE_EU IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getPerfil() != null
				&& adjuntardocs.getPerfil().getIsmantenimiento() != null) {
			where.append(" AND UPPER(t3.ISMANTENIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getPerfil().getIsmantenimiento().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getPerfil().getIsmantenimiento().toUpperCase() + "%");
			}
			where.append(" AND t3.ISMANTENIMIENTO IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getTipoDocumento() != null
				&& adjuntardocs.getTipoDocumento().getIdTipodoc() != null) {
			where.append(" AND t4.ID_TIPODOC = ?");
			params.add(adjuntardocs.getTipoDocumento().getIdTipodoc());
		}
		if (adjuntardocs != null && adjuntardocs.getTipoDocumento() != null
				&& adjuntardocs.getTipoDocumento().getTdnombre() != null) {
			where.append(" AND UPPER(t4.TDNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getTipoDocumento().getTdnombre().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getTipoDocumento().getTdnombre().toUpperCase() + "%");
			}
			where.append(" AND t4.TDNOMBRE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getTipoDocumento() != null
				&& adjuntardocs.getTipoDocumento().getTdnombree() != null) {
			where.append(" AND UPPER(t4.TDNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getTipoDocumento().getTdnombree().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getTipoDocumento().getTdnombree().toUpperCase() + "%");
			}
			where.append(" AND t4.TDNOMBREE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThidExpediente() != null) {
			where.append(" AND UPPER(t1.THID_EXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThidExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThidExpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.THID_EXPEDIENTE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThidTramite() != null) {
			where.append(" AND UPPER(t1.THID_TRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThidTramite().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThidTramite().toUpperCase() + "%");
			}
			where.append(" AND t1.THID_TRAMITE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThnofile() != null) {
			where.append(" AND UPPER(t1.THNOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThnofile().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThnofile().toUpperCase() + "%");
			}
			where.append(" AND t1.THNOFILE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThsizefile() != null) {
			where.append(" AND t1.THSIZEFILE = ?");
			params.add(adjuntardocs.getThsizefile());
		}
		if (adjuntardocs != null && adjuntardocs.getThtedesfile() != null) {
			where.append(" AND UPPER(t1.THTEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThtedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThtedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.THTEDESFILE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThorigen() != null) {
			where.append(" AND UPPER(t1.THORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThorigen().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThorigen().toUpperCase() + "%");
			}
			where.append(" AND t1.THORIGEN IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThtramite() != null) {
			where.append(" AND UPPER(t1.THTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThtramite().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThtramite().toUpperCase() + "%");
			}
			where.append(" AND t1.THTRAMITE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThfecha() != null) {
			where.append(" AND t1.THFECHA = ?");
			params.add(adjuntardocs.getThfecha());
		}
		if (adjuntardocs != null && adjuntardocs.getThindmail() != null) {
			where.append(" AND UPPER(t1.THINDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThindmail().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThindmail().toUpperCase() + "%");
			}
			where.append(" AND t1.THINDMAIL IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThtrmail() != null) {
			where.append(" AND UPPER(t1.THTRMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThtrmail().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThtrmail().toUpperCase() + "%");
			}
			where.append(" AND t1.THTRMAIL IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThcontenttypefile() != null) {
			where.append(" AND UPPER(t1.THCONTENTTYPEFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThcontenttypefile().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThcontenttypefile().toUpperCase() + "%");
			}
			where.append(" AND t1.THCONTENTTYPEFILE IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null) {
			where.append(" AND UPPER(t1.THIDDOCUMENTUM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThiddocumentum().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThiddocumentum().toUpperCase() + "%");
			}
			where.append(" AND t1.THIDDOCUMENTUM IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThfechaaportacion() != null) {
			where.append(" AND t1.THFECHAAPORTACION = ?");
			params.add(adjuntardocs.getThfechaaportacion());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechaentrada() != null) {
			where.append(" AND t1.THFECHAENTRADA = ?");
			params.add(adjuntardocs.getThfechaentrada());
		}
		if (adjuntardocs != null && adjuntardocs.getThnumregistroentrada() != null) {
			where.append(" AND UPPER(t1.THNUMREGISTROENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThnumregistroentrada().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThnumregistroentrada().toUpperCase() + "%");
			}
			where.append(" AND t1.THNUMREGISTROENTRADA IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThestadodocumento() != null) {
			where.append(" AND UPPER(t1.THESTADODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThestadodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThestadodocumento().toUpperCase() + "%");
			}
			where.append(" AND t1.THESTADODOCUMENTO IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThfechasolfirma() != null) {
			where.append(" AND t1.THFECHASOLFIRMA = ?");
			params.add(adjuntardocs.getThfechasolfirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechalimfirma() != null) {
			where.append(" AND t1.THFECHALIMFIRMA = ?");
			params.add(adjuntardocs.getThfechalimfirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThfechafirma() != null) {
			where.append(" AND t1.THFECHAFIRMA = ?");
			params.add(adjuntardocs.getThfechafirma());
		}
		if (adjuntardocs != null && adjuntardocs.getThcomofirma() != null) {
			where.append(" AND UPPER(t1.THCOMOFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThcomofirma().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThcomofirma().toUpperCase() + "%");
			}
			where.append(" AND t1.THCOMOFIRMA IS NOT NULL");
		}
		if (adjuntardocs != null && adjuntardocs.getThdestino() != null) {
			where.append(" AND UPPER(t1.THDESTINO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardocs.getThdestino().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardocs.getThdestino().toUpperCase() + "%");
			}
			where.append(" AND t1.THDESTINO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the Adjuntardocs table.
	 */
	public void removeAdjuntardocsAntiguos() {
		String query = "DELETE FROM ADJUNTARDOCS WHERE THFECALTA <= ?";
		Date hoy = new Date();
		hoy = Y41bUtils.addDays(hoy, -15);
		this.jdbcTemplate.update(query, hoy);
	}

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Adjuntardocs> findAllTipoDocArb(Adjuntardocs adjuntardocs, Pagination pagination) {
		try {
			StringBuilder query = new StringBuilder(
					"SELECT  t1.THCODOCUMENTO THCODOCUMENTO,null THDATAFILE,t1.THID_EXPEDIENTE THIDEXPEDIENTE,t1.THID_TRAMITE THIDTRAMITE,t1.THNOFILE THNOFILE,t1.THSIZEFILE THSIZEFILE,t1.THTEDESFILE THTEDESFILE,t1.THORIGEN THORIGEN,t1.THNUMREGISTROORIGEN THNUMREGISTROORIGEN,t1.THFECHAREGISTROORIGEN THFECHAREGISTROORIGEN,t1.THTRAMITE THTRAMITE,t1.THFECHA THFECHA,t1.THINDMAIL THINDMAIL,t1.THTRMAIL THTRMAIL,t1.THCONTENTTYPEFILE THCONTENTTYPEFILE,t1.THIDDOCUMENTUM THIDDOCUMENTUM,t1.THFECHAAPORTACION THFECHAAPORTACION,t1.THFECHAENTRADA THFECHAENTRADA,t1.THNUMREGISTROENTRADA THNUMREGISTROENTRADA,t1.THESTADODOCUMENTO THESTADODOCUMENTO,t1.THFECHASOLFIRMA THFECHASOLFIRMA,t1.THFECHALIMFIRMA THFECHALIMFIRMA,t1.THFECHAFIRMA THFECHAFIRMA,t1.THCOMOFIRMA THCOMOFIRMA,t1.THDESTINO THDESTINO, t1.THFECHASOLLOCALIZADOR THFECHASOLLOCALIZADOR, t1.THPTCODIGO THPTCODIGO,t2.PCODIGO TIPOPROCEDIMIENTOPCODIGO,t2.PNOMBRE TIPOPROCEDIMIENTOPNOMBRE,t2.PNOMBREE TIPOPROCEDIMIENTOPNOMBREE,t2.PBAJA TIPOPROCEDIMIENTOPBAJA,t3.ID_PERFIL PERFILIDPERFIL,t3.NOMBRE_ES PERFILNOMBREES,t3.NOMBRE_EU PERFILNOMBREEU,t3.ISMANTENIMIENTO PERFILISMANTENIMIENTO,t1.THID_TIPODOC TIPODOCUMENTOIDTIPODOC,null TIPODOCUMENTOTDNOMBRE,null TIPODOCUMENTOTDNOMBREE, t1.TRPCODIGO TRPCODIGO, t1.THIDINTERVINIENTE THIDINTERVINIENTE, t1.THHASHFILE THHASHFILE ");
			query.append("FROM ADJUNTARDOCS t1 ,TIPO_PROCEDIMIENTO t2 ,PERFIL t3 ");

			// Where clause & Params
			StringBuilder where = new StringBuilder(
					" WHERE 1=1 AND t1.THPCODIGO= t2.PCODIGO(+) AND t1.THID_PERFILFIRMA= t3.ID_PERFIL(+)  ");
			where.append(" AND  T1.THID_TRAMITE  = ? AND t1.TRPCODIGO=?  ");

			query.append(where);

			if (pagination != null) {
				query = pagination.getPaginationQuery(query);
			}

			return (List<Adjuntardocs>) this.jdbcTemplate.query(query.toString(), this.rwMap,
					adjuntardocs.getThidTramite(), adjuntardocs.getTrpcodigo());

		} catch (Exception e) {
			e.printStackTrace();
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return int
	 */
	public int updateArbDocTemp(Arbdoctemp arbdoctemp) {
		String query = "UPDATE ADJUNTARDOCS SET THNOFILE=?,THDATAFILE=?, THSIZEFILE=?, THCONTENTTYPEFILE=? WHERE THIDDOCUMENTUM=?";
		if (arbdoctemp.getX5datafileinputstream() == null) {
			return this.jdbcTemplate.update(query, arbdoctemp.getX5nofile(),
					Y41bJdbcUtils.ConvertBlobToByte(arbdoctemp.getX5datafile()), arbdoctemp.getX5sizefile(),
					arbdoctemp.getX5conttype(), arbdoctemp.getX5iddocumentum());
		} else {
			int resultado = this.jdbcTemplate.update(query, arbdoctemp.getX5nofile(), null, arbdoctemp.getX5sizefile(),
					arbdoctemp.getX5conttype(), arbdoctemp.getX5iddocumentum());
			this.updateBlob3(arbdoctemp.getX5datafileinputstream(), arbdoctemp.getX5iddocumentum());
			return resultado;
		}
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return int
	 */
	public int updateArbAdhDoc(Arbadhdoc arbadhdoc) {
		String query = "UPDATE ADJUNTARDOCS SET THNOFILE=?,THDATAFILE=?, THSIZEFILE=?, THCONTENTTYPEFILE=? WHERE THIDDOCUMENTUM=?";
		if (arbadhdoc.getX5datafileinputstream() == null) {
			return this.jdbcTemplate.update(query, arbadhdoc.getX5nofile(),
					Y41bJdbcUtils.ConvertBlobToByte(arbadhdoc.getX5datafile()), arbadhdoc.getX5sizefile(),
					arbadhdoc.getX5conttype(), arbadhdoc.getX5iddocumentum());
		} else {
			int resultado = this.jdbcTemplate.update(query, arbadhdoc.getX5nofile(), null, arbadhdoc.getX5sizefile(),
					arbadhdoc.getX5conttype(), arbadhdoc.getX5iddocumentum());
			this.updateBlob3(arbadhdoc.getX5datafileinputstream(), arbadhdoc.getX5iddocumentum());
			return resultado;
		}
	}

	/**
	 * Finds a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * @throws Exception
	 */
	@Transactional(readOnly = true)
	public Adjuntardocs findDocAdhesiones(Adjuntardocs adjuntardocs) throws Exception {
		Adjuntardocs adjuntardocsAux = null;
		try {
			String query = "SELECT t1.THCODOCUMENTO THCODOCUMENTO, t1.THDATAFILE THDATAFILE FROM ADJUNTARDOCS t1 WHERE t1.THCODOCUMENTO = ?   AND  T1.THID_TRAMITE  = ? AND T1.TRPCODIGO = ? ";

			List<Adjuntardocs> listAdjuntardocs = this.jdbcTemplate.query(query, new RowMapper<Adjuntardocs>() {
				public Adjuntardocs mapRow(ResultSet resultSet, int rowNum) throws SQLException {
					return new Adjuntardocs(resultSet.getString("THCODOCUMENTO"), resultSet.getBlob("THDATAFILE"));
				}
			}, adjuntardocs.getThcodocumento(), adjuntardocs.getThidTramite(), adjuntardocs.getTrpcodigo());

			if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
				adjuntardocsAux = listAdjuntardocs.get(0);
			} else {
				adjuntardocsAux = null;
			}
		} catch (Exception e) {
			throw e;
		}
		return adjuntardocsAux;
	}
}
