package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.DocumentoHecho;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.TramiteComun;

/**
 * AdjuntardocsDao  
 * 
 *  
 */

public interface AdjuntardocsDao {

	/**
	 * Inserts a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs add(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs update(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs updateAdjuntarDocumentos(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateOIDDokusi(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateHash(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateHashByOIDDokusi(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs removeBlobFromOIDDokusi(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	public Adjuntardocs updateFechaLocalizacion(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateDocumentoHecho(DocumentoHecho documentoHecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return int
	 */
	public int updateSanDocTemp(Sandoctemp sandoctemp);

	/**
	 * Updates a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return int
	 */
	public int updateTipoDocumento(Adjuntardocs adjuntardocs);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentoHecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateDatosFirma(DocumentoHecho documentoHecho);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 */
	Adjuntardocs find(Adjuntardocs adjuntardocs);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	public Adjuntardocs findAdjuntarDocs(Adjuntardocs adjuntardocs);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	public Adjuntardocs findDocByPK(Adjuntardocs adjuntardocs);

	/**
	 * Finds a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return Adjuntardocs
	 */
	public Adjuntardocs findAdjuntarDocsByExpediente(Adjuntardocs adjuntardocs);

	/**
	 * Deletes a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return
	 */
	void remove(Adjuntardocs adjuntardocs);

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Pagination
	 * @return
	 */
	public void removeAdjuntarDocs(Adjuntardocs adjuntardocs);

	/**
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 */
	public void removeAdjuntarDocsTramite(TramiteComun tramiteComun);

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param tramiteComun
	 *            TramiteComun
	 * @return
	 */
	public void removeAllAdjuntarDocs(TramiteComun tramiteComun);

	/**
	 * Removes a single row in the Adjuntardocs table.
	 * 
	 * @param claveTablaMaestra
	 *            String
	 * @return
	 */
	public void removeAllDocsTableTemporal(String claveTablaMaestra);

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAll(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAllTipoDocInspecciones(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Counts rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Long
	 */
	Long findAllActasTramiteCount(Adjuntardocs adjuntardocs);

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAllTipoDocNuevo(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Counts rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Long
	 */
	Long findAllCount(Adjuntardocs adjuntardocs);

	/**
	 * Finds rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Adjuntardocs> findAllLike(Adjuntardocs adjuntardocs, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Adjuntardocs table using like.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Adjuntardocs adjuntardocs, Boolean startsWith);

	/**
	 * Removes a single row in the Adjuntardocs table.
	 */
	public void removeAdjuntardocsAntiguos();

	/**
	 * Finds a List of rows in the Adjuntardocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Adjuntardocs> findAllTipoDocArb(Adjuntardocs adjuntardocs, Pagination pagination);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbdoctemp
	 *            Arbdoctemp
	 * @return int
	 */
	int updateArbDocTemp(Arbdoctemp arbdoctemp);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param arbadhdoc
	 *            Arbadhdoc
	 * @return int
	 */
	int updateArbAdhDoc(Arbadhdoc arbadhdoc);

	/**
	 * Finds a single row in the AdjuntarDocs table.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return Adjuntardocs
	 * @throws Exception
	 */
	Adjuntardocs findDocAdhesiones(Adjuntardocs adjuntardocs) throws Exception;
}
