package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Alerta;

/**
 * AdjuntarDistribuidorDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarDistribuidorDaoImpl implements AdjuntarDistribuidorDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntarDistribuidor> rwMap = new RowMapper<AdjuntarDistribuidor>() {
		public AdjuntarDistribuidor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarDistribuidor(resultSet.getString("RDCODIGO"),
					resultSet.getString("RDCOAL"),
					resultSet.getString("RDCOES"),
					resultSet.getString("RDFABRICANTE"),
					resultSet.getString("RDIDINTERVINIENTE"),
					resultSet.getString("NIF"), resultSet.getString("NOMBRE"),
					resultSet.getString("ESNOCO"),
					resultSet.getString("NOMBRE_MUNICIPIO"),
					resultSet.getString("NOMBRE_PROVINCIA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor add(AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "INSERT INTO ADJUNTAR_DISTRIBUIDOR (RDCODIGO, RDCOAL, RDCOES, RDFABRICANTE, RDIDINTERVINIENTE) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, adjuntardistribuidor.getRdcodigo(),
				adjuntardistribuidor.getRdcoal(),
				adjuntardistribuidor.getRdcoes(),
				adjuntardistribuidor.getRdfabricante(),
				adjuntardistribuidor.getRdidinterviniente());
		return adjuntardistribuidor;
	}

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor update(AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "UPDATE ADJUNTAR_DISTRIBUIDOR SET RDCOAL=?, RDCOES=?, RDFABRICANTE=?, RDIDINTERVINIENTE=? WHERE RDCODIGO=?";
		this.jdbcTemplate.update(query, adjuntardistribuidor.getRdcoal(),
				adjuntardistribuidor.getRdcoes(),
				adjuntardistribuidor.getRdfabricante(),
				adjuntardistribuidor.getRdidinterviniente(),
				adjuntardistribuidor.getRdcodigo());
		return adjuntardistribuidor;
	}

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateRemoveAllFabricante(
			AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "UPDATE ADJUNTAR_DISTRIBUIDOR SET RDFABRICANTE=? WHERE RDCOAL=?";
		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_NO,
				adjuntardistribuidor.getRdcoal());
		return adjuntardistribuidor;
	}

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteDistribuidor(
			AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "UPDATE ADJUNTAR_DISTRIBUIDOR SET RDFABRICANTE=? WHERE RDCODIGO=?";
		this.jdbcTemplate.update(query, Y41bConstantes.VALOR_SI,
				adjuntardistribuidor.getRdcodigo());
		return adjuntardistribuidor;
	}

	/**
	 * Finds a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	@Transactional(readOnly = true)
	public AdjuntarDistribuidor find(AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "SELECT t1.RDCODIGO RDCODIGO, t1.RDCOAL RDCOAL, t1.RDCOES RDCOES, t1.RDFABRICANTE RDFABRICANTE, t1.RDIDINTERVINIENTE RDIDINTERVINIENTE, t2.NIF NIF, t2.NOMBRE NOMBRE,  t2.ESNOCO ESNOCO, t2.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIO, t2.NOMBRE_PROVINCIA NOMBRE_PROVINCIA FROM ADJUNTAR_DISTRIBUIDOR t1, INTERVINIENTES t2  WHERE t1.RDIDINTERVINIENTE=t2.IDINTERVINIENTE(+) AND t1.RDCODIGO = ?  ";

		List<AdjuntarDistribuidor> adjuntardistribuidorList = this.jdbcTemplate
				.query(query, this.rwMap, adjuntardistribuidor.getRdcodigo());
		return (AdjuntarDistribuidor) DataAccessUtils
				.uniqueResult(adjuntardistribuidorList);
	}

	/**
	 * Removes a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntarDistribuidor adjuntardistribuidor) {
		String query = "DELETE FROM ADJUNTAR_DISTRIBUIDOR WHERE RDCODIGO=?";
		this.jdbcTemplate.update(query, adjuntardistribuidor.getRdcodigo());
	}

	/**
	 * Finds a List of rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarDistribuidor> findAll(
			AdjuntarDistribuidor adjuntardistribuidor, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RDCODIGO RDCODIGO,t1.RDCOAL RDCOAL,t1.RDCOES RDCOES,t1.RDFABRICANTE RDFABRICANTE,t1.RDIDINTERVINIENTE RDIDINTERVINIENTE, t2.NIF NIF, t2.NOMBRE NOMBRE,  t2.ESNOCO ESNOCO, t2.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIO, t2.NOMBRE_PROVINCIA NOMBRE_PROVINCIA ");
		query.append("FROM ADJUNTAR_DISTRIBUIDOR t1, INTERVINIENTES t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntardistribuidor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDIDINTERVINIENTE=t2.IDINTERVINIENTE(+)");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarDistribuidor>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntarDistribuidor adjuntardistribuidor) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_DISTRIBUIDOR t1, INTERVINIENTES t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntardistribuidor);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDIDINTERVINIENTE=t2.IDINTERVINIENTE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarDistribuidor> findAllLike(
			AdjuntarDistribuidor adjuntardistribuidor, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.RDCODIGO RDCODIGO,t1.RDCOAL RDCOAL,t1.RDCOES RDCOES,t1.RDFABRICANTE RDFABRICANTE,t1.RDIDINTERVINIENTE RDIDINTERVINIENTE, t2.NIF NIF, t2.NOMBRE NOMBRE,  t2.ESNOCO ESNOCO, t2.NOMBRE_MUNICIPIO NOMBRE_MUNICIPIO, t2.NOMBRE_PROVINCIA NOMBRE_PROVINCIA ");
		query.append("FROM ADJUNTAR_DISTRIBUIDOR t1, INTERVINIENTES t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntardistribuidor,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDIDINTERVINIENTE=t2.IDINTERVINIENTE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarDistribuidor>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjuntarDistribuidor adjuntardistribuidor,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_DISTRIBUIDOR t1, INTERVINIENTES t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntardistribuidor,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.RDIDINTERVINIENTE=t2.IDINTERVINIENTE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarDistribuidor entity
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(AdjuntarDistribuidor adjuntardistribuidor) {

		StringBuilder where = new StringBuilder(
				AdjuntarDistribuidorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdcodigo() != null) {
			where.append(" AND t1.RDCODIGO = ?");
			params.add(adjuntardistribuidor.getRdcodigo());
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdcoal() != null) {
			where.append(" AND t1.RDCOAL = ?");
			params.add(adjuntardistribuidor.getRdcoal());
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdcoes() != null) {
			where.append(" AND t1.RDCOES = ?");
			params.add(adjuntardistribuidor.getRdcoes());
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdfabricante() != null) {
			where.append(" AND t1.RDFABRICANTE = ?");
			params.add(adjuntardistribuidor.getRdfabricante());
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdidinterviniente() != null) {
			where.append(" AND t1.RDIDINTERVINIENTE = ?");
			params.add(adjuntardistribuidor.getRdidinterviniente());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarDistribuidor entity
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjuntarDistribuidor adjuntardistribuidor, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarDistribuidorDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdcodigo() != null) {
			where.append(" AND UPPER(t1.RDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardistribuidor.getRdcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntardistribuidor.getRdcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RDCODIGO IS NOT NULL");
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdcoal() != null) {
			where.append(" AND UPPER(t1.RDCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardistribuidor.getRdcoal().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardistribuidor.getRdcoal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RDCOAL IS NOT NULL");
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdcoes() != null) {
			where.append(" AND UPPER(t1.RDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardistribuidor.getRdcoes().toUpperCase() + "%");
			} else {
				params.add("%" + adjuntardistribuidor.getRdcoes().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RDCOES IS NOT NULL");
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdfabricante() != null) {
			where.append(" AND UPPER(t1.RDFABRICANTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardistribuidor.getRdfabricante().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntardistribuidor.getRdfabricante().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.RDFABRICANTE IS NOT NULL");
		}
		if (adjuntardistribuidor != null
				&& adjuntardistribuidor.getRdidinterviniente() != null) {
			where.append(" AND UPPER(t1.RDIDINTERVINIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntardistribuidor.getRdidinterviniente()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ adjuntardistribuidor.getRdidinterviniente()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.RDIDINTERVINIENTE IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	public void removeAllAlertaDistribuidor(Alerta alerta) {
		String query = "DELETE FROM ADJUNTAR_DISTRIBUIDOR WHERE RDCOAL = ?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void addAlertaDistribuidor(Alerta alerta) {

		String query = "INSERT INTO ADJUNTAR_DISTRIBUIDOR (RDCODIGO, RDCOAL, RDCOES, RDFABRICANTE, RDIDINTERVINIENTE) SELECT RDCODIGO, RDCOAL, RDCOES, RDFABRICANTE, RDIDINTERVINIENTE FROM DISTRIBUIDOR t1 WHERE RDCOAL = ?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

}
