package com.ejie.y41b.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarDistribuidor;
import com.ejie.y41b.model.Alerta;

/**
 * AdjuntarDistribuidorDao  
 * 
 *  
 */

public interface AdjuntarDistribuidorDao {

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	AdjuntarDistribuidor add(AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	AdjuntarDistribuidor update(AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateRemoveAllFabricante(
			AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Updates a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            Pagination
	 * @return AdjuntarDistribuidor
	 */
	public AdjuntarDistribuidor updateAlertaFabricanteDistribuidor(
			AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Finds a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @return AdjuntarDistribuidor
	 */
	AdjuntarDistribuidor find(AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Deletes a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @return
	 */
	void remove(AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Finds a List of rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AdjuntarDistribuidor> findAll(
			AdjuntarDistribuidor adjuntardistribuidor, Pagination pagination);

	/**
	 * Counts rows in the AdjuntarDistribuidor table.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @return Long
	 */
	Long findAllCount(AdjuntarDistribuidor adjuntardistribuidor);

	/**
	 * Finds rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<AdjuntarDistribuidor> findAllLike(
			AdjuntarDistribuidor adjuntardistribuidor, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the AdjuntarDistribuidor table using like.
	 * 
	 * @param adjuntardistribuidor
	 *            AdjuntarDistribuidor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(AdjuntarDistribuidor adjuntardistribuidor,
			Boolean startsWith);

	/**
	 * Removes a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	public void removeAllAlertaDistribuidor(Alerta alerta);

	/**
	 * Inserts a single row in the AdjuntarDistribuidor table.
	 * 
	 * @param alerta
	 *            Alerta
	 */
	public void addAlertaDistribuidor(Alerta alerta);
}
