package com.ejie.y41b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.AdjuntarComusoivrerel;
import com.ejie.y41b.model.ComunicacionSoivre;

/**
 * AdjuntarComusoivrerelDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class AdjuntarComusoivrerelDaoImpl implements AdjuntarComusoivrerelDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<AdjuntarComusoivrerel> rwMap = new RowMapper<AdjuntarComusoivrerel>() {
		public AdjuntarComusoivrerel mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AdjuntarComusoivrerel(resultSet.getString("V7CODIGO"),
					resultSet.getString("IDCOMUNICACIONSOIVRE"),
					resultSet.getString("IDCOMUNICACIONSOIVREREL"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            Pagination
	 * @return AdjuntarComusoivrerel
	 */
	public AdjuntarComusoivrerel add(AdjuntarComusoivrerel adjuntarcomusoivrerel) {
		String query = "INSERT INTO ADJUNTAR_COMUSOIVREREL (V7CODIGO, IDCOMUNICACIONSOIVRE, IDCOMUNICACIONSOIVREREL) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, adjuntarcomusoivrerel.getV7codigo(),
				adjuntarcomusoivrerel.getIdcomunicacionsoivre(),
				adjuntarcomusoivrerel.getIdcomunicacionsoivrerel());
		return adjuntarcomusoivrerel;
	}

	/**
	 * Updates a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            Pagination
	 * @return AdjuntarComusoivrerel
	 */
	public AdjuntarComusoivrerel update(
			AdjuntarComusoivrerel adjuntarcomusoivrerel) {
		String query = "UPDATE ADJUNTAR_COMUSOIVREREL SET IDCOMUNICACIONSOIVRE=?, IDCOMUNICACIONSOIVREREL=? WHERE V7CODIGO=?";
		this.jdbcTemplate.update(query,
				adjuntarcomusoivrerel.getIdcomunicacionsoivre(),
				adjuntarcomusoivrerel.getIdcomunicacionsoivrerel(),
				adjuntarcomusoivrerel.getV7codigo());
		return adjuntarcomusoivrerel;
	}

	/**
	 * Finds a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            Pagination
	 * @return AdjuntarComusoivrerel
	 */
	@Transactional(readOnly = true)
	public AdjuntarComusoivrerel find(
			AdjuntarComusoivrerel adjuntarcomusoivrerel) {
		String query = "SELECT t1.V7CODIGO V7CODIGO, t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE, t1.IDCOMUNICACIONSOIVREREL IDCOMUNICACIONSOIVREREL FROM ADJUNTAR_COMUSOIVREREL t1  WHERE t1.V7CODIGO = ?  ";

		List<AdjuntarComusoivrerel> adjuntarcomusoivrerelList = this.jdbcTemplate
				.query(query, this.rwMap, adjuntarcomusoivrerel.getV7codigo());
		return (AdjuntarComusoivrerel) DataAccessUtils
				.uniqueResult(adjuntarcomusoivrerelList);
	}

	/**
	 * Removes a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            Pagination
	 * @return
	 */
	public void remove(AdjuntarComusoivrerel adjuntarcomusoivrerel) {
		String query = "DELETE FROM ADJUNTAR_COMUSOIVREREL WHERE V7CODIGO=?";
		this.jdbcTemplate.update(query, adjuntarcomusoivrerel.getV7codigo());
	}

	/**
	 * Removes a single row in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            Pagination
	 * @return
	 */
	public void removeComusoivrerel(AdjuntarComusoivrerel adjuntarcomusoivrerel) {
		String query = "DELETE FROM ADJUNTAR_COMUSOIVREREL WHERE IDCOMUNICACIONSOIVRE=? AND IDCOMUNICACIONSOIVREREL=?";
		this.jdbcTemplate.update(query,
				adjuntarcomusoivrerel.getIdcomunicacionsoivre(),
				adjuntarcomusoivrerel.getIdcomunicacionsoivrerel());
	}

	/**
	 * Finds a List of rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarComusoivrerel> findAll(
			AdjuntarComusoivrerel adjuntarcomusoivrerel, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.V7CODIGO V7CODIGO,t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE,t1.IDCOMUNICACIONSOIVREREL IDCOMUNICACIONSOIVREREL ");
		query.append("FROM ADJUNTAR_COMUSOIVREREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcomusoivrerel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarComusoivrerel>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarComusoivrerel table.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            AdjuntarComusoivrerel
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AdjuntarComusoivrerel adjuntarcomusoivrerel) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_COMUSOIVREREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(adjuntarcomusoivrerel);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AdjuntarComusoivrerel table using like.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AdjuntarComusoivrerel> findAllLike(
			AdjuntarComusoivrerel adjuntarcomusoivrerel, Pagination pagination,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.V7CODIGO V7CODIGO,t1.IDCOMUNICACIONSOIVRE IDCOMUNICACIONSOIVRE,t1.IDCOMUNICACIONSOIVREREL IDCOMUNICACIONSOIVREREL ");
		query.append("FROM ADJUNTAR_COMUSOIVREREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntarcomusoivrerel,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<AdjuntarComusoivrerel>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AdjuntarComusoivrerel table using like.
	 * 
	 * @param adjuntarcomusoivrerel
	 *            AdjuntarComusoivrerel
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(AdjuntarComusoivrerel adjuntarcomusoivrerel,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM ADJUNTAR_COMUSOIVREREL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(adjuntarcomusoivrerel,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarComusoivrerel entity
	 * 
	 * @param adjuntarcomusoivrerel
	 *            AdjuntarComusoivrerel Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			AdjuntarComusoivrerel adjuntarcomusoivrerel) {

		StringBuilder where = new StringBuilder(
				AdjuntarComusoivrerelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcomusoivrerel != null
				&& adjuntarcomusoivrerel.getV7codigo() != null) {
			where.append(" AND t1.V7CODIGO = ?");
			params.add(adjuntarcomusoivrerel.getV7codigo());
		}
		if (adjuntarcomusoivrerel != null
				&& adjuntarcomusoivrerel.getIdcomunicacionsoivre() != null) {
			where.append(" AND t1.IDCOMUNICACIONSOIVRE = ?");
			params.add(adjuntarcomusoivrerel.getIdcomunicacionsoivre());
		}
		if (adjuntarcomusoivrerel != null
				&& adjuntarcomusoivrerel.getIdcomunicacionsoivrerel() != null) {
			where.append(" AND t1.IDCOMUNICACIONSOIVREREL = ?");
			params.add(adjuntarcomusoivrerel.getIdcomunicacionsoivrerel());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the AdjuntarComusoivrerel entity
	 * 
	 * @param adjuntarcomusoivrerel
	 *            AdjuntarComusoivrerel Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			AdjuntarComusoivrerel adjuntarcomusoivrerel, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				AdjuntarComusoivrerelDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (adjuntarcomusoivrerel != null
				&& adjuntarcomusoivrerel.getV7codigo() != null) {
			where.append(" AND UPPER(t1.V7CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcomusoivrerel.getV7codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ adjuntarcomusoivrerel.getV7codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.V7CODIGO IS NOT NULL");
		}
		if (adjuntarcomusoivrerel != null
				&& adjuntarcomusoivrerel.getIdcomunicacionsoivre() != null) {
			where.append(" AND UPPER(t1.IDCOMUNICACIONSOIVRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcomusoivrerel.getIdcomunicacionsoivre()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ adjuntarcomusoivrerel.getIdcomunicacionsoivre()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.IDCOMUNICACIONSOIVRE IS NOT NULL");
		}
		if (adjuntarcomusoivrerel != null
				&& adjuntarcomusoivrerel.getIdcomunicacionsoivrerel() != null) {
			where.append(" AND UPPER(t1.IDCOMUNICACIONSOIVREREL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(adjuntarcomusoivrerel.getIdcomunicacionsoivrerel()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ adjuntarcomusoivrerel.getIdcomunicacionsoivrerel()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.IDCOMUNICACIONSOIVREREL IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Removes a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return
	 */
	public void removeAllComuSoivreRel(ComunicacionSoivre comunicacionSoivre) {
		String query = "DELETE FROM ADJUNTAR_COMUSOIVREREL WHERE IDCOMUNICACIONSOIVRE = ?";
		this.jdbcTemplate.update(query,
				comunicacionSoivre.getIdcomunicacionsoivre());
	}

	/**
	 * Inserts a single row in the AdjuntarAlertaprogra table.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 */
	public void addComuSoivreRel(ComunicacionSoivre comunicacionSoivre) {

		String query = "INSERT INTO ADJUNTAR_COMUSOIVREREL (V7CODIGO, IDCOMUNICACIONSOIVRE, IDCOMUNICACIONSOIVREREL) SELECT V7CODIGO, IDCOMUNICACIONSOIVRE, IDCOMUNICACIONSOIVREREL FROM COMUNICACION_SOIVRE_REL t1 WHERE IDCOMUNICACIONSOIVRE = ?";
		this.jdbcTemplate.update(query,
				comunicacionSoivre.getIdcomunicacionsoivre());
	}

}
